//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to declare a method within a class with
// one type of visibility, and then to subsequently re-declare that
// same method within the same class with more parameter defaults,
// but with a different type of visibility.
//
// Test all 6 combinations of {private, protected, public}.

class c1 {
	int member;
private:
	int method (int i);
protected:
	int method (int i = 0);	// ERROR - method is already private
};

class c2 {
	int member;
private:
	int method (int i);
public:
	int method (int i = 0);	// ERROR - method is already private
};

class c3 {
	int member;
protected:
	int method (int i);
private:
	int method (int i = 0);	// ERROR - method is already protected
};

class c4 {
	int member;
protected:
	int method (int i);
public:
	int method (int i = 0);	// ERROR - method is already protected
};

class c5 {
	int member;
public:
	int method (int i);
protected:
	int method (int i = 0);	// ERROR - method is already public
};

class c6 {
	int member;
public:
	int method (int i);
private:
	int method (int i = 0);	// ERROR - method is already public
};
