//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a class type has a protected default constructor, no
// object of the type may be constructed using that constructor, other
// than in the scope of the given constructor.
//
// This test causes the G++ 1.34.0/sun3 compiler to abort

class base {
public:
	int base_member;
protected:
	base();
private:
	void private_base_member_1 ()
	{
		base local_base_object;	// OK
		base *base_ptr;

		base_ptr =  new base;	// OK
		local_base_object.base_member = 0;
		base_ptr->base_member = 0;
	}

	void private_base_member_2 ();
protected:
	void protected_base_member_1 ()
	{
		base local_base_object;	// OK
		base *base_ptr;

		base_ptr =  new base;	// OK
		local_base_object.base_member = 0;
		base_ptr->base_member = 0;
	}

	void protected_base_member_2 ();
public:
	void public_base_member_1 ()
	{
		base local_base_object;	// OK
		base *base_ptr;

		base_ptr =  new base;	// OK
		local_base_object.base_member = 0;
		base_ptr->base_member = 0;
	}

	void public_base_member_2 ();
};

class derived : public base {
	int derived_member;
private:
	void private_derived_member_1 ()
	{
		base local_base_object;	// OK
		base *base_ptr;

		base_ptr =  new base;	// OK
		local_base_object.base_member = 0;
		base_ptr->base_member = 0;
	}

	void private_derived_member_2 ();
protected:
	void protected_derived_member_1 ()
	{
		base local_base_object;	// OK
		base *base_ptr;

		base_ptr =  new base;	// OK
		local_base_object.base_member = 0;
		base_ptr->base_member = 0;
	}

	void protected_derived_member_2 ();
public:
	void public_derived_member_1 ()
	{
		base local_base_object;	// OK
		base *base_ptr;

		base_ptr =  new base;	// OK
		local_base_object.base_member = 0;
		base_ptr->base_member = 0;
	}

	void public_derived_member_2 ();
};

base static_base_object_1;		// ERROR - aborts 1.34.0
static base static_base_object_2;	// ERROR

int test ()
{
	base local_base_object;		// ERROR
	base *base_ptr;

	base_ptr = new base;		// ERROR
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
	return 0;
}

void base::private_base_member_2 ()
{
	base local_base_object;		// OK
	base *base_ptr;

	base_ptr = new base;		// OK
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
}

void base::protected_base_member_2 ()
{
	base local_base_object;		// OK
	base *base_ptr;

	base_ptr = new base;		// OK
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
}

void base::public_base_member_2 ()
{
	base local_base_object;		// OK
	base *base_ptr;

	base_ptr = new base;		// OK
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
}

void derived::private_derived_member_2 ()
{
	base local_base_object;		// OK
	base *base_ptr;

	base_ptr = new base;		// OK
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
}

void derived::protected_derived_member_2 ()
{
	base local_base_object;		// OK
	base *base_ptr;

	base_ptr = new base;		// OK
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
}

void derived::public_derived_member_2 ()
{
	base local_base_object;		// OK
	base *base_ptr;

	base_ptr = new base;		// OK
	local_base_object.base_member = 0;
	base_ptr->base_member = 0;
}
