//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is legal to overload a declared function
// with another function which has the same name and mostly
// the same parameter-type-profile, with the only difference
// being that one of the overloadings takes an enum type formal
// parameter in one parameter position, while another one of the
// overloadings takes a different enum type (or an int type)
// formal parameter for that same formal parameter position.

enum color {
	red,
	orange,
	yellow
};

enum fruit {
	apple,
	banana
};

overload function;

void function (int i) { i = i; }

void function (color c) { c = c; }

void function (fruit f) { f = f; }

int main ()
{
	function (apple);
	function (red);
	function (99);
	return 0;
}
