// 990412 bkoz

// Copyright (C) 1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include <istream>
#include <sstream>
#ifdef DEBUG_ASSERT
  #include <assert.h>
#endif

string str_01;
string str_02("true false 0 1 0 -1 -2 -3 -4 -5 5 4 3 2 1 11.11 22.22");
string str_03("-19,999,999 777,777 -234,234 233 -234 33 1 66,300.25 .315 1.5");
istringstream iss_01;
istringstream iss_02(str_02);
istringstream iss_03(str_03);
 
bool test01() {

  bool test = true;
  // Integral Types:
  bool 			b1  = false;
  bool 			b2  = false;
  short 		s1  = 0;
  int	 		i1  = 0;
  long	 		l1  = 0;
  unsigned short 	us1 = 0;
  unsigned int 		ui1 = 0;
  unsigned long 	ul1 = 0;

  // Floating-point Types:
  float 		f1  = 0;
  double 		d1  = 0;
  long double 		ld1 = 0;

  // process alphanumeric versions of bool values
  ios_base::fmtflags fmt = iss_02.flags();
  bool testfmt = fmt & ios_base::boolalpha;
  iss_02.setf(ios_base::boolalpha);
  fmt = iss_02.flags();
  testfmt = fmt & ios_base::boolalpha;
  iss_02 >> b1;
  test &= b1 == 1;
  iss_02 >> b1;
  test &= b1 == 0;

  // process numeric versions of of bool values
  iss_02.unsetf(ios_base::boolalpha);
  fmt = iss_02.flags();
  testfmt = fmt & ios_base::boolalpha;
  iss_02 >> b1;
  test &= b1 == 0;
  iss_02 >> b1;
  test &= b1 == 1;

  // iss_03 == "-19,999,999 777,777 -234,234 233 -234 33 1 66,300.25 .315 1.5"
  iss_03 >> l1;
  test &= l1 == -19999999;
  iss_03 >> ul1;
  test &= ul1 == 777777;
  iss_03 >> i1;
  test &= i1 == -234234;
  iss_03 >> ui1;
  test &= ui1 == 233;
  iss_03 >> s1;
  test &= s1 == -234;
  iss_03 >> us1;
  test &= us1 == 33;
  iss_03 >> b1;
  test &= b1 == 1;
  iss_03 >> ld1;
  test &= ld1 == 66300.25;
  iss_03 >> d1;
  test &= d1 == .315;
  iss_03 >> f1;
  test &= f1 == 1.5;


#ifdef DEBUG_ASSERT
  assert(test);
#endif
 
  return test;
}

int main()
{
  test01();
  return 0;
}





// paul miller was right on with riddim warfare!
