// Locale support -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

// Warning: this file is not meant for user inclusion.  Use <locale>.

#ifndef _CPP_BITS_LOCFACETS_TCC
#define _CPP_BITS_LOCFACETS_TCC 1

#include <bits/std_vector.h>


// __match_parallel
// matches input __s against a set of __ntargs strings in __targets,
// placing in __matches a vector of indices into __targets which
// match, and in __remain the number of such matches. If it hits
// end of sequence before it minimizes the set, sets __eof.
// Empty strings are never matched.

namespace std
{

#if defined(_G_NO_TEMPLATE_EXPORT) && !defined(export)
#define export
#endif

template <class _InIter, class _CharT>
  _InIter __match_parallel(_InIter __s, _InIter __end,
			  int __ntargs, const basic_string<_CharT>* __targets,
			  int* __matches, int& __remain, bool& __eof)
{
  __eof = false;
  for (int __ti = 0; __ti < __ntargs; ++__ti) __matches[__ti] = __ti;
  __remain = __ntargs;
  size_t __pos = 0;
  do {
    {
      int __ti = 0;
      for (;__ti < __remain &&
            __pos == __targets[__matches[__ti]].size(); ++__ti)
        { }
      if (__ti == __remain) {
        if (__pos == 0) __remain = 0;
        return __s;
      }
    }
    if (__s == __end) { __eof = true; }
    bool __matched = false;
    for (int __ti = 0; __ti < __remain; ) {
      const basic_string<_CharT>& __target = __targets[__matches[__ti]];
      if (__pos < __target.size()) {
	if (__eof || __target[__pos] != *__s)
	  { __matches[__ti] = __matches[--__remain]; continue; }
	__matched = true;
      }
      ++__ti;
    }
    if (__matched) { ++__s; ++__pos; }
    for (int __ti = 0; __ti < __remain;) {
      if (__pos > __targets[__matches[__ti]].size())
	{ __matches[__ti] = __matches[--__remain]; continue; }
      ++__ti;
    }
  } while (__remain);
  return __s;
}

  export template<typename _CharT>
    _Ctype_nois<_CharT>::~_Ctype_nois () {}

  export template<typename _CharT>
    _Ctype<_CharT>::~_Ctype () {}

# if 0  /* XXX delete me, eventually */
  /* probably since these are "=0" we don't need to implement them. */
  template<typename _CharT>
    bool
      _Ctype::do_is (mask __m, char_type __c) const =0

  template<typename _CharT>
    const _CharT*
      _Ctype::do_is (const char_type* __low,
		     const char_type* __high, mask* __vec) const =0

  template<typename _CharT>
    const _CharT*
      _Ctype::do_scan_is (mask __m, const char_type* __low,
			  const char_type* __high) const =0

  template<typename _CharT>
    const _CharT*
      _Ctype::do_scan_not (mask __m, const char_type* __low,
			   const char_type* __high) const =0

  template<typename _CharT>
    _CharT
      _Ctype::do_toupper (char_type) const =0

  template<typename _CharT>
    const _CharT*
      _Ctype::do_toupper (char_type* __low, const char_type* __high) const =0

  template<typename _CharT>
    _CharT
      _Ctype::do_tolower (char_type) const =0

  template<typename _CharT>
    const _CharT*
      _Ctype::do_tolower (char_type* __low, const char_type* __high) const =0

  template<typename _CharT>
    _CharT
      _Ctype::do_widen (char) const =0

  template<typename _CharT>
    const char*
      _Ctype::do_widen (const char* __low, const char* __high,
		char_type* __dest) const =0

  template<typename _CharT>
    char
      _Ctype::do_narrow (char_type, char __dfault) const =0

  template<typename _CharT>
    const _CharT*
      _Ctype::do_narrow (const char_type* __low, const char_type* __high,
			 char __dfault, char* __dest) const =0
#endif

  ///////////
  export template<typename _CharT>
    locale::id ctype<_CharT>::id;

  export template<typename _CharT>
    ctype<_CharT>::ctype (size_t __refs) : _Ctype<_CharT> (__refs) {}

  export template<typename _CharT>
    ctype<_CharT>::~ctype () {}

  ////////////

  export template<typename _CharT>
    ctype_byname<_CharT>::ctype_byname (const char*, size_t __refs)
  : ctype<_CharT>(__refs)
  {
  }


  export template<typename _CharT>
    ctype_byname<_CharT>::~ctype_byname () { }


  export template<typename _InternT, typename _ExternT, typename _StateT>
    _Codecvt<_InternT,_ExternT,_StateT>::_Codecvt (size_t __refs)
  : locale::facet (__refs)
  {
  }


  export template<typename _InternT, typename _ExternT, typename _StateT>
    _Codecvt<_InternT,_ExternT,_StateT>::~_Codecvt () { }


#if 0 /* these are pure virtual, maybe we don't need to implement them. */
  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt_base::result
    _Codecvt<_InternT,_ExternT,_StateT>::do_out (state_type& __state,
	      const intern_type* __from, const intern_type* __from_end,
	      const intern_type*& __from_next,
	      extern_type* __to, extern_type* __to_limit,
	      extern_type*& __to_next) const =0

  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt_base::result
    _Codecvt<_InternT,_ExternT,_StateT>::do_unshift (state_type& __state,
		  extern_type* __to, extern_type* __to_limit,
		  extern_type*& __to_next) const =0

  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt_base::result
    _Codecvt<_InternT,_ExternT,_StateT>::do_in (state_type& __state,
	     const extern_type* __from, const extern_type* __from_end,
	     const extern_type*& __from_next,
	     intern_type* __to, intern_type* __to_limit,
	     intern_type*& __to_next) const =0

  export template<typename _InternT, typename _ExternT, typename _StateT>
    int
    _Codecvt<_InternT,_ExternT,_StateT>::do_encoding () const throw () =0

  export template<typename _InternT, typename _ExternT, typename _StateT>
    bool
    _Codecvt<_InternT,_ExternT,_StateT>::do_always_noconv () const throw () =0

  export template<typename _InternT, typename _ExternT, typename _StateT>
    int
    _Codecvt<_InternT,_ExternT,_StateT>::do_length (const state_type&,
						    const extern_type* __from,
						    const extern_type* __end,
						    size_t __max) const =0

  export template<typename _InternT, typename _ExternT, typename _StateT>
    int
    _Codecvt<_InternT,_ExternT,_StateT>::do_max_length () const throw () =0

#endif /* pure virtuals */

  ///////////

  export template<typename _InternT, typename _ExternT, typename _StateT>
    locale::id  codecvt<_InternT,_ExternT,_StateT>::id;

  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt<_InternT,_ExternT,_StateT>::codecvt (size_t __refs)
  : _Codecvt<_InternT,_ExternT,_StateT> (__refs)
  {
  }


  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt<_InternT,_ExternT,_StateT>::~codecvt () { }


  ///////////

  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt_byname<_InternT,_ExternT,_StateT>::codecvt_byname (const char*,
							       size_t __refs)
  : codecvt<_InternT,_ExternT,_StateT> (__refs)
  {
  }


  export template<typename _InternT, typename _ExternT, typename _StateT>
    codecvt_byname<_InternT,_ExternT,_StateT>::~codecvt_byname () { }

  //////////

  template<typename _CharT>
    int _Format_cache<_CharT>::_S_pword_ix;

  // XXX 990319 bkoz egcs static data bug??? Clarifying. . .
#if 0
  template<typename _CharT>
    const char _Format_cache<_CharT>::
    _S_numeric_literals[] = "-+xX0123456789abcdef0123456789ABCDEF";
#else
  template<>
    const char _Format_cache<char>::
    _S_numeric_literals[] = "-+xX0123456789abcdef0123456789ABCDEF";

#ifdef _G_USE_WCHAR_T
  template<>
    const char _Format_cache<wchar_t>::
    _S_numeric_literals[] = "-+xX0123456789abcdef0123456789ABCDEF";
#endif
#endif

  template<typename _CharT>
    const int _Format_cache<_CharT>::
    _S_literal_count = sizeof(_S_numeric_literals) - 1;

  template<typename _CharT>
    _Format_cache<_CharT>::_Format_cache()
    : _M_valid(true), _M_use_grouping(false)
    {
      try {
	_M_literals = new _CharT[_S_literal_count];
      }
      catch(...){
	delete _M_literals;
	throw;
      }
    }

   template<>
     _Format_cache<char>::_Format_cache()
     : _M_valid(true), _M_decsep('.'), _M_grsep(','), _M_use_grouping(false)
     {
      try {
	_M_literals = new char[_S_literal_count];
      }
      catch(...){
	delete _M_literals;
	throw;
      }
       memcpy(_M_literals, _S_numeric_literals, _S_literal_count);
       _M_boolnames[0] = string("false");
       _M_boolnames[1] = string("true");
     }
 
   template<>
     _Format_cache<wchar_t>::_Format_cache()
     : _M_valid(true), _M_decsep(L'.'), _M_grsep(L','), _M_use_grouping(false)
     {
      try {
	_M_literals = new wchar_t[_S_literal_count];
      }
      catch(...){
	delete _M_literals;
	throw;
      }
      static char const* __lits = _S_numeric_literals;
      for (int i = 0; i < _S_literal_count; ++i)
	 _M_literals[i] = wchar_t(__lits[i]);
       _M_boolnames[0] = wstring(L"false");
       _M_boolnames[1] = wstring(L"true");
     }
  
   template<typename _CharT>
    _Format_cache<_CharT>::~_Format_cache () throw()
    { delete _M_literals; }

   template<typename _CharT>
    void
    _Format_cache<_CharT>::_M_populate(ios_base& __io)
    {
      locale __loc = __io.getloc ();
      numpunct<_CharT> const& __np = use_facet<numpunct<_CharT> >(__loc);
      _M_boolnames[0] = __np.falsename();
      _M_boolnames[1] = __np.truename();

      ctype<_CharT> const& __ct = use_facet< ctype<_CharT> >(__loc);
      __ct.widen(_S_numeric_literals, 
		 _S_numeric_literals + _S_literal_count, _M_literals);
      _M_grsep = __np.thousands_sep ();
      _M_decsep = __np.decimal_point ();
      _M_grouping = __np.grouping ();
      _M_use_grouping = _M_grouping.size() != 0 && _M_grouping.data()[0] != 0;
      _M_valid = true;
    }

   // This function is always called via a pointer installed in
   // an ios_base by ios_base::register_callback.
   template<typename _CharT>
    void
    _Format_cache<_CharT>::_S_callback(ios_base::event __ev,
				       ios_base& __ios, int __ix) throw()
     {
       void*& __p = __ios.pword(__ix);
       switch (__ev)
	 {
	 case ios_base::erase_event:
	   delete static_cast<_Format_cache<_CharT>*> (__p); __p = 0;   
	   break;
	 case ios_base::copyfmt_event:
	   // if just stored zero, the callback would get registered again
	   try { 
	     __p = new _Format_cache<_CharT>; 
	   } 
	   catch(...) { 
	   }      
	   break;
	 case ios_base::imbue_event:
	   static_cast<_Format_cache<_CharT>*>(__p)->_M_valid = false; 
	   break;
	 }
     }

   template<typename _CharT>
     _Format_cache<_CharT>*
     _Format_cache<_CharT>::_S_get(ios_base& __ios)
     {
       if (!_S_pword_ix) _S_pword_ix = ios_base::xalloc();  // XXX MT
       void*& __p = __ios.pword (_S_pword_ix);

       // XXX what if pword fails? must check failbit, throw.
       
       if (__p == 0)  // XXX MT?  maybe sentry takes care of it
	 {
	   auto_ptr<_Format_cache<_CharT> > __ap(new _Format_cache<_CharT>);
	   __ios.register_callback (&_Format_cache<_CharT>::_S_callback,
				    _S_pword_ix);
	   __p = __ap.release();
	 }
       _Format_cache<_CharT>* __ncp = static_cast<_Format_cache<_CharT>*>(__p);
       if (!__ncp->_M_valid) __ncp->_M_populate(__ios);
       return __ncp;
     }

  //////////
  export template <typename _CharT, typename _InIter>
    _Numeric_get<_CharT,_InIter>::_Numeric_get ()
  {
  }

  export template <typename _CharT, typename _InIter>
    _Numeric_get<_CharT,_InIter>::~_Numeric_get () { }

  ////////////
  export template <typename _CharT, typename _InIter>
    locale::id num_get<_CharT,_InIter>::id;


  export template <typename _CharT, typename _InIter>
    num_get<_CharT,_InIter>::num_get (size_t __refs)
  : locale::facet(__refs)
  {
  }

  export template <typename _CharT, typename _InIter>
    num_get<_CharT,_InIter>::~num_get () { }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     bool& __v) const
  {
    if (__io.flags () & __io.boolalpha)
      {
	_Format_cache<_CharT>* __fmt = _Format_cache<_CharT>::_S_get(__io);

        bool __at_eof = false;
	int __remain = 0;
	int __matches[2];
	_InIter __out = __match_parallel(__s, __end, 2, __fmt->_M_boolnames,
					 __matches, __remain, __at_eof);
	__err = ios_base::iostate(0);
	if (__at_eof)      __err |= __io.eofbit;
	if (__remain == 0) __err |= __io.failbit;
 	else __v = (__remain == 1) ? __matches[0] == 1 : true;
	return __out;
      }
    unsigned long __l = 0;
    _InIter __out = this->get(__s, __end, __io, __err, __l);
    if ((__err & __io.failbit) == 0)
    if (__l > 1) __err |= __io.failbit; else __v = __l;
    return __out;
  }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     long& __v) const
  {
    return __s;  // XXX not done
  }

#if 0  // XXX need appropriate macro guard for this.
  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     long long& __v) const
  {
    return __s;  // XXX not done
  }
#endif


  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     unsigned short& __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& err,
					     unsigned int& __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     unsigned long& __v) const
  {
    return __s;  // XXX not done
  }

#if 0
  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     unsigned long long& __v) const
  {
    return __s;  // XXX not done
  }
#endif

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     float& __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     double& __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     long double& __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _InIter>
    _InIter num_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					     ios_base& __io, _Ios_Iostate& __err,
					     void*& __v) const
  {
    return __s;  // XXX not done
  }


  //////////

  export template <typename _CharT, typename _OutIter>
    _Numeric_put<_CharT,_OutIter>::_Numeric_put ()
  {
  }

  export template <typename _CharT, typename _OutIter>
    _Numeric_put<_CharT,_OutIter>::~_Numeric_put () { }

  ////////////

  export template <typename _CharT, typename _OutIter>
    locale::id num_put<_CharT,_OutIter>::id;

  export template <typename _CharT, typename _OutIter>
    num_put<_CharT,_OutIter>::num_put (size_t __refs)
    : locale::facet (__refs)
  {
  }


  export template <typename _CharT, typename _OutIter>
    num_put<_CharT,_OutIter>::~num_put () { }



  /////////////

  // _S_fill is specialized for ostreambuf_iterator, random access iterator.

  template <typename _CharT, typename _OutIter>
    inline _OutIter
    _S_fill(_OutIter __s, _CharT __fill, int __padding);

#if 0 // XXX not optimal
  // generic version is better for an optimal ostreambuf_iterator,
  // which we don't have yet.  But this can be improved too.
  export template <typename _CharT, typename _Traits>
    ostreambuf_iterator<_CharT,_Traits>
    _S_fill(ostreambuf_iterator<_CharT,_Traits> __s,
            _CharT __fill, int __padding)
  {
    // XXX  could do a lot better by breaking into the streambuf.
    basic_streambuf<_CharT,_Traits>* __buf = __s._M_sbuf;
    typename _Traits::int_type __ifill = _Traits::to_int_type(__fill);
    while (__padding--) __buf->sputc(__ifill);
  }
#endif

  export template <typename _CharT, typename _RaIter>
    _RaIter
    _S_fill(_RaIter __s, _CharT __fill, int __padding,
            random_access_iterator_tag)
  {
    fill_n(__s, __fill);
    return __s + __padding;
  }

  export template <typename _CharT, typename _OutIter, typename _Tag>
    _OutIter
    _S_fill(_OutIter __s, _CharT __fill, int __padding, _Tag)
  {
    while (--__padding >= 0) { *__s = __fill; ++__s; }
    return __s;
  }

  template <typename _CharT, typename _OutIter>
    inline _OutIter
    _S_fill(_OutIter __s, _CharT __fill, int __padding)
  {
    return _S_fill(__s,__fill,__padding,
                   iterator_traits<_OutIter>::iterator_category());
  }


  export template <typename _CharT, typename _OutIter>
    _OutIter
    _S_pad_numeric(_OutIter __s, ios_base::fmtflags __flags,
                   _CharT __fill, int __width, _CharT const* __first,
                   _CharT const* __middle, _CharT const* __last)
  {
    int __padding = __width - (__last - __first);
    if (__padding < 0) __padding = 0;
    ios_base::fmtflags __adjfield = __flags & ios_base::adjustfield;
    // this bit is pretty complicated because output iterators don't assign.
    _OutIter __s2 = (__first == __middle) ? __s : copy(__first,__middle,
       (__padding == 0 || __adjfield == ios_base::left ||
                          __adjfield == ios_base::internal) ? __s :
          (_S_fill(__s,__fill, __padding), (__padding = 0), __s));

    if (__padding && __adjfield != ios_base::left) {
      _S_fill(__s2,__fill, __padding);
      __padding = 0;
    }
    _OutIter __s3 = copy(__middle,__last, __s2);
    if (__padding)
      _S_fill(__s3,__fill, __padding);
    return __s3;
  }

  ////////////

  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       bool __v) const
  {
    _Format_cache<_CharT> const* __fmt = _Format_cache<_CharT>::_S_get(__io);
    ios_base::fmtflags __flags = __io.flags();
    _CharT const* __first = __fmt->_M_literals + __fmt->_S_digits + __v;
    _CharT const* __last = __first+1;
    if (__flags & __io.boolalpha) {
      __first = __fmt->_M_boolnames[__v].data();
      __last = __first + __fmt->_M_boolnames[__v].size();
    }
    if (__io.width())
      return _S_pad_numeric(__s, __flags, __fill, __io.width(0),
                            __first, __first, __last);
    else
      return copy(__first, __last, __s);
  }

  //////////

  // _S_group_digits inserts "group separator" characters into an array 
  // of characters.  It's recursive, one iteration per group.  It moves
  // the characters in the buffer this way: "xxxx12345" -> "12,345xxx".
  // Call this only with __grouping != __grend.

  export template <typename _CharT>
    _CharT*
    _S_group_digits(_CharT* __s, _CharT __grsep, 
                    char const* __grouping, char const* __grend,
                    _CharT const* __first, _CharT const* __last)
  {
    if (__last - __first > *__grouping) {
      __s = _S_group_digits(__s,  __grsep, 
              (__grouping + 1 == __grend ? __grouping : __grouping + 1),
	      __grend, __first, __last - *__grouping);
      __first = __last - *__grouping;
      *__s++ = __grsep;
    }
    do {
      *__s++ = *__first++;
    } while (__first != __last);
    return __s;
  }

  export template <typename _CharT, typename _OutIter>
    _OutIter
    _S_format_long(_OutIter __s, ios_base& __io, _CharT __fill, bool __neg,
		   unsigned long __v)
  {
    static const int _S_room =   // leave room for "-0x" and commas
      numeric_limits<unsigned long>::digits10 * 2 + 4;
    _CharT __digits[_S_room];
    _CharT* __front = __digits + _S_room;
    ios_base::fmtflags __flags = __io.flags();
    const _Format_cache<_CharT>* __fmt = _Format_cache<_CharT>::_S_get(__io);
    _CharT const* __table = __fmt->_M_literals + __fmt->_S_digits;

    ios_base::fmtflags __basefield = (__flags & __io.basefield);
    _CharT* __sign_end = __front;
    if (__basefield == __io.hex) {
      if (__flags & ios_base::uppercase) __table += 16;  // use ABCDEF
      do {
        *--__front = __table[__v & 15];
      } while ((__v >>= 4) != 0);
      __sign_end = __front;
      if (__flags & __io.showbase) {
        *--__front = __fmt->_M_literals[__fmt->_S_ecks +
                       ((__flags & ios_base::uppercase) ? 1 : 0)];
        *--__front = __table[0];
      }
    } else if (__basefield == __io.oct) {
      do {
        *--__front = __table[__v & 7];
      } while ((__v >>= 3) != 0);
      if (__flags & __io.showbase && *__front != __table[0])
        *--__front = __table[0];
      __sign_end = __front;
    } else {
      // note: this is _lots_ faster than using ldiv.
      do { 
        *--__front = __table[__v % 10];
      } while ((__v /= 10) != 0);
      __sign_end = __front;
    }
    if (__neg || (__flags & __io.showpos))
      *--__front = __fmt->_M_literals[__fmt->_S_plus - __neg];

    if (!__fmt->_M_use_grouping && !__io.width())
      return copy(__front, __digits+_S_room, __s);  // XXX should specialize!

    if (!__fmt->_M_use_grouping)
      return _S_pad_numeric(__s, __flags, __fill, __io.width(0),
                            __front, __sign_end, __digits+_S_room);

    _CharT* __p = __digits;
    while (__front < __sign_end)
      *__p++ = *__front++;
    const char* __gr = __fmt->_M_grouping.data();
    __front = _S_group_digits(__p, __fmt->_M_grsep, __gr, 
        __gr + __fmt->_M_grouping.size(), __sign_end, __digits+_S_room);
    return _S_pad_numeric(__s, __flags, __fill, __io.width(0),
                          __digits, __p, __front);
  }

  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       long __v) const
  {
    unsigned long __uv = __v;
    bool __neg = false;
    if (__v < 0) { __neg = true; __uv = -__uv; }
    return _S_format_long(__s, __io, __fill, __neg, __uv);
  }

#ifdef _G_USE_LONG_LONG 
  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       long long __v) const
  {
    unsigned long long __uv = __v;
    bool __neg = false;
    if (__v < 0) { __neg = true; __uv = -__uv; }
    return _S_format_long(__s, __io, __fill, __neg, __uv);
  }
#endif

  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       unsigned long __v) const
  {
    return _S_format_long(__s, __io, __fill, false, __v);
  }

  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       double __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       long double __v) const
  {
    return __s;  // XXX not done
  }

  export template <typename _CharT, typename _OutIter>
    _OutIter num_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
					       char_type __fill,
					       const void* __v) const
  {
    ios_base::fmtflags __oldflags = __io.flags(__io.flags() &
       ~(__io.showpos|__io.basefield|__io.uppercase|__io.internal) |
       (__io.hex|__io.showbase));
    try {
      _OutIter __s2 = _S_format_long(__s, __io, __fill, false, 
         reinterpret_cast<unsigned long>(__v));
      __io.flags(__oldflags);
      return __s2;
    } catch (...) {
      __io.flags(__oldflags); 
      throw;
    }
  }


  //////////

  export template <typename _CharT>
    _Punct<_CharT>::_Punct (size_t __refs)
  : locale::facet (__refs)
  {
  }

  export template <typename _CharT>
    _Punct<_CharT>::~_Punct () { }

  export template <typename _CharT>
    _CharT    _Punct<_CharT>::do_decimal_point () const
  {
    return _M_decimal_point;
  }

  export template <typename _CharT>
    _CharT    _Punct<_CharT>::do_thousands_sep () const
  {
    return _M_thousands_sep;
  }

  export template <typename _CharT>
    string       _Punct<_CharT>::do_grouping ()      const
  {
    return _M_grouping;
  }

  // for use at derived-class construction time only:
  export template <typename _CharT>
    void _Punct<_CharT>::_M_init (char_type __d, char_type __t,
                                  const string& __g)
  {
    _M_decimal_point = __d;
    _M_thousands_sep = __t;
    _M_grouping = __g;
  }

  ////////
  export template <typename _CharT>
    _Numpunct<_CharT>::_Numpunct (size_t __refs)
  : _Punct<_CharT> (__refs)
  {
  }

  export template <typename _CharT>
    _Numpunct<_CharT>::~_Numpunct () { }

  export template <typename _CharT>
    basic_string<_CharT> _Numpunct<_CharT>::do_truename ()   const
  {
    return _M_truename;
  }

  export template <typename _CharT>
    basic_string<_CharT> _Numpunct<_CharT>::do_falsename ()  const
  {
    return _M_falsename;
  }


  export template <typename _CharT>
    void _Numpunct<_CharT>::_M_init_boolnames (const string_type& __t,
					       const string_type& __f)
  {
    _M_truename = __t;
    _M_falsename = __f;
  }

  ///////////
  export template <typename _CharT>
    locale::id numpunct<_CharT>::id;

  export template <typename _CharT>
    numpunct<_CharT>::numpunct (size_t __refs)
  : _Numpunct<_CharT> (__refs)
  {
  }

  export template <typename _CharT>
    numpunct<_CharT>::~numpunct () { }

  //////
  export template <typename _CharT>
    numpunct_byname<_CharT>::numpunct_byname (const char*, size_t __refs)
  : numpunct<_CharT> (__refs)
  {
  }

  export template <typename _CharT>
    numpunct_byname<_CharT>::~numpunct_byname () { }

  //////
  export template <typename _CharT>
    _Collate<_CharT>::_Collate (size_t __refs)
  : locale::facet (__refs)
  {
  }

  export template <typename _CharT>
    _Collate<_CharT>::~_Collate () { }


# if 0   /* XXX delete me, eventually */
  /* probably we don't need to implement these pure virtuals. */
  template <typename _CharT>
    int  _Collate<_CharT>::do_compare (const _CharT* __lo1,
				       const _CharT* __hi1,
			    const _CharT* __lo2, const _CharT* __hi2) const =0
  template <typename _CharT>
    basic_string<CharT> _Collate<_CharT>::do_transform
			     (const _CharT* __lo, const _CharT* __hi) const =0
  template <typename _CharT>
    long   _Collate<_CharT>::do_hash   (const _CharT* __lo,
					const _CharT* __hi) const =0
#endif

  ///////
  export template <typename _CharT>
    locale::id collate<_CharT>::id;

  export template <typename _CharT>
    collate<_CharT>::collate (size_t __refs)
  : _Collate<_CharT> (__refs)
  {
  }


  export template <typename _CharT>
    collate<_CharT>::~collate () { }

  export template <typename _CharT>
    collate_byname<_CharT>::~collate_byname () { }

// Support for time_get:

// Note that these partial specializations could, and maybe should,
// be changed to full specializations (by eliminating the _Dummy
// argument) and moved to a .cc file.

template <typename _CharT, typename _Dummy = int>
  struct _Weekdaynames;

template <typename _Dummy>
  struct _Weekdaynames<char, _Dummy>
    { static const char* const _S_names[14]; };

template <typename _Dummy>
  const char* const
  _Weekdaynames<char,_Dummy>::_S_names[14] = { "Sun", "Sunday",
      "Mon", "Monday",   "Tue", "Tuesday", "Wed", "Wednesday",
      "Thu", "Thursday", "Fri", "Friday",  "Sat", "Saturday"
  };

template <typename _Dummy>
  struct _Weekdaynames<wchar_t,_Dummy>
    { static const wchar_t* const _S_names[14]; };

template <typename _Dummy>
  const wchar_t* const
  _Weekdaynames<wchar_t,_Dummy>::_S_names[14] = { L"Sun", L"Sunday",
     L"Mon", L"Monday",   L"Tue", L"Tuesday", L"Wed", L"Wednesday",
     L"Thu", L"Thursday", L"Fri", L"Friday",  L"Sat", L"Saturday"
  };

template <typename _CharT, typename _Dummy = int>
  struct _Monthnames;

template <typename _Dummy>
  struct _Monthnames<char,_Dummy>
    { static const char* const _S_names[24]; };

template <typename _Dummy>
  const char* const
  _Monthnames<char,_Dummy>::_S_names[24] = {
	"Jan", "January", "Feb", "February", "Mar", "March",
	"Apr", "April",   "May", "May",      "Jun", "June",
	"Jul", "July",    "Aug", "August",   "Sep", "September",
	"Oct", "October", "Nov", "November", "Dec", "December"
  };

template <typename _Dummy>
  struct _Monthnames<wchar_t, _Dummy>
    { static const wchar_t* const _S_names[24]; };

template <typename _Dummy>
  const wchar_t* const
  _Monthnames<wchar_t,_Dummy>::_S_names[24] = {
	L"Jan", L"January", L"Feb", L"February", L"Mar", L"March",
	L"Apr", L"April",   L"May", L"May",      L"Jun", L"June",
	L"Jul", L"July",    L"Aug", L"August",   L"Sep", L"September",
	L"Oct", L"October", L"Nov", L"November", L"Dec", L"December"
  };

  ////////////
  export template <typename _CharT, typename _InIter>
    locale::id time_get<_CharT,_InIter>::id;

  export template <typename _CharT, typename _InIter>
    time_get<_CharT,_InIter>::time_get (size_t __refs)
  : locale::facet (__refs), _M_daynames(0), _M_monthnames(0)
  { }

  export template <typename _CharT, typename _InIter>
    time_get<_CharT,_InIter>::~time_get ()
      { delete [] _M_monthnames; delete [] _M_daynames; }

  export template <typename _CharT, typename _InIter>
    time_base::dateorder time_get<_CharT,_InIter>::do_date_order ()  const
  {
    return time_base::ymd;
  }

  // do_get_time specialized for char
  export template <typename _CharT, typename _InIter>
    _InIter time_get<_CharT,_InIter>::
      do_get_time (iter_type __s, iter_type __end,
		   ios_base& __io, _Ios_Iostate& __err,  tm* __t) const
  {
    return __s;
  }

  export template <typename _CharT, typename _InIter>
    _InIter time_get<_CharT,_InIter>::
      do_get_date (iter_type __s, iter_type __end,
		   ios_base& __io, _Ios_Iostate& __err,  tm* __t) const
  {
    return __s;
  }

  export template <typename _CharT, typename _InIter>
    _InIter time_get<_CharT,_InIter>::
      do_get_weekday (iter_type __s, iter_type __end,
		      ios_base& __io, _Ios_Iostate& __err, tm* __t) const
  {
    if (!_M_daynames) {
      _M_daynames = new basic_string<_CharT>[14];
      for (int __i = 0; __i < 14; ++__i)
        _M_daynames[__i] = _Weekdaynames<_CharT>::_S_names[__i];
    }
    bool __at_eof = false;
    int __remain = 0;
    int __matches[14];
    iter_type __out = __match_parallel(
      __s, __end, 14, _M_daynames, __matches, __remain, __at_eof);
    __err = ios_base::iostate(0);
    if (__at_eof) __err |= __io.eofbit;
    if (__remain == 1 ||
	__remain == 2 && (__matches[0]>>1) == (__matches[1]>>1))
      __t->tm_wday = (__matches[0]>>1);
    else
      __err |= __io.failbit;
    return __out;
  }

  export template <typename _CharT, typename _InIter>
    _InIter time_get<_CharT,_InIter>::
      do_get_monthname (iter_type __s, iter_type __end,
			ios_base& __io, _Ios_Iostate& __err, tm* __t) const
  {
    if (!_M_monthnames) {
      _M_monthnames = new basic_string<_CharT>[24];
      for (int __i = 0; __i < 24; ++__i)
        _M_monthnames[__i] = _Monthnames<_CharT>::_S_names[__i];
    }
    bool __at_eof = false;
    int __remain = 0;
    int __matches[24];
    iter_type __out = __match_parallel(
      __s, __end, 24, _M_monthnames, __matches, __remain, __at_eof);
    __err = ios_base::iostate(0);
    if (__at_eof) __err |= __io.eofbit;
    if (__remain == 1 ||
	__remain == 2 && (__matches[0]>>1) == (__matches[1]>>1))
      __t->tm_mon = (__matches[0]>>1);
    else
      __err |= __io.failbit;
    return __out;
  }

  export template <typename _CharT, typename _InIter>
    _InIter time_get<_CharT,_InIter>::
      do_get_year (iter_type __s, iter_type __end,
		   ios_base& __io, _Ios_Iostate& __err, tm* __t) const
  {
    return __s;
  }

  //////
  export template <typename _CharT, typename _InIter>
    time_get_byname<_CharT,_InIter>::time_get_byname (const char*,
						      size_t __refs)
  : time_get<_CharT,_InIter> (__refs)
  {
  }

  export template <typename _CharT, typename _InIter>
    time_get_byname<_CharT,_InIter>::~time_get_byname () { }


  /////
  export template <typename _CharT, typename _OutIter>
    locale::id time_put<_CharT,_OutIter>::id;

  export template <typename _CharT, typename _OutIter>
    time_put<_CharT,_OutIter>::time_put (size_t __refs)
  : locale::facet (__refs)
  {
  }

  export template <typename _CharT, typename _OutIter>
    time_put<_CharT,_OutIter>::~time_put () { }


  // note: this is a nonvirtual, calls do_put in a loop.
  export template <typename _CharT, typename _OutIter>
    _OutIter time_put<_CharT,_OutIter>::put (iter_type __s, ios_base& __f,
		  char_type __fill, const tm* __tmb,
		  const _CharT* __pattern, const _CharT* __pat_end) const
  {
    return __s;
  }

  export template <typename _CharT, typename _OutIter>
    _OutIter time_put<_CharT,_OutIter>::do_put (iter_type __s, ios_base& __io,
						char_type, const tm* __t,
						char __format,
						char __modifier) const
  {
    return __s;
  }

  /////////////
  export template <typename _CharT, typename _OutIter>
    time_put_byname<_CharT,_OutIter>::time_put_byname (const char*,
						       size_t __refs)
  : time_put<_CharT,_OutIter> (__refs)
  {
  }

  export template <typename _CharT, typename _OutIter>
    time_put_byname<_CharT,_OutIter>::~time_put_byname () { }

  /////////////
  export template <typename _CharT, typename _InIter>
    locale::id money_get<_CharT,_InIter>::id;

  export template <typename _CharT, typename _InIter>
    money_get<_CharT,_InIter>::money_get (size_t __refs)
  : locale::facet (__refs)
  {
  }

  export template <typename _CharT, typename _InIter>
    money_get<_CharT,_InIter>::~money_get () { }

  export template <typename _CharT, typename _InIter>
    _InIter money_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					       bool __intl, ios_base& __io,
					       _Ios_Iostate& __err,
					       long double& __units) const
  {
    return __s;
  }


  export template <typename _CharT, typename _InIter>
    _InIter money_get<_CharT,_InIter>::do_get (iter_type __s, iter_type __end,
					       bool __intl, ios_base& __io,
					       _Ios_Iostate& __err,
					       string_type& __digits) const
  {
    return __s;
  }


  /////////////
  export template <typename _CharT, typename _OutIter>
    locale::id money_put<_CharT,_OutIter>::id;

  export template <typename _CharT, typename _OutIter>
    money_put<_CharT,_OutIter>::money_put (size_t __refs)
  : locale::facet (__refs)
  {
  }

  export template <typename _CharT, typename _OutIter>
    money_put<_CharT,_OutIter>::~money_put ()  {  }

  export template <typename _CharT, typename _OutIter>
    _OutIter
    money_put<_CharT,_OutIter>::do_put (iter_type __s, bool, ios_base& __io,
					char_type __fill,
					long double __units) const
  {
    return __s;
  }


  export template <typename _CharT, typename _OutIter>
    _OutIter
    money_put<_CharT,_OutIter>::do_put (iter_type __s, bool, ios_base& __io,
					char_type __fill,
					const string_type& __digits) const
  {
    return __s;
  }

  ////////////////
  export template<typename _CharT>
    _Moneypunct<_CharT>::_Moneypunct (size_t __refs)
  : _Punct<_CharT> (__refs)
  {
  }

  export template<typename _CharT>
    _Moneypunct<_CharT>::~_Moneypunct () { }

  export template<typename _CharT>
    basic_string<_CharT>  _Moneypunct<_CharT>::do_curr_symbol ()   const
  {
    return basic_string<_CharT>();
  }

  export template<typename _CharT>
    basic_string<_CharT>  _Moneypunct<_CharT>::do_positive_sign () const
  {
    return basic_string<_CharT>();
  }

  export template<typename _CharT>
    basic_string<_CharT>  _Moneypunct<_CharT>::do_negative_sign () const
  {
    return basic_string<_CharT>();
  }

  export template<typename _CharT>
    int          _Moneypunct<_CharT>::do_frac_digits ()   const
  {
    return 0;
  }

  export template<typename _CharT>
    money_base::pattern      _Moneypunct<_CharT>::do_pos_format ()    const
  {
    static const money_base::pattern __pat = {{ symbol, sign, none, value }};
    return __pat;
  }

  export template<typename _CharT>
    money_base::pattern      _Moneypunct<_CharT>::do_neg_format ()    const
  {
    static const money_base::pattern __pat = {{ symbol, sign, none, value }};
    return __pat;
  }


  ////////////
  export template <typename _CharT, bool _Intl>
    locale::id moneypunct<_CharT,_Intl>::id;

  export template <typename _CharT, bool _Intl>
    moneypunct<_CharT,_Intl>::moneypunct (size_t __refs)
  : _Moneypunct<_CharT> (__refs)
  {
  }

  export template <typename _CharT, bool _Intl>
    moneypunct<_CharT,_Intl>::~moneypunct () { }

  ////////////
  export template <typename _CharT, bool _Intl>
    moneypunct_byname<_CharT,_Intl>::moneypunct_byname (const char*,
							size_t __refs)
  : moneypunct<_CharT,_Intl> (__refs)
  {
  }

  export template <typename _CharT, bool _Intl>
    moneypunct_byname<_CharT,_Intl>::~moneypunct_byname () { }


  ////////////
  export template <typename _CharT>
    _Messages<_CharT>::_Messages (size_t __refs)
  : locale::facet (__refs)
  {
  }

  export template <typename _CharT>
    _Messages<_CharT>::~_Messages () { }


#if 1
  // These probably should be pure, and specialized
  //   But for now, they're stubs here.

  template <typename _CharT>
    messages_base::catalog _Messages<_CharT>::do_open (
	       const basic_string<char>&, const locale&) const
      { return 0; }

  template <typename _CharT>
    basic_string<_CharT>  _Messages<_CharT>::do_get (catalog, int __set,
		     int __msgid, const string_type& __dfault) const
      { return __dfault; }

  template <typename _CharT>
    void    _Messages<_CharT>::do_close (catalog) const
      { }
#endif

  ///////////////
  export template <typename _CharT>
    locale::id messages<_CharT>::id;

  export template <typename _CharT>
    messages<_CharT>::messages (size_t __refs)
  : _Messages<_CharT> (__refs)
  {
  }

  export template <typename _CharT>
    messages<_CharT>::~messages () { }

  ///////////////
  export template <typename _CharT>
    messages_byname<_CharT>::messages_byname (const char*, size_t __refs)
  : messages<_CharT> (__refs)
  {
  }

  export template <typename _CharT>
    messages_byname<_CharT>::~messages_byname () { }

#if 1
  template<>
    inline const ctype<char>&
    use_facet< const ctype<char> > (const locale& __loc)
  {
    size_t __i = ctype<char>::id._M_index;
    const locale::_Impl* __tmp = __loc._M_impl;
    return static_cast<const ctype<char>&>(* (*(__tmp->_M_facets))[__i]);
  }

  template<>
    inline const ctype<wchar_t>&
    use_facet< const ctype<wchar_t> > (const locale& __loc)
  {
    size_t __i = ctype<wchar_t>::id._M_index;
    const locale::_Impl* __tmp = __loc._M_impl;
    return static_cast<const ctype<wchar_t>&>(* (*(__tmp->_M_facets))[__i]);
  }
#endif

} // std::

#endif /* _CPP_BITS_LOCFACETS_TCC */

// Local Variables:
// mode:c++
// End:
