// -*- C++ -*- forwarding header.

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882:
//

// Note: this is not a conforming implementation.

#ifndef _CPP_CCTYPE
#define _CPP_CCTYPE 1
# include_next <ctype.h>

#if 1
// The ISO standard allows the following symbols to be macros.  We cannot
// live with this so undefine them.

// XXX They should be replaced with inline functions.

# undef toupper
# undef tolower
# undef isspace
# undef isprint
# undef iscntrl
# undef isupper
# undef islower
# undef isalpha
# undef isdigit
# undef ispunct
# undef isxdigit
# undef isalnum
# undef isgraph

/* XXX put these in for now, to avoid problems when users try to use these
   for template parameter names and the like.  */
# undef _U
# undef _L
# undef _N
# undef _S
# undef _P
# undef _C
# undef _B
# undef _X

#else

// XXX when we have namespaces we can sequester the C non-inline
//   implementations in the _C_Swamp:: namespace, and provide C++
//   inlines for them in the std:: namespace where they belong.

namespace std 
{

#ifdef toupper
  inline int _S_toupper_helper (int c) { return toupper(c); }
# undef toupper
  inline int toupper (int c) { return _S_toupper_helper (c); }
#endif

#ifdef tolower
  inline int _S_tolower_helper (int c) { return tolower(c); }
# undef tolower
  inline int tolower (int c) { return _S_tolower_helper (c); }
#endif

#ifdef isspace
  inline int _S_isspace_helper (int c) { return isspace(c); }
# undef isspace
  inline int isspace (int c) { return _S_isspace_helper (c); }
#endif

#ifdef isprint
  inline int _S_isprint_helper (int c) { return isprint(c); }
# undef isprint
  inline int isprint (int c) { return _S_isprint_helper (c); }
#endif

#ifdef iscntrl
  inline int _S_iscntrl_helper (int c) { return iscntrl(c); }
# undef iscntrl
  inline int iscntrl (int c) { return _S_iscntrl_helper (c); }
#endif

#ifdef isupper
  inline int _S_isupper_helper (int c) { return isupper(c); }
# undef isupper
  inline int isupper (int c) { return _S_isupper_helper (c); }
#endif

#ifdef islower
  inline int _S_islower_helper (int c) { return islower(c); }
# undef islower
  inline int islower (int c) { return _S_islower_helper (c); }
#endif

#ifdef isalpha
  inline int _S_isalpha_helper (int c) { return isalpha(c); }
# undef isalpha
  inline int isalpha (int c) { return _S_isalpha_helper (c); }
#endif

#ifdef isdigit
  inline int _S_isdigit_helper (int c) { return isdigit(c); }
# undef isdigit
  inline int isdigit (int c) { return _S_isdigit_helper (c); }
#endif

#ifdef ispunct
  inline int _S_ispunct_helper (int c) { return ispunct(c); }
# undef ispunct
  inline int ispunct (int c) { return _S_ispunct_helper (c); }
#endif

#ifdef isxdigit
  inline int _S_isxdigit_helper (int c) { return isxdigit(c); }
# undef isxdigit
  inline int isxdigit (int c) { return _S_isxdigit_helper (c); }
#endif

#ifdef isalnum
  inline int _S_isalnum_helper (int c) { return isalnum(c); }
# undef isalnum
  inline int isalnum (int c) { return _S_isalnum_helper (c); }
#endif

#ifdef isgraph
  inline int _S_isgraph_helper (int c) { return isgraph(c); }
# undef isgraph
  inline int isgraph (int c) { return _S_isgraph_helper (c); }
#endif

} // namespace std

#endif

#endif
