// Streambuf iterators

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

// XXX should specialize copy, find algorithms for streambuf iterators.

#ifndef _CPP_BITS_SBUF_ITER_H
#define _CPP_BITS_SBUF_ITER_H 1

namespace std
{

    template <class _CharT, class _Traits>
      class ostreambuf_iterator
#if 0      // XXX this is standard:
        : public iterator<output_iterator_tag,_CharT,void,void,void>
#else
        : public output_iterator
#endif
    {
    public:
      typedef _CharT                          char_type;
      typedef _Traits                         traits_type;
      typedef basic_streambuf<_CharT,_Traits> streambuf_type;
      typedef basic_ostream<_CharT,_Traits>   ostream_type;
    public:
      inline ostreambuf_iterator(ostream_type& __s) throw ()
        : _M_sbuf(__s.rdbuf()), _M_failed(false) { }
      inline ostreambuf_iterator(streambuf_type* __s) throw ()
	: _M_sbuf(__s), _M_failed(false) { }
      inline ostreambuf_iterator& operator=(_CharT __c);
      inline ostreambuf_iterator& operator*() throw()
	{ return *this; }
      inline ostreambuf_iterator& operator++(int) throw()
	{ return *this; }
      inline ostreambuf_iterator& operator++() throw()
	{ return *this; }
      inline bool failed() const throw()
	{ return _M_failed; }
    private:
      streambuf_type* _M_sbuf;
      bool _M_failed;

#if 0
      template <>
        friend char const*
        copy(char const* __first, char const* __last,
             ostreambuf_iterator<char,char_traits<char> > __to);
      template <>
        friend wchar_t const*
        copy(wchar_t const* __first, wchar_t const* __last,
             ostreambuf_iterator<wchar_t,char_traits<wchar_t> > __to);
#endif
    };

    template <class _CharT, class _Traits>
      inline ostreambuf_iterator<_CharT,_Traits>&
      ostreambuf_iterator<_CharT,_Traits>::operator=(_CharT __c)
    {
      if (!_M_failed &&
          _Traits::eq_int_type(_M_sbuf->sputc(__c),_Traits::eof()))
	_M_failed = true;
      return *this;
    }


#if 0
    // Optimized specializations of standard algorithms
    //  These are specialized only for standard types
    //  (with no unbound arguments) to avoid creating
    //  overload problems with user specializations.

    template <>
      char const*
      copy(char const* __first, char const* __last,
           ostreambuf_iterator<char,char_traits<char> > __to)
    {
      if (!__to._M_failed)
        __to._M_sbuf->sputn(__first, __last-__first);
      return __last;
    }

    template <>
      wchar_t const*
      copy(wchar_t const* __first, wchar_t const* __last,
           ostreambuf_iterator<whar_t,char_traits<wchar_t> > __to)
    {
      if (!__to._M_failed)
        __to._M_sbuf->sputn(__first, __last-__first);
      return __last;
    }
#endif

  // Input Streambuf Iterator

    template<class _CharT, class _Traits>
      class istreambuf_iterator
#if 0      // XXX this is standard:
        : public iterator<input_iterator_tag, _CharT,
                         typename _Traits::off_type, _CharT*, _CharT&>
#else
        : public input_iterator<_CharT,typename _Traits::off_type>
#endif
    {
    public:
      typedef _CharT                         char_type;
      typedef _Traits                        traits_type;
      typedef typename _Traits::int_type     int_type;
      typedef basic_streambuf<_CharT,_Traits> streambuf_type;
      typedef basic_istream<_CharT,_Traits>   istream_type;
      class _Proxy;
    public:
      inline istreambuf_iterator() throw()
	: _M_sbuf(_S_dummy ()) { }
      inline istreambuf_iterator(istream_type& __s) throw()
	: _M_sbuf(__s.rdbuf() ? __s.rdbuf() : _S_dummy ()) {}
      inline istreambuf_iterator(streambuf_type* __s) throw()
	: _M_sbuf(__s ? __s : _S_dummy ()) {}
      inline istreambuf_iterator(const _Proxy& __p) throw()
	: _M_sbuf(__p._M_sbuf) {}
      inline _CharT operator*() const
	{ return _Traits::to_char_type(_M_sbuf->sgetc()); }
      inline istreambuf_iterator<_CharT,_Traits>& operator++()
        { return *this; }
      inline _Proxy operator++(int)
        { return _Proxy(_M_sbuf->sbumpc(), _M_sbuf); }
      inline bool equal(const istreambuf_iterator& __b);
        // nonstandard: this is here because of a bug in the standard.
        //  member equal() should have been specified const; so overload.
      inline bool equal(const istreambuf_iterator& __b) const;

    private:
      // _S_dummy () returns a pointer to a static object in which
      //   the words at offsetof _IO_read_ptr and _IO_read_end are equal.
      static inline basic_streambuf<_CharT,_Traits>* _S_dummy ();

      bool _M_equal_helper(const istreambuf_iterator& __b) const;
      streambuf_type* _M_sbuf;  // never 0.
    };

    template <class _CharT, class _Traits>
      inline basic_streambuf<_CharT,_Traits>* _S_dummy ()
	{ static long __dummy[(sizeof(streambuf_type)+sizeof(long)-1)/
                              sizeof(long)];
          return reinterpret_cast<basic_streambuf<_CharT,_Traits>*>
            (&__dummy); }

    template <class _CharT, class _Traits>
      inline bool operator==(const istreambuf_iterator<_CharT,_Traits>& __a,
                             const istreambuf_iterator<_CharT,_Traits>& __b)
	{ return __a.equal(__b); }

    template <class _CharT, class _Traits>
      inline bool operator!=(const istreambuf_iterator<_CharT,_Traits>& __a,
                             const istreambuf_iterator<_CharT,_Traits>& __b)
	{ return !__a.equal(__b); }

    template <class _CharT, class _Traits>
      class istreambuf_iterator<_CharT,_Traits>::_Proxy {
	typedef typename _Traits::int_type _Int_type;
	_Int_type _M_keep;
	basic_streambuf<_CharT,_Traits>* _M_sbuf;
	inline _Proxy(_Int_type __c, basic_streambuf<_CharT,_Traits>* __sbuf) throw()
	  : _M_keep(__c), _M_sbuf(__sbuf) { }
      public:
	_CharT operator*()
          { return _Traits::to_char_type(_M_keep); }
	friend class istreambuf_iterator<_CharT,_Traits>;
    };


    template <class _CharT, class _Traits>
      inline basic_streambuf<_CharT,_Traits>*
      istreambuf_iterator<_CharT,_Traits>::_S_dummy ()
      {
        // note: this depends on zero-init'd pointers being really null.
        static long __dummy[(sizeof(streambuf_type)+sizeof(long)-1)/
                            sizeof(long)];
        return reinterpret_cast<streambuf_type*> (&__dummy);
      }

    template <class _CharT, class _Traits>
      inline bool
      istreambuf_iterator<_CharT,_Traits>::
        equal (istreambuf_iterator const& __b) const
      {
	// XXX note: this definition is not strictly standard-conforming.
	//   we will try to change the standard instead.
	return (_M_sbuf->_M_in_cur >= _M_sbuf->_M_in_end &&
                __b._M_sbuf->_M_in_cur >= __b._M_sbuf->_M_in_end) &&
                _M_equal_helper(__b);
      }

    template <class _CharT, class _Traits>
      bool
      istreambuf_iterator<_CharT,_Traits>::
        _M_equal_helper	(const istreambuf_iterator & __b) const
      {
        // we avoid calling sgetc () on the _S_dummy streambuf,
        // because its virtual functions don't work.
	return
          ((_M_sbuf == _S_dummy () ||
              _Traits::eq_int_type (_M_sbuf->sgetc (), _Traits::eof ())) &&
           (_M_sbuf == _S_dummy () ||
              _Traits::eq_int_type (__b._M_sbuf->sgetc (), _Traits::eof ())));
      }

    // XXX this is here because of a bug in the standard.
    //   we will try to fix the standard.

    template <class _CharT, class _Traits>
      inline bool
      istreambuf_iterator<_CharT,_Traits>::equal
	(istreambuf_iterator const& __b)
      { typedef istreambuf_iterator<_CharT,_Traits> const& _It;
        return (const_cast<_It> (*this)).equal(__b); }


} // std::

#endif /* _CPP_BITS_SBUF_ITER_H */
