/* Complex cosine hyperbole function for double.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ double
ccosh (__complex__ double x)
{
  __complex__ double retval;

  if (FINITE_P (__real__ x))
    {
      /* Real part is finite.  */
      if (FINITE_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  double sinh_val = sinh (__real__ x);
	  double cosh_val = cosh (__real__ x);
	  double sinix = sin (__imag__ x);
	  double cosix = cos (__imag__ x);

	  __real__ retval = cosh_val * cosix;
	  __imag__ retval = sinh_val * sinix;
	}
      else
	{
	  __imag__ retval = __real__ x == 0.0 ? 0.0 : NAN;
	  __real__ retval = NAN + NAN;
	}
    }
  else if (INFINITE_P (__real__ x))
    {
      /* Real part is infinite.  */
      if (__imag__ x == 0.0)
	{
	  /* Imaginary part is 0.0.  */
	  __real__ retval = HUGE_VAL;
	  __imag__ retval = __imag__ x * __copysign (1.0, __real__ x);
	}
      else if (FINITE_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  double sinix = sin (__imag__ x);
	  double cosix = cos (__imag__ x);

	  __real__ retval = __copysign (HUGE_VAL, cosix);
	  __imag__ retval = (__copysign (HUGE_VAL, sinix)
			     * __copysign (1.0, __real__ x));
	}
      else
	{
	  /* The addition raises the invalid exception.  */
	  __real__ retval = HUGE_VAL;
	  __imag__ retval = NAN + NAN;
	}
    }
  else
    {
      __real__ retval = NAN;
      __imag__ retval = __imag__ x == 0.0 ? __imag__ x : NAN;
    }

  return retval;
}
