#ifndef time_h
#define time_h 1

// this kludge will probably work on most systems

#include <stddef.h>  /* sorry, but needed for DGUX */
#include <stdio.h>   /* sorry, but needed for USG */

#include <sys/types.h>

extern "C" {

#define gmtime c_proto_gmtime
#define localtime c_proto_localtime
#define asctime c_proto_asctime
#define ctime c_proto_ctime
#define tzset c_proto_tzset
#define tzsetwall c_proto_tzsetwall
#define  timezone c_proto_timezone
#define getitimer c_proto_getitimer
#define setitimer c_proto_setitimer
#define gettimeofday c_proto_gettimeofday
#define settimeofday c_proto_settimeofday

#define KERNEL

#ifndef USG
#include "//usr/include/sys/time.h"
#endif
#include "//usr/include/sys/times.h"
#include "//usr/include/time.h"

#undef KERNEL

#undef gmtime 
#undef localtime 
#undef asctime 
#undef ctime 
#undef tzset 
#undef tzsetwall 
#undef timezone 
#undef getitimer
#undef setitimer
#undef gettimeofday
#undef settimeofday

extern struct tm* localtime(long*);
extern struct tm* gmtime(long*);
extern char* ctime(long*);
extern char* asctime(struct tm*);
extern void tzset();
extern void tzsetwall();

extern long times(struct tms*);

#if defined(USG)
extern long timezone;
extern int daylight;
extern char* tzname[];
#else
typedef struct c_proto_timezone timezone;
extern char* timezone(int, int);
extern int getitimer(int, struct itimerval*);
extern int setitimer(int, struct itimerval*, struct itimerval*);
extern int gettimeofday(struct timeval*, struct timezone*);
extern int settimeofday(struct timeval*, struct timezone*);

#endif

}
#else
#ifdef ctime
/* What to do if "//usr/include/sys/time.h" tries to include us.  */
#include "//usr/include/time.h"
#endif
#endif


