/* This may look like C code, but it is really -*- C++ -*- */

/* Simple lookup table abstraction implemented as a Guilmette Array.

   Copyright (C) 1989 Free Software Foundation, Inc.
   written by Douglas C. Schmidt (schmidt@ics.uci.edu)

This file is part of GNU GPERF.

GNU GPERF is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU GPERF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GPERF; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Define and implement a simple boolean array abstraction,
   uses a Guilmette implementation to save on initialization time. */

#pragma once
#include <std.h>

class Bool_Array 
{
private:
  int *storage_array;    /* Initialization of the index space. */
  int  size;             /* Keep track of array size. */
  int  iteration_number; /* Keep track of the current iteration. */

public:
       Bool_Array (void);
      ~Bool_Array (void);
  void init (int size);
  int  find (int hash_value);
  void reset (void);
};

#ifdef __OPTIMIZE__  /* efficiency hack! */

inline 
Bool_Array::Bool_Array (void)
{
  storage_array    = 0;
  iteration_number = 0;
}

inline void
Bool_Array::init (int s)
{
  iteration_number = 1;
  size             = s;
  storage_array    = new int[s];
  bzero (storage_array, s * sizeof *storage_array);
}

inline int  
Bool_Array::find (int index) 
{
  if (storage_array[index] == iteration_number)
    return 1;
  else
    {
      storage_array[index] = iteration_number;
      return 0;
    }
}

inline void 
Bool_Array::reset (void) 
{ 
  if (iteration_number++ == 0)
    bzero (storage_array, size * sizeof *storage_array);
}

#endif
