<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>algo.h</name>
    <filename>a01321</filename>
    <namespace>std</namespace>
    <namespace>std::__parallel</namespace>
    <class kind="struct">std::__parallel::c_rand_number</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_ALGO_H</name>
      <anchorfile>a01321.html</anchorfile>
      <anchor>f78bb30647c3f8602e88bb8ceae9332a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>45d91e8adf1f264e2ac58c61af2a6f82</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, BinaryPredicate pred)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b33e1a4f6defec690c740288f3488007</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9e24e22f56ed7434ffe5e813758ef2b4</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, BinaryPredicate binary_pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>afe775acbc993ac96a4476f105045db2</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d39e432850d6db7536745afa4a2b0783</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, BinaryPredicate pred, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c5a8964071c76865154c4303162399a6</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, BinaryPredicate pred, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ba0e0449f4a937426664428180f86895</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c0b0ef6a17eb7f2eb25c65313f0cb7f2</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1e1d28878ab2375d17db3fa7b3aa03f3</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>017c021b298aa7eb34886f427980e277</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;value, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cbbc09bb9387572676f24591b0aad197</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;value, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1978d251f2656c378e9ca7005ad36e1e</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>52f3b2d4a35fea195de128ada5958bb1</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>45f568273b729a6f34bff881bc964b43</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>37a967b9c3117dccbec4c525325598a8</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; RandomAccessIterator &gt;::difference_type</type>
      <name>count_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c2ec60c9f8b1eae0a55f07030a0ee7be</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Predicate pred, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_unbalanced)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; InputIterator &gt;::difference_type</type>
      <name>count_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2783ad240bcc91b64f4cfc2f733df1c1</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;value, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; RandomAccessIterator &gt;::difference_type</type>
      <name>count_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0d1d7596aa997725e3469b234b2e747f</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, const T &amp;value, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_unbalanced)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0906c8faa456603dd6f0de0afea1a4fd</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b199dcf805c3951063920244b331ef00</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;val, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>15e665f8181f2a772e2739f499450975</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, ForwardIterator begin2, ForwardIterator end2)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0f1e8437acdfac03b289eba5ed362824</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, ForwardIterator begin2, ForwardIterator end2, BinaryPredicate comp)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d81e17dae8991c1c65b214895202fb52</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, ForwardIterator begin2, ForwardIterator end2, BinaryPredicate comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5a4ad2fdea72506f7116efd7111fb255</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, ForwardIterator begin2, ForwardIterator end2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_first_of_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>71927a129edb5bf76b7e1d282222c7b5</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, ForwardIterator begin2, ForwardIterator end2, BinaryPredicate comp, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>find_first_of_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>43b7e69eca56f943907115a9ecd162c2</anchor>
      <arglist>(RandomAccessIterator begin1, RandomAccessIterator end1, ForwardIterator begin2, ForwardIterator end2, BinaryPredicate comp, random_access_iterator_tag, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_first_of_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>27849addc6c682cc4e326b35177d2abc</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, ForwardIterator begin2, ForwardIterator end2, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>071fe50370e74befaab2d9cb6e4c9d4a</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>de6ed3afca9d43c12e9b65cbfcd49967</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>find_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e5eaaa2419130515c7174fde29414d18</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Predicate pred, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2b8db639c597f5a08de2df0611156098</anchor>
      <arglist>(InputIterator begin, InputIterator end, Predicate pred, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b42becbb1234255e833156a89febf9b2</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, const T &amp;val, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>InputIterator</type>
      <name>find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ba7a011cfd6761d123e9af4a71e3fc9b</anchor>
      <arglist>(InputIterator begin, InputIterator end, const T &amp;val, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>Function</type>
      <name>for_each</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e6800a0c7896f9877eeb9251366fc42b</anchor>
      <arglist>(Iterator begin, Iterator end, Function f)</arglist>
    </member>
    <member kind="function">
      <type>Function</type>
      <name>for_each</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>61351e236aac7da1606b3dbbf992aa94</anchor>
      <arglist>(Iterator begin, Iterator end, Function f, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>Function</type>
      <name>for_each</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c099555bae01161b3527ba6f13121452</anchor>
      <arglist>(InputIterator begin, InputIterator end, Function f, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>Function</type>
      <name>for_each_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>24588fda98967bae948a9bae72bfaa52</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Function f, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>Function</type>
      <name>for_each_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>53ba2c5a7d5eadaa4954fe1d460c5cda</anchor>
      <arglist>(InputIterator begin, InputIterator end, Function f, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1caed53f2ea576b13d7857a4b9ce6866</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Generator gen)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>aace5688e7c0f419ac3edf6d7fb2357e</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Generator gen, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ccf63a0ff5dde07dc96ebf0be69d47d4</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Generator gen, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>generate_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>660c79611dee8674d74055a86a774764</anchor>
      <arglist>(OutputIterator begin, Size n, Generator gen)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>generate_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>38dd82eba8bfe7ff748125f3debef8de</anchor>
      <arglist>(OutputIterator begin, Size n, Generator gen, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>generate_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>46d976ae017272e825165814a498b308</anchor>
      <arglist>(OutputIterator begin, Size n, Generator gen, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>generate_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>80143888e2dac29997b4722027d787a3</anchor>
      <arglist>(RandomAccessIterator begin, Size n, Generator gen, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>generate_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d8225890643db12de8489bee38dfed10</anchor>
      <arglist>(OutputIterator begin, Size n, Generator gen, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d6ae2fe69ab6c3d9d98cedce54f7c2e1</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Generator gen, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c101239f2558ff95f152b16bd2cdf17f</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Generator gen, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>17c43941ea32572f764cbac623469ec0</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0329644ad03600afa233c65cb5232085</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>04a5c936d1bcd13681341de9c9f22cd6</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2f91938b133696031b9e8ec72fa6e460</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>84dc11685ee48a496d6056141e924965</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>605dc40b81e766cf880901c15c5f8e06</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>max_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b986c0d4a8c3d071004a8674203dd086</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>max_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0b76eb128ae09481188e69f815ca0a13</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9789664177a9686bb6475249b6c9151b</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>41432f3b11a5eeb326a9c526f015596b</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>00cc8ccef704418e561c68f3cb1645e3</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Comparator comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>41bb8201e59366cb156157e26a873561</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>81b0cac36630d84d5005e03dbce8ac65</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Comparator comp, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>36cdce5ac2e907619047d50b7efdd709</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Comparator comp, IteratorTag1, IteratorTag2, IteratorTag3)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4182acfd603a3efcc1e451fa5cb0908a</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2945670b8b6fc5842d5c6449d3c2db5d</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>80ed94b6f821409cd829224b66f95099</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f96000537425607c54b66a6c97425489</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>01328638b552f1a50fa03f973f1efa8d</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>de67cc5544936016970b7bffc7e96fac</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>min_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1655b802352c54699f41dda8048c0657</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>min_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2f993c38a20658d92ed7ac2dffa0cd8f</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Comparator comp, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b8401f3aacdc65cf4c995b0b2030c7c9</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator nth, RandomAccessIterator end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1738366afe8188a328c30cb3b0c1b68b</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator nth, RandomAccessIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8e80fe7d1329f5c16ee83f4d19d47920</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator nth, RandomAccessIterator end, Comparator comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d90083a47c503fd6ae618451a6aca022</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator nth, RandomAccessIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>711ecce7d35008904f9520f7fefb00ec</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator middle, RandomAccessIterator end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a78fb75e9f1622e0e6a7a0047be38242</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator middle, RandomAccessIterator end, _Compare comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f8587f1c54209888a4b1489e5a143214</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator middle, RandomAccessIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2e00f516a78687d6ea264fda36462996</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator middle, RandomAccessIterator end, _Compare comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>partition</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0dd5f2e2abe35cc3c40a61b97bf2db42</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>partition</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>101b37752a7d0b1469eb32d6d10dd389</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>partition_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7ac4de054745e666e8f876470856bb38</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Predicate pred, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>partition_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7966cfe6c4856b7bb0edef67c5931283</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>19f9c75878ae5a52ab17f0bc732b9cbd</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, RandomNumberGenerator &amp;rand)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>85b47e5db0f8a82c689abbffe109f042</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2e98c861ebf847f9bb86f44221669467</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, RandomNumberGenerator &amp;rand, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>829066a3da792393a8af50e44ae18168</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>025eabbc21853f3297d0d3753f1878c5</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, const T &amp;old_value, const T &amp;new_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a419f9607a68707e52bec8ba4df381f8</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, const T &amp;old_value, const T &amp;new_value, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b7dac0789daedbcc44f49d0cb1f97e49</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, const T &amp;old_value, const T &amp;new_value, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>135451577d3a870cc4a905b711e94e39</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred, const T &amp;new_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b81bd3ebb75009a4d4feb459fc09f746</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred, const T &amp;new_value, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ab84e9cfb0ac25d4b268e08aa44de9a9</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred, const T &amp;new_value, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c8c712b89f74665e6a31ac175825b892</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Predicate pred, const T &amp;new_value, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>aed5802663c3f05403e16f0e569df238</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Predicate pred, const T &amp;new_value, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>dcea23c8e262f9269ed872eedefc6c25</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, const T &amp;old_value, const T &amp;new_value, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a0b366a0d095011e869a58698c90714a</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, const T &amp;old_value, const T &amp;new_value, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c4be057108d21bdbbba7470e447630e0</anchor>
      <arglist>(ForwardIterator1 begin1, ForwardIterator1 end1, ForwardIterator2 begin2, ForwardIterator2 end2, BinaryPredicate pred)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>92d570b1cd6867847027d47a1272098e</anchor>
      <arglist>(ForwardIterator1 begin1, ForwardIterator1 end1, ForwardIterator2 begin2, ForwardIterator2 end2, BinaryPredicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ff504cea4e56e445edda0a4de50be83a</anchor>
      <arglist>(ForwardIterator1 begin1, ForwardIterator1 end1, ForwardIterator2 begin2, ForwardIterator2 end2)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4854145efa1cc05b21ea03cf5f4d0c7e</anchor>
      <arglist>(ForwardIterator1 begin1, ForwardIterator1 end1, ForwardIterator2 begin2, ForwardIterator2 end2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f5090583c58ecdaf8006d42d44c1f0fb</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Integer count, const T &amp;val, BinaryPredicate binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>eae9fc2e681b5a8a5911b2682c47f8b8</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Integer count, const T &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>305a750b76f07a9e55719328f2cfd9e8</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Integer count, const T &amp;val, BinaryPredicate binary_pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>376823c8963ecc5f8638e51c3e1376a1</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Integer count, const T &amp;val, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator</type>
      <name>search_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>89f62a55631b0b4e0431221173277937</anchor>
      <arglist>(ForwardIterator begin, ForwardIterator end, Integer count, const T &amp;val, BinaryPredicate binary_pred, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>search_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>667c4bf59c9e167b3ee5bae2168a5dec</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Integer count, const T &amp;val, BinaryPredicate binary_pred, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>947676cad4c3f6352051c364c04a2eb0</anchor>
      <arglist>(ForwardIterator1 begin1, ForwardIterator1 end1, ForwardIterator2 begin2, ForwardIterator2 end2, BinaryPredicate pred, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>75769349e71450a70c7485cdc0477dc7</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, BinaryPredicate pred, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>ForwardIterator1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>948f293264eea0d4645e293d9189788c</anchor>
      <arglist>(ForwardIterator1 begin1, ForwardIterator1 end1, ForwardIterator2 begin2, ForwardIterator2 end2, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>395a8bbb08d64d3161da0e2dbf4941f9</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8dca3dad8daad8326d7fcac9d67af6ab</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4da88a2ce264ee4199282bcecf4caf11</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7da57678c1a1c68f843df1ac0a2d9d73</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ab3052c21abd08c1e61de5cc9a6f1fe0</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputRandomAccessIterator</type>
      <name>set_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>175520b5d5dc8da3fc409e731116f1db</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, OutputRandomAccessIterator result, Predicate pred, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a5048c73c1da75c94bd1c84488f8bb90</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Predicate pred, IteratorTag1, IteratorTag2, IteratorTag3)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3ed2682f9376b266757a49d7e3266bc4</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>dc4d1b8f9d2c5e4c61e1ec56ac9a75fc</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>bb76a2cc3ec568798243b513b4ad6bda</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f739cd9feaab9a90a8f261de02cc61ff</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputRandomAccessIterator</type>
      <name>set_intersection_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>811037f246aa0cd6cdc885f54aa15912</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, OutputRandomAccessIterator result, Predicate pred, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_intersection_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f7dc31fab90e4987ceeae0dd5450f32e</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Predicate pred, IteratorTag1, IteratorTag2, IteratorTag3)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ab9ba447be2b51fd7d7d0f3d14c6df34</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f6c1bb88ea6d6220cc047653cb290914</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4cbd78d68799480645f8110b351a3e87</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cfaff83ab2ef795e5f38b86722505c2d</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputRandomAccessIterator</type>
      <name>set_symmetric_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7694d7ac2a95a48200630c6f38e2ef2c</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, OutputRandomAccessIterator result, Predicate pred, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_symmetric_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1b2a1ebe84117db980efcc71e5bd2920</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Predicate pred, IteratorTag1, IteratorTag2, IteratorTag3)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>21e2ac292918c09642844ad3441ba2b6</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2498fce907b620d33e2b9acc24f7f281</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>50c17836ba5e3a824a31cb56d9802794</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7560764555d52b170049d1211871f539</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator out, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputRandomAccessIterator</type>
      <name>set_union_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>47f1a909f1a2f912103c2aa7c2d207cb</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, OutputRandomAccessIterator result, Predicate pred, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_union_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>847c8cb8386df557e6302f9c8d8d4d77</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, OutputIterator result, Predicate pred, IteratorTag1, IteratorTag2, IteratorTag3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>32fd29398fb73afbb800de587d67aad9</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d97b11d4a1e491bc0f8b2efb00095e74</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1d346c1b9831da06486619447660ba6d</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1752752796da2f306846cd4f2a9755c8</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9f52c343b7622f459e2bd356a40156aa</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>085815e9751655f954fde5f285a4b743</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ea973efd109bd9a011f8b99b20a4a339</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7f88a37c20500bf49d03b8fa0c5441c4</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>dd6d528e5748e841d083251d5ef1f4ab</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, OutputIterator result, BinaryOperation binary_op)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cc3deba13c6194ba94adc36acad55a55</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, OutputIterator result, BinaryOperation binary_op, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>bb2d2abb443d3c15ae9daad833ce8636</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, OutputIterator result, BinaryOperation binary_op, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e5841fba7eba1bce53d1fb6bcb093b38</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, UnaryOperation unary_op)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e15663050552027037c471269a321e82</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, UnaryOperation unary_op, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>022f7ed14888cad88d306364f241b30c</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, UnaryOperation unary_op, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator2</type>
      <name>transform1_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a3ecf3dc44f847cb192103379d5e7a3c</anchor>
      <arglist>(RandomAccessIterator1 begin, RandomAccessIterator1 end, RandomAccessIterator2 result, UnaryOperation unary_op, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator2</type>
      <name>transform1_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6a4749b79ee42e5d3a1ed4b3d7c21992</anchor>
      <arglist>(RandomAccessIterator1 begin, RandomAccessIterator1 end, RandomAccessIterator2 result, UnaryOperation unary_op, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>transform2_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8d36dee20469805e8353480603b225ed</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, OutputIterator result, BinaryOperation binary_op, tag1, tag2, tag3)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>transform2_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c812d4acdb412b274fd020f5d98cd5c1</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator3 result, BinaryOperation binary_op, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>815d78f2d71eb9b2b7a13dc203bca28a</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, OutputIterator out, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b86540932502f20d2faa6ccf82e83bd7</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, OutputIterator out)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3a38e4c510fabd0b6085f320e2c2b7d8</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, OutputIterator out, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2e1b5dcaadeb9475d7dd5b2cf16eceee</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, OutputIterator out, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessOutputIterator</type>
      <name>unique_copy_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>bc96a67fa0baa89251442dc9fb64fe9e</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator last, RandomAccessOutputIterator out, Predicate pred, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>unique_copy_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e07a66e5e6bde2cf64a0d5214b1b5364</anchor>
      <arglist>(InputIterator begin, InputIterator last, OutputIterator out, Predicate pred, IteratorTag1, IteratorTag2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>algobase.h</name>
    <filename>a01322</filename>
    <namespace>std</namespace>
    <namespace>std::__parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_ALGOBASE_H</name>
      <anchorfile>a01322.html</anchorfile>
      <anchor>19d7d518b4939414477d1bfff138a011</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c5b05e62d018b2ec6f43f5a9ce2ea390</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>11ca59e903840aba54a3156fe50ccccf</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c4c2cdee7a3d769aa876ed5435c2aa26</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>428404db7ebc0b2bdeb1002b1304e9ea</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3ac8d58faeab2027901fdff47b8ac66d</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>982a629f720336692bc7da3f1529bff8</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3c07e1ac43e907a45a69d0e63e7a12d9</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1172809b736fe35435b1eb996bd502cd</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b866df694773b2e8de2643cf92fb938c</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, RandomAccessIterator2 end2, Predicate pred, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cb56d58e2d6dea44aab26304ac241a6f</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, InputIterator2 end2, Predicate pred, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; InputIterator1, InputIterator2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>89cbfe30209cedd837f5d78f98cf5d4d</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, Predicate pred)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; InputIterator1, InputIterator2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8bba1644b40a1f8304ecf80964a6d688</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; InputIterator1, InputIterator2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6405b7cbf2723f16319507622f4eed65</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, Predicate pred, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; InputIterator1, InputIterator2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4c3590dffbbbf69d6170a3fe2c29eaa1</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; RandomAccessIterator1, RandomAccessIterator2 &gt;</type>
      <name>mismatch_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a94c49bea011e2e066f7ab62aa45948e</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, Predicate pred, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; InputIterator1, InputIterator2 &gt;</type>
      <name>mismatch_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f13cd14108344821929a51246e38207d</anchor>
      <arglist>(InputIterator1 begin1, InputIterator1 end1, InputIterator2 begin2, Predicate pred, IteratorTag1, IteratorTag2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>algorithm</name>
    <filename>a01323</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ALGORITHM</name>
      <anchorfile>a01323.html</anchorfile>
      <anchor>c6509f16e6d55e018a548cab211f476c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ext/algorithm</name>
    <filename>a01324</filename>
    <namespace>__gnu_cxx</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_ALGORITHM</name>
      <anchorfile>a01324.html</anchorfile>
      <anchor>4aa69a9e25c150ccf01e988f5ed53307</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _RAIterator, _OutputIterator &gt;</type>
      <name>__copy_n</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d6bb47473f98868761f443c389f8db4b</anchor>
      <arglist>(_RAIterator __first, _Size __count, _OutputIterator __result, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIterator, _OutputIterator &gt;</type>
      <name>__copy_n</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>28a34b1c89c3e73383aedc34297e7b5f</anchor>
      <arglist>(_InputIterator __first, _Size __count, _OutputIterator __result, input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__lexicographical_compare_3way</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>4533173058ebb30de806485c5f76e790</anchor>
      <arglist>(const char *__first1, const char *__last1, const char *__first2, const char *__last2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__lexicographical_compare_3way</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6607fca6e6766b372a8f4a139035d5b5</anchor>
      <arglist>(const unsigned char *__first1, const unsigned char *__last1, const unsigned char *__first2, const unsigned char *__last2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__lexicographical_compare_3way</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>3fc531ecdb380b3db9a730365305fcc0</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>__random_sample</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a36646ee2891af7d7d1771b014c5fc2f</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _RandomAccessIterator __out, _RandomNumberGenerator &amp;__rand, const _Distance __n)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>__random_sample</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a085ff71195b95ee9cb4793563578011</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _RandomAccessIterator __out, const _Distance __n)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIterator, _OutputIterator &gt;</type>
      <name>copy_n</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>gae9f70cf5e0c2ecbd9e4aacec29e35db</anchor>
      <arglist>(_InputIterator __first, _Size __count, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>count</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>17ec7cbcc76596651d8c5fe574fe1862</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, const _Tp &amp;__value, _Size &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>count_if</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ed855b44b56e16b5f739a3eeb4179f89</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Predicate __pred, _Size &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_heap</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g57a96f73efac40f7f28b73043ed30514</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _StrictWeakOrdering __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_heap</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g1417862afcb26d3f2f358908a5343196</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sorted</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g1030db5d71a92dc1c0c25fb9e25a754f</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _StrictWeakOrdering __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sorted</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>gf1bc10043b510c060bdc4e3c2c8e4820</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>lexicographical_compare_3way</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g7b63e70851205ca844ba8b1db0cdee12</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>random_sample</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g0bb5278200b64c61310f842bd6381e16</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _RandomAccessIterator __out_first, _RandomAccessIterator __out_last, _RandomNumberGenerator &amp;__rand)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>random_sample</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>gd800918f1d02ebbd7eabf5af0a29e8d4</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _RandomAccessIterator __out_first, _RandomAccessIterator __out_last)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>random_sample_n</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g83ef0a0e70829057a339c507d5c01bab</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _OutputIterator __out, const _Distance __n, _RandomNumberGenerator &amp;__rand)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>random_sample_n</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g94129650d48ed6ca9e94bbb82d2d0b40</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _OutputIterator __out, const _Distance __n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>parallel/algorithm</name>
    <filename>a01325</filename>
    <member kind="define">
      <type>#define</type>
      <name>_PARALLEL_ALGORITHM</name>
      <anchorfile>a01325.html</anchorfile>
      <anchor>cf747d39d4334eb866794e82056426d0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bits/algorithmfwd.h</name>
    <filename>a01326</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ALGORITHMFWD_H</name>
      <anchorfile>a01326.html</anchorfile>
      <anchor>ba0de9c2f01cc798327c097244f3c56a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4186f1d9e2b1ca323aaaf540fd69fe7a</anchor>
      <arglist>(_FIter, _FIter, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d73487c2531fa32189fe26de50b49f56</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>binary_search</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b9526e214407da09adf4e486ee1a0a85</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>binary_search</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3a2a14fc90b498041dfab1b1df722e61</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>79f1152926d969201a4d75523ccaeec9</anchor>
      <arglist>(_IIter, _IIter, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_BIter2</type>
      <name>copy_backward</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0a07eff78dc7c8951229737d20c92490</anchor>
      <arglist>(_BIter1, _BIter1, _BIter2)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e99d67620b9c82a85def9b52353832ca</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>77f3a3c6446c22d1383442333e1e8eab</anchor>
      <arglist>(_IIter1 __first1, _IIter1 __last1, _IIter2 __first2, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>78cc7d65e15c8465dc4a8f4e75fc0ae6</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _FIter, _FIter &gt;</type>
      <name>equal_range</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>61c924bd1fd7341ee4a460e602602485</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _FIter, _FIter &gt;</type>
      <name>equal_range</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>80d6ffcf0be2ed334077f5f7cc33bb6f</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7ae1bb9e318d0a09082a0cc7d10fa53e</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>fill_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>316cda03b95fde66c04ed134b55badac</anchor>
      <arglist>(_OIter, _Size, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5c76868d3dc5457ec71f720d4addf20d</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>99713004f86aa82325446118f716fcc1</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>51405aeefd54fe0b1e5712ccde143254</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>find_first_of</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cc13824c9ae74c264109fcd290b139d0</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>find_first_of</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ba238857509afd6d6317cb176f2065ab</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3384f6d0d7c6f394f8bef6e14572b659</anchor>
      <arglist>(_IIter, _IIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_Funct</type>
      <name>for_each</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>80fc2c0f7eb8be418be52ef6172cd9b2</anchor>
      <arglist>(_IIter, _IIter, _Funct)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c7f1a1aa4b2f510c46d94bd7f7c9c451</anchor>
      <arglist>(_FIter, _FIter, _Generator)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>generate_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>819f577cf29621900411c5c9a0b02304</anchor>
      <arglist>(_OIter, _Size, _Generator)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includes</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>53991e12b110b80a7f4859435988e9e3</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includes</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>76d99cf99b38f53351ef063efe6e7fd9</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inplace_merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>946a9ca7c7a627567692db02d41976cc</anchor>
      <arglist>(_BIter, _BIter, _BIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inplace_merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4f84d7b79506b1b26e81bc206848435c</anchor>
      <arglist>(_BIter, _BIter, _BIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>iter_swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>28864197acde95f993a72423e864bcfa</anchor>
      <arglist>(_FIter1, _FIter2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7dfdc837d665b490f9a9f36e63e9130b</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>568d68c7163a24c67cab4eac5eb3c29a</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>lower_bound</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6d9621a97f98eceb35fd6be05ca6e625</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>lower_bound</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2f6f9170df209b0e1f95ef6fd0025cef</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>80c8392e6a613d97f569e44a3061642a</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a38a00251a88f810f277b3465869adcc</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>max</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a57f237cc8bca8e0f83eb79cdf826fd6</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>max</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0f121f0dee771e7ac8a254382021ccaf</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>04d8e708e514ec24203216d3a987240c</anchor>
      <arglist>(_FIter, _FIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3d5d0de12e16d23a3cbdf8e6b78d7977</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a2faca652319e4b08a7ff6814c9e8fc3</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d5a59c79eb018fc305318f35032e17ef</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>min</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a30e5442eb3a6667b444a09935679805</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>min</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0626578e4634db1d4175202deebaa330</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>faf4b844aefdb26eeec77d5a98935afc</anchor>
      <arglist>(_FIter, _FIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0bb2a0e884ebccb69eefce737bf07a8d</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>75ed9fbbfa9a0c6ed1929acba6e45cd7</anchor>
      <arglist>(_BIter, _BIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>decc20056581dde3707a61bd80440480</anchor>
      <arglist>(_BIter, _BIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>597b22964f20354f2b7fc9306f9cd7e5</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>567e9bd01db5712c72c1b6e048453778</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ed6235cb7e60655712933816fe86919b</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cd5b9b8d874eb4e0718cd059436c83a8</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>partial_sort_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>40021847f49a1643999dda7658dbb65f</anchor>
      <arglist>(_IIter, _IIter, _RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>partial_sort_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>480651372cdf13a72c84e49651f4dc42</anchor>
      <arglist>(_IIter, _IIter, _RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>_BIter</type>
      <name>partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fedc78f612595ab08ae86254da784158</anchor>
      <arglist>(_BIter, _BIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f8a093877fce4c9ecc4f3aec96efbb8d</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>16bb4b02b85da4d9680ba69a98941ea7</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prev_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3e9807a6ee2778c8b6c3a00dd4346ae9</anchor>
      <arglist>(_BIter, _BIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prev_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>898c94ac29658db032fdb0c9dc19b14b</anchor>
      <arglist>(_BIter, _BIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9778c990c305c2c79bdf83d46a51c615</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>16c7844864aa8c00ff127c2fcbe30bed</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6661182a68ce6e97eda8328939090493</anchor>
      <arglist>(_RAIter, _RAIter, _Generator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>edbb694d784fc5ce029a81d8829f474c</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>remove</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>34e8e88d92734972e5f4ab674286cbe1</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>remove_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>42153d66315cd68b5f136ef52cb71d07</anchor>
      <arglist>(_IIter, _IIter, _OIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>remove_copy_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>14081feab881b9cf0e7f65e1dd6a6b1b</anchor>
      <arglist>(_IIter, _IIter, _OIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>remove_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3ff9b1b012d774b1d8dc2fedd6187072</anchor>
      <arglist>(_FIter, _FIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>99722d7f16a1e075633e0fb352e0f972</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>replace_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e61729d09bd444c636b02b6967b94af</anchor>
      <arglist>(_IIter, _IIter, _OIter, const _Tp &amp;, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>replace_copy_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>86a5490b24e5e6dc1db3658a10a36ef2</anchor>
      <arglist>(_Iter, _Iter, _OIter, _Predicate, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>97661d3c1893d87d693d71d3bd048ad5</anchor>
      <arglist>(_FIter, _FIter, _Predicate, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reverse</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d99fd53b9935b9e0d6f7278b1ba7b21c</anchor>
      <arglist>(_BIter, _BIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>reverse_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>87be70fba8afba40410bc4723bd854c2</anchor>
      <arglist>(_BIter, _BIter, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>45b115d41f6733913a3569be70925e7c</anchor>
      <arglist>(_FIter, _FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>rotate_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>41ede8af08eb6a724b0e169d4f374f1d</anchor>
      <arglist>(_FIter, _FIter, _FIter, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ce1eeaf714663b27af31d23dd5c41260</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d5ee9e171e02874a6e14b51ed31d8b9c</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>da0e95acde54f09fe77b1363656e8f54</anchor>
      <arglist>(_FIter, _FIter, _Size, const _Tp &amp;, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f64cc7288e2690cf0a09f5b4ae0fa43d</anchor>
      <arglist>(_FIter, _FIter, _Size, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>261aedaa1e845ea3c72c94ae02041a03</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9ff95b74663e55e5b75e5bae848738db</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>01c84554ff7a884dc166854c72a2672e</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2903b2c8014a9b2e5cf69e78e9410131</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e949fec66193d6f158f973c8021f035c</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1abdde2f611c2ec922ab47c0cbcae751</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a241dfa040bc2aaa74bf3a67ca6c7ebc</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5e10e74a9ee4d78a562a0742b2b6aa89</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>63c42a442d1ea863cd71ac3290eff7cc</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2af6ee7dd37d700c09d56e3618379bde</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e4f2daf09606a6347b2fd4fd00b64de3</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fcdba6ab401d108964400b87ae0c9410</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>_BIter</type>
      <name>stable_partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5d603e8a32ab52cd472dc19258f18c8c</anchor>
      <arglist>(_BIter, _BIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c87d75bee293205d98c45c90ef501666</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2126b2a654492b8980b7b7b3a05d78cf</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c88287dd3555e345aeeddc0a767174d2</anchor>
      <arglist>(_Tp &amp;__a, _Tp &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>_FIter2</type>
      <name>swap_ranges</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9b8717bf3dd958930c2bcfbf43ed59bc</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cb997ac9ee00ccfe0b7ede37386263c1</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _OIter, _BinaryOperation)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7c105409539596416f27b3baf319bd16</anchor>
      <arglist>(_IIter, _IIter, _OIter, _UnaryOperation)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>unique</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>65a10488f760e94d0d074e7b02e6e7dc</anchor>
      <arglist>(_FIter, _FIter, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>unique</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cc5a8d6b25f0c2be2a694b88670b6904</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>747c996aa8552d692f56c63e4336660e</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>179274b141c1213b5c9e4e02ffb1ca56</anchor>
      <arglist>(_IIter, _IIter, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>upper_bound</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>65b56d12f37eceb220971c250f2ab935</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>upper_bound</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6efc086455a47e90390f1f55a5132b76</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="variable">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2165b8376999b87a21fa9aec06614378</anchor>
      <arglist>(_IIter, _IIter, _Predicate)</arglist>
    </member>
    <member kind="variable">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dab9a81497de3d973a5660045c642c01</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _BinaryPredicate)</arglist>
    </member>
    <member kind="variable">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>de35180efb56d4448f7a3a21c920db40</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>parallel/algorithmfwd.h</name>
    <filename>a01327</filename>
    <namespace>std</namespace>
    <namespace>std::__parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_ALGORITHMFWD_H</name>
      <anchorfile>a01327.html</anchorfile>
      <anchor>a41732f9c8a09acb3d56e3d582e28395</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>490b3ac305f1bddc6b71f5de1552b05c</anchor>
      <arglist>(_FIter, _FIter, _BiPredicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f3078cb441b1759af314f7bc0f5032cc</anchor>
      <arglist>(_FIter, _FIter, _BiPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>41d4edd4ae827d8b892ca8a24a50a05c</anchor>
      <arglist>(_FIter, _FIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d293a0e25f62fecfea10013ed1943a88</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2a26a9aca554c4cf842490bdd6c22fe8</anchor>
      <arglist>(_RAIter, _RAIter, _BiPredicate, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cc4e67004ba35b9fcea19225a03a74a3</anchor>
      <arglist>(_FIter, _FIter, _BiPredicate, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>56c7f89660ca577f0bfc1e3d2fe87eef</anchor>
      <arglist>(_RAIter, _RAIter, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>adjacent_find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5c06e432560c1acb92bb8efc23f2104a</anchor>
      <arglist>(_FIter, _FIter, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0bb754675a81978fac0ad8acde5d36bd</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ed0624570632da8cbe4b8f0bf2f3c7ad</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>77d41cdc36e368862d1050072ddb78a3</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>eaf1bbe6d86cb5ac6417567436e12403</anchor>
      <arglist>(_IIter, _IIter, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _RAIter &gt;::difference_type</type>
      <name>count_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>441e33d9ec33529701db678160a397c1</anchor>
      <arglist>(_RAIter, _RAIter, _Predicate, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _RAIter &gt;::difference_type</type>
      <name>count_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ab196572c029368509c4fd8aefceda95</anchor>
      <arglist>(_RAIter, _RAIter, const _Tp &amp;, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0f3aaf90ad2ce1a80481aae7cd354fc8</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>68dcadda632ed995b6b567832109517d</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, Predicate)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>75e87c502d860fe6117061f3c6770c73</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2877f715306091c3bd650e54c6a6b0b8</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4c40a403daa1f7dc870edf1a6ce37881</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6974bb16dfd4e009af01938aba5ee458</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b0c9d2c3ca2cb9a99c4a41c58664ffd4</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e666448cea3b506ff8246d4e382d0926</anchor>
      <arglist>(_IIter, _IIter, _FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8acfb5f3893213233eff8e1a97ad2a93</anchor>
      <arglist>(_IIter, _IIter, _FIter, _FIter, _BiPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f33aa1ab2ef7e5ed23fb6a3d56880f71</anchor>
      <arglist>(_IIter, _IIter, _FIter, _FIter, _BiPredicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_first_of</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>038f5894115e33ab641976b0756f2de4</anchor>
      <arglist>(_IIter, _IIter, _FIter, _FIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_first_of_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f61f78fbbefb7838e2ac95f2ee067e52</anchor>
      <arglist>(_IIter, _IIter, _FIter, _FIter, _BiPredicate, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>find_first_of_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c1d9697f6b0bde397fd0f4e6e66230db</anchor>
      <arglist>(_RAIter, _RAIter, _FIter, _FIter, _BiPredicate, random_access_iterator_tag, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_first_of_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2e304f0bfeb43e96a56f295a705b2273</anchor>
      <arglist>(_IIter, _IIter, _FIter, _FIter, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>78104aa23c00d8d71a1d299493ede81e</anchor>
      <arglist>(_IIter, _IIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>145e720137517d7628e55466e936f103</anchor>
      <arglist>(_IIter, _IIter, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>find_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>813dfd5c571026a19680abc4e536c6f8</anchor>
      <arglist>(_RAIter, _RAIter, _Predicate, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5403d8144709ec397fa7ae2aad0f15ad</anchor>
      <arglist>(_IIter, _IIter, _Predicate, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>331fb06e50f82c5ecc9a0eb898b20783</anchor>
      <arglist>(_RAIter, _RAIter, const _Tp &amp;, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_IIter</type>
      <name>find_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9348d5b1fb48cd0968d9e1feaad1e498</anchor>
      <arglist>(_IIter, _IIter, const _Tp &amp;, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_Function</type>
      <name>for_each</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>148ba5fcb65bc2e862895599fc6d607d</anchor>
      <arglist>(_Iterator, _Iterator, _Function, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Function</type>
      <name>for_each</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4d7d728e1019983b90779b41657c2f8f</anchor>
      <arglist>(_IIter, _IIter, _Function, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Function</type>
      <name>for_each</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c2e28ceb11108a1e4067141d2ee13924</anchor>
      <arglist>(_IIter, _IIter, _Function)</arglist>
    </member>
    <member kind="function">
      <type>_Function</type>
      <name>for_each_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>319142e7b465f8d39fa0476c13cff3ac</anchor>
      <arglist>(_RAIter, _RAIter, _Function, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Function</type>
      <name>for_each_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ba9ef5df8f26ffff0257b2ae89b376c6</anchor>
      <arglist>(_IIter, _IIter, _Function, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5aff0f525713ccd5d25c1fbb447edf7a</anchor>
      <arglist>(_FIter, _FIter, _Generator, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>177a7287bebc9dc6c7297d152d165ba4</anchor>
      <arglist>(_FIter, _FIter, _Generator, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4728d2f7849c3ec17f00664f6fb6b9df</anchor>
      <arglist>(_FIter, _FIter, _Generator)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>generate_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f5fb1ea88c67cc2bf7161a5a3cd9e637</anchor>
      <arglist>(_OIter, _Size, _Generator, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>generate_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>86f85f426b6074342f3f2a82b016bc52</anchor>
      <arglist>(_OIter, _Size, _Generator, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>generate_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>24c1767aa6501342c3b03a6e79155f09</anchor>
      <arglist>(_OIter, _Size, _Generator)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>generate_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>72c86e7b3b9c8008b8decf10232e20d9</anchor>
      <arglist>(_RAIter, _Size, _Generator, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>generate_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>386f42ee0f975e0c6365c96aaa652b86</anchor>
      <arglist>(_OIter, _Size, _Generator, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a0045b4c0fca222b1f46dd75bb6eeed1</anchor>
      <arglist>(_RAIter, _RAIter, _Generator, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>463d131a13f5bce7722cdc22825c789c</anchor>
      <arglist>(_FIter, _FIter, _Generator, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d2e654431ffa2dba34b346b388c2cc96</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b2725f95c10393c1915aa97e924d42db</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7635b3d15462a2476e7ee6493f55b682</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>25e25b0aec500299abaec3568aa734eb</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>03dddf37f0652c9fe8a9fb9fa792be36</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, _Predicate, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e60bcbe759a957f084a09320dd9b8577</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _Predicate, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>22e20b33893a66a95c62e16e98198c52</anchor>
      <arglist>(_FIter, _FIter, _Compare, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3f9d5bca25790307bf347d28f7304870</anchor>
      <arglist>(_FIter, _FIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ad1eeb8da58ae48fadbd1a8ced95d703</anchor>
      <arglist>(_FIter, _FIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>68286478ddebac12fd0b27e6e4a8e51d</anchor>
      <arglist>(_FIter, _FIter, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1aaba84dcb79103deb31d3394e3e73f5</anchor>
      <arglist>(_FIter, _FIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>955eccb02abddf32b647132c0f87ef46</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>max_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cd019c4b00107fa270a2a51bebba6ebc</anchor>
      <arglist>(_RAIter, _RAIter, _Compare, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>max_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9f1b359cbca9d4571c87247fbde0e41c</anchor>
      <arglist>(_FIter, _FIter, _Compare, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d0eac087f5a5567baf9e0a303171841e</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>424900230f2fb1bc43f9db30e5b915f9</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>fe2ab0aaf61a8e463f08d2cc0325e3a5</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>02e87f9c7fc75b46d93a807a73ac4283</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>691aa768d9e9de3d75249ad31d4f686e</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>merge_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>74ae1ce3df6d1a2dbab07ea3733f323a</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Compare, _IterTag1, _IterTag2, _IterTag3)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2aeecb86226d6cc5298169f8da1387c7</anchor>
      <arglist>(_FIter, _FIter, _Compare, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>459b039708383327c6c634d6d9106f27</anchor>
      <arglist>(_FIter, _FIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5355e3514a4828dd4d872094aec94e60</anchor>
      <arglist>(_FIter, _FIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0b72169c70854e23ed751513bc06ceaa</anchor>
      <arglist>(_FIter, _FIter, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>bfd337c9864c468414837dcd87ccdc59</anchor>
      <arglist>(_FIter, _FIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5a881302105a2306eb4a7ebae4fce352</anchor>
      <arglist>(_FIter, _FIter)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>min_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f7261385a01c7d3748787a96c6f60999</anchor>
      <arglist>(_RAIter, _RAIter, _Compare, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>min_element_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8eb357d0a02c4dc22f104c7402fad153</anchor>
      <arglist>(_FIter, _FIter, _Compare, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>02711903d3b9ae4c85b14786b934a5bc</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>06692c7d7eb5c7eae59d1c6673566f7d</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _RAIter1, _RAIter2 &gt;</type>
      <name>mismatch_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4ca0e6eb3495a48ae8641b0e6d3bbed0</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _Predicate, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4fbce068b3f926dc391e32f61404f50d</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>212b8eec952b53da8552621b83e1aa93</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>27d0e3472f4f1bf0a5d7dee5dead406e</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4325a1393082f14117f83b1a7f335d9e</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>dacc8ef9539693de5e9bd5508a4763d2</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b496af9b6f8f9417c4b1ee181e038bb2</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>472771cbcca50ecd2dfa970d3ed51ce3</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>15444076e6f967664d3f5954d4f914ce</anchor>
      <arglist>(_RAIter, _RAIter, _RAIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>partition</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>224b0caf97a36459ab2b7e369cd05815</anchor>
      <arglist>(_FIter, _FIter, Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>partition</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cbdb5788af42cded4bfb502d48b52ccf</anchor>
      <arglist>(_FIter, _FIter, Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>partition_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>af2d4121c2dc24c4c85a6dcf773b2960</anchor>
      <arglist>(_RAIter, _RAIter, Predicate, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>partition_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2052ebd354599971902fac43b68c37dd</anchor>
      <arglist>(_FIter, _FIter, Predicate, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>430268c61c1474dd3ecf8051ace4dfc9</anchor>
      <arglist>(_RAIter, _RAIter, _RandomNumberGenerator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>fb0aeaa76f17cd9639c2570b4aa9b523</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>955d2e6c257ea955436c506876c8d185</anchor>
      <arglist>(_RAIter, _RAIter, _RandomNumberGenerator &amp;, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0267ea3212827ba3806b2099d5737f97</anchor>
      <arglist>(_RAIter, _RAIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ebb35fc88946d4b2079cd38f72937feb</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, const _Tp &amp;, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5af9f1a9ea98b8af5493f6941bb580cd</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, const _Tp &amp;, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e75cee7d6725f7addba5ee08492b7a60</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>47398f429418116b3cb63218d728f3a8</anchor>
      <arglist>(_FIter, _FIter, _Predicate, const _Tp &amp;, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d25d3e939693feba12101c58c739a201</anchor>
      <arglist>(_FIter, _FIter, _Predicate, const _Tp &amp;, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9fcb50f207ae0de7dd9eecb9d76dd457</anchor>
      <arglist>(_FIter, _FIter, _Predicate, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1297bab73e7c8e4df87416c912fc1c8a</anchor>
      <arglist>(_RAIter, _RAIter, _Predicate, const _Tp &amp;, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>932bfdc4f5f322779abb48500113a9d4</anchor>
      <arglist>(_FIter, _FIter, _Predicate, const _Tp &amp;, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5c4f12cdf1196983606d44876aed97d4</anchor>
      <arglist>(_RAIter, _RAIter, const _Tp &amp;, const _Tp &amp;, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>aec22deb574d73a289edd04eabc7f68e</anchor>
      <arglist>(_FIter, _FIter, const _Tp &amp;, const _Tp &amp;, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cd2ce36344f52f967e28834f86542e9f</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _BiPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4918c874d06b373be500bb282fbf4d1a</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _BiPredicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f90d35a8fd6d4b9b2833348962b41fd4</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c2a2daecf8f69e99ad0dfa729bb958ad</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5809ff0b8328f7bb68dcb2b5fee58153</anchor>
      <arglist>(_FIter, _FIter, _Integer, const _Tp &amp;, _BiPredicate)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2b4664fd7a46df1a037fa6e47a1c9b64</anchor>
      <arglist>(_FIter, _FIter, _Integer, const _Tp &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>bd46d50d24ee79c05df28b8d34af0e64</anchor>
      <arglist>(_FIter, _FIter, _Integer, const _Tp &amp;, _BiPredicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>048699a579f9b646f13fa9f1cee08279</anchor>
      <arglist>(_FIter, _FIter, _Integer, const _Tp &amp;, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter</type>
      <name>search_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>faae5f38403376b9b98fa627c35e84d3</anchor>
      <arglist>(_FIter, _FIter, _Integer, const _Tp &amp;, _BiPredicate, _IterTag)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>search_n_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>445942da74f7150ac2b21162eccc919f</anchor>
      <arglist>(_RAIter, _RAIter, _Integer, const _Tp &amp;, _BiPredicate, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>fe9cc4c76c86e1e08094037dbc79e25b</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _BiPredicate, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>23d80ca6e19718ac0d986524368912a5</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, _BiPredicate, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_FIter1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8a778532eff495b8eac7e30a1be38bd8</anchor>
      <arglist>(_FIter1, _FIter1, _FIter2, _FIter2, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter1</type>
      <name>search_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e19d651cc842dc527cd0b22a9ed3d42e</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3fa4af447ed2d8795020eb28e801dbb2</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>00cfc8fa0a4668561b537b16f82768b2</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>af8b61f616a83583ef770ce1a3affcbc</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>12e426955864d60d1e531e0d7d66decf</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Output_RAIter</type>
      <name>set_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a1e200486a3790f46efad640ed207557</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, _Output_RAIter, _Predicate, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>676b11996e09176288f2b3937f3797cc</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, _IterTag1, _IterTag2, _IterTag3)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>457046cc79c41cff5d1b9db20c8d8b72</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>02d35f0544490eb374f95bbeb3c9188d</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>fd4e9d1059ddf882a384dfc413570b05</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c6089c35e73337a8f5acdb70dc756492</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Output_RAIter</type>
      <name>set_intersection_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3f9283fb8b8cc31a4f24531b0c0937cb</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, _Output_RAIter, _Predicate, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_intersection_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>128b5e100115e16a42f8f4f75f8a1d67</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, _IterTag1, _IterTag2, _IterTag3)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1a53a42650dd9c40f3c0eb944e32a3b7</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b982ed8a6711f9acf3ec0b858ed0e31d</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>862bfaca5b9948457cba0e2cd71fbbe8</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2766dd64d823c5afaba2ea9763dd9faf</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Output_RAIter</type>
      <name>set_symmetric_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c41047e509adc7118d8fa973d2a6c80b</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, _Output_RAIter, _Predicate, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_symmetric_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>84216b934bcfbb540a6c502a14ae75a9</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, _IterTag1, _IterTag2, _IterTag3)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d22e75f7edbe474b9b7751a441e25be0</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5783c28c49ea744b132cbb65a521993d</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>71b624e480b15e1c536a962e834c855c</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e3d82f28dc680423e5552db2146f12f1</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Output_RAIter</type>
      <name>set_union_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>fe166275cfb6a57c5fa529ea0087f8f5</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter2, _Output_RAIter, _Predicate, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>set_union_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c90bc2be1b502db06be65c86d6aa1f5e</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _IIter2, _OIter, _Predicate, _IterTag1, _IterTag2, _IterTag3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c2ebb0ecdbc0ac51cdea8d8792ad8657</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3db037539d8a0cbbeb1b94a460cf183c</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6b1ef0be816a3a102d2617b4bd830a67</anchor>
      <arglist>(_RAIter, _RAIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>53c2713d8e4d7f7f4c7dbe5a05c34058</anchor>
      <arglist>(_RAIter, _RAIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8207c1a1e9050deeede866f98a62612d</anchor>
      <arglist>(_RAIter, _RAIter, _Compare)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4f1302a9f820760868a82436ff7fadff</anchor>
      <arglist>(_RAIter, _RAIter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1dcf6f7c29c3144e2f6c9a30952b47e4</anchor>
      <arglist>(_RAIter, _RAIter, _Compare, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6262b6bf5f0f407e609b96d911fd7e66</anchor>
      <arglist>(_RAIter, _RAIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>190e5571593a59eab7faffe5d48f29ee</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _OIter, _BiOperation, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7fa548696a92453bb5ada4b1a38af6f2</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _OIter, _BiOperation, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ac99177f13a564b22b3afea9662b98c5</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _OIter, _BiOperation)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4cd19a615e6221d0bc0673eb2d80fd66</anchor>
      <arglist>(_IIter, _IIter, _OIter, UnaryOperation, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e035f955ef9091493ac4ce703a5e5a7e</anchor>
      <arglist>(_IIter, _IIter, _OIter, UnaryOperation, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ca9914f96287a39fb9c8aebd9148ef39</anchor>
      <arglist>(_IIter, _IIter, _OIter, UnaryOperation)</arglist>
    </member>
    <member kind="function">
      <type>_RAOIter</type>
      <name>transform1_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d4e0f0af2c64f9be46991ab3a0bc23b0</anchor>
      <arglist>(_RAIIter, _RAIIter, _RAOIter, UnaryOperation, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform1_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4176e49b2b3b3075fe4b70a1cc85b22c</anchor>
      <arglist>(_IIter, _IIter, _OIter, UnaryOperation, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>transform2_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>439727350a689ff1e5ef2b1bc1a29034</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _OIter, _BiOperation, _Tag1, _Tag2, _Tag3)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter3</type>
      <name>transform2_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>03969c2b1ec65a589844a53d31b1a975</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _RAIter3, _BiOperation, random_access_iterator_tag, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e48cab1fb443e158cd5ae8ad56a96502</anchor>
      <arglist>(_IIter, _IIter, _OIter, _Predicate)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>77663ea15bcd19d1e38665850486e2b5</anchor>
      <arglist>(_IIter, _IIter, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9b656a0d00000d333178c01d27657ef1</anchor>
      <arglist>(_IIter, _IIter, _OIter, _Predicate, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3ab629e0c7791c4a6cb227a2c416f5b9</anchor>
      <arglist>(_IIter, _IIter, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccess_OIter</type>
      <name>unique_copy_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9545d04b0de98c965eef9ed5c00320fe</anchor>
      <arglist>(_RAIter, _RAIter, _RandomAccess_OIter, _Predicate, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>unique_copy_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f1e79b3f3cbab2ce6b56ba1be5f5b623</anchor>
      <arglist>(_IIter, _IIter, _OIter, _Predicate, _IterTag1, _IterTag2)</arglist>
    </member>
    <member kind="variable">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a9be0331ed7493ab761597c2826b36ac</anchor>
      <arglist>(_IIter, _IIter, _Predicate, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="variable">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f9d807640bc801b9911f13587c6096ea</anchor>
      <arglist>(_IIter, _IIter, _Predicate)</arglist>
    </member>
    <member kind="variable">
      <type>iterator_traits&lt; _IIter &gt;::difference_type</type>
      <name>count_if_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>4e71bd47a9c252510f7c89c63b1453ee</anchor>
      <arglist>(_IIter, _IIter, _Predicate, _IterTag)</arglist>
    </member>
    <member kind="variable">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3ff1ad459a1cddf0634df53d9d8d80de</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Predicate)</arglist>
    </member>
    <member kind="variable">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>74a5bb612140f5098fb69115454552ef</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2)</arglist>
    </member>
    <member kind="variable">
      <type>pair&lt; _IIter1, _IIter2 &gt;</type>
      <name>mismatch_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a82df1d15b4181bb53a376ddcac681ad</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Predicate, _IterTag1, _IterTag2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>allocator.h</name>
    <filename>a01328</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__alloc_neq</class>
    <class kind="struct">std::__alloc_neq&lt; _Alloc, false &gt;</class>
    <class kind="struct">std::__alloc_swap</class>
    <class kind="struct">std::__alloc_swap&lt; _Alloc, false &gt;</class>
    <class kind="class">std::allocator</class>
    <class kind="struct">std::allocator::rebind</class>
    <class kind="class">std::allocator&lt; void &gt;</class>
    <class kind="struct">std::allocator&lt; void &gt;::rebind</class>
    <member kind="define">
      <type>#define</type>
      <name>_ALLOCATOR_H</name>
      <anchorfile>a01328.html</anchorfile>
      <anchor>6c5710bb67b482d49c747b85ef75f51d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b5b305c9144395e51ccee20314578499</anchor>
      <arglist>(const allocator&lt; _Tp &gt; &amp;, const allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>711bb4787a7efe21367d64cd8c4204c9</anchor>
      <arglist>(const allocator&lt; _T1 &gt; &amp;, const allocator&lt; _T2 &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>399f6d5bef0809dc1e16052f731c3ec3</anchor>
      <arglist>(const allocator&lt; _Tp &gt; &amp;, const allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b63d3a928a7655724c650a20ab018324</anchor>
      <arglist>(const allocator&lt; _T1 &gt; &amp;, const allocator&lt; _T2 &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>array</name>
    <filename>a01329</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX0X_ARRAY</name>
      <anchorfile>a01329.html</anchorfile>
      <anchor>5e23f844ffd683dc68d28b4b0e4a63c4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/array</name>
    <filename>a01330</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01330.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01330.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01330.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01330.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_ARRAY</name>
      <anchorfile>a01330.html</anchorfile>
      <anchor>5c08e2196e0b19503ef81c419daec4ba</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/array</name>
    <filename>a01331</filename>
    <namespace>std</namespace>
    <class kind="struct">std::array</class>
    <class kind="struct">std::tuple_element&lt; _Int, array&lt; _Tp, _Nm &gt; &gt;</class>
    <class kind="struct">std::tuple_size&lt; array&lt; _Tp, _Nm &gt; &gt;</class>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>get</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>44f34bff865a4af7184693a08921113e</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__arr)</arglist>
    </member>
    <member kind="function">
      <type>_Tp &amp;</type>
      <name>get</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7c45c2a32a0c28baec59d7a46c546f2c</anchor>
      <arglist>(array&lt; _Tp, _Nm &gt; &amp;__arr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c87d421b5f2f8787792d8ce08e3b1ca0</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__one, const array&lt; _Tp, _Nm &gt; &amp;__two)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>752da31bd7264b85158092835106be83</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__a, const array&lt; _Tp, _Nm &gt; &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b3c1a5030a605f9bb3468be5882066a7</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__one, const array&lt; _Tp, _Nm &gt; &amp;__two)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>855f84c482965dc03da461b0a669a7c4</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__one, const array&lt; _Tp, _Nm &gt; &amp;__two)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>596c06a6320f7a7b7a6204f67784b17f</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__one, const array&lt; _Tp, _Nm &gt; &amp;__two)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6bd0e3b39639c11d72e6514fa71cab9c</anchor>
      <arglist>(const array&lt; _Tp, _Nm &gt; &amp;__one, const array&lt; _Tp, _Nm &gt; &amp;__two)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>530c2b4366559e68322f9de5645a2769</anchor>
      <arglist>(array&lt; _Tp, _Nm &gt; &amp;__one, array&lt; _Tp, _Nm &gt; &amp;__two)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>array_allocator.h</name>
    <filename>a01332</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::array_allocator</class>
    <class kind="struct">__gnu_cxx::array_allocator::rebind</class>
    <class kind="class">__gnu_cxx::array_allocator_base</class>
    <member kind="define">
      <type>#define</type>
      <name>_ARRAY_ALLOCATOR_H</name>
      <anchorfile>a01332.html</anchorfile>
      <anchor>0147870f6106d6aabda4e7f32ae56fab</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6b857cc04569243502c2a73e8ab49c42</anchor>
      <arglist>(const array_allocator&lt; _Tp, _Array &gt; &amp;, const array_allocator&lt; _Tp, _Array &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c2648ae674a38ca6fa2c5b4ca41a8bcc</anchor>
      <arglist>(const array_allocator&lt; _Tp, _Array &gt; &amp;, const array_allocator&lt; _Tp, _Array &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>assoc_container.hpp</name>
    <filename>a01333</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="class">__gnu_pbds::basic_hash_table</class>
    <class kind="class">__gnu_pbds::basic_tree</class>
    <class kind="class">__gnu_pbds::cc_hash_table</class>
    <class kind="class">__gnu_pbds::container_base</class>
    <class kind="class">__gnu_pbds::gp_hash_table</class>
    <class kind="class">__gnu_pbds::list_update</class>
    <class kind="class">__gnu_pbds::tree</class>
    <class kind="class">__gnu_pbds::trie</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>2ab180816e73cd2b7b36b04999593412</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>2ab180816e73cd2b7b36b04999593412</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>2ab180816e73cd2b7b36b04999593412</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_TREE_NODE_AND_IT_TRAITS_C_DEC</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>e48cf98166c4ab9cd0a72cd287b3e456</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_TRIE_NODE_AND_ITS_TRAITS</name>
      <anchorfile>a01333.html</anchorfile>
      <anchor>41f79fa4f2713fccc2148e1896f495a0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>atomic_word.h</name>
    <filename>a01334</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ATOMIC_WORD_H</name>
      <anchorfile>a01334.html</anchorfile>
      <anchor>eda4a1907b0cada1e9e99e5a0a835e65</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>_Atomic_word</name>
      <anchorfile>a01334.html</anchorfile>
      <anchor>04db2e783c73d9ec2ea01e9c1aea16dd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>atomicity.h</name>
    <filename>a01335</filename>
    <namespace>__gnu_cxx</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ATOMICITY_H</name>
      <anchorfile>a01335.html</anchorfile>
      <anchor>fb6bca7cfa13757029b3081a3a7c8be3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_READ_MEM_BARRIER</name>
      <anchorfile>a01335.html</anchorfile>
      <anchor>dc8541dc7ed746a55039e35bafd10114</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_WRITE_MEM_BARRIER</name>
      <anchorfile>a01335.html</anchorfile>
      <anchor>5d014ed443d5081ccb36b0c5ab0831e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>__atomic_add_single</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>f77d3eb9ba89bd3ded4fd9bacf422ede</anchor>
      <arglist>(_Atomic_word *__mem, int __val)</arglist>
    </member>
    <member kind="function">
      <type>_Atomic_word</type>
      <name>__attribute__</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c7647159353b5973f6aaa63d2e60deef</anchor>
      <arglist>((__unused__)) __exchange_and_add(volatile _Atomic_word *</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static _Atomic_word</type>
      <name>__exchange_and_add_single</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>bb502e8a43e153c8e2ef3745aadf11f2</anchor>
      <arglist>(_Atomic_word *__mem, int __val)</arglist>
    </member>
    <member kind="variable">
      <type>void</type>
      <name>int</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>9dc3f70c22ead245eef9db177eda5495</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>_Atomic_word</type>
      <name>int</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>3fe277c31d1adb8ad44f63b465f3246c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>auto_ptr.h</name>
    <filename>a01336</filename>
    <namespace>std</namespace>
    <class kind="class">std::auto_ptr</class>
    <class kind="class">std::auto_ptr&lt; void &gt;</class>
    <class kind="struct">std::auto_ptr_ref</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_AUTO_PTR_H</name>
      <anchorfile>a01336.html</anchorfile>
      <anchor>4c937fc9254f254c2af36cf9edc2e870</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::auto_ptr&lt; void &gt;</type>
      <name>_GLIBCXX_DEPRECATED_ATTR</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e119b5971e35358a5a3bbc3a7e767198</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::auto_ptr</type>
      <name>_GLIBCXX_DEPRECATED_ATTR</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f446867cb7b8a797ea06d9cec6ad31d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::auto_ptr_ref</type>
      <name>_GLIBCXX_DEPRECATED_ATTR</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0fd24f7d6b8b24a815054e463ec70a92</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>balanced_quicksort.h</name>
    <filename>a01338</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::QSBThreadLocal</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_BAL_QUICKSORT_H</name>
      <anchorfile>a01338.html</anchorfile>
      <anchor>9f60a9b82fd870abb4de568d3fff0829</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_sort_qsb</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f3cbd0fee84a615caed0dd29f5f8daa6</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type n, thread_index_t num_threads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>qsb_conquer</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>d4fb1e78dc125621ff3abec9f5df0896</anchor>
      <arglist>(QSBThreadLocal&lt; RandomAccessIterator &gt; **tls, RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, thread_index_t iam, thread_index_t num_threads, bool parent_wait)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type</type>
      <name>qsb_divide</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>9c2f5d61eeac857c14a4b2b510d0f997</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, thread_index_t num_threads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>qsb_local_sort_with_helping</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>6b0e5fd8d5c642c349dfe2d855e1b10d</anchor>
      <arglist>(QSBThreadLocal&lt; RandomAccessIterator &gt; **tls, Comparator &amp;comp, int iam, bool wait)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>base.h</name>
    <filename>a01339</filename>
    <namespace>__gnu_parallel</namespace>
    <namespace>__gnu_sequential</namespace>
    <namespace>std</namespace>
    <namespace>std::__parallel</namespace>
    <class kind="class">__gnu_parallel::binder1st</class>
    <class kind="class">__gnu_parallel::binder2nd</class>
    <class kind="class">__gnu_parallel::equal_from_less</class>
    <class kind="struct">__gnu_parallel::equal_to</class>
    <class kind="struct">__gnu_parallel::less</class>
    <class kind="struct">__gnu_parallel::less&lt; _Tp, _Tp &gt;</class>
    <class kind="struct">__gnu_parallel::multiplies</class>
    <class kind="struct">__gnu_parallel::multiplies&lt; _Tp, _Tp &gt;</class>
    <class kind="struct">__gnu_parallel::plus</class>
    <class kind="struct">__gnu_parallel::plus&lt; _Tp, _Tp &gt;</class>
    <class kind="class">__gnu_parallel::pseudo_sequence</class>
    <class kind="class">__gnu_parallel::pseudo_sequence_iterator</class>
    <class kind="class">__gnu_parallel::unary_negate</class>
    <class kind="class">__gnu_parallel::void_functor</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_ASSERT</name>
      <anchorfile>a01339.html</anchorfile>
      <anchor>5a636f52c230b0321f314e0096f19c68</anchor>
      <arglist>(_Condition)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_BASE_H</name>
      <anchorfile>a01339.html</anchorfile>
      <anchor>4a5c8284aa91d3e461181262ed7418ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__replacement_assert</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>1ccebb188e1e5badafd0fb4e60de4ef1</anchor>
      <arglist>(const char *__file, int __line, const char *__function, const char *__condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decode2</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>9fd529a3d5fcc2893087037eca39ae0b</anchor>
      <arglist>(lcas_t x, int &amp;a, int &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>lcas_t</type>
      <name>encode2</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>c79ad2f6361b116e78e5d2274a045b9f</anchor>
      <arglist>(int a, int b)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_max_threads</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>83ce3eea6765a05935092c07e8e5a78b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_parallel</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>9d5c1fdc25af6b5dc9e5a67ad2e4447b</anchor>
      <arglist>(const _Parallelism __p)</arglist>
    </member>
    <member kind="function">
      <type>Size</type>
      <name>log2</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8c4e7f5a437cb4b1ccc2357f0c7d3d83</anchor>
      <arglist>(Size n)</arglist>
    </member>
    <member kind="function">
      <type>const T &amp;</type>
      <name>max</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>fe969822696d91c73bc0001206987d8b</anchor>
      <arglist>(const T &amp;a, const T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator</type>
      <name>median_of_three_iterators</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>10fed76efda80af27bcdbff1525425c2</anchor>
      <arglist>(RandomAccessIterator a, RandomAccessIterator b, RandomAccessIterator c, Comparator &amp;comp)</arglist>
    </member>
    <member kind="function">
      <type>const T &amp;</type>
      <name>min</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>334828a69fab62c3cd7499b4fe1f15ad</anchor>
      <arglist>(const T &amp;a, const T &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_file.h</name>
    <filename>a01340</filename>
    <namespace>std</namespace>
    <class kind="class">std::__basic_file&lt; char &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BASIC_FILE_STDIO_H</name>
      <anchorfile>a01340.html</anchorfile>
      <anchor>00d36de0bbf4a5e0d878a29bc6ae50bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_ios.h</name>
    <filename>a01341</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_ios</class>
    <member kind="define">
      <type>#define</type>
      <name>_BASIC_IOS_H</name>
      <anchorfile>a01341.html</anchorfile>
      <anchor>8aa287c3a4903187da2eb6cbbb2b7256</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const _Facet &amp;</type>
      <name>__check_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a959484b98a872baf89a986782e35a8b</anchor>
      <arglist>(const _Facet *__f)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_ios.tcc</name>
    <filename>a01342</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_BASIC_IOS_TCC</name>
      <anchorfile>a01342.html</anchorfile>
      <anchor>c66ed27bd73a57edccb18696737b7f22</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_iterator.h</name>
    <filename>a01343</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_BASIC_ITERATOR_H</name>
      <anchorfile>a01343.html</anchorfile>
      <anchor>c4336791c1ab9bc956849482e30e4c95</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_string.h</name>
    <filename>a01344</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_string</class>
    <member kind="define">
      <type>#define</type>
      <name>_BASIC_STRING_H</name>
      <anchorfile>a01344.html</anchorfile>
      <anchor>bc4a465b4deca9217e88a7fcde742178</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; wchar_t &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>123f13727e88ad84e174027800206bbf</anchor>
      <arglist>(basic_istream&lt; wchar_t &gt; &amp;__in, basic_string&lt; wchar_t &gt; &amp;__str, wchar_t __delim)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6a3714f85ceef10a7d3951061bd4a4c6</anchor>
      <arglist>(basic_istream&lt; char &gt; &amp;__in, basic_string&lt; char &gt; &amp;__str, char __delim)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>81138c3d2139ecf57f4c90f09f982715</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5bd383686039267c537e20d77abcf8ab</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__str, _CharT __delim)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bb977262f9679366decef58f665cf3b9</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4ab63341966e58f6dd193e2e33c7f7a9</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>10e305c020e53e852b26071f3bb6b20e</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>61b53f48eb706b68638229547918f04f</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, _CharT __rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7595cf442e1a85ee424ada2e7ef2aa7a</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0fa81a122077152c5d56821ffbf9adbe</anchor>
      <arglist>(_CharT __lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f2e93b1fe0f746c351d0c2810764f83e</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>02986e4fedc730003537640a0cb40ded</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7934a7fb2b4a71187df2923a7af39f16</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6a1bc7ce7405e867c138424586306d57</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>38c83b3808ed6d67d4da265ef4d56300</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>88b30a4b481dfaee995ca60ad4bf2d41</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>82e0e23477943c901dde8b5055b14351</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>98dd990cdc73588576b66fc0110c6251</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fca3d711f601ebb951ea5ee58c92bdef</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d47aed4eeaa40f69b99cbd22e63c49b6</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6432d3de7ee824a65c5916de79bc139a</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, bool &gt;::__type</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d0e9eb44d00102e33dc754de44b08559</anchor>
      <arglist>(const basic_string&lt; _CharT &gt; &amp;__lhs, const basic_string&lt; _CharT &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ffa36606a3ec665a52a24b6c67645004</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>57c033e1dc93f4588c08be3c48d3e516</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b2545a40385fe71257f95f07a47f56e3</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>83d302f85f74ad9fd2a98ac787cd5982</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e4c8541a1dc69bf35d4e809ef03eabaa</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e77e07f7bde55034b59d9bad9f3230d</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ecb2dbad97e32ab4766b858dca0ffc7e</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>99c46fa750044f9e99a61090e79e64ac</anchor>
      <arglist>(basic_istream&lt; char &gt; &amp;__is, basic_string&lt; char &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>310ec66c60d272a9c7c084a4088f99b9</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5428f0590b8890f5b3c38f21685eda99</anchor>
      <arglist>(basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__lhs, basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_string.tcc</name>
    <filename>a01345</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_BASIC_STRING_TCC</name>
      <anchorfile>a01345.html</anchorfile>
      <anchor>692f5e71ce5c0ed5579c6e8190560b19</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5bd383686039267c537e20d77abcf8ab</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__str, _CharT __delim)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0fa81a122077152c5d56821ffbf9adbe</anchor>
      <arglist>(_CharT __lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f2e93b1fe0f746c351d0c2810764f83e</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>310ec66c60d272a9c7c084a4088f99b9</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Alloc &gt; &amp;__str)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>basic_types.hpp</name>
    <filename>a01346</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="struct">__gnu_pbds::detail::no_throw_copies</class>
    <class kind="struct">__gnu_pbds::detail::no_throw_copies&lt; Key, null_mapped_type &gt;</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, Mapped, Allocator, false &gt;</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, Mapped, Allocator, false &gt;::stored_value_type</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, Mapped, Allocator, true &gt;</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, Mapped, Allocator, true &gt;::stored_value_type</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, null_mapped_type, Allocator, false &gt;</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, null_mapped_type, Allocator, false &gt;::stored_value_type</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, null_mapped_type, Allocator, true &gt;</class>
    <class kind="struct">__gnu_pbds::detail::value_type_base&lt; Key, null_mapped_type, Allocator, true &gt;::stored_value_type</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01346.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01346.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01346.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01346.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bessel_function.tcc</name>
    <filename>a01347</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_BESSEL_FUNCTION_TCC</name>
      <anchorfile>a01347.html</anchorfile>
      <anchor>e9dce5001be3ba29866ad9a69dac9826</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__bessel_jn</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>48e0da7c9f6d88fecc454fba4e83dd0b</anchor>
      <arglist>(const _Tp __nu, const _Tp __x, _Tp &amp;__Jnu, _Tp &amp;__Nnu, _Tp &amp;__Jpnu, _Tp &amp;__Npnu)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cyl_bessel_ij_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>01aeb3aa64317d03f1f70591948882dd</anchor>
      <arglist>(const _Tp __nu, const _Tp __x, const _Tp __sgn, const unsigned int __max_iter)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cyl_bessel_j</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>7801f9da216e4198e18a03a2c77ac3b7</anchor>
      <arglist>(const _Tp __nu, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cyl_bessel_jn_asymp</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>a69f0968483a20ae2d01703015ab2ed0</anchor>
      <arglist>(const _Tp __nu, const _Tp __x, _Tp &amp;__Jnu, _Tp &amp;__Nnu)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cyl_neumann_n</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>4902f90927444f1b443a511e1bb65aca</anchor>
      <arglist>(const _Tp __nu, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__gamma_temme</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>827d714f2a740cbcd5d9237f823cc6b5</anchor>
      <arglist>(const _Tp __mu, _Tp &amp;__gam1, _Tp &amp;__gam2, _Tp &amp;__gampl, _Tp &amp;__gammi)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__sph_bessel</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>7a0dc62e9df9d4753ffe8eb996a30d42</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__sph_bessel_jn</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>de21056989387e74df081e48133d6df0</anchor>
      <arglist>(const unsigned int __n, const _Tp __x, _Tp &amp;__j_n, _Tp &amp;__n_n, _Tp &amp;__jp_n, _Tp &amp;__np_n)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__sph_neumann</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>cb8604c7792f03761702261f735c2e5d</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>beta_function.tcc</name>
    <filename>a01348</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_BETA_FUNCTION_TCC</name>
      <anchorfile>a01348.html</anchorfile>
      <anchor>9a25a11e51dbb908fff5b25cba455da7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__beta</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>c77b5845d6146ec3bce9a66fd19e6be7</anchor>
      <arglist>(_Tp __x, _Tp __y)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__beta_gamma</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>161bb04cca910484ad6231a12ca32a66</anchor>
      <arglist>(_Tp __x, _Tp __y)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__beta_lgamma</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>e3ad3888a39f74f7ccdb8b705f75a45f</anchor>
      <arglist>(_Tp __x, _Tp __y)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__beta_product</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>6fb5bc7f77bc88592fb150859e5c9840</anchor>
      <arglist>(_Tp __x, _Tp __y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>binders.h</name>
    <filename>a01349</filename>
    <namespace>std</namespace>
    <class kind="class">std::binder1st</class>
    <class kind="class">std::binder2nd</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BINDERS_H</name>
      <anchorfile>a01349.html</anchorfile>
      <anchor>4c2c232b64c376a6869b6f79cd14e8b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>binder1st&lt; _Operation &gt;</type>
      <name>bind1st</name>
      <anchorfile>a01709.html</anchorfile>
      <anchor>gdd39a86bd7ec39ff0189f5d4812a42a7</anchor>
      <arglist>(const _Operation &amp;__fn, const _Tp &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>binder2nd&lt; _Operation &gt;</type>
      <name>bind2nd</name>
      <anchorfile>a01709.html</anchorfile>
      <anchor>g39e5d66d070b8d95e82fefb1080bcc63</anchor>
      <arglist>(const _Operation &amp;__fn, const _Tp &amp;__x)</arglist>
    </member>
    <member kind="variable">
      <type>std::binder2nd</type>
      <name>_GLIBCXX_DEPRECATED_ATTR</name>
      <anchorfile>a01709.html</anchorfile>
      <anchor>gd5ed2cf39565d105c844063d8f4e1017</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::binder1st</type>
      <name>_GLIBCXX_DEPRECATED_ATTR</name>
      <anchorfile>a01709.html</anchorfile>
      <anchor>g94ce43f76ba55443cca37af4a4c6266d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bitmap_allocator.h</name>
    <filename>a01350</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>__gnu_cxx::__detail</namespace>
    <class kind="class">__gnu_cxx::__detail::__mini_vector</class>
    <class kind="struct">__gnu_cxx::__detail::__mv_iter_traits</class>
    <class kind="struct">__gnu_cxx::__detail::__mv_iter_traits&lt; _Tp * &gt;</class>
    <class kind="class">__gnu_cxx::__detail::_Bitmap_counter</class>
    <class kind="class">__gnu_cxx::__detail::_Ffit_finder</class>
    <class kind="class">__gnu_cxx::__detail::_Functor_Ref</class>
    <class kind="class">__gnu_cxx::__detail::_Inclusive_between</class>
    <class kind="class">__gnu_cxx::bitmap_allocator</class>
    <class kind="struct">__gnu_cxx::bitmap_allocator::rebind</class>
    <class kind="class">__gnu_cxx::bitmap_allocator&lt; void &gt;</class>
    <class kind="struct">__gnu_cxx::bitmap_allocator&lt; void &gt;::rebind</class>
    <class kind="class">__gnu_cxx::free_list</class>
    <member kind="define">
      <type>#define</type>
      <name>_BALLOC_ALIGN_BYTES</name>
      <anchorfile>a01350.html</anchorfile>
      <anchor>25cd3ec612ee958210cb33b14ae7e368</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_BITMAP_ALLOCATOR_H</name>
      <anchorfile>a01350.html</anchorfile>
      <anchor>50862c7adcfddac4948f187e6633900e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__bit_allocate</name>
      <anchorfile>a01687.html</anchorfile>
      <anchor>2ed653073f9d9019a0795639dad8b1c1</anchor>
      <arglist>(size_t *__pbmap, size_t __pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__bit_free</name>
      <anchorfile>a01687.html</anchorfile>
      <anchor>240847aaf1b57709bbc028d705812932</anchor>
      <arglist>(size_t *__pbmap, size_t __pos)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>__find_if</name>
      <anchorfile>a01687.html</anchorfile>
      <anchor>f0c4ec7d4e9c88d2e74bc4bc5aef3b5c</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Predicate __p)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__lower_bound</name>
      <anchorfile>a01687.html</anchorfile>
      <anchor>b3d1c549312c55791bbdee8385284ebe</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>__num_bitmaps</name>
      <anchorfile>a01687.html</anchorfile>
      <anchor>fb492b86d5791ca6900563523d920528</anchor>
      <arglist>(_AddrPair __ap)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>__num_blocks</name>
      <anchorfile>a01687.html</anchorfile>
      <anchor>29b746765caaf81f84ed17ffb7db8cb8</anchor>
      <arglist>(_AddrPair __ap)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>_Bit_scan_forward</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>65f1a5d8eb0e91ef8cc544a643a18a7e</anchor>
      <arglist>(size_t __num)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a9c539b60252aa9962245283c3200b3b</anchor>
      <arglist>(const bitmap_allocator&lt; _Tp1 &gt; &amp;, const bitmap_allocator&lt; _Tp2 &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>98b350269e8ac64a9f16dca55179649b</anchor>
      <arglist>(const bitmap_allocator&lt; _Tp1 &gt; &amp;, const bitmap_allocator&lt; _Tp2 &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bitset</name>
    <filename>a01351</filename>
    <namespace>std</namespace>
    <class kind="struct">std::_Base_bitset</class>
    <class kind="struct">std::_Base_bitset&lt; 0 &gt;</class>
    <class kind="struct">std::_Base_bitset&lt; 1 &gt;</class>
    <class kind="struct">std::_Sanitize</class>
    <class kind="struct">std::_Sanitize&lt; 0 &gt;</class>
    <class kind="class">std::bitset</class>
    <class kind="class">std::bitset::reference</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BITSET</name>
      <anchorfile>a01351.html</anchorfile>
      <anchor>8e25d47691747cf7f8a18be38d4e271b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BITSET_BITS_PER_WORD</name>
      <anchorfile>a01351.html</anchorfile>
      <anchor>6121e7a670973272b81398a5eb3f1228</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BITSET_WORDS</name>
      <anchorfile>a01351.html</anchorfile>
      <anchor>85fc26bb26bb8337b44dc9617a298a59</anchor>
      <arglist>(__n)</arglist>
    </member>
    <member kind="function">
      <type>bitset&lt; _Nb &gt;</type>
      <name>operator &amp;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c6e1a88c265275c76b6500f1ea7818ea</anchor>
      <arglist>(const bitset&lt; _Nb &gt; &amp;__x, const bitset&lt; _Nb &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bitset&lt; _Nb &gt;</type>
      <name>operator^</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>603f60f3be8ca2db05b5e587ba6c86a0</anchor>
      <arglist>(const bitset&lt; _Nb &gt; &amp;__x, const bitset&lt; _Nb &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bitset&lt; _Nb &gt;</type>
      <name>operator|</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c95bf8305661643403ed2fe40822ba80</anchor>
      <arglist>(const bitset&lt; _Nb &gt; &amp;__x, const bitset&lt; _Nb &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a275ad073c93a5f37ffbf9f6dbdcecfc</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const bitset&lt; _Nb &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>06cddd2c65eddeccf74c219a15ddb32b</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, bitset&lt; _Nb &gt; &amp;__x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/bitset</name>
    <filename>a01352</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::bitset</class>
    <class kind="class">std::__debug::bitset::reference</class>
    <member kind="function">
      <type>bitset&lt; _Nb &gt;</type>
      <name>operator &amp;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b26af1f5e985a57b5657bdfeb6895b7e</anchor>
      <arglist>(const bitset&lt; _Nb &gt; &amp;__x, const bitset&lt; _Nb &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>cf8639f8c86b797c495a29bba69bfc61</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const bitset&lt; _Nb &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>157c466590244ccd858e9bf92e240de8</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, bitset&lt; _Nb &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>bitset&lt; _Nb &gt;</type>
      <name>operator^</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b3414c1a86b6003eb76a389432dae01a</anchor>
      <arglist>(const bitset&lt; _Nb &gt; &amp;__x, const bitset&lt; _Nb &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bitset&lt; _Nb &gt;</type>
      <name>operator|</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>81c854ee14a4fa369335c16992995792</anchor>
      <arglist>(const bitset&lt; _Nb &gt; &amp;__x, const bitset&lt; _Nb &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>boost_concept_check.h</name>
    <filename>a01353</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::_AssignableConcept</class>
    <class kind="struct">__gnu_cxx::_Aux_require_same</class>
    <class kind="struct">__gnu_cxx::_Aux_require_same&lt; _Tp, _Tp &gt;</class>
    <class kind="struct">__gnu_cxx::_BackInsertionSequenceConcept</class>
    <class kind="struct">__gnu_cxx::_BidirectionalIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_BinaryFunctionConcept</class>
    <class kind="struct">__gnu_cxx::_BinaryFunctionConcept&lt; _Func, void, _First, _Second &gt;</class>
    <class kind="struct">__gnu_cxx::_BinaryPredicateConcept</class>
    <class kind="struct">__gnu_cxx::_ComparableConcept</class>
    <class kind="struct">__gnu_cxx::_Const_BinaryPredicateConcept</class>
    <class kind="struct">__gnu_cxx::_ContainerConcept</class>
    <class kind="struct">__gnu_cxx::_ConvertibleConcept</class>
    <class kind="struct">__gnu_cxx::_CopyConstructibleConcept</class>
    <class kind="struct">__gnu_cxx::_DefaultConstructibleConcept</class>
    <class kind="struct">__gnu_cxx::_DivideOpConcept</class>
    <class kind="struct">__gnu_cxx::_EqualityComparableConcept</class>
    <class kind="struct">__gnu_cxx::_EqualOpConcept</class>
    <class kind="struct">__gnu_cxx::_ForwardContainerConcept</class>
    <class kind="struct">__gnu_cxx::_ForwardIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_FrontInsertionSequenceConcept</class>
    <class kind="struct">__gnu_cxx::_GeneratorConcept</class>
    <class kind="struct">__gnu_cxx::_GeneratorConcept&lt; _Func, void &gt;</class>
    <class kind="struct">__gnu_cxx::_GreaterEqualOpConcept</class>
    <class kind="struct">__gnu_cxx::_GreaterThanOpConcept</class>
    <class kind="struct">__gnu_cxx::_InputIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; int &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; long &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; long long &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; short &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; unsigned int &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; unsigned long &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; unsigned long long &gt;</class>
    <class kind="struct">__gnu_cxx::_IntegerConcept&lt; unsigned short &gt;</class>
    <class kind="struct">__gnu_cxx::_LessEqualOpConcept</class>
    <class kind="struct">__gnu_cxx::_LessThanComparableConcept</class>
    <class kind="struct">__gnu_cxx::_LessThanOpConcept</class>
    <class kind="struct">__gnu_cxx::_ModOpConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_BidirectionalIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_ContainerConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_ForwardContainerConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_ForwardIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_RandomAccessContainerConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_RandomAccessIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_ReversibleContainerConcept</class>
    <class kind="struct">__gnu_cxx::_Mutable_TrivialIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_NotEqualOpConcept</class>
    <class kind="struct">__gnu_cxx::_OutputIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_PlusOpConcept</class>
    <class kind="struct">__gnu_cxx::_RandomAccessContainerConcept</class>
    <class kind="struct">__gnu_cxx::_RandomAccessIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_ReversibleContainerConcept</class>
    <class kind="struct">__gnu_cxx::_SameTypeConcept</class>
    <class kind="struct">__gnu_cxx::_SequenceConcept</class>
    <class kind="struct">__gnu_cxx::_SGIAssignableConcept</class>
    <class kind="struct">__gnu_cxx::_SignedIntegerConcept</class>
    <class kind="struct">__gnu_cxx::_SignedIntegerConcept&lt; int &gt;</class>
    <class kind="struct">__gnu_cxx::_SignedIntegerConcept&lt; long &gt;</class>
    <class kind="struct">__gnu_cxx::_SignedIntegerConcept&lt; long long &gt;</class>
    <class kind="struct">__gnu_cxx::_SignedIntegerConcept&lt; short &gt;</class>
    <class kind="struct">__gnu_cxx::_SubtractOpConcept</class>
    <class kind="struct">__gnu_cxx::_TimesOpConcept</class>
    <class kind="struct">__gnu_cxx::_TrivialIteratorConcept</class>
    <class kind="struct">__gnu_cxx::_UnaryFunctionConcept</class>
    <class kind="struct">__gnu_cxx::_UnaryFunctionConcept&lt; _Func, void, _Arg &gt;</class>
    <class kind="struct">__gnu_cxx::_UnaryPredicateConcept</class>
    <class kind="struct">__gnu_cxx::_UnsignedIntegerConcept</class>
    <class kind="struct">__gnu_cxx::_UnsignedIntegerConcept&lt; unsigned int &gt;</class>
    <class kind="struct">__gnu_cxx::_UnsignedIntegerConcept&lt; unsigned long &gt;</class>
    <class kind="struct">__gnu_cxx::_UnsignedIntegerConcept&lt; unsigned long long &gt;</class>
    <class kind="struct">__gnu_cxx::_UnsignedIntegerConcept&lt; unsigned short &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_BOOST_CONCEPT_CHECK_H</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>74120adf2519152fb5c752d97c301381</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CLASS_REQUIRES</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>e51768ee9703b5204e71e23ef0c534c7</anchor>
      <arglist>(_type_var, _ns, _concept)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CLASS_REQUIRES2</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>d3a17de91ba3acb12e15f8dd79ce6078</anchor>
      <arglist>(_type_var1, _type_var2, _ns, _concept)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CLASS_REQUIRES3</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>36ca55ca3639b77bba09b9560be92aaa</anchor>
      <arglist>(_type_var1, _type_var2, _type_var3, _ns, _concept)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CLASS_REQUIRES4</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>b07b08ee42e898c15abf3bd892180c92</anchor>
      <arglist>(_type_var1, _type_var2, _type_var3, _type_var4, _ns, _concept)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEFINE_BINARY_OPERATOR_CONSTRAINT</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>c0fcc88ac15aa5ea6a24b5f9379d1db3</anchor>
      <arglist>(_OP, _NAME)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEFINE_BINARY_PREDICATE_OP_CONSTRAINT</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>b9a9c0afdd2180df6fa3efac838588a2</anchor>
      <arglist>(_OP, _NAME)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_IsUnused</name>
      <anchorfile>a01353.html</anchorfile>
      <anchor>b949679e1edd2f9cb4acc8c66667b29e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__aux_require_boolean_expr</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>0d92fa3ac298c841c038621675b8e2ae</anchor>
      <arglist>(const _Tp &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__error_type_must_be_a_signed_integer_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c7435c74311e1b6413fcb0cf3acc4167</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__error_type_must_be_an_integer_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>dedee823a341000091c79aa9117463c0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__error_type_must_be_an_unsigned_integer_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>8d65265d242854d0d28ef686e110728a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__function_requires</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>16c2cee1cdca4c4155ed836735902318</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>boost_shared_ptr.h</name>
    <filename>a01354</filename>
  </compound>
  <compound kind="file">
    <name>boost_sp_counted_base.h</name>
    <filename>a01355</filename>
    <namespace>std</namespace>
    <class kind="class">std::_Mutex_base</class>
    <class kind="class">std::_Mutex_base&lt; _S_mutex &gt;</class>
    <class kind="class">std::_Sp_counted_base</class>
    <class kind="class">std::bad_weak_ptr</class>
    <member kind="function">
      <type>void</type>
      <name>__throw_bad_weak_ptr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>06334974e7b3f52f4fa1fe64f12016f3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bits/boost_sp_shared_count.h</name>
    <filename>a01356</filename>
    <namespace>std</namespace>
    <class kind="class">std::__shared_count</class>
    <class kind="class">std::_Sp_counted_deleter</class>
    <class kind="class">std::_Sp_counted_ptr</class>
    <class kind="class">std::_Sp_counted_ptr_inplace</class>
    <class kind="struct">std::_Sp_destroy_inplace</class>
    <class kind="struct">std::_Sp_make_shared_tag</class>
  </compound>
  <compound kind="file">
    <name>tr1/boost_sp_shared_count.h</name>
    <filename>a01357</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <class kind="class">std::tr1::__shared_count</class>
    <class kind="class">std::tr1::_Sp_counted_base_impl</class>
    <class kind="struct">std::tr1::_Sp_deleter</class>
  </compound>
  <compound kind="file">
    <name>c++allocator.h</name>
    <filename>a01358</filename>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_base_allocator</name>
      <anchorfile>a01358.html</anchorfile>
      <anchor>7b6743f2687c7e9c8620ebfe27126836</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX_ALLOCATOR_H</name>
      <anchorfile>a01358.html</anchorfile>
      <anchor>2832032e0ec337cf7db7bceb21371b14</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>c++config.h</name>
    <filename>a01359</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>__GLIBCXX__</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>38b47d9ebc241dba2c65e2bb24fb5943</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__N</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>28ab508cb9f36beb6c8094b488b02d30</anchor>
      <arglist>(msgid)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ATOMIC_BUILTINS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ecde5aeb105ca788f492fd513684d86d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_LDBL_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ea88e70188ad999fbd8c70d5e8d73116</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>65c0a90ad1328edbf005a47b09073e48</anchor>
      <arglist>(X)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NESTED_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>92ab67ec0f86822cb87d8ee7fac04a92</anchor>
      <arglist>(X, Y)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX_CONFIG_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>c6d50ae15a8bc99f9131fb49edfef589</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEPRECATED_ATTR</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>adf58adcc1ee9379590b6eb5b2121d31</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_LDBL_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>310f2b04607af0b86c3d2c7d0518a524</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>013c20e9d62ea8fc5ee595f5d6604d8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NESTED_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>12d181dcc9f3716e34c40641e8ea4d94</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_EXTERN_TEMPLATE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>a810d6a9d00fad0d81e73eeb98857b31</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_FAST_MATH</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>1f6769cc91363ee05880b1d625474165</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_ABS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>628b4e8af499ed0dd1b6f63bfa9e7e1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_COS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>43b042be7fd92183dc082c6c64deae26</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_COSF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>12fd6c5c950d9a74a7f6d9f28844e47a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_COSL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>10d8d96cf42ca4a7064608a781edd1a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_FABS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>73d05708a3373f3959aa4cf943bdd973</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_FABSF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2d02a04ca60d491249054fd6c4092975</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_FABSL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>68c8f6d4a36b528bfa14c7e277945968</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_LABS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>e2d0079f56e89aa8cabe3e8b82e85305</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_SIN</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>b07f0e37cf12d6ed47d157fdbea8fb96</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_SINF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3cad1930f8936458f410fa55baa7a3b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_SINL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>20961097bb692aad1383d186893cd167</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_SQRT</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>efc726aba6fd58ea9cf04aab3075b991</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_SQRTF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ded8ea38c34c98f2c8c2f41d5bc700e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___BUILTIN_SQRTL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>64769f1be1c20715e4c4e348515300f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___SIGNBIT</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>da2c7e8f598f5c1466625ebe9a12e737</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___SIGNBITF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>8ae682f98a1973e2bd2bed1d36e74fd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE___SIGNBITL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>919636f984fdc8f85b7e12bb83b1a35d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ACOSF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>dac4218403513acf5559f088ced86b08</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ACOSL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>d8afce190c777e7b4a427d29e8dd7aa1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ASINF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f75ff661ded5abe914632cb7c2edce47</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ASINL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ff5be0f7c788fe3ec58595280c050da0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ATAN2F</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>e0c0d9855246c86f4e0723591fefa6dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ATAN2L</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>d330c38f704a1d3900d21d2941621931</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ATANF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fce276012ce35eb9c51862a2cc08db19</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ATANL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>8478fb870d19158675fa2ef88b97e670</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ATTRIBUTE_VISIBILITY</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2d7e69bb2f308e21091588fe2a7c365e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_CEILF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>03f48fb1abb200666cb80373ac9d7b8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_CEILL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>8a7ee2898b65b1d00f6e537bb602ce32</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COMPLEX_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f47f9b2b2ec03c7e70cbbcdad2ae7852</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COPYSIGN</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2c448a75841d0c6ca731bd96cef23496</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COPYSIGNF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>65f18ee9735ca1ed7996ea96821b62ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COPYSIGNL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>dec6d6b467c6db8f14e9e0b04dc6bf3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COSF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3ac636a920573f6bb1ae4d32b2ebcbe9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COSHF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>9967c934538194b47903875d55870355</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COSHL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>c771c9d3475d0750e1802e059c1daa7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_COSL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>dec7b39ae3031648c42717bcade69343</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_DLFCN_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>6714d6f9e66109ac4e3708854acc8296</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ENDIAN_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>a638a226ccc8324edd0a3523b35f0faf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_EXPF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>bfacecdedfa7ac9ed56ccb68775bc966</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_EXPL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0375cace5e684bfc77edbc59d69cb651</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FABSF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>d95a1eb1f1260616f6126fd682af063a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FABSL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>5d79225ad2c718a25ec4a0f08fa97efa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FENV_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>36298c42eed9c9bc9fb63d8e7a5af561</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FINITE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>5b7662b9290456de6c9e4fc834628f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FINITEF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>6fa3729a0e093eadad4c388eaad1df22</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FINITEL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>dd5efb5164948f9e7f1d198d06eba618</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FLOAT_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f17eca531d55a548e2dab1723aaf37fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FLOORF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>4aabe8601b169fb089fcea69cf49c3e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FLOORL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>cece94bfee7b7c7f1e4bb7284efc3a68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FMODF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>486442110af6fa9476d5fbbf9a620b3a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FMODL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3f59384fd90cec3aa0d463eead410468</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FREXPF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>8c3b8e78077c69360f475e1faeebda96</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_FREXPL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f8745b404db1899523a3ca5eef2048d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_GCONV_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>75724c5589ada3809f96e1b5fc21c977</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_GETIPINFO</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>85bc5e7d2948a867e053c211e8ec29e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_GETPAGESIZE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fbd8e3e78fef34466a7040fb29cbcb2f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_GTHR_DEFAULT</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ace9367c32dea6a0976d0d0a39750524</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_HYPOT</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fea95e4911df76a7c69f10d29148abef</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_HYPOTF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>200e86f6fb0cc14be2b333f77365ea8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_HYPOTL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ca55e39146fb7d0fd6f609fba3e38bfa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ICONV</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>534e5f3d9340e564fb74ef3f42748d8b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_INT64_T</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f163b6fe58986988e309fb36beb4a2b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_INTTYPES_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>4f155a756c089a19d8f36b894a77048b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISINF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>9166b5dc399a9afcc3e596d597974075</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISINFF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f575c105b00bd3e083c1dcc977246e5a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISINFL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>6c12e688d203d721f01e4e8fae9fc90a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISNAN</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>b68225622d00df87dc89ff8e216b1107</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISNANF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>e937588e4ad53eb8b3117d678da534e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISNANL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0acf9df7b2bc6cb6119a6ae046690260</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_ISWBLANK</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>498a193975bd138d3b238cc630b003c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LC_MESSAGES</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>1715f9622640589c19fd674e6c048809</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LDEXPF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>66346d758de35baee5f7d9d995e35956</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LDEXPL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>6760a0f6c89db38d662ae4a4d22c8d9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIBINTL_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>748dadfa4c949a5f7541992889929aa2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIBM</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>c5f43da6e348910acb6f31cf3c22eb4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIMIT_AS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>31ba3260bd9fce74cbb38620dee4fefb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIMIT_DATA</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>17b8217cde8ff2aed768fc60e8b8101c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIMIT_FSIZE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>98345d4a7c7e59c877429da9339003ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIMIT_RSS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>5b0446ddf13ef476c4ae6da565342965</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LIMIT_VMEM</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>44bbf998664d005144f8ef460f06fa3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LINUX_FUTEX</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>113047536e746d7da62950c02bf509bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LOCALE_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>974e511db0b22f533c7b26057efd1db5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LOG10F</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>5b04c44a85b5ff6c0d19f83715b46ff1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LOG10L</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>9cd96f7fd1b7ce8437a7d82d170845a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LOGF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>a6dbf50dae027393d5d66abd3b0ae364</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_LOGL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>83160bf883f8e8b485e4f8c0df47717c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_MBSTATE_T</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>d5d71dcaadf727ae0b1325d75006b54e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_MEMORY_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>894fce2c54a24758d282ab15ae78339a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_MMAP</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>30f3055da3b7d0d21017459eb7c9ee19</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_MODF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>4d8d247d6f0a0ee25ff6839788bb0c18</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_MODFF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>38c9a8379857acf2ba01d79f4cf75520</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_MODFL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>982114751307dc525d0fe09352c9d70d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_POLL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>784e770e0cf773aaf987e65743666237</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_POWF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>4daf9b4458c7f6acd206efd539b6886d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_POWL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fb951564cd305d39ae2c5b02e0c5d2c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_S_ISREG</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>face26b943f19c2aaf93d6834ef40e0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SETENV</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0a700332533e5c1594027858801670d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SIGSETJMP</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>8bb67371df62c788d2dbbe310b8c78b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINCOS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>b8066c5eb9c16fcb0cb87185fa300907</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINCOSF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ffb52474a5fce7a91f424f5405dc464e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINCOSL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>adef9ab91b01d0ac33214f7f22b2ed18</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>e5d307850b83ce7f9a3bcd88e0f34405</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINHF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2385cc4a11c2fc2f4726bd59a2b239dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINHL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0954cc6f4486b21db422e1e6797baf94</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SINL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>82e8b95a00233dca5a3c4af383f713ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SQRTF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>74d53748cca2a18ab375e945200265ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SQRTL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>7f7677308eb2300e9766b4b788a7e4cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STDBOOL_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0c94ec7e9de6d7d473b2df7e096057f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STDINT_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3c5a6d2917a0c1d71c6ccd035a885abd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STDLIB_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>6744ff808674c4fed3b0b3af056a4c27</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRERROR_L</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3f063e3d2616701d791d502405f8d144</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRERROR_R</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>e0c59dd0cb23031eecead503ee8a4ecb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRING_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>4584a84f58809f6e07d23358d2b210e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRINGS_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fe00fd11a92ee6d0ee63ec8b0228667a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRTOF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>7149b46895ab6a7cff67a7376f20204f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRTOLD</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>91bcf36854dfac9c22f1e1876f6ddaff</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_STRXFRM_L</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fb34681bacb505f9a4cb0cf639568481</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_IOCTL_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>adad4b7c56d74fa7b35d5f62f42be6ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_IPC_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2658d9c9f47bd03f86497cd45b767472</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_RESOURCE_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>64f6b9880411630f1787cd5f2e3570ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_SEM_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ce7d157f2c70367cd7dc3926cf1dc29f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_STAT_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>be0b6439fc1f74d544c9abb3f9ba2f5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_TIME_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>54fa12b50cae4cc682a3ee872bd1fb4d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_TYPES_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>bc03e2cd23cacc2728b6fb38d0e694d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_SYS_UIO_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>019bc33cfddda8731efc2b1ea5b7a795</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_TANF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>76614a41b4ecaab6d07fd55fb60b9f59</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_TANHF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>bda5c7ac1f4b003efbdf244920b4ac40</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_TANHL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2bdc2764bd899f80a2ef98299acc90cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_TANL</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>826b9e4a0953444cf7ea3b758f7983f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_TGMATH_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>b02fb5f8d5bca22e85eb57f5189f1695</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_TLS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>142d40f1d0b28f29301da86847062d44</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_UNISTD_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>225c327d57b29ea9e2d37d54ac79f6ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_VFWSCANF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3935cf8a2e4f6724c01874ee2aa5abaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_VSWSCANF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>90f8b4543bbf5e3d77975f309b2712b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_VWSCANF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>894b36db2deb0304d47507ef8b1ba36b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_WCHAR_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>e079da0b99bec6eec2b74ddc93a047f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_WCSTOF</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>dae82e0baf7395dec4a583f6abcf089e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_WCTYPE_H</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>3e88f82198992403ff48d3f41472dcac</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HAVE_WRITEV</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>a7295efd718fbb8cecf2364c6ee732de</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_HOSTED</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0640185281f861247ee95c5e1168d476</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ICONV_CONST</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>ad886b301a6cf2a2277a9d50588a17d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LDBL_NAMESPACE</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>027d52f8d6eab93184388500ddebfd87</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_NAMESPACE_ASSOCIATION_VERSION</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2bf723b1a4b900b4b32a532ec1c4fbbf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PACKAGE__GLIBCXX_VERSION</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>5999e689cff48473eceb2f1ec7cfe95e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PACKAGE_BUGREPORT</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>42eb398f282bb222cdb147b456f50178</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PACKAGE_NAME</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0144e1931c86023d9f1745bf7e62953c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PACKAGE_STRING</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>7b46f32f321046763593382b6a64d0c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PACKAGE_TARNAME</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>5f4036695560cc748d2c004bd4c661e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_RES_LIMITS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>eabf3fb527f0252e33a72963191b0cdb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>342a80223ed1801cef0def4b101369c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD_D</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f2957d09e18fc0f4cb30f0a11c1668a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD_P</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>1a6172df7d6182de045877c741ed0e03</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_SYMVER</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f9b52f4bc9d732d7de11fd2077a094cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_SYMVER_GNU</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>dcd3c8ac9845977326528b9c5bbda554</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>04f19d39a6cd601fb8178f2812e208a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_COMPLEX</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>0ac43bda3fe922973256c2906fe68473</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_COMPLEX_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>c22c99dc0e74e1e5221345f78e325f73</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_CTYPE_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>def94c7de5f9cfcc6dbcf97bd3efd8fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_FENV_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>379112a43b5a3f0d91f04c3ef5d6f419</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_INTTYPES_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>56b751a9ae1faf36430833245eeddb3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_MATH</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>35a6a4e922913673e1cb7925288801a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_MATH_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>7a36af292ba7192a874a63d43b6d7c2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_C99_STDINT_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fcf00ada3266e85f33bcee912aba861e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_LFS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>6ca0bdb1b4d0205c1746f45948fe08d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_LONG_LONG</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>f8efe79bb0ff6ee077c09d0be4fa35c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_NLS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>fc7e611af906d3fe81305c6b4f862e43</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_RANDOM_TR1</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>43e4e3fc6562f45f58293f795ed5c808</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_USE_WCHAR_T</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>b9ba10c6f05a0bbb2b57e96a39bfdc64</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_VISIBILITY_ATTR</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>d97b067198f7fd8c85bd01529309ce55</anchor>
      <arglist>(V)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LT_OBJDIR</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>2765e0fe1ecc31808fd9473c2e8f4bee</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STDC_HEADERS</name>
      <anchorfile>a01359.html</anchorfile>
      <anchor>965f81077fe690ce508b3c205339f69f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>c++io.h</name>
    <filename>a01360</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX_IO_H</name>
      <anchorfile>a01360.html</anchorfile>
      <anchor>c49a5a153305b917501cbd025f9e407c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>FILE</type>
      <name>__c_file</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>65955b2a91adc9014e67c8ce110640ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>__gthread_mutex_t</type>
      <name>__c_lock</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>48cec5855c6f82944dd11772e53da92a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>c++locale.h</name>
    <filename>a01361</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_C_LOCALE_GNU</name>
      <anchorfile>a01361.html</anchorfile>
      <anchor>f73e36211b4df2da223686bbda1923b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX_LOCALE_H</name>
      <anchorfile>a01361.html</anchorfile>
      <anchor>2c3551a52efaad9beabb32c524e6aa3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_NUM_CATEGORIES</name>
      <anchorfile>a01361.html</anchorfile>
      <anchor>3eb43d776ade2cd881be1f0108a40779</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>__locale_t</type>
      <name>__c_locale</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>af4b61194215c769c2d16d1897fa2b92</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__convert_from_v</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a016b90eaa22a2db05c9b6672d20417f</anchor>
      <arglist>(const __c_locale &amp;__cloc __attribute__((__unused__)), char *__out, const int __size __attribute__((__unused__)), const char *__fmt,...)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>c++locale_internal.h</name>
    <filename>a01362</filename>
  </compound>
  <compound kind="file">
    <name>cassert</name>
    <filename>a01363</filename>
  </compound>
  <compound kind="file">
    <name>ccomplex</name>
    <filename>a01364</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CCOMPLEX</name>
      <anchorfile>a01364.html</anchorfile>
      <anchor>71f8f5e76f702c76cc7d3327e819abb0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/ccomplex</name>
    <filename>a01365</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CCOMPLEX</name>
      <anchorfile>a01365.html</anchorfile>
      <anchor>26be46c5683d037dac600b3691ec9f4d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cctype</name>
    <filename>a01366</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CCTYPE</name>
      <anchorfile>a01366.html</anchorfile>
      <anchor>3ec5463b80e3c0dc6279e78507639fe3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cctype</name>
    <filename>a01367</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01367.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01367.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01367.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01367.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CCTYPE</name>
      <anchorfile>a01367.html</anchorfile>
      <anchor>51a64a3454f78916fcfdb3538a1696cb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cctype</name>
    <filename>a01368</filename>
  </compound>
  <compound kind="file">
    <name>cerrno</name>
    <filename>a01369</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CERRNO</name>
      <anchorfile>a01369.html</anchorfile>
      <anchor>308b6b135431776dfddb6df6199b25b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>errno</name>
      <anchorfile>a01369.html</anchorfile>
      <anchor>b98ec1b5bcaae594796fdb3d9e2e16c6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cfenv</name>
    <filename>a01370</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CFENV</name>
      <anchorfile>a01370.html</anchorfile>
      <anchor>f4ab07442056aa4c30c56fa2b298e71a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cfenv</name>
    <filename>a01371</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01371.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01371.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01371.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01371.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CFENV</name>
      <anchorfile>a01371.html</anchorfile>
      <anchor>667505f302973ad52fb336cfc494aeca</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cfenv</name>
    <filename>a01372</filename>
  </compound>
  <compound kind="file">
    <name>cfloat</name>
    <filename>a01373</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CFLOAT</name>
      <anchorfile>a01373.html</anchorfile>
      <anchor>d84eddd3d9be9e2f3ea88ef0514c8a6a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cfloat</name>
    <filename>a01374</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CFLOAT</name>
      <anchorfile>a01374.html</anchorfile>
      <anchor>88f6fd3b34cf3d4b7ec6679ed37ce2d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>DECIMAL_DIG</name>
      <anchorfile>a01374.html</anchorfile>
      <anchor>00c71f3f0e707d588a206b0b7e6405a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FLT_EVAL_METHOD</name>
      <anchorfile>a01374.html</anchorfile>
      <anchor>e6b6df11b65edcb82837a3663bd07a96</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>char_traits.h</name>
    <filename>a01375</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="struct">__gnu_cxx::_Char_types</class>
    <class kind="struct">__gnu_cxx::char_traits</class>
    <class kind="struct">std::char_traits</class>
    <class kind="struct">std::char_traits&lt; char &gt;</class>
    <class kind="struct">std::char_traits&lt; wchar_t &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_CHAR_TRAITS_H</name>
      <anchorfile>a01375.html</anchorfile>
      <anchor>5a1d594ec1ed4fc72d8bbce44128419d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>checkers.h</name>
    <filename>a01376</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_CHECKERS</name>
      <anchorfile>a01376.html</anchorfile>
      <anchor>6988782530cbf34ad1c805149beb474c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sorted</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>1bb7f042c961f338578d4dec1a842771</anchor>
      <arglist>(InputIterator begin, InputIterator end, Comparator comp=std::less&lt; typename std::iterator_traits&lt; InputIterator &gt;::value_type &gt;())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sorted_failure</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>69d7259a2e5f520d8332b024f8084215</anchor>
      <arglist>(InputIterator begin, InputIterator end, InputIterator &amp;first_failure, Comparator comp=std::less&lt; typename std::iterator_traits&lt; InputIterator &gt;::value_type &gt;())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sorted_print_failures</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>70ec6d2212333e48d1eea20c321b4870</anchor>
      <arglist>(InputIterator begin, InputIterator end, Comparator comp=std::less&lt; typename std::iterator_traits&lt; InputIterator &gt;::value_type &gt;())</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cinttypes</name>
    <filename>a01377</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CINTTYPES</name>
      <anchorfile>a01377.html</anchorfile>
      <anchor>8ee1e19207872c8bc3262e3905f8a938</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cinttypes</name>
    <filename>a01378</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01378.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01378.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01378.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01378.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CINTTYPES</name>
      <anchorfile>a01378.html</anchorfile>
      <anchor>1462867dcf0380a3375f716c84112124</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cinttypes</name>
    <filename>a01379</filename>
  </compound>
  <compound kind="file">
    <name>ciso646</name>
    <filename>a01380</filename>
  </compound>
  <compound kind="file">
    <name>climits</name>
    <filename>a01381</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CLIMITS</name>
      <anchorfile>a01381.html</anchorfile>
      <anchor>f092d885717052cf5dc26fa1bea2f318</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LLONG_MAX</name>
      <anchorfile>a01381.html</anchorfile>
      <anchor>6bf16ee941792c0cb2869bc973e21b81</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LLONG_MIN</name>
      <anchorfile>a01381.html</anchorfile>
      <anchor>f6161de201d907a44a8f7e4d69470609</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ULLONG_MAX</name>
      <anchorfile>a01381.html</anchorfile>
      <anchor>525d61c24c1a5701e0ead7ba0e8e1663</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/climits</name>
    <filename>a01382</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CLIMITS</name>
      <anchorfile>a01382.html</anchorfile>
      <anchor>5a3633d2fb7d49dcc37bc6d28e648056</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LLONG_MAX</name>
      <anchorfile>a01382.html</anchorfile>
      <anchor>6bf16ee941792c0cb2869bc973e21b81</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>LLONG_MIN</name>
      <anchorfile>a01382.html</anchorfile>
      <anchor>f6161de201d907a44a8f7e4d69470609</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ULLONG_MAX</name>
      <anchorfile>a01382.html</anchorfile>
      <anchor>525d61c24c1a5701e0ead7ba0e8e1663</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>clocale</name>
    <filename>a01383</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CLOCALE</name>
      <anchorfile>a01383.html</anchorfile>
      <anchor>ab0fd1192b50791f1347fe8a4bfab5b6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cmath</name>
    <filename>a01384</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CMATH</name>
      <anchorfile>a01384.html</anchorfile>
      <anchor>4ca7063d2f4fdc69856ff3fabfcd7094</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cmath_power</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aa7d6756fced97673cb1c110ad2cbae5</anchor>
      <arglist>(_Tp, unsigned int)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__pow_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6ee9c2feb2c0757a2303b527eeb42da6</anchor>
      <arglist>(_Tp __x, int __n)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>abs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>238e5e294eeb80752bfb1026e68e4bcc</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>abs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fbf36b2ea7f6bf7f284fc1bca5dd58b5</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>abs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e14c4fd02d1e0e33704db960246e3269</anchor>
      <arglist>(double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>acos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5ddc0ba9f5a2bb09509a1cf426cab5fd</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>acos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ba8565806a568c01a4438031463409a9</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>acos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aa2a2ca626f3e33bca812bf5183211ee</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>asin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3edfb316de5595f836d25da21e0796aa</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>asin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4de1f4f53db7219c614f1865fc0da03e</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>asin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a2418158155265945c12aae52cf1a35f</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>atan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3ca7b454f96f5beb614a0c05d4cf98d2</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>atan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1a09309f3ab787a4ecb6d24da77916c6</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>atan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fab275a7d09990945c5616c8c5f74d50</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; typename __gnu_cxx::__enable_if&lt; __is_arithmetic&lt; _Tp &gt;::__value &amp;&amp;__is_arithmetic&lt; _Up &gt;::__value, _Tp &gt;::__type, _Up &gt;::__type</type>
      <name>atan2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6b1980c9dfabc8b2a6c671b62ea576e2</anchor>
      <arglist>(_Tp __y, _Up __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>atan2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>24aee2057b57182563c29c702d353968</anchor>
      <arglist>(long double __y, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>atan2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7170cff7a1188215e4f4c33ee79f3ca0</anchor>
      <arglist>(float __y, float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>ceil</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f07f0fbd4157bf5906071286302e933f</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>ceil</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>223108bc0fdc6ff7e44befe0d061cf3c</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>ceil</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5256770a09001d0c878797db213112b1</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>cos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>767449b2186fae2a30047094e29a323e</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>cos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6d374774dc12d227259d5419eb670cd1</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>cos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b9c41852a8d84c09781e83b67e8f03d2</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>cosh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>09094e02d874e3fe69342db9996f29d8</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>cosh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4297a2c5c914f3a62d0b767672a2816e</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>cosh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a8117b2cf37b4bfe56fc52bd1a315835</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>exp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3ef4d8cf64beb2afca3c7959777fb2a3</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>exp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ea993dbfec550113ceb1013c99862964</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>exp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aca4211d14b9ede41eda16c896530e46</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>fabs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>42fec2f6c6429a447bea8a40720a143a</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>fabs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9aeabfc5bb0fa7eabbb0a8f57e08296d</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>fabs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a3718c4cd53f42815104ca725d8f59f3</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>floor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>eca9cdc65d83a9f5246423ad93d5b3d4</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>floor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b995f495972f228579aa176680508fbd</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>floor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>438a9a91207363f1f408eeaa30db7d32</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>fmod</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>785f5e5fe4e87320bfedd3426effac9f</anchor>
      <arglist>(long double __x, long double __y)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>fmod</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>98b4be42253330f3831b229c04e6a313</anchor>
      <arglist>(float __x, float __y)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>frexp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2791b80271329b08c1848bba75d083d4</anchor>
      <arglist>(_Tp __x, int *__exp)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>frexp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>193651bd589c192c33d22ec3d3b554e3</anchor>
      <arglist>(long double __x, int *__exp)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>frexp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fd0ecce148f4b65c9293c88767409108</anchor>
      <arglist>(float __x, int *__exp)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>ldexp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f55ab56b3470a0f2e5bd08c64cef80c1</anchor>
      <arglist>(_Tp __x, int __exp)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>ldexp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a25c31eced26a650b941b4fc7a2d7c74</anchor>
      <arglist>(long double __x, int __exp)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>ldexp</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2e6eb07d2bd37974d2fbab47369e6d47</anchor>
      <arglist>(float __x, int __exp)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>log</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d59418a1e878b6ff9b16a7cbcc8368a8</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>log</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9045eb93d4c7a776c89051c06565d537</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>log</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3753c2bdfd00c718ecb6fde68681a761</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>log10</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4dfa121fd737d59fe9dd22e3b629bbac</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>log10</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3c9e470aaf50c8c14038e42a462ff028</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>log10</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>19a44140c156bd9b3225cf4c870dcec8</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>modf</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>30d5861e7c7703ac5f8a621aa3e170b2</anchor>
      <arglist>(long double __x, long double *__iptr)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>modf</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ec0e56721d7c3b51a296353a407b3ef4</anchor>
      <arglist>(float __x, float *__iptr)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; typename __gnu_cxx::__enable_if&lt; __is_arithmetic&lt; _Tp &gt;::__value &amp;&amp;__is_arithmetic&lt; _Up &gt;::__value, _Tp &gt;::__type, _Up &gt;::__type</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f7439d6844d2edd47213afb067eaf3c4</anchor>
      <arglist>(_Tp __x, _Up __y)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>96667d1084157d3cda54eef58a0df1b5</anchor>
      <arglist>(long double __x, int __n)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>493d3810f55296db360d5827f265d928</anchor>
      <arglist>(float __x, int __n)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f9c58a4a4728789b8c7bf36963b473f2</anchor>
      <arglist>(double __x, int __i)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>35ecc9939e9429ce4cd74cc0df40f439</anchor>
      <arglist>(long double __x, long double __y)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8949760445e0e6724c92d521b679619d</anchor>
      <arglist>(float __x, float __y)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>sin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>071791976a3b20015a79eeea1cf6672a</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>sin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>230aa10a8fdafee12f264beb33270e23</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f9a5a17f1c317e99f530835be6d3ced3</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>sinh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ee16d417d43501beaf0d05684f637f23</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>sinh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>96eb0d98fa08fdfe758f2de80c98b1b8</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sinh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>635a4f59e6e5c04b8fbebb34d668a3dd</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>sqrt</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b2c9d94b4becdf532618ad9a0a54aade</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>sqrt</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c07fc52e9c42acbc9654a56f931fa38a</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrt</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4b373f85fdba77b98d2b856649202c2e</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>tan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0e8b3f8bdd40fd238e9ab2b25c582b8c</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>tan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ebd6f0f1c246db8c02d7e0b917e55d32</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>tan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>db88e3363d37c12c3dd9033816a1cebf</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_integer&lt; _Tp &gt;::__value, double &gt;::__type</type>
      <name>tanh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7ee4d6d6980ad92f03eab1de84137bd8</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>tanh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d2efd0434c661003f31abdff7be4b4ec</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>tanh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a8df147ee3c43cfb4a93462a18000262</anchor>
      <arglist>(float __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cmath</name>
    <filename>a01385</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01385.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01385.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01385.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01385.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CMATH</name>
      <anchorfile>a01385.html</anchorfile>
      <anchor>fa98bd741d291f6537f01e9a5f9aa815</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>assoc_laguerre</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gbd1fdec0a30acb77caac7b25f93130b1</anchor>
      <arglist>(unsigned int __n, unsigned int __m, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>assoc_laguerref</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gbcbfdb6706343029e387b2016dd140e5</anchor>
      <arglist>(unsigned int __n, unsigned int __m, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>assoc_laguerrel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gd3bbbaf1e78dfceba65a6f6c3d27d1c5</anchor>
      <arglist>(unsigned int __n, unsigned int __m, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>assoc_legendre</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g97149c56f7d077b4d5ef07824ac43701</anchor>
      <arglist>(unsigned int __l, unsigned int __m, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>assoc_legendref</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g4a7d6db014cd8d086499a185594eeed0</anchor>
      <arglist>(unsigned int __l, unsigned int __m, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>assoc_legendrel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gded1065d0afdabc6ff7cb679e5f15e55</anchor>
      <arglist>(unsigned int __l, unsigned int __m, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tpx, _Tpy &gt;::__type</type>
      <name>beta</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gc16868683c8c3c1ff244d3a6177b74d6</anchor>
      <arglist>(_Tpx __x, _Tpy __y)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>betaf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g6384070cfef94cae71724a631134dcaa</anchor>
      <arglist>(float __x, float __y)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>betal</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gc4ac19c9af42bfddab1c3188643e4b40</anchor>
      <arglist>(long double __x, long double __y)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>comp_ellint_1</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g03a7999da2c60cfe319d05ae6c3c2e85</anchor>
      <arglist>(_Tp __k)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>comp_ellint_1f</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g5747e6e22713a74fab1203fe952f537e</anchor>
      <arglist>(float __k)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>comp_ellint_1l</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g0aedd75613abf456df1ea23833fa9cbc</anchor>
      <arglist>(long double __k)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>comp_ellint_2</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g74e143d9dcfd986b0860d36166f164ff</anchor>
      <arglist>(_Tp __k)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>comp_ellint_2f</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g7435aad958e756b77f56716a31441776</anchor>
      <arglist>(float __k)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>comp_ellint_2l</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g3bc628d51ff3e885ea9f74310872cda9</anchor>
      <arglist>(long double __k)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tp, _Tpn &gt;::__type</type>
      <name>comp_ellint_3</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gf9c5e7e98a7a7f7cfcf4f83b7a9373f8</anchor>
      <arglist>(_Tp __k, _Tpn __nu)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>comp_ellint_3f</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gdc004448531cc727932c1b068c26c79e</anchor>
      <arglist>(float __k, float __nu)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>comp_ellint_3l</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g46d28c5658ffc4280692e193d4ae6967</anchor>
      <arglist>(long double __k, long double __nu)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_3&lt; _Tpa, _Tpc, _Tp &gt;::__type</type>
      <name>conf_hyperg</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g4acb4e11024fb888f550d9d72a721a77</anchor>
      <arglist>(_Tpa __a, _Tpc __c, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>conf_hypergf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gba7d81178fde14e6f95d16a3878ff456</anchor>
      <arglist>(float __a, float __c, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>conf_hypergl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g07a1715e3e9aa572bbcdf48278fc4491</anchor>
      <arglist>(long double __a, long double __c, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tpnu, _Tp &gt;::__type</type>
      <name>cyl_bessel_i</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g54d7ff86b6f92d86f7ab667891dbb0fc</anchor>
      <arglist>(_Tpnu __nu, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>cyl_bessel_if</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g7bf974f156d90a061905bc316984b4d7</anchor>
      <arglist>(float __nu, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>cyl_bessel_il</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gd9881058cc6a66798eaa8e953569a7ce</anchor>
      <arglist>(long double __nu, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tpnu, _Tp &gt;::__type</type>
      <name>cyl_bessel_j</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gb35f3e0717473d50686ddf84775cd384</anchor>
      <arglist>(_Tpnu __nu, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>cyl_bessel_jf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g542a410a2ae8f321be5ffa2e4434a4b2</anchor>
      <arglist>(float __nu, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>cyl_bessel_jl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g9f394dbcb71948a8af1e7fd8273438f0</anchor>
      <arglist>(long double __nu, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tpnu, _Tp &gt;::__type</type>
      <name>cyl_bessel_k</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>ge0f68ad3230491403e29ea7d1415347f</anchor>
      <arglist>(_Tpnu __nu, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>cyl_bessel_kf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g11d849333ced5a68f29dbb3f52a6c5ef</anchor>
      <arglist>(float __nu, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>cyl_bessel_kl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g06b2e8e200dba8d3afbcad0f4da06c08</anchor>
      <arglist>(long double __nu, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tpnu, _Tp &gt;::__type</type>
      <name>cyl_neumann</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gd43f4f27ebef671ab7c223f8f4e3ddb1</anchor>
      <arglist>(_Tpnu __nu, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>cyl_neumannf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g2b580317236ac9a0f048289681084abc</anchor>
      <arglist>(float __nu, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>cyl_neumannl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g30b15557ff6898cc8d6fe55ed0e4addd</anchor>
      <arglist>(long double __nu, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tp, _Tpp &gt;::__type</type>
      <name>ellint_1</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gf04e1374413a3fc2b44d4cf21a78da29</anchor>
      <arglist>(_Tp __k, _Tpp __phi)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>ellint_1f</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g7d63b1e7c3029170f88231edaa8bd27f</anchor>
      <arglist>(float __k, float __phi)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>ellint_1l</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g62702db2dfc63bb8c3740ac0438512fc</anchor>
      <arglist>(long double __k, long double __phi)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_2&lt; _Tp, _Tpp &gt;::__type</type>
      <name>ellint_2</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g6e59ac097be69dd19c83983cbc871997</anchor>
      <arglist>(_Tp __k, _Tpp __phi)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>ellint_2f</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g25ff951a7443df04feb3ba4616045d7e</anchor>
      <arglist>(float __k, float __phi)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>ellint_2l</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gfbe798ca5c2d4af3848f4bd208e4dccd</anchor>
      <arglist>(long double __k, long double __phi)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_3&lt; _Tp, _Tpn, _Tpp &gt;::__type</type>
      <name>ellint_3</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gdcf2238ee27291d52c46a89ac37976bc</anchor>
      <arglist>(_Tp __k, _Tpn __nu, _Tpp __phi)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>ellint_3f</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g7a4341a83f7c8f87971752650049e482</anchor>
      <arglist>(float __k, float __nu, float __phi)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>ellint_3l</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g72c9695c7ae41b833bb5a3713af803d5</anchor>
      <arglist>(long double __k, long double __nu, long double __phi)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>expint</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g505cc50f361cfb9bf0472f8b5852d853</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>expintf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gdc2fbe1f8bbba7e6586bf01024606888</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>expintl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g9b0b587d0ababa5e359cb40d91ea2c25</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>hermite</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>geb5b2de367d82fed09b5f4e03246d23d</anchor>
      <arglist>(unsigned int __n, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>hermitef</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g686a0c1615014932d11d771f359a4f59</anchor>
      <arglist>(unsigned int __n, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>hermitel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g4bb769783f773f0602d114d83fbb8e8f</anchor>
      <arglist>(unsigned int __n, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote_4&lt; _Tpa, _Tpb, _Tpc, _Tp &gt;::__type</type>
      <name>hyperg</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g6dc135386258137626001d481bd0a88e</anchor>
      <arglist>(_Tpa __a, _Tpb __b, _Tpc __c, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>hypergf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g10f2bf0697eb38419a45fd3a249ec818</anchor>
      <arglist>(float __a, float __b, float __c, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>hypergl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gb508bbd396d79f766a62c7b70d2d4350</anchor>
      <arglist>(long double __a, long double __b, long double __c, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>laguerre</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g05df0bd1a39082930fb4026333b4e8e5</anchor>
      <arglist>(unsigned int __n, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>laguerref</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g1dbc8fcd103ac0fa3448dca3cd4474e3</anchor>
      <arglist>(unsigned int __n, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>laguerrel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gf04e9e03724a3a1175506ef2a0a73080</anchor>
      <arglist>(unsigned int __n, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>legendre</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g7f203d350992345f5d21421f41cd90d7</anchor>
      <arglist>(unsigned int __n, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>legendref</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g5cf434110d653d5c19165a69bd5188d1</anchor>
      <arglist>(unsigned int __n, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>legendrel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g6dce17db466ede51f7fba902bd34ae3f</anchor>
      <arglist>(unsigned int __n, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>riemann_zeta</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g6359fef9cb2f55662dc51172f97ee20b</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>riemann_zetaf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g9199f2ea5714ee42edc2f103d22bb684</anchor>
      <arglist>(float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>riemann_zetal</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gf377f6e42fce07c6a36830d146dfb195</anchor>
      <arglist>(long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>sph_bessel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g93da6191f4af70d0bbc73f25cefe30ce</anchor>
      <arglist>(unsigned int __n, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sph_besself</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g901b559cc8e99510a063664e0cfa2826</anchor>
      <arglist>(unsigned int __n, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>sph_bessell</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gcc54137f76507593fb878fbafb81dc1e</anchor>
      <arglist>(unsigned int __n, long double __x)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>sph_legendre</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g8853e4fe246284b35582c1252cf28ec3</anchor>
      <arglist>(unsigned int __l, unsigned int __m, _Tp __theta)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sph_legendref</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gec362ed93c1fe8ec15d2e82be0f6e065</anchor>
      <arglist>(unsigned int __l, unsigned int __m, float __theta)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>sph_legendrel</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gd9bf82952ecd508c76d3e0f9b1a8af3a</anchor>
      <arglist>(unsigned int __l, unsigned int __m, long double __theta)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>sph_neumann</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gff1b97a65e2d5d7863d8a0a23f4969b2</anchor>
      <arglist>(unsigned int __n, _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sph_neumannf</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>g0c0d7175e8517025a5e10a728e2bd38b</anchor>
      <arglist>(unsigned int __n, float __x)</arglist>
    </member>
    <member kind="function">
      <type>long double</type>
      <name>sph_neumannl</name>
      <anchorfile>a01719.html</anchorfile>
      <anchor>gfe986296aca734367517f42fe3cefe3c</anchor>
      <arglist>(unsigned int __n, long double __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cmath</name>
    <filename>a01386</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>cmath.tcc</name>
    <filename>a01387</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CMATH_TCC</name>
      <anchorfile>a01387.html</anchorfile>
      <anchor>4a507e2faf2db9f7cce9b2a5cbdf2ab5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cmath_power</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aa7d6756fced97673cb1c110ad2cbae5</anchor>
      <arglist>(_Tp, unsigned int)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>codecvt.h</name>
    <filename>a01388</filename>
    <namespace>std</namespace>
    <class kind="class">std::__codecvt_abstract_base</class>
    <class kind="class">std::codecvt</class>
    <class kind="class">std::codecvt&lt; char, char, mbstate_t &gt;</class>
    <class kind="class">std::codecvt&lt; wchar_t, char, mbstate_t &gt;</class>
    <class kind="class">std::codecvt_base</class>
    <class kind="class">std::codecvt_byname</class>
    <member kind="define">
      <type>#define</type>
      <name>_CODECVT_H</name>
      <anchorfile>a01388.html</anchorfile>
      <anchor>37a824f1e6ca628e710115bfe2d80c98</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>codecvt_specializations.h</name>
    <filename>a01389</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="struct">__gnu_cxx::encoding_char_traits</class>
    <class kind="class">__gnu_cxx::encoding_state</class>
    <class kind="class">std::codecvt&lt; _InternT, _ExternT, encoding_state &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_CODECVT_SPECIALIZATIONS_H</name>
      <anchorfile>a01389.html</anchorfile>
      <anchor>337b26b13025008e4c77298318fec71e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>__iconv_adaptor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8d1a02482f97ea72d6d8d455e234bb12</anchor>
      <arglist>(size_t(*__func)(iconv_t, _Tp, size_t *, char **, size_t *), iconv_t __cd, char **__inbuf, size_t *__inbytes, char **__outbuf, size_t *__outbytes)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>x86_64-unknown-linux-gnu/bits/compatibility.h</name>
    <filename>a01390</filename>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv _ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv _ZNSbIwSt11char_traitsIwESaIwEE7_M_copyEPwPKwm _ZNSbIwSt11char_traitsIwESaIwEE9_M_assignEPwmw _ZNKSbIwSt11char_traitsIwESaIwEE15_M_check_lengthEmmPKc _ZNSt13basic_istreamIwSt11char_traitsIwEE6ignoreEv _ZNKSt13basic_fstreamIwSt11char_traitsIwEE7is_openEv</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>748cc3b96a05378196a63f445deff049</anchor>
      <arglist>(_ZNKSt16basic_ifstreamXXIwSt11char_traitsIwEE7is_openEv, _ZNKSt14basic_ifstreamIwSt11char_traitsIwEE7is_openEv) _GLIBCXX_APPLY_SYMVER(_ZNKSt16basic_ofstreamXXIwSt11char_traitsIwEE7is_openEv</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv _ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv _ZNSbIwSt11char_traitsIwESaIwEE7_M_copyEPwPKwm _ZNSbIwSt11char_traitsIwESaIwEE9_M_assignEPwmw _ZNKSbIwSt11char_traitsIwESaIwEE15_M_check_lengthEmmPKc _ZNSt13basic_istreamIwSt11char_traitsIwEE6ignoreEv</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>a37ba06544e77e2ccb481fa8e2be7bbc</anchor>
      <arglist>(_ZNSt13basic_istreamIwSt11char_traitsIwEE8ignoreXXEl, _ZNSt13basic_istreamIwSt11char_traitsIwEE6ignoreEl) _GLIBCXX_APPLY_SYMVER(_ZNKSt15basic_fstreamXXIwSt11char_traitsIwEE7is_openEv</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv _ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv _ZNSbIwSt11char_traitsIwESaIwEE7_M_copyEPwPKwm _ZNSbIwSt11char_traitsIwESaIwEE9_M_assignEPwmw _ZNKSbIwSt11char_traitsIwESaIwEE15_M_check_lengthEmmPKc</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>242db5bdda89518ae39c9533ce3631e8</anchor>
      <arglist>(_ZNSbIwSt11char_traitsIwESaIwEE4_Rep28_M_set_length_and_sharableXXEm, _ZNSbIwSt11char_traitsIwESaIwEE4_Rep26_M_set_length_and_sharableEm) _GLIBCXX_APPLY_SYMVER(_ZNSt13basic_istreamIwSt11char_traitsIwEE8ignoreXXEv</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv _ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv _ZNSbIwSt11char_traitsIwESaIwEE7_M_copyEPwPKwm _ZNSbIwSt11char_traitsIwESaIwEE9_M_assignEPwmw</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>73f1d11482dadef4c3da4718a43a4780</anchor>
      <arglist>(_ZNKSbIwSt11char_traitsIwESaIwEE13_M_disjunctXXEPKw, _ZNKSbIwSt11char_traitsIwESaIwEE11_M_disjunctEPKw) _GLIBCXX_APPLY_SYMVER(_ZNKSbIwSt11char_traitsIwESaIwEE17_M_check_lengthXXEmmPKc</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv _ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv _ZNSbIwSt11char_traitsIwESaIwEE7_M_copyEPwPKwm</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>2d2c7d09ded364811455be08f201ed1c</anchor>
      <arglist>(_ZNSbIwSt11char_traitsIwESaIwEE9_M_moveXXEPwPKwm, _ZNSbIwSt11char_traitsIwESaIwEE7_M_moveEPwPKwm) _GLIBCXX_APPLY_SYMVER(_ZNSbIwSt11char_traitsIwESaIwEE11_M_assignXXEPwmw</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv _ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>f2d7358f59e2f0e10849a43fc749e37a</anchor>
      <arglist>(_ZNSt11char_traitsIwE4eqXXERKwS2_, _ZNSt11char_traitsIwE2eqERKwS2_) _GLIBCXX_APPLY_SYMVER(_ZNSbIwSt11char_traitsIwESaIwEE9_M_copyXXEPwPKwm</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc _ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>cf3533483e568b9843344dfde89591ab</anchor>
      <arglist>(_ZNKSt16basic_ifstreamXXIcSt11char_traitsIcEE7is_openEv, _ZNKSt14basic_ifstreamIcSt11char_traitsIcEE7is_openEv) _GLIBCXX_APPLY_SYMVER(_ZNKSt16basic_ofstreamXXIcSt11char_traitsIcEE7is_openEv</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc _ZNKSs15_M_check_lengthEmmPKc</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>45b43ec61ab3ddf547e20810c35f82dc</anchor>
      <arglist>(_ZNSs4_Rep28_M_set_length_and_sharableXXEm, _ZNSs4_Rep26_M_set_length_and_sharableEm) _GLIBCXX_APPLY_SYMVER(_ZNKSt15basic_fstreamXXIcSt11char_traitsIcEE7is_openEv</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm _ZNSs9_M_assignEPcmc</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>e7938da1341afe64793f801301bd1648</anchor>
      <arglist>(_ZNKSs13_M_disjunctXXEPKc, _ZNKSs11_M_disjunctEPKc) _GLIBCXX_APPLY_SYMVER(_ZNKSs17_M_check_lengthXXEmmPKc</arglist>
    </member>
    <member kind="function" static="yes">
      <type>_ZNSs7_M_copyEPcPKcm</type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>b5dbb7aac4fe7c0de83d2776bbe24f85</anchor>
      <arglist>(_ZNSs9_M_moveXXEPcPKcm, _ZNSs7_M_moveEPcPKcm) _GLIBCXX_APPLY_SYMVER(_ZNSs11_M_assignXXEPcmc</arglist>
    </member>
    <member kind="function" static="yes">
      <type></type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>14d4c660141d5df0c368478d941ed58c</anchor>
      <arglist>(_ZNSt11char_traitsIcE4eqXXERKcS2_, _ZNSt11char_traitsIcE2eqERKcS2_) _GLIBCXX_APPLY_SYMVER(_ZNSs9_M_copyXXEPcPKcm</arglist>
    </member>
    <member kind="function" static="yes">
      <type></type>
      <name>_GLIBCXX_APPLY_SYMVER</name>
      <anchorfile>a01390.html</anchorfile>
      <anchor>2a034ed2c7d6f3fd4c2ded175181ff26</anchor>
      <arglist>(_ZNSt21istreambuf_iteratorXXIcSt11char_traitsIcEEppEv, _ZNSt19istreambuf_iteratorIcSt11char_traitsIcEEppEv) _GLIBCXX_APPLY_SYMVER(_ZNSt21istreambuf_iteratorXXIwSt11char_traitsIwEEppEv</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>parallel/compatibility.h</name>
    <filename>a01391</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_COMPATIBILITY_H</name>
      <anchorfile>a01391.html</anchorfile>
      <anchor>a253af7692eb2f1032229c1b9e3f99d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compare_and_swap</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>b43dd3a66e217bb50fbe810f148949e7</anchor>
      <arglist>(volatile T *ptr, T comparand, T replacement)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compare_and_swap_32</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8291d91267317ed7bedba91a879d75f7</anchor>
      <arglist>(volatile int32 *ptr, int32 comparand, int32 replacement)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compare_and_swap_64</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>a857abe286c582ab99e30ed962670881</anchor>
      <arglist>(volatile int64 *ptr, int64 comparand, int64 replacement)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>fetch_and_add</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>83604c0de6abf90a70f666efd1d41e0c</anchor>
      <arglist>(volatile T *ptr, T addend)</arglist>
    </member>
    <member kind="function">
      <type>int32</type>
      <name>fetch_and_add_32</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f35836a4e04ec3f1d2c63b2997ae4884</anchor>
      <arglist>(volatile int32 *ptr, int32 addend)</arglist>
    </member>
    <member kind="function">
      <type>int64</type>
      <name>fetch_and_add_64</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>2a61000eeab8f7c548b39cb366fb6743</anchor>
      <arglist>(volatile int64 *ptr, int64 addend)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>yield</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>405d700f71b4bbafd77bad19a0892da3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>compiletime_settings.h</name>
    <filename>a01392</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ASSERTIONS</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>597a97952fddce9d0c5fbcda552b773e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CALL</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>1f6e93249d913bc8f75f37f1a1fcefc8</anchor>
      <arglist>(n)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MULTIWAY_MERGESORT_COPY_LAST</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>2180b32bf461f9ec80981ccb5bd69c52</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_RANDOM_SHUFFLE_CONSIDER_L1</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>d927534b81e68cb0e55d73f3aece91d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_RANDOM_SHUFFLE_CONSIDER_TLB</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>ed02e87b29b9701f81d8c9d2d0a85772</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_SCALE_DOWN_FPU</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>e8ae2743dc17c2503b9c4b1a6b5e0f9c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_VERBOSE_LEVEL</name>
      <anchorfile>a01392.html</anchorfile>
      <anchor>42c043c9ee2145cdd9bc4ec6a8ee0772</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>complex</name>
    <filename>a01393</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01393.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01393.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01393.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01393.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_COMPLEX</name>
      <anchorfile>a01393.html</anchorfile>
      <anchor>f1febebc949d0977024a1224ca5caa2b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>impl/complex</name>
    <filename>a01394</filename>
    <namespace>std</namespace>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>__complex_acos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4b332a8f0bd0b24981f14b9cc4bc1b56</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>__complex_acosh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9257f527d86f6549fba6afc32bf15fc4</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>__complex_asin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>142f04e98f61d3e793109bc178dd457c</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>__complex_asinh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a76057c8e6a2f86e908109ebddf1a116</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>__complex_atan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>74944ec9ba28f3f3307446d715fe77f0</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>__complex_atanh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>86f383a34d1875054a6da950ce752d32</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>acos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>059f4a7e5d2304f42dda96848db9e70c</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>acosh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>abf19845102763b557369b9fe88e4dc7</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>arg</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>87a38ef0fc4b1a7c98c81f2a0ea4bfb0</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>asin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ef9e38ec8e67611b7cf98ee697c315e0</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>asinh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6ff4724828d41646f25b9b0664805186</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>atan</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3480c29bfb7a8bdd639d5009284fe1f0</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; _Tp &gt;</type>
      <name>atanh</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>46345d7d276f80356fcafb5872d0cf10</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; typename __gnu_cxx::__promote&lt; _Tp &gt;::__type &gt;</type>
      <name>conj</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c8d19cf0f5309f0f6725df68839d5f76</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>fabs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1d7fcd1e0977462eb14ee949b38e62c2</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__z)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>norm</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cc752930b50e4763ef35d8485d84fec8</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; typename __gnu_cxx::__promote_2&lt; _Tp, _Up &gt;::__type &gt;</type>
      <name>polar</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a25c54bc7336982ceb3ea72d5003a92c</anchor>
      <arglist>(const _Tp &amp;__rho, const _Up &amp;__theta)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; typename __gnu_cxx::__promote_2&lt; _Tp, _Up &gt;::__type &gt;</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ffc9383fb7c20eaf9197b2d54a5d00a2</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__x, const std::complex&lt; _Up &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; typename __gnu_cxx::__promote_2&lt; _Tp, _Up &gt;::__type &gt;</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e4cbe31cf6989413b2e11df17d1ca806</anchor>
      <arglist>(const _Tp &amp;__x, const std::complex&lt; _Up &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>std::complex&lt; typename __gnu_cxx::__promote_2&lt; _Tp, _Up &gt;::__type &gt;</type>
      <name>pow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8b66a77f54133452578ba671bfd05ff6</anchor>
      <arglist>(const std::complex&lt; _Tp &gt; &amp;__x, const _Up &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>real</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7b44e251a8a2305d2b584836283305d0</anchor>
      <arglist>(_Tp __x)</arglist>
    </member>
    <member kind="variable">
      <type>__gnu_cxx::__promote&lt; _Tp &gt;::__type</type>
      <name>imag</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5cf8f720b8d6e65fda43746f3602217f</anchor>
      <arglist>(_Tp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>complex.h</name>
    <filename>a01395</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_COMPLEX_H</name>
      <anchorfile>a01395.html</anchorfile>
      <anchor>0a526274ef1b8f88f27396312043ceeb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>concept_check.h</name>
    <filename>a01396</filename>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_class_requires</name>
      <anchorfile>a01396.html</anchorfile>
      <anchor>3fff87c2c70756fb7f006ba87646e3e7</anchor>
      <arglist>(_a, _b)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_class_requires2</name>
      <anchorfile>a01396.html</anchorfile>
      <anchor>be71037395424ebc9a2efd25f596cf15</anchor>
      <arglist>(_a, _b, _c)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_class_requires3</name>
      <anchorfile>a01396.html</anchorfile>
      <anchor>60088a43cce2254b32516bac07f60c88</anchor>
      <arglist>(_a, _b, _c, _d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_class_requires4</name>
      <anchorfile>a01396.html</anchorfile>
      <anchor>9029822ea035b97b550bb5ea30834efe</anchor>
      <arglist>(_a, _b, _c, _d, _e)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_function_requires</name>
      <anchorfile>a01396.html</anchorfile>
      <anchor>6abd49672c01382e41f6a0fc5fb4254f</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_CONCEPT_CHECK_H</name>
      <anchorfile>a01396.html</anchorfile>
      <anchor>895e69b062c2074efd390dd955efd556</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>concurrence.h</name>
    <filename>a01397</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::__concurrence_broadcast_error</class>
    <class kind="class">__gnu_cxx::__concurrence_lock_error</class>
    <class kind="class">__gnu_cxx::__concurrence_unlock_error</class>
    <class kind="class">__gnu_cxx::__concurrence_wait_error</class>
    <class kind="class">__gnu_cxx::__mutex</class>
    <class kind="class">__gnu_cxx::__recursive_mutex</class>
    <class kind="class">__gnu_cxx::__scoped_lock</class>
    <member kind="define">
      <type>#define</type>
      <name>_CONCURRENCE_H</name>
      <anchorfile>a01397.html</anchorfile>
      <anchor>b44f3a286546e38f30efd848c4f5dcc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Lock_policy</name>
      <anchor>b1a48fd4e7a59bc86d12ab8528c5527d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_concurrence_lock_error</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d9a52b76d99962965a0358735024fd0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_concurrence_unlock_error</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d0cbb40541bddef0ba930c9a1f134b61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const _Lock_policy</type>
      <name>__default_lock_policy</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>b353c96567f1dff89b4dac674ac44ff5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cond_dealtor.hpp</name>
    <filename>a01398</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="class">__gnu_pbds::detail::cond_dealtor</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_COND_DEALTOR_CLASS_C_DEC</name>
      <anchorfile>a01398.html</anchorfile>
      <anchor>62800a4de091987f318f759fe0893b54</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_COND_DEALTOR_CLASS_T_DEC</name>
      <anchorfile>a01398.html</anchorfile>
      <anchor>80547b7ae8f136bbbe5dc11c4135e596</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>constructors_destructor_fn_imps.hpp</name>
    <filename>a01399</filename>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>b49b4a75a16e2cd84a56b001306a318c</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>943005406aad3de19fe8040b8d5191de</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>fe738b010d8a6094f16807c721183088</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>0b21ee828ab01997fd3e6d249aea82a9</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2, T3 t3, T4 t4, T5 t5)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>4208692b6c81df77fb9632af6134b62f</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2, T3 t3, T4 t4)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>ef37105360da773b32d1c16765e0cf12</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2, T3 t3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>287e6313f8d9a005d8abccb2078c4a3a</anchor>
      <arglist>(T0 t0, T1 t1, T2 t2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>221c52028a6db9b1e42c0ae32be696aa</anchor>
      <arglist>(T0 t0, T1 t1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>f4b5338ad65c0974dd89181bae8310e3</anchor>
      <arglist>(T0 t0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>0a84a3e284b42061437ca34d42274d67</anchor>
      <arglist>(const PB_DS_CLASS_NAME &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PB_DS_CLASS_NAME</name>
      <anchorfile>a01399.html</anchorfile>
      <anchor>1f3775b65dd9b15e8d7dbc1b63324a17</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>container_base_dispatch.hpp</name>
    <filename>a01400</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, cc_hash_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, gp_hash_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, list_update_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, ov_tree_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, pat_trie_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, rb_tree_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, Mapped, splay_tree_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, cc_hash_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, gp_hash_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, list_update_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, ov_tree_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, pat_trie_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, rb_tree_tag, Policy_Tl, Alloc &gt;</class>
    <class kind="struct">__gnu_pbds::detail::container_base_dispatch&lt; Key, null_mapped_type, splay_tree_tag, Policy_Tl, Alloc &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_FALSE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>645726e2ee0bbb170b52e1dbf7d99e68</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_DATA_TRUE_INDICATOR</name>
      <anchorfile>a01400.html</anchorfile>
      <anchor>e8a360ff2cc323a978cc2feab1d5c669</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cpp_type_traits.h</name>
    <filename>a01401</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="struct">std::__are_same</class>
    <class kind="struct">std::__are_same&lt; _Tp, _Tp &gt;</class>
    <class kind="struct">std::__false_type</class>
    <class kind="struct">std::__is_arithmetic</class>
    <class kind="struct">std::__is_byte</class>
    <class kind="struct">std::__is_byte&lt; char &gt;</class>
    <class kind="struct">std::__is_byte&lt; signed char &gt;</class>
    <class kind="struct">std::__is_byte&lt; unsigned char &gt;</class>
    <class kind="struct">std::__is_char</class>
    <class kind="struct">std::__is_char&lt; char &gt;</class>
    <class kind="struct">std::__is_char&lt; wchar_t &gt;</class>
    <class kind="struct">std::__is_floating</class>
    <class kind="struct">std::__is_floating&lt; double &gt;</class>
    <class kind="struct">std::__is_floating&lt; float &gt;</class>
    <class kind="struct">std::__is_floating&lt; long double &gt;</class>
    <class kind="struct">std::__is_fundamental</class>
    <class kind="struct">std::__is_integer</class>
    <class kind="struct">std::__is_integer&lt; bool &gt;</class>
    <class kind="struct">std::__is_integer&lt; char &gt;</class>
    <class kind="struct">std::__is_integer&lt; int &gt;</class>
    <class kind="struct">std::__is_integer&lt; long &gt;</class>
    <class kind="struct">std::__is_integer&lt; long long &gt;</class>
    <class kind="struct">std::__is_integer&lt; short &gt;</class>
    <class kind="struct">std::__is_integer&lt; signed char &gt;</class>
    <class kind="struct">std::__is_integer&lt; unsigned char &gt;</class>
    <class kind="struct">std::__is_integer&lt; unsigned int &gt;</class>
    <class kind="struct">std::__is_integer&lt; unsigned long &gt;</class>
    <class kind="struct">std::__is_integer&lt; unsigned long long &gt;</class>
    <class kind="struct">std::__is_integer&lt; unsigned short &gt;</class>
    <class kind="struct">std::__is_integer&lt; wchar_t &gt;</class>
    <class kind="struct">std::__is_move_iterator</class>
    <class kind="struct">std::__is_normal_iterator</class>
    <class kind="struct">std::__is_normal_iterator&lt; __gnu_cxx::__normal_iterator&lt; _Iterator, _Container &gt; &gt;</class>
    <class kind="struct">std::__is_pointer</class>
    <class kind="struct">std::__is_pointer&lt; _Tp * &gt;</class>
    <class kind="struct">std::__is_scalar</class>
    <class kind="struct">std::__is_void</class>
    <class kind="struct">std::__is_void&lt; void &gt;</class>
    <class kind="struct">std::__traitor</class>
    <class kind="struct">std::__true_type</class>
    <class kind="struct">std::__truth_type</class>
    <class kind="struct">std::__truth_type&lt; true &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_CPP_TYPE_TRAITS_H</name>
      <anchorfile>a01401.html</anchorfile>
      <anchor>9963aea65bf47cd5f3fafe7e1a917617</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cpu_defines.h</name>
    <filename>a01402</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CPU_DEFINES</name>
      <anchorfile>a01402.html</anchorfile>
      <anchor>e6bcc27cf43d743d1fb3768ad5e52ec5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>csetjmp</name>
    <filename>a01403</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSETJMP</name>
      <anchorfile>a01403.html</anchorfile>
      <anchor>e9316953c8081bc616ca201f2c50ac96</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>setjmp</name>
      <anchorfile>a01403.html</anchorfile>
      <anchor>93b52187715baf3e748dd8f792656aff</anchor>
      <arglist>(env)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>csignal</name>
    <filename>a01404</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSIGNAL</name>
      <anchorfile>a01404.html</anchorfile>
      <anchor>b21e1faf5af647fffc9b4368703ec803</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cstdarg</name>
    <filename>a01405</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTDARG</name>
      <anchorfile>a01405.html</anchorfile>
      <anchor>325189169f5a575862f76125de3f2e9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>va_end</name>
      <anchorfile>a01405.html</anchorfile>
      <anchor>273fbd4dd7ce1bbc2640606acff5d7e5</anchor>
      <arglist>(ap)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cstdarg</name>
    <filename>a01406</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CSTDARG</name>
      <anchorfile>a01406.html</anchorfile>
      <anchor>d9f9c08a9ba3f01381b8330783e7acfe</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cstdbool</name>
    <filename>a01407</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTDBOOL</name>
      <anchorfile>a01407.html</anchorfile>
      <anchor>bfebbb7d544a9c854718112fbbd388a6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cstdbool</name>
    <filename>a01408</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CSTDBOOL</name>
      <anchorfile>a01408.html</anchorfile>
      <anchor>fc53c6f2112b17065a0c0cafebec25d3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cstddef</name>
    <filename>a01409</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTDDEF</name>
      <anchorfile>a01409.html</anchorfile>
      <anchor>a9e63070df7e984231629510d6509b18</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cstdint</name>
    <filename>a01410</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTDINT</name>
      <anchorfile>a01410.html</anchorfile>
      <anchor>8b6bc26535e5096c668d1225a3619cfc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cstdint</name>
    <filename>a01411</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01411.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01411.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01411.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01411.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CSTDINT</name>
      <anchorfile>a01411.html</anchorfile>
      <anchor>bd151b395077552f28354cd8a5be05d0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cstdint</name>
    <filename>a01412</filename>
  </compound>
  <compound kind="file">
    <name>cstdio</name>
    <filename>a01413</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTDIO</name>
      <anchorfile>a01413.html</anchorfile>
      <anchor>9bdbc2f7cefa4d1cc6437be51339af9d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cstdio</name>
    <filename>a01414</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01414.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01414.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01414.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01414.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CSTDIO</name>
      <anchorfile>a01414.html</anchorfile>
      <anchor>884f2970a7f32777197746209a709618</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cstdio</name>
    <filename>a01415</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>cstdlib</name>
    <filename>a01416</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTDLIB</name>
      <anchorfile>a01416.html</anchorfile>
      <anchor>63950caddc59c64678fee4379adbe70f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>EXIT_FAILURE</name>
      <anchorfile>a01416.html</anchorfile>
      <anchor>d851a8925c3675478e7dbb01d23a4dfa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>EXIT_SUCCESS</name>
      <anchorfile>a01416.html</anchorfile>
      <anchor>f10c4450462a331cc76a25d3e9292dcf</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>abort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e3b91f35a04ada8c900f6046b83fdad5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>atexit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8e3fd19b371a6ed520197baabe15f522</anchor>
      <arglist>(void(*)())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>exit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2107b37641fcd1f3d16ecc9c0a18041f</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cstdlib</name>
    <filename>a01417</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01417.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01417.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01417.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01417.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CSTDLIB</name>
      <anchorfile>a01417.html</anchorfile>
      <anchor>0165e27b3d9e9f873be3a33053963302</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cstdlib</name>
    <filename>a01418</filename>
  </compound>
  <compound kind="file">
    <name>cstring</name>
    <filename>a01419</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CSTRING</name>
      <anchorfile>a01419.html</anchorfile>
      <anchor>c75ee3b83595ac7e5874a9c7312d2361</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>memchr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6b32b84d2c7ea9cbf7c92477d3629cf3</anchor>
      <arglist>(void *__p, int __c, size_t __n)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>strchr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>82848fec91d9ff66306702d01cac7a0b</anchor>
      <arglist>(char *__s1, int __n)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>strpbrk</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2857fd65434f8c7ec9f80935caeee9ac</anchor>
      <arglist>(char *__s1, const char *__s2)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>strrchr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b111ee0b8a8d09efe0690f38b200bbb4</anchor>
      <arglist>(char *__s1, int __n)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>strstr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>28a0f0093fb0204fd8b7193aeacf35b2</anchor>
      <arglist>(char *__s1, const char *__s2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ctgmath</name>
    <filename>a01420</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CTGMATH</name>
      <anchorfile>a01420.html</anchorfile>
      <anchor>fc221506f5e04e2a69485119af10f191</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/ctgmath</name>
    <filename>a01421</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CTGMATH</name>
      <anchorfile>a01421.html</anchorfile>
      <anchor>c67eb43bee0f44b357ca2f893dac80a2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ctime</name>
    <filename>a01422</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CTIME</name>
      <anchorfile>a01422.html</anchorfile>
      <anchor>ac80affb7196e3d1e124d79acfaf5193</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/ctime</name>
    <filename>a01423</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CTIME</name>
      <anchorfile>a01423.html</anchorfile>
      <anchor>85ba2c331076a3624eea983b5b6811da</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ctype.h</name>
    <filename>a01424</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_CTYPE_H</name>
      <anchorfile>a01424.html</anchorfile>
      <anchor>272d2a079d280a56dbd021019783158d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ctype_base.h</name>
    <filename>a01425</filename>
    <namespace>std</namespace>
    <class kind="struct">std::ctype_base</class>
  </compound>
  <compound kind="file">
    <name>ctype_inline.h</name>
    <filename>a01426</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>ctype_noninline.h</name>
    <filename>a01427</filename>
  </compound>
  <compound kind="file">
    <name>cwchar</name>
    <filename>a01428</filename>
    <namespace>std</namespace>
    <class kind="struct">mbstate_t</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CWCHAR</name>
      <anchorfile>a01428.html</anchorfile>
      <anchor>648e9e378b38d1c84fe9cd782dbc45f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>wchar_t *</type>
      <name>wcschr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>43f00debea7f5bee2a7255190121e112</anchor>
      <arglist>(wchar_t *__p, wchar_t __c)</arglist>
    </member>
    <member kind="function">
      <type>wchar_t *</type>
      <name>wcspbrk</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>48c5ea429240207a9ad43656cb8b31db</anchor>
      <arglist>(wchar_t *__s1, const wchar_t *__s2)</arglist>
    </member>
    <member kind="function">
      <type>wchar_t *</type>
      <name>wcsrchr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>95e8891da7109e95c8dcdd4e518876c6</anchor>
      <arglist>(wchar_t *__p, wchar_t __c)</arglist>
    </member>
    <member kind="function">
      <type>wchar_t *</type>
      <name>wcsstr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7e924f36d3557911b0d2517bc9bff90d</anchor>
      <arglist>(wchar_t *__s1, const wchar_t *__s2)</arglist>
    </member>
    <member kind="function">
      <type>wchar_t *</type>
      <name>wmemchr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>69bf5b6ded40db6658cb524779d41a2c</anchor>
      <arglist>(wchar_t *__p, wchar_t __c, size_t __n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cwchar</name>
    <filename>a01429</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01429.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01429.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01429.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01429.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CWCHAR</name>
      <anchorfile>a01429.html</anchorfile>
      <anchor>6c9bacc9c581727de435d66715ba9762</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cwchar</name>
    <filename>a01430</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>cwctype</name>
    <filename>a01431</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CWCTYPE</name>
      <anchorfile>a01431.html</anchorfile>
      <anchor>00064bc7e465096fe3b58d7444ed05ce</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/cwctype</name>
    <filename>a01432</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01432.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01432.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01432.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01432.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_CWCTYPE</name>
      <anchorfile>a01432.html</anchorfile>
      <anchor>5eef5d478b531dd4a29953e604180be0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/cwctype</name>
    <filename>a01433</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>cxxabi.h</name>
    <filename>a01435</filename>
    <member kind="define">
      <type>#define</type>
      <name>_CXXABI_H</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>fd2348b9a7ce0e254f28956e25411de6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_NOTHROW</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>d7c3151745fc9495c9d51c4884a7d6bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>__cxa_cdtor_return_type(*)</type>
      <name>__cxa_cdtor_type</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>b0f2027139f9de4a324886c86bba44a1</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__cxa_atexit</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>6167e318ec6efac6e830e5b05213416d</anchor>
      <arglist>(void(*)(void *), void *, void *) __attribute__((nothrow))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_bad_cast</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>eb89f24b7f133edaf2c7a7471c99dfc4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_bad_typeid</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>f0c7553b15049653ffc6844555a9fee0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>__cxa_demangle</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>541317cfae8fe4c7617b647d98360120</anchor>
      <arglist>(const char *__mangled_name, char *__output_buffer, size_t *__length, int *__status)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__cxa_finalize</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>5fcba951908d8176d47c7f41fefa56fa</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_guard_abort</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>3c228f75717cd725607a511f9a4fe996</anchor>
      <arglist>(__guard *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__cxa_guard_acquire</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>c701503d8a817da06bbf7289dff21425</anchor>
      <arglist>(__guard *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_guard_release</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>95a10b12582500f9933b3e222dccd7b9</anchor>
      <arglist>(__guard *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_pure_virtual</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>88ebe737a75c8dfddada38bf93d8b998</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>__cxa_vec_ctor_return_type</type>
      <name>__cxa_vec_cctor</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>52ef38e9d04d7a41e691870e13872130</anchor>
      <arglist>(void *dest_array, void *src_array, size_t element_count, size_t element_size, __cxa_cdtor_return_type(*constructor)(void *, void *), __cxa_cdtor_type destructor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_vec_cleanup</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>e6bdf959174602d74b67253099f0fd6c</anchor>
      <arglist>(void *__array_address, size_t __element_count, size_t __element_size, __cxa_cdtor_type destructor)</arglist>
    </member>
    <member kind="function">
      <type>__cxa_vec_ctor_return_type</type>
      <name>__cxa_vec_ctor</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>5f0ae89fdcf4e47810db88881a6dbb18</anchor>
      <arglist>(void *__array_address, size_t __element_count, size_t __element_size, __cxa_cdtor_type constructor, __cxa_cdtor_type destructor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_vec_delete</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>cf9798b17375a8616343533593ff8f17</anchor>
      <arglist>(void *__array_address, size_t __element_size, size_t __padding_size, __cxa_cdtor_type destructor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_vec_delete2</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>b1178edd6cf3cdd2c1c7d90d477c9362</anchor>
      <arglist>(void *__array_address, size_t __element_size, size_t __padding_size, __cxa_cdtor_type destructor, void(*__dealloc)(void *))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_vec_delete3</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>dbd4f247588624f547fcdcaada286a3a</anchor>
      <arglist>(void *__array_address, size_t __element_size, size_t __padding_size, __cxa_cdtor_type destructor, void(*__dealloc)(void *, size_t))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__cxa_vec_dtor</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>e46311fb39f13e05093f6f21d3be619b</anchor>
      <arglist>(void *__array_address, size_t __element_count, size_t __element_size, __cxa_cdtor_type destructor)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>__cxa_vec_new</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>065a657ddc1736033022b70c5e7c88c7</anchor>
      <arglist>(size_t __element_count, size_t __element_size, size_t __padding_size, __cxa_cdtor_type constructor, __cxa_cdtor_type destructor)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>__cxa_vec_new2</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>58560320a5bbb095ae2611c427331bde</anchor>
      <arglist>(size_t __element_count, size_t __element_size, size_t __padding_size, __cxa_cdtor_type constructor, __cxa_cdtor_type destructor, void *(*__alloc)(size_t), void(*__dealloc)(void *))</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>__cxa_vec_new3</name>
      <anchorfile>a01435.html</anchorfile>
      <anchor>dc53342ddfd2ccd7fd5b57f66e5d77f9</anchor>
      <arglist>(size_t __element_count, size_t __element_size, size_t __padding_size, __cxa_cdtor_type constructor, __cxa_cdtor_type destructor, void *(*__alloc)(size_t), void(*__dealloc)(void *, size_t))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cxxabi_tweaks.h</name>
    <filename>a01436</filename>
    <member kind="define">
      <type>#define</type>
      <name>_CXXABI_TWEAKS_H</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>2628d07b497f45bf81a2596cbf5575a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXA_VEC_CTOR_RETURN</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>d3200358f1e54952167b1dcc9920d8ff</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_GUARD_BIT</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>fb5f75e090da8f8f4811378167b5d978</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_GUARD_PENDING_BIT</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>31c477121c83df420202e45049e38b30</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_GUARD_SET</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>2814f54a7eb1f5a90dab3a534343de52</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_GUARD_TEST</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>16345002d8e63ed750963b9a715f33ab</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_GUARD_WAITING_BIT</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>fd7bc9a9ae14c997af18deb529f58efe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>__cxa_cdtor_return_type</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>d77ebabbe7b77cc88a0c50876823101c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>__cxa_vec_ctor_return_type</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>ed107adeb391894b7fef0e33e8d012fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>__extension__ typedef int __guard</type>
      <name>__attribute__</name>
      <anchorfile>a01436.html</anchorfile>
      <anchor>a4a66e19d3a07fbd438535274c91d95f</anchor>
      <arglist>((mode(__DI__)))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug.h</name>
    <filename>a01437</filename>
    <namespace>__gnu_debug</namespace>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_cond</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>481a6dce99eec15c8aa48fba27091077</anchor>
      <arglist>(_Cond, _Msg)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_heap</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>16c46af720b3f409e133f7c792db9bfc</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_heap_pred</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>3666d1a7bedcb91664e94fa3a5c5e335</anchor>
      <arglist>(_First, _Last, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_nonempty</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>71500f9b93e2cfb924982de5fab3b65f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_partitioned_lower</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>fcdcd25531a6bee7ca30cbf9fd481c9e</anchor>
      <arglist>(_First, _Last, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_partitioned_lower_pred</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>331710f9695cd1828d7101611d01f2ae</anchor>
      <arglist>(_First, _Last, _Value, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_partitioned_upper</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>4ea8539387b4477204c1ddd769a49e03</anchor>
      <arglist>(_First, _Last, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_partitioned_upper_pred</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>5bad37cb20b41377c646e4804a817140</anchor>
      <arglist>(_First, _Last, _Value, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_sorted</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>3d0cba215703446a2f947e4dee5b1262</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_sorted_pred</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>b653c68c075ffe455fb64e03a960abf0</anchor>
      <arglist>(_First, _Last, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_sorted_set</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>9b679a8ef395ae4304dc45f5fbe5218a</anchor>
      <arglist>(_First1, _Last1, _First2)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_sorted_set_pred</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>7fe0579d87c7648105fbffd60ceffbe2</anchor>
      <arglist>(_First1, _Last1, _First2, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_string</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>edb4492e9e651028dc49244ef989a051</anchor>
      <arglist>(_String)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_string_len</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>f4c3845b9f49cd19a40f8c1035436828</anchor>
      <arglist>(_String, _Len)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_subscript</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>d2c4c8aea53e9d044bfe10b7d3569ac6</anchor>
      <arglist>(_N)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_requires_valid_range</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>8ce242fc713df277e3c52a0bffc7da61</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_ASSERT</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>06fa6bbc78ddfb027377c4df385dc46c</anchor>
      <arglist>(_Condition)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_MACRO_SWITCH_H</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>ffec3e883107af0772de79656ddd8f8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_ONLY</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>bddd86895d239c59372135f74bfa5221</anchor>
      <arglist>(_Statement)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_PEDASSERT</name>
      <anchorfile>a01437.html</anchorfile>
      <anchor>67fbb3931300e71cfef6f9d15c9cfedb</anchor>
      <arglist>(_Condition)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug_allocator.h</name>
    <filename>a01438</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::debug_allocator</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEBUG_ALLOCATOR_H</name>
      <anchorfile>a01438.html</anchorfile>
      <anchor>3bf29d676989ac56ca9ec23f86234bc7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug_map_base.hpp</name>
    <filename>a01439</filename>
  </compound>
  <compound kind="file">
    <name>deque</name>
    <filename>a01440</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEQUE</name>
      <anchorfile>a01440.html</anchorfile>
      <anchor>009c527df0a7a611dce25d0c9ca13f96</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/deque</name>
    <filename>a01441</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::deque</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_DEQUE</name>
      <anchorfile>a01441.html</anchorfile>
      <anchor>b1886774186f7d464a35a304ea86311d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>de8b2b2e1de877d4d320737c27171646</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__lhs, const deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>f1d303697c96a7f64d17309ad7b9304a</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__lhs, const deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b394d2b9e6eb7ebaa80aa37010124500</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__lhs, const deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>2859ac235f0798f7c8bf1ec6285f3ba6</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__lhs, const deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>faec2f3ecee3b3ea0769d9267b3097e0</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__lhs, const deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>bfb7dc7926ec4233bf54bfe135de86de</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__lhs, const deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>85fb6a0071070d5e01b66dd06da8fdd9</anchor>
      <arglist>(deque&lt; _Tp, _Alloc &gt; &amp;__lhs, deque&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>deque.tcc</name>
    <filename>a01442</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_DEQUE_TCC</name>
      <anchorfile>a01442.html</anchorfile>
      <anchor>0e38aed64d85d11bffd5face7ea1925e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9bfbce8baf0dbac17c1303ace0986d55</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Tp &amp;, _Tp * &gt; &amp;__first, const _Deque_iterator&lt; _Tp, _Tp &amp;, _Tp * &gt; &amp;__last, const _Tp &amp;__value)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ell_integral.tcc</name>
    <filename>a01444</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_ELL_INTEGRAL_TCC</name>
      <anchorfile>a01444.html</anchorfile>
      <anchor>b48148dc82275db1b0e89b07b1af1430</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__comp_ellint_1</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>7a5c0bcca9e57ef941cf1c71dd497515</anchor>
      <arglist>(const _Tp __k)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__comp_ellint_1_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>ebbd0b38fa58791339669181822f544f</anchor>
      <arglist>(const _Tp __k)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__comp_ellint_2</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>2a46d8f38e7514acf068c0009f32a121</anchor>
      <arglist>(const _Tp __k)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__comp_ellint_2_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>a5b7bbefe3e13b8db8587d81ec9a9bc4</anchor>
      <arglist>(const _Tp __k)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__comp_ellint_3</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>6815ab69763d468a433afbbb6deb8b89</anchor>
      <arglist>(const _Tp __k, const _Tp __nu)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_1</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>321dffc680bd8a79a3e6c0ace95ac0b3</anchor>
      <arglist>(const _Tp __k, const _Tp __phi)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_2</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>ac24e9b34294ca3d5de480f797acc4be</anchor>
      <arglist>(const _Tp __k, const _Tp __phi)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_3</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>7191fa4515c6f095fd3232779fde334d</anchor>
      <arglist>(const _Tp __k, const _Tp __nu, const _Tp __phi)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_rc</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>51a05cf9284e02b8488da1e49c80413d</anchor>
      <arglist>(const _Tp __x, const _Tp __y)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_rd</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>12caabd495627545884ca4044893eca6</anchor>
      <arglist>(const _Tp __x, const _Tp __y, const _Tp __z)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_rf</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>6abd0b213616f4710b9e32aed8e3ce73</anchor>
      <arglist>(const _Tp __x, const _Tp __y, const _Tp __z)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__ellint_rj</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>f8e2de01657426b40cd122de00aa5aa1</anchor>
      <arglist>(const _Tp __x, const _Tp __y, const _Tp __z, const _Tp __p)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>enc_filebuf.h</name>
    <filename>a01445</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::enc_filebuf</class>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_ENC_FILEBUF_H</name>
      <anchorfile>a01445.html</anchorfile>
      <anchor>51669883821e9a22548420049121831c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>equally_split.h</name>
    <filename>a01446</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_EQUALLY_SPLIT_H</name>
      <anchorfile>a01446.html</anchorfile>
      <anchor>ebecad14db396b7b42b1f22883fe4ce7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>equally_split</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>5eb7480e9480b702cdc5449a19fdbe33</anchor>
      <arglist>(difference_type n, thread_index_t num_threads, OutputIterator s)</arglist>
    </member>
    <member kind="function">
      <type>difference_type</type>
      <name>equally_split_point</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>5158963fc4d22c198bd273c9a1c35c8f</anchor>
      <arglist>(difference_type n, thread_index_t num_threads, thread_index_t thread_no)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>exception</name>
    <filename>a01447</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="class">std::bad_exception</class>
    <class kind="class">std::exception</class>
    <member kind="typedef">
      <type>void(*)</type>
      <name>terminate_handler</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7a94e4f095402fc2ab9905fa0621ee85</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="typedef">
      <type>void(*)</type>
      <name>unexpected_handler</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>646e4dea9e03b36d0fc8e5d88e8425fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__verbose_terminate_handler</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>1d621404faf0f5a890bdbcc17389586a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>terminate_handler</type>
      <name>set_terminate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>17c3910992c4f5c25bde652cdbef456a</anchor>
      <arglist>(terminate_handler)</arglist>
    </member>
    <member kind="function">
      <type>unexpected_handler</type>
      <name>set_unexpected</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>79fefcde34dba71b0fdae43a19f647c5</anchor>
      <arglist>(unexpected_handler)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>terminate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>df637e4d02f3910190f82d2e55f046d2</anchor>
      <arglist>() __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>uncaught_exception</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d84a172839a819ebaf4e5a980ff8ebd0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unexpected</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0eb8877b336c9a9c79af006fb3d04ebb</anchor>
      <arglist>() __attribute__((__noreturn__))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>exception.hpp</name>
    <filename>a01448</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="struct">__gnu_pbds::container_error</class>
    <class kind="struct">__gnu_pbds::insert_error</class>
    <class kind="struct">__gnu_pbds::join_error</class>
    <class kind="struct">__gnu_pbds::resize_error</class>
    <member kind="function">
      <type>void</type>
      <name>__throw_container_error</name>
      <anchorfile>a01693.html</anchorfile>
      <anchor>398be7eb3598eba8bb680195cc9e24a4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_insert_error</name>
      <anchorfile>a01693.html</anchorfile>
      <anchor>c979fb3d30ac8741befad26dd97b80f9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_join_error</name>
      <anchorfile>a01693.html</anchorfile>
      <anchor>3161c8250b69494429dc407a335b8f8b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_resize_error</name>
      <anchorfile>a01693.html</anchorfile>
      <anchor>e53655261502c47b30d506cd99600949</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>exp_integral.tcc</name>
    <filename>a01449</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_EXP_INTEGRAL_TCC</name>
      <anchorfile>a01449.html</anchorfile>
      <anchor>1e359af0d5b9a98241a6282d1e0c8531</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>32256578bc01a4dde03599ceda053e11</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>53807816f3646afd140ba6aa8c5f8ad5</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_asymp</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>ed2934cf1496f2692d3d88b3340710e3</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_E1</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>d841dc4908fee1ccc925da0c36286839</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_E1_asymp</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>c91502af14e53823323f628c06a2c415</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_E1_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>d78b7797e987a74629c29285a6b93c34</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_Ei</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>254e8044b56e7a1361209f48ca8ea4e2</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_Ei_asymp</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>556714a2f5e51bf731c2ffa7fed3059d</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_Ei_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>e7c1ae9a6ae3856c4269d6fd35ef6fd8</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_En_cont_frac</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>eaca582a5659ae23c2f44a4f58d6cb0d</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_En_recursion</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>2cdfba2f638f87c5e6a86b5adb0815cb</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_En_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>050820e4e66c430688e239d84ceee48f</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__expint_large_n</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>c40b38934426e966eb5044b62456dfc2</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>features.h</name>
    <filename>a01450</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BAL_QUICKSORT</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>816d41fe822bdc772550d22cdd40ae24</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_FIND_CONSTANT_SIZE_BLOCKS</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>c31e91c456d75214cd4f68c690ba5852</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_FIND_EQUAL_SPLIT</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>bcd2015991d08f5bc676d5fe1441ee53</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_FIND_GROWING_BLOCKS</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>a6ca60c4a286e72a09a702f487d3ca97</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>c95dd5d50be97905887007c75a8bc13e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_COMBINED</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>122ffb29de38d07ed8fe22f3af1b3b88</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_EXPLICIT</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>88e0c53844accfbe35c928908beb221c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_POINTER</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>fea9ac375fcd6888fc9d47925dd6741c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_POINTER_UNGUARDED</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>d456111b85ce27e223858d9141cdf07a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_REFERENCE</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>4c320e3b0f23e5201a1c9312495e5fd0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_SENTINEL</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>39c7f7c822bdafff4cb56db2e4ce8e6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOSER_TREE_UNGUARDED</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>10ca661a50edd9d11ea918eb2e9df2b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MERGESORT</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>1d5a407e17fe3171c882259cfa7d29df</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_FEATURES_H</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>b67f4e0955739d8a7fd6d0477aa04a80</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_QUICKSORT</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>b9dd841bd97e55c2f140589be40bf033</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TREE_DYNAMIC_BALANCING</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>333c29b880b5ac70589ba9b4ee97addd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TREE_FULL_COPY</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>a01983a1de16742163bea4d2a54a2c4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TREE_INITIAL_SPLITTING</name>
      <anchorfile>a01450.html</anchorfile>
      <anchor>f3bd175fc01ff2e61e7243905ee3e307</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>fenv.h</name>
    <filename>a01451</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_FENV_H</name>
      <anchorfile>a01451.html</anchorfile>
      <anchor>8c1fe3abe09fbea6be9b585b292dd002</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>find.h</name>
    <filename>a01452</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_FIND_H</name>
      <anchorfile>a01452.html</anchorfile>
      <anchor>bc159f95f5c332fc776634b802d3d671</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; RandomAccessIterator1, RandomAccessIterator2 &gt;</type>
      <name>find_template</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8bf7bf152b15a59b03f327389faeceab</anchor>
      <arglist>(RandomAccessIterator1 begin1, RandomAccessIterator1 end1, RandomAccessIterator2 begin2, Pred pred, Selector selector)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>find_selectors.h</name>
    <filename>a01453</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::adjacent_find_selector</class>
    <class kind="struct">__gnu_parallel::find_first_of_selector</class>
    <class kind="struct">__gnu_parallel::find_if_selector</class>
    <class kind="struct">__gnu_parallel::generic_find_selector</class>
    <class kind="struct">__gnu_parallel::mismatch_selector</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_FIND_FUNCTIONS_H</name>
      <anchorfile>a01453.html</anchorfile>
      <anchor>3ed088f3f5590b9f08f762d623c02d54</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>float.h</name>
    <filename>a01454</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_FLOAT_H</name>
      <anchorfile>a01454.html</anchorfile>
      <anchor>59784bab80cf776a35b27e14f2981692</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>for_each.h</name>
    <filename>a01455</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_FOR_EACH_H</name>
      <anchorfile>a01455.html</anchorfile>
      <anchor>af8fb9cb03c88174b691323b9e887652</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>UserOp</type>
      <name>for_each_template_random_access</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>4ece85194b64735cc69fccbd5c752521</anchor>
      <arglist>(InputIterator begin, InputIterator end, UserOp user_op, Functionality &amp;functionality, Red reduction, Result reduction_start, Result &amp;output, typename std::iterator_traits&lt; InputIterator &gt;::difference_type bound, _Parallelism parallelism_tag)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>for_each_selectors.h</name>
    <filename>a01456</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::accumulate_binop_reduct</class>
    <class kind="struct">__gnu_parallel::accumulate_selector</class>
    <class kind="struct">__gnu_parallel::adjacent_difference_selector</class>
    <class kind="struct">__gnu_parallel::count_if_selector</class>
    <class kind="struct">__gnu_parallel::count_selector</class>
    <class kind="struct">__gnu_parallel::dummy_reduct</class>
    <class kind="struct">__gnu_parallel::fill_selector</class>
    <class kind="struct">__gnu_parallel::for_each_selector</class>
    <class kind="struct">__gnu_parallel::generate_selector</class>
    <class kind="struct">__gnu_parallel::generic_for_each_selector</class>
    <class kind="struct">__gnu_parallel::identity_selector</class>
    <class kind="struct">__gnu_parallel::inner_product_selector</class>
    <class kind="struct">__gnu_parallel::max_element_reduct</class>
    <class kind="struct">__gnu_parallel::min_element_reduct</class>
    <class kind="struct">__gnu_parallel::nothing</class>
    <class kind="struct">__gnu_parallel::replace_if_selector</class>
    <class kind="struct">__gnu_parallel::replace_selector</class>
    <class kind="struct">__gnu_parallel::transform1_selector</class>
    <class kind="struct">__gnu_parallel::transform2_selector</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_FOR_EACH_SELECTORS_H</name>
      <anchorfile>a01456.html</anchorfile>
      <anchor>3478fd1da3f72fc24eceba58e86cc0f9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>formatter.h</name>
    <filename>a01457</filename>
    <namespace>__gnu_debug</namespace>
    <class kind="struct">__gnu_debug::__is_same</class>
    <class kind="struct">__gnu_debug::__is_same&lt; _Type, _Type &gt;</class>
    <class kind="struct">__gnu_debug::__truth</class>
    <class kind="class">__gnu_debug::_Error_formatter</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_FORMATTER_H</name>
      <anchorfile>a01457.html</anchorfile>
      <anchor>215120aa2c7c9be6aaea5db012dffc45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Debug_msg_id</name>
      <anchor>70cc1d9258385c9a906e6c677ffcea26</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>fstream</name>
    <filename>a01458</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_filebuf</class>
    <class kind="class">std::basic_fstream</class>
    <class kind="class">std::basic_ifstream</class>
    <class kind="class">std::basic_ofstream</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_FSTREAM</name>
      <anchorfile>a01458.html</anchorfile>
      <anchor>61288c9643c47f67cd93bc71a956383f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>fstream.tcc</name>
    <filename>a01459</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_FSTREAM_TCC</name>
      <anchorfile>a01459.html</anchorfile>
      <anchor>f260aa86015a86a396f57fe49f8f8f64</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>functexcept.h</name>
    <filename>a01460</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_FUNCTEXCEPT_H</name>
      <anchorfile>a01460.html</anchorfile>
      <anchor>4a01fcdd7213042d4100c268ce309ee2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_bad_alloc</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dc6678b02b023b93c1f767954d5bf32d</anchor>
      <arglist>(void) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_bad_cast</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cdaeae756adc7a4268d975801319fb78</anchor>
      <arglist>(void) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_bad_exception</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>36efe03b498085f78bde37b7cd94ba54</anchor>
      <arglist>(void) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_bad_typeid</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>388856940331c9f93e9722b9b88a2339</anchor>
      <arglist>(void) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_domain_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>96173b9458136e3fe901cd229b4527ec</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_invalid_argument</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0fadfffa97d6340e3cebefe7cffaa75b</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_ios_failure</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>29435d04812e7c02aeb89dd17cbc8689</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_length_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9f52afa1bcec390d665c7758b2ba4546</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_logic_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6ac9a35cec63f0529bd1ef81ed2f90fd</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_out_of_range</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3dfbdfcd95b76ac131f1367b0c8f3fd4</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_overflow_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>beb9e46de7b7a1f4c9d779e5bab48002</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_range_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>29e08a10d2ad277f7656a3d4bcaa0d60</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_runtime_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d42ec2ea35784b4af8ee831041039cea</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_underflow_error</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>724e455dba8348e0d5b83d6c3421876d</anchor>
      <arglist>(const char *) __attribute__((__noreturn__))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>functional</name>
    <filename>a01461</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_FUNCTIONAL</name>
      <anchorfile>a01461.html</anchorfile>
      <anchor>b96e536dbd7a470e45c040f87159bef5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ext/functional</name>
    <filename>a01462</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::_Constant_binary_fun</class>
    <class kind="struct">__gnu_cxx::_Constant_unary_fun</class>
    <class kind="struct">__gnu_cxx::_Constant_void_fun</class>
    <class kind="struct">__gnu_cxx::_Project1st</class>
    <class kind="struct">__gnu_cxx::_Project2nd</class>
    <class kind="class">__gnu_cxx::binary_compose</class>
    <class kind="struct">__gnu_cxx::constant_binary_fun</class>
    <class kind="struct">__gnu_cxx::constant_unary_fun</class>
    <class kind="struct">__gnu_cxx::constant_void_fun</class>
    <class kind="struct">__gnu_cxx::identity</class>
    <class kind="struct">__gnu_cxx::project1st</class>
    <class kind="struct">__gnu_cxx::project2nd</class>
    <class kind="struct">__gnu_cxx::select1st</class>
    <class kind="struct">__gnu_cxx::select2nd</class>
    <class kind="class">__gnu_cxx::subtractive_rng</class>
    <class kind="class">__gnu_cxx::unary_compose</class>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_FUNCTIONAL</name>
      <anchorfile>a01462.html</anchorfile>
      <anchor>22fea573d5e4176060700c49f7e38a44</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>unary_compose&lt; _Operation1, _Operation2 &gt;</type>
      <name>compose1</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>gfc42787979ca59c8977167134251e13a</anchor>
      <arglist>(const _Operation1 &amp;__fn1, const _Operation2 &amp;__fn2)</arglist>
    </member>
    <member kind="function">
      <type>binary_compose&lt; _Operation1, _Operation2, _Operation3 &gt;</type>
      <name>compose2</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g981620201bb56ffdd37cb03ad91f7fd4</anchor>
      <arglist>(const _Operation1 &amp;__fn1, const _Operation2 &amp;__fn2, const _Operation3 &amp;__fn3)</arglist>
    </member>
    <member kind="function">
      <type>constant_void_fun&lt; _Result &gt;</type>
      <name>constant0</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g81063abd22d40bf2480edc44f66a9a15</anchor>
      <arglist>(const _Result &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>constant_unary_fun&lt; _Result, _Result &gt;</type>
      <name>constant1</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g07e0107064467e307f5cd53a08f85572</anchor>
      <arglist>(const _Result &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>constant_binary_fun&lt; _Result, _Result, _Result &gt;</type>
      <name>constant2</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g668b22ccab0e9e58c7b0bd86ef95c614</anchor>
      <arglist>(const _Result &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>identity_element</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g06204e98f86f6b1a613b54af2aa22b2b</anchor>
      <arglist>(std::multiplies&lt; _Tp &gt;)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>identity_element</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g0b612928e691a0acc280e87e80fe9187</anchor>
      <arglist>(std::plus&lt; _Tp &gt;)</arglist>
    </member>
    <member kind="function">
      <type>mem_fun1_t&lt; _Ret, _Tp, _Arg &gt;</type>
      <name>mem_fun1</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>1a9cdd4d5f62434fe5f3477abd12f477</anchor>
      <arglist>(_Ret(_Tp::*__f)(_Arg))</arglist>
    </member>
    <member kind="function">
      <type>mem_fun1_ref_t&lt; _Ret, _Tp, _Arg &gt;</type>
      <name>mem_fun1_ref</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c588ec62dacd0c6a0cf0bc15bf9e8a71</anchor>
      <arglist>(_Ret(_Tp::*__f)(_Arg))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/functional</name>
    <filename>a01463</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01463.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01463.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01463.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01463.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_FUNCTIONAL</name>
      <anchorfile>a01463.html</anchorfile>
      <anchor>5a3c6a856c69528922516e729cda2eea</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/functional</name>
    <filename>a01464</filename>
    <namespace>std</namespace>
    <namespace>std::placeholders</namespace>
    <class kind="struct">std::__is_location_invariant</class>
    <class kind="struct">std::__is_location_invariant&lt; _Simple_type_wrapper&lt; _Tp &gt; &gt;</class>
    <class kind="union">std::_Any_data</class>
    <class kind="class">std::_Bind&lt; _Functor(_Bound_args...)&gt;</class>
    <class kind="class">std::_Bind_result&lt; _Result, _Functor(_Bound_args...)&gt;</class>
    <class kind="struct">std::_Build_index_tuple&lt; 0, _Index_tuple&lt; _Indexes...&gt; &gt;</class>
    <class kind="struct">std::_Build_index_tuple&lt; _Num, _Index_tuple&lt; _Indexes...&gt; &gt;</class>
    <class kind="struct">std::_Derives_from_binary_function</class>
    <class kind="struct">std::_Derives_from_unary_function</class>
    <class kind="class">std::_Function_base</class>
    <class kind="class">std::_Function_base::_Base_manager</class>
    <class kind="class">std::_Function_base::_Ref_manager</class>
    <class kind="class">std::_Function_handler&lt; _Res(_ArgTypes...), _Functor &gt;</class>
    <class kind="class">std::_Function_handler&lt; _Res(_ArgTypes...), _Member _Class::* &gt;</class>
    <class kind="class">std::_Function_handler&lt; _Res(_ArgTypes...), reference_wrapper&lt; _Functor &gt; &gt;</class>
    <class kind="class">std::_Function_handler&lt; void(_ArgTypes...), _Functor &gt;</class>
    <class kind="class">std::_Function_handler&lt; void(_ArgTypes...), _Member _Class::* &gt;</class>
    <class kind="class">std::_Function_handler&lt; void(_ArgTypes...), reference_wrapper&lt; _Functor &gt; &gt;</class>
    <class kind="struct">std::_Function_to_function_pointer</class>
    <class kind="struct">std::_Function_to_function_pointer&lt; _Tp, true &gt;</class>
    <class kind="struct">std::_Has_result_type</class>
    <class kind="class">std::_Has_result_type_helper</class>
    <class kind="struct">std::_Index_tuple</class>
    <class kind="struct">std::_Maybe_get_result_type</class>
    <class kind="struct">std::_Maybe_get_result_type&lt; true, _Functor &gt;</class>
    <class kind="struct">std::_Maybe_unary_or_binary_function</class>
    <class kind="struct">std::_Maybe_unary_or_binary_function&lt; _Res, _T1 &gt;</class>
    <class kind="struct">std::_Maybe_unary_or_binary_function&lt; _Res, _T1, _T2 &gt;</class>
    <class kind="struct">std::_Maybe_wrap_member_pointer</class>
    <class kind="struct">std::_Maybe_wrap_member_pointer&lt; _Tp _Class::* &gt;</class>
    <class kind="class">std::_Mem_fn&lt; _Res _Class::* &gt;</class>
    <class kind="struct">std::_Mem_fn&lt; _Res _Class::* &gt;::_Result_type</class>
    <class kind="struct">std::_Mem_fn&lt; _Res _Class::* &gt;::result&lt; _CVMem(_Tp &amp;)&gt;</class>
    <class kind="struct">std::_Mem_fn&lt; _Res _Class::* &gt;::result&lt; _CVMem(_Tp)&gt;</class>
    <class kind="class">std::_Mem_fn&lt; _Res(_Class::*)(_ArgTypes...) const &gt;</class>
    <class kind="class">std::_Mem_fn&lt; _Res(_Class::*)(_ArgTypes...) const volatile &gt;</class>
    <class kind="class">std::_Mem_fn&lt; _Res(_Class::*)(_ArgTypes...) volatile &gt;</class>
    <class kind="class">std::_Mem_fn&lt; _Res(_Class::*)(_ArgTypes...)&gt;</class>
    <class kind="struct">std::_Mem_fn_const_or_non</class>
    <class kind="struct">std::_Mem_fn_const_or_non&lt; _Tp, false &gt;</class>
    <class kind="class">std::_Mu&lt; _Arg, false, false &gt;</class>
    <class kind="struct">std::_Mu&lt; _Arg, false, false &gt;::result&lt; _CVMu(_CVArg, _Tuple)&gt;</class>
    <class kind="class">std::_Mu&lt; _Arg, false, true &gt;</class>
    <class kind="class">std::_Mu&lt; _Arg, false, true &gt;::result&lt; _CVMu(_CVArg, _Tuple)&gt;</class>
    <class kind="class">std::_Mu&lt; _Arg, true, false &gt;</class>
    <class kind="class">std::_Mu&lt; _Arg, true, false &gt;::result&lt; _CVMu(_CVArg, tuple&lt; _Args...&gt;)&gt;</class>
    <class kind="class">std::_Mu&lt; reference_wrapper&lt; _Tp &gt;, false, false &gt;</class>
    <class kind="union">std::_Nocopy_types</class>
    <class kind="struct">std::_Placeholder</class>
    <class kind="struct">std::_Reference_wrapper_base</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(*)(_T1)&gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(*)(_T1, _T2)&gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1)&gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1, _T2)&gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)() const &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)() const volatile &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)() volatile &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)()&gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)(_T2) const &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)(_T2) const volatile &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)(_T2) volatile &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base&lt; _Res(_T1::*)(_T2)&gt;</class>
    <class kind="struct">std::_Reference_wrapper_base_impl&lt; false, false, _Tp &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base_impl&lt; false, true, _Tp &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base_impl&lt; true, false, _Tp &gt;</class>
    <class kind="struct">std::_Reference_wrapper_base_impl&lt; true, true, _Tp &gt;</class>
    <class kind="struct">std::_Result_of_impl&lt; false, _Functor()&gt;</class>
    <class kind="struct">std::_Result_of_impl&lt; false, _Functor(_ArgTypes...)&gt;</class>
    <class kind="struct">std::_Result_of_impl&lt; false, _Res _Class::*(_T1)&gt;</class>
    <class kind="struct">std::_Result_of_impl&lt; true, _Functor(_ArgTypes...)&gt;</class>
    <class kind="struct">std::_Safe_tuple_element</class>
    <class kind="struct">std::_Safe_tuple_element_impl</class>
    <class kind="struct">std::_Safe_tuple_element_impl&lt; __i, _Tuple, false &gt;</class>
    <class kind="struct">std::_Simple_type_wrapper</class>
    <class kind="struct">std::_Weak_result_type</class>
    <class kind="struct">std::_Weak_result_type_impl</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(&amp;)(_ArgTypes...)&gt;</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(*)(_ArgTypes...)&gt;</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(_ArgTypes...)&gt;</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(_Class::*)(_ArgTypes...) const &gt;</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(_Class::*)(_ArgTypes...) const volatile &gt;</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(_Class::*)(_ArgTypes...) volatile &gt;</class>
    <class kind="struct">std::_Weak_result_type_impl&lt; _Res(_Class::*)(_ArgTypes...)&gt;</class>
    <class kind="class">std::bad_function_call</class>
    <class kind="class">std::function&lt; _Res(_ArgTypes...)&gt;</class>
    <class kind="struct">std::is_bind_expression</class>
    <class kind="struct">std::is_bind_expression&lt; _Bind&lt; _Signature &gt; &gt;</class>
    <class kind="struct">std::is_bind_expression&lt; _Bind_result&lt; _Result, _Signature &gt; &gt;</class>
    <class kind="struct">std::is_placeholder</class>
    <class kind="struct">std::is_placeholder&lt; _Placeholder&lt; _Num &gt; &gt;</class>
    <class kind="class">std::reference_wrapper</class>
    <class kind="class">std::result_of&lt; _Functor(_ArgTypes...)&gt;</class>
    <member kind="enumeration">
      <name>_Manager_operation</name>
      <anchor>5b32abd234bcbd0aef8abfdb3c0d5353</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Mem_fn&lt; _Member _Class::* &gt;</type>
      <name>__callable_functor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ec5877c364e0487da2e41151cb3bcaa9</anchor>
      <arglist>(_Member _Class::*const &amp;__p)</arglist>
    </member>
    <member kind="function">
      <type>_Mem_fn&lt; _Member _Class::* &gt;</type>
      <name>__callable_functor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ebb325ffd0b1ef83393d5d392e747aa1</anchor>
      <arglist>(_Member _Class::*&amp;__p)</arglist>
    </member>
    <member kind="function">
      <type>_Functor &amp;</type>
      <name>__callable_functor</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>87f595fbc423acd5eca4eca263c3c570</anchor>
      <arglist>(_Functor &amp;__f)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; (is_pointer&lt; _Functor &gt;::value &amp;&amp;is_function&lt; typename remove_pointer&lt; _Functor &gt;::type &gt;::value), typename result_of&lt; _Functor(_Args...)&gt;::type &gt;::__type</type>
      <name>__invoke</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0d522caba2185885892d5bc5301dc822</anchor>
      <arglist>(_Functor __f, _Args &amp;...__args)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; (!is_member_pointer&lt; _Functor &gt;::value &amp;&amp;!is_function&lt; _Functor &gt;::value &amp;&amp;!is_function&lt; typename remove_pointer&lt; _Functor &gt;::type &gt;::value), typename result_of&lt; _Functor(_Args...)&gt;::type &gt;::__type</type>
      <name>__invoke</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0f77a2a3d27b1a9abb67dc123de5e8ca</anchor>
      <arglist>(_Functor &amp;__f, _Args &amp;...__args)</arglist>
    </member>
    <member kind="function">
      <type>_Bind&lt; typename _Maybe_wrap_member_pointer&lt; _Functor &gt;::type(_ArgTypes...)&gt;</type>
      <name>bind</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bc0727effbbc3a8a46ea54174966d46f</anchor>
      <arglist>(_Functor __f, _ArgTypes...__args)</arglist>
    </member>
    <member kind="function">
      <type>reference_wrapper&lt; const _Tp &gt;</type>
      <name>cref</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>56b5f5b5e10899b2f028cb82c3bcc01e</anchor>
      <arglist>(reference_wrapper&lt; _Tp &gt; __t)</arglist>
    </member>
    <member kind="function">
      <type>reference_wrapper&lt; const _Tp &gt;</type>
      <name>cref</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>68857d492ec457916f35e7403da567bf</anchor>
      <arglist>(const _Tp &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>_Mem_fn&lt; _Tp _Class::* &gt;</type>
      <name>mem_fn</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c45277b565dfb4ee9e72221e639f16b6</anchor>
      <arglist>(_Tp _Class::*__pm)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8cade98247cafb2ddf5497c3d14fd9dd</anchor>
      <arglist>(_M_clear_type *, const function&lt; _Signature &gt; &amp;__f)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>da9e38147f4215082a7966d3164ba46b</anchor>
      <arglist>(const function&lt; _Signature &gt; &amp;__f, _M_clear_type *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>85b409fe39067872dc417fa482034a60</anchor>
      <arglist>(_M_clear_type *, const function&lt; _Signature &gt; &amp;__f)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d00d73220ff3547282ee8ea420b18627</anchor>
      <arglist>(const function&lt; _Signature &gt; &amp;__f, _M_clear_type *)</arglist>
    </member>
    <member kind="function">
      <type>reference_wrapper&lt; _Tp &gt;</type>
      <name>ref</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4d8a658fd0ef17e83ea9c8dd11dfa905</anchor>
      <arglist>(reference_wrapper&lt; _Tp &gt; __t)</arglist>
    </member>
    <member kind="function">
      <type>reference_wrapper&lt; _Tp &gt;</type>
      <name>ref</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8a8c31e9617c8da354f78376f04efe2d</anchor>
      <arglist>(_Tp &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4535fb647a5b18fe6a47d9ed61df62a9</anchor>
      <arglist>(function&lt; _Signature &gt; &amp;__x, function&lt; _Signature &gt; &amp;__y)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 1 &gt;</type>
      <name>_1</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>916dc6c2fed36a333f5c69decb5cb358</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 10 &gt;</type>
      <name>_10</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>ffa1b2ba91d651c645517e720dd18efa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 11 &gt;</type>
      <name>_11</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>40ebb7ca5c5494bb6015286985989fe8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 12 &gt;</type>
      <name>_12</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>80a4807f88d72948ba45a0b56d449bfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 13 &gt;</type>
      <name>_13</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>264f14f7102f77ba47517184333db11e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 14 &gt;</type>
      <name>_14</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>f8227be53ed3bcbdab9e80a85552f87d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 15 &gt;</type>
      <name>_15</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>773270070f17d004776b43b471215dac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 16 &gt;</type>
      <name>_16</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>8c777738691e185bc2f0e30988855cc1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 17 &gt;</type>
      <name>_17</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>9abed4ad4dcfd923bc46040d386b5d8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 18 &gt;</type>
      <name>_18</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>d934e4bc9d7b642dc97e88df9a1d4159</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 19 &gt;</type>
      <name>_19</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>90b6b705efff4b71d97e5612d8a674aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 2 &gt;</type>
      <name>_2</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>ebe3fa9078b02f5633163300b212c7b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 20 &gt;</type>
      <name>_20</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>53305c809c4d74d7115ef3a0560f40a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 21 &gt;</type>
      <name>_21</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>fe0e6c6beef50e3118a3929bd83d1313</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 22 &gt;</type>
      <name>_22</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>563ecee6896a1a2b7a293ed4006cb88b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 23 &gt;</type>
      <name>_23</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>c69906fdd449e5669e8420c43ccada5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 24 &gt;</type>
      <name>_24</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>33c9a00e11db44b60dda601398ce039e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 25 &gt;</type>
      <name>_25</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>952b129af0257d9e35fe8147e85bfabe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 26 &gt;</type>
      <name>_26</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>5478c875e6853e26ab2382cf751a0a8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 27 &gt;</type>
      <name>_27</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>02796d1abe9da15f07ddc59917694779</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 28 &gt;</type>
      <name>_28</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>1ce9c58b9a19483dd6605172a6572234</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 29 &gt;</type>
      <name>_29</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>65bacfdd18b1f9bb73b8348904e4bc84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 3 &gt;</type>
      <name>_3</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>d15d848d4ec673814eb2772ecc2b15b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 4 &gt;</type>
      <name>_4</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>0b4d9fdc47cacff08143ce9ac5dd471c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 5 &gt;</type>
      <name>_5</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>2cee88b74efccec02b350c0a04137656</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 6 &gt;</type>
      <name>_6</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>1d8253fcd95a9e6b62784c155783f498</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 7 &gt;</type>
      <name>_7</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>0e4a613b5c81757cc3ed71269774eea1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 8 &gt;</type>
      <name>_8</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>110fb5d25d79a2741984932151ec0ceb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Placeholder&lt; 9 &gt;</type>
      <name>_9</name>
      <anchorfile>a01702.html</anchorfile>
      <anchor>ac25e6f6802b0fa82a583563364372df</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bits/functional_hash.h</name>
    <filename>a01465</filename>
    <member kind="define">
      <type>#define</type>
      <name>_FUNCTIONAL_HASH_H</name>
      <anchorfile>a01465.html</anchorfile>
      <anchor>13454ca67f49400987173932beef103b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/functional_hash.h</name>
    <filename>a01466</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01466.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01466.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01466.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01466.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_FUNCTIONAL_HASH_H</name>
      <anchorfile>a01466.html</anchorfile>
      <anchor>35f5a4a039330c2898168d5c2d2510d8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/functional_hash.h</name>
    <filename>a01467</filename>
    <namespace>std</namespace>
    <class kind="struct">std::_Fnv_hash</class>
    <class kind="struct">std::_Fnv_hash&lt; 4 &gt;</class>
    <class kind="struct">std::_Fnv_hash&lt; 8 &gt;</class>
    <class kind="struct">std::hash</class>
    <class kind="struct">std::hash&lt; _Tp * &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_hashtable_define_trivial_hash</name>
      <anchorfile>a01467.html</anchorfile>
      <anchor>95fbac97409f52a5b2183301880df915</anchor>
      <arglist>(_Tp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>functions.h</name>
    <filename>a01468</filename>
    <namespace>__gnu_debug</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_FUNCTIONS_H</name>
      <anchorfile>a01468.html</anchorfile>
      <anchor>a17bea9f9554dddba0982d063cd2f590</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_dereferenceable</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>82e02f3e5c9143e30d783a057c87d355</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_dereferenceable</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>8c6fd079d17fca05cfe40944f8d9a1ef</anchor>
      <arglist>(const _Tp *__ptr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_dereferenceable</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>622c9f45dd6947be236b97dc4ed75f91</anchor>
      <arglist>(_Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_partitioned_lower</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>14bac96e71f0e96af6e725de412db535</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value, _Pred __pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_partitioned_lower</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>8b0a757b6e8bec406d26711498bda042</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_partitioned_upper</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>c1f7f3088db6e8a3fbfa4cdf90d69389</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value, _Pred __pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_partitioned_upper</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>e4bdf7f5184612dd164e73177fa2c304</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_singular</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>b58f161927e89166e2489fcb262997a3</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_singular</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>70dca2d374499cabbc6be9e6749ae747</anchor>
      <arglist>(const _Tp *__ptr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_singular</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>da0ca0da823b71f847a0f2f9438a8a72</anchor>
      <arglist>(_Iterator &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_singular_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>610473f07918058566a1d3e3b80fb778</anchor>
      <arglist>(const void *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ed608bbda9939783a378e8932dd4865a</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>338258703e0680679cb1fc52b183c00f</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>db40a4fa5908ec9c77d04b05be43686a</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred, std::forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>d5c57cc775fb0ee12308e1503d124060</anchor>
      <arglist>(const _InputIterator &amp;, const _InputIterator &amp;, _Predicate, std::input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>cfe189ff82038cb684664d13d9ffc635</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, std::forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>0aee02c23b2bf0b2da194d6ce8abd536</anchor>
      <arglist>(const _InputIterator &amp;, const _InputIterator &amp;, std::input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_set</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>3fe012f97a99fcd9415d7bafbcf01c5d</anchor>
      <arglist>(const _InputIterator1 &amp;__first, const _InputIterator1 &amp;__last, const _InputIterator2 &amp;, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_set</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>c40f00817c99c483c98d62b90d4405f9</anchor>
      <arglist>(const _InputIterator1 &amp;__first, const _InputIterator1 &amp;__last, const _InputIterator2 &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_set_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>f51050122a1379fc4f7e281129bd553b</anchor>
      <arglist>(const _InputIterator &amp;, const _InputIterator &amp;, _Predicate, std::__false_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_set_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ccc0b25c3687bf5d10683022be3b36c4</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last, _Predicate __pred, std::__true_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_set_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>f20f64e6bee5c4f08497456f022c2a74</anchor>
      <arglist>(const _InputIterator &amp;, const _InputIterator &amp;, std::__false_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_sorted_set_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>0cfb87b9ddbf237bb5ef6f4942ff5c8e</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last, std::__true_type)</arglist>
    </member>
    <member kind="function">
      <type>const _CharT *</type>
      <name>__check_string</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>753b898d5a4b1bceb637ccd5d26519f0</anchor>
      <arglist>(const _CharT *__s)</arglist>
    </member>
    <member kind="function">
      <type>const _CharT *</type>
      <name>__check_string</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>6a094201c545c0f8516d9939e5037443</anchor>
      <arglist>(const _CharT *__s, const _Integer &amp;__n __attribute__((__unused__)))</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>__check_valid_range</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>426e06c43eb97e990d3a8364b6e7b03c</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last __attribute__((__unused__)))</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__valid_range</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>726a4cdafbf8055cdbca61ca41d1e277</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__first, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__valid_range</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ff6e9ff62313bcd4c24bdd886efcf653</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__valid_range_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ecbbb4a9642f141d09c47f9b9ea12e55</anchor>
      <arglist>(const _InputIterator &amp;__first, const _InputIterator &amp;__last, std::__false_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__valid_range_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>a322d404d441bac9ea25b8b891303a61</anchor>
      <arglist>(const _Integral &amp;, const _Integral &amp;, std::__true_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__valid_range_aux2</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>16a2caa38f10bd8a1803a0e81318271a</anchor>
      <arglist>(const _InputIterator &amp;, const _InputIterator &amp;, std::input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__valid_range_aux2</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>8237d49d06967a300a076d85a9d99d30</anchor>
      <arglist>(const _RandomAccessIterator &amp;__first, const _RandomAccessIterator &amp;__last, std::random_access_iterator_tag)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gamma.tcc</name>
    <filename>a01469</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_GAMMA_TCC</name>
      <anchorfile>a01469.html</anchorfile>
      <anchor>b928265977597de6fda8fa2f050af3b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__bernoulli</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>e3c302fb63fe11fd5b34b6103843d3b0</anchor>
      <arglist>(const int __n)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__bernoulli_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>ca452b42fa330d43b71747999a52c794</anchor>
      <arglist>(unsigned int __n)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__bincoef</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>31fa5541095e07048e63a2df8625aba9</anchor>
      <arglist>(const unsigned int __n, const unsigned int __k)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__gamma</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>be0f00733a72f6d8a83e3112ecfe8cda</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__log_bincoef</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>2682014b4f77d89f185e6b062f835383</anchor>
      <arglist>(const unsigned int __n, const unsigned int __k)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__log_gamma</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>4ae23dfbe777bf20579b84ba2f689a7a</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__log_gamma_bernoulli</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>ac24b92bbc011fe7fd6070324ba9b241</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__log_gamma_lanczos</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>215de7fb48b704e95aae5195bb408a3d</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__log_gamma_sign</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>33bb67f5a27788a7183fd0d5712bcc6b</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__psi</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>f0d8105680f6e7e9ac7cfdb68c881c73</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__psi</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>ff24a51be6ff0c62470b8a8b6d4552a3</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__psi_asymp</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>a401dd726a891344113419363debf5c5</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__psi_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>6723ea12ad9a09e34cdfbf9951bfd629</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gslice.h</name>
    <filename>a01470</filename>
    <namespace>std</namespace>
    <class kind="class">std::gslice</class>
    <member kind="define">
      <type>#define</type>
      <name>_GSLICE_H</name>
      <anchorfile>a01470.html</anchorfile>
      <anchor>4a0dcfe6e9d5c333f59efb05d47d8b8d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gslice_array.h</name>
    <filename>a01471</filename>
    <namespace>std</namespace>
    <class kind="class">std::gslice_array</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_OPERATOR</name>
      <anchorfile>a01471.html</anchorfile>
      <anchor>2d8d2d09544ebac440902adb07bbc233</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GSLICE_ARRAY_H</name>
      <anchorfile>a01471.html</anchorfile>
      <anchor>0e92faeee848914121e4dbf249c3db95</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hash_fun.h</name>
    <filename>a01477</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::hash</class>
    <class kind="struct">__gnu_cxx::hash&lt; char * &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; char &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; const char * &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; int &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; long &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; short &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; signed char &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; unsigned char &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; unsigned int &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; unsigned long &gt;</class>
    <class kind="struct">__gnu_cxx::hash&lt; unsigned short &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_HASH_FUN_H</name>
      <anchorfile>a01477.html</anchorfile>
      <anchor>ef4ae42a615530d78c2433f1e83bc793</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>__stl_hash_string</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6560f09c02752bcbafd9d153dc456c9a</anchor>
      <arglist>(const char *__s)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hash_map</name>
    <filename>a01478</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="class">__gnu_cxx::hash_map</class>
    <class kind="class">__gnu_cxx::hash_multimap</class>
    <class kind="class">std::insert_iterator&lt; __gnu_cxx::hash_map&lt; _Key, _Tp, _HashFn, _EqKey, _Alloc &gt; &gt;</class>
    <class kind="class">std::insert_iterator&lt; __gnu_cxx::hash_multimap&lt; _Key, _Tp, _HashFn, _EqKey, _Alloc &gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_HASH_MAP</name>
      <anchorfile>a01478.html</anchorfile>
      <anchor>d62b51b7672baedf3cccb6a86b4f3c20</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d3b4de8df3b04b0c619a746d2fd8da7c</anchor>
      <arglist>(const hash_multimap&lt; _Key, _Tp, _HF, _EqKey, _Alloc &gt; &amp;__hm1, const hash_multimap&lt; _Key, _Tp, _HF, _EqKey, _Alloc &gt; &amp;__hm2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6a54cfff3f2f6ac7598d99b21a6aeb92</anchor>
      <arglist>(const hash_map&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm1, const hash_map&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>662ad6559e9cbb9572cb6df16fdd3197</anchor>
      <arglist>(const hash_multimap&lt; _Key, _Tp, _HF, _EqKey, _Alloc &gt; &amp;__hm1, const hash_multimap&lt; _Key, _Tp, _HF, _EqKey, _Alloc &gt; &amp;__hm2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>84297f79387aab1a43d087aa5c962373</anchor>
      <arglist>(const hash_map&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm1, const hash_map&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>8d1d748183a8ca85570a4daee7a15e60</anchor>
      <arglist>(hash_multimap&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm1, hash_multimap&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>169d24e7924908c0701360393364eb7d</anchor>
      <arglist>(hash_map&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm1, hash_map&lt; _Key, _Tp, _HashFn, _EqlKey, _Alloc &gt; &amp;__hm2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hash_policy.hpp</name>
    <filename>a01479</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="class">__gnu_pbds::cc_hash_max_collision_check_resize_trigger</class>
    <class kind="class">__gnu_pbds::direct_mask_range_hashing</class>
    <class kind="class">__gnu_pbds::direct_mod_range_hashing</class>
    <class kind="class">__gnu_pbds::hash_exponential_size_policy</class>
    <class kind="class">__gnu_pbds::hash_load_check_resize_trigger</class>
    <class kind="class">__gnu_pbds::hash_prime_size_policy</class>
    <class kind="class">__gnu_pbds::hash_standard_resize_policy</class>
    <class kind="class">__gnu_pbds::linear_probe_fn</class>
    <class kind="struct">__gnu_pbds::null_hash_fn</class>
    <class kind="struct">__gnu_pbds::null_probe_fn</class>
    <class kind="class">__gnu_pbds::quadratic_probe_fn</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_SIZE_BASE_C_DEC</name>
      <anchorfile>a01479.html</anchorfile>
      <anchor>40b9e65d34833b82cbb2b9320070d300</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hash_set</name>
    <filename>a01480</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="class">__gnu_cxx::hash_multiset</class>
    <class kind="class">__gnu_cxx::hash_set</class>
    <class kind="class">std::insert_iterator&lt; __gnu_cxx::hash_multiset&lt; _Value, _HashFcn, _EqualKey, _Alloc &gt; &gt;</class>
    <class kind="class">std::insert_iterator&lt; __gnu_cxx::hash_set&lt; _Value, _HashFcn, _EqualKey, _Alloc &gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_HASH_SET</name>
      <anchorfile>a01480.html</anchorfile>
      <anchor>fb250519285258bda6e2af79b1d3f1b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ec5be242c1dd934641e6cb247059378e</anchor>
      <arglist>(const hash_multiset&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs1, const hash_multiset&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>91e3772b4ef2b9cf48a0aec540350ea6</anchor>
      <arglist>(const hash_set&lt; _Value, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs1, const hash_set&lt; _Value, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>4c3966c724bdfbfe9ffbcd4a1d6569e7</anchor>
      <arglist>(const hash_multiset&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs1, const hash_multiset&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>032a8b557776ba14d341324eda78d952</anchor>
      <arglist>(const hash_set&lt; _Value, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs1, const hash_set&lt; _Value, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>1d45a32aaebe0ca6b5402b950471f881</anchor>
      <arglist>(hash_multiset&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs1, hash_multiset&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>11c72aafddb5c14fc74ec7422f750d7b</anchor>
      <arglist>(hash_set&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs1, hash_set&lt; _Val, _HashFcn, _EqualKey, _Alloc &gt; &amp;__hs2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hashtable</name>
    <filename>a01481</filename>
    <namespace>std</namespace>
    <class kind="class">std::_Hashtable</class>
  </compound>
  <compound kind="file">
    <name>backward/hashtable.h</name>
    <filename>a01482</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::_Hashtable_const_iterator</class>
    <class kind="struct">__gnu_cxx::_Hashtable_iterator</class>
    <class kind="struct">__gnu_cxx::_Hashtable_node</class>
    <class kind="class">__gnu_cxx::hashtable</class>
    <member kind="define">
      <type>#define</type>
      <name>_HASHTABLE_H</name>
      <anchorfile>a01482.html</anchorfile>
      <anchor>f4fbfc8b1578cbb09873ea594ba965d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>__stl_next_prime</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>09359cc3b4fe6125cbfdf0b2e0bc674c</anchor>
      <arglist>(unsigned long __n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>b24ecf3ba1761cf6e332e14a222a59d9</anchor>
      <arglist>(const hashtable&lt; _Val, _Key, _HF, _Ex, _Eq, _All &gt; &amp;__ht1, const hashtable&lt; _Val, _Key, _HF, _Ex, _Eq, _All &gt; &amp;__ht2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>8656d5e65eb69cfc6f11379ddaeace75</anchor>
      <arglist>(const hashtable&lt; _Val, _Key, _HF, _Ex, _Eq, _All &gt; &amp;__ht1, const hashtable&lt; _Val, _Key, _HF, _Ex, _Eq, _All &gt; &amp;__ht2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>28d44cb3c1faec413d84557c7ada877f</anchor>
      <arglist>(hashtable&lt; _Val, _Key, _HF, _Extract, _EqKey, _All &gt; &amp;__ht1, hashtable&lt; _Val, _Key, _HF, _Extract, _EqKey, _All &gt; &amp;__ht2)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const unsigned long</type>
      <name>__stl_prime_list</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>2219f9b57521e86edd9636313d89f0fa</anchor>
      <arglist>[_S_num_primes]</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>bits/hashtable.h</name>
    <filename>a01483</filename>
    <member kind="define">
      <type>#define</type>
      <name>_HASHTABLE_H</name>
      <anchorfile>a01483.html</anchorfile>
      <anchor>f4fbfc8b1578cbb09873ea594ba965d3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/hashtable.h</name>
    <filename>a01484</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01484.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01484.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01484.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01484.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_HASHTABLE_H</name>
      <anchorfile>a01484.html</anchorfile>
      <anchor>cc8969c7ca6b2057714a7c52619ab40a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hashtable_policy.h</name>
    <filename>a01485</filename>
    <namespace>std</namespace>
    <namespace>std::__detail</namespace>
    <class kind="struct">std::__detail::_Default_ranged_hash</class>
    <class kind="struct">std::__detail::_Hash_code_base&lt; _Key, _Value, _ExtractKey, _Equal, _H1, _H2, _Default_ranged_hash, false &gt;</class>
    <class kind="struct">std::__detail::_Hash_code_base&lt; _Key, _Value, _ExtractKey, _Equal, _H1, _H2, _Default_ranged_hash, true &gt;</class>
    <class kind="struct">std::__detail::_Hash_code_base&lt; _Key, _Value, _ExtractKey, _Equal, _H1, _H2, _Hash, false &gt;</class>
    <class kind="struct">std::__detail::_Hash_node&lt; _Value, false &gt;</class>
    <class kind="struct">std::__detail::_Hash_node&lt; _Value, true &gt;</class>
    <class kind="struct">std::__detail::_Hashtable_const_iterator</class>
    <class kind="struct">std::__detail::_Hashtable_iterator</class>
    <class kind="struct">std::__detail::_Hashtable_iterator_base</class>
    <class kind="struct">std::__detail::_Map_base</class>
    <class kind="struct">std::__detail::_Map_base&lt; _Key, _Pair, std::_Select1st&lt; _Pair &gt;, false, _Hashtable &gt;</class>
    <class kind="struct">std::__detail::_Map_base&lt; _Key, _Pair, std::_Select1st&lt; _Pair &gt;, true, _Hashtable &gt;</class>
    <class kind="struct">std::__detail::_Mod_range_hashing</class>
    <class kind="struct">std::__detail::_Node_const_iterator</class>
    <class kind="struct">std::__detail::_Node_iterator</class>
    <class kind="struct">std::__detail::_Node_iterator_base</class>
    <class kind="struct">std::__detail::_Prime_rehash_policy</class>
    <class kind="struct">std::__detail::_Rehash_base</class>
    <class kind="struct">std::__detail::_Rehash_base&lt; _Prime_rehash_policy, _Hashtable &gt;</class>
    <member kind="function">
      <type>std::iterator_traits&lt; _Iterator &gt;::difference_type</type>
      <name>__distance_fw</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>89d9b9bcf6c9970afc288ee4204423ed</anchor>
      <arglist>(_Iterator __first, _Iterator __last)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; _Iterator &gt;::difference_type</type>
      <name>__distance_fw</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>8e94cb41bb2de089d8c77bc876f7e682</anchor>
      <arglist>(_Iterator __first, _Iterator __last, std::forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; _Iterator &gt;::difference_type</type>
      <name>__distance_fw</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>514245dfefddfb2d6e50ee772d832742</anchor>
      <arglist>(_Iterator __first, _Iterator __last, std::input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_RAIter</type>
      <name>__lower_bound</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>e7f1f89465bc89c5f6b895b78475e190</anchor>
      <arglist>(_RAIter __first, _RAIter __last, const _Tp &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>e4eb61e524a767e00becb1d683a646be</anchor>
      <arglist>(const _Hashtable_iterator_base&lt; _Value, __cache &gt; &amp;__x, const _Hashtable_iterator_base&lt; _Value, __cache &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>f746fe27c02e2052f5f2408ce8d9d8c5</anchor>
      <arglist>(const _Node_iterator_base&lt; _Value, __cache &gt; &amp;__x, const _Node_iterator_base&lt; _Value, __cache &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>f5a61a346875f26032efd3b142c564f9</anchor>
      <arglist>(const _Hashtable_iterator_base&lt; _Value, __cache &gt; &amp;__x, const _Hashtable_iterator_base&lt; _Value, __cache &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>f6f0e6e4134830b7db9c83aa05a1d99a</anchor>
      <arglist>(const _Node_iterator_base&lt; _Value, __cache &gt; &amp;__x, const _Node_iterator_base&lt; _Value, __cache &gt; &amp;__y)</arglist>
    </member>
    <member kind="variable">
      <type>const unsigned long</type>
      <name>__prime_list</name>
      <anchorfile>a01700.html</anchorfile>
      <anchor>c161b3bfd583647ec8590e79c4f7229b</anchor>
      <arglist>[]</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hypergeometric.tcc</name>
    <filename>a01486</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_HYPERGEOMETRIC_TCC</name>
      <anchorfile>a01486.html</anchorfile>
      <anchor>4b6d49cc9dabc2afbac88f3ec7f71564</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__conf_hyperg</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>b68c8f85b28664e65a7cbb981a85db09</anchor>
      <arglist>(const _Tp __a, const _Tp __c, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__conf_hyperg_luke</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>05b966deae9096cde5594eae0775cab5</anchor>
      <arglist>(const _Tp __a, const _Tp __c, const _Tp __xin)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__conf_hyperg_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>d6a53dcf16c760293edcc302abd5c07f</anchor>
      <arglist>(const _Tp __a, const _Tp __c, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__hyperg</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>3df041342bd483d665ba09cab7cb4892</anchor>
      <arglist>(const _Tp __a, const _Tp __b, const _Tp __c, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__hyperg_luke</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>141ab89c4cb2d0b3d8d3712618215511</anchor>
      <arglist>(const _Tp __a, const _Tp __b, const _Tp __c, const _Tp __xin)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__hyperg_reflect</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>7cb2c33116de4bd6547d184dba0e2a4f</anchor>
      <arglist>(const _Tp __a, const _Tp __b, const _Tp __c, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__hyperg_series</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>5c93c52d9a51a7faf03eec8751a06c62</anchor>
      <arglist>(const _Tp __a, const _Tp __b, const _Tp __c, const _Tp __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>indirect_array.h</name>
    <filename>a01488</filename>
    <namespace>std</namespace>
    <class kind="class">std::indirect_array</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_OPERATOR</name>
      <anchorfile>a01488.html</anchorfile>
      <anchor>2d8d2d09544ebac440902adb07bbc233</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_INDIRECT_ARRAY_H</name>
      <anchorfile>a01488.html</anchorfile>
      <anchor>c993796bdebea28445928252e3c33a02</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>inttypes.h</name>
    <filename>a01489</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_INTTYPES_H</name>
      <anchorfile>a01489.html</anchorfile>
      <anchor>e916713e6a140687ff8b1c30e25d183e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iomanip</name>
    <filename>a01490</filename>
    <namespace>std</namespace>
    <class kind="struct">std::_Resetiosflags</class>
    <class kind="struct">std::_Setbase</class>
    <class kind="struct">std::_Setfill</class>
    <class kind="struct">std::_Setiosflags</class>
    <class kind="struct">std::_Setprecision</class>
    <class kind="struct">std::_Setw</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_IOMANIP</name>
      <anchorfile>a01490.html</anchorfile>
      <anchor>5579d4324afc6b9658c76651eb7e664b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>da6744d5e681950a2eda06cf114e80ef</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, _Setw __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5e2d0cf88b91521bc7b7c7892efb458a</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, _Setprecision __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4bbf848c4ff84eb4dce799618525c2e5</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, _Setfill&lt; _CharT &gt; __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b44b82120205915e159bc0918d976c24</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, _Setbase __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4d1623d114f10ed71fbe2dac40a45d2d</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, _Setiosflags __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>46091545c4a361e5a1cab75073d63261</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, _Resetiosflags __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6cfa2d32f2aa07454c88166e2fa246d7</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, _Setw __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5309afab78cb3827b6ad527d3d734b46</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, _Setprecision __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b649fbda81dba264a5e25bb5ba64b47f</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, _Setfill&lt; _CharT &gt; __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bdf9cec1293b7487d7aa8f8b82568b54</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, _Setbase __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7c661acf09b3ac0219a2b80813e5b457</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, _Setiosflags __f)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>43e13e17126760db34a3aadea37de28f</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is, _Resetiosflags __f)</arglist>
    </member>
    <member kind="function">
      <type>_Resetiosflags</type>
      <name>resetiosflags</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>679d1f10bbd46482a6392173ce2aba95</anchor>
      <arglist>(ios_base::fmtflags __mask)</arglist>
    </member>
    <member kind="function">
      <type>_Setbase</type>
      <name>setbase</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b9030e7cfdb1fd864179f7589bab7818</anchor>
      <arglist>(int __base)</arglist>
    </member>
    <member kind="function">
      <type>_Setfill&lt; _CharT &gt;</type>
      <name>setfill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a658ae52cb78d292e3e9fb2dba8793bb</anchor>
      <arglist>(_CharT __c)</arglist>
    </member>
    <member kind="function">
      <type>_Setiosflags</type>
      <name>setiosflags</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4ea2784aa0ddc104a0108204349f1c67</anchor>
      <arglist>(ios_base::fmtflags __mask)</arglist>
    </member>
    <member kind="function">
      <type>_Setprecision</type>
      <name>setprecision</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d144ea244605dd88248705744073becd</anchor>
      <arglist>(int __n)</arglist>
    </member>
    <member kind="function">
      <type>_Setw</type>
      <name>setw</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bd07880aa68c2ff1d4d4529a976c72b2</anchor>
      <arglist>(int __n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ios</name>
    <filename>a01491</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_IOS</name>
      <anchorfile>a01491.html</anchorfile>
      <anchor>1200452b3a2d806b5f4b71299d18f222</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ios_base.h</name>
    <filename>a01492</filename>
    <namespace>std</namespace>
    <class kind="class">std::ios_base</class>
    <class kind="struct">std::ios_base::_Callback_list</class>
    <class kind="struct">std::ios_base::_Words</class>
    <class kind="class">std::ios_base::failure</class>
    <class kind="class">std::ios_base::Init</class>
    <member kind="define">
      <type>#define</type>
      <name>_IOS_BASE_H</name>
      <anchorfile>a01492.html</anchorfile>
      <anchor>e553029ec20a198f2c911a78b68122f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Ios_Fmtflags</name>
      <anchor>bbb171afbc9c149101e715b26ecfba36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Ios_Iostate</name>
      <anchor>80e34095b68e66c5448bd5d01474ec3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Ios_Openmode</name>
      <anchor>81b4afbd08a8e2fa4a80e1eb942c9a66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Ios_Seekdir</name>
      <anchor>1a07f890a4472d15df47533e4cf6e439</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>boolalpha</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8c166181b2b45922766022323f3fb2e9</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>dec</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1354ba0305ce7c6685bf8ca7754d269f</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>fixed</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a391af879d5308fe08bbcbaf9da0932f</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>hex</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9bbf6cda99eb552010c1e7ebf8cdd175</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>internal</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>13f103ac23f469ac8881707512dfe8f0</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>left</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f4c18f9740e817f6dc4a914ba0e28cf3</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>noboolalpha</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bfa93e44f28e514ae11456a342d7219f</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>noshowbase</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>70f8a9d35f8fd6ebfca4d9c4ce1e97dc</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>noshowpoint</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>85cbd5b1910f10d0f60931297af9aa4a</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>noshowpos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5f6b88c28581d1bfccd9d5aadd59604a</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>noskipws</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4b9cff3b4da876af9e98f45927bb6ce3</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>nounitbuf</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>96220eb161d9266e3b4e209941297859</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>nouppercase</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3bddf5f9e8b247a807046177fb8be29e</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>oct</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3baa899af4b56d5b60efe2c4c7976242</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate</type>
      <name>operator &amp;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c591d3ec9599e63df4271b015e6c2603</anchor>
      <arglist>(_Ios_Iostate __a, _Ios_Iostate __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode</type>
      <name>operator &amp;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ecfacd592c09d12e2290e081dbab4c32</anchor>
      <arglist>(_Ios_Openmode __a, _Ios_Openmode __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags</type>
      <name>operator &amp;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f3f1686e30a490f977c49ce2d28e2bfc</anchor>
      <arglist>(_Ios_Fmtflags __a, _Ios_Fmtflags __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate &amp;</type>
      <name>operator &amp;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>29b5b1a9ee7c2d693179f61ddbbd11ce</anchor>
      <arglist>(_Ios_Iostate &amp;__a, _Ios_Iostate __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode &amp;</type>
      <name>operator &amp;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9bf7fad8446adad2473b24911ac6bd4c</anchor>
      <arglist>(_Ios_Openmode &amp;__a, _Ios_Openmode __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags &amp;</type>
      <name>operator &amp;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>540413d0fafc061d350dfed308299704</anchor>
      <arglist>(_Ios_Fmtflags &amp;__a, _Ios_Fmtflags __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate</type>
      <name>operator^</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dcf45f87828611f3377a0f7f553c942b</anchor>
      <arglist>(_Ios_Iostate __a, _Ios_Iostate __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode</type>
      <name>operator^</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0b8dcab139710b3a890a8113038c9339</anchor>
      <arglist>(_Ios_Openmode __a, _Ios_Openmode __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags</type>
      <name>operator^</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>69f78687179b94002de5dbaf6323ac7c</anchor>
      <arglist>(_Ios_Fmtflags __a, _Ios_Fmtflags __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate &amp;</type>
      <name>operator^=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>43b64be2a11624e7b919243cd3356082</anchor>
      <arglist>(_Ios_Iostate &amp;__a, _Ios_Iostate __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode &amp;</type>
      <name>operator^=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>213ddd5eb94e08f41af0ad3623b249d9</anchor>
      <arglist>(_Ios_Openmode &amp;__a, _Ios_Openmode __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags &amp;</type>
      <name>operator^=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>925d7da41cd10a6007fb6743e1d5e2f7</anchor>
      <arglist>(_Ios_Fmtflags &amp;__a, _Ios_Fmtflags __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate</type>
      <name>operator|</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7e59b14e241e2d962468cac06f45185b</anchor>
      <arglist>(_Ios_Iostate __a, _Ios_Iostate __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode</type>
      <name>operator|</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>880c4a79432a067a76d1d1b29054b6d2</anchor>
      <arglist>(_Ios_Openmode __a, _Ios_Openmode __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags</type>
      <name>operator|</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7885c74f2836ca1d712f3757f30852e6</anchor>
      <arglist>(_Ios_Fmtflags __a, _Ios_Fmtflags __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate &amp;</type>
      <name>operator|=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5cf3f04286f428284d6e40d98de67b9f</anchor>
      <arglist>(_Ios_Iostate &amp;__a, _Ios_Iostate __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode &amp;</type>
      <name>operator|=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9b9e029217bf70424754071756326327</anchor>
      <arglist>(_Ios_Openmode &amp;__a, _Ios_Openmode __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags &amp;</type>
      <name>operator|=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>74430ec09e130d82cbafbb8ef80cc256</anchor>
      <arglist>(_Ios_Fmtflags &amp;__a, _Ios_Fmtflags __b)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Iostate</type>
      <name>operator~</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7a659492274a02c2339cff8a068f7f22</anchor>
      <arglist>(_Ios_Iostate __a)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Openmode</type>
      <name>operator~</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1d283fe8c3132db5886bfa3d7fbf86bc</anchor>
      <arglist>(_Ios_Openmode __a)</arglist>
    </member>
    <member kind="function">
      <type>_Ios_Fmtflags</type>
      <name>operator~</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>07da180b49654cdfd85be39ccf28abe0</anchor>
      <arglist>(_Ios_Fmtflags __a)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>right</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ae665368593b0b8456470655148626d1</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>scientific</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>440060ca3acb2c3cc63c950797264dc1</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>showbase</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9aaa104413ad45c41d9e36712a5bb9ea</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>showpoint</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6c14e51b3d4f27b0fc4e7663bf4332bc</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>showpos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9db92f52c3c9733a573c7683f63f16fb</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>skipws</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ee35bd487f4faefefd8ecfcf79245947</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>unitbuf</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c924e7ec9dd1e852689b311ea743ca95</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
    <member kind="function">
      <type>ios_base &amp;</type>
      <name>uppercase</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3c5fae77be423f624bca890c017e8798</anchor>
      <arglist>(ios_base &amp;__base)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iosfwd</name>
    <filename>a01493</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_IOSFWD</name>
      <anchorfile>a01493.html</anchorfile>
      <anchor>4f313df6d6ca3d198f54b4e40df8755c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_filebuf&lt; char &gt;</type>
      <name>filebuf</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g3fb5e32accf74a06c4be53b9a754cc41</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_fstream&lt; char &gt;</type>
      <name>fstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g11ed9f66044b50031858beae85006346</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ifstream&lt; char &gt;</type>
      <name>ifstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g1ee50e2b59202595ec9b2b54be7057cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ios&lt; char &gt;</type>
      <name>ios</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g78c85296d338dfd4e9a00e9ee8d8dd16</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_iostream&lt; char &gt;</type>
      <name>iostream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g0ec8f81215da6f7ba4339cb7a6b5d9bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_istream&lt; char &gt;</type>
      <name>istream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g6b116976599edf01f11b901e3cd0099a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_istringstream&lt; char &gt;</type>
      <name>istringstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g880ba9e4dc7f6fff889b8bed31620669</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ofstream&lt; char &gt;</type>
      <name>ofstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g9a22749909c6b21cb603d5c9db2b6141</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ostream&lt; char &gt;</type>
      <name>ostream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>ge83348f0f14ec5bf401ed2b962cb6491</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ostringstream&lt; char &gt;</type>
      <name>ostringstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>gdd8337e70853f2c3a15e40572e9cbbe6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_streambuf&lt; char &gt;</type>
      <name>streambuf</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>gfb21593be4dcf0dd619e05dc9a51c599</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_stringbuf&lt; char &gt;</type>
      <name>stringbuf</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g5b0047a8f0c33bd24acd6281bbae2309</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_stringstream&lt; char &gt;</type>
      <name>stringstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g9290c15cadc4984da1f5690ad2acd902</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_filebuf&lt; wchar_t &gt;</type>
      <name>wfilebuf</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g13cfc9ad93bb2412fc98263ee3fba636</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_fstream&lt; wchar_t &gt;</type>
      <name>wfstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g96f0c067e1d149061885ee374b4e07fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ifstream&lt; wchar_t &gt;</type>
      <name>wifstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g61c2e34e36abfec190eb026ec070cae8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ios&lt; wchar_t &gt;</type>
      <name>wios</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g0a19c385c65183262bf07b69072a14e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_iostream&lt; wchar_t &gt;</type>
      <name>wiostream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g8176342675c3f8f03f0c032118841fce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_istream&lt; wchar_t &gt;</type>
      <name>wistream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g4dd14fb7c423446ae9df5663487bfadc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_istringstream&lt; wchar_t &gt;</type>
      <name>wistringstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g7f7ab3cf22700cd496c34cb22fc571d1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ofstream&lt; wchar_t &gt;</type>
      <name>wofstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g522ca89e06648d132817fcbc8cdd7c42</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ostream&lt; wchar_t &gt;</type>
      <name>wostream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>gfc5f755101b3a4d8fd97a181dc6839fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_ostringstream&lt; wchar_t &gt;</type>
      <name>wostringstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>gdce75860ec8a2f1bff2a5ac5fd13fd56</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_streambuf&lt; wchar_t &gt;</type>
      <name>wstreambuf</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g72af2d860c3e0a4ee2dc62c5e5ecf0dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_stringbuf&lt; wchar_t &gt;</type>
      <name>wstringbuf</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>g372e69d6887025df0537b465f2fcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_stringstream&lt; wchar_t &gt;</type>
      <name>wstringstream</name>
      <anchorfile>a01708.html</anchorfile>
      <anchor>gb173c00c58b78b55b302c7d3d4c22313</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iostream</name>
    <filename>a01494</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_IOSTREAM</name>
      <anchorfile>a01494.html</anchorfile>
      <anchor>fd6155e6e5a626372d087205bf3e3283</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static ios_base::Init</type>
      <name>__ioinit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1c4069e5220328673b703512ddeff08d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ostream</type>
      <name>cerr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>64ca41bba3155dda187b56928fd61914</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>istream</type>
      <name>cin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1e7455cef254f63b78df37ef7c95b266</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ostream</type>
      <name>clog</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2148b3c6737ac87cc8fc54289b785527</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ostream</type>
      <name>cout</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a254869c6a5188f3c0c4b3af7a853144</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>wostream</type>
      <name>wcerr</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>95047e88d1a89798413d8be9062b63f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>wistream</type>
      <name>wcin</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1ea358d8769ed7d48857d07f8a4c1839</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>wostream</type>
      <name>wclog</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e656b59b722a78beea55659aa3bd2d1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>wostream</type>
      <name>wcout</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>58ad0d2cbfa8193149040adf57def27e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>istream</name>
    <filename>a01495</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_iostream</class>
    <class kind="class">std::basic_istream</class>
    <class kind="class">std::basic_istream::sentry</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ISTREAM</name>
      <anchorfile>a01495.html</anchorfile>
      <anchor>2d3f81d51bf0a2da5601ddd6b5ce645e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>ws</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2cbfab706635fa9399cc3a53e1e12795</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>29323852605cea6bffe1f8247899bdf8</anchor>
      <arglist>(basic_istream&lt; char, _Traits &gt; &amp;__in, signed char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c58d6197e6dfca45b7d246adc776d93c</anchor>
      <arglist>(basic_istream&lt; char, _Traits &gt; &amp;__in, unsigned char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4249171979c79b043283e8f5526f6c7e</anchor>
      <arglist>(basic_istream&lt; char &gt; &amp;__in, char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>79b11b2f7b58d9432689e7d8a0ff70b3</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__in, _CharT *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>467c0f2f238ff352e1f4a11f42f6e3f0</anchor>
      <arglist>(basic_istream&lt; char, _Traits &gt; &amp;__in, signed char &amp;__c)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2bafeb913acd637215d19fa305da4e2e</anchor>
      <arglist>(basic_istream&lt; char, _Traits &gt; &amp;__in, unsigned char &amp;__c)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a8445ec189f38ac2f112a630b46ef940</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__in, _CharT &amp;__c)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>istream.tcc</name>
    <filename>a01496</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_ISTREAM_TCC</name>
      <anchorfile>a01496.html</anchorfile>
      <anchor>c0a4abb4f43ee04a3b13e84b31b59353</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>ws</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2cbfab706635fa9399cc3a53e1e12795</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__is)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>79b11b2f7b58d9432689e7d8a0ff70b3</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__in, _CharT *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a8445ec189f38ac2f112a630b46ef940</anchor>
      <arglist>(basic_istream&lt; _CharT, _Traits &gt; &amp;__in, _CharT &amp;__c)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iterator</name>
    <filename>a01497</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_ITERATOR</name>
      <anchorfile>a01497.html</anchorfile>
      <anchor>17aff0026389ef71a6e5e1270aaf9d29</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ext/iterator</name>
    <filename>a01498</filename>
    <namespace>__gnu_cxx</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_ITERATOR</name>
      <anchorfile>a01498.html</anchorfile>
      <anchor>25473594cddd91f91cca15cbf356a2e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__distance</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d209d3bc7f25fce5e2748a8b1692dea5</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Distance &amp;__n, std::random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__distance</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>b453e73d0832b0f80d88bf6d982a69c6</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Distance &amp;__n, std::input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>distance</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g67083dac9c65bbddc8ae5c950ff1c4eb</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Distance &amp;__n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iterator.h</name>
    <filename>a01499</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="class">__gnu_parallel::iterator_pair</class>
    <class kind="class">__gnu_parallel::iterator_triple</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_ITERATOR_H</name>
      <anchorfile>a01499.html</anchorfile>
      <anchor>86dca6b7d57f7246c6611881d83f37cd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>legendre_function.tcc</name>
    <filename>a01500</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_LEGENDRE_FUNCTION_TCC</name>
      <anchorfile>a01500.html</anchorfile>
      <anchor>29822f88775e9d87eba34a562f180d21</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__assoc_legendre_p</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>5d0606e2fa709a3c0d71c39fb12954bd</anchor>
      <arglist>(const unsigned int __l, const unsigned int __m, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_legendre_p</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>16741b0c0f1d6caf686abebe3589fedf</anchor>
      <arglist>(const unsigned int __l, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__sph_legendre</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>95d0f696219155f96e6a5412e48beff9</anchor>
      <arglist>(const unsigned int __l, const unsigned int __m, const _Tp __theta)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>limits</name>
    <filename>a01501</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__numeric_limits_base</class>
    <class kind="struct">std::numeric_limits</class>
    <class kind="struct">std::numeric_limits&lt; bool &gt;</class>
    <class kind="struct">std::numeric_limits&lt; char &gt;</class>
    <class kind="struct">std::numeric_limits&lt; double &gt;</class>
    <class kind="struct">std::numeric_limits&lt; float &gt;</class>
    <class kind="struct">std::numeric_limits&lt; int &gt;</class>
    <class kind="struct">std::numeric_limits&lt; long &gt;</class>
    <class kind="struct">std::numeric_limits&lt; long double &gt;</class>
    <class kind="struct">std::numeric_limits&lt; long long &gt;</class>
    <class kind="struct">std::numeric_limits&lt; short &gt;</class>
    <class kind="struct">std::numeric_limits&lt; signed char &gt;</class>
    <class kind="struct">std::numeric_limits&lt; unsigned char &gt;</class>
    <class kind="struct">std::numeric_limits&lt; unsigned int &gt;</class>
    <class kind="struct">std::numeric_limits&lt; unsigned long &gt;</class>
    <class kind="struct">std::numeric_limits&lt; unsigned long long &gt;</class>
    <class kind="struct">std::numeric_limits&lt; unsigned short &gt;</class>
    <class kind="struct">std::numeric_limits&lt; wchar_t &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_digits</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>120e2c63ee70eca5f3c1e15a773f59f2</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_digits10</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>a9ca9ddb994ed13e09ec02049df88a7b</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_double_has_denorm_loss</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>564399b1fbcce41b5506f225a0607dcf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_double_tinyness_before</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>6c794724aaf8e0ae7944a1a9f4fd9126</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_double_traps</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>8c0d1eec549578df1c028c9b952e0794</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_float_has_denorm_loss</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>29f6c5efa79010730c14d29ce71f4898</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_float_tinyness_before</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>2b34cf65595df04b8f6d0600d74994a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_float_traps</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>16a6eb35cd0cf4f02171fca96e17b842</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_integral_traps</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>02a69a6e1999c112b6b1523338ee64d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_long_double_has_denorm_loss</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>9ae24a3ec39ff1cfe5e4731078c8315b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_long_double_tinyness_before</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>5a9ea50699adc6bffd14f86c76fa81e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_long_double_traps</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>dd884afc6573459e06e95a61fc0a1584</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_max</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>f10573c1560150ec91805fa21c24575a</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_min</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>c3b4ac7d1d67742d1ad7ba9af880551a</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_signed</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>5c81ddaf2b980f0a93bb3ad5e188c610</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_NUMERIC_LIMITS</name>
      <anchorfile>a01501.html</anchorfile>
      <anchor>ccc0c09835ff191d7dc00bc64b6e8bc1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>float_denorm_style</name>
      <anchor>95e8eb381c6caa0a2a22b73399f050c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>denorm_indeterminate</name>
      <anchor>95e8eb381c6caa0a2a22b73399f050c3fb002ae0887117fdaff01dd1d4c11505</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>denorm_absent</name>
      <anchor>95e8eb381c6caa0a2a22b73399f050c3087c559a01216cc5c14b693a75ecebc2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>denorm_present</name>
      <anchor>95e8eb381c6caa0a2a22b73399f050c333c26d24d7616381018fdf436bd357cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>float_round_style</name>
      <anchor>bea67caaad19437eb69fcd37dad3474f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>round_indeterminate</name>
      <anchor>bea67caaad19437eb69fcd37dad3474f911d5be2710c4816a894d00b014c480b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>round_toward_zero</name>
      <anchor>bea67caaad19437eb69fcd37dad3474f9c6db1453f2f66463a2f66ef931cfe6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>round_to_nearest</name>
      <anchor>bea67caaad19437eb69fcd37dad3474f8ddde250d88da73be2cdb5f9f3fc45f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>round_toward_infinity</name>
      <anchor>bea67caaad19437eb69fcd37dad3474f4c06e6846a5fcdb8430b4f924bdec82d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>round_toward_neg_infinity</name>
      <anchor>bea67caaad19437eb69fcd37dad3474fa1a2fea6ae6865b2702e33522b80ea1a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>limits.h</name>
    <filename>a01502</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_LIMITS_H</name>
      <anchorfile>a01502.html</anchorfile>
      <anchor>639f48388912ffaf26dc0a5f89ec94e0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>list</name>
    <filename>a01503</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LIST</name>
      <anchorfile>a01503.html</anchorfile>
      <anchor>af88260889f768ed703932f8da93aa70</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/list</name>
    <filename>a01504</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::list</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_LIST</name>
      <anchorfile>a01504.html</anchorfile>
      <anchor>87cedee6e41222862246827336fec58d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>7c1b0f0b00053a3f6795bc44407805ee</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__lhs, const list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>d22402148fe51c12dbdeecd7f87b0558</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__lhs, const list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>7e2cbc9501a1e1336c9ef54299c0db1f</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__lhs, const list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>76c094b1878ee150171f2773bc5a1f78</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__lhs, const list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b8a6ff04d1e5172d5448af573d41d3d9</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__lhs, const list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>13e0f0e81397924ce994e80bbf8ca284</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__lhs, const list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>8bf5e868ec91d6b3d9efa7c04f9e543a</anchor>
      <arglist>(list&lt; _Tp, _Alloc &gt; &amp;__lhs, list&lt; _Tp, _Alloc &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>list.tcc</name>
    <filename>a01505</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_LIST_TCC</name>
      <anchorfile>a01505.html</anchorfile>
      <anchor>12775526e99777894445759688b4fe4d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>list_partition.h</name>
    <filename>a01506</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_LIST_PARTITION_H</name>
      <anchorfile>a01506.html</anchorfile>
      <anchor>d1a004be3866807980761f46e8a23c06</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>list_partition</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>1da641a9cf7bf02ce2707b6f7683403c</anchor>
      <arglist>(const InputIterator begin, const InputIterator end, InputIterator *starts, size_t *lengths, const int num_parts, FunctorType &amp;f, int oversampling=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shrink</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>ff89561cb83a8f892b00a1a8e5267318</anchor>
      <arglist>(std::vector&lt; InputIterator &gt; &amp;os_starts, size_t &amp;count_to_two, size_t &amp;range_length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shrink_and_double</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>32b7887a9455a2f4f0c95c41a32a18b2</anchor>
      <arglist>(std::vector&lt; InputIterator &gt; &amp;os_starts, size_t &amp;count_to_two, size_t &amp;range_length, const bool make_twice)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>list_update_policy.hpp</name>
    <filename>a01507</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="class">__gnu_pbds::counter_lu_policy</class>
    <class kind="class">__gnu_pbds::move_to_front_lu_policy</class>
    <class kind="struct">__gnu_pbds::null_lu_metadata</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01507.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01507.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01507.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01507.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale</name>
    <filename>a01508</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_LOCALE</name>
      <anchorfile>a01508.html</anchorfile>
      <anchor>82756e288c0db64074f2b009895451d1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale_classes.h</name>
    <filename>a01509</filename>
    <namespace>std</namespace>
    <class kind="class">std::collate</class>
    <class kind="class">std::collate_byname</class>
    <class kind="class">std::locale</class>
    <class kind="class">std::locale::_Impl</class>
    <class kind="class">std::locale::facet</class>
    <class kind="class">std::locale::id</class>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_CLASSES_H</name>
      <anchorfile>a01509.html</anchorfile>
      <anchor>c224eefdaf138942e62c037deed29496</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e2115ea25e354b1af64041c3db094b4b</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>const _Facet &amp;</type>
      <name>use_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cd7df9b07c8af76bc0a36d02dae559fd</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale_classes.tcc</name>
    <filename>a01510</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_CLASSES_TCC</name>
      <anchorfile>a01510.html</anchorfile>
      <anchor>87723e42e396ab92cfcbb1bbc7a22b4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e2115ea25e354b1af64041c3db094b4b</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>const _Facet &amp;</type>
      <name>use_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cd7df9b07c8af76bc0a36d02dae559fd</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale_facets.h</name>
    <filename>a01511</filename>
    <namespace>std</namespace>
    <class kind="class">std::__ctype_abstract_base</class>
    <class kind="class">std::__num_base</class>
    <class kind="struct">std::__numpunct_cache</class>
    <class kind="struct">std::__pad</class>
    <class kind="class">std::ctype</class>
    <class kind="class">std::ctype&lt; char &gt;</class>
    <class kind="class">std::ctype&lt; wchar_t &gt;</class>
    <class kind="class">std::ctype_byname</class>
    <class kind="class">std::ctype_byname&lt; char &gt;</class>
    <class kind="class">std::ctype_byname&lt; wchar_t &gt;</class>
    <class kind="class">std::num_get</class>
    <class kind="class">std::num_put</class>
    <class kind="class">std::numpunct</class>
    <class kind="class">std::numpunct_byname</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_NUM_FACETS</name>
      <anchorfile>a01511.html</anchorfile>
      <anchor>ac2c55713060d10c6cb3d7384b6d5ab0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_FACETS_H</name>
      <anchorfile>a01511.html</anchorfile>
      <anchor>2f14c0993ba87814a16a79c127427d42</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_CharT *</type>
      <name>__add_grouping</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9119adf38015a9988bc1a45cddef2b3c</anchor>
      <arglist>(_CharT *__s, _CharT __sep, const char *__gbeg, size_t __gsize, const _CharT *__first, const _CharT *__last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__convert_to_v</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a45d14e728c09bf4925bc928bb87afb7</anchor>
      <arglist>(const char *, long double &amp;, ios_base::iostate &amp;, const __c_locale &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__convert_to_v</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d02f3a7e3d06a28be2d13f57a41e8c5d</anchor>
      <arglist>(const char *, double &amp;, ios_base::iostate &amp;, const __c_locale &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__convert_to_v</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ed90781578a230734f213ade3466c996</anchor>
      <arglist>(const char *, float &amp;, ios_base::iostate &amp;, const __c_locale &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__convert_to_v</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1663a4a1c42bae0f3e030260241a49b1</anchor>
      <arglist>(const char *__in, _Tv &amp;__out, ios_base::iostate &amp;__err, const __c_locale &amp;__cloc)</arglist>
    </member>
    <member kind="function">
      <type>_OutIter</type>
      <name>__write</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>23ffb82393ed920844eed863dfac1380</anchor>
      <arglist>(_OutIter __s, const _CharT *__ws, int __len)</arglist>
    </member>
    <member kind="function">
      <type>ostreambuf_iterator&lt; _CharT &gt;</type>
      <name>__write</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>71650bbee45ac0d45da8b75773f45a16</anchor>
      <arglist>(ostreambuf_iterator&lt; _CharT &gt; __s, const _CharT *__ws, int __len)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isalnum</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0b7b83de90cb5302a21000056e29b87d</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isalpha</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e07d13414ee78c514aa1c30b6b410bc</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>iscntrl</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>674c304bafa9ec07b8cb61e5cbb02e95</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isdigit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>58f56651f70f4d85d5917120d68eff11</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isgraph</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3f3e05ace3d60d60dc7bc34faab3a3cc</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>islower</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d80990ebf25c3c996d1c59943426fa68</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isprint</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9a31c19a395d642c734f616c54c0fd38</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ispunct</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>31ade496964c1cb62fdc63711db30b35</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>_GLIBCXX_END_LDBL_NAMESPACE bool</type>
      <name>isspace</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>31b52a7d3d14d51ef9028a88aad911f4</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isupper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1a3468d0426ac1cdd5251b496a53e8c4</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isxdigit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>db730bbffd8f8454a9f139102c0d353c</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>_CharT</type>
      <name>tolower</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>24ee6d654108ebbaebc8336ce000fff1</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>_CharT</type>
      <name>toupper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dcca0d40a89e0ec24bc24a9f9ba5f29f</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>const ctype&lt; char &gt; &amp;</type>
      <name>use_facet&lt; ctype&lt; char &gt; &gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>654d2c9bad8dbfc5328b1132bf24d92d</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>const ctype&lt; wchar_t &gt; &amp;</type>
      <name>use_facet&lt; ctype&lt; wchar_t &gt; &gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ed294ee95bafdbd7844f9d7d9ed697cd</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale_facets.tcc</name>
    <filename>a01512</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__use_cache</class>
    <class kind="struct">std::__use_cache&lt; __numpunct_cache&lt; _CharT &gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_FACETS_TCC</name>
      <anchorfile>a01512.html</anchorfile>
      <anchor>298249aa3f3a14d8bfaa1e817f3216bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_CharT *</type>
      <name>__add_grouping</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9119adf38015a9988bc1a45cddef2b3c</anchor>
      <arglist>(_CharT *__s, _CharT __sep, const char *__gbeg, size_t __gsize, const _CharT *__first, const _CharT *__last)</arglist>
    </member>
    <member kind="function">
      <type>_GLIBCXX_END_LDBL_NAMESPACE int</type>
      <name>__int_to_char</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>991cc1582daffb8be7e08c8611732902</anchor>
      <arglist>(_CharT *__bufend, _ValueT __v, const _CharT *__lit, ios_base::fmtflags __flags, bool __dec)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__verify_grouping</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>918053dcbd6ddc79aade69ee8a667b3f</anchor>
      <arglist>(const char *__grouping, size_t __grouping_size, const string &amp;__grouping_tmp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale_facets_nonio.h</name>
    <filename>a01513</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__moneypunct_cache</class>
    <class kind="class">std::__timepunct</class>
    <class kind="struct">std::__timepunct_cache</class>
    <class kind="class">std::messages</class>
    <class kind="struct">std::messages_base</class>
    <class kind="class">std::messages_byname</class>
    <class kind="class">std::money_base</class>
    <class kind="struct">std::money_base::pattern</class>
    <class kind="class">std::money_get</class>
    <class kind="class">std::money_put</class>
    <class kind="class">std::moneypunct</class>
    <class kind="class">std::moneypunct_byname</class>
    <class kind="class">std::time_base</class>
    <class kind="class">std::time_get</class>
    <class kind="class">std::time_get_byname</class>
    <class kind="class">std::time_put</class>
    <class kind="class">std::time_put_byname</class>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_FACETS_NONIO_H</name>
      <anchorfile>a01513.html</anchorfile>
      <anchor>051c95a5a5e4896ef513e75f260b62dd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>locale_facets_nonio.tcc</name>
    <filename>a01514</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__use_cache&lt; __moneypunct_cache&lt; _CharT, _Intl &gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_FACETS_NONIO_TCC</name>
      <anchorfile>a01514.html</anchorfile>
      <anchor>b3201283ecebee7ec99bf9fbc1addeff</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>localefwd.h</name>
    <filename>a01515</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_LOCALE_FWD_H</name>
      <anchorfile>a01515.html</anchorfile>
      <anchor>ec3b049731193449e357f17b844b99f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e2115ea25e354b1af64041c3db094b4b</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isalnum</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0b7b83de90cb5302a21000056e29b87d</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isalpha</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e07d13414ee78c514aa1c30b6b410bc</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>iscntrl</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>674c304bafa9ec07b8cb61e5cbb02e95</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isdigit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>58f56651f70f4d85d5917120d68eff11</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isgraph</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3f3e05ace3d60d60dc7bc34faab3a3cc</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>islower</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d80990ebf25c3c996d1c59943426fa68</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isprint</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9a31c19a395d642c734f616c54c0fd38</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ispunct</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>31ade496964c1cb62fdc63711db30b35</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>_GLIBCXX_END_LDBL_NAMESPACE bool</type>
      <name>isspace</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>31b52a7d3d14d51ef9028a88aad911f4</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isupper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1a3468d0426ac1cdd5251b496a53e8c4</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isxdigit</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>db730bbffd8f8454a9f139102c0d353c</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>_CharT</type>
      <name>tolower</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>24ee6d654108ebbaebc8336ce000fff1</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>_CharT</type>
      <name>toupper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dcca0d40a89e0ec24bc24a9f9ba5f29f</anchor>
      <arglist>(_CharT __c, const locale &amp;__loc)</arglist>
    </member>
    <member kind="function">
      <type>const _Facet &amp;</type>
      <name>use_facet</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cd7df9b07c8af76bc0a36d02dae559fd</anchor>
      <arglist>(const locale &amp;__loc)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>losertree.h</name>
    <filename>a01516</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::loser_tree_traits</class>
    <class kind="struct">__gnu_parallel::loser_tree_unguarded_traits</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_LOSERTREE_H</name>
      <anchorfile>a01516.html</anchorfile>
      <anchor>97b1f546aaaff4e7e242e13b1b5dddbe</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>macros.h</name>
    <filename>a01517</filename>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_erase</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>8e378b4a099b00f5391a2817fad03e47</anchor>
      <arglist>(_Position)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_erase_range</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>b45aaf5f75e31f3c23dd6aecea086a08</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_heap</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>3381739b64d22fee32aefe732a153846</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_heap_pred</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>ff1e1b0b3ce9272a1146dd34c8296f11</anchor>
      <arglist>(_First, _Last, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_insert</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>2890cbed49d9b6e340a733221eab3002</anchor>
      <arglist>(_Position)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_insert_range</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>b42feb2b4f38d54a2e59d84252dccfa5</anchor>
      <arglist>(_Position, _First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_nonempty</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>30aa21550590a34f4b8b701e8575bedc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_partitioned_lower</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>04ea34af064b8786e93b3d79d65d9f53</anchor>
      <arglist>(_First, _Last, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_partitioned_lower_pred</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>a7da3b7ebcbc2ca7394989e0457c0ee1</anchor>
      <arglist>(_First, _Last, _Value, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_partitioned_upper</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>6de9430560413430a1d2530a87058dea</anchor>
      <arglist>(_First, _Last, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_partitioned_upper_pred</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>865926142fc1b8549f062e038f74cba4</anchor>
      <arglist>(_First, _Last, _Value, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_sorted</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>fd11365e8f55ba0e39dcc4bd27f982b6</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_sorted_pred</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>4962150b8e32abdbea07fac8c40d2da3</anchor>
      <arglist>(_First, _Last, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_sorted_set</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>3405b9ac00891d333270726b11605ed0</anchor>
      <arglist>(_First1, _Last1, _First2)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_sorted_set_pred</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>1b6b0de6d905f776fd451ab0427862d4</anchor>
      <arglist>(_First1, _Last1, _First2, _Pred)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_string</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>27202e6a8357ef90d62635a18846b2e2</anchor>
      <arglist>(_String)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_string_len</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>21a6e42491ad039ade5fcb7b6701ae07</anchor>
      <arglist>(_String, _Len)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_subscript</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>34bd7844c950cefe705b1ca8d0a0344c</anchor>
      <arglist>(_N)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_check_valid_range</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>f28347adf1f3176c889b4d2345af031c</anchor>
      <arglist>(_First, _Last)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_MACROS_H</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>9f4e3eed21ad4a009f5068a912f9ea41</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_VERIFY</name>
      <anchorfile>a01517.html</anchorfile>
      <anchor>f5025c1cf7b7e26cfa9ce51a5a0bcb5c</anchor>
      <arglist>(_Condition, _ErrorMessage)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>malloc_allocator.h</name>
    <filename>a01518</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::malloc_allocator</class>
    <class kind="struct">__gnu_cxx::malloc_allocator::rebind</class>
    <member kind="define">
      <type>#define</type>
      <name>_MALLOC_ALLOCATOR_H</name>
      <anchorfile>a01518.html</anchorfile>
      <anchor>b767c5f1d5c15c18708959d27275529a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>e05f75b8a9a94d85ac65544e5c36554e</anchor>
      <arglist>(const malloc_allocator&lt; _Tp &gt; &amp;, const malloc_allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>f6f696bd5b1dc218e5265653a1fcfa52</anchor>
      <arglist>(const malloc_allocator&lt; _Tp &gt; &amp;, const malloc_allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>map</name>
    <filename>a01519</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MAP</name>
      <anchorfile>a01519.html</anchorfile>
      <anchor>2f84c5ac77ecbeca6a5a2376c2149e43</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/map</name>
    <filename>a01520</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_MAP</name>
      <anchorfile>a01520.html</anchorfile>
      <anchor>084acc266391e85fbaa9a92fac4361cb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>map.h</name>
    <filename>a01521</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::map</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_MAP_H</name>
      <anchorfile>a01521.html</anchorfile>
      <anchor>2491a37fe945105f3521b29784bbfa0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>5ac7da8bee271e3afd3dee8b474efa6b</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>0544f43ec13c8976e67be966eca4f888</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>a2eee3ab50b711748d4167f95f3978d3</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>a099c54805f37e1fad0a6d9eed19f740</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>7554df43f09849fa29b98a7d9f5f61a8</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>ee84b73fce048e6c18c974fe6504114f</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>6cb52ba5ffed2226e4472fdb14b5d0a6</anchor>
      <arglist>(map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, map&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>mask_array.h</name>
    <filename>a01522</filename>
    <namespace>std</namespace>
    <class kind="class">std::mask_array</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_OPERATOR</name>
      <anchorfile>a01522.html</anchorfile>
      <anchor>2d8d2d09544ebac440902adb07bbc233</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_MASK_ARRAY_H</name>
      <anchorfile>a01522.html</anchorfile>
      <anchor>a78a453c8a19155d55b2045baa5f9dd3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>math.h</name>
    <filename>a01523</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_MATH_H</name>
      <anchorfile>a01523.html</anchorfile>
      <anchor>f64e8d7d5e8e5caf8792505ead6d2916</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>memory</name>
    <filename>a01524</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MEMORY</name>
      <anchorfile>a01524.html</anchorfile>
      <anchor>957b47644fb49b25130291524b7c1edc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ext/memory</name>
    <filename>a01525</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::temporary_buffer</class>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_MEMORY</name>
      <anchorfile>a01525.html</anchorfile>
      <anchor>8b5ec9c2f107e0feaf2d1fb0a60dab27</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIter, _ForwardIter &gt;</type>
      <name>__uninitialized_copy_n</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>41f49011db38ea8daf5d2ad0198b5298</anchor>
      <arglist>(_InputIter __first, _Size __count, _ForwardIter __result)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _RandomAccessIter, _ForwardIter &gt;</type>
      <name>__uninitialized_copy_n</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>bb8c68570934717e16e199991d62333a</anchor>
      <arglist>(_RandomAccessIter __first, _Size __count, _ForwardIter __result, std::random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIter, _ForwardIter &gt;</type>
      <name>__uninitialized_copy_n</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>82891a3e0eca4a1f37d974cc514bb3b4</anchor>
      <arglist>(_InputIter __first, _Size __count, _ForwardIter __result, std::input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIter, _ForwardIter &gt;</type>
      <name>__uninitialized_copy_n_a</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>aa361b05323af6c2b7b5263cb6e0d0ca</anchor>
      <arglist>(_InputIter __first, _Size __count, _ForwardIter __result, std::allocator&lt; _Tp &gt;)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIter, _ForwardIter &gt;</type>
      <name>__uninitialized_copy_n_a</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>de74275b3306dd6a2b1ffbe20aff8473</anchor>
      <arglist>(_InputIter __first, _Size __count, _ForwardIter __result, _Allocator __alloc)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIter, _ForwardIter &gt;</type>
      <name>uninitialized_copy_n</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g8c5e5ef78cee437f9d81b8e40df481df</anchor>
      <arglist>(_InputIter __first, _Size __count, _ForwardIter __result)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/memory</name>
    <filename>a01526</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01526.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01526.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01526.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01526.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_MEMORY</name>
      <anchorfile>a01526.html</anchorfile>
      <anchor>c6addf608b1a4764c1aa41719ecbcbf8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>merge.h</name>
    <filename>a01527</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_MERGE_H</name>
      <anchorfile>a01527.html</anchorfile>
      <anchor>3beb4940cbb18016bd030bd576d6f2dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge_advance</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>7a7dd0199007747066702c99d8f1db58</anchor>
      <arglist>(RandomAccessIterator1 &amp;begin1, RandomAccessIterator1 end1, RandomAccessIterator2 &amp;begin2, RandomAccessIterator2 end2, OutputIterator target, _DifferenceTp max_length, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge_advance_movc</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>2e35cdb8ba23e20ca97109c59066bebc</anchor>
      <arglist>(RandomAccessIterator1 &amp;begin1, RandomAccessIterator1 end1, RandomAccessIterator2 &amp;begin2, RandomAccessIterator2 end2, OutputIterator target, _DifferenceTp max_length, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>merge_advance_usual</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>ec0bafe7b91a825538bd3dc85463896b</anchor>
      <arglist>(RandomAccessIterator1 &amp;begin1, RandomAccessIterator1 end1, RandomAccessIterator2 &amp;begin2, RandomAccessIterator2 end2, OutputIterator target, _DifferenceTp max_length, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>parallel_merge_advance</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>d5d22108320c329f54ea53c8462970ef</anchor>
      <arglist>(RandomAccessIterator1 &amp;begin1, RandomAccessIterator1 end1, RandomAccessIterator1 &amp;begin2, RandomAccessIterator1 end2, RandomAccessIterator3 target, typename std::iterator_traits&lt; RandomAccessIterator1 &gt;::difference_type max_length, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>parallel_merge_advance</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>5525bd6dfcee6e3c00a69ec016b7330a</anchor>
      <arglist>(RandomAccessIterator1 &amp;begin1, RandomAccessIterator1 end1, RandomAccessIterator2 &amp;begin2, RandomAccessIterator2 end2, RandomAccessIterator3 target, typename std::iterator_traits&lt; RandomAccessIterator1 &gt;::difference_type max_length, Comparator comp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>messages_members.h</name>
    <filename>a01528</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>modified_bessel_func.tcc</name>
    <filename>a01529</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_MODIFIED_BESSEL_FUNC_TCC</name>
      <anchorfile>a01529.html</anchorfile>
      <anchor>c27464fc2f8596c00f4633b0f03d4ee9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__airy</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>bd83f10655a8642690a41a8ce5bdd395</anchor>
      <arglist>(const _Tp __x, _Tp &amp;__Ai, _Tp &amp;__Bi, _Tp &amp;__Aip, _Tp &amp;__Bip)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__bessel_ik</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>caa6401a81fc9fcfe51dd8befde37a91</anchor>
      <arglist>(const _Tp __nu, const _Tp __x, _Tp &amp;__Inu, _Tp &amp;__Knu, _Tp &amp;__Ipnu, _Tp &amp;__Kpnu)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cyl_bessel_i</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>c24a8b946b968863a9e00d0f445e26b9</anchor>
      <arglist>(const _Tp __nu, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__cyl_bessel_k</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>c04821a21add11c86259c1492a9b4beb</anchor>
      <arglist>(const _Tp __nu, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__sph_bessel_ik</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>f109bc21d701e6177233d2b207923082</anchor>
      <arglist>(const unsigned int __n, const _Tp __x, _Tp &amp;__i_n, _Tp &amp;__k_n, _Tp &amp;__ip_n, _Tp &amp;__kp_n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>mt_allocator.h</name>
    <filename>a01530</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::__common_pool</class>
    <class kind="struct">__gnu_cxx::__common_pool_base&lt; _PoolTp, false &gt;</class>
    <class kind="struct">__gnu_cxx::__common_pool_base&lt; _PoolTp, true &gt;</class>
    <class kind="struct">__gnu_cxx::__common_pool_policy</class>
    <class kind="struct">__gnu_cxx::__common_pool_policy::_M_rebind</class>
    <class kind="class">__gnu_cxx::__mt_alloc</class>
    <class kind="struct">__gnu_cxx::__mt_alloc::rebind</class>
    <class kind="class">__gnu_cxx::__mt_alloc_base</class>
    <class kind="struct">__gnu_cxx::__per_type_pool</class>
    <class kind="struct">__gnu_cxx::__per_type_pool_base&lt; _Tp, _PoolTp, false &gt;</class>
    <class kind="struct">__gnu_cxx::__per_type_pool_base&lt; _Tp, _PoolTp, true &gt;</class>
    <class kind="struct">__gnu_cxx::__per_type_pool_policy</class>
    <class kind="struct">__gnu_cxx::__per_type_pool_policy::_M_rebind</class>
    <class kind="class">__gnu_cxx::__pool&lt; false &gt;</class>
    <class kind="struct">__gnu_cxx::__pool&lt; false &gt;::_Bin_record</class>
    <class kind="union">__gnu_cxx::__pool&lt; false &gt;::_Block_record</class>
    <class kind="class">__gnu_cxx::__pool&lt; true &gt;</class>
    <class kind="struct">__gnu_cxx::__pool&lt; true &gt;::_Bin_record</class>
    <class kind="union">__gnu_cxx::__pool&lt; true &gt;::_Block_record</class>
    <class kind="struct">__gnu_cxx::__pool&lt; true &gt;::_Thread_record</class>
    <class kind="struct">__gnu_cxx::__pool_base</class>
    <class kind="struct">__gnu_cxx::__pool_base::_Block_address</class>
    <class kind="struct">__gnu_cxx::__pool_base::_Tune</class>
    <member kind="define">
      <type>#define</type>
      <name>__thread_default</name>
      <anchorfile>a01530.html</anchorfile>
      <anchor>f7a6235f146bc98a40fa5235abd7beb5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_MT_ALLOCATOR_H</name>
      <anchorfile>a01530.html</anchorfile>
      <anchor>1946aaca3fb0c12d90e104d71c6d204f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void(*)</type>
      <name>__destroy_handler</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d0c79acdd83d858b94352ec1c202a741</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>0bbb81bb2b9d002fc875f83147bbb92d</anchor>
      <arglist>(const __mt_alloc&lt; _Tp, _Poolp &gt; &amp;, const __mt_alloc&lt; _Tp, _Poolp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>be193f972f78f643be2188347d0610ac</anchor>
      <arglist>(const __mt_alloc&lt; _Tp, _Poolp &gt; &amp;, const __mt_alloc&lt; _Tp, _Poolp &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>multimap.h</name>
    <filename>a01531</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::multimap</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_MULTIMAP_H</name>
      <anchorfile>a01531.html</anchorfile>
      <anchor>9d648edb1925497eb7bd7a685e07f979</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>2a54f1c18894e3c0a9e6bf33f930565b</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>36cac9fb01cb4e148769286225fa0b5f</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b359380267dc2d85bc7de5c892c8b66c</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>743075a3acf25a8770f58a4ac0374e45</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>7bd03d658ebd2ef689274b55f1d971f1</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>de315ca8a240367cfdbd35d0c3e9b379</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, const multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b03f4eb87874dfdf65d707acc7ccd257</anchor>
      <arglist>(multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__lhs, multimap&lt; _Key, _Tp, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>multiseq_selection.h</name>
    <filename>a01532</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="class">__gnu_parallel::lexicographic</class>
    <class kind="class">__gnu_parallel::lexicographic_reverse</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_MULTISEQ_SELECTION_H</name>
      <anchorfile>a01532.html</anchorfile>
      <anchor>6d8f7c263968a2314587dd9bdf92dc20</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>S</name>
      <anchorfile>a01532.html</anchorfile>
      <anchor>394cb81a43a39834f351e0fd9a34a476</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>S</name>
      <anchorfile>a01532.html</anchorfile>
      <anchor>394cb81a43a39834f351e0fd9a34a476</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multiseq_partition</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>df79841e39397f984fea3723448ba7bd</anchor>
      <arglist>(RanSeqs begin_seqs, RanSeqs end_seqs, RankType rank, RankIterator begin_offsets, Comparator comp=std::less&lt; typename std::iterator_traits&lt; typename std::iterator_traits&lt; RanSeqs &gt;::value_type::first_type &gt;::value_type &gt;())</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>multiseq_selection</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>789ea66c6207d5173efce8f35136b591</anchor>
      <arglist>(RanSeqs begin_seqs, RanSeqs end_seqs, RankType rank, RankType &amp;offset, Comparator comp=std::less&lt; T &gt;())</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>multiset.h</name>
    <filename>a01533</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::multiset</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_MULTISET_H</name>
      <anchorfile>a01533.html</anchorfile>
      <anchor>f2f4823eab7a57cfba12c8bcf1442a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>0d5fb3d19844360865f36fe8c6980fc9</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>e191200c132462b8dc527ea2aba3cf23</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>daf5515766ba5a01bcbc05e8f9b0de7e</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>140859a35514c2046af4e1c01a07a766</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>c7bfa6eb1616c72982583de801bc9612</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>36a7aa5e7b830da7941ec55831ca71db</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>8664f0409708e39a3fd482ccc76b6459</anchor>
      <arglist>(multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__x, multiset&lt; _Key, _Compare, _Allocator &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>multiway_merge.h</name>
    <filename>a01534</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="class">__gnu_parallel::guarded_iterator</class>
    <class kind="class">__gnu_parallel::unguarded_iterator</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_DECISION</name>
      <anchorfile>a01534.html</anchorfile>
      <anchor>55c01993087fa7f6441d5a02d95ffc56</anchor>
      <arglist>(a, b, c, d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_LENGTH</name>
      <anchorfile>a01534.html</anchorfile>
      <anchor>5e50defc079596d02b6b141b2b1f83fd</anchor>
      <arglist>(s)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_MERGE_3_CASE</name>
      <anchorfile>a01534.html</anchorfile>
      <anchor>a02d6bdeecf7e57891ea3d7577000af2</anchor>
      <arglist>(a, b, c, c0, c1)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_MERGE_4_CASE</name>
      <anchorfile>a01534.html</anchorfile>
      <anchor>b9e8981ff021d05011ed8f0295251982</anchor>
      <arglist>(a, b, c, d, c0, c1, c2)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>be7f09d73c4102bc11c39952ffde5b7c</anchor>
      <arglist>(RandomAccessIteratorPairIterator seqs_begin, RandomAccessIteratorPairIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f5efaf03e66910aa81b2eb2fb8195612</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable, bool sentinel, sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_3_combined</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>218524356c85f6f97536fa6dc1bb363d</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_3_variant</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>60d9f4a51e23761867ea0886d7e2088e</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_4_combined</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>c3f35cb557070c504d7942905dc30927</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_4_variant</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>659ad8a952a6db48603d36a7b89a996e</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_bubble</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>dbd351b3d2b8f176c3512dc9c0bbd894</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_loser_tree</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>08d446f778cfd901138b831a043b3154</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_loser_tree_combined</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>b42fc724ba142b80ebf812d6793aaf50</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_loser_tree_sentinel</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f14a07dad8d91b32f45abdf8e65a5d8b</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_loser_tree_unguarded</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>b4378265e0ab9ffaf31fad41c7cba86f</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>multiway_merge_sentinel</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8d23f183c791f89415c868d95455208a</anchor>
      <arglist>(RandomAccessIteratorPairIterator seqs_begin, RandomAccessIteratorPairIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>2a5b6b3fffb73331e30b01c7d6c4eb3d</anchor>
      <arglist>(unguarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi1, unguarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>11b84276afeb10b13033129d718d039d</anchor>
      <arglist>(guarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi1, guarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>14f28ae66284ca86e79eb686e0cdd90e</anchor>
      <arglist>(unguarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi1, unguarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>75c0c24972a23cfe1e82bd99c750eb09</anchor>
      <arglist>(guarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi1, guarded_iterator&lt; RandomAccessIterator, Comparator &gt; &amp;bi2)</arglist>
    </member>
    <member kind="function">
      <type>RandomAccessIterator3</type>
      <name>parallel_multiway_merge</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>68d0b381534fb9344ba13135c22afc25</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, RandomAccessIterator3 target, Comparator comp, _DifferenceTp length, bool stable, bool sentinel)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; typename std::iterator_traits&lt; RandomAccessIteratorIterator &gt;::value_type::first_type &gt;::difference_type</type>
      <name>prepare_unguarded</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>9871a2951a2b313b11ca429828d1b6b1</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, Comparator comp, int &amp;min_sequence, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; typename std::iterator_traits&lt; RandomAccessIteratorIterator &gt;::value_type::first_type &gt;::difference_type</type>
      <name>prepare_unguarded_sentinel</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>1753345e26cf38d273914d5b7520fc0d</anchor>
      <arglist>(RandomAccessIteratorIterator seqs_begin, RandomAccessIteratorIterator seqs_end, Comparator comp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>multiway_mergesort.h</name>
    <filename>a01535</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::Piece</class>
    <class kind="struct">__gnu_parallel::PMWMSSortingData</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_MERGESORT_H</name>
      <anchorfile>a01535.html</anchorfile>
      <anchor>a9073c0c55236425327187af02270aaf</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>determine_samples</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>21425082e958989650b345f520d54305</anchor>
      <arglist>(PMWMSSortingData&lt; RandomAccessIterator &gt; *sd, _DifferenceTp &amp;num_samples)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_sort_mwms</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>cd2dc6f693706675c40490f0bf7e4620</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type n, int num_threads, bool stable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_sort_mwms_pu</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>2303ce8fbf2c36319b2362ee092a8473</anchor>
      <arglist>(PMWMSSortingData&lt; RandomAccessIterator &gt; *sd, Comparator &amp;comp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>new</name>
    <filename>a01536</filename>
    <namespace>std</namespace>
    <class kind="class">std::bad_alloc</class>
    <class kind="struct">std::nothrow_t</class>
    <member kind="typedef">
      <type>void(*)</type>
      <name>new_handler</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b8d4cfc544ce7db2a7dee093f183246c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>new_handler</type>
      <name>set_new_handler</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9c7aa9de53b2c46b9262ce298050b466</anchor>
      <arglist>(new_handler)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>67ebcc6f04076ae6001b6510230cfe0f</anchor>
      <arglist>(void *, void *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>703eb86af0cfba5f15fd88501a43a570</anchor>
      <arglist>(void *, const std::nothrow_t &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>3d3efb3dc56a6cae765a655d54d75ea5</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete[]</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>26d523b8debbbcafcc00c878e8ea3f18</anchor>
      <arglist>(void *, void *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete[]</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>3dd1552cf5c0693cfedc70f55ddc7d2b</anchor>
      <arglist>(void *, const std::nothrow_t &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete[]</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>6d4474e58c1d1b47557d9f16764f598e</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>6176943386edec6291247e1239a53dca</anchor>
      <arglist>(std::size_t, void *__p)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>82266d4abfada876ae53d06f759f18b0</anchor>
      <arglist>(std::size_t, const std::nothrow_t &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>d3d3f6d4acb62eb9eea848620ebbdb79</anchor>
      <arglist>(std::size_t)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new[]</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>759e1911dcc94262197276cb8e17910f</anchor>
      <arglist>(std::size_t, void *__p)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new[]</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>43b5c23a9a81f43b3fae94b8d750afb1</anchor>
      <arglist>(std::size_t, const std::nothrow_t &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new[]</name>
      <anchorfile>a01536.html</anchorfile>
      <anchor>b43d8ce91ba84f55abbeafaa028767a2</anchor>
      <arglist>(std::size_t)</arglist>
    </member>
    <member kind="variable">
      <type>const nothrow_t</type>
      <name>nothrow</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>580d55c6d3a4cda065580a4b85d89a96</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>new_allocator.h</name>
    <filename>a01537</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::new_allocator</class>
    <class kind="struct">__gnu_cxx::new_allocator::rebind</class>
    <member kind="define">
      <type>#define</type>
      <name>_NEW_ALLOCATOR_H</name>
      <anchorfile>a01537.html</anchorfile>
      <anchor>5e34250b19966eb28583999d98605a67</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6237966c0cb1b840c2a15620772179b3</anchor>
      <arglist>(const new_allocator&lt; _Tp &gt; &amp;, const new_allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>fb2879aba35e06ca9d458d8599942d87</anchor>
      <arglist>(const new_allocator&lt; _Tp &gt; &amp;, const new_allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>numeric</name>
    <filename>a01538</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_NUMERIC</name>
      <anchorfile>a01538.html</anchorfile>
      <anchor>d61a99694486f1331282354b9d0bc00a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ext/numeric</name>
    <filename>a01539</filename>
    <namespace>__gnu_cxx</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_NUMERIC</name>
      <anchorfile>a01539.html</anchorfile>
      <anchor>e1c349f71df0adf49bdd22d25d73b64d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__power</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6738f1c695c644f484b443310378c5cd</anchor>
      <arglist>(_Tp __x, _Integer __n)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__power</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>008bde52af2f0b62ffce3f56a3f5b984</anchor>
      <arglist>(_Tp __x, _Integer __n, _MonoidOperation __monoid_op)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>iota</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>gc4b0a5bcb36d0a4f8bc81054b3cd5de0</anchor>
      <arglist>(_ForwardIter __first, _ForwardIter __last, _Tp __value)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>power</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g2ceff004d19aac46dc5f7d21750b1dab</anchor>
      <arglist>(_Tp __x, _Integer __n)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>power</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g0d1846d5f66e2a5e24d9468b48976648</anchor>
      <arglist>(_Tp __x, _Integer __n, _MonoidOperation __monoid_op)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>parallel/numeric</name>
    <filename>a01540</filename>
    <namespace>std</namespace>
    <namespace>std::__parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_NUMERIC_H</name>
      <anchorfile>a01540.html</anchorfile>
      <anchor>afd5791b77dffdd62d1027ba5f806642</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a58a93596c398991c369158b73a8ab82</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, BinaryOperation binary_op)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3f73b729ef53212027cb5334dc1b03bc</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, BinaryOperation binary_op, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>5afa7e228fe152c3554198a27924d372</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>41e9bb493000422ca908a614df0ca751</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>34a70464ff50737ff2ea138c781fc2b3</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, BinaryOperation binary_op, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b3df2fb985072b53117e5724450a2864</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>96d9366db3aa0442111af95fe85e5be0</anchor>
      <arglist>(_RandomAccessIterator begin, _RandomAccessIterator end, T init, BinaryOperation binary_op, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_unbalanced)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>fdb02c6c767056b8e2fe1ac9e14be97b</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, BinaryOperation binary_op, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>accumulate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3d659d17b41cd519a5296b1d55771824</anchor>
      <arglist>(InputIterator begin, InputIterator end, T init, IteratorTag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1fb8f1955ab2b83626ed64b5d931ff0b</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation binary_op)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6eb670670a6c7bda4f664ab0ae71e13b</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation binary_op, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>0080dd033ad8b68db56b301b48cfd031</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>374484f1d5d8cdeffdf853ceb44170e7</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c7ef9e8dc96504a320fb8ab22cd7716e</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>6d9b6498e9326acf6e33e992a4d987b3</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2adcde01a5ea78d18838e8a7c428ebda</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_balanced)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>adjacent_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>19c8596daf9f8d252e8a5168fb871574</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>366e38f098d77b3e685587b8fcd57c91</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f3e5da14b9449666575d61b1c572f5f8</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1ef6e88a686e2c80fbcde4a9c2686422</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init, BinaryFunction1 binary_op1, BinaryFunction2 binary_op2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>73bf07b710ddf1a371a2b2f989f6c8ea</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init, BinaryFunction1 binary_op1, BinaryFunction2 binary_op2, __gnu_parallel::_Parallelism parallelism_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2da92b49266e472942953ebc4233eb9e</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init, BinaryFunction1 binary_op1, BinaryFunction2 binary_op2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9c6a45845409c50ece0f09274f8a5e7b</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>267043b01ab7672f36dbe682677228c7</anchor>
      <arglist>(InputIterator1 first1, InputIterator1 last1, InputIterator2 first2, T init, BinaryFunction1 binary_op1, BinaryFunction2 binary_op2, IteratorTag1, IteratorTag2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>inner_product_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d18c9fd3d019c83f423ef0386f98ae23</anchor>
      <arglist>(RandomAccessIterator1 first1, RandomAccessIterator1 last1, RandomAccessIterator2 first2, T init, BinaryFunction1 binary_op1, BinaryFunction2 binary_op2, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism parallelism_tag=__gnu_parallel::parallel_unbalanced)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>33c4601b5dd6001115ee40872e67bb03</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation binary_op)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>19c8f38bb1cb06ffb8af3ac0a254b833</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>49883440aba272fb1a6fc30285226ea0</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>dee2dfc6ab5a965529903db3313b14aa</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>partial_sum_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>82912f10cdb620e73096f33006e9eb4a</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>partial_sum_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>cb0d9f08d4b57464aa7962e3a5fcc9c3</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, IteratorTag1, IteratorTag2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>numeric_traits.h</name>
    <filename>a01541</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::__numeric_traits</class>
    <class kind="struct">__gnu_cxx::__numeric_traits_floating</class>
    <class kind="struct">__gnu_cxx::__numeric_traits_integer</class>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_digits</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>963ea0576f3715925ac80d47ef6a85f0</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_digits10</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>37ec457816fb975eb5fc20a7a8eaa8de</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_floating</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>8877a2fc26103581c822899bd7be1214</anchor>
      <arglist>(_Tp, _Fval, _Dval, _LDval)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_max</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>e9aeec92a8281cc4e29dd79963d55753</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_max_digits10</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>7fd0d80c5584866976c4fe920e937950</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_max_exponent10</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>cd1373648be0a1f63bb917002b9eb977</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_min</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>a568d589a482407bed8473a4075a1b2d</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__glibcxx_signed</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>db023fcfb8200c0606555664a742d2a7</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_NUMERIC_TRAITS</name>
      <anchorfile>a01541.html</anchorfile>
      <anchor>807bbae5023718c334eb14ef7f88a58e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>numericfwd.h</name>
    <filename>a01542</filename>
    <namespace>std</namespace>
    <namespace>std::__parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_NUMERICFWD_H</name>
      <anchorfile>a01542.html</anchorfile>
      <anchor>f847caea5202c17f6da8417330abe690</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3de2a459d29476dfe535c11b0ead5d25</anchor>
      <arglist>(_IIter, _IIter, _Tp, _BinaryOper, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>3cb32e94d140725060a76d9e8847d00b</anchor>
      <arglist>(_IIter, _IIter, _Tp, _BinaryOper, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a9f49456442f5b756d7a7351d1d05f37</anchor>
      <arglist>(_IIter, _IIter, _Tp, _BinaryOper)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2a2184b130822cd3aa626e2f41df5ca8</anchor>
      <arglist>(_IIter, _IIter, _Tp, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>80067ea92a9cfa9c1fec485dae192586</anchor>
      <arglist>(_IIter, _IIter, _Tp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>41ec28d5da39374d365e87c101ee6879</anchor>
      <arglist>(_IIter, _IIter, _Tp)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>53926bd0f274a7b11ebaf8ea2260add2</anchor>
      <arglist>(_RAIter, _RAIter, _Tp, _BinaryOper, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e158cf31e12986583beb813d6f178bb5</anchor>
      <arglist>(_IIter, _IIter, _Tp, _BinaryOper, _Tag)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>814083022573060243b61d677c0d17e8</anchor>
      <arglist>(_IIter, _IIter, _Tp, _Tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e66138bc587df4317c777633d60e1238</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>009415c11d4ebc6334d06276af0abd30</anchor>
      <arglist>(_IIter, _IIter, _OIter, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>2b02b9a76699d50706f36601e0c4100e</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>c6c806f80b072a5fa02c6a7428c6ba34</anchor>
      <arglist>(_IIter, _IIter, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>8f59c6c3470e098556c48087f95ea93f</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e280395afb74930fc786dd0644c93ed1</anchor>
      <arglist>(_IIter, _IIter, _OIter)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>a63127531e9919a231932ac4fdb9c671</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>adjacent_difference_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>832cb93783c6050d8bac8f86904c1b20</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, _Tag1, _Tag2)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ecb14af70f3bb21a3724b6099dcf9b28</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp, BinaryFunction1, BinaryFunction2, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f26900ed8dd8186d3b5e02b0987141b0</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp, _BinaryFunction1, _BinaryFunction2, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>163b0a637e3fa01630e46cb1c2682d46</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp, _BinaryFunction1, _BinaryFunction2)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>70c587857c454cc49568ccadcfe1eaa8</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>592e83fa608e62b95f69023fa12cc501</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>ddedb51eb907b3a9cd43433378c97e3e</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>17183e472d0163ac9e94c8e088e2107d</anchor>
      <arglist>(_IIter1, _IIter1, _IIter2, _Tp, _BinaryFunction1, _BinaryFunction2, _Tag1, _Tag2)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>7b63aeb8e7923c203f29a087c8886937</anchor>
      <arglist>(_RAIter1, _RAIter1, _RAIter2, _Tp, BinaryFunction1, BinaryFunction2, random_access_iterator_tag, random_access_iterator_tag, __gnu_parallel::_Parallelism)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>1bfd8cc1eb829500ea78eb256829e93d</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>f9b859a8b749e79c301e1cf40ee4a3fb</anchor>
      <arglist>(_IIter, _IIter, _OIter result)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>d79a8d7337c25bf61ee64c8e74c7d98b</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>partial_sum</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>9a9bff81f7691b016f2e0f0720c69302</anchor>
      <arglist>(_IIter, _IIter, _OIter, __gnu_parallel::sequential_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>partial_sum_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>e95ab10ec7507c09e91a0a12b8e36e48</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, random_access_iterator_tag, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OIter</type>
      <name>partial_sum_switch</name>
      <anchorfile>a01701.html</anchorfile>
      <anchor>b63db13b3ac303ea9bdc7adeb6d3f59f</anchor>
      <arglist>(_IIter, _IIter, _OIter, _BinaryOper, _Tag1, _Tag2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>omp_loop.h</name>
    <filename>a01543</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_OMP_LOOP_H</name>
      <anchorfile>a01543.html</anchorfile>
      <anchor>0a4c79f1eb9a8ad41f6fad79ea98536d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Op</type>
      <name>for_each_template_random_access_omp_loop</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>4037e2a12c2d3b8261bde097b7e7e9ac</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Op o, Fu &amp;f, Red r, Result base, Result &amp;output, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type bound)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>omp_loop_static.h</name>
    <filename>a01544</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_OMP_LOOP_STATIC_H</name>
      <anchorfile>a01544.html</anchorfile>
      <anchor>68fa53e698d2423f13dbe134b1085be9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Op</type>
      <name>for_each_template_random_access_omp_loop_static</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>2176bc8f15032f31621ebf02d99b6f0d</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Op o, Fu &amp;f, Red r, Result base, Result &amp;output, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type bound)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>os_defines.h</name>
    <filename>a01545</filename>
    <member kind="define">
      <type>#define</type>
      <name>__NO_CTYPE</name>
      <anchorfile>a01545.html</anchorfile>
      <anchor>afd8d7e2e2f15f45648e98ef585ea28b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_OS_DEFINES</name>
      <anchorfile>a01545.html</anchorfile>
      <anchor>00c3ff8112338194a0987e4dfa5f12e9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ostream</name>
    <filename>a01546</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_ostream</class>
    <class kind="class">std::basic_ostream::sentry</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_OSTREAM</name>
      <anchorfile>a01546.html</anchorfile>
      <anchor>944013159dd79458c1f397049d272064</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>endl</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>10ebe236b3a6e1c3f67686162aa3e7ce</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>ends</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5995b4f91efffb4d046090108b38505a</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>flush</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b1bd309c2a44ca8accde616e93eec3f3</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__os)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b42920e5308992cc20593e430c086a28</anchor>
      <arglist>(basic_ostream&lt; char, _Traits &gt; &amp;__out, const unsigned char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5189894f5670c7644e91f44ef4b1f40e</anchor>
      <arglist>(basic_ostream&lt; char, _Traits &gt; &amp;__out, const signed char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f7867013dfd626d4a0acc4c64c57c036</anchor>
      <arglist>(basic_ostream&lt; char, _Traits &gt; &amp;__out, const char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3801b148607fac836895f38d251130be</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, const char *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>50c0da6b065b543011676fdff70d0867</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, const _CharT *__s)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4f06e86740703af1ec05d23643200c63</anchor>
      <arglist>(basic_ostream&lt; char, _Traits &gt; &amp;__out, unsigned char __c)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d127c84363c3207fb4c60c03bbd20403</anchor>
      <arglist>(basic_ostream&lt; char, _Traits &gt; &amp;__out, signed char __c)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; char, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6f077e8e3cb79d6ee61455f40e0fe9c9</anchor>
      <arglist>(basic_ostream&lt; char, _Traits &gt; &amp;__out, char __c)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>83bf878ec4ee65ef74ec999f463bcaaa</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, char __c)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ed78da3940e0390c26019bd7308425f4</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, _CharT __c)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ostream.tcc</name>
    <filename>a01547</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_OSTREAM_TCC</name>
      <anchorfile>a01547.html</anchorfile>
      <anchor>5d7ce646f49020dec63122f72aaddd6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3801b148607fac836895f38d251130be</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, const char *__s)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ostream_insert.h</name>
    <filename>a01548</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_OSTREAM_INSERT_H</name>
      <anchorfile>a01548.html</anchorfile>
      <anchor>c141df028c13c9a97d91545f0a6ecc67</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__ostream_fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5c0525ef0fec149b272c51ce7aa22bd2</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, streamsize __n)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>__ostream_insert</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2615b1a4b279b3ac21e751c148cb7dcd</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, const _CharT *__s, streamsize __n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__ostream_write</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>84507a080106de135854eeefbace8a6e</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__out, const _CharT *__s, streamsize __n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>par_loop.h</name>
    <filename>a01549</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_PAR_LOOP_H</name>
      <anchorfile>a01549.html</anchorfile>
      <anchor>719a10ee080cd1fd9215fe0ce8c7d742</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Op</type>
      <name>for_each_template_random_access_ed</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>a9d382af8cce5f35352b41f2482a8b36</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Op o, Fu &amp;f, Red r, Result base, Result &amp;output, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type bound)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>parallel.h</name>
    <filename>a01550</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_PARALLEL_H</name>
      <anchorfile>a01550.html</anchorfile>
      <anchor>778f1eeaa770a28925569838f12fb97a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>partial_sum.h</name>
    <filename>a01551</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_PARTIAL_SUM_H</name>
      <anchorfile>a01551.html</anchorfile>
      <anchor>ebb5c617f14dee205a81fe9e5e8d42ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_partial_sum</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>e076daaef7b72aaab42bacdf241ce5a4</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_partial_sum_basecase</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>ede41ebea59b4328e895dfc4b589e2d7</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, typename std::iterator_traits&lt; InputIterator &gt;::value_type value)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_partial_sum_linear</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>d0412328a983deaa0f2010138523e351</anchor>
      <arglist>(InputIterator begin, InputIterator end, OutputIterator result, BinaryOperation bin_op, typename std::iterator_traits&lt; InputIterator &gt;::difference_type n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>partition.h</name>
    <filename>a01552</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_PARTITION_H</name>
      <anchorfile>a01552.html</anchorfile>
      <anchor>f4fa5631d107ca27e1809d3ba80b20c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_VOLATILE</name>
      <anchorfile>a01552.html</anchorfile>
      <anchor>4e32058cf550d7168927e9476c62f1cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_nth_element</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>fcb14fffcfec7f6b1426527b62e86fd5</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator nth, RandomAccessIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_partial_sort</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8d28f50a8004e041d38a952dd222a7b1</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator middle, RandomAccessIterator end, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type</type>
      <name>parallel_partition</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>df0a79c0952a270f505cb5137b9332fc</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Predicate pred, thread_index_t num_threads)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>pod_char_traits.h</name>
    <filename>a01553</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="struct">__gnu_cxx::character</class>
    <class kind="struct">std::char_traits&lt; __gnu_cxx::character&lt; V, I, S &gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_POD_CHAR_TRAITS_H</name>
      <anchorfile>a01553.html</anchorfile>
      <anchor>ee6136f65d91094557d5076ea6500f6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d50fcc6ad3e85203340bc33850a94450</anchor>
      <arglist>(const character&lt; V, I, S &gt; &amp;lhs, const character&lt; V, I, S &gt; &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>9f257a44be270f0860213968ad8dc5e4</anchor>
      <arglist>(const character&lt; V, I, S &gt; &amp;lhs, const character&lt; V, I, S &gt; &amp;rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>poly_hermite.tcc</name>
    <filename>a01554</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_POLY_HERMITE_TCC</name>
      <anchorfile>a01554.html</anchorfile>
      <anchor>6e097802a50ec4c2caa10e0bd36ebf12</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_hermite</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>4c38b891c41bcdade235861cd1ff09aa</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_hermite_recursion</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>a2fb6d27d56af5ca6859de0c9f97902d</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>poly_laguerre.tcc</name>
    <filename>a01555</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_POLY_LAGUERRE_TCC</name>
      <anchorfile>a01555.html</anchorfile>
      <anchor>187833d66dc7dd6b88b1e69fc620a5c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__assoc_laguerre</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>980cec2fc63168c054037b903224038c</anchor>
      <arglist>(const unsigned int __n, const unsigned int __m, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__laguerre</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>06c48311e9a7cb8bd6d1fbf1885e408a</anchor>
      <arglist>(const unsigned int __n, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_laguerre</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>323e16ae58d40e6f725dad856d1838de</anchor>
      <arglist>(const unsigned int __n, const _Tpa __alpha1, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_laguerre_hyperg</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>8e4b98f7bb64baaa8f842375e7257afe</anchor>
      <arglist>(const unsigned int __n, const _Tpa __alpha1, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_laguerre_large_n</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>20e25968badf20d8e06c9c0de99b24e2</anchor>
      <arglist>(const unsigned __n, const _Tpa __alpha1, const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__poly_laguerre_recursion</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>d01d572b49ab027d9901a579711f9a10</anchor>
      <arglist>(const unsigned int __n, const _Tpa __alpha1, const _Tp __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>pool_allocator.h</name>
    <filename>a01556</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::__pool_alloc</class>
    <class kind="struct">__gnu_cxx::__pool_alloc::rebind</class>
    <class kind="class">__gnu_cxx::__pool_alloc_base</class>
    <class kind="union">__gnu_cxx::__pool_alloc_base::_Obj</class>
    <member kind="define">
      <type>#define</type>
      <name>_POOL_ALLOCATOR_H</name>
      <anchorfile>a01556.html</anchorfile>
      <anchor>b899158ee1ca23807580224dd44ac244</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>706c9f14a3277b5d1fcf8fef4b6d3aa9</anchor>
      <arglist>(const __pool_alloc&lt; _Tp &gt; &amp;, const __pool_alloc&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>03948f9db65728b723d28d95b6aeb38d</anchor>
      <arglist>(const __pool_alloc&lt; _Tp &gt; &amp;, const __pool_alloc&lt; _Tp &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>postypes.h</name>
    <filename>a01557</filename>
    <namespace>std</namespace>
    <class kind="class">std::fpos</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_POSTYPES_H</name>
      <anchorfile>a01557.html</anchorfile>
      <anchor>6f2671683f43965347cb927ca7571af4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>long long</type>
      <name>streamoff</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c7c0b2396440c6a41662ca21d6e6889d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>fpos&lt; mbstate_t &gt;</type>
      <name>streampos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2c5ca398b17a255f6f5414484c848cbf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ptrdiff_t</type>
      <name>streamsize</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>288c7b0c59152caef61b3199559d6892</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>fpos&lt; mbstate_t &gt;</type>
      <name>wstreampos</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b47ec791379a1336c1e70e372b6c8f36</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d197637c27626268daef6c38ad01f6ff</anchor>
      <arglist>(const fpos&lt; _StateT &gt; &amp;__lhs, const fpos&lt; _StateT &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>19e2b127fee9d126ddfdc83448cb0a37</anchor>
      <arglist>(const fpos&lt; _StateT &gt; &amp;__lhs, const fpos&lt; _StateT &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>priority_queue.hpp</name>
    <filename>a01558</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="class">__gnu_pbds::priority_queue</class>
  </compound>
  <compound kind="file">
    <name>priority_queue_base_dispatch.hpp</name>
    <filename>a01559</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="struct">__gnu_pbds::detail::priority_queue_base_dispatch&lt; Value_Type, Cmp_Fn, binary_heap_tag, Allocator &gt;</class>
    <class kind="struct">__gnu_pbds::detail::priority_queue_base_dispatch&lt; Value_Type, Cmp_Fn, binomial_heap_tag, Allocator &gt;</class>
    <class kind="struct">__gnu_pbds::detail::priority_queue_base_dispatch&lt; Value_Type, Cmp_Fn, pairing_heap_tag, Allocator &gt;</class>
    <class kind="struct">__gnu_pbds::detail::priority_queue_base_dispatch&lt; Value_Type, Cmp_Fn, rc_binomial_heap_tag, Allocator &gt;</class>
    <class kind="struct">__gnu_pbds::detail::priority_queue_base_dispatch&lt; Value_Type, Cmp_Fn, thin_heap_tag, Allocator &gt;</class>
  </compound>
  <compound kind="file">
    <name>queue</name>
    <filename>a01560</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_QUEUE</name>
      <anchorfile>a01560.html</anchorfile>
      <anchor>8f886399bf9e05b45e9c815eca21477a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>queue.h</name>
    <filename>a01561</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="class">__gnu_parallel::RestrictedBoundedConcurrentQueue</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_QUEUE_H</name>
      <anchorfile>a01561.html</anchorfile>
      <anchor>863395378c83389bd17e70955e258044</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_VOLATILE</name>
      <anchorfile>a01561.html</anchorfile>
      <anchor>4e32058cf550d7168927e9476c62f1cf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>quicksort.h</name>
    <filename>a01562</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_QUICKSORT_H</name>
      <anchorfile>a01562.html</anchorfile>
      <anchor>c655c0490dafcb8b2cea85f1842a08d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_sort_qs</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>bc8c136877cf06aecc2515cbff89dcd6</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type n, int num_threads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_sort_qs_conquer</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>92afcf39bd4262374066eb3fb7052548</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, thread_index_t num_threads)</arglist>
    </member>
    <member kind="function">
      <type>std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type</type>
      <name>parallel_sort_qs_divide</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>85868cee8dcb9ebc9b6bfc68d5c3c850</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type pivot_rank, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type num_samples, thread_index_t num_threads)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>random</name>
    <filename>a01563</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_RANDOM</name>
      <anchorfile>a01563.html</anchorfile>
      <anchor>e90747240dea259324d68d40022012cd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/random</name>
    <filename>a01564</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01564.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01564.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01564.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01564.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_RANDOM</name>
      <anchorfile>a01564.html</anchorfile>
      <anchor>29302ef79dfcbfd2bc09b97edcd3b187</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/random</name>
    <filename>a01565</filename>
    <namespace>std</namespace>
    <namespace>std::__detail</namespace>
    <class kind="class">std::bernoulli_distribution</class>
    <class kind="class">std::binomial_distribution</class>
    <class kind="class">std::discard_block</class>
    <class kind="class">std::exponential_distribution</class>
    <class kind="class">std::gamma_distribution</class>
    <class kind="class">std::geometric_distribution</class>
    <class kind="class">std::linear_congruential</class>
    <class kind="class">std::mersenne_twister</class>
    <class kind="class">std::normal_distribution</class>
    <class kind="class">std::poisson_distribution</class>
    <class kind="class">std::random_device</class>
    <class kind="class">std::subtract_with_carry</class>
    <class kind="class">std::subtract_with_carry_01</class>
    <class kind="class">std::uniform_int</class>
    <class kind="class">std::uniform_real</class>
    <class kind="class">std::variate_generator</class>
    <class kind="class">std::xor_combine</class>
    <member kind="typedef">
      <type>linear_congruential&lt; unsigned long, 48271, 0, 2147483647 &gt;</type>
      <name>minstd_rand</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>g03bd32a3be8e1c55e5b59fbd3182af22</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>linear_congruential&lt; unsigned long, 16807, 0, 2147483647 &gt;</type>
      <name>minstd_rand0</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>g26a3e251b85d4aabdd76c4aff9372e6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mersenne_twister&lt; unsigned long, 32, 624, 397, 31, 0x9908b0dful, 11, 7, 0x9d2c5680ul, 15, 0xefc60000ul, 18 &gt;</type>
      <name>mt19937</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>g4e99e213cb1ead832617d8b6c94c5249</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>discard_block&lt; subtract_with_carry&lt; unsigned long,(1UL&lt;&lt; 24), 10, 24 &gt;, 223, 24 &gt;</type>
      <name>ranlux3</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>gdd037ec5fa13f5489e7f9d6c697a1604</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>discard_block&lt; subtract_with_carry_01&lt; float, 24, 10, 24 &gt;, 223, 24 &gt;</type>
      <name>ranlux3_01</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>gda43d9bb0220c49f6ccac84fd6c844cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>discard_block&lt; subtract_with_carry&lt; unsigned long,(1UL&lt;&lt; 24), 10, 24 &gt;, 389, 24 &gt;</type>
      <name>ranlux4</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>gf5f7544e7aee3a477f7dde69fded6065</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>discard_block&lt; subtract_with_carry_01&lt; float, 24, 10, 24 &gt;, 389, 24 &gt;</type>
      <name>ranlux4_01</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>g9c70b88fb6358335860198e1e60b9c61</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>subtract_with_carry_01&lt; double, 48, 5, 12 &gt;</type>
      <name>ranlux64_base_01</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>gef39e9eb43a4fc26eb48f89ff8b596b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>subtract_with_carry_01&lt; float, 24, 10, 24 &gt;</type>
      <name>ranlux_base_01</name>
      <anchorfile>a01721.html</anchorfile>
      <anchor>g05ebb5e8249900718b57118d9e5d87c9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>random.tcc</name>
    <filename>a01566</filename>
    <namespace>std</namespace>
    <namespace>std::__detail</namespace>
    <class kind="struct">std::__detail::_Mod</class>
    <class kind="struct">std::__detail::_Mod&lt; _Tp, __a, __c, __m, true &gt;</class>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>eee8d38e83ec2ac9f11ffc357fead968</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const gamma_distribution&lt; _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>49124297254e8fa9fbfb37033d35fd9d</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const normal_distribution&lt; _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>78bd5b51a5d82459132ef7618426999b</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const exponential_distribution&lt; _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aa6efc39ae461599370cbdd3c29477df</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const uniform_real&lt; _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f888910f89c463b3726a059e27336294</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const binomial_distribution&lt; _IntType, _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6e79f8ca49079604e148f037188e5053</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const poisson_distribution&lt; _IntType, _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c345bec390e2836234f058fb9d6c16e7</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const geometric_distribution&lt; _IntType, _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0b56775b90908a078a752903b07d8342</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const bernoulli_distribution &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3078713cac83e9f5ace084b3f38731c1</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const uniform_int&lt; _IntType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8dfda81054682a0273fcef0b20736b8b</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const xor_combine&lt; _UniformRandomNumberGenerator1, __s1, _UniformRandomNumberGenerator2, __s2 &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0e34e820b64a6418ccbc357b0f39a0b1</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const discard_block&lt; _UniformRandomNumberGenerator, __p, __r &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0d13e7b6f13ea8a96e47d0efb764adcb</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const subtract_with_carry_01&lt; _RealType, __w, __s, __r &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>43f400dc38b1d678c6049341c1d85013</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const subtract_with_carry&lt; _IntType, __m, __s, __r &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a3fdd9fa78019bb39f60b99d490ea738</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const mersenne_twister&lt; _UIntType, __w, __n, __m, __r, __a, __u, __s, __b, __t, __c, __l &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fc51ce85e6dd299300e32262d64e80ad</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const linear_congruential&lt; _UIntType, __a, __c, __m &gt; &amp;__lcr)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>589a63ee4446f6a4e288b4b07e6c65fc</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, normal_distribution&lt; _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a8b89b8a3e1723671e4ec522582384dd</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, uniform_real&lt; _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>87533d79a681763679d67341be36d59a</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, binomial_distribution&lt; _IntType, _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>242531a0b189089ad26d7f120336051f</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, poisson_distribution&lt; _IntType, _RealType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fcf964d1683d95d007145b23b5563043</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, uniform_int&lt; _IntType &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e9fa9c62c0bfe2409bee9f9b4d4abe10</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, xor_combine&lt; _UniformRandomNumberGenerator1, __s1, _UniformRandomNumberGenerator2, __s2 &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bb5b5a2f39c9623f31b56b377fbdaf53</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, discard_block&lt; _UniformRandomNumberGenerator, __p, __r &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a9a8ebc716fa03809fafc7329277f83e</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, subtract_with_carry_01&lt; _RealType, __w, __s, __r &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7bc3f1c33b7caa1f6787f54e025eb540</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, subtract_with_carry&lt; _IntType, __m, __s, __r &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f05b71526d9991c778abe48b4ea6f966</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, mersenne_twister&lt; _UIntType, __w, __n, __m, __r, __a, __u, __s, __b, __t, __c, __l &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ac417591fe79b48b590a54b78f9decf0</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, linear_congruential&lt; _UIntType, __a, __c, __m &gt; &amp;__lcr)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>random_number.h</name>
    <filename>a01567</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="class">__gnu_parallel::random_number</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_RANDOM_NUMBER_H</name>
      <anchorfile>a01567.html</anchorfile>
      <anchor>bea6551d3e00884bbf3808fbb0a07a7d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>random_shuffle.h</name>
    <filename>a01568</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::DRandomShufflingGlobalData</class>
    <class kind="struct">__gnu_parallel::DRSSorterPU</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_RANDOM_SHUFFLE_H</name>
      <anchorfile>a01568.html</anchorfile>
      <anchor>c8c93e9102a8e5a46215a037fc481038</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned short</type>
      <name>bin_index</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>b1d2084f77257e5713518c1248e514d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_random_shuffle</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>94a156cd8ffab131289513df815db391</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, RandomNumberGenerator rng=random_number())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_random_shuffle_drs</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f7092984d9729482304f3b46a32c50fa</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, typename std::iterator_traits&lt; RandomAccessIterator &gt;::difference_type n, thread_index_t num_threads, RandomNumberGenerator &amp;rng)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_random_shuffle_drs_pu</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>7b84f6b02fabb9c4fb88553c5225ce2c</anchor>
      <arglist>(DRSSorterPU&lt; RandomAccessIterator, RandomNumberGenerator &gt; *pus)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>random_number_pow2</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>d907d270476c5c58c43b906c5fd13cf1</anchor>
      <arglist>(int logp, RandomNumberGenerator &amp;rng)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>round_up_to_pow2</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>e6c7b9861a01bb8176e4dd8c5e4fe20c</anchor>
      <arglist>(T x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sequential_random_shuffle</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>5235590240603a9490386c113ada727d</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, RandomNumberGenerator &amp;rng)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rb_tree</name>
    <filename>a01569</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::rb_tree</class>
    <member kind="define">
      <type>#define</type>
      <name>_RB_TREE</name>
      <anchorfile>a01569.html</anchorfile>
      <anchor>9599c7fe5f7e7a0964ea812aec8810a3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rc_string_base.h</name>
    <filename>a01570</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::__rc_string_base</class>
    <member kind="define">
      <type>#define</type>
      <name>_RC_STRING_BASE_H</name>
      <anchorfile>a01570.html</anchorfile>
      <anchor>0f497b99275ab9f76d611fa14551571a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>regex</name>
    <filename>a01571</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX0X_REGEX</name>
      <anchorfile>a01571.html</anchorfile>
      <anchor>521864a43dc5b920444ed4cd9da86e48</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/regex</name>
    <filename>a01572</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01572.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01572.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01572.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01572.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_REGEX</name>
      <anchorfile>a01572.html</anchorfile>
      <anchor>f7588bc33ae4988209ad8ec3a6839f5b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/regex</name>
    <filename>a01573</filename>
    <namespace>std</namespace>
    <namespace>std::regex_constants</namespace>
    <class kind="class">std::basic_regex</class>
    <class kind="class">std::match_results</class>
    <class kind="class">std::regex_error</class>
    <class kind="class">std::regex_iterator</class>
    <class kind="class">std::regex_token_iterator</class>
    <class kind="struct">std::regex_traits</class>
    <class kind="class">std::sub_match</class>
    <member kind="typedef">
      <type>match_results&lt; const char * &gt;</type>
      <name>cmatch</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gd5083973d23df86614de0d40c8b80501</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_iterator&lt; const char * &gt;</type>
      <name>cregex_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g84999b60c0551d87eef295b4b7c5e424</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_token_iterator&lt; const char * &gt;</type>
      <name>cregex_token_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gbcab936ab0d29e42db35352da83745c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sub_match&lt; const char * &gt;</type>
      <name>csub_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g08250a75de17f88baab8e2e55ff3e18c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::bitset&lt; _S_match_flag_last &gt;</type>
      <name>match_flag_type</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>645c24fde9ed8de8ab20afcf1b22b198</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_regex&lt; char &gt;</type>
      <name>regex</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g3cb8662e6fb6a0bf973d90b1b33412c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>match_results&lt; string::const_iterator &gt;</type>
      <name>smatch</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g0a6355f925ceaaeec0ebaa7b70f3d2f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_iterator&lt; string::const_iterator &gt;</type>
      <name>sregex_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g0b60ceb5d45d44bcd3c4207672ccc213</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_token_iterator&lt; string::const_iterator &gt;</type>
      <name>sregex_token_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g4a0e0f43c84627c5517790eb59e596a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sub_match&lt; string::const_iterator &gt;</type>
      <name>ssub_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g72016d36a6e1fd67559e76b3030306b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned int</type>
      <name>syntax_option_type</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>e5c22fdee4c4225bc3d85c08869f646c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>match_results&lt; const wchar_t * &gt;</type>
      <name>wcmatch</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g24b98a37a3bb40503529b44187652dcf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_iterator&lt; const wchar_t * &gt;</type>
      <name>wcregex_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gbff7251bc7892f79e947ab823aea2a10</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_token_iterator&lt; const wchar_t * &gt;</type>
      <name>wcregex_token_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g4c2e54b2929f401076ad905366f62c39</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sub_match&lt; const wchar_t * &gt;</type>
      <name>wcsub_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g54d2a78875b0ff0b64702656117062d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_regex&lt; wchar_t &gt;</type>
      <name>wregex</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gffb6239690273ad7db55c1a01de6bcb8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>match_results&lt; wstring::const_iterator &gt;</type>
      <name>wsmatch</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g053a6081f0270895c41f4c2428271dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_iterator&lt; wstring::const_iterator &gt;</type>
      <name>wsregex_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g7199c8f0ffaecfb8c5a4093ae0812397</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>regex_token_iterator&lt; wstring::const_iterator &gt;</type>
      <name>wsregex_token_iterator</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g0c0c996e9774152c5cdfd731d2705cfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sub_match&lt; wstring::const_iterator &gt;</type>
      <name>wssub_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g514eb50d1a000ec8299621de89d2efaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>__match_flag</name>
      <anchor>07156cb2a7483c02ce7aa4adf1059449</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>__syntax_option</name>
      <anchor>981f0c0cf9971454dd0e11fd47cf9094</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>error_type</name>
      <anchor>77877de43f8cd19a7d6adec50e3566eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_backref</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>37ffbd9836600ccbb1dbbeb6d79b1ebf</anchor>
      <arglist>(_S_error_backref)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_badbrace</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>c6d3cd30d80617e13353bd2f5041022d</anchor>
      <arglist>(_S_error_badbrace)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_badrepeat</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>b96a0d8499a96b514216802bf574dd2e</anchor>
      <arglist>(_S_error_badrepeat)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_brace</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>c6f9efc3e12d83341d57bbeb92b6dc65</anchor>
      <arglist>(_S_error_brace)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_brack</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>18ff3fa237e2cc64eedc377a12e95b2e</anchor>
      <arglist>(_S_error_brack)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_collate</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>4fa0306d48d4765ef5207ce9ef0676c1</anchor>
      <arglist>(_S_error_collate)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_complexity</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>08615f81f3a8ed026a96ff4b4de618e8</anchor>
      <arglist>(_S_error_complexity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_ctype</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>9df1bb573bb48b47a3410cb19c68b2ed</anchor>
      <arglist>(_S_error_ctype)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_escape</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>e5f6db1bdb228ecfc02ad788620ec140</anchor>
      <arglist>(_S_error_escape)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_paren</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>df4e229b255b9e8cb88eeb91990c800a</anchor>
      <arglist>(_S_error_paren)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_range</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>e23113409af6ec4a971bd5069c98ee9f</anchor>
      <arglist>(_S_error_range)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_space</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>c2a629cc41b6d1b2d4eb485efa74c4e3</anchor>
      <arglist>(_S_error_space)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const error_type</type>
      <name>error_stack</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>33515b00f841ea4cabbf1f1b267533a8</anchor>
      <arglist>(_S_error_stack)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g069a9cd9b8aadaa103f033c9e378b311</anchor>
      <arglist>(const match_results&lt; _Bi_iter, _Allocator &gt; &amp;__m1, const match_results&lt; _Bi_iter, _Allocator &gt; &amp;__m2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g8657e6c10c3ccf9f4aeec4ad7de81698</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g22c7084730d77a68593c49b26983eeb4</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g52488e52c5a270199cb8b09546afa1c5</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g182477825c550851c9ff24d117e4fdb1</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>geb9467cfa72cde880c9184e76b077a0c</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gbc1fec0deee3476e883c9125354c7cfc</anchor>
      <arglist>(const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g70027e156400829997ac10553a9c327d</anchor>
      <arglist>(const sub_match&lt; _BiIter &gt; &amp;__lhs, const sub_match&lt; _BiIter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gb95bdc58e1d897e463281bb37a742dd5</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gab1dfc4e9e0bad7a45e568ae035b5a5c</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>ga5f17417b5c2a3a9c7eeb6476cd505cb</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g29e900784001305abd6b3abf068e4ef0</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g6c0d67072bfb02dcd2e62f658c2cb1bf</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g5b66ecf986971d1b02e8c2fe04ff1796</anchor>
      <arglist>(const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g35cd7137f36449c02526978c78cc5944</anchor>
      <arglist>(const sub_match&lt; _BiIter &gt; &amp;__lhs, const sub_match&lt; _BiIter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_ostream&lt; _Ch_type, _Ch_traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g8252f4a45721bb2e32aa9514e7caf7f4</anchor>
      <arglist>(basic_ostream&lt; _Ch_type, _Ch_traits &gt; &amp;__os, const sub_match&lt; _Bi_iter &gt; &amp;__m)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g46e519e7d2a297886edafcb24dfc74e1</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g1e4af8d54be3eaff40fc55d62324208e</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g6d08f899e1135e12bef50f89cc99d7a4</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g82046316d5bb917f10690591f99615d5</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g6a8e6e97250820e8304ea1e22927857f</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g6eaf570e4fd19ed117834a12ba8cd51c</anchor>
      <arglist>(const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g95e52130e153d8bb4888658d147cdea8</anchor>
      <arglist>(const sub_match&lt; _BiIter &gt; &amp;__lhs, const sub_match&lt; _BiIter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g82e9b501c5976a2b2645ad6926ca7c65</anchor>
      <arglist>(const match_results&lt; _Bi_iter, _Allocator &gt; &amp;__m1, const match_results&lt; _Bi_iter, _Allocator &gt; &amp;__m2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g9a149fc3799e27d148192f193bd7536e</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>ga398c108d593def47d2f096609b1a5c0</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gefb6f6d4c75415d2283b512d29b6a3b9</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gfbf28a999b8f2154d71d7743c61727cf</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g7565f1c44847497af53a1bae217c73bf</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gd3c2b9bf1d82afe30909660059de7e54</anchor>
      <arglist>(const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g27e8a58b5a30a237b65caef5877db9a1</anchor>
      <arglist>(const sub_match&lt; _BiIter &gt; &amp;__lhs, const sub_match&lt; _BiIter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gb079896b114db6072d07b439bf47cd1e</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g8261c602e15c07e2bed67b20de1f8025</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g748d81936cc8f2715335724ad10a64b5</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g339a66cda3b638f7088feb22c7337c53</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gf0b19a48f029ca202f3f195f897f8b57</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gfa2e47a9207ccf60119904dce00cd2e8</anchor>
      <arglist>(const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gfc723e258e871865d617878fd8bbfaa1</anchor>
      <arglist>(const sub_match&lt; _BiIter &gt; &amp;__lhs, const sub_match&lt; _BiIter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g27d114f26a4a2c2a53a5941fab1d30c0</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g4a1768485666e72bc838bdba5089cfb4</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g20e10f9d74c053243930abbafda567f0</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>ge9ff39ce4d620d8be2d239796cdb252a</anchor>
      <arglist>(typename iterator_traits&lt; _Bi_iter &gt;::value_type const *__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g9287a7d9bd275659852ebdb8eac1c198</anchor>
      <arglist>(const sub_match&lt; _Bi_iter &gt; &amp;__lhs, const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g8f3e4a1ffca3b4bef520698a2d5c124e</anchor>
      <arglist>(const basic_string&lt; typename iterator_traits&lt; _Bi_iter &gt;::value_type, _Ch_traits, _Ch_alloc &gt; &amp;__lhs, const sub_match&lt; _Bi_iter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>ge1df2231212460db24b5552a96c405aa</anchor>
      <arglist>(const sub_match&lt; _BiIter &gt; &amp;__lhs, const sub_match&lt; _BiIter &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gbfdc1320290d66cba48e43a7aa86339e</anchor>
      <arglist>(const basic_string&lt; _Ch_type, _Ch_traits, _Str_allocator &gt; &amp;__s, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g575294e9674b4f75583751fb6bf73fa3</anchor>
      <arglist>(const _Ch_type *__s, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __f=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g8295b7773d167f2612f215b84df1a59a</anchor>
      <arglist>(const basic_string&lt; _Ch_type, _Ch_traits, _Ch_alloc &gt; &amp;__s, match_results&lt; typename basic_string&lt; _Ch_type, _Ch_traits, _Ch_alloc &gt;::const_iterator, _Allocator &gt; &amp;__m, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gb069ac44d101f8f0ea3b4e8d838024ab</anchor>
      <arglist>(const _Ch_type *__s, match_results&lt; const _Ch_type *, _Allocator &gt; &amp;__m, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __f=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g14a3054a7a4beeda6b17ffa1ad5eaf83</anchor>
      <arglist>(_Bi_iter __first, _Bi_iter __last, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_match</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g76314701e43426398047720d0c9518ce</anchor>
      <arglist>(_Bi_iter __first, _Bi_iter __last, match_results&lt; _Bi_iter, _Allocator &gt; &amp;__m, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _Ch_type &gt;</type>
      <name>regex_replace</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gd36528e420ade3f6c53996f74ca20885</anchor>
      <arglist>(const basic_string&lt; _Ch_type &gt; &amp;__s, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__e, const basic_string&lt; _Ch_type &gt; &amp;__fmt, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>_Out_iter</type>
      <name>regex_replace</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g86f5dde39aa06d016126e83d4e4312c0</anchor>
      <arglist>(_Out_iter __out, _Bi_iter __first, _Bi_iter __last, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__e, const basic_string&lt; _Ch_type &gt; &amp;__fmt, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_search</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g2c0df9de31839e14090a6a4054d1faaf</anchor>
      <arglist>(const basic_string&lt; _Ch_type, _Ch_traits, _Ch_alloc &gt; &amp;__s, match_results&lt; typename basic_string&lt; _Ch_type, _Ch_traits, _Ch_alloc &gt;::const_iterator, _Allocator &gt; &amp;__m, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__e, regex_constants::match_flag_type __f=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_search</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>gfe23db87f81a03f0cbf33f618b93855b</anchor>
      <arglist>(const basic_string&lt; _Ch_type, _Ch_traits, _String_allocator &gt; &amp;__s, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__e, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_search</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g338bf407c3eac234da2f048a6b71d976</anchor>
      <arglist>(const _Ch_type *__s, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__e, regex_constants::match_flag_type __f=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_search</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g55a25d6e71c21e84a3c49d3fc0530303</anchor>
      <arglist>(const _Ch_type *__s, match_results&lt; const _Ch_type *, _Allocator &gt; &amp;__m, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__e, regex_constants::match_flag_type __f=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_search</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>ge456dc78c83c2a7a763cf1ac194b539e</anchor>
      <arglist>(_Bi_iter __first, _Bi_iter __last, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>regex_search</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g18dd08d01adcddb718106e1ddb012943</anchor>
      <arglist>(_Bi_iter __first, _Bi_iter __last, match_results&lt; _Bi_iter, _Allocator &gt; &amp;__m, const basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__re, regex_constants::match_flag_type __flags=regex_constants::match_default)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g952e8b7e307724d7a14fc394c2196d18</anchor>
      <arglist>(match_results&lt; _Bi_iter, _Allocator &gt; &amp;__lhs, match_results&lt; _Bi_iter, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01725.html</anchorfile>
      <anchor>g3b52ef17091f267e995e357003b8c746</anchor>
      <arglist>(basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__lhs, basic_regex&lt; _Ch_type, _Rx_traits &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>awk</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>f6611fcfc27cc66404bd86a8566a0a20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>basic</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>7cc2337860a195d30e60b5c2859aaf97</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>collate</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>1f1ac1b3ae3b9b3b47630847f1ada91f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>ECMAScript</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>2c4757be90af5f475e37b6cb74f1394b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>egrep</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>f98328f6a532aacf8b0957a6331dd2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>extended</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>15d56272405bf69afb7ea3e8848acdc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>format_default</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>38d51f0ed716bd905b32ec6dbae6a769</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>format_first_only</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>78d5a9ad84f4f4608a5a41009409cf37</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>format_no_copy</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>bd9385ebd2b9a15c3e98ae454aa8e889</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>format_sed</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>0f1fee9f4bf3cd2dfe444e5fb147d837</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>grep</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>28e34aec409ce227bd2dedd40a136c74</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>icase</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>00126c8e439e2ae61d7c5219622952e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_any</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>2843cd206c518852ab8ff54cd22c4e37</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_continuous</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>922baa4fb2f9555ddfbd9c50571047ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_default</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>bab58284bf5af08f600e9e9e6cf11724</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_not_bol</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>7ce2ed7f5fc8e2efef0bcbec44e794f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_not_bow</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>5642c3abf6a7cefc46ebef32c98ea7b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_not_eol</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>ffd0a4d8addc7c3a1ad72077e3629b48</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_not_eow</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>770c73b6d7592e1c82e9b400ecd637de</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_not_null</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>1419fea391164ece95e80740fd8c8138</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const match_flag_type</type>
      <name>match_prev_avail</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>6b5528b9b02696383a661bbaf979dc31</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>nosubs</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>2db57a4427420d0b89264ea8493566ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const syntax_option_type</type>
      <name>optimize</name>
      <anchorfile>a01704.html</anchorfile>
      <anchor>4c244b0e221821b526ef65bbbaa837a4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>riemann_zeta.tcc</name>
    <filename>a01574</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_RIEMANN_ZETA_TCC</name>
      <anchorfile>a01574.html</anchorfile>
      <anchor>43fbdb5470cc3ddc163b4cc03b5a64f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__hurwitz_zeta</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>0f233cae63912e1e89886a8083ec4842</anchor>
      <arglist>(const _Tp __a, const _Tp __s)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__hurwitz_zeta_glob</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>74e5992844e58b8ffb2a82519197fccd</anchor>
      <arglist>(const _Tp __a, const _Tp __s)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__riemann_zeta</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>31194b6f0bd1a56644f0c18f653110cf</anchor>
      <arglist>(const _Tp __s)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__riemann_zeta_alt</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>2fdd2420630211e5465d196830b4e72c</anchor>
      <arglist>(const _Tp __s)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__riemann_zeta_glob</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>9e4815a3c82e58c3640219b2c495e1ba</anchor>
      <arglist>(const _Tp __s)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__riemann_zeta_product</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>191c5f77af73782744b9fd70891f3e1a</anchor>
      <arglist>(const _Tp __s)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>__riemann_zeta_sum</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>1be1917016128eea614f74c868bd04cc</anchor>
      <arglist>(const _Tp __s)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rope</name>
    <filename>a01575</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>__gnu_cxx::__detail</namespace>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <class kind="struct">__gnu_cxx::_Refcount_Base</class>
    <class kind="struct">__gnu_cxx::_Rope_base</class>
    <class kind="class">__gnu_cxx::_Rope_char_consumer</class>
    <class kind="class">__gnu_cxx::_Rope_char_ptr_proxy</class>
    <class kind="class">__gnu_cxx::_Rope_char_ref_proxy</class>
    <class kind="struct">__gnu_cxx::_Rope_Concat_fn</class>
    <class kind="class">__gnu_cxx::_Rope_const_iterator</class>
    <class kind="class">__gnu_cxx::_Rope_iterator</class>
    <class kind="class">__gnu_cxx::_Rope_iterator_base</class>
    <class kind="struct">__gnu_cxx::_Rope_rep_base</class>
    <class kind="struct">__gnu_cxx::_Rope_RopeConcatenation</class>
    <class kind="struct">__gnu_cxx::_Rope_RopeFunction</class>
    <class kind="struct">__gnu_cxx::_Rope_RopeLeaf</class>
    <class kind="struct">__gnu_cxx::_Rope_RopeRep</class>
    <class kind="struct">__gnu_cxx::_Rope_RopeSubstring</class>
    <class kind="struct">__gnu_cxx::_Rope_self_destruct_ptr</class>
    <class kind="class">__gnu_cxx::char_producer</class>
    <class kind="class">__gnu_cxx::rope</class>
    <class kind="class">__gnu_cxx::sequence_buffer</class>
    <class kind="struct">std::tr1::hash&lt; __gnu_cxx::crope &gt;</class>
    <class kind="struct">std::tr1::hash&lt; __gnu_cxx::wrope &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>__GC_CONST</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>dd42bda9dece1ac141cc6590cbd3614c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__ROPE_DEFINE_ALLOC</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>7140360ca619fbd9ea014deedfd995f0</anchor>
      <arglist>(_Tp, __name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__ROPE_DEFINE_ALLOC</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>7140360ca619fbd9ea014deedfd995f0</anchor>
      <arglist>(_Tp, __name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__ROPE_DEFINE_ALLOCS</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>79bc91da6a71ff97c8f06642a66dfe3d</anchor>
      <arglist>(__a)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__STATIC_IF_SGI_ALLOC</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>a01aea3f79e5884328e7cb2c0c39d424</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__STL_FREE_STRING</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>f327702aa60b3eb05ebd395cb136cca6</anchor>
      <arglist>(__s, __l, __a)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__STL_ROPE_FROM_UNOWNED_CHAR_PTR</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>eb75e1f3a754b8fb8f931a8f46d2b31a</anchor>
      <arglist>(__s, __size, __a)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_ROPE</name>
      <anchorfile>a01575.html</anchorfile>
      <anchor>ab2955d42633f51e19916fd0eb483d6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>rope&lt; char &gt;</type>
      <name>crope</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>3a5a02bbb0d565f3a0b066ddbd9c4ee1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>rope&lt; wchar_t &gt;</type>
      <name>wrope</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6fee83fc63e575b5bc56b48033d7cd82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Tag</name>
      <anchor>3a30ae5843d89bce36679e78a45d1a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>crope::reference</type>
      <name>__mutable_reference_at</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c788de1a69eda3d8b5121fd43411b973</anchor>
      <arglist>(crope &amp;__c, size_t __i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_S_cond_store_eos</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d286de54f0320e6c812cb16fab582dad</anchor>
      <arglist>(wchar_t &amp;__c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_S_cond_store_eos</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>24013f6a0688593a3bd077a5dc135e01</anchor>
      <arglist>(char &amp;__c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_S_cond_store_eos</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>77b5a162db51268290b4d87d3bbfb3ce</anchor>
      <arglist>(_CharT &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_CharT</type>
      <name>_S_eos</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>3a44784fbd96a284220f44573bf43bcf</anchor>
      <arglist>(_CharT *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_S_is_basic_char_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>81eb68cbec120b0567eb2d6fb5406973</anchor>
      <arglist>(wchar_t *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_S_is_basic_char_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>87f6f385948cdc490e68db237f137b9c</anchor>
      <arglist>(char *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_S_is_basic_char_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>757ea92e4533b2d0277bccfa23a38cb6</anchor>
      <arglist>(_CharT *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_S_is_one_byte_char_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>0d2d8a15f77c53b44b6e7e0194090343</anchor>
      <arglist>(char *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_S_is_one_byte_char_type</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>60f67d914a6830e608dd46d3f0cf26e5</anchor>
      <arglist>(_CharT *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>e489116b6df5a4b009c2f4695342b751</anchor>
      <arglist>(const _Rope_char_ptr_proxy&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_char_ptr_proxy&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>5ffe7fef2e3838aa9fd2f33478270d91</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__x, const rope&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a755344f7e7404e504471375032a42d9</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>8a6ac129ed4351131204593c00024444</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>rope&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>f96a68c17fc9f3fb63a62c951290f597</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__left, _CharT __right)</arglist>
    </member>
    <member kind="function">
      <type>rope&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>fd8e9d260c6cceed224a85cfe89d24cb</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__left, const _CharT *__right)</arglist>
    </member>
    <member kind="function">
      <type>rope&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>26ce383bebb682f0af0646ea055f18f9</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__left, const rope&lt; _CharT, _Alloc &gt; &amp;__right)</arglist>
    </member>
    <member kind="function">
      <type>_Rope_iterator&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ea3e241b668a633d3568e5ff749abe89</anchor>
      <arglist>(ptrdiff_t __n, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>_Rope_iterator&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>546ddfe8f3b77dd6d5010a3e9a917099</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, ptrdiff_t __n)</arglist>
    </member>
    <member kind="function">
      <type>_Rope_const_iterator&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>f4c217c9b0cd93d7392e1c4948e0f128</anchor>
      <arglist>(ptrdiff_t __n, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>_Rope_const_iterator&lt; _CharT, _Alloc &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>cf18f80814c9460b8ad0f307e8442ecc</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, ptrdiff_t __n)</arglist>
    </member>
    <member kind="function">
      <type>rope&lt; _CharT, _Alloc &gt; &amp;</type>
      <name>operator+=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>1a871cd9bf12a0597af7bfaa4eea877b</anchor>
      <arglist>(rope&lt; _CharT, _Alloc &gt; &amp;__left, _CharT __right)</arglist>
    </member>
    <member kind="function">
      <type>rope&lt; _CharT, _Alloc &gt; &amp;</type>
      <name>operator+=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>24f39ba2b580ea8fc42a33e3fada053d</anchor>
      <arglist>(rope&lt; _CharT, _Alloc &gt; &amp;__left, const _CharT *__right)</arglist>
    </member>
    <member kind="function">
      <type>rope&lt; _CharT, _Alloc &gt; &amp;</type>
      <name>operator+=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>461e17654130e478dbef0eba0d7c7c71</anchor>
      <arglist>(rope&lt; _CharT, _Alloc &gt; &amp;__left, const rope&lt; _CharT, _Alloc &gt; &amp;__right)</arglist>
    </member>
    <member kind="function">
      <type>ptrdiff_t</type>
      <name>operator-</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>e9c2204fe9b8c5612c1b678012ba50da</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>_Rope_iterator&lt; _CharT, _Alloc &gt;</type>
      <name>operator-</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>f2cb11155883ab35ebdb6c6c7d014864</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, ptrdiff_t __n)</arglist>
    </member>
    <member kind="function">
      <type>ptrdiff_t</type>
      <name>operator-</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>47a894c7965fc9f70d30f16ec47b6d67</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>_Rope_const_iterator&lt; _CharT, _Alloc &gt;</type>
      <name>operator-</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>7a0b0122b0501abce1c6ea687c14e4d1</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, ptrdiff_t __n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ebfb2aa46b0202eb5a6713272ce617e4</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__left, const rope&lt; _CharT, _Alloc &gt; &amp;__right)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>5c4d9bfac13dba8e16e4bb38f9ece2f8</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a8d67f4f0d359c9b585c3ed08eae178d</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>05ecf8b7ef52291a1a2103449d60642e</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__o, const rope&lt; _CharT, _Alloc &gt; &amp;__r)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>10d1b717dfdcc8fd944a68fc702c526e</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__x, const rope&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a629f93345bacbddfe8d543529a4415e</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>1904f2be01a6822c9ef1618da4a18ab3</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>7d670184069dbb3a7c91b556b451bb77</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__left, const rope&lt; _CharT, _Alloc &gt; &amp;__right)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>401860a09b288d3e2ea68df4e411a71a</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>bbd9c636e66af854d2b1430ed0c00f42</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>61b810980a635b3d28c7c6271b34533a</anchor>
      <arglist>(const _Rope_char_ptr_proxy&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_char_ptr_proxy&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>be3579781a97a97a0e3a25b8b1f30d41</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__x, const rope&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>0348917e4a321e5758f42309c0984b84</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>b0a5889551d95f0691dca6bce8abd1ff</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>e2cc534b4180a37167bae4671f097b8b</anchor>
      <arglist>(const rope&lt; _CharT, _Alloc &gt; &amp;__x, const rope&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ac8254f2d15746f8b01c16ae8b949c76</anchor>
      <arglist>(const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a995b4e531885f381c5e2d46f0782490</anchor>
      <arglist>(const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__x, const _Rope_const_iterator&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c7abdf15049b9714a5f91d9c9d349a93</anchor>
      <arglist>(rope&lt; _CharT, _Alloc &gt; &amp;__x, rope&lt; _CharT, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>e69386dec127f76771354272a8404330</anchor>
      <arglist>(_Rope_char_ref_proxy&lt; _CharT, __Alloc &gt; __a, _Rope_char_ref_proxy&lt; _CharT, __Alloc &gt; __b)</arglist>
    </member>
    <member kind="variable">
      <type>rope&lt; _CharT, _Alloc &gt;</type>
      <name>identity_element</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a989c8884eb6e1b2b7d4a08fd650c3a0</anchor>
      <arglist>(_Rope_Concat_fn&lt; _CharT, _Alloc &gt;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ropeimpl.h</name>
    <filename>a01576</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::_Rope_find_char_char_consumer</class>
    <class kind="class">__gnu_cxx::_Rope_flatten_char_consumer</class>
    <class kind="class">__gnu_cxx::_Rope_insert_char_consumer</class>
    <member kind="function">
      <type>void</type>
      <name>_Rope_fill</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6809ce1899d42161ff2a7114262e7b9f</anchor>
      <arglist>(basic_ostream&lt; _CharT, _Traits &gt; &amp;__o, size_t __n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_Rope_is_simple</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>479ce8562d7dddbfa645ef684849e7a2</anchor>
      <arglist>(wchar_t *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_Rope_is_simple</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c929ea2d37572cf47352354d7350afc6</anchor>
      <arglist>(char *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>_Rope_is_simple</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d789ef96ccfc4a60a088b4999fcb751e</anchor>
      <arglist>(_CharT *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Rope_rotate</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c34c4aca8feda98dcbec6139b8b82b02</anchor>
      <arglist>(_Rope_iterator __first, _Rope_iterator __middle, _Rope_iterator __last)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>05ecf8b7ef52291a1a2103449d60642e</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__o, const rope&lt; _CharT, _Alloc &gt; &amp;__r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotate</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>4937ad6b8a003483ec6454c4b6c65f4a</anchor>
      <arglist>(_Rope_iterator&lt; char, __STL_DEFAULT_ALLOCATOR(char)&gt; __first, _Rope_iterator&lt; char, __STL_DEFAULT_ALLOCATOR(char)&gt; __middle, _Rope_iterator&lt; char, __STL_DEFAULT_ALLOCATOR(char)&gt; __last)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>safe_association.h</name>
    <filename>a01577</filename>
    <namespace>__gnu_debug</namespace>
    <class kind="class">__gnu_debug::_Safe_association</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SAFE_ASSOCIATION_H</name>
      <anchorfile>a01577.html</anchorfile>
      <anchor>7637dbe4ffe5628768a39cbb31591e9b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>safe_base.h</name>
    <filename>a01578</filename>
    <namespace>__gnu_debug</namespace>
    <class kind="class">__gnu_debug::_Safe_iterator_base</class>
    <class kind="class">__gnu_debug::_Safe_sequence_base</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SAFE_BASE_H</name>
      <anchorfile>a01578.html</anchorfile>
      <anchor>ae3d600b632a9620ba16c06ad3f1e8c8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>safe_iterator.h</name>
    <filename>a01579</filename>
    <namespace>__gnu_debug</namespace>
    <class kind="class">__gnu_debug::_Safe_iterator</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SAFE_ITERATOR_H</name>
      <anchorfile>a01579.html</anchorfile>
      <anchor>aa2ff23df7691efb6c1b7d46f285a421</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__check_singular_aux</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>e09673160860c2bbbdd1baed6d1f93b7</anchor>
      <arglist>(const _Safe_iterator_base *__x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>87af1ac4b9bb62ff63bae8d11cce59d5</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>76b3746f2f2f14249f27e52e52a09e6a</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>_Safe_iterator&lt; _Iterator, _Sequence &gt;</type>
      <name>operator+</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>40e1724d5996c6d01584855834b6c784</anchor>
      <arglist>(typename _Safe_iterator&lt; _Iterator, _Sequence &gt;::difference_type __n, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__i)</arglist>
    </member>
    <member kind="function">
      <type>_Safe_iterator&lt; _Iterator, _Sequence &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>a40fb49327675659edf3b364e01c4696</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>_Safe_iterator&lt; _IteratorL, _Sequence &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ce7a9e4e1fba8ea0783aa4fea7ffd0d3</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>a1c7498e06810792a3c58e6e3978dc0c</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>8e289e0be5bd66aa826e7fad3bb1d09e</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>375fd1919801bae0758011cc9d6788f5</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>a032af7b98cf845ac3b16558b0947598</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>fa479707650c5f5b8248a5ea37aaf298</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>30f57f0072267d9a3c51785bc7beb73a</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>5140d4f50ce3ddc2d54be60ab9e62ea1</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ee6b335cd6188412768a0b546d07f6cd</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>88b72ecd1a4596370deb1135a68d561f</anchor>
      <arglist>(const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _Iterator, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>d8ab2cc95446f568929308539b077415</anchor>
      <arglist>(const _Safe_iterator&lt; _IteratorL, _Sequence &gt; &amp;__lhs, const _Safe_iterator&lt; _IteratorR, _Sequence &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>safe_iterator.tcc</name>
    <filename>a01580</filename>
    <namespace>__gnu_debug</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SAFE_ITERATOR_TCC</name>
      <anchorfile>a01580.html</anchorfile>
      <anchor>f9331712e0fdab7f24403f49565a0069</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>safe_sequence.h</name>
    <filename>a01581</filename>
    <namespace>__gnu_debug</namespace>
    <class kind="class">__gnu_debug::_After_nth_from</class>
    <class kind="class">__gnu_debug::_Not_equal_to</class>
    <class kind="class">__gnu_debug::_Safe_sequence</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SAFE_SEQUENCE_H</name>
      <anchorfile>a01581.html</anchorfile>
      <anchor>716d7117110a0db8932bbff98fcd1057</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>search.h</name>
    <filename>a01582</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_SEARCH_H</name>
      <anchorfile>a01582.html</anchorfile>
      <anchor>225a0a1b88e2697cde05e8ad43a524bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>calc_borders</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>96c69498e4cc1110bf3152933b02de3a</anchor>
      <arglist>(RandomAccessIterator elements, _DifferenceTp length, _DifferenceTp *off)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator1</type>
      <name>search_template</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>3335a5d897ecb7bae2f13e7da8942aa6</anchor>
      <arglist>(_RandomAccessIterator1 begin1, _RandomAccessIterator1 end1, _RandomAccessIterator2 begin2, _RandomAccessIterator2 end2, Pred pred)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>set</name>
    <filename>a01583</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_SET</name>
      <anchorfile>a01583.html</anchorfile>
      <anchor>f8f97e65d61a683ccd786a8a05106c06</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/set</name>
    <filename>a01584</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SET</name>
      <anchorfile>a01584.html</anchorfile>
      <anchor>49b493ec60d956a41f7d99b9df727f31</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>set.h</name>
    <filename>a01585</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::set</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_SET_H</name>
      <anchorfile>a01585.html</anchorfile>
      <anchor>9d1a3c8787c7180701461674c93217f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>597c6ff782f6af4069189c2b9af8c4ab</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const set&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>9f1cccaaa30fdc7f4d4f78aece07d7be</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const set&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>f07962ae374126bbd7a3d5f76658254e</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const set&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>4e3a36d5e7505f2a3e9319063d06217a</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const set&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>9e3e036e4b38aa9b3ffb9e365a475c8a</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const set&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>f9890254128a7d22a48517442fe0f380</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Allocator &gt; &amp;__lhs, const set&lt; _Key, _Compare, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>3c9fcbb6cd601f06c599d57ad4b316b9</anchor>
      <arglist>(set&lt; _Key, _Compare, _Allocator &gt; &amp;__x, set&lt; _Key, _Compare, _Allocator &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>set_operations.h</name>
    <filename>a01586</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::difference_func</class>
    <class kind="struct">__gnu_parallel::intersection_func</class>
    <class kind="struct">__gnu_parallel::symmetric_difference_func</class>
    <class kind="struct">__gnu_parallel::union_func</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_SET_OPERATIONS_H</name>
      <anchorfile>a01586.html</anchorfile>
      <anchor>759a083980b02c401610bf011fc69048</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>copy_tail</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>258e2524dfe4f6825a0163d956f5d462</anchor>
      <arglist>(std::pair&lt; InputIterator, InputIterator &gt; b, std::pair&lt; InputIterator, InputIterator &gt; e, OutputIterator r)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_set_difference</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>300369f032ad5599c638e0c4f4ecb604</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, InputIterator begin2, InputIterator end2, OutputIterator result, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_set_intersection</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>30aac733ad58c981540a8835ebb925fd</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, InputIterator begin2, InputIterator end2, OutputIterator result, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_set_operation</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>e0d5fcf4941367823e23dfcddd0c62b4</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, InputIterator begin2, InputIterator end2, OutputIterator result, Operation op)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_set_symmetric_difference</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>205aff19856b6271dac1b716888df363</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, InputIterator begin2, InputIterator end2, OutputIterator result, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_set_union</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>0e5d2f537cdd76bab34457c4f163badc</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, InputIterator begin2, InputIterator end2, OutputIterator result, Comparator comp)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>13a0158d62b81b4f4c819c94740677dc</anchor>
      <arglist>(InputIterator begin1, InputIterator end1, InputIterator begin2, InputIterator end2, OutputIterator result)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>settings.h</name>
    <filename>a01587</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::_Settings</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_CONDITION</name>
      <anchorfile>a01587.html</anchorfile>
      <anchor>a1ab11688e65f33f9b939bfd8d94d9fd</anchor>
      <arglist>(c)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_SETTINGS_H</name>
      <anchorfile>a01587.html</anchorfile>
      <anchor>ff05b14da6d36fc5189ee57502d06ea0</anchor>
      <arglist></arglist>
    </member>
    <docanchor file="a01587">parallelization_decision</docanchor>
  </compound>
  <compound kind="file">
    <name>slice_array.h</name>
    <filename>a01588</filename>
    <namespace>std</namespace>
    <class kind="class">std::slice</class>
    <class kind="class">std::slice_array</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_OPERATOR</name>
      <anchorfile>a01588.html</anchorfile>
      <anchor>2d8d2d09544ebac440902adb07bbc233</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_SLICE_ARRAY_H</name>
      <anchorfile>a01588.html</anchorfile>
      <anchor>648f6cab04fadfbf359474b9931f3143</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>slist</name>
    <filename>a01589</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="struct">__gnu_cxx::_Slist_base</class>
    <class kind="struct">__gnu_cxx::_Slist_iterator</class>
    <class kind="struct">__gnu_cxx::_Slist_iterator_base</class>
    <class kind="struct">__gnu_cxx::_Slist_node</class>
    <class kind="struct">__gnu_cxx::_Slist_node_base</class>
    <class kind="class">__gnu_cxx::slist</class>
    <class kind="class">std::insert_iterator&lt; __gnu_cxx::slist&lt; _Tp, _Alloc &gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_SLIST</name>
      <anchorfile>a01589.html</anchorfile>
      <anchor>984a095cf83f83023ad0c12c62b8dbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Slist_node_base *</type>
      <name>__slist_make_link</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>9afa4a5034683f3f40d439be3797f447</anchor>
      <arglist>(_Slist_node_base *__prev_node, _Slist_node_base *__new_node)</arglist>
    </member>
    <member kind="function">
      <type>const _Slist_node_base *</type>
      <name>__slist_previous</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>80571d88551b9388219d575b489650fd</anchor>
      <arglist>(const _Slist_node_base *__head, const _Slist_node_base *__node)</arglist>
    </member>
    <member kind="function">
      <type>_Slist_node_base *</type>
      <name>__slist_previous</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>7ac23b6414eb8fef28eb08c44ade6fc5</anchor>
      <arglist>(_Slist_node_base *__head, const _Slist_node_base *__node)</arglist>
    </member>
    <member kind="function">
      <type>_Slist_node_base *</type>
      <name>__slist_reverse</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>21418d812272cb481a39e45b250e0567</anchor>
      <arglist>(_Slist_node_base *__node)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>__slist_size</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d871bd0a7edeafe31f5110f228b38e8e</anchor>
      <arglist>(_Slist_node_base *__node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__slist_splice_after</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>9dbda8760de8697ebd47267043def4ca</anchor>
      <arglist>(_Slist_node_base *__pos, _Slist_node_base *__head)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__slist_splice_after</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>a9318939da5c76836126861eb458680d</anchor>
      <arglist>(_Slist_node_base *__pos, _Slist_node_base *__before_first, _Slist_node_base *__before_last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>dbdc8a3d9f3c6c42644629080d5e26a5</anchor>
      <arglist>(const slist&lt; _Tp, _Alloc &gt; &amp;_SL1, const slist&lt; _Tp, _Alloc &gt; &amp;_SL2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>4bc5a3c80cd9e75da215065fc18e02ed</anchor>
      <arglist>(const slist&lt; _Tp, _Alloc &gt; &amp;_SL1, const slist&lt; _Tp, _Alloc &gt; &amp;_SL2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>d219305cb6461fbdf7154217e57f5bd0</anchor>
      <arglist>(const slist&lt; _Tp, _Alloc &gt; &amp;_SL1, const slist&lt; _Tp, _Alloc &gt; &amp;_SL2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>bb9e8cacf2df0a528c01ada40dca6446</anchor>
      <arglist>(const slist&lt; _Tp, _Alloc &gt; &amp;_SL1, const slist&lt; _Tp, _Alloc &gt; &amp;_SL2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>b18dfba2d7394132cd358c1371160d29</anchor>
      <arglist>(const slist&lt; _Tp, _Alloc &gt; &amp;_SL1, const slist&lt; _Tp, _Alloc &gt; &amp;_SL2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>4727d8922d37cdade0cb9723990c4be3</anchor>
      <arglist>(const slist&lt; _Tp, _Alloc &gt; &amp;_SL1, const slist&lt; _Tp, _Alloc &gt; &amp;_SL2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>9c35535f167691f44c4a6744aa9c0a14</anchor>
      <arglist>(slist&lt; _Tp, _Alloc &gt; &amp;__x, slist&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>sort.h</name>
    <filename>a01590</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_SORT_H</name>
      <anchorfile>a01590.html</anchorfile>
      <anchor>4db8eb5906f094cc89281ed20d0fc002</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>parallel_sort</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>5c8dd9fbd3b1860c9847c4d6a543b544</anchor>
      <arglist>(RandomAccessIterator begin, RandomAccessIterator end, Comparator comp, bool stable)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>special_function_util.h</name>
    <filename>a01591</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <namespace>std::tr1::__detail</namespace>
    <class kind="struct">std::tr1::__detail::__floating_point_constant</class>
    <class kind="struct">std::tr1::__detail::__numeric_constants</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_SPECIAL_FUNCTION_UTIL_H</name>
      <anchorfile>a01591.html</anchorfile>
      <anchor>bcb9fb5a3349c3c546cacb6f77e2866c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__isnan</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>cea2e699e8167a4c54519bf99dcc13b9</anchor>
      <arglist>(const _Tp __x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__isnan&lt; float &gt;</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>3b7997c33fba0d2037f735ab45e6f852</anchor>
      <arglist>(const float __x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__isnan&lt; long double &gt;</name>
      <anchorfile>a01487.html</anchorfile>
      <anchor>4b096d355afa9ab8c8583a84b3061abd</anchor>
      <arglist>(const long double __x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>sso_string_base.h</name>
    <filename>a01592</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::__sso_string_base</class>
    <member kind="define">
      <type>#define</type>
      <name>_SSO_STRING_BASE_H</name>
      <anchorfile>a01592.html</anchorfile>
      <anchor>38f59d3d8b90dd34af5d1bea33254326</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>sstream</name>
    <filename>a01593</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_istringstream</class>
    <class kind="class">std::basic_ostringstream</class>
    <class kind="class">std::basic_stringbuf</class>
    <class kind="class">std::basic_stringstream</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_SSTREAM</name>
      <anchorfile>a01593.html</anchorfile>
      <anchor>e1d6c90a7f38298ff63eae4846cb25ab</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>sstream.tcc</name>
    <filename>a01594</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_SSTREAM_TCC</name>
      <anchorfile>a01594.html</anchorfile>
      <anchor>4b327b703e574c4db6a48806a75f0796</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stack</name>
    <filename>a01595</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STACK</name>
      <anchorfile>a01595.html</anchorfile>
      <anchor>959daa3939097280b17c9829be3555e2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>standard_policies.hpp</name>
    <filename>a01596</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="struct">__gnu_pbds::detail::default_comb_hash_fn</class>
    <class kind="struct">__gnu_pbds::detail::default_eq_fn</class>
    <class kind="struct">__gnu_pbds::detail::default_hash_fn</class>
    <class kind="struct">__gnu_pbds::detail::default_probe_fn</class>
    <class kind="struct">__gnu_pbds::detail::default_resize_policy</class>
    <class kind="struct">__gnu_pbds::detail::default_trie_e_access_traits&lt; std::basic_string&lt; Char, Char_Traits, std::allocator&lt; char &gt; &gt; &gt;</class>
    <class kind="struct">__gnu_pbds::detail::default_update_policy</class>
  </compound>
  <compound kind="file">
    <name>stdarg.h</name>
    <filename>a01597</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_STDARG_H</name>
      <anchorfile>a01597.html</anchorfile>
      <anchor>30802ba36e70c0ddb206ea977f50674b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdbool.h</name>
    <filename>a01598</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_STDBOOL_H</name>
      <anchorfile>a01598.html</anchorfile>
      <anchor>9cf3515d6c37bd75f602be2a36223eb2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdexcept</name>
    <filename>a01599</filename>
    <namespace>std</namespace>
    <class kind="class">std::domain_error</class>
    <class kind="class">std::invalid_argument</class>
    <class kind="class">std::length_error</class>
    <class kind="class">std::logic_error</class>
    <class kind="class">std::out_of_range</class>
    <class kind="class">std::overflow_error</class>
    <class kind="class">std::range_error</class>
    <class kind="class">std::runtime_error</class>
    <class kind="class">std::underflow_error</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STDEXCEPT</name>
      <anchorfile>a01599.html</anchorfile>
      <anchor>392cefaa65ec689774786dd0a0d4b552</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdint.h</name>
    <filename>a01600</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_STDINT_H</name>
      <anchorfile>a01600.html</anchorfile>
      <anchor>32b6aad77209f573585bfce294d7d75a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdio.h</name>
    <filename>a01601</filename>
    <member kind="define">
      <type>#define</type>
      <name>_TR1_STDIO_H</name>
      <anchorfile>a01601.html</anchorfile>
      <anchor>b28b77c20bff1c1c4e9328071b364880</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdio_filebuf.h</name>
    <filename>a01602</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::stdio_filebuf</class>
    <member kind="define">
      <type>#define</type>
      <name>_STDIO_FILEBUF_H</name>
      <anchorfile>a01602.html</anchorfile>
      <anchor>0c98e5cfced1830c2afc78bc74c78074</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdio_sync_filebuf.h</name>
    <filename>a01603</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="class">__gnu_cxx::stdio_sync_filebuf</class>
    <member kind="define">
      <type>#define</type>
      <name>_STDIO_SYNC_FILEBUF_H</name>
      <anchorfile>a01603.html</anchorfile>
      <anchor>45f63373035dd07da9dd802873a519f3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stdlib.h</name>
    <filename>a01604</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_STDLIB_H</name>
      <anchorfile>a01604.html</anchorfile>
      <anchor>96f66e61717140cf5b53407ed3043ccf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_algo.h</name>
    <filename>a01605</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STL_ALGO_H</name>
      <anchorfile>a01605.html</anchorfile>
      <anchor>248ac5e3b5c99d364fdcaadffdb9a267</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__chunk_insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c53db766f4194f19d23c155481c1aa69</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Distance __chunk_size, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__chunk_insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fc8c06f2c8491bc19a18e6b7420c526d</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Distance __chunk_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__final_insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d0e85edee673d62db801e23032fb1f35</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__final_insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d4b502037ad9f2778ef720c94fd83b5e</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>__find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e8b4234ab201e46612f02fd7c92b8e0c</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, const _Tp &amp;__val, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>__find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dc9348269627403f8925132ba37f05b8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, const _Tp &amp;__val, input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_BidirectionalIterator1</type>
      <name>__find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2b06912c9da8da034fa70e107eeb574d</anchor>
      <arglist>(_BidirectionalIterator1 __first1, _BidirectionalIterator1 __last1, _BidirectionalIterator2 __first2, _BidirectionalIterator2 __last2, bidirectional_iterator_tag, bidirectional_iterator_tag, _BinaryPredicate __comp)</arglist>
    </member>
    <member kind="function">
      <type>_BidirectionalIterator1</type>
      <name>__find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>12f9487da807c06e69abd813b10ddbc3</anchor>
      <arglist>(_BidirectionalIterator1 __first1, _BidirectionalIterator1 __last1, _BidirectionalIterator2 __first2, _BidirectionalIterator2 __last2, bidirectional_iterator_tag, bidirectional_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator1</type>
      <name>__find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1b837562341bea03d8453e4885308b6d</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2, _ForwardIterator2 __last2, forward_iterator_tag, forward_iterator_tag, _BinaryPredicate __comp)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator1</type>
      <name>__find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cb2d7d151d59ff2ec7023757c6eb8fb9</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2, _ForwardIterator2 __last2, forward_iterator_tag, forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>__find_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>03c9ba725e30da6c4638895aaae9a830</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Predicate __pred, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>__find_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1a79f91a4729a9e1bbb6a2076b1aece8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Predicate __pred, input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_EuclideanRingElement</type>
      <name>__gcd</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>88ffa0035ab6bbb4c15f4bffd9665948</anchor>
      <arglist>(_EuclideanRingElement __m, _EuclideanRingElement __n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__heap_select</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0ffa7b133a43364a1cfd5f66a97be196</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __middle, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__heap_select</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>db43eafedb98bb5d9382bc0517911fbe</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __middle, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__inplace_stable_partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b9c7827f806898a69b55313941272b90</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred, _Distance __len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__inplace_stable_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8893d1732ade2b01ba5e39f3c4077bb4</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__inplace_stable_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>772d7174aa210b16817c7defa3011c5c</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a5ba11b4ca2f28e0aa6793f387d06cad</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0c7687d66b904f0b3a3535612e8cb130</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__introselect</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>da6d9825922db156ad0c80b2976a7f7a</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __nth, _RandomAccessIterator __last, _Size __depth_limit, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__introselect</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4d125ef5295163d659b665828903e95e</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __nth, _RandomAccessIterator __last, _Size __depth_limit)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__introsort_loop</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c8f8ca7241f84bd1d780cd8beb50dd7d</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Size __depth_limit, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__introsort_loop</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e6b6c0dbed0d4d25b0b0dd7ccf617f5a</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Size __depth_limit)</arglist>
    </member>
    <member kind="function">
      <type>long long</type>
      <name>__lg</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>02fd30d838924ec67d40856fa9cb0c0f</anchor>
      <arglist>(long long __n)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>__lg</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0070d7f0ed2850539ebc4504af8d9d89</anchor>
      <arglist>(long __n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>__lg</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a5368303d71e7a1952ab6dc690dc1bab</anchor>
      <arglist>(int __n)</arglist>
    </member>
    <member kind="function">
      <type>_Size</type>
      <name>__lg</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0464ede25c1b2b0d912a72c7c612c27b</anchor>
      <arglist>(_Size __n)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>__median</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>ged4c6d08738a0ab728911d6d20b0b5b0</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b, const _Tp &amp;__c, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>__median</name>
      <anchorfile>a01718.html</anchorfile>
      <anchor>g606c564c2b3a1698f4a566722c3800b0</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b, const _Tp &amp;__c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_adaptive</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f10f1a8d765c1aafb754a4f3c96f5920</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last, _Distance __len1, _Distance __len2, _Pointer __buffer, _Distance __buffer_size, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_adaptive</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c33a590163c716d7cb67eabc3e836425</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last, _Distance __len1, _Distance __len2, _Pointer __buffer, _Distance __buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>_BidirectionalIterator3</type>
      <name>__merge_backward</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b5bec7bc62f9f145ac769bc1071840c4</anchor>
      <arglist>(_BidirectionalIterator1 __first1, _BidirectionalIterator1 __last1, _BidirectionalIterator2 __first2, _BidirectionalIterator2 __last2, _BidirectionalIterator3 __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_BidirectionalIterator3</type>
      <name>__merge_backward</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c5fc92f3c739969613afa743f2036d61</anchor>
      <arglist>(_BidirectionalIterator1 __first1, _BidirectionalIterator1 __last1, _BidirectionalIterator2 __first2, _BidirectionalIterator2 __last2, _BidirectionalIterator3 __result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_sort_loop</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>323df9fb6a8e864c922ef4cbc3142f5a</anchor>
      <arglist>(_RandomAccessIterator1 __first, _RandomAccessIterator1 __last, _RandomAccessIterator2 __result, _Distance __step_size, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_sort_loop</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b07c052ac7c5234ae16ac5f9ac1bde87</anchor>
      <arglist>(_RandomAccessIterator1 __first, _RandomAccessIterator1 __last, _RandomAccessIterator2 __result, _Distance __step_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_sort_with_buffer</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9457f4cd594818f6ee5a697bd6f54021</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Pointer __buffer, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_sort_with_buffer</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e3f656c6977bd59a1bef57d6db532b8</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Pointer __buffer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_without_buffer</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4d1fd48a93cf6de6b16720d9c1ac9dcc</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last, _Distance __len1, _Distance __len2, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__merge_without_buffer</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>12646b83fdd4f8d6ddd6dae3b364e219</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last, _Distance __len1, _Distance __len2)</arglist>
    </member>
    <member kind="function">
      <type>_BidirectionalIterator</type>
      <name>__partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6fea4751d3ef25a4ca8302d2fe91fb1d</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last, _Predicate __pred, bidirectional_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c354af934eeedc26341d843cd54e7705</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred, forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__reverse</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8b8bf3938aa7464261955d0bc155d5a8</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__reverse</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a90c9ec75172f214681d0a6c259af2fb</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last, bidirectional_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__rotate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c308ca2c992f7ab5db26cd3d162852a5</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __middle, _RandomAccessIterator __last, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__rotate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>967c63b75a5c44457a4993d3f98811d8</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last, bidirectional_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__rotate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bf78570e38d0b98893321d6aa3323abc</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __middle, _ForwardIterator __last, forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_BidirectionalIterator1</type>
      <name>__rotate_adaptive</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8578cecfefb15cd5369824044569f3df</anchor>
      <arglist>(_BidirectionalIterator1 __first, _BidirectionalIterator1 __middle, _BidirectionalIterator1 __last, _Distance __len1, _Distance __len2, _BidirectionalIterator2 __buffer, _Distance __buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIter</type>
      <name>__search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>090f3c183858208626c9a44f0576da77</anchor>
      <arglist>(_RandomAccessIter __first, _RandomAccessIter __last, _Integer __count, const _Tp &amp;__val, _BinaryPredicate __binary_pred, std::random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>732b36297658334ea553eb0e75d6aca0</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Integer __count, const _Tp &amp;__val, _BinaryPredicate __binary_pred, std::forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIter</type>
      <name>__search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>08245dbe4712d3a8ac0921c34625eee4</anchor>
      <arglist>(_RandomAccessIter __first, _RandomAccessIter __last, _Integer __count, const _Tp &amp;__val, std::random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c073d7aa5e4e753a53968cb4b9e08505</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Integer __count, const _Tp &amp;__val, std::forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__stable_partition_adaptive</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0e35e129eec534cbb9065df80d31a7c0</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred, _Distance __len, _Pointer __buffer, _Distance __buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__stable_sort_adaptive</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7b413cf7ccdcfecc0bfbcebabd6a1d87</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Pointer __buffer, _Distance __buffer_size, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__stable_sort_adaptive</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>eb19b0b1e3a7a8a6e4749a2413e88ad0</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Pointer __buffer, _Distance __buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__unguarded_insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>06d2853f3c7cc9861eede726c419a1a1</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__unguarded_insertion_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fa2f55e68c66e1c0b4de37d6d4be24bf</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__unguarded_linear_insert</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2fa37c9b23256fcfbafffea89e2e5c41</anchor>
      <arglist>(_RandomAccessIterator __last, _Tp __val, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__unguarded_linear_insert</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>986a8a7013c23f840bed42d3c6d95478</anchor>
      <arglist>(_RandomAccessIterator __last, _Tp __val)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>__unguarded_partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0883ee69ac48bfd6e991f6c5aa8e0532</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Tp __pivot, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>__unguarded_partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>be97d880736a0e401c98e1e054a93069</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Tp __pivot)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3f711bb5abf709a2583d0717a010a998</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _ForwardIterator __result, _BinaryPredicate __binary_pred, input_iterator_tag, forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>__unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>676f80b4112bf17349243607db2326e8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _BinaryPredicate __binary_pred, input_iterator_tag, output_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>__unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7d7f0719ddbdfb3b91ac0256cf221ef8</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _OutputIterator __result, _BinaryPredicate __binary_pred, forward_iterator_tag, output_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>177e0ecd99d60589a9a84f62bc03399f</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _ForwardIterator __result, input_iterator_tag, forward_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>__unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ad7f3f6bf5fc140d9617a3c64155a28a</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, input_iterator_tag, output_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>__unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e95667ed6f7fcc8150a7957d6724d0ce</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _OutputIterator __result, forward_iterator_tag, output_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>adjacent_find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>556d1329c67f46dfecb717ae255b547e</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>adjacent_find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a25abcf98907957d79076f7d87482986</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>binary_search</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>g3f3b4d2c4ec330338ab99c7779238f74</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>binary_search</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>g5d2a17680134ff4a1915ee80cf187589</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _InputIterator &gt;::difference_type</type>
      <name>count</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c950d4a3065ca90e5d2d767e167254a8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _InputIterator &gt;::difference_type</type>
      <name>count_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>788667cd2ea0498225daf325b1b53fe6</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _ForwardIterator, _ForwardIterator &gt;</type>
      <name>equal_range</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>g877cd65b496efc0c85d787965f4319fa</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _ForwardIterator, _ForwardIterator &gt;</type>
      <name>equal_range</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>gcdc30367323ec219bb07c77fa95f4659</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7035efa7987e0fa2417812674317a08e</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, const _Tp &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator1</type>
      <name>find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fb3fe80f18ff907e21a2072b6f10a724</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2, _ForwardIterator2 __last2, _BinaryPredicate __comp)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator1</type>
      <name>find_end</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ae80b1ef8be0bc74421f3fc7df5f2f60</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2, _ForwardIterator2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>find_first_of</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b9765faea864d513ece3268743e6c79f</anchor>
      <arglist>(_InputIterator __first1, _InputIterator __last1, _ForwardIterator __first2, _ForwardIterator __last2, _BinaryPredicate __comp)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>find_first_of</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2eafba78f5048e42d443d16fe4f91a22</anchor>
      <arglist>(_InputIterator __first1, _InputIterator __last1, _ForwardIterator __first2, _ForwardIterator __last2)</arglist>
    </member>
    <member kind="function">
      <type>_InputIterator</type>
      <name>find_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>64ea380bd0bfded2048c587f38d6e3a7</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>_Function</type>
      <name>for_each</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>13cb14e06e17b532cc35edfd9d5b3038</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Function __f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>85e8f5b9176a8a77ba3be339190ea15e</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Generator __gen)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>generate_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3fbc9f379a1793cc3fbab5be1ecb1937</anchor>
      <arglist>(_OutputIterator __first, _Size __n, _Generator __gen)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includes</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g65ccd3439ad4a63e44a8cc247615a560</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includes</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>gab7e3a37453e2add39c763bc165ffdc1</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inplace_merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3c4986b5bf5aa8350a5dc5e1ed411a27</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inplace_merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a6dd8b9cae96ccdf58e3fcdbcc4f6ea1</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __middle, _BidirectionalIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>lower_bound</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>g7a741cced9926572a169f83f0c119954</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>lower_bound</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>g2e825c4e257a6850552f9bfbbc2e14e3</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>78581777b98a8b873186a34a2a836bc7</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>max_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e74882f308c4094320f59d760dc41df4</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d0684eb5fd9765e867800ddb5b46a643</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>merge</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b2f447c588d30150c5cfed491ad2c292</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2282df06237f079a62c795a90d8f4ba3</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>min_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d96ddeeeb129c91c8127272a8811c7ad</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f1e255e229c286e3dea55bdd99cd58e7</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d3923909fed5af70c3412e523437ff51</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b5ca80412d22cd7be32d57a2c05d79b0</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __nth, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nth_element</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>30ed84fb3ef594553a52f7b3a0bef517</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __nth, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5f48b65c7ba5781f0f85196a4f917abe</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __middle, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>partial_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>06e3ef5c74c081868d8e720768c65224</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __middle, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>partial_sort_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>defb743a6da40859492ce7567ed6b3a2</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _RandomAccessIterator __result_first, _RandomAccessIterator __result_last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_RandomAccessIterator</type>
      <name>partial_sort_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>640b144bcae58178ecfaa1cde0b262c8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _RandomAccessIterator __result_first, _RandomAccessIterator __result_last)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e71e50bd4b1799f3c4d6aa50b382dfe4</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prev_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b394ecb044f4b1fac132aabd7d77c624</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prev_permutation</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f1dc891a515820c778c9a8d6e7a926bf</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>92ab465d5b3892eafda49d7bf38e0559</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _RandomNumberGenerator &amp;__rand)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>random_shuffle</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4e1aea1b42cd0380ca15a771b8f00e2a</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>remove</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>11bf487db4d59c71ddb1b424fb4d321f</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>remove_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a597080f71f2de576a0db8f552accba7</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>remove_copy_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0cb0abc8266f8525819cfac709d230c8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>remove_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3b61301da3d123a8f902a673116ba8ef</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b6f0983e83a19ff91469619cdbe90445</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__old_value, const _Tp &amp;__new_value)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>replace_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>af0e60dbd7dd2271fbd52994982061d0</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, const _Tp &amp;__old_value, const _Tp &amp;__new_value)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>replace_copy_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a23aba9dc58cc62a33d390b5594946b8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _Predicate __pred, const _Tp &amp;__new_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_if</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6f83cac5627efdd6dd0da86bd7a01a38</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred, const _Tp &amp;__new_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reverse</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ec7ed32141676ef21b850530ff6ba09a</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>reverse_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>67a1e21bed597093b51c240117aaa47a</anchor>
      <arglist>(_BidirectionalIterator __first, _BidirectionalIterator __last, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e07626d4d23b85a28a9ac0e4c732598c</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __middle, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>rotate_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>128a10da9d098c9db263045bc8a3c673</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __middle, _ForwardIterator __last, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator1</type>
      <name>search</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4fdba14b0a3f2410adc579723c44b871</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2, _ForwardIterator2 __last2, _BinaryPredicate __predicate)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator1</type>
      <name>search</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d2733909b719f32d7e620330ed72c94f</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2, _ForwardIterator2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7bb92c0efc0e778052367fd61b4f797e</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Integer __count, const _Tp &amp;__val, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>search_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f5ffae769fa86ea09794a50c3e15e9b5</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Integer __count, const _Tp &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_difference</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g72ff3ae9e8e421ecce8f933815b7ecbf</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_difference</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g9a522e23e774d12df48cc5b7ecde4745</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g8c0698356b38310cd8ab9fd1fc31201b</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_intersection</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>ge94eececd60fb98c9d2c623652636335</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>ga1815d764666842a91559fcc950198b0</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_symmetric_difference</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g5eee81afa0e3d4bc2e78e703adbbfce9</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_union</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g333332f5caed16dcf39d570555fc3ab8</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>set_union</name>
      <anchorfile>a01730.html</anchorfile>
      <anchor>g72ce0dcba82855bc032533bb58945aac</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7b803e714e33404644d491f0a28c278c</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2964176c37d2035fd54c6132fd40f8cf</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>stable_partition</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6eb49f8bcc363fc55fb4959a8319ea5a</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Predicate __pred)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8a29d13ca15385eebc1599658e13b231</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stable_sort</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aab54bbc3b5dc432a1ccddfcbe6036b1</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2740a349ce9a6be03eed03b7d2a6ddf3</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _OutputIterator __result, _BinaryOperation __binary_op)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>transform</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3675111f707f27a8018c513505bc1866</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _UnaryOperation __unary_op)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>unique</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3fe802b68f03f7359bf1ae6378ed4731</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>unique</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5316b498da0025c06636e78ba8e49ef5</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>021f5d83bec38ab565bcddd6d1bffbb7</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>unique_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f4c6220061c4e712c1b3761006d071e8</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>upper_bound</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>gc9a8f86f411444b63ae23cb5113d3bcb</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>upper_bound</name>
      <anchorfile>a01729.html</anchorfile>
      <anchor>g113c17cd3be529043be13cf177006285</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__val)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_algobase.h</name>
    <filename>a01606</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__copy_move</class>
    <class kind="struct">std::__copy_move&lt; _IsMove, true, random_access_iterator_tag &gt;</class>
    <class kind="struct">std::__copy_move&lt; false, false, random_access_iterator_tag &gt;</class>
    <class kind="struct">std::__copy_move_backward</class>
    <class kind="struct">std::__copy_move_backward&lt; _IsMove, true, random_access_iterator_tag &gt;</class>
    <class kind="struct">std::__copy_move_backward&lt; false, false, random_access_iterator_tag &gt;</class>
    <class kind="struct">std::__equal</class>
    <class kind="struct">std::__equal&lt; true &gt;</class>
    <class kind="struct">std::__iter_swap</class>
    <class kind="struct">std::__iter_swap&lt; true &gt;</class>
    <class kind="struct">std::__lc_rai</class>
    <class kind="struct">std::__lc_rai&lt; random_access_iterator_tag, random_access_iterator_tag &gt;</class>
    <class kind="struct">std::__lexicographical_compare</class>
    <class kind="struct">std::__lexicographical_compare&lt; true &gt;</class>
    <class kind="struct">std::__miter_base</class>
    <class kind="struct">std::__miter_base&lt; _Iterator, true &gt;</class>
    <class kind="struct">std::__niter_base</class>
    <class kind="struct">std::__niter_base&lt; _Iterator, true &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MOVE3</name>
      <anchorfile>a01606.html</anchorfile>
      <anchor>96267ebf7fc7e9bd0a3f6c6b7d3624e7</anchor>
      <arglist>(_Tp, _Up, _Vp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MOVE_BACKWARD3</name>
      <anchorfile>a01606.html</anchorfile>
      <anchor>750614c077bc5d808d205747571ffc28</anchor>
      <arglist>(_Tp, _Up, _Vp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_STL_ALGOBASE_H</name>
      <anchorfile>a01606.html</anchorfile>
      <anchor>7271b5ed098cec285604fb1d4182d015</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_OI</type>
      <name>__copy_move_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b40000e062dbdb068470a051c4889db7</anchor>
      <arglist>(_II __first, _II __last, _OI __result)</arglist>
    </member>
    <member kind="function">
      <type>_OI</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8f85c2ac346e4de7c247c1d1cff945e0</anchor>
      <arglist>(_II __first, _II __last, _OI __result)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, _CharT * &gt;::__type</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>25e56156953e83085325bca83380722d</anchor>
      <arglist>(istreambuf_iterator&lt; _CharT, char_traits&lt; _CharT &gt; &gt;, istreambuf_iterator&lt; _CharT, char_traits&lt; _CharT &gt; &gt;, _CharT *)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, ostreambuf_iterator&lt; _CharT, char_traits&lt; _CharT &gt; &gt; &gt;::__type</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4751f881c4f52009d8b08437e9031f2f</anchor>
      <arglist>(const _CharT *, const _CharT *, ostreambuf_iterator&lt; _CharT, char_traits&lt; _CharT &gt; &gt;)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, ostreambuf_iterator&lt; _CharT, char_traits&lt; _CharT &gt; &gt; &gt;::__type</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>71f94668670401a3c7f19c75789d9ebe</anchor>
      <arglist>(_CharT *, _CharT *, ostreambuf_iterator&lt; _CharT, char_traits&lt; _CharT &gt; &gt;)</arglist>
    </member>
    <member kind="function">
      <type>_BI2</type>
      <name>__copy_move_backward_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cae43339f3762d6a3280592a103a782c</anchor>
      <arglist>(_BI1 __first, _BI1 __last, _BI2 __result)</arglist>
    </member>
    <member kind="function">
      <type>_BI2</type>
      <name>__copy_move_backward_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6db976f1d26cebf718c964914958364c</anchor>
      <arglist>(_BI1 __first, _BI1 __last, _BI2 __result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__equal_aux</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9df6d6a39e7631ae45fcd5f77979a2e4</anchor>
      <arglist>(_II1 __first1, _II1 __last1, _II2 __first2)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_byte&lt; _Tp &gt;::__value, void &gt;::__type</type>
      <name>__fill_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1da634080c838fe6ae90a79149783a89</anchor>
      <arglist>(_Tp *__first, _Tp *__last, _Tp __c)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_scalar&lt; _Tp &gt;::__value, void &gt;::__type</type>
      <name>__fill_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6286ccabc180ded75b4c94a7fd158d38</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Tp __value)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt;!__is_scalar&lt; _Tp &gt;::__value, void &gt;::__type</type>
      <name>__fill_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>93749ca0473d0fe81cebedb41d21ef9c</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_byte&lt; _Tp &gt;::__value, _Tp * &gt;::__type</type>
      <name>__fill_n_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d9af89cd306f74361edd067a2405d80d</anchor>
      <arglist>(_Tp *__first, _Size __n, _Tp __c)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_scalar&lt; _Tp &gt;::__value, _OutputIterator &gt;::__type</type>
      <name>__fill_n_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0fca607a0ae68118d8b9db781f0875e6</anchor>
      <arglist>(_OutputIterator __first, _Size __n, _Tp __value)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt;!__is_scalar&lt; _Tp &gt;::__value, _OutputIterator &gt;::__type</type>
      <name>__fill_n_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0d74d61111615fc84c15ba96ba5ba600</anchor>
      <arglist>(_OutputIterator __first, _Size __n, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__lexicographical_compare_aux</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>48060c97df34e535b07982668c8d2784</anchor>
      <arglist>(_II1 __first1, _II1 __last1, _II2 __first2, _II2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>_OI</type>
      <name>copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>61519dfdb5d51d95c5e79525a070d9a5</anchor>
      <arglist>(_II __first, _II __last, _OI __result)</arglist>
    </member>
    <member kind="function">
      <type>_BI2</type>
      <name>copy_backward</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e561277758830f7d6211580451548e1e</anchor>
      <arglist>(_BI1 __first, _BI1 __last, _BI2 __result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>77f3a3c6446c22d1383442333e1e8eab</anchor>
      <arglist>(_IIter1 __first1, _IIter1 __last1, _IIter2 __first2, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5eac7e856b713e313f23567cfd366226</anchor>
      <arglist>(_II1 __first1, _II1 __last1, _II2 __first2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>034f12ef9de3aeccff4349a80753d1af</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>_OI</type>
      <name>fill_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fcf321d76a154cfbd192f3cb7707d12f</anchor>
      <arglist>(_OI __first, _Size __n, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>iter_swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9dcd290632be563369e84e6b31ddc8f5</anchor>
      <arglist>(_ForwardIterator1 __a, _ForwardIterator2 __b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7209d1ac1f56cb11394c251391595c66</anchor>
      <arglist>(_II1 __first1, _II1 __last1, _II2 __first2, _II2 __last2, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lexicographical_compare</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f01c94f2a4cee6b86426a814cb4c3525</anchor>
      <arglist>(_II1 __first1, _II1 __last1, _II2 __first2, _II2 __last2)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>max</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a57f237cc8bca8e0f83eb79cdf826fd6</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>max</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0f121f0dee771e7ac8a254382021ccaf</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>min</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a30e5442eb3a6667b444a09935679805</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>const _Tp &amp;</type>
      <name>min</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0626578e4634db1d4175202deebaa330</anchor>
      <arglist>(const _Tp &amp;__a, const _Tp &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIterator1, _InputIterator2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5ad7bc4bcceccd165ada792cc4541c5e</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _BinaryPredicate __binary_pred)</arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _InputIterator1, _InputIterator2 &gt;</type>
      <name>mismatch</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dde0b8f19820615682b8f06da9a89444</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator2</type>
      <name>swap_ranges</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cf4e59c4c4a9bc0f82e0edb60198dbcf</anchor>
      <arglist>(_ForwardIterator1 __first1, _ForwardIterator1 __last1, _ForwardIterator2 __first2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_bvector.h</name>
    <filename>a01607</filename>
    <namespace>std</namespace>
    <class kind="struct">std::_Bit_const_iterator</class>
    <class kind="struct">std::_Bit_iterator</class>
    <class kind="struct">std::_Bit_iterator_base</class>
    <class kind="struct">std::_Bit_reference</class>
    <class kind="struct">std::_Bvector_base</class>
    <class kind="struct">std::_Bvector_base::_Bvector_impl</class>
    <class kind="class">std::vector&lt; bool, _Alloc &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_BVECTOR_H</name>
      <anchorfile>a01607.html</anchorfile>
      <anchor>e3d171f2e021cf5f9581c9099dfa388b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned long</type>
      <name>_Bit_type</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>078d179620c44185aa0d433a71f30332</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__fill_bvector</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ff6274ea1bb1b6925a39418e0052dcab</anchor>
      <arglist>(_Bit_iterator __first, _Bit_iterator __last, bool __x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5f3a4cd13e60843872df8228f0e0b919</anchor>
      <arglist>(_Bit_iterator __first, _Bit_iterator __last, const bool &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>_Bit_const_iterator</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>eae47dc8f2e6ff61abbab0744888556e</anchor>
      <arglist>(ptrdiff_t __n, const _Bit_const_iterator &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>_Bit_iterator</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a09076181b8ef2f9a6dd3c37c599060f</anchor>
      <arglist>(ptrdiff_t __n, const _Bit_iterator &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>ptrdiff_t</type>
      <name>operator-</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>add51fcbbfbbc0fafda2afc907eecfea</anchor>
      <arglist>(const _Bit_iterator_base &amp;__x, const _Bit_iterator_base &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_construct.h</name>
    <filename>a01608</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STL_CONSTRUCT_H</name>
      <anchorfile>a01608.html</anchorfile>
      <anchor>dfcf560dd48487f4d5c2c72daf9f3fb5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Construct</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7901967be0a1495722491063f7d2cb83</anchor>
      <arglist>(_T1 *__p, const _T2 &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Destroy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a9afa54ecdc0430683744f742aabc005</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Destroy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>101aee02b07f6e6c17392fe1eb912c76</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Destroy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6d96cbb307f9f1436fb912b29aacf932</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Destroy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9612fe335c1860eafcbc52e39741ab3b</anchor>
      <arglist>(_Tp *__pointer)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_deque.h</name>
    <filename>a01609</filename>
    <namespace>std</namespace>
    <class kind="class">std::_Deque_base</class>
    <class kind="struct">std::_Deque_base::_Deque_impl</class>
    <class kind="struct">std::_Deque_iterator</class>
    <class kind="class">std::deque</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_DEQUE_H</name>
      <anchorfile>a01609.html</anchorfile>
      <anchor>f348da4db9bcb8f25470ba9b18673fa3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>__deque_buf_size</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>78b7fa14f5faa0c097409e1379e399b4</anchor>
      <arglist>(size_t __size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9bfbce8baf0dbac17c1303ace0986d55</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Tp &amp;, _Tp * &gt; &amp;__first, const _Deque_iterator&lt; _Tp, _Tp &amp;, _Tp * &gt; &amp;__last, const _Tp &amp;__value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>77e60c1912aa0f23a95b57f58422f53c</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__x, const deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4a2be531974661b6d95b2106e6d038fa</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4cc29abe2c72ef3ce14e7fa39f8b6487</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>_Deque_iterator&lt; _Tp, _Ref, _Ptr &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b013bdee46576e1b1de1286fe8d938f6</anchor>
      <arglist>(ptrdiff_t __n, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>_Deque_iterator&lt; _Tp, _RefL, _PtrL &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>52cbd0240f1da4f516e851e5607de799</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>_Deque_iterator&lt; _Tp, _Ref, _Ptr &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>427b6d20ab412f6131d661262c81ead1</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>404bd23c29c9d4dbc1db050e230c806d</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__x, const deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f704ef0b934503b951375f1b2a4309b0</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d74cd4886fa8015075597df244d5ed2f</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7fe2564f7f61f19284474a65d3328e72</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__x, const deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>658e7a8ba4765fa7c9313a92008a92e9</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f62d987f67b700c21f7720d683d53216</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dd9d8f36292d2b8245102c42165dbe3e</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__x, const deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e22b636f0eb15246b6a615a98ed50d6c</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>623a245a4a16515198c8986adc257377</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1860b66536c184d93c3afcc6d254e705</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__x, const deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9c8a52aef5653badfec98edb661a9954</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6b9886873c42fbe1b648c961c645dd63</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1373658754d79f5fb081db2b60de9ae6</anchor>
      <arglist>(const deque&lt; _Tp, _Alloc &gt; &amp;__x, const deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9c20223fb559239e3c4cf1a1aa10aaae</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _RefL, _PtrL &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _RefR, _PtrR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ee069b6cfb96082255489fdeac2ffaee</anchor>
      <arglist>(const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__x, const _Deque_iterator&lt; _Tp, _Ref, _Ptr &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e8eb2e6914755339296fe300b8f9b30a</anchor>
      <arglist>(deque&lt; _Tp, _Alloc &gt; &amp;__x, deque&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_function.h</name>
    <filename>a01610</filename>
    <namespace>std</namespace>
    <class kind="struct">std::_Identity</class>
    <class kind="struct">std::_Select1st</class>
    <class kind="struct">std::_Select2nd</class>
    <class kind="struct">std::binary_function</class>
    <class kind="class">std::binary_negate</class>
    <class kind="struct">std::bit_and</class>
    <class kind="struct">std::bit_or</class>
    <class kind="struct">std::bit_xor</class>
    <class kind="class">std::const_mem_fun1_ref_t</class>
    <class kind="class">std::const_mem_fun1_t</class>
    <class kind="class">std::const_mem_fun_ref_t</class>
    <class kind="class">std::const_mem_fun_t</class>
    <class kind="struct">std::divides</class>
    <class kind="struct">std::equal_to</class>
    <class kind="struct">std::greater</class>
    <class kind="struct">std::greater_equal</class>
    <class kind="struct">std::less</class>
    <class kind="struct">std::less_equal</class>
    <class kind="struct">std::logical_and</class>
    <class kind="struct">std::logical_not</class>
    <class kind="struct">std::logical_or</class>
    <class kind="class">std::mem_fun1_ref_t</class>
    <class kind="class">std::mem_fun1_t</class>
    <class kind="class">std::mem_fun_ref_t</class>
    <class kind="class">std::mem_fun_t</class>
    <class kind="struct">std::minus</class>
    <class kind="struct">std::modulus</class>
    <class kind="struct">std::multiplies</class>
    <class kind="struct">std::negate</class>
    <class kind="struct">std::not_equal_to</class>
    <class kind="struct">std::plus</class>
    <class kind="class">std::pointer_to_binary_function</class>
    <class kind="class">std::pointer_to_unary_function</class>
    <class kind="struct">std::unary_function</class>
    <class kind="class">std::unary_negate</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_FUNCTION_H</name>
      <anchorfile>a01610.html</anchorfile>
      <anchor>7902ea3dc5922e0a72f229cb4359b6c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>mem_fun1_t&lt; _Ret, _Tp, _Arg &gt;</type>
      <name>mem_fun</name>
      <anchorfile>a01716.html</anchorfile>
      <anchor>g7237cf94f5bdc6f3490ae1d6dc68b11d</anchor>
      <arglist>(_Ret(_Tp::*__f)(_Arg))</arglist>
    </member>
    <member kind="function">
      <type>mem_fun_t&lt; _Ret, _Tp &gt;</type>
      <name>mem_fun</name>
      <anchorfile>a01716.html</anchorfile>
      <anchor>gbdc056f10f040a4a55450a2894de9338</anchor>
      <arglist>(_Ret(_Tp::*__f)())</arglist>
    </member>
    <member kind="function">
      <type>mem_fun1_ref_t&lt; _Ret, _Tp, _Arg &gt;</type>
      <name>mem_fun_ref</name>
      <anchorfile>a01716.html</anchorfile>
      <anchor>g0454e57c857ec33d44cb2707d1352d21</anchor>
      <arglist>(_Ret(_Tp::*__f)(_Arg))</arglist>
    </member>
    <member kind="function">
      <type>mem_fun_ref_t&lt; _Ret, _Tp &gt;</type>
      <name>mem_fun_ref</name>
      <anchorfile>a01716.html</anchorfile>
      <anchor>g78074457cd539e0a5d8fc7d55e106e7d</anchor>
      <arglist>(_Ret(_Tp::*__f)())</arglist>
    </member>
    <member kind="function">
      <type>unary_negate&lt; _Predicate &gt;</type>
      <name>not1</name>
      <anchorfile>a01714.html</anchorfile>
      <anchor>g377607e912faff5b422619110c956c89</anchor>
      <arglist>(const _Predicate &amp;__pred)</arglist>
    </member>
    <member kind="function">
      <type>binary_negate&lt; _Predicate &gt;</type>
      <name>not2</name>
      <anchorfile>a01714.html</anchorfile>
      <anchor>g12bcfdf859b9595e40378b1e4bfa339b</anchor>
      <arglist>(const _Predicate &amp;__pred)</arglist>
    </member>
    <member kind="function">
      <type>pointer_to_binary_function&lt; _Arg1, _Arg2, _Result &gt;</type>
      <name>ptr_fun</name>
      <anchorfile>a01715.html</anchorfile>
      <anchor>g72d3c1fd56fdcaeced35c7cb34f8a09d</anchor>
      <arglist>(_Result(*__x)(_Arg1, _Arg2))</arglist>
    </member>
    <member kind="function">
      <type>pointer_to_unary_function&lt; _Arg, _Result &gt;</type>
      <name>ptr_fun</name>
      <anchorfile>a01715.html</anchorfile>
      <anchor>gf0fb4e46ed7a75635b19187d2e1215e5</anchor>
      <arglist>(_Result(*__x)(_Arg))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_heap.h</name>
    <filename>a01611</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STL_HEAP_H</name>
      <anchorfile>a01611.html</anchorfile>
      <anchor>4328ee225ed4a40a067693b3c548cb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__adjust_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>db8e4fb98d8cf244f1b10adb7541c5b3</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __holeIndex, _Distance __len, _Tp __value, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__adjust_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2345412237121d9ed6fb0f919c0a5e91</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __holeIndex, _Distance __len, _Tp __value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__is_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b474befcf3bfbe1bebaf19e80f002366</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__is_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4beb67a1181b49c366311f853f1fd012</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__is_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9f543200d1fd2a1157fc42c7ae1ee650</anchor>
      <arglist>(_RandomAccessIterator __first, _Compare __comp, _Distance __n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__is_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8ea4814ee9d2a9865d40b57b4d2082f5</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __n)</arglist>
    </member>
    <member kind="function">
      <type>_Distance</type>
      <name>__is_heap_until</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>764ec27288c8b127004fc9e3fbb192bd</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __n, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>_Distance</type>
      <name>__is_heap_until</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a81c289b7fe279705c69973b5b795473</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__pop_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c2b7cfa3582f0eadc709e3b71b04a879</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _RandomAccessIterator __result, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__pop_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3f3df8fbc32fb5c6131be3e12ded91c9</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _RandomAccessIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__push_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>35dd447ef5a1df943e5592a19d5d9ef5</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __holeIndex, _Distance __topIndex, _Tp __value, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__push_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bfe31bb54e9e404ce4a7e02581c38339</anchor>
      <arglist>(_RandomAccessIterator __first, _Distance __holeIndex, _Distance __topIndex, _Tp __value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4b52102c418ba0ece72bdfc015baf638</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b014ed73e0ad5fd922b42769edf75482</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f8de9a7255e3c2482c92a9b4516b3d82</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>537f6edf685c91c2df2c3cf9353b18c5</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d61bcb57c96ff885dfe83b5dead0b899</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a4f55fcef27e0245f39915b4a99bebeb</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>274e8f1312a8c715d28097b6805ab908</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, _Compare __comp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort_heap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8559201e27b7f250b10f56e6b0325b80</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_iterator.h</name>
    <filename>a01612</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>std</namespace>
    <class kind="class">__gnu_cxx::__normal_iterator</class>
    <class kind="class">std::back_insert_iterator</class>
    <class kind="class">std::front_insert_iterator</class>
    <class kind="class">std::insert_iterator</class>
    <class kind="class">std::reverse_iterator</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MAKE_MOVE_ITERATOR</name>
      <anchorfile>a01612.html</anchorfile>
      <anchor>5718cb54ffd54311b89290d03a505288</anchor>
      <arglist>(_Iter)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_STL_ITERATOR_H</name>
      <anchorfile>a01612.html</anchorfile>
      <anchor>d75946ecae6bab94b4913a8a1189f314</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>back_insert_iterator&lt; _Container &gt;</type>
      <name>back_inserter</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3eb4e396543b071ce186a6339611c72b</anchor>
      <arglist>(_Container &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>front_insert_iterator&lt; _Container &gt;</type>
      <name>front_inserter</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4a151116974550e7454dba639d4ea39c</anchor>
      <arglist>(_Container &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>insert_iterator&lt; _Container &gt;</type>
      <name>inserter</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c5f09e35d5cc6a7f39c7a661fdcf5c7b</anchor>
      <arglist>(_Container &amp;__x, _Iterator __i)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>0fd1e01a4ad9d4e5926bb1bd4bef533b</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>e9626e8e8ea6e5e7f7d05ed5f16feead</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>__normal_iterator&lt; _Iterator, _Container &gt;</type>
      <name>operator+</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>fd1e0ef2e56b0d81b081baac0f29f94c</anchor>
      <arglist>(typename __normal_iterator&lt; _Iterator, _Container &gt;::difference_type __n, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__i)</arglist>
    </member>
    <member kind="function">
      <type>__normal_iterator&lt; _Iterator, _Container &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>43ec0b5299318166a15334ec22304ba9</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>__normal_iterator&lt; _IteratorL, _Container &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>2b6656de8676ca5ce2cd1201febd1c9c</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>899cd840e812fdfd63592110a4786ab3</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>cea8b08ef431b70cbf97e347105e0811</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ead884be2f77695ecbfcbe0a43990ea2</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>155feea64da2114a5bd8f966dac90a68</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>6d897c68e09162d0d667e333c3b83c5b</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>40b37a5d8c9ea9c86fa429a33a7bb7ca</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>ee63c3ba1631fb81596e62e1d39f667e</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>5082c7fd9eebc278a11d3281205c7e6b</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>44e60c514b4194d3a76430161a37c114</anchor>
      <arglist>(const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _Iterator, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>3b6de992cc1ecffb807c67ede701421d</anchor>
      <arglist>(const __normal_iterator&lt; _IteratorL, _Container &gt; &amp;__lhs, const __normal_iterator&lt; _IteratorR, _Container &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>36356e8df93f3a543f31a23fbf3e83f1</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f81154b284dadff140fc39d2d7b80335</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator&lt; _Iterator &gt;</type>
      <name>operator+</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>98189907d82a75f6f6307c8d352b41c2</anchor>
      <arglist>(typename reverse_iterator&lt; _Iterator &gt;::difference_type __n, const reverse_iterator&lt; _Iterator &gt; &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator&lt; _IteratorL &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>27a4f32465666095b6f419c8f0344632</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator&lt; _Iterator &gt;::difference_type</type>
      <name>operator-</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ba92dc5746293463bd2ff53afd965ddc</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6bfd02c51675e43dbac71c71debe9f0a</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b0a24300bff9949c9f189e49f9d91d5d</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>96e11a7adb08806d53d49a4be7efbee2</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b678f1f50c6e67b7897a16e2e4234d85</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1a07ebc72f02ba001addda85782c9c49</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2a69b34853ab64fb164c8b73e852d3b7</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3b832d5a42f8627c3712ee476f7ed00f</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1dedca703ed6e0b5ea2efe174d8f8e06</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4d46ec6ac46614d8e95dd4717e2fff00</anchor>
      <arglist>(const reverse_iterator&lt; _IteratorL &gt; &amp;__x, const reverse_iterator&lt; _IteratorR &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a945d69ff0c5768f1d290ae1f7adda7d</anchor>
      <arglist>(const reverse_iterator&lt; _Iterator &gt; &amp;__x, const reverse_iterator&lt; _Iterator &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_iterator_base_funcs.h</name>
    <filename>a01613</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STL_ITERATOR_BASE_FUNCS_H</name>
      <anchorfile>a01613.html</anchorfile>
      <anchor>1b7ed390664fe679aa13fb2463d9a91a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__advance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>724f0c31aff93ec6481e14a090461850</anchor>
      <arglist>(_RandomAccessIterator &amp;__i, _Distance __n, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__advance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c7fe23f8dc672e0f6f652ca4bb8ff87d</anchor>
      <arglist>(_BidirectionalIterator &amp;__i, _Distance __n, bidirectional_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__advance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>de56667d6e06fddaf398d9dd267b6184</anchor>
      <arglist>(_InputIterator &amp;__i, _Distance __n, input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _RandomAccessIterator &gt;::difference_type</type>
      <name>__distance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4d27e0015f5768f7b4efc2c2a25490c5</anchor>
      <arglist>(_RandomAccessIterator __first, _RandomAccessIterator __last, random_access_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _InputIterator &gt;::difference_type</type>
      <name>__distance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0d02ee0f0f5a3f18a683dd0ba24a8550</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, input_iterator_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>afef0506bacb687d86f7f2c7597f7164</anchor>
      <arglist>(_InputIterator &amp;__i, _Distance __n)</arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _InputIterator &gt;::difference_type</type>
      <name>distance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2f37fd86adc15ea61afd19b4e2c049ec</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_iterator_base_types.h</name>
    <filename>a01614</filename>
    <namespace>std</namespace>
    <class kind="struct">std::bidirectional_iterator_tag</class>
    <class kind="struct">std::forward_iterator_tag</class>
    <class kind="struct">std::input_iterator_tag</class>
    <class kind="struct">std::iterator</class>
    <class kind="struct">std::iterator_traits</class>
    <class kind="struct">std::iterator_traits&lt; _Tp * &gt;</class>
    <class kind="struct">std::iterator_traits&lt; const _Tp * &gt;</class>
    <class kind="struct">std::output_iterator_tag</class>
    <class kind="struct">std::random_access_iterator_tag</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_ITERATOR_BASE_TYPES_H</name>
      <anchorfile>a01614.html</anchorfile>
      <anchor>324ad22f8139b1800245f08624ccf4bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>iterator_traits&lt; _Iter &gt;::iterator_category</type>
      <name>__iterator_category</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bebc18da815eef459489aab98c5616b7</anchor>
      <arglist>(const _Iter &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_list.h</name>
    <filename>a01615</filename>
    <namespace>std</namespace>
    <class kind="class">std::_List_base</class>
    <class kind="struct">std::_List_base::_List_impl</class>
    <class kind="struct">std::_List_const_iterator</class>
    <class kind="struct">std::_List_iterator</class>
    <class kind="struct">std::_List_node</class>
    <class kind="struct">std::_List_node_base</class>
    <class kind="class">std::list</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_LIST_H</name>
      <anchorfile>a01615.html</anchorfile>
      <anchor>a94f1bb746d544dc198a77ccd43f0250</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b9854290e87fcc9d3a73d65b4a15ce21</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__x, const list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d7b4f0f5f6e901868f53934eab944c7c</anchor>
      <arglist>(const _List_iterator&lt; _Val &gt; &amp;__x, const _List_const_iterator&lt; _Val &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a061827da1036ee372e5477f79cc0c79</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__x, const list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>861ff9e145a6634992cb3239f736ac73</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__x, const list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>da1f96b794e870baa08e94d974735077</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__x, const list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>44c0c24556e32a8acc7ac178da5ab53c</anchor>
      <arglist>(const _List_iterator&lt; _Val &gt; &amp;__x, const _List_const_iterator&lt; _Val &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>26b1c7da3dd8dbcc6c6b542b4756fce2</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__x, const list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>47b8f1fe49de6ad4f6b2a215423e66cf</anchor>
      <arglist>(const list&lt; _Tp, _Alloc &gt; &amp;__x, const list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>46f7643e69a657380ddb22edf89ecf6c</anchor>
      <arglist>(list&lt; _Tp, _Alloc &gt; &amp;__x, list&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_map.h</name>
    <filename>a01616</filename>
    <namespace>std</namespace>
    <class kind="class">std::map</class>
    <class kind="class">std::map::value_compare</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_MAP_H</name>
      <anchorfile>a01616.html</anchorfile>
      <anchor>acde5420b947a3f482d139afcb0eb238</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f859955e7c5996f90a20f7f6c4c79475</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>019154ad9d7f71f31ec24e67bbf714ab</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>39aac96f6bde7c98839d537d2d0e416b</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2383a556d8b9a351ec56b393af95b1bb</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6c79a981fc2481b4c7494789d230f56a</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>24356da2dad5f445ac2e6f4a97e3bf7e</anchor>
      <arglist>(const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>16962b7edaab08d2c7f5068331054406</anchor>
      <arglist>(map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, map&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_move.h</name>
    <filename>a01617</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_MOVE</name>
      <anchorfile>a01617.html</anchorfile>
      <anchor>81729d0cbf6b558edb6c4837d9a3086f</anchor>
      <arglist>(_Tp)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_STL_MOVE_H</name>
      <anchorfile>a01617.html</anchorfile>
      <anchor>a8a77d396e21f91ecc9b7ed13c75a15b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c88287dd3555e345aeeddc0a767174d2</anchor>
      <arglist>(_Tp &amp;__a, _Tp &amp;__b)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_multimap.h</name>
    <filename>a01618</filename>
    <namespace>std</namespace>
    <class kind="class">std::multimap</class>
    <class kind="class">std::multimap::value_compare</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_MULTIMAP_H</name>
      <anchorfile>a01618.html</anchorfile>
      <anchor>18a170fc3fab26bf78c422f07fbd3c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9f5e64ddf2e4bd4d86b104ca2f7099e2</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f8ad1a2d6070eaf9621cef8d89b7704f</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bf0bbafc306921bc41060f1dd4f40c23</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b767cc6b9f78a2bf4ead72774b543970</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>82f09e9349789d8e4ce7c2684eb85b6a</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fcb1251214b199ce25f314161e6db576</anchor>
      <arglist>(const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, const multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dbfd0d22a0dd255e8caea721e05fd163</anchor>
      <arglist>(multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__x, multimap&lt; _Key, _Tp, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_multiset.h</name>
    <filename>a01619</filename>
    <namespace>std</namespace>
    <class kind="class">std::multiset</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_MULTISET_H</name>
      <anchorfile>a01619.html</anchorfile>
      <anchor>ba9ed0524001ffc90c2d01bb82fd993a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>97a89a7e59c38a040d749b17af558756</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b191f6a3b5c9e7e0ff7987c23cabd1fc</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2b11be8c4b4fd9e5b86c1bb409bb97aa</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ab339993429a0cbabe99f1738875209c</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>39cbf32a973e106eb40defd35588caa6</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3d053def1c34a32661d6b6e43b963965</anchor>
      <arglist>(const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f5e78978838d725b80f20c2defd62cbd</anchor>
      <arglist>(multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__x, multiset&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_numeric.h</name>
    <filename>a01620</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STL_NUMERIC_H</name>
      <anchorfile>a01620.html</anchorfile>
      <anchor>9007b530cc86f1b53de8413fcb2f52b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5a56b915d91b02eee2d3631f0ebcdfbb</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Tp __init, _BinaryOperation __binary_op)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>accumulate</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b10e4ca69b4b6cf84874a7e141aea746</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _Tp __init)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dfe60cd2b303ecc21efc78c01815351d</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _BinaryOperation __binary_op)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>adjacent_difference</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bc720bd4aae61230819ed7119e27382f</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a0407d9be66f9d5514739b74a3d4a535</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _Tp __init, _BinaryOperation1 __binary_op1, _BinaryOperation2 __binary_op2)</arglist>
    </member>
    <member kind="function">
      <type>_Tp</type>
      <name>inner_product</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6a7303e4ba622e0559e5a2f297dd4fc4</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _Tp __init)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>partial_sum</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b67f4c12016189e97e44cbb7f728efc3</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result, _BinaryOperation __binary_op)</arglist>
    </member>
    <member kind="function">
      <type>_OutputIterator</type>
      <name>partial_sum</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fe20d6b0f445c30a90277ed4caf83607</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _OutputIterator __result)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_pair.h</name>
    <filename>a01621</filename>
    <namespace>std</namespace>
    <class kind="struct">std::pair</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_PAIR_H</name>
      <anchorfile>a01621.html</anchorfile>
      <anchor>92c1065d430266a5f245906164f147f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _T1, _T2 &gt;</type>
      <name>make_pair</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>1703f64655c8b7d80023e1d99b2c8ba7</anchor>
      <arglist>(_T1 __x, _T2 __y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>af2cef5efac801aa8dd0118f1484daa2</anchor>
      <arglist>(const pair&lt; _T1, _T2 &gt; &amp;__x, const pair&lt; _T1, _T2 &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>018ce126263993dd65445ed17bba6d7d</anchor>
      <arglist>(const pair&lt; _T1, _T2 &gt; &amp;__x, const pair&lt; _T1, _T2 &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>56dfc5dc1c51c266f9a1e24ea1e362e4</anchor>
      <arglist>(const pair&lt; _T1, _T2 &gt; &amp;__x, const pair&lt; _T1, _T2 &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>be559cb49f37f5cea26d4c8ab133401b</anchor>
      <arglist>(const pair&lt; _T1, _T2 &gt; &amp;__x, const pair&lt; _T1, _T2 &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4f1e7efc37ff9ca9feeb428ff68add5a</anchor>
      <arglist>(const pair&lt; _T1, _T2 &gt; &amp;__x, const pair&lt; _T1, _T2 &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e57188f08215175fbaa485582397303d</anchor>
      <arglist>(const pair&lt; _T1, _T2 &gt; &amp;__x, const pair&lt; _T1, _T2 &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_queue.h</name>
    <filename>a01622</filename>
    <namespace>std</namespace>
    <class kind="class">std::priority_queue</class>
    <class kind="class">std::queue</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_QUEUE_H</name>
      <anchorfile>a01622.html</anchorfile>
      <anchor>43918e52003e2b844e10c42fa7bf6b63</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bb6354e44fa845dd18d14ffb6ec2cb88</anchor>
      <arglist>(const queue&lt; _Tp, _Seq &gt; &amp;__x, const queue&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>72aa0d37bd1c5ab4bd4de8ee6c56368b</anchor>
      <arglist>(const queue&lt; _Tp, _Seq &gt; &amp;__x, const queue&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5344e7e040278f2ca330d899bf62c4d9</anchor>
      <arglist>(const queue&lt; _Tp, _Seq &gt; &amp;__x, const queue&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b74b1098817ca5540f003239395a5cda</anchor>
      <arglist>(const queue&lt; _Tp, _Seq &gt; &amp;__x, const queue&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e715e271c40d0a6b0fe54b2bb32fcbb7</anchor>
      <arglist>(const queue&lt; _Tp, _Seq &gt; &amp;__x, const queue&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>93a6be6feaeecd5f8da591251f4bcdca</anchor>
      <arglist>(const queue&lt; _Tp, _Seq &gt; &amp;__x, const queue&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_raw_storage_iter.h</name>
    <filename>a01623</filename>
    <namespace>std</namespace>
    <class kind="class">std::raw_storage_iterator</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_RAW_STORAGE_ITERATOR_H</name>
      <anchorfile>a01623.html</anchorfile>
      <anchor>855eddad54ef40f642502844ab7ac201</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_relops.h</name>
    <filename>a01624</filename>
    <namespace>std</namespace>
    <namespace>std::rel_ops</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STL_RELOPS_H</name>
      <anchorfile>a01624.html</anchorfile>
      <anchor>fa5674e044e42b1f2e0e3530c2fd3841</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01705.html</anchorfile>
      <anchor>902d5ecc3f54584d430901d3db99fb53</anchor>
      <arglist>(const _Tp &amp;__x, const _Tp &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01705.html</anchorfile>
      <anchor>026fdad7d5af27252f5117436596ad3f</anchor>
      <arglist>(const _Tp &amp;__x, const _Tp &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01705.html</anchorfile>
      <anchor>521b957faf9531b33b28f0772426ca8f</anchor>
      <arglist>(const _Tp &amp;__x, const _Tp &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01705.html</anchorfile>
      <anchor>ddbd47caabad444c501cbc28f84b4c10</anchor>
      <arglist>(const _Tp &amp;__x, const _Tp &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_set.h</name>
    <filename>a01625</filename>
    <namespace>std</namespace>
    <class kind="class">std::set</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_SET_H</name>
      <anchorfile>a01625.html</anchorfile>
      <anchor>8ce95fcf2b4d8626fee89fd86aac4c78</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>90176e088006b821f70da4b73e208070</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>44d762ad5d57732ff71f987c68d9471c</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>798fe29023d9001f11ae17b0c7a55f29</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c02a0b899e7f4376d8dc9fb03794a730</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>58f7c53b602713b6c232130f347da2b2</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b6d35c092cf210ecb670919d478cb33f</anchor>
      <arglist>(const set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, const set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4233186ea990e12bb32b58d71ca2f22c</anchor>
      <arglist>(set&lt; _Key, _Compare, _Alloc &gt; &amp;__x, set&lt; _Key, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_stack.h</name>
    <filename>a01626</filename>
    <namespace>std</namespace>
    <class kind="class">std::stack</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_STACK_H</name>
      <anchorfile>a01626.html</anchorfile>
      <anchor>1d65c78bdf06261ee32bd0472b52621f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>338dba6499cb1c3fefcf69f027f9ee78</anchor>
      <arglist>(const stack&lt; _Tp, _Seq &gt; &amp;__x, const stack&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>db4c62243927958156ec374d1191c510</anchor>
      <arglist>(const stack&lt; _Tp, _Seq &gt; &amp;__x, const stack&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3031c4f685e32c4fd7a966dff82ff075</anchor>
      <arglist>(const stack&lt; _Tp, _Seq &gt; &amp;__x, const stack&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ee7dbc298da082c5d65403bd96a98889</anchor>
      <arglist>(const stack&lt; _Tp, _Seq &gt; &amp;__x, const stack&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>abb4414770ded1d1dd387109c0c2adaf</anchor>
      <arglist>(const stack&lt; _Tp, _Seq &gt; &amp;__x, const stack&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>9aa9e33b42e14f33438596ecdf7f08a1</anchor>
      <arglist>(const stack&lt; _Tp, _Seq &gt; &amp;__x, const stack&lt; _Tp, _Seq &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_tempbuf.h</name>
    <filename>a01627</filename>
    <namespace>std</namespace>
    <class kind="class">std::_Temporary_buffer</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_TEMPBUF_H</name>
      <anchorfile>a01627.html</anchorfile>
      <anchor>64aaf317d489344da0c440790367e098</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>pair&lt; _Tp *, ptrdiff_t &gt;</type>
      <name>get_temporary_buffer</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>462c10f8371116491c5158da3f556ee7</anchor>
      <arglist>(ptrdiff_t __len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>return_temporary_buffer</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3f8af6552c0023f9ff5b4d8005ef4e4a</anchor>
      <arglist>(_Tp *__p)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_tree.h</name>
    <filename>a01628</filename>
    <namespace>std</namespace>
    <class kind="class">std::_Rb_tree</class>
    <class kind="struct">std::_Rb_tree::_Rb_tree_impl</class>
    <class kind="struct">std::_Rb_tree_const_iterator</class>
    <class kind="struct">std::_Rb_tree_iterator</class>
    <class kind="struct">std::_Rb_tree_node</class>
    <class kind="struct">std::_Rb_tree_node_base</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_TREE_H</name>
      <anchorfile>a01628.html</anchorfile>
      <anchor>53a6bede245f977aae2ba45b2bd71bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Rb_tree_color</name>
      <anchor>76828d01ca752fa99c166d9ce4b0fa25</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>_Rb_tree_black_count</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8f25ec1c7ca69eb656b7f30ba7aa3d61</anchor>
      <arglist>(const _Rb_tree_node_base *__node, const _Rb_tree_node_base *__root)</arglist>
    </member>
    <member kind="function">
      <type>const _Rb_tree_node_base *</type>
      <name>_Rb_tree_decrement</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>88f2792864983eaec7911e2cdd823a14</anchor>
      <arglist>(const _Rb_tree_node_base *__x)</arglist>
    </member>
    <member kind="function">
      <type>_Rb_tree_node_base *</type>
      <name>_Rb_tree_decrement</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>154889b4139b8b052382a510cba5e91c</anchor>
      <arglist>(_Rb_tree_node_base *__x)</arglist>
    </member>
    <member kind="function">
      <type>const _Rb_tree_node_base *</type>
      <name>_Rb_tree_increment</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>32c452b9485a6492234db4c43f618631</anchor>
      <arglist>(const _Rb_tree_node_base *__x)</arglist>
    </member>
    <member kind="function">
      <type>_Rb_tree_node_base *</type>
      <name>_Rb_tree_increment</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>307d849f199660eb0232adaca7092c44</anchor>
      <arglist>(_Rb_tree_node_base *__x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_Rb_tree_insert_and_rebalance</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6ca64002ebfe8443f5f05a0798ddd351</anchor>
      <arglist>(const bool __insert_left, _Rb_tree_node_base *__x, _Rb_tree_node_base *__p, _Rb_tree_node_base &amp;__header)</arglist>
    </member>
    <member kind="function">
      <type>_Rb_tree_node_base *</type>
      <name>_Rb_tree_rebalance_for_erase</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d629e5c154916b858f27afe96d4a5052</anchor>
      <arglist>(_Rb_tree_node_base *const __z, _Rb_tree_node_base &amp;__header)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3ce359d85ea4d84370eca0f1c6e56012</anchor>
      <arglist>(const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>21dfd59129f3889035c1bd0948d1b923</anchor>
      <arglist>(const _Rb_tree_iterator&lt; _Val &gt; &amp;__x, const _Rb_tree_const_iterator&lt; _Val &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6eea148b775908d37085503babbf69c2</anchor>
      <arglist>(const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>08a3dd90f3f1f1b2e0ebbf03120d7c85</anchor>
      <arglist>(const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dfbc9a97e5ca77f1bc541f32e3f6a6bc</anchor>
      <arglist>(const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>294b5f18dd1dcfa305cae8dfef11f558</anchor>
      <arglist>(const _Rb_tree_iterator&lt; _Val &gt; &amp;__x, const _Rb_tree_const_iterator&lt; _Val &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>335744f8b1dddb3d3e92675e68b32727</anchor>
      <arglist>(const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>84a3f3ce1c420befd740b4927673fe20</anchor>
      <arglist>(const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, const _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bdb3d7f877f0a1162e450a266fc45044</anchor>
      <arglist>(_Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__x, _Rb_tree&lt; _Key, _Val, _KeyOfValue, _Compare, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_uninitialized.h</name>
    <filename>a01629</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__uninitialized_copy</class>
    <class kind="struct">std::__uninitialized_copy&lt; true &gt;</class>
    <class kind="struct">std::__uninitialized_fill</class>
    <class kind="struct">std::__uninitialized_fill&lt; true &gt;</class>
    <class kind="struct">std::__uninitialized_fill_n</class>
    <class kind="struct">std::__uninitialized_fill_n&lt; true &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_UNINITIALIZED_H</name>
      <anchorfile>a01629.html</anchorfile>
      <anchor>76f56b6dffa42047045e11b231141172</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__uninitialized_copy_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a225293d0205331b63799842f1a54003</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _ForwardIterator __result, allocator&lt; _Tp &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__uninitialized_copy_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c8e63a7d3591e014522ce22e25bd56f4</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _ForwardIterator __result, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__uninitialized_copy_move</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7c1b05fd265d3500b24de0a14bf9ff30</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _ForwardIterator __result, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__uninitialized_fill_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>54eba8023f7f56f3d1cf87cde93aa203</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__x, allocator&lt; _Tp2 &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__uninitialized_fill_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e23c6d152d5a00907ab4759a6fa1111c</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__x, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__uninitialized_fill_move</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>28dae623c612ba4e3077ff60f376af39</anchor>
      <arglist>(_ForwardIterator __result, _ForwardIterator __mid, const _Tp &amp;__x, _InputIterator __first, _InputIterator __last, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__uninitialized_fill_n_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fb4ccb251a5f5ea6eda816a1ebaa9e1b</anchor>
      <arglist>(_ForwardIterator __first, _Size __n, const _Tp &amp;__x, allocator&lt; _Tp2 &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__uninitialized_fill_n_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ad9b9dc0e7a53c8dcbef6feeb69111d2</anchor>
      <arglist>(_ForwardIterator __first, _Size __n, const _Tp &amp;__x, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__uninitialized_move_a</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a6016fee7364a9754346870745f030e9</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _ForwardIterator __result, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>__uninitialized_move_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>68e0a69bc4eda2ae234473755476d492</anchor>
      <arglist>(_InputIterator1 __first1, _InputIterator1 __last1, _InputIterator2 __first2, _InputIterator2 __last2, _ForwardIterator __result, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__uninitialized_move_fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a6f53375fb5fa885dc7ed659a4cb2fb7</anchor>
      <arglist>(_InputIterator __first1, _InputIterator __last1, _ForwardIterator __first2, _ForwardIterator __last2, const _Tp &amp;__x, _Allocator &amp;__alloc)</arglist>
    </member>
    <member kind="function">
      <type>_ForwardIterator</type>
      <name>uninitialized_copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e4747285d905a13bcc832228a2687ede</anchor>
      <arglist>(_InputIterator __first, _InputIterator __last, _ForwardIterator __result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>uninitialized_fill</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bcfbd05829b10b7f3aee4d6377685880</anchor>
      <arglist>(_ForwardIterator __first, _ForwardIterator __last, const _Tp &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>uninitialized_fill_n</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bfd80fec6cee49745059ce301abe90b1</anchor>
      <arglist>(_ForwardIterator __first, _Size __n, const _Tp &amp;__x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stl_vector.h</name>
    <filename>a01630</filename>
    <namespace>std</namespace>
    <class kind="struct">std::_Vector_base</class>
    <class kind="struct">std::_Vector_base::_Vector_impl</class>
    <class kind="class">std::vector</class>
    <member kind="define">
      <type>#define</type>
      <name>_STL_VECTOR_H</name>
      <anchorfile>a01630.html</anchorfile>
      <anchor>703a3f27bf287ae329d686a870690528</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0786eace7408b668dfe744df7935d8de</anchor>
      <arglist>(const vector&lt; _Tp, _Alloc &gt; &amp;__x, const vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e6649ccc166d52af9a2077650eee2dec</anchor>
      <arglist>(const vector&lt; _Tp, _Alloc &gt; &amp;__x, const vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>64489592e3e00e28d2f31653fd1d6557</anchor>
      <arglist>(const vector&lt; _Tp, _Alloc &gt; &amp;__x, const vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>35cdf36a9c31ff31d7a0f0fccd4040c0</anchor>
      <arglist>(const vector&lt; _Tp, _Alloc &gt; &amp;__x, const vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>70b8c1dd34e25dde3f5ba6525e5daee3</anchor>
      <arglist>(const vector&lt; _Tp, _Alloc &gt; &amp;__x, const vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6009b58a5ab18ca54557699387024270</anchor>
      <arglist>(const vector&lt; _Tp, _Alloc &gt; &amp;__x, const vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>70398c1c6d6592c28a19d5fae724bfd0</anchor>
      <arglist>(vector&lt; _Tp, _Alloc &gt; &amp;__x, vector&lt; _Tp, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stream_iterator.h</name>
    <filename>a01631</filename>
    <namespace>std</namespace>
    <class kind="class">std::istream_iterator</class>
    <class kind="class">std::ostream_iterator</class>
    <member kind="define">
      <type>#define</type>
      <name>_STREAM_ITERATOR_H</name>
      <anchorfile>a01631.html</anchorfile>
      <anchor>9cc8ad709e147ef3f82e02e16ea78998</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6d8f958a3dc43ea46a7212048953dd58</anchor>
      <arglist>(const istream_iterator&lt; _Tp, _CharT, _Traits, _Dist &gt; &amp;__x, const istream_iterator&lt; _Tp, _CharT, _Traits, _Dist &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a06deadcd392bfb4c57e2bc0b2bf24e3</anchor>
      <arglist>(const istream_iterator&lt; _Tp, _CharT, _Traits, _Dist &gt; &amp;__x, const istream_iterator&lt; _Tp, _CharT, _Traits, _Dist &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>streambuf</name>
    <filename>a01632</filename>
    <namespace>std</namespace>
    <class kind="class">std::basic_streambuf</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBXX_STREAMBUF</name>
      <anchorfile>a01632.html</anchorfile>
      <anchor>bfad8c302de172bb6d6567e7a55c23d1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>streamsize</type>
      <name>__copy_streambufs_eof</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>31c3caa4f9c014c7d6d203f057256911</anchor>
      <arglist>(basic_streambuf&lt; wchar_t &gt; *__sbin, basic_streambuf&lt; wchar_t &gt; *__sbout, bool &amp;__ineof)</arglist>
    </member>
    <member kind="function">
      <type>streamsize</type>
      <name>__copy_streambufs_eof</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dc43000cf30c6d64b9483dc09e6ede82</anchor>
      <arglist>(basic_streambuf&lt; char &gt; *__sbin, basic_streambuf&lt; char &gt; *__sbout, bool &amp;__ineof)</arglist>
    </member>
    <member kind="function">
      <type>streamsize</type>
      <name>__copy_streambufs_eof</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>610c26e1f837bde8df0d88ae30974898</anchor>
      <arglist>(basic_streambuf&lt; _CharT, _Traits &gt; *, basic_streambuf&lt; _CharT, _Traits &gt; *, bool &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>streambuf.tcc</name>
    <filename>a01633</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STREAMBUF_TCC</name>
      <anchorfile>a01633.html</anchorfile>
      <anchor>aa86bd3819b2a2619675565b6eb4a2d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>streamsize</type>
      <name>__copy_streambufs</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>3e2e6af4d2d8d7bd90d7001cc7f47c3c</anchor>
      <arglist>(basic_streambuf&lt; _CharT, _Traits &gt; *__sbin, basic_streambuf&lt; _CharT, _Traits &gt; *__sbout)</arglist>
    </member>
    <member kind="function">
      <type>streamsize</type>
      <name>__copy_streambufs_eof</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>610c26e1f837bde8df0d88ae30974898</anchor>
      <arglist>(basic_streambuf&lt; _CharT, _Traits &gt; *, basic_streambuf&lt; _CharT, _Traits &gt; *, bool &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>streambuf_iterator.h</name>
    <filename>a01634</filename>
    <namespace>std</namespace>
    <class kind="class">std::istreambuf_iterator</class>
    <class kind="class">std::ostreambuf_iterator</class>
    <member kind="define">
      <type>#define</type>
      <name>_STREAMBUF_ITERATOR_H</name>
      <anchorfile>a01634.html</anchorfile>
      <anchor>aad41dd7bedd3393ce1833bc8804cb3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, _CharT * &gt;::__type</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>46bc660e406d56cac1709694b3d64e63</anchor>
      <arglist>(istreambuf_iterator&lt; _CharT &gt; __first, istreambuf_iterator&lt; _CharT &gt; __last, _CharT *__result)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, ostreambuf_iterator&lt; _CharT &gt; &gt;::__type</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ebdd35929dfe25644e096fbdd76d5b1d</anchor>
      <arglist>(const _CharT *__first, const _CharT *__last, ostreambuf_iterator&lt; _CharT &gt; __result)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, ostreambuf_iterator&lt; _CharT &gt; &gt;::__type</type>
      <name>__copy_move_a2</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6d4df487068769ed272921b7a83a0067</anchor>
      <arglist>(_CharT *__first, _CharT *__last, ostreambuf_iterator&lt; _CharT &gt; __result)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, ostreambuf_iterator&lt; _CharT &gt; &gt;::__type</type>
      <name>copy</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>5161f56c8316d3e5f5818c9ce3e73708</anchor>
      <arglist>(istreambuf_iterator&lt; _CharT &gt; __first, istreambuf_iterator&lt; _CharT &gt; __last, ostreambuf_iterator&lt; _CharT &gt; __result)</arglist>
    </member>
    <member kind="function">
      <type>__gnu_cxx::__enable_if&lt; __is_char&lt; _CharT &gt;::__value, istreambuf_iterator&lt; _CharT &gt; &gt;::__type</type>
      <name>find</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6a9629c88b5d21a63ba93b0bbeb9473f</anchor>
      <arglist>(istreambuf_iterator&lt; _CharT &gt; __first, istreambuf_iterator&lt; _CharT &gt; __last, const _CharT &amp;__val)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>047d1dbedb22957edc6ce831e7723285</anchor>
      <arglist>(const istreambuf_iterator&lt; _CharT, _Traits &gt; &amp;__a, const istreambuf_iterator&lt; _CharT, _Traits &gt; &amp;__b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e048bc6499c9029edf653f4559f2483a</anchor>
      <arglist>(const istreambuf_iterator&lt; _CharT, _Traits &gt; &amp;__a, const istreambuf_iterator&lt; _CharT, _Traits &gt; &amp;__b)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>string</name>
    <filename>a01635</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STRING</name>
      <anchorfile>a01635.html</anchorfile>
      <anchor>c137cdb13610fd5494ae2c1970c5d011</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/string</name>
    <filename>a01636</filename>
    <namespace>__gnu_debug</namespace>
    <class kind="class">__gnu_debug::basic_string</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_STRING</name>
      <anchorfile>a01636.html</anchorfile>
      <anchor>7ef375244577545de563f28d35210a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_string&lt; char &gt;</type>
      <name>string</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ca84459ba4a06bd1a96f70c2cd94e83c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_string&lt; wchar_t &gt;</type>
      <name>wstring</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>bd2582b547781b440d4ee7b8e14de587</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>4670304439075a79e2b63079325c36fe</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>getline</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>6ff82d151a564936c43228296dd82f07</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__str, _CharT __delim)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>be3bedd068d5599873f6b1670d11490f</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>cc5d149fbb4fbcc30ab63a029b76373b</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>e070551018996124e5a77fd65d156b92</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Allocator &gt;</type>
      <name>operator+</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>5049b951f95fbf5588e56c21d1090856</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, _CharT __rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Allocator &gt;</type>
      <name>operator+</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>72c95f1692803984f599d05026af4af5</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Allocator &gt;</type>
      <name>operator+</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>f6c773cd30b1e99b685d29289d07b910</anchor>
      <arglist>(_CharT __lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Allocator &gt;</type>
      <name>operator+</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>acd78b9ee4308eb027ad5ffec78c6721</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>basic_string&lt; _CharT, _Traits, _Allocator &gt;</type>
      <name>operator+</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>5e0f0a49f62df1b7e5bee832e8908507</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>62683e38d602de46de149cfbe6b53b18</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>f98e4416d8c9c2bed2eb0dc27b9b315a</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>c98ae16e7516a29b50f0d76b9570a0cd</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_ostream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>139e17dce0a8cd4c7380caa82c2afb91</anchor>
      <arglist>(std::basic_ostream&lt; _CharT, _Traits &gt; &amp;__os, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>67e8d51f4c9486222d2f55ba803aa0be</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>8ce49f71be668596d2e8db4732e2b851</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>1b68dc85af1e56c5150b5b252d8b9506</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>5a9a1d9e1b29d2f2be5c3e6c4dd7d8a9</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>ddd3f280050d821b08a698278bf8a567</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>02b77b2c5c6ff68d85fc470e69c3738c</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>3c8f5e92c07982fb33268d0d5b5c0a85</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>4cda5b2e6ac1e6f3bb78f26eb0c9d490</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>aa28d3b8048824d71a00009850df4996</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>cdfc37127630aed9cb4c00d20b1c822d</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const _CharT *__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>a17284b74d56901d27b5e0c6150f604d</anchor>
      <arglist>(const _CharT *__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>a256bde784122a546604535960d98693</anchor>
      <arglist>(const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, const basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::basic_istream&lt; _CharT, _Traits &gt; &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>80943a92bd7f879f14c5abe980363fe8</anchor>
      <arglist>(std::basic_istream&lt; _CharT, _Traits &gt; &amp;__is, basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01690.html</anchorfile>
      <anchor>f13748ef87baf482400735d2d5a899ab</anchor>
      <arglist>(basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__lhs, basic_string&lt; _CharT, _Traits, _Allocator &gt; &amp;__rhs)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>stringfwd.h</name>
    <filename>a01637</filename>
    <namespace>std</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_STRINGFWD_H</name>
      <anchorfile>a01637.html</anchorfile>
      <anchor>fcdf9523bf3c5d8a7361cd43290865bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_string&lt; char &gt;</type>
      <name>string</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a431813f68fa8a80ea10ea2ad21066a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_string&lt; wchar_t &gt;</type>
      <name>wstring</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>55bb71d9c231e315d523fec09fe5f538</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tag_and_trait.hpp</name>
    <filename>a01639</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="struct">__gnu_pbds::associative_container_tag</class>
    <class kind="struct">__gnu_pbds::basic_hash_tag</class>
    <class kind="struct">__gnu_pbds::basic_invalidation_guarantee</class>
    <class kind="struct">__gnu_pbds::basic_tree_tag</class>
    <class kind="struct">__gnu_pbds::binary_heap_tag</class>
    <class kind="struct">__gnu_pbds::binomial_heap_tag</class>
    <class kind="struct">__gnu_pbds::cc_hash_tag</class>
    <class kind="struct">__gnu_pbds::container_tag</class>
    <class kind="struct">__gnu_pbds::container_traits</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; binary_heap_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; binomial_heap_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; cc_hash_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; gp_hash_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; list_update_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; ov_tree_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; pairing_heap_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; pat_trie_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; rb_tree_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; rc_binomial_heap_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; splay_tree_tag &gt;</class>
    <class kind="struct">__gnu_pbds::container_traits_base&lt; thin_heap_tag &gt;</class>
    <class kind="struct">__gnu_pbds::gp_hash_tag</class>
    <class kind="struct">__gnu_pbds::list_update_tag</class>
    <class kind="struct">__gnu_pbds::null_mapped_type</class>
    <class kind="struct">__gnu_pbds::ov_tree_tag</class>
    <class kind="struct">__gnu_pbds::pairing_heap_tag</class>
    <class kind="struct">__gnu_pbds::pat_trie_tag</class>
    <class kind="struct">__gnu_pbds::point_invalidation_guarantee</class>
    <class kind="struct">__gnu_pbds::priority_queue_tag</class>
    <class kind="struct">__gnu_pbds::range_invalidation_guarantee</class>
    <class kind="struct">__gnu_pbds::rb_tree_tag</class>
    <class kind="struct">__gnu_pbds::rc_binomial_heap_tag</class>
    <class kind="struct">__gnu_pbds::splay_tree_tag</class>
    <class kind="struct">__gnu_pbds::thin_heap_tag</class>
    <class kind="struct">__gnu_pbds::tree_tag</class>
    <class kind="struct">__gnu_pbds::trie_tag</class>
    <class kind="struct">__gnu_pbds::trivial_iterator_tag</class>
    <member kind="typedef">
      <type>void</type>
      <name>trivial_iterator_difference_type</name>
      <anchorfile>a01693.html</anchorfile>
      <anchor>885c58b590300cc52d7369c0f6b93b11</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tags.h</name>
    <filename>a01640</filename>
    <namespace>__gnu_parallel</namespace>
    <class kind="struct">__gnu_parallel::balanced_tag</class>
    <class kind="struct">__gnu_parallel::constant_size_blocks_tag</class>
    <class kind="struct">__gnu_parallel::equal_split_tag</class>
    <class kind="struct">__gnu_parallel::find_tag</class>
    <class kind="struct">__gnu_parallel::growing_blocks_tag</class>
    <class kind="struct">__gnu_parallel::omp_loop_static_tag</class>
    <class kind="struct">__gnu_parallel::omp_loop_tag</class>
    <class kind="struct">__gnu_parallel::parallel_tag</class>
    <class kind="struct">__gnu_parallel::sequential_tag</class>
    <class kind="struct">__gnu_parallel::unbalanced_tag</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_TAGS_H</name>
      <anchorfile>a01640.html</anchorfile>
      <anchor>84adddf2588afe9c7889bc89b2d9c853</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tgmath.h</name>
    <filename>a01641</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_TGMATH_H</name>
      <anchorfile>a01641.html</anchorfile>
      <anchor>01b6af033aabb238364df7f114d47b2b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>throw_allocator.h</name>
    <filename>a01642</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::forced_exception_error</class>
    <class kind="class">__gnu_cxx::throw_allocator</class>
    <class kind="struct">__gnu_cxx::throw_allocator::rebind</class>
    <class kind="class">__gnu_cxx::throw_allocator_base</class>
    <class kind="struct">__gnu_cxx::throw_allocator_base::group_throw_prob_adjustor</class>
    <class kind="struct">__gnu_cxx::throw_allocator_base::zero_throw_prob_adjustor</class>
    <class kind="class">__gnu_cxx::twister_rand_gen</class>
    <member kind="define">
      <type>#define</type>
      <name>_THROW_ALLOCATOR_H</name>
      <anchorfile>a01642.html</anchorfile>
      <anchor>d5d822075efd95e1a8a84517d908068f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>__throw_forced_exception_error</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>611064b821504fde8bc04ab5bf1866cf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>509b35fa80771b6c9bdb66bde8c72c99</anchor>
      <arglist>(const throw_allocator&lt; T &gt; &amp;, const throw_allocator&lt; T &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>7322c74f5a06928ebedcc369f4f46f90</anchor>
      <arglist>(std::ostream &amp;os, const throw_allocator_base &amp;alloc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>9ee2f1fa08b038f339dbd71fd61870c0</anchor>
      <arglist>(const throw_allocator&lt; T &gt; &amp;, const throw_allocator&lt; T &gt; &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>time_members.h</name>
    <filename>a01643</filename>
    <namespace>std</namespace>
  </compound>
  <compound kind="file">
    <name>tree_policy.hpp</name>
    <filename>a01644</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="struct">__gnu_pbds::null_tree_node_update</class>
    <class kind="class">__gnu_pbds::tree_order_statistics_node_update</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01644.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01644.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01644.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tree_trace_base.hpp</name>
    <filename>a01645</filename>
  </compound>
  <compound kind="file">
    <name>trie_policy.hpp</name>
    <filename>a01646</filename>
    <namespace>__gnu_pbds</namespace>
    <class kind="struct">__gnu_pbds::null_trie_node_update</class>
    <class kind="struct">__gnu_pbds::string_trie_e_access_traits</class>
    <class kind="class">__gnu_pbds::trie_order_statistics_node_update</class>
    <class kind="class">__gnu_pbds::trie_prefix_search_node_update</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_BASE_C_DEC</name>
      <anchorfile>a01646.html</anchorfile>
      <anchor>82cafb865f28e7bc013fdfa9adf85c23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01646.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01646.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_C_DEC</name>
      <anchorfile>a01646.html</anchorfile>
      <anchor>83c85af873c7273e4e662f29d8f7bbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01646.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_CLASS_T_DEC</name>
      <anchorfile>a01646.html</anchorfile>
      <anchor>0822d336342652d6869270a09a0cf8db</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tuple</name>
    <filename>a01647</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__add_c_ref</class>
    <class kind="struct">std::__add_c_ref&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::__add_ref</class>
    <class kind="struct">std::__add_ref&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::__index_holder</class>
    <class kind="struct">std::__index_holder_impl&lt; __i, __index_holder&lt; _Indexes...&gt; &gt;</class>
    <class kind="struct">std::__index_holder_impl&lt; __i, __index_holder&lt; _Indexes...&gt;, _IdxHolder, _Elements...&gt;</class>
    <class kind="struct">std::__make_index_holder</class>
    <class kind="struct">std::__tuple_compare&lt; 0, __i, __i, _Tp, _Up &gt;</class>
    <class kind="struct">std::__tuple_compare&lt; 0, __i, __j, _Tp, _Up &gt;</class>
    <class kind="struct">std::_Head_base&lt; _Idx, _Head, false &gt;</class>
    <class kind="struct">std::_Head_base&lt; _Idx, _Head, true &gt;</class>
    <class kind="struct">std::_Swallow_assign</class>
    <class kind="struct">std::_Tuple_impl&lt; _Idx &gt;</class>
    <class kind="struct">std::_Tuple_impl&lt; _Idx, _Head, _Tail...&gt;</class>
    <class kind="class">std::tuple</class>
    <class kind="class">std::tuple&lt; _T1, _T2 &gt;</class>
    <class kind="class">std::tuple&lt;&gt;</class>
    <class kind="struct">std::tuple_element&lt; 0, tuple&lt; _Head, _Tail...&gt; &gt;</class>
    <class kind="struct">std::tuple_element&lt; __i, tuple&lt; _Head, _Tail...&gt; &gt;</class>
    <class kind="struct">std::tuple_size&lt; tuple&lt; _Elements...&gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX0X_TUPLE</name>
      <anchorfile>a01647.html</anchorfile>
      <anchor>38104be3beecae4acfb83c45ef20f8ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>__add_c_ref&lt; _Head &gt;::type</type>
      <name>__get_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>912bcbc5aac21d7a3ba41c00928e338a</anchor>
      <arglist>(const _Tuple_impl&lt; __i, _Head, _Tail...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>__add_ref&lt; _Head &gt;::type</type>
      <name>__get_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c184fb4fe47847ce860761ec216b35e6</anchor>
      <arglist>(_Tuple_impl&lt; __i, _Head, _Tail...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>__tuple_cat_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>390545bc279f1c2006150a147e9aba2a</anchor>
      <arglist>(tuple&lt; _TElements...&gt; &amp;&amp;__t, const __index_holder&lt; _TIdx...&gt; &amp;, tuple&lt; _UElements...&gt; &amp;&amp;__u, const __index_holder&lt; _UIdx...&gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>__tuple_cat_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>f3f3f6553ada84a85a1bdcbd2056f644</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const __index_holder&lt; _TIdx...&gt; &amp;, tuple&lt; _UElements...&gt; &amp;&amp;__u, const __index_holder&lt; _UIdx...&gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>__tuple_cat_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>50bf4d3ad6afd172325cfd32fed2a5d5</anchor>
      <arglist>(tuple&lt; _TElements...&gt; &amp;&amp;__t, const __index_holder&lt; _TIdx...&gt; &amp;, const tuple&lt; _UElements...&gt; &amp;__u, const __index_holder&lt; _UIdx...&gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>__tuple_cat_helper</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8a27c3860fbc62acb4039be9bd97756d</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const __index_holder&lt; _TIdx...&gt; &amp;, const tuple&lt; _UElements...&gt; &amp;__u, const __index_holder&lt; _UIdx...&gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>__add_c_ref&lt; typename tuple_element&lt; __i, tuple&lt; _Elements...&gt; &gt;::type &gt;::type</type>
      <name>get</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>eee59a0c77ff71e99540955933b346e6</anchor>
      <arglist>(const tuple&lt; _Elements...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>__add_ref&lt; typename tuple_element&lt; __i, tuple&lt; _Elements...&gt; &gt;::type &gt;::type</type>
      <name>get</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>8477400ce8ba334a7c1bb58bb2246d91</anchor>
      <arglist>(tuple&lt; _Elements...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; typename __decay_and_strip&lt; _Elements &gt;::__type...&gt;</type>
      <name>make_tuple</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dde8590c6b49967060c456734ff7622d</anchor>
      <arglist>(_Elements &amp;&amp;...__args)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>c17528e9bff455fe214b6af00e1ff66b</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4be907a20a875458c531dc857eb8d447</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>a049fe2200f097db2d9ed31844a12479</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b22e61d7e7f061c6318975fbb53f0953</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e1256565b697136cfb835572b10f0e09</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7ec4fff9e3ccba0969b4d27469a68e1e</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _Elements &amp;...&gt;</type>
      <name>tie</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2690abd59cdb0a40f190100aa53f883a</anchor>
      <arglist>(_Elements &amp;...__args)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>tuple_cat</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>115b1a0ba365d8ac925aecff6fd55605</anchor>
      <arglist>(tuple&lt; _TElements...&gt; &amp;&amp;__t, tuple&lt; _UElements...&gt; &amp;&amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>tuple_cat</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>dfc72f55f2866f06ee5c5774c651cd81</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, tuple&lt; _UElements...&gt; &amp;&amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>tuple_cat</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b013d807bef3f41ac676a2efda379012</anchor>
      <arglist>(tuple&lt; _TElements...&gt; &amp;&amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _TElements..., _UElements...&gt;</type>
      <name>tuple_cat</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>4071a4427b142b7b9b7d4ee20cf67474</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Swallow_assign</type>
      <name>ignore</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2efa7a8f632b5f73df9ea4a8062b4c28</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/tuple</name>
    <filename>a01648</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <class kind="struct">std::tr1::__add_c_ref</class>
    <class kind="struct">std::tr1::__add_c_ref&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::tr1::__add_ref</class>
    <class kind="struct">std::tr1::__add_ref&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::tr1::__strip_reference_wrapper</class>
    <class kind="struct">std::tr1::__strip_reference_wrapper&lt; const reference_wrapper&lt; _Tp &gt; &gt;</class>
    <class kind="struct">std::tr1::__strip_reference_wrapper&lt; reference_wrapper&lt; _Tp &gt; &gt;</class>
    <class kind="struct">std::tr1::__tuple_compare&lt; 0, __i, __i, _Tp, _Up &gt;</class>
    <class kind="struct">std::tr1::__tuple_compare&lt; 0, __i, __j, _Tp, _Up &gt;</class>
    <class kind="struct">std::tr1::_Swallow_assign</class>
    <class kind="struct">std::tr1::_Tuple_impl&lt; _Idx &gt;</class>
    <class kind="struct">std::tr1::_Tuple_impl&lt; _Idx, _Head, _Tail...&gt;</class>
    <class kind="class">std::tr1::tuple</class>
    <class kind="class">std::tr1::tuple&lt; _T1, _T2 &gt;</class>
    <class kind="class">std::tr1::tuple&lt;&gt;</class>
    <class kind="struct">std::tr1::tuple_element&lt; 0, tuple&lt; _Head, _Tail...&gt; &gt;</class>
    <class kind="struct">std::tr1::tuple_element&lt; __i, tuple&lt; _Head, _Tail...&gt; &gt;</class>
    <class kind="struct">std::tr1::tuple_size&lt; tuple&lt; _Elements...&gt; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_TUPLE</name>
      <anchorfile>a01648.html</anchorfile>
      <anchor>6e489fb826b64dbef36343a70019cb58</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>__add_c_ref&lt; _Head &gt;::type</type>
      <name>__get_helper</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>27ee022257c3beb5e407deec18ccd21e</anchor>
      <arglist>(const _Tuple_impl&lt; __i, _Head, _Tail...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>__add_ref&lt; _Head &gt;::type</type>
      <name>__get_helper</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>7aa53d7792a9801978ee86feebe11952</anchor>
      <arglist>(_Tuple_impl&lt; __i, _Head, _Tail...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>__add_c_ref&lt; typename tuple_element&lt; __i, tuple&lt; _Elements...&gt; &gt;::type &gt;::type</type>
      <name>get</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>f4370f08d45e828d9936107e9ca36d8e</anchor>
      <arglist>(const tuple&lt; _Elements...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>__add_ref&lt; typename tuple_element&lt; __i, tuple&lt; _Elements...&gt; &gt;::type &gt;::type</type>
      <name>get</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>ffcde01a4ef9a1c5f6b12cf8aef1ecb1</anchor>
      <arglist>(tuple&lt; _Elements...&gt; &amp;__t)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; typename __strip_reference_wrapper&lt; _Elements &gt;::__type...&gt;</type>
      <name>make_tuple</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>23617550f61c53e07c7c5719cdfde155</anchor>
      <arglist>(_Elements...__args)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>e4d8d3d8184fa25001a84b0b6add6e8a</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>675b7b485827fb4a8031af853eb56709</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>561a7773e61dca0dace54619ba4660c9</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>0ad31997ee785d82ad1e1daf37d0b826</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>0b32a2bb683354c17a6fa96e457ee636</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>55b0ecda47300dcf3d6e594c2a307c41</anchor>
      <arglist>(const tuple&lt; _TElements...&gt; &amp;__t, const tuple&lt; _UElements...&gt; &amp;__u)</arglist>
    </member>
    <member kind="function">
      <type>tuple&lt; _Elements &amp;...&gt;</type>
      <name>tie</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>39156089b5a1256ffc280239a1a30c3a</anchor>
      <arglist>(_Elements &amp;...__args)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>_Swallow_assign</type>
      <name>ignore</name>
      <anchorfile>a01706.html</anchorfile>
      <anchor>09778a6641b2b462bfe4ed8bcda76f07</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>type_traits</name>
    <filename>a01649</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__add_lvalue_reference_helper</class>
    <class kind="struct">std::__add_lvalue_reference_helper&lt; _Tp, false, true &gt;</class>
    <class kind="struct">std::__add_lvalue_reference_helper&lt; _Tp, true, false &gt;</class>
    <class kind="struct">std::__add_rvalue_reference_helper</class>
    <class kind="struct">std::__add_rvalue_reference_helper&lt; _Tp, true &gt;</class>
    <class kind="struct">std::__is_signed_helper</class>
    <class kind="struct">std::__is_signed_helper&lt; _Tp, false, true &gt;</class>
    <class kind="struct">std::add_lvalue_reference</class>
    <class kind="struct">std::add_rvalue_reference</class>
    <class kind="struct">std::is_lvalue_reference</class>
    <class kind="struct">std::is_lvalue_reference&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::is_reference</class>
    <class kind="struct">std::is_rvalue_reference</class>
    <class kind="struct">std::is_rvalue_reference&lt; _Tp &amp;&amp; &gt;</class>
    <class kind="struct">std::remove_reference</class>
    <class kind="struct">std::remove_reference&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::remove_reference&lt; _Tp &amp;&amp; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_CXX0X_TYPE_TRAITS</name>
      <anchorfile>a01649.html</anchorfile>
      <anchor>a1f2934cacd01fb867791413d05abfef</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/type_traits</name>
    <filename>a01650</filename>
    <namespace>std</namespace>
    <namespace>std::tr1</namespace>
    <class kind="struct">std::tr1::__add_reference_helper</class>
    <class kind="struct">std::tr1::__add_reference_helper&lt; _Tp, true &gt;</class>
    <class kind="struct">std::tr1::__is_base_of_helper</class>
    <class kind="struct">std::tr1::__is_convertible_helper</class>
    <class kind="struct">std::tr1::__is_convertible_helper&lt; _From, _To, true &gt;</class>
    <class kind="struct">std::tr1::__is_convertible_simple</class>
    <class kind="struct">std::tr1::__is_int_or_cref</class>
    <class kind="struct">std::tr1::add_reference</class>
    <class kind="struct">std::tr1::aligned_storage</class>
    <class kind="union">std::tr1::aligned_storage::type</class>
    <class kind="struct">std::tr1::has_nothrow_assign</class>
    <class kind="struct">std::tr1::has_nothrow_constructor</class>
    <class kind="struct">std::tr1::has_nothrow_copy</class>
    <class kind="struct">std::tr1::has_trivial_assign</class>
    <class kind="struct">std::tr1::has_trivial_constructor</class>
    <class kind="struct">std::tr1::has_trivial_copy</class>
    <class kind="struct">std::tr1::has_trivial_destructor</class>
    <class kind="struct">std::tr1::is_base_of</class>
    <class kind="struct">std::tr1::is_convertible</class>
    <class kind="struct">std::tr1::is_pod</class>
    <class kind="struct">std::tr1::is_reference</class>
    <class kind="struct">std::tr1::is_reference&lt; _Tp &amp; &gt;</class>
    <class kind="struct">std::tr1::is_signed</class>
    <class kind="struct">std::tr1::is_signed&lt; int &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; intconst &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; intconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; intvolatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; long &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; long long &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; long longconst &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; long longconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; long longvolatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; longconst &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; longconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; longvolatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; short &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; shortconst  &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; shortconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; shortvolatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; signed char &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; signed charconst &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; signed charconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_signed&lt; signed charvolatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned char &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned charconst  &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned charconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned charvolatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned int &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned intconst &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned intconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned intvolatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned long &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned long long &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned long longconst &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned long longconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned long longvolatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned longconst  &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned longconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned longvolatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned short &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned shortconst &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned shortconst volatile &gt;</class>
    <class kind="struct">std::tr1::is_unsigned&lt; unsigned shortvolatile &gt;</class>
    <class kind="struct">std::tr1::remove_reference</class>
    <class kind="struct">std::tr1::remove_reference&lt; _Tp &amp; &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>f02de3eafa503dbcafc7b677605e3e0f</anchor>
      <arglist>(_Trait, _Type)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC_HELPER</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>4655b8bae8f1170e83270747f805a09f</anchor>
      <arglist>(_Spec)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_TYPE_TRAITS</name>
      <anchorfile>a01650.html</anchorfile>
      <anchor>b321ff23b07dfc1d251b81501cbd99c4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/type_traits</name>
    <filename>a01651</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__in_array</class>
    <class kind="struct">std::__sfinae_types</class>
    <class kind="struct">std::__sfinae_types::__two</class>
    <class kind="struct">std::add_const</class>
    <class kind="struct">std::add_cv</class>
    <class kind="struct">std::add_pointer</class>
    <class kind="struct">std::add_volatile</class>
    <class kind="struct">std::alignment_of</class>
    <class kind="struct">std::extent</class>
    <class kind="struct">std::extent&lt; _Tp[], _Uint &gt;</class>
    <class kind="struct">std::extent&lt; _Tp[_Size], _Uint &gt;</class>
    <class kind="struct">std::has_virtual_destructor</class>
    <class kind="struct">std::integral_constant</class>
    <class kind="struct">std::is_abstract</class>
    <class kind="struct">std::is_arithmetic</class>
    <class kind="struct">std::is_array</class>
    <class kind="struct">std::is_array&lt; _Tp[]&gt;</class>
    <class kind="struct">std::is_array&lt; _Tp[_Size]&gt;</class>
    <class kind="struct">std::is_class</class>
    <class kind="struct">std::is_compound</class>
    <class kind="struct">std::is_const</class>
    <class kind="struct">std::is_const&lt; _Tp const  &gt;</class>
    <class kind="struct">std::is_empty</class>
    <class kind="struct">std::is_enum</class>
    <class kind="struct">std::is_floating_point</class>
    <class kind="struct">std::is_floating_point&lt; double &gt;</class>
    <class kind="struct">std::is_floating_point&lt; doubleconst &gt;</class>
    <class kind="struct">std::is_floating_point&lt; doubleconst volatile &gt;</class>
    <class kind="struct">std::is_floating_point&lt; doublevolatile &gt;</class>
    <class kind="struct">std::is_floating_point&lt; float &gt;</class>
    <class kind="struct">std::is_floating_point&lt; floatconst &gt;</class>
    <class kind="struct">std::is_floating_point&lt; floatconst volatile &gt;</class>
    <class kind="struct">std::is_floating_point&lt; floatvolatile &gt;</class>
    <class kind="struct">std::is_floating_point&lt; long double &gt;</class>
    <class kind="struct">std::is_floating_point&lt; long doubleconst &gt;</class>
    <class kind="struct">std::is_floating_point&lt; long doubleconst volatile &gt;</class>
    <class kind="struct">std::is_floating_point&lt; long doublevolatile &gt;</class>
    <class kind="struct">std::is_function</class>
    <class kind="struct">std::is_fundamental</class>
    <class kind="struct">std::is_integral</class>
    <class kind="struct">std::is_integral&lt; bool &gt;</class>
    <class kind="struct">std::is_integral&lt; boolconst &gt;</class>
    <class kind="struct">std::is_integral&lt; boolconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; boolvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; char &gt;</class>
    <class kind="struct">std::is_integral&lt; charconst &gt;</class>
    <class kind="struct">std::is_integral&lt; charconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; charvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; int &gt;</class>
    <class kind="struct">std::is_integral&lt; intconst &gt;</class>
    <class kind="struct">std::is_integral&lt; intconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; intvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; long &gt;</class>
    <class kind="struct">std::is_integral&lt; long long &gt;</class>
    <class kind="struct">std::is_integral&lt; long longconst  &gt;</class>
    <class kind="struct">std::is_integral&lt; long longconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; long longvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; longconst &gt;</class>
    <class kind="struct">std::is_integral&lt; longconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; longvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; short &gt;</class>
    <class kind="struct">std::is_integral&lt; shortconst &gt;</class>
    <class kind="struct">std::is_integral&lt; shortconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; shortvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; signed char &gt;</class>
    <class kind="struct">std::is_integral&lt; signed charconst &gt;</class>
    <class kind="struct">std::is_integral&lt; signed charconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; signed charvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned char &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned charconst &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned charconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned charvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned int &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned intconst &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned intconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned intvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned long &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned long long &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned long longconst  &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned long longconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned long longvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned longconst &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned longconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned longvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned short &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned shortconst &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned shortconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; unsigned shortvolatile &gt;</class>
    <class kind="struct">std::is_integral&lt; wchar_t &gt;</class>
    <class kind="struct">std::is_integral&lt; wchar_tconst &gt;</class>
    <class kind="struct">std::is_integral&lt; wchar_tconst volatile &gt;</class>
    <class kind="struct">std::is_integral&lt; wchar_tvolatile &gt;</class>
    <class kind="struct">std::is_member_function_pointer</class>
    <class kind="struct">std::is_member_function_pointer&lt; _Tp _Cp::* &gt;</class>
    <class kind="struct">std::is_member_function_pointer&lt; _Tp _Cp::*const &gt;</class>
    <class kind="struct">std::is_member_function_pointer&lt; _Tp _Cp::*const volatile &gt;</class>
    <class kind="struct">std::is_member_function_pointer&lt; _Tp _Cp::*volatile &gt;</class>
    <class kind="struct">std::is_member_object_pointer</class>
    <class kind="struct">std::is_member_object_pointer&lt; _Tp _Cp::* &gt;</class>
    <class kind="struct">std::is_member_object_pointer&lt; _Tp _Cp::*const &gt;</class>
    <class kind="struct">std::is_member_object_pointer&lt; _Tp _Cp::*const volatile &gt;</class>
    <class kind="struct">std::is_member_object_pointer&lt; _Tp _Cp::*volatile &gt;</class>
    <class kind="struct">std::is_member_pointer</class>
    <class kind="struct">std::is_object</class>
    <class kind="struct">std::is_pointer</class>
    <class kind="struct">std::is_pointer&lt; _Tp * &gt;</class>
    <class kind="struct">std::is_pointer&lt; _Tp *const &gt;</class>
    <class kind="struct">std::is_pointer&lt; _Tp *const volatile &gt;</class>
    <class kind="struct">std::is_pointer&lt; _Tp *volatile &gt;</class>
    <class kind="struct">std::is_polymorphic</class>
    <class kind="struct">std::is_same</class>
    <class kind="struct">std::is_same&lt; _Tp, _Tp &gt;</class>
    <class kind="struct">std::is_scalar</class>
    <class kind="struct">std::is_union</class>
    <class kind="struct">std::is_void</class>
    <class kind="struct">std::is_void&lt; void &gt;</class>
    <class kind="struct">std::is_void&lt; voidconst  &gt;</class>
    <class kind="struct">std::is_void&lt; voidconst volatile &gt;</class>
    <class kind="struct">std::is_void&lt; voidvolatile &gt;</class>
    <class kind="struct">std::is_volatile</class>
    <class kind="struct">std::is_volatile&lt; _Tp volatile &gt;</class>
    <class kind="struct">std::rank</class>
    <class kind="struct">std::rank&lt; _Tp[]&gt;</class>
    <class kind="struct">std::rank&lt; _Tp[_Size]&gt;</class>
    <class kind="struct">std::remove_all_extents</class>
    <class kind="struct">std::remove_all_extents&lt; _Tp[]&gt;</class>
    <class kind="struct">std::remove_all_extents&lt; _Tp[_Size]&gt;</class>
    <class kind="struct">std::remove_const</class>
    <class kind="struct">std::remove_const&lt; _Tp const &gt;</class>
    <class kind="struct">std::remove_cv</class>
    <class kind="struct">std::remove_extent</class>
    <class kind="struct">std::remove_extent&lt; _Tp[]&gt;</class>
    <class kind="struct">std::remove_extent&lt; _Tp[_Size]&gt;</class>
    <class kind="struct">std::remove_pointer</class>
    <class kind="struct">std::remove_pointer&lt; _Tp * &gt;</class>
    <class kind="struct">std::remove_pointer&lt; _Tp *const  &gt;</class>
    <class kind="struct">std::remove_pointer&lt; _Tp *const volatile &gt;</class>
    <class kind="struct">std::remove_pointer&lt; _Tp *volatile &gt;</class>
    <class kind="struct">std::remove_volatile</class>
    <class kind="struct">std::remove_volatile&lt; _Tp volatile &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC</name>
      <anchorfile>a01651.html</anchorfile>
      <anchor>c9bc416a3f44667d9af8fb56c3e9e4f0</anchor>
      <arglist>(_Order, _Trait, _Type, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC_0_HELPER</name>
      <anchorfile>a01651.html</anchorfile>
      <anchor>4a72338fa0b55edef991e299ff6efb5b</anchor>
      <arglist>(_Spec, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC_1_HELPER</name>
      <anchorfile>a01651.html</anchorfile>
      <anchor>403905a467f6e407f198540aefee5c08</anchor>
      <arglist>(_Spec, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC_2_HELPER</name>
      <anchorfile>a01651.html</anchorfile>
      <anchor>1178be59acd4c70ffdce12054125e7be</anchor>
      <arglist>(_Spec, _Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC_BODY</name>
      <anchorfile>a01651.html</anchorfile>
      <anchor>fb0be6010c4ccc37200dd2e0e73cca99</anchor>
      <arglist>(_Value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_SPEC_BODY</name>
      <anchorfile>a01651.html</anchorfile>
      <anchor>fb0be6010c4ccc37200dd2e0e73cca99</anchor>
      <arglist>(_Value)</arglist>
    </member>
    <member kind="typedef">
      <type>integral_constant&lt; bool, false &gt;</type>
      <name>false_type</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>712bd6fda941d784ce0c1e432c03b2c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>integral_constant&lt; bool, true &gt;</type>
      <name>true_type</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>27acb0c35a2d0b5de29d6d0452dc73a0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>type_traits.h</name>
    <filename>a01652</filename>
    <namespace>__gnu_cxx</namespace>
    <class kind="struct">__gnu_cxx::__add_unsigned</class>
    <class kind="struct">__gnu_cxx::__add_unsigned&lt; char &gt;</class>
    <class kind="struct">__gnu_cxx::__add_unsigned&lt; int &gt;</class>
    <class kind="struct">__gnu_cxx::__add_unsigned&lt; long &gt;</class>
    <class kind="struct">__gnu_cxx::__add_unsigned&lt; long long &gt;</class>
    <class kind="struct">__gnu_cxx::__add_unsigned&lt; short &gt;</class>
    <class kind="struct">__gnu_cxx::__add_unsigned&lt; signed char &gt;</class>
    <class kind="struct">__gnu_cxx::__conditional_type</class>
    <class kind="struct">__gnu_cxx::__conditional_type&lt; false, _Iftrue, _Iffalse &gt;</class>
    <class kind="struct">__gnu_cxx::__enable_if</class>
    <class kind="struct">__gnu_cxx::__enable_if&lt; true, _Tp &gt;</class>
    <class kind="struct">__gnu_cxx::__promote</class>
    <class kind="struct">__gnu_cxx::__promote&lt; _Tp, false &gt;</class>
    <class kind="struct">__gnu_cxx::__promote_2</class>
    <class kind="struct">__gnu_cxx::__promote_3</class>
    <class kind="struct">__gnu_cxx::__promote_4</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned&lt; char &gt;</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned&lt; unsigned char &gt;</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned&lt; unsigned int &gt;</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned&lt; unsigned long &gt;</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned&lt; unsigned long long &gt;</class>
    <class kind="struct">__gnu_cxx::__remove_unsigned&lt; unsigned short &gt;</class>
    <member kind="define">
      <type>#define</type>
      <name>_EXT_TYPE_TRAITS</name>
      <anchorfile>a01652.html</anchorfile>
      <anchor>2592ddf35e9c14e3dcc93f94a53cbe1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__is_null_pointer</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c623c7faba1568c72c1a747a7cc1ebf5</anchor>
      <arglist>(_Type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>__is_null_pointer</name>
      <anchorfile>a01686.html</anchorfile>
      <anchor>c5a0d954e53de9b37e61366d917c3e71</anchor>
      <arglist>(_Type *__ptr)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>type_utils.hpp</name>
    <filename>a01653</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="struct">__gnu_pbds::detail::__static_assert&lt; true &gt;</class>
    <class kind="struct">__gnu_pbds::detail::__static_assert_dumclass</class>
    <class kind="struct">__gnu_pbds::detail::is_const_pointer</class>
    <class kind="struct">__gnu_pbds::detail::is_const_reference</class>
    <class kind="class">__gnu_pbds::detail::is_pair</class>
    <class kind="struct">__gnu_pbds::detail::is_simple</class>
    <class kind="struct">__gnu_pbds::detail::type_to_type</class>
    <member kind="define">
      <type>#define</type>
      <name>PB_DS_STATIC_ASSERT</name>
      <anchorfile>a01653.html</anchorfile>
      <anchor>8b7ddb03a3a1cf23a8fa6811ccbf32ba</anchor>
      <arglist>(UNIQUE, E)</arglist>
    </member>
    <member kind="typedef">
      <type>std::tr1::integral_constant&lt; int, 0 &gt;</type>
      <name>false_type</name>
      <anchorfile>a01694.html</anchorfile>
      <anchor>7ec09224d74dbb3ab2bce2fdfcc45c87</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::tr1::integral_constant&lt; int, 1 &gt;</type>
      <name>true_type</name>
      <anchorfile>a01694.html</anchorfile>
      <anchor>9a2f183f924d7bbb702e827e71591db6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>typeinfo</name>
    <filename>a01654</filename>
    <namespace>__cxxabiv1</namespace>
    <namespace>std</namespace>
    <class kind="class">std::bad_cast</class>
    <class kind="class">std::bad_typeid</class>
    <class kind="class">std::type_info</class>
    <member kind="define">
      <type>#define</type>
      <name>__GXX_MERGED_TYPEINFO_NAMES</name>
      <anchorfile>a01654.html</anchorfile>
      <anchor>68b75fe0a43b49db22246b94bfb20c46</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>__GXX_TYPEINFO_EQUALITY_INLINE</name>
      <anchorfile>a01654.html</anchorfile>
      <anchor>0d1957a85e7a5b2226721dd04693954b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>typelist.h</name>
    <filename>a01655</filename>
    <namespace>__gnu_cxx</namespace>
    <namespace>__gnu_cxx::typelist</namespace>
    <namespace>__gnu_cxx::typelist::detail</namespace>
    <class kind="struct">__gnu_cxx::typelist::append</class>
    <class kind="struct">__gnu_cxx::typelist::append_typelist</class>
    <class kind="struct">__gnu_cxx::typelist::at_index</class>
    <class kind="struct">__gnu_cxx::typelist::chain</class>
    <class kind="struct">__gnu_cxx::typelist::contains</class>
    <class kind="struct">__gnu_cxx::typelist::create1</class>
    <class kind="struct">__gnu_cxx::typelist::create2</class>
    <class kind="struct">__gnu_cxx::typelist::create3</class>
    <class kind="struct">__gnu_cxx::typelist::create4</class>
    <class kind="struct">__gnu_cxx::typelist::create5</class>
    <class kind="struct">__gnu_cxx::typelist::create6</class>
    <class kind="struct">__gnu_cxx::typelist::detail::append_&lt; chain&lt; Hd, Tl &gt;, Typelist_Chain &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::append_&lt; null_type, null_type &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::append_&lt; null_type, Typelist_Chain &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::append_&lt; Typelist_Chain, null_type &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::append_typelist_&lt; chain&lt; Hd, null_type &gt; &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::append_typelist_&lt; chain&lt; Hd, Tl &gt; &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::apply_&lt; Fn, chain&lt; Hd, Tl &gt; &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::apply_&lt; Fn, null_type &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_at_index_&lt; chain&lt; Hd, Tl &gt;, 0 &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_at_index_&lt; chain&lt; Hd, Tl &gt;, i &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_filter_&lt; chain&lt; Hd, Tl &gt;, Pred &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_filter_&lt; null_type, Pred &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_flatten_&lt; chain&lt; Hd_Tl, null_type &gt; &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_flatten_&lt; chain&lt; Hd_Typelist, Tl_Typelist &gt; &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_transform_&lt; chain&lt; Hd, Tl &gt;, Transform &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::chain_transform_&lt; null_type, Transform &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::contains_&lt; chain&lt; Hd, Tl &gt;, T &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::contains_&lt; chain&lt; T, Tl &gt;, T &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::detail::contains_&lt; null_type, T &gt;</class>
    <class kind="struct">__gnu_cxx::typelist::filter</class>
    <class kind="struct">__gnu_cxx::typelist::flatten</class>
    <class kind="struct">__gnu_cxx::typelist::from_first</class>
    <class kind="struct">__gnu_cxx::typelist::node</class>
    <class kind="struct">__gnu_cxx::typelist::null_type</class>
    <class kind="struct">__gnu_cxx::typelist::transform</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN1</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>b92bd592dfc3b6ff6b55357f80c1493b</anchor>
      <arglist>(X0)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN10</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>3d4f67f656f8655e7fa2aad9909a321b</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8, X9)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN11</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>a1ca45c80a1ad37c25d762c1f223a64c</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8, X9, X10)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN12</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>7daf345ce8a26084d3a03a90aeb9e71e</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN13</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>7f86f2d2404a54e98ed370d3fb54a26c</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN14</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>d88a49ad08e3f418847f01c884ef6de4</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12, X13)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN15</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>a2387e149a0ee6ce445d478eebb7e9f7</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12, X13, X14)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN2</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>36d2ef89f7bcbb9801341ac1ee5ef226</anchor>
      <arglist>(X0, X1)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN3</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>271fcbfcda0fac1417cafb79268a765d</anchor>
      <arglist>(X0, X1, X2)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN4</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>d43c99ead62cc9de7341d8efc460003c</anchor>
      <arglist>(X0, X1, X2, X3)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN5</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>680a44ead73c68d446e7e85cada8ec6e</anchor>
      <arglist>(X0, X1, X2, X3, X4)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN6</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>e482aa09822326458475713b569426b5</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN7</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>5222e2e3132d0ba4d27d5b7302cfb96c</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN8</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>5d6f1f0adff46fe2bcd52f1e82d3eba0</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TYPELIST_CHAIN9</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>e218b032ffed98071eab726a5847f7b7</anchor>
      <arglist>(X0, X1, X2, X3, X4, X5, X6, X7, X8)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_TYPELIST_H</name>
      <anchorfile>a01655.html</anchorfile>
      <anchor>4a6a4e62d9182edcd76feb062a7837f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>a01688.html</anchorfile>
      <anchor>b3342279c87e89bce99dce6922647621</anchor>
      <arglist>(Fn &amp;, Typelist)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>types.h</name>
    <filename>a01656</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_TYPES_H</name>
      <anchorfile>a01656.html</anchorfile>
      <anchor>4bee3fee03cf56ac4e82c5a4b79b51ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>short</type>
      <name>int16</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>1e1d19be398226b695077389fb4af102</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>int32</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8d465e87b3078edcd8768b8cb0354320</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>long long</type>
      <name>int64</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>c6881aebdf508901f2ce8a56e0b9c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int64</type>
      <name>lcas_t</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>7f4d7984542d62d8288a5695f942d6cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>uint64</type>
      <name>sequence_index_t</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>197895be2b2db971c6c43244e9eb5763</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>uint16</type>
      <name>thread_index_t</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>5651019e943da063f4ee0f98bf7d952e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned short</type>
      <name>uint16</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>e816c7a98779bdb95c17e899e8c26151</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned int</type>
      <name>uint32</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f07574becf0f4eca0b4657e3d71bd75e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned long long</type>
      <name>uint64</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>49e5dc5fd6e30b5e8606ac4865f525c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_AlgorithmStrategy</name>
      <anchor>7e7a2a2b05c0e5a375f5f273a2958c33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_FindAlgorithm</name>
      <anchor>9781c614da1ed5ac69e1d8d9c9905375</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_MultiwayMergeAlgorithm</name>
      <anchor>91aea90a21e90c6f6594909b50d58829</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_Parallelism</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>sequential</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783d7b86be8c39fe445d2e0d6c94d4b46734</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>parallel_unbalanced</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783db3e8b07150d7209df681905bd8bc59d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>parallel_balanced</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783d9566b3641818e5ac737f70663d52800c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>parallel_omp_loop</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783d223a1895f0c534d28c3374a39868111b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>parallel_omp_loop_static</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783d42feae5cb49ebddce928ca9e95a586e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>parallel_taskqueue</name>
      <anchor>8221cda0f1a911c5731b007d0e4d783d7b1120877add37e5f13d5f95c3cd3c0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_PartialSumAlgorithm</name>
      <anchor>800008d9f5a548ec9d25a804c9842ca0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_SortAlgorithm</name>
      <anchor>6a8db7b045c2cb2b9d8d62d53d741b56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>_SplittingAlgorithm</name>
      <anchor>56cdc0647573069a7e018603b6ab1d8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>lcas_t_bits</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>cebf7c9a355654ef5ef3cd9806afd940</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const lcas_t</type>
      <name>lcas_t_mask</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8d7e5d5505e4adb9211a506df8ac4aec</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>types_traits.hpp</name>
    <filename>a01657</filename>
    <namespace>__gnu_pbds</namespace>
    <namespace>__gnu_pbds::detail</namespace>
    <class kind="struct">__gnu_pbds::detail::types_traits</class>
    <class kind="struct">__gnu_pbds::detail::vt_base_selector</class>
  </compound>
  <compound kind="file">
    <name>unique_copy.h</name>
    <filename>a01658</filename>
    <namespace>__gnu_parallel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_PARALLEL_UNIQUE_H</name>
      <anchorfile>a01658.html</anchorfile>
      <anchor>f048ae2a2386a903629ef571b6d4793b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_unique_copy</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>f4fed24d576a654d94fb26caee819be2</anchor>
      <arglist>(InputIterator first, InputIterator last, OutputIterator result)</arglist>
    </member>
    <member kind="function">
      <type>OutputIterator</type>
      <name>parallel_unique_copy</name>
      <anchorfile>a01692.html</anchorfile>
      <anchor>8001abb52de6c1ff1b6277a65d7ea33b</anchor>
      <arglist>(InputIterator first, InputIterator last, OutputIterator result, BinaryPredicate binary_pred)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>unordered_map</name>
    <filename>a01659</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_UNORDERED_MAP</name>
      <anchorfile>a01659.html</anchorfile>
      <anchor>4eaa6ae788cbf1c2336f826dccda0f0d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/unordered_map</name>
    <filename>a01660</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::unordered_map</class>
    <class kind="class">std::__debug::unordered_multimap</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BASE</name>
      <anchorfile>a01660.html</anchorfile>
      <anchor>6dfe3389c219a608128297b221272130</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BASE</name>
      <anchorfile>a01660.html</anchorfile>
      <anchor>6dfe3389c219a608128297b221272130</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_UNORDERED_MAP</name>
      <anchorfile>a01660.html</anchorfile>
      <anchor>e49cbdb71db0f13b1051ff6408af4031</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD_BASE</name>
      <anchorfile>a01660.html</anchorfile>
      <anchor>4ed3b6a4e0eea95af028fc4845dc73c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD_BASE</name>
      <anchorfile>a01660.html</anchorfile>
      <anchor>4ed3b6a4e0eea95af028fc4845dc73c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>57ccbfcf208195c152f9f822836f9213</anchor>
      <arglist>(unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>b603e235b35402ec87399a3a83bac82c</anchor>
      <arglist>(unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>7ae4294bcd9f5e6964bcb9453e271575</anchor>
      <arglist>(unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>805cad0859b926110ff470a44cf26d1d</anchor>
      <arglist>(unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>9efd69cb5df595556883b6d791e2145d</anchor>
      <arglist>(unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>ed19f57af9a49678cb32df9a91519c96</anchor>
      <arglist>(unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/unordered_map</name>
    <filename>a01661</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01661.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01661.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01661.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01661.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_UNORDERED_MAP</name>
      <anchorfile>a01661.html</anchorfile>
      <anchor>98d994dd40b5e8ca3d6e3a768b81d36d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/unordered_map</name>
    <filename>a01662</filename>
    <namespace>std</namespace>
    <class kind="class">std::__unordered_map</class>
    <class kind="class">std::__unordered_multimap</class>
    <class kind="class">std::unordered_map</class>
    <class kind="class">std::unordered_multimap</class>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>6b457620e5e11376a6ed298e7ba74d61</anchor>
      <arglist>(unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>e5a08c03e203e5baa8870cd30a33b352</anchor>
      <arglist>(unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>b08042bac196a9f116f23a404b520209</anchor>
      <arglist>(unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7a676f7bbc854a635e10873d45bf4dba</anchor>
      <arglist>(unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>ca32bc80bf66b0b92c65b7ae3d209771</anchor>
      <arglist>(unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0bc3f81b5f65a9dbb4dcd0be5e2d7fba</anchor>
      <arglist>(unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>2a8e2ad816f0801eb609c8c869105310</anchor>
      <arglist>(__unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__x, __unordered_multimap&lt; _Key, _Tp, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d4a690f8d5d42b3d3e5fd7cf1ae79112</anchor>
      <arglist>(__unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__x, __unordered_map&lt; _Key, _Tp, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>unordered_set</name>
    <filename>a01663</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_UNORDERED_SET</name>
      <anchorfile>a01663.html</anchorfile>
      <anchor>7436bc3afe3e3b69ab483e38096738dd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug/unordered_set</name>
    <filename>a01664</filename>
    <namespace>std</namespace>
    <namespace>std::__debug</namespace>
    <class kind="class">std::__debug::unordered_multiset</class>
    <class kind="class">std::__debug::unordered_set</class>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BASE</name>
      <anchorfile>a01664.html</anchorfile>
      <anchor>6dfe3389c219a608128297b221272130</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BASE</name>
      <anchorfile>a01664.html</anchorfile>
      <anchor>6dfe3389c219a608128297b221272130</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_DEBUG_UNORDERED_SET</name>
      <anchorfile>a01664.html</anchorfile>
      <anchor>3daf96ab452085dc02657e4bf5616c08</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD_BASE</name>
      <anchorfile>a01664.html</anchorfile>
      <anchor>4ed3b6a4e0eea95af028fc4845dc73c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_STD_BASE</name>
      <anchorfile>a01664.html</anchorfile>
      <anchor>4ed3b6a4e0eea95af028fc4845dc73c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>94892f072edb44cb59fa3b5fe968fd88</anchor>
      <arglist>(unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>1d3afd80df528556c3e5d223f3204f12</anchor>
      <arglist>(unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>566285cf8b26040fc7b822eeef2803e7</anchor>
      <arglist>(unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>0619480077dd8bc3bf2f36fe52d34f84</anchor>
      <arglist>(unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>0c6956685bb9914ca54d3a2625b4e0e4</anchor>
      <arglist>(unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01699.html</anchorfile>
      <anchor>ef23b85e51c77aa3c3f2b342732764c3</anchor>
      <arglist>(unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1/unordered_set</name>
    <filename>a01665</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_BEGIN_NAMESPACE_TR1</name>
      <anchorfile>a01665.html</anchorfile>
      <anchor>9de25f11697aa5d61a97fcae1490416e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_END_NAMESPACE_TR1</name>
      <anchorfile>a01665.html</anchorfile>
      <anchor>0433186c1af9441ed3167cefa2213bfb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_INCLUDE_AS_TR1</name>
      <anchorfile>a01665.html</anchorfile>
      <anchor>7cd6b02e91cda224c6cf9cdda2ae1dd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1</name>
      <anchorfile>a01665.html</anchorfile>
      <anchor>3a54a7b2957f1f25c9e2135050808c49</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_TR1_UNORDERED_SET</name>
      <anchorfile>a01665.html</anchorfile>
      <anchor>393a6a1336c7b88bf2223fb7d0640838</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/unordered_set</name>
    <filename>a01666</filename>
    <namespace>std</namespace>
    <class kind="class">std::__unordered_multiset</class>
    <class kind="class">std::__unordered_set</class>
    <class kind="class">std::unordered_multiset</class>
    <class kind="class">std::unordered_set</class>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>39d21ce44cc8ce3c884a2f8f6cfbb0ba</anchor>
      <arglist>(unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>0bb7eeb71d0b25b70e90288ac1415115</anchor>
      <arglist>(unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>fa0a15ac1b2b78a520e92aea4d4c1c99</anchor>
      <arglist>(unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>893d97b06a59b512669905573e83b225</anchor>
      <arglist>(unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;&amp;__x, unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>bf243d81dfae62e9c2368cabf6c40de0</anchor>
      <arglist>(unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>cc24a021d8f476d0e2256f06e98df9c6</anchor>
      <arglist>(unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__x, unordered_set&lt; _Value, _Hash, _Pred, _Alloc &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>7fb8f2f8b2612a446a45dce918b858fb</anchor>
      <arglist>(__unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__x, __unordered_multiset&lt; _Value, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>d8b3404e37b0cce5eb26cae22a8e6cb4</anchor>
      <arglist>(__unordered_set&lt; _Value, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__x, __unordered_set&lt; _Value, _Hash, _Pred, _Alloc, __cache_hash_code &gt; &amp;__y)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>utility</name>
    <filename>a01667</filename>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_UTILITY</name>
      <anchorfile>a01667.html</anchorfile>
      <anchor>506a0b1bca4414dec4951ec7cb14d883</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tr1_impl/utility</name>
    <filename>a01668</filename>
    <namespace>std</namespace>
    <class kind="struct">std::__pair_get&lt; 0 &gt;</class>
    <class kind="struct">std::__pair_get&lt; 1 &gt;</class>
    <class kind="struct">std::tuple_element&lt; 0, std::pair&lt; _Tp1, _Tp2 &gt; &gt;</class>
    <class kind="struct">std::tuple_element&lt; 1, std::pair&lt; _Tp1, _Tp2 &gt; &gt;</class>
    <class kind="struct">std::tuple_size&lt; std::pair&lt; _Tp1, _Tp2 &gt; &gt;</class>
    <member kind="function">
      <type>const tuple_element&lt; _Int, std::pair&lt; _Tp1, _Tp2 &gt; &gt;::type &amp;</type>
      <name>get</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>aed98c4909e94016c6d38642076a3872</anchor>
      <arglist>(const std::pair&lt; _Tp1, _Tp2 &gt; &amp;__in)</arglist>
    </member>
    <member kind="function">
      <type>tuple_element&lt; _Int, std::pair&lt; _Tp1, _Tp2 &gt; &gt;::type &amp;</type>
      <name>get</name>
      <anchorfile>a01697.html</anchorfile>
      <anchor>61cfa93d7090523f047f60696f5502c2</anchor>
      <arglist>(std::pair&lt; _Tp1, _Tp2 &gt; &amp;__in)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>valarray</name>
    <filename>a01669</filename>
    <namespace>std</namespace>
    <class kind="class">std::valarray</class>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_BINARY_OPERATOR</name>
      <anchorfile>a01669.html</anchorfile>
      <anchor>fd8b2afc0992d51e65ac4dcd34ab0b93</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_AUGMENTED_ASSIGNMENT</name>
      <anchorfile>a01669.html</anchorfile>
      <anchor>eae15cdfafee06176fb0ff0cf9872700</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_EXPR_AUGMENTED_ASSIGNMENT</name>
      <anchorfile>a01669.html</anchorfile>
      <anchor>1a4473a0c234f896ebe3f32509f4152f</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_DEFINE_VALARRAY_UNARY_OPERATOR</name>
      <anchorfile>a01669.html</anchorfile>
      <anchor>c53457ada7e25e93be916fe06ee229ba</anchor>
      <arglist>(_Op, _Name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>_GLIBCXX_VALARRAY</name>
   