// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_COMPLEX_H
#define POOMA_COMPLEX_H

#include <complex>

using std::complex;

using std::real;
using std::imag;
using std::norm;
using std::abs;
using std::arg;
using std::conj;
using std::polar;

using std::cos;
using std::cosh;
using std::exp;
using std::log;
using std::log10;
using std::pow;
using std::sin;
using std::sinh;
using std::sqrt;

// definitions for tan() and tanh() for type std::complex
// appear to be missing from the MS VC++ 6.0 header <Xcomplex>

template <class T>
inline
std::complex<T>
tan(std::complex<T> x)
{
  return sin(x)/cos(x);
}

template <class T>
inline
std::complex<T>
tanh(std::complex<T> x)
{
  return sinh(x)/cosh(x);
}

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: complex.h,v $   $Author: julianc $
// $Revision: 1.3 $   $Date: 2000/04/25 17:28:33 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
