#include "Pooma/Pooma.h"
#include "Geometry/CenteringTags.h"

#include <iostream>

// Forward declarations:
void printC(PoomaRectilinearCentering ce);

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);

  const unsigned D1 = 1, D2 = 2, D3 = 3;       // Dim
  const unsigned TR1 = 1, TR2 = 2, TR0 = 0;    // TensorRank
  const unsigned NC1 = 1, NC2 = 2, NC3 = 3;    // NComponents
  const unsigned DIR1 = 1, DIR2 = 2, DIR3 = 3; // Direction

  // 1D:
  std::cout << "1D, 1C, FaceRCTag<0>: { ";
  for (int d = 0; d < D1; d++) {
    printC(RectilinearCentering<D1,FaceRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "1D, 1C, EdgeRCTag<0>: { ";
  for (int d = 0; d < D1; d++) {
    printC(RectilinearCentering<D1,EdgeRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;

  // 2D:
  std::cout << "2D, 1C, FaceRCTag<0>: { ";
  for (int d = 0; d < D2; d++) {
    printC(RectilinearCentering<D2,FaceRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "2D, 2C, FaceRCTag<0>: { ";
  for (int d = 0; d < D2; d++) {
    printC(RectilinearCentering<D2,FaceRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "2D, 1C, EdgeRCTag<0>: { ";
  for (int d = 0; d < D2; d++) {
    printC(RectilinearCentering<D2,EdgeRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "2D, 1C, FaceRCTag<1>: { ";
  for (int d = 0; d < D2; d++) {
    for (int c = 0; c < NC1; c++) {
      printC(RectilinearCentering<D2,FaceRCTag<1> >::centering(d));
    }
  }
  std::cout << "}" << std::endl;
  std::cout << "2D, 1C, EdgeRCTag<1>: { ";
  for (int d = 0; d < D2; d++) {
    printC(RectilinearCentering<D2,EdgeRCTag<1> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "2D, 2C, VectorFaceRCTag<2>: { ";
  for (int d = 0; d < D2; d++) {
    for (int c = 0; c < NC2; c++) {
      printC(RectilinearCentering<D2,VectorFaceRCTag<D2> >::centering(d,c));
    }
  }
  std::cout << "}" << std::endl;
  std::cout << "2D, 2C, VectorEdgeRCTag<2>: { ";
  for (int d = 0; d < D2; d++) {
    for (int c = 0; c < NC2; c++) {
      printC(RectilinearCentering<D2,VectorEdgeRCTag<D2> >::centering(d,c));
    }
  }
  std::cout << "}" << std::endl;

  // 3D:
  std::cout << "3D, 1C, FaceRCTag<0>: { ";
  for (int d = 0; d < D3; d++) {
    printC(RectilinearCentering<D3,FaceRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "3D, 1C, EdgeRCTag<0>: { ";
  for (int d = 0; d < D3; d++) {
    printC(RectilinearCentering<D3,EdgeRCTag<0> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "3D, 1C, FaceRCTag<1>: { ";
  for (int d = 0; d < D3; d++) {
    printC(RectilinearCentering<D3,FaceRCTag<1> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "3D, 1C, FaceRCTag<2>: { ";
  for (int d = 0; d < D3; d++) {
    printC(RectilinearCentering<D3,FaceRCTag<2> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "3D, 1C, EdgeRCTag<1>: { ";
  for (int d = 0; d < D3; d++) {
    printC(RectilinearCentering<D3,EdgeRCTag<1> >::centering(d));
  }
  std::cout << "}" << std::endl;
  std::cout << "3D, 3C, VectorFaceRCTag<3>: { ";
  for (int d = 0; d < D3; d++) {
    for (int c = 0; c < NC3; c++) {
      printC(RectilinearCentering<D3,VectorFaceRCTag<D3> >::centering(d,c));
    }
  }
  std::cout << "}" << std::endl;
  std::cout << "3D, 3C, VectorEdgeRCTag<3>: { ";
  for (int d = 0; d < D3; d++) {
    for (int c = 0; c < NC3; c++) {
      printC(RectilinearCentering<D3,VectorEdgeRCTag<D3> >::centering(d,c));
    }
  }
  std::cout << "}" << std::endl;

  

  Pooma::finalize();
  return 0;
}

// Formatted printout of 1D, one-component centering value (enum):
void printC(PoomaRectilinearCentering ce) {
 
 switch (ce) {
  case cell:
    std::cout << "cell ";
    break;
  case vert:
    std::cout << "vert ";
    break;
  case undefined:
    std::cout << "undefined ";
    break;
  default:
    std::cout << "BOGUS! ";
  }

}
