// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// test of RNGSimple
//-----------------------------------------------------------------------------

// include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Functions/RNGSimple.h"

#include <iostream>

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);

  RNGSimple r0, r1, r2;

  tester.out() << "some random numbers" << std::endl;

  int i;
  for (i = 0; i < 10; ++i)
  {
    tester.out() << i << ": "
		 << r0.value() << ","
		 << r1.value() << ","
		 << r2.value() << std::endl; 
    r0.advance();
    r1.advance();
    r2.advance();
  }

  tester.out() << r0.value() - r1.value() << std::endl;

  tester.check("same values", abs(r0.value() - r1.value()) < 0.00001);

  tester.out() << "different seeds!" << std::endl;
  r0.advance(1);
  r1.advance(2);
  r2.advance(3);

  for (i = 0; i < 10; ++i)
  {
    tester.out() << i << ": "
		 << r0.value() << ","
		 << r1.value() << ","
		 << r2.value() << std::endl;
    r0.advance();
    r1.advance();
    r2.advance();
  }

  tester.out() << r0.value() - r1.value() << std::endl;

  tester.check("different values", r0.value() != r1.value());

  int ret = tester.results("rngSimple");

  Pooma::finalize();

  return ret;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: rngSimple.cpp,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:17:20 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
