// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Array test 13: bounds checking
//
// Note: exceptions are not thread safe so this program may not work in
//       in parallel.
//-----------------------------------------------------------------------------

// Make sure bounds checking is on.

#ifdef POOMA_BOUNDS_CHECK
#undef POOMA_BOUNDS_CHECK
#endif

#ifdef POOMA_BOUNDS_CHECK_DEFAULT
#undef POOMA_BOUNDS_CHECK_DEFAULT
#endif

#define POOMA_BOUNDS_CHECK POOMA_YES
#define POOMA_BOUNDS_CHECK_DEFAULT POOMA_TRUE

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"
#include "Tiny/Vector.h"

#include <math.h>


int main(int argc, char* argv[])
{
  // Initialize Pooma.
  
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);

  // This test depends on exceptions being present.

#if ! POOMA_THREADS
#if POOMA_EXCEPTIONS

  int cnt = 0;

  int n = 10;
  Array<3> a(n, n, n);
  Array<2, Vector<3> > b(n, n);
  
  try
    {
      a(-1, 0, 0) = 3.0;
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }
    
  try
    {
      double d = a(-1, 0, 0);
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }
    
  try
    {
      a(0, n, 0) = 3.0;
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }

  try
    {
      double d = a(0, n, 0);
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }

  try
    {
      Interval<1> I(n+1);
      a(I, 0, 0) = 3.0;
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }

  try
    {
      Interval<1> I(n+1);
      Array<1> v(I);
      v = a(I, 0, 0);
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }

  try
    {
      Interval<1> I(0,0);
      b(I,I).comp(4) = 3.0;
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }

  try
    {
      Interval<1> I(0,0);
      Array<2> v(I,I);
      v = b(I,I).comp(4);
    }
  catch(Pooma::Assertion &as)
    {
      tester.exceptionHandler( as );
      cnt++;
    }

  if (cnt != 8)
    tester.set(false);

#endif
#endif

  int ret = tester.results("array_test13");
  Pooma::finalize();
  return ret;

}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test13.cpp,v $   $Author: swhaney $
// $Revision: 1.10 $   $Date: 2000/07/20 15:36:25 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
