//=================================================================
//
//        strtoul.c
//
//        Testcase for C library strtoul()
//
//=================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     ctarpy, jlarmour
// Contributors:  
// Date:          2000-04-30
// Description:   Contains testcode for C library strtoul() function
//
//
//####DESCRIPTIONEND####

// INCLUDES

#include <pkgconf/system.h>
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include <cyg/infra/testcase.h>


// FUNCTIONS

static char *
my_strcpy(char *s1, const char *s2)
{
    while (*s2 != '\0') {
        *(s1++) = *(s2++);
    }
    *s1 = '\0';

    return s1; 
} // my_strcpy()


static void
test( CYG_ADDRWORD data )
{
    char x[30];
    unsigned long z;
    char *endptr;

    my_strcpy(x, "20");
    CYG_TEST_PASS_FAIL( strtoul(x, (char**)NULL, 10) == 20,
                        "Simple strtoul(20 ,...)" );

    my_strcpy(x, "1972100");
    CYG_TEST_PASS_FAIL( strtoul(x, (char**)NULL, 10) == 1972100,
                        "Simple strtoul(1972100, ..." );

    my_strcpy(x, "0xFFEE");
    z = strtoul(x, (char**)NULL, 16);
    CYG_TEST_PASS_FAIL(z == 65518, "Hex base strtoul()");

    my_strcpy(x, "100111011");
    z = strtoul(x, (char**)NULL, 2);
    CYG_TEST_PASS_FAIL(z == 315, "Binary base strtoul()");

    my_strcpy(x, "10372");
    z = strtoul(x, (char**)NULL, 8);
    CYG_TEST_PASS_FAIL(z == 4346, "Octal base strtoul()" );

    my_strcpy(x, "317823");
    z = strtoul(x, (char**)NULL, 8);
    CYG_TEST_PASS_FAIL(z == 207, "Partial string" );

    my_strcpy(x, " 53ab823");
    z = strtoul(x, &endptr, 10);
    CYG_TEST_PASS_FAIL( (z == 53) && (endptr==&x[3]), "Correct end pointer" );

    my_strcpy(x, "-479");
    z = strtoul(x, (char**)NULL, 0);
    CYG_TEST_PASS_FAIL( (z == (unsigned long) -479),
                        "Negative string");

    my_strcpy(x, "+4796");
    z = strtoul(x, (char**)NULL, 10);
    CYG_TEST_PASS_FAIL(z == 4796, "Positive string");

    my_strcpy(x, "");
    z = strtoul(x, (char**)NULL, 10);
    CYG_TEST_PASS_FAIL(z == 0, "Empty string");

    my_strcpy(x, "");
    z = strtoul(x, &endptr, 10);
    CYG_TEST_PASS_FAIL( (z == 0) && (endptr==x),
                        "Empty string sets endptr correctly");

    my_strcpy(x, "    ");
    z = strtoul(x, &endptr, 10);
    CYG_TEST_PASS_FAIL( (z == 0) && (endptr==x),
                        "White space only string sets endptr correctly");

    my_strcpy(x, "0XFFEE");
    z = strtoul(x, (char**)NULL, 0);
    CYG_TEST_PASS_FAIL(z == 65518, "Base 0 but hex");

    my_strcpy(x, "\t    0629");
    z = strtoul(x, (char**)NULL, 0);
    CYG_TEST_PASS_FAIL(z == 50, "Base 0 but octal");

    my_strcpy(x, "42");
    z = strtoul(x, (char**)NULL, 0);
    CYG_TEST_PASS_FAIL(z == 42, "Base 0 but decimal");

    my_strcpy(x, "hello");
    z = strtoul(x, &endptr, 0);
    CYG_TEST_PASS_FAIL((z == 0) && (endptr==x),
                       "endptr set correctly on conversion failure");

    my_strcpy(x, "z2f");
    z = strtoul(x, (char**)NULL, 36);
    CYG_TEST_PASS_FAIL(z == 45447, "Base==36");

    my_strcpy(x, "h547324");
    z = strtoul(x, (char**)NULL, 10);
    CYG_TEST_PASS_FAIL(z == 0, "No valid number string");

    my_strcpy(x, "545425876654547324");
    z = strtoul(x, (char**)NULL, 10);
    CYG_TEST_PASS_FAIL( (z == ULONG_MAX) && (errno == ERANGE),
                        "Number out of range");

    CYG_TEST_FINISH("Finished tests from testcase " __FILE__ " for C library "
                    "strtoul() function");
} // test()

#ifndef CYGPKG_LIBC_STARTUP
void cyg_user_start(void)
#else
int
main( int argc, char *argv[] )
#endif
{
    CYG_TEST_INIT();

    CYG_TEST_INFO("Starting tests from testcase " __FILE__ " for C library "
                  "strtoul() function");
    CYG_TEST_INFO("This testcase provides simple basic tests");

    test(0);

    CYG_TEST_NA("Testing is not applicable to this configuration");
} // main()

// EOF strtoul.c
