#ifndef CYGONCE_LIBM_FREXP_H
#define CYGONCE_LIBM_FREXP_H
//===========================================================================
//
//      frexp.h
//
//      Test vectors for testing of frexp() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/frexp.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define FREXP_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t frexp_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 0u, 6u, 1071707692u, 2506787616u, 0, FREXP_TOLERANCE, 0},
{ 2, 1090024059u, 3619148316u, 0u, 17u, 1072198267u, 3619148316u, 0, FREXP_TOLERANCE, 0},
{ 3, 3218153654u, 3176730980u, 0u, 4294967295u, 3219202230u, 3176730980u, 0, FREXP_TOLERANCE, 0},
{ 4, 1051524793u, 2993920299u, 0u, 4294967276u, 1072496313u, 2993920299u, 0, FREXP_TOLERANCE, 0},
{ 5, 3239659803u, 2725707538u, 0u, 19u, 3219736859u, 2725707538u, 0, FREXP_TOLERANCE, 0},
{ 6, 3232101343u, 2346810316u, 0u, 12u, 3219518431u, 2346810316u, 0, FREXP_TOLERANCE, 0},
{ 7, 1092554362u, 2088062470u, 0u, 19u, 1072631418u, 2088062470u, 0, FREXP_TOLERANCE, 0},
{ 8, 3201242716u, 420891118u, 0u, 4294967278u, 3220117084u, 420891118u, 0, FREXP_TOLERANCE, 0},
{ 9, 3221200677u, 2636405208u, 0u, 1u, 3220152101u, 2636405208u, 0, FREXP_TOLERANCE, 0},
{ 10, 1100049309u, 471635570u, 0u, 27u, 1071737757u, 471635570u, 0, FREXP_TOLERANCE, 0},
{ 11, 1089363191u, 1746012320u, 0u, 16u, 1072585975u, 1746012320u, 0, FREXP_TOLERANCE, 0},
{ 12, 1054478713u, 3333988501u, 0u, 4294967279u, 1072304505u, 3333988501u, 0, FREXP_TOLERANCE, 0},
{ 13, 1047953160u, 183014794u, 0u, 4294967273u, 1072070408u, 183014794u, 0, FREXP_TOLERANCE, 0},
{ 14, 3202039382u, 2016785810u, 0u, 4294967279u, 3219865174u, 2016785810u, 0, FREXP_TOLERANCE, 0},
{ 15, 3213486034u, 2688957927u, 0u, 4294967290u, 3219777490u, 2688957927u, 0, FREXP_TOLERANCE, 0},
{ 16, 1046089230u, 2709029994u, 0u, 4294967271u, 1072303630u, 2709029994u, 0, FREXP_TOLERANCE, 0},
{ 17, 1058795730u, 624574473u, 0u, 4294967283u, 1072427218u, 624574473u, 0, FREXP_TOLERANCE, 0},
{ 18, 1045840574u, 3473266330u, 0u, 4294967271u, 1072054974u, 3473266330u, 0, FREXP_TOLERANCE, 0},
{ 19, 3204919842u, 1605286142u, 0u, 4294967282u, 3219599906u, 1605286142u, 0, FREXP_TOLERANCE, 0},
{ 20, 1068931671u, 4233776869u, 0u, 4294967293u, 1072077399u, 4233776869u, 0, FREXP_TOLERANCE, 0},
{ 21, 1060343410u, 1857607719u, 0u, 4294967285u, 1071877746u, 1857607719u, 0, FREXP_TOLERANCE, 0},
{ 22, 3222889559u, 3417070006u, 0u, 3u, 3219743831u, 3417070006u, 0, FREXP_TOLERANCE, 0},
{ 23, 1103599987u, 3981151660u, 0u, 30u, 1072142707u, 3981151660u, 0, FREXP_TOLERANCE, 0},
{ 24, 1088899021u, 1332651746u, 0u, 16u, 1072121805u, 1332651746u, 0, FREXP_TOLERANCE, 0},
{ 25, 1085298022u, 3824988054u, 0u, 13u, 1071666534u, 3824988054u, 0, FREXP_TOLERANCE, 0},
{ 26, 1066856791u, 2070129652u, 0u, 4294967291u, 1072099671u, 2070129652u, 0, FREXP_TOLERANCE, 0},
{ 27, 3207559790u, 1372884064u, 0u, 4294967284u, 3220142702u, 1372884064u, 0, FREXP_TOLERANCE, 0},
{ 28, 1080833116u, 3229926662u, 0u, 8u, 1072444508u, 3229926662u, 0, FREXP_TOLERANCE, 0},
{ 29, 1093826501u, 3217805330u, 0u, 21u, 1071806405u, 3217805330u, 0, FREXP_TOLERANCE, 0},
{ 30, 3191644264u, 2014578707u, 0u, 4294967269u, 3219955816u, 2014578707u, 0, FREXP_TOLERANCE, 0},
{ 31, 1102287487u, 265058758u, 0u, 29u, 1071878783u, 265058758u, 0, FREXP_TOLERANCE, 0},
{ 32, 3239903247u, 1630600647u, 0u, 19u, 3219980303u, 1630600647u, 0, FREXP_TOLERANCE, 0},
{ 33, 1071124229u, 1946677669u, 0u, 4294967295u, 1072172805u, 1946677669u, 0, FREXP_TOLERANCE, 0},
{ 34, 3198462609u, 926009897u, 0u, 4294967276u, 3219434129u, 926009897u, 0, FREXP_TOLERANCE, 0},
{ 35, 1072130299u, 2271884183u, 0u, 0u, 1072130299u, 2271884183u, 0, FREXP_TOLERANCE, 0},
{ 36, 3203741999u, 2118617783u, 0u, 4294967281u, 3219470639u, 2118617783u, 0, FREXP_TOLERANCE, 0},
{ 37, 3194849109u, 213658772u, 0u, 4294967272u, 3220014933u, 213658772u, 0, FREXP_TOLERANCE, 0},
{ 38, 3249401130u, 314151656u, 0u, 28u, 3220041002u, 314151656u, 0, FREXP_TOLERANCE, 0},
{ 39, 3254112288u, 1564829925u, 0u, 33u, 3219509280u, 1564829925u, 0, FREXP_TOLERANCE, 0},
{ 40, 3197817016u, 497230814u, 0u, 4294967275u, 3219837112u, 497230814u, 0, FREXP_TOLERANCE, 0},
{ 41, 3216262634u, 2075329122u, 0u, 4294967293u, 3219408362u, 2075329122u, 0, FREXP_TOLERANCE, 0},
{ 42, 3231746400u, 169900577u, 0u, 12u, 3219163488u, 169900577u, 0, FREXP_TOLERANCE, 0},
{ 43, 1049848642u, 541549344u, 0u, 4294967275u, 1071868738u, 541549344u, 0, FREXP_TOLERANCE, 0},
{ 44, 1096608669u, 3119070100u, 0u, 23u, 1072491421u, 3119070100u, 0, FREXP_TOLERANCE, 0},
{ 45, 1085427055u, 567496114u, 0u, 13u, 1071795567u, 567496114u, 0, FREXP_TOLERANCE, 0},
{ 46, 1045286891u, 1969998540u, 0u, 4294967270u, 1072549867u, 1969998540u, 0, FREXP_TOLERANCE, 0},
{ 47, 1060548195u, 1299369769u, 0u, 4294967285u, 1072082531u, 1299369769u, 0, FREXP_TOLERANCE, 0},
{ 48, 1049342524u, 4167404066u, 0u, 4294967274u, 1072411196u, 4167404066u, 0, FREXP_TOLERANCE, 0},
{ 49, 3208865645u, 3348930841u, 0u, 4294967286u, 3219351405u, 3348930841u, 0, FREXP_TOLERANCE, 0},
{ 50, 1078472138u, 358457347u, 0u, 6u, 1072180682u, 358457347u, 0, FREXP_TOLERANCE, 0},
{ 51, 1071069297u, 2192461366u, 0u, 4294967295u, 1072117873u, 2192461366u, 0, FREXP_TOLERANCE, 0},
{ 52, 1099527247u, 3184735642u, 0u, 26u, 1072264271u, 3184735642u, 0, FREXP_TOLERANCE, 0},
{ 53, 1052861772u, 331696577u, 0u, 4294967278u, 1071736140u, 331696577u, 0, FREXP_TOLERANCE, 0},
{ 54, 3189610016u, 793242270u, 0u, 4294967267u, 3220018720u, 793242270u, 0, FREXP_TOLERANCE, 0},
{ 55, 3252528934u, 2322696981u, 0u, 31u, 3220023078u, 2322696981u, 0, FREXP_TOLERANCE, 0},
{ 56, 1083791358u, 3020766674u, 0u, 11u, 1072257022u, 3020766674u, 0, FREXP_TOLERANCE, 0},
{ 57, 1044902177u, 252085215u, 0u, 4294967270u, 1072165153u, 252085215u, 0, FREXP_TOLERANCE, 0},
{ 58, 3214426435u, 4139068910u, 0u, 4294967291u, 3219669315u, 4139068910u, 0, FREXP_TOLERANCE, 0},
{ 59, 3222505725u, 105589263u, 0u, 3u, 3219359997u, 105589263u, 0, FREXP_TOLERANCE, 0},
{ 60, 1056316170u, 261630827u, 0u, 4294967281u, 1072044810u, 261630827u, 0, FREXP_TOLERANCE, 0},
{ 61, 1107213408u, 428765703u, 0u, 33u, 1072610400u, 428765703u, 0, FREXP_TOLERANCE, 0},
{ 62, 3251828686u, 2009972239u, 0u, 31u, 3219322830u, 2009972239u, 0, FREXP_TOLERANCE, 0},
{ 63, 1098568019u, 3517376586u, 0u, 25u, 1072353619u, 3517376586u, 0, FREXP_TOLERANCE, 0},
{ 64, 3240257920u, 3304487302u, 0u, 20u, 3219286400u, 3304487302u, 0, FREXP_TOLERANCE, 0},
{ 65, 3233537912u, 237004814u, 0u, 13u, 3219906424u, 237004814u, 0, FREXP_TOLERANCE, 0},
{ 66, 3237899261u, 3364008659u, 0u, 17u, 3220073469u, 3364008659u, 0, FREXP_TOLERANCE, 0},
{ 67, 3195247552u, 472004928u, 0u, 4294967273u, 3219364800u, 472004928u, 0, FREXP_TOLERANCE, 0},
{ 68, 3226869477u, 1186387580u, 0u, 7u, 3219529445u, 1186387580u, 0, FREXP_TOLERANCE, 0},
{ 69, 1054226850u, 4085763910u, 0u, 4294967279u, 1072052642u, 4085763910u, 0, FREXP_TOLERANCE, 0},
{ 70, 1106394906u, 2684738273u, 0u, 33u, 1071791898u, 2684738273u, 0, FREXP_TOLERANCE, 0},
{ 71, 1057053639u, 2055490142u, 0u, 4294967282u, 1071733703u, 2055490142u, 0, FREXP_TOLERANCE, 0},
{ 72, 3231581370u, 3879040079u, 0u, 11u, 3220047034u, 3879040079u, 0, FREXP_TOLERANCE, 0},
{ 73, 3188976647u, 3725731239u, 0u, 4294967267u, 3219385351u, 3725731239u, 0, FREXP_TOLERANCE, 0},
{ 74, 1061652681u, 591292963u, 0u, 4294967286u, 1072138441u, 591292963u, 0, FREXP_TOLERANCE, 0},
{ 75, 3225014981u, 1147041027u, 0u, 5u, 3219772101u, 1147041027u, 0, FREXP_TOLERANCE, 0},
{ 76, 3215417793u, 624695933u, 0u, 4294967292u, 3219612097u, 624695933u, 0, FREXP_TOLERANCE, 0},
{ 77, 3206052774u, 705725219u, 0u, 4294967283u, 3219684262u, 705725219u, 0, FREXP_TOLERANCE, 0},
{ 78, 3238067573u, 1116238321u, 0u, 18u, 3219193205u, 1116238321u, 0, FREXP_TOLERANCE, 0},
{ 79, 3207367088u, 7287411u, 0u, 4294967284u, 3219950000u, 7287411u, 0, FREXP_TOLERANCE, 0},
{ 80, 1045917232u, 116067742u, 0u, 4294967271u, 1072131632u, 116067742u, 0, FREXP_TOLERANCE, 0},
{ 81, 3240055222u, 3604989074u, 0u, 19u, 3220132278u, 3604989074u, 0, FREXP_TOLERANCE, 0},
{ 82, 1066381836u, 545298780u, 0u, 4294967290u, 1072673292u, 545298780u, 0, FREXP_TOLERANCE, 0},
{ 83, 3219080936u, 1681476121u, 0u, 4294967295u, 3220129512u, 1681476121u, 0, FREXP_TOLERANCE, 0},
{ 84, 1060345752u, 3553822398u, 0u, 4294967285u, 1071880088u, 3553822398u, 0, FREXP_TOLERANCE, 0},
{ 85, 1102831658u, 3410480388u, 0u, 29u, 1072422954u, 3410480388u, 0, FREXP_TOLERANCE, 0},
{ 86, 1052460275u, 1660607230u, 0u, 4294967277u, 1072383219u, 1660607230u, 0, FREXP_TOLERANCE, 0},
{ 87, 1089216869u, 1494984673u, 0u, 16u, 1072439653u, 1494984673u, 0, FREXP_TOLERANCE, 0},
{ 88, 3196647153u, 287894723u, 0u, 4294967274u, 3219715825u, 287894723u, 0, FREXP_TOLERANCE, 0},
{ 89, 1054885127u, 644548665u, 0u, 4294967280u, 1071662343u, 644548665u, 0, FREXP_TOLERANCE, 0},
{ 90, 1081948134u, 2442134629u, 0u, 9u, 1072510950u, 2442134629u, 0, FREXP_TOLERANCE, 0},
{ 91, 1087554095u, 2312530895u, 0u, 15u, 1071825455u, 2312530895u, 0, FREXP_TOLERANCE, 0},
{ 92, 3221584595u, 3379665576u, 0u, 2u, 3219487443u, 3379665576u, 0, FREXP_TOLERANCE, 0},
{ 93, 1096085375u, 3018463866u, 0u, 23u, 1071968127u, 3018463866u, 0, FREXP_TOLERANCE, 0},
{ 94, 1086226574u, 404012923u, 0u, 13u, 1072595086u, 404012923u, 0, FREXP_TOLERANCE, 0},
{ 95, 1064733299u, 1710279345u, 0u, 4294967289u, 1072073331u, 1710279345u, 0, FREXP_TOLERANCE, 0},
{ 96, 3251401196u, 3528946000u, 0u, 30u, 3219943916u, 3528946000u, 0, FREXP_TOLERANCE, 0},
{ 97, 1061536351u, 2164450219u, 0u, 4294967286u, 1072022111u, 2164450219u, 0, FREXP_TOLERANCE, 0},
{ 98, 1083520023u, 3312018966u, 0u, 11u, 1071985687u, 3312018966u, 0, FREXP_TOLERANCE, 0},
{ 99, 1057248676u, 2648986431u, 0u, 4294967282u, 1071928740u, 2648986431u, 0, FREXP_TOLERANCE, 0},
{ 100, 1050330591u, 1474376550u, 0u, 4294967275u, 1072350687u, 1474376550u, 0, FREXP_TOLERANCE, 0},
{ 101, 3194422028u, 1839068700u, 0u, 4294967272u, 3219587852u, 1839068700u, 0, FREXP_TOLERANCE, 0},
{ 102, 1077406406u, 3013052171u, 0u, 5u, 1072163526u, 3013052171u, 0, FREXP_TOLERANCE, 0},
{ 103, 1046493630u, 772102380u, 0u, 4294967272u, 1071659454u, 772102380u, 0, FREXP_TOLERANCE, 0},
{ 104, 3220729740u, 4219039958u, 0u, 1u, 3219681164u, 4219039958u, 0, FREXP_TOLERANCE, 0},
{ 105, 3229472221u, 3058618779u, 0u, 9u, 3220035037u, 3058618779u, 0, FREXP_TOLERANCE, 0},
{ 106, 1046304788u, 3338676024u, 0u, 4294967271u, 1072519188u, 3338676024u, 0, FREXP_TOLERANCE, 0},
{ 107, 1051172137u, 506286854u, 0u, 4294967276u, 1072143657u, 506286854u, 0, FREXP_TOLERANCE, 0},
{ 108, 1094907481u, 2217000199u, 0u, 22u, 1071838809u, 2217000199u, 0, FREXP_TOLERANCE, 0},
{ 109, 1082428310u, 1147428263u, 0u, 10u, 1071942550u, 1147428263u, 0, FREXP_TOLERANCE, 0},
{ 110, 1065432625u, 3034786717u, 0u, 4294967290u, 1071724081u, 3034786717u, 0, FREXP_TOLERANCE, 0},
{ 111, 1082016752u, 2844125311u, 0u, 9u, 1072579568u, 2844125311u, 0, FREXP_TOLERANCE, 0},
{ 112, 1082985198u, 2561492677u, 0u, 10u, 1072499438u, 2561492677u, 0, FREXP_TOLERANCE, 0},
{ 113, 3211536916u, 704542600u, 0u, 4294967288u, 3219925524u, 704542600u, 0, FREXP_TOLERANCE, 0},
{ 114, 3222902057u, 2762779203u, 0u, 3u, 3219756329u, 2762779203u, 0, FREXP_TOLERANCE, 0},
{ 115, 3199680614u, 184131949u, 0u, 4294967277u, 3219603558u, 184131949u, 0, FREXP_TOLERANCE, 0},
{ 116, 3249723525u, 1667366082u, 0u, 29u, 3219314821u, 1667366082u, 0, FREXP_TOLERANCE, 0},
{ 117, 3223609598u, 3904224140u, 0u, 4u, 3219415294u, 3904224140u, 0, FREXP_TOLERANCE, 0},
{ 118, 1067056698u, 2942159914u, 0u, 4294967291u, 1072299578u, 2942159914u, 0, FREXP_TOLERANCE, 0},
{ 119, 1100636863u, 426114282u, 0u, 27u, 1072325311u, 426114282u, 0, FREXP_TOLERANCE, 0},
{ 120, 3209056785u, 1083606355u, 0u, 4294967286u, 3219542545u, 1083606355u, 0, FREXP_TOLERANCE, 0},
{ 121, 1106165945u, 3774123863u, 0u, 32u, 1072611513u, 3774123863u, 0, FREXP_TOLERANCE, 0},
{ 122, 1106787580u, 2722107965u, 0u, 33u, 1072184572u, 2722107965u, 0, FREXP_TOLERANCE, 0},
{ 123, 1088005092u, 1377734762u, 0u, 15u, 1072276452u, 1377734762u, 0, FREXP_TOLERANCE, 0},
{ 124, 1104232051u, 2377063483u, 0u, 31u, 1071726195u, 2377063483u, 0, FREXP_TOLERANCE, 0},
{ 125, 1069380559u, 1029739074u, 0u, 4294967293u, 1072526287u, 1029739074u, 0, FREXP_TOLERANCE, 0},
{ 126, 1105467109u, 3062201018u, 0u, 32u, 1071912677u, 3062201018u, 0, FREXP_TOLERANCE, 0},
{ 127, 3234741597u, 773857656u, 0u, 14u, 3220061533u, 773857656u, 0, FREXP_TOLERANCE, 0},
{ 128, 3214251949u, 335833884u, 0u, 4294967291u, 3219494829u, 335833884u, 0, FREXP_TOLERANCE, 0},
{ 129, 3203224610u, 1473865960u, 0u, 4294967280u, 3220001826u, 1473865960u, 0, FREXP_TOLERANCE, 0},
{ 130, 1103073830u, 4000427507u, 0u, 29u, 1072665126u, 4000427507u, 0, FREXP_TOLERANCE, 0},
{ 131, 1103185231u, 4242092620u, 0u, 30u, 1071727951u, 4242092620u, 0, FREXP_TOLERANCE, 0},
{ 132, 1067009473u, 14539161u, 0u, 4294967291u, 1072252353u, 14539161u, 0, FREXP_TOLERANCE, 0},
{ 133, 3192516074u, 1732245037u, 0u, 4294967270u, 3219779050u, 1732245037u, 0, FREXP_TOLERANCE, 0},
{ 134, 1101371955u, 1533536108u, 0u, 28u, 1072011827u, 1533536108u, 0, FREXP_TOLERANCE, 0},
{ 135, 3249153995u, 1833841275u, 0u, 28u, 3219793867u, 1833841275u, 0, FREXP_TOLERANCE, 0},
{ 136, 1099430098u, 4144145552u, 0u, 26u, 1072167122u, 4144145552u, 0, FREXP_TOLERANCE, 0},
{ 137, 3244270463u, 935007012u, 0u, 23u, 3220153215u, 935007012u, 0, FREXP_TOLERANCE, 0},
{ 138, 3188865420u, 604442938u, 0u, 4294967267u, 3219274124u, 604442938u, 0, FREXP_TOLERANCE, 0},
{ 139, 3206903253u, 2211464602u, 0u, 4294967284u, 3219486165u, 2211464602u, 0, FREXP_TOLERANCE, 0},
{ 140, 1046255144u, 1635910526u, 0u, 4294967271u, 1072469544u, 1635910526u, 0, FREXP_TOLERANCE, 0},
{ 141, 1077871417u, 2549219008u, 0u, 5u, 1072628537u, 2549219008u, 0, FREXP_TOLERANCE, 0},
{ 142, 3231633258u, 3733639385u, 0u, 11u, 3220098922u, 3733639385u, 0, FREXP_TOLERANCE, 0},
{ 143, 1082095089u, 1819374372u, 0u, 9u, 1072657905u, 1819374372u, 0, FREXP_TOLERANCE, 0},
{ 144, 3202219056u, 2617077637u, 0u, 4294967279u, 3220044848u, 2617077637u, 0, FREXP_TOLERANCE, 0},
{ 145, 1094345280u, 546465680u, 0u, 21u, 1072325184u, 546465680u, 0, FREXP_TOLERANCE, 0},
{ 146, 1048653554u, 532401530u, 0u, 4294967274u, 1071722226u, 532401530u, 0, FREXP_TOLERANCE, 0},
{ 147, 1044571091u, 2759019783u, 0u, 4294967270u, 1071834067u, 2759019783u, 0, FREXP_TOLERANCE, 0},
{ 148, 3221570188u, 3554409630u, 0u, 2u, 3219473036u, 3554409630u, 0, FREXP_TOLERANCE, 0},
{ 149, 3212931282u, 2527221960u, 0u, 4294967290u, 3219222738u, 2527221960u, 0, FREXP_TOLERANCE, 0},
{ 150, 1099107978u, 2696971136u, 0u, 26u, 1071845002u, 2696971136u, 0, FREXP_TOLERANCE, 0},
{ 151, 1097158000u, 173134582u, 0u, 24u, 1071992176u, 173134582u, 0, FREXP_TOLERANCE, 0},
{ 152, 1087299442u, 2877794600u, 0u, 14u, 1072619378u, 2877794600u, 0, FREXP_TOLERANCE, 0},
{ 153, 1086400474u, 547642046u, 0u, 14u, 1071720410u, 547642046u, 0, FREXP_TOLERANCE, 0},
{ 154, 3197285510u, 3521286127u, 0u, 4294967275u, 3219305606u, 3521286127u, 0, FREXP_TOLERANCE, 0},
{ 155, 1074860702u, 1231582831u, 0u, 3u, 1071714974u, 1231582831u, 0, FREXP_TOLERANCE, 0},
{ 156, 1090971734u, 1653446832u, 0u, 18u, 1072097366u, 1653446832u, 0, FREXP_TOLERANCE, 0},
{ 157, 1061342535u, 3762182190u, 0u, 4294967286u, 1071828295u, 3762182190u, 0, FREXP_TOLERANCE, 0},
{ 158, 3252967851u, 2615360375u, 0u, 32u, 3219413419u, 2615360375u, 0, FREXP_TOLERANCE, 0},
{ 159, 3200834423u, 2588067350u, 0u, 4294967278u, 3219708791u, 2588067350u, 0, FREXP_TOLERANCE, 0},
{ 160, 3206610957u, 3551059728u, 0u, 4294967284u, 3219193869u, 3551059728u, 0, FREXP_TOLERANCE, 0},
{ 161, 3206978856u, 845263327u, 0u, 4294967284u, 3219561768u, 845263327u, 0, FREXP_TOLERANCE, 0},
{ 162, 1073415902u, 1749010288u, 0u, 1u, 1072367326u, 1749010288u, 0, FREXP_TOLERANCE, 0},
{ 163, 3205576370u, 3092685191u, 0u, 4294967283u, 3219207858u, 3092685191u, 0, FREXP_TOLERANCE, 0},
{ 164, 3190678390u, 2872219490u, 0u, 4294967268u, 3220038518u, 2872219490u, 0, FREXP_TOLERANCE, 0},
{ 165, 3218315055u, 4107255722u, 0u, 4294967295u, 3219363631u, 4107255722u, 0, FREXP_TOLERANCE, 0},
{ 166, 3205337291u, 3069068345u, 0u, 4294967282u, 3220017355u, 3069068345u, 0, FREXP_TOLERANCE, 0},
{ 167, 3243990857u, 2294867524u, 0u, 23u, 3219873609u, 2294867524u, 0, FREXP_TOLERANCE, 0},
{ 168, 3216653996u, 2860384670u, 0u, 4294967293u, 3219799724u, 2860384670u, 0, FREXP_TOLERANCE, 0},
{ 169, 3193326350u, 2265437201u, 0u, 4294967271u, 3219540750u, 2265437201u, 0, FREXP_TOLERANCE, 0},
{ 170, 3240198679u, 1234948614u, 0u, 20u, 3219227159u, 1234948614u, 0, FREXP_TOLERANCE, 0},
{ 171, 3216359929u, 1186945904u, 0u, 4294967293u, 3219505657u, 1186945904u, 0, FREXP_TOLERANCE, 0},
{ 172, 3251167793u, 1896750851u, 0u, 30u, 3219710513u, 1896750851u, 0, FREXP_TOLERANCE, 0},
{ 173, 1081575478u, 3686084548u, 0u, 9u, 1072138294u, 3686084548u, 0, FREXP_TOLERANCE, 0},
{ 174, 1079286273u, 3309277689u, 0u, 7u, 1071946241u, 3309277689u, 0, FREXP_TOLERANCE, 0},
{ 175, 3223476240u, 3006860614u, 0u, 4u, 3219281936u, 3006860614u, 0, FREXP_TOLERANCE, 0},
{ 176, 3231412671u, 2504194724u, 0u, 11u, 3219878335u, 2504194724u, 0, FREXP_TOLERANCE, 0},
{ 177, 3236149260u, 1948717780u, 0u, 16u, 3219372044u, 1948717780u, 0, FREXP_TOLERANCE, 0},
{ 178, 1048317852u, 3791803982u, 0u, 4294967273u, 1072435100u, 3791803982u, 0, FREXP_TOLERANCE, 0},
{ 179, 1064345015u, 4272034420u, 0u, 4294967289u, 1071685047u, 4272034420u, 0, FREXP_TOLERANCE, 0},
{ 180, 3192982124u, 1526175922u, 0u, 4294967271u, 3219196524u, 1526175922u, 0, FREXP_TOLERANCE, 0},
{ 181, 3245817826u, 4108948538u, 0u, 25u, 3219603426u, 4108948538u, 0, FREXP_TOLERANCE, 0},
{ 182, 1104691287u, 640541190u, 0u, 31u, 1072185431u, 640541190u, 0, FREXP_TOLERANCE, 0},
{ 183, 3207257417u, 3259274853u, 0u, 4294967284u, 3219840329u, 3259274853u, 0, FREXP_TOLERANCE, 0},
{ 184, 1082507103u, 3677038020u, 0u, 10u, 1072021343u, 3677038020u, 0, FREXP_TOLERANCE, 0},
{ 185, 1083132498u, 3781708548u, 0u, 10u, 1072646738u, 3781708548u, 0, FREXP_TOLERANCE, 0},
{ 186, 1096584871u, 1207386447u, 0u, 23u, 1072467623u, 1207386447u, 0, FREXP_TOLERANCE, 0},
{ 187, 3188695272u, 3011191657u, 0u, 4294967266u, 3220152552u, 3011191657u, 0, FREXP_TOLERANCE, 0},
{ 188, 1103798670u, 1096124830u, 0u, 30u, 1072341390u, 1096124830u, 0, FREXP_TOLERANCE, 0},
{ 189, 1063235023u, 2540404725u, 0u, 4294967287u, 1072672207u, 2540404725u, 0, FREXP_TOLERANCE, 0},
{ 190, 3240157452u, 4122845725u, 0u, 20u, 3219185932u, 4122845725u, 0, FREXP_TOLERANCE, 0},
{ 191, 1083643710u, 311336721u, 0u, 11u, 1072109374u, 311336721u, 0, FREXP_TOLERANCE, 0},
{ 192, 3214382367u, 4212533768u, 0u, 4294967291u, 3219625247u, 4212533768u, 0, FREXP_TOLERANCE, 0},
{ 193, 1051139427u, 1769686293u, 0u, 4294967276u, 1072110947u, 1769686293u, 0, FREXP_TOLERANCE, 0},
{ 194, 3240200923u, 3538602249u, 0u, 20u, 3219229403u, 3538602249u, 0, FREXP_TOLERANCE, 0},
{ 195, 1078227549u, 508056696u, 0u, 6u, 1071936093u, 508056696u, 0, FREXP_TOLERANCE, 0},
{ 196, 1103793878u, 776520138u, 0u, 30u, 1072336598u, 776520138u, 0, FREXP_TOLERANCE, 0},
{ 197, 1102910577u, 4064962760u, 0u, 29u, 1072501873u, 4064962760u, 0, FREXP_TOLERANCE, 0},
{ 198, 1077424413u, 819766631u, 0u, 5u, 1072181533u, 819766631u, 0, FREXP_TOLERANCE, 0},
{ 199, 1074178362u, 2112385259u, 0u, 2u, 1072081210u, 2112385259u, 0, FREXP_TOLERANCE, 0},
{ 200, 3227593179u, 1187058516u, 0u, 8u, 3219204571u, 1187058516u, 0, FREXP_TOLERANCE, 0},
{ 201, 1082295059u, 2514398118u, 0u, 10u, 1071809299u, 2514398118u, 0, FREXP_TOLERANCE, 0},
{ 202, 1076579751u, 870169764u, 0u, 4u, 1072385447u, 870169764u, 0, FREXP_TOLERANCE, 0},
{ 203, 3246851392u, 1190259653u, 0u, 26u, 3219588416u, 1190259653u, 0, FREXP_TOLERANCE, 0},
{ 204, 1069112254u, 3417249840u, 0u, 4294967293u, 1072257982u, 3417249840u, 0, FREXP_TOLERANCE, 0},
{ 205, 3193663083u, 3467757357u, 0u, 4294967271u, 3219877483u, 3467757357u, 0, FREXP_TOLERANCE, 0},
{ 206, 3215075200u, 2168175352u, 0u, 4294967292u, 3219269504u, 2168175352u, 0, FREXP_TOLERANCE, 0},
{ 207, 3239643135u, 1508888184u, 0u, 19u, 3219720191u, 1508888184u, 0, FREXP_TOLERANCE, 0},
{ 208, 1060430241u, 3524949092u, 0u, 4294967285u, 1071964577u, 3524949092u, 0, FREXP_TOLERANCE, 0},
{ 209, 3197412883u, 166402802u, 0u, 4294967275u, 3219432979u, 166402802u, 0, FREXP_TOLERANCE, 0},
{ 210, 3237198975u, 3572369260u, 0u, 17u, 3219373183u, 3572369260u, 0, FREXP_TOLERANCE, 0},
{ 211, 1081866822u, 2441536203u, 0u, 9u, 1072429638u, 2441536203u, 0, FREXP_TOLERANCE, 0},
{ 212, 3202753937u, 3658194573u, 0u, 4294967280u, 3219531153u, 3658194573u, 0, FREXP_TOLERANCE, 0},
{ 213, 1062392908u, 2479742828u, 0u, 4294967287u, 1071830092u, 2479742828u, 0, FREXP_TOLERANCE, 0},
{ 214, 1062342831u, 4214154303u, 0u, 4294967287u, 1071780015u, 4214154303u, 0, FREXP_TOLERANCE, 0},
{ 215, 1082396794u, 426896765u, 0u, 10u, 1071911034u, 426896765u, 0, FREXP_TOLERANCE, 0},
{ 216, 1066474375u, 2201754442u, 0u, 4294967291u, 1071717255u, 2201754442u, 0, FREXP_TOLERANCE, 0},
{ 217, 3195629021u, 2055773734u, 0u, 4294967273u, 3219746269u, 2055773734u, 0, FREXP_TOLERANCE, 0},
{ 218, 3239267288u, 291396537u, 0u, 19u, 3219344344u, 291396537u, 0, FREXP_TOLERANCE, 0},
{ 219, 3236968033u, 874125203u, 0u, 17u, 3219142241u, 874125203u, 0, FREXP_TOLERANCE, 0},
{ 220, 3210508124u, 4091098764u, 0u, 4294967287u, 3219945308u, 4091098764u, 0, FREXP_TOLERANCE, 0},
{ 221, 1065716026u, 120488169u, 0u, 4294967290u, 1072007482u, 120488169u, 0, FREXP_TOLERANCE, 0},
{ 222, 3241241441u, 1985269424u, 0u, 21u, 3219221345u, 1985269424u, 0, FREXP_TOLERANCE, 0},
{ 223, 3206539410u, 2243036871u, 0u, 4294967283u, 3220170898u, 2243036871u, 0, FREXP_TOLERANCE, 0},
{ 224, 3243941101u, 740033495u, 0u, 23u, 3219823853u, 740033495u, 0, FREXP_TOLERANCE, 0},
{ 225, 3209424906u, 1176656356u, 0u, 4294967286u, 3219910666u, 1176656356u, 0, FREXP_TOLERANCE, 0},
{ 226, 1074261978u, 3588756231u, 0u, 2u, 1072164826u, 3588756231u, 0, FREXP_TOLERANCE, 0},
{ 227, 3252816791u, 3037249392u, 0u, 32u, 3219262359u, 3037249392u, 0, FREXP_TOLERANCE, 0},
{ 228, 1061635587u, 1173102190u, 0u, 4294967286u, 1072121347u, 1173102190u, 0, FREXP_TOLERANCE, 0},
{ 229, 3237209581u, 2882725208u, 0u, 17u, 3219383789u, 2882725208u, 0, FREXP_TOLERANCE, 0},
{ 230, 1071440059u, 69225090u, 0u, 4294967295u, 1072488635u, 69225090u, 0, FREXP_TOLERANCE, 0},
{ 231, 3212663474u, 272319256u, 0u, 4294967289u, 3220003506u, 272319256u, 0, FREXP_TOLERANCE, 0},
{ 232, 1072073912u, 2493997123u, 0u, 0u, 1072073912u, 2493997123u, 0, FREXP_TOLERANCE, 0},
{ 233, 1057720186u, 188610379u, 0u, 4294967282u, 1072400250u, 188610379u, 0, FREXP_TOLERANCE, 0},
{ 234, 3232757923u, 2209647371u, 0u, 12u, 3220175011u, 2209647371u, 0, FREXP_TOLERANCE, 0},
{ 235, 3236758517u, 1990439193u, 0u, 16u, 3219981301u, 1990439193u, 0, FREXP_TOLERANCE, 0},
{ 236, 1078073146u, 622849962u, 0u, 6u, 1071781690u, 622849962u, 0, FREXP_TOLERANCE, 0},
{ 237, 1057135741u, 756052458u, 0u, 4294967282u, 1071815805u, 756052458u, 0, FREXP_TOLERANCE, 0},
{ 238, 1081649113u, 2247475162u, 0u, 9u, 1072211929u, 2247475162u, 0, FREXP_TOLERANCE, 0},
{ 239, 1061623064u, 3878055211u, 0u, 4294967286u, 1072108824u, 3878055211u, 0, FREXP_TOLERANCE, 0},
{ 240, 3222407050u, 2979438623u, 0u, 3u, 3219261322u, 2979438623u, 0, FREXP_TOLERANCE, 0},
{ 241, 3195290997u, 2676398686u, 0u, 4294967273u, 3219408245u, 2676398686u, 0, FREXP_TOLERANCE, 0},
{ 242, 1105124431u, 3631096636u, 0u, 31u, 1072618575u, 3631096636u, 0, FREXP_TOLERANCE, 0},
{ 243, 1065079390u, 1697791764u, 0u, 4294967289u, 1072419422u, 1697791764u, 0, FREXP_TOLERANCE, 0},
{ 244, 3198136112u, 2299842819u, 0u, 4294967275u, 3220156208u, 2299842819u, 0, FREXP_TOLERANCE, 0},
{ 245, 1078084768u, 1931502677u, 0u, 6u, 1071793312u, 1931502677u, 0, FREXP_TOLERANCE, 0},
{ 246, 3215264397u, 3016456382u, 0u, 4294967292u, 3219458701u, 3016456382u, 0, FREXP_TOLERANCE, 0},
{ 247, 1072253426u, 343404215u, 0u, 0u, 1072253426u, 343404215u, 0, FREXP_TOLERANCE, 0},
{ 248, 1061072607u, 4266232536u, 0u, 4294967285u, 1072606943u, 4266232536u, 0, FREXP_TOLERANCE, 0},
{ 249, 3241230836u, 4140316002u, 0u, 21u, 3219210740u, 4140316002u, 0, FREXP_TOLERANCE, 0},
{ 250, 1082896196u, 868256971u, 0u, 10u, 1072410436u, 868256971u, 0, FREXP_TOLERANCE, 0},
{ 251, 1075422810u, 1864139509u, 0u, 3u, 1072277082u, 1864139509u, 0, FREXP_TOLERANCE, 0},
{ 252, 3187675097u, 3084482407u, 0u, 4294967266u, 3219132377u, 3084482407u, 0, FREXP_TOLERANCE, 0},
{ 253, 3220191323u, 2427162817u, 0u, 1u, 3219142747u, 2427162817u, 0, FREXP_TOLERANCE, 0},
{ 254, 3234748208u, 2715105792u, 0u, 14u, 3220068144u, 2715105792u, 0, FREXP_TOLERANCE, 0},
{ 255, 1064600512u, 3943389284u, 0u, 4294967289u, 1071940544u, 3943389284u, 0, FREXP_TOLERANCE, 0},
{ 256, 1046724025u, 3626825684u, 0u, 4294967272u, 1071889849u, 3626825684u, 0, FREXP_TOLERANCE, 0},
{ 257, 1045423002u, 967350972u, 0u, 4294967270u, 1072685978u, 967350972u, 0, FREXP_TOLERANCE, 0},
{ 258, 1093012318u, 448002663u, 0u, 20u, 1072040798u, 448002663u, 0, FREXP_TOLERANCE, 0},
{ 259, 3251845859u, 105058217u, 0u, 31u, 3219340003u, 105058217u, 0, FREXP_TOLERANCE, 0},
{ 260, 1069733884u, 171786224u, 0u, 4294967294u, 1071831036u, 171786224u, 0, FREXP_TOLERANCE, 0},
{ 261, 3189614508u, 2863482262u, 0u, 4294967267u, 3220023212u, 2863482262u, 0, FREXP_TOLERANCE, 0},
{ 262, 3204997271u, 877784425u, 0u, 4294967282u, 3219677335u, 877784425u, 0, FREXP_TOLERANCE, 0},
{ 263, 3202629313u, 2801782962u, 0u, 4294967280u, 3219406529u, 2801782962u, 0, FREXP_TOLERANCE, 0},
{ 264, 3213604117u, 762347195u, 0u, 4294967290u, 3219895573u, 762347195u, 0, FREXP_TOLERANCE, 0},
{ 265, 3233486727u, 2317950339u, 0u, 13u, 3219855239u, 2317950339u, 0, FREXP_TOLERANCE, 0},
{ 266, 3246333414u, 2135700283u, 0u, 25u, 3220119014u, 2135700283u, 0, FREXP_TOLERANCE, 0},
{ 267, 1056516397u, 4171919805u, 0u, 4294967281u, 1072245037u, 4171919805u, 0, FREXP_TOLERANCE, 0},
{ 268, 1082858682u, 2180920863u, 0u, 10u, 1072372922u, 2180920863u, 0, FREXP_TOLERANCE, 0},
{ 269, 3220149084u, 1918836931u, 0u, 0u, 3220149084u, 1918836931u, 0, FREXP_TOLERANCE, 0},
{ 270, 1083603224u, 3137821660u, 0u, 11u, 1072068888u, 3137821660u, 0, FREXP_TOLERANCE, 0},
{ 271, 1103902874u, 3456203663u, 0u, 30u, 1072445594u, 3456203663u, 0, FREXP_TOLERANCE, 0},
{ 272, 3235600523u, 2335688936u, 0u, 15u, 3219871883u, 2335688936u, 0, FREXP_TOLERANCE, 0},
{ 273, 1042279322u, 4170235262u, 0u, 4294967267u, 1072688026u, 4170235262u, 0, FREXP_TOLERANCE, 0},
{ 274, 1051824459u, 521583737u, 0u, 4294967277u, 1071747403u, 521583737u, 0, FREXP_TOLERANCE, 0},
{ 275, 1081348303u, 1296623194u, 0u, 9u, 1071911119u, 1296623194u, 0, FREXP_TOLERANCE, 0},
{ 276, 3250673860u, 2442872540u, 0u, 30u, 3219216580u, 2442872540u, 0, FREXP_TOLERANCE, 0},
{ 277, 1061684277u, 289979405u, 0u, 4294967286u, 1072170037u, 289979405u, 0, FREXP_TOLERANCE, 0},
{ 278, 1049514449u, 3865737145u, 0u, 4294967274u, 1072583121u, 3865737145u, 0, FREXP_TOLERANCE, 0},
{ 279, 1075298944u, 3699090239u, 0u, 3u, 1072153216u, 3699090239u, 0, FREXP_TOLERANCE, 0},
{ 280, 1054539840u, 3259249360u, 0u, 4294967279u, 1072365632u, 3259249360u, 0, FREXP_TOLERANCE, 0},
{ 281, 1096418100u, 1619819023u, 0u, 23u, 1072300852u, 1619819023u, 0, FREXP_TOLERANCE, 0},
{ 282, 1045993352u, 1022642459u, 0u, 4294967271u, 1072207752u, 1022642459u, 0, FREXP_TOLERANCE, 0},
{ 283, 1081433004u, 19455098u, 0u, 9u, 1071995820u, 19455098u, 0, FREXP_TOLERANCE, 0},
{ 284, 3229182089u, 2096003654u, 0u, 9u, 3219744905u, 2096003654u, 0, FREXP_TOLERANCE, 0},
{ 285, 1076297936u, 3803689997u, 0u, 4u, 1072103632u, 3803689997u, 0, FREXP_TOLERANCE, 0},
{ 286, 1071630912u, 2263729518u, 0u, 4294967295u, 1072679488u, 2263729518u, 0, FREXP_TOLERANCE, 0},
{ 287, 1101357261u, 2816837387u, 0u, 28u, 1071997133u, 2816837387u, 0, FREXP_TOLERANCE, 0},
{ 288, 1063422305u, 2597606398u, 0u, 4294967288u, 1071810913u, 2597606398u, 0, FREXP_TOLERANCE, 0},
{ 289, 1069100169u, 3680967506u, 0u, 4294967293u, 1072245897u, 3680967506u, 0, FREXP_TOLERANCE, 0},
{ 290, 1040201163u, 179224723u, 0u, 4294967266u, 1071658443u, 179224723u, 0, FREXP_TOLERANCE, 0},
{ 291, 3188629767u, 978126928u, 0u, 4294967266u, 3220087047u, 978126928u, 0, FREXP_TOLERANCE, 0},
{ 292, 1101553990u, 4047893399u, 0u, 28u, 1072193862u, 4047893399u, 0, FREXP_TOLERANCE, 0},
{ 293, 3222322045u, 4059818629u, 0u, 3u, 3219176317u, 4059818629u, 0, FREXP_TOLERANCE, 0},
{ 294, 1042678728u, 3640293589u, 0u, 4294967268u, 1072038856u, 3640293589u, 0, FREXP_TOLERANCE, 0},
{ 295, 3248464040u, 3383497159u, 0u, 27u, 3220152488u, 3383497159u, 0, FREXP_TOLERANCE, 0},
{ 296, 1070002807u, 1527313008u, 0u, 4294967294u, 1072099959u, 1527313008u, 0, FREXP_TOLERANCE, 0},
{ 297, 3202707679u, 2599946514u, 0u, 4294967280u, 3219484895u, 2599946514u, 0, FREXP_TOLERANCE, 0},
{ 298, 1104170406u, 2738675352u, 0u, 31u, 1071664550u, 2738675352u, 0, FREXP_TOLERANCE, 0},
{ 299, 1105232623u, 3616571377u, 0u, 32u, 1071678191u, 3616571377u, 0, FREXP_TOLERANCE, 0},
{ 300, 1060859316u, 1130603218u, 0u, 4294967285u, 1072393652u, 1130603218u, 0, FREXP_TOLERANCE, 0},
{ 301, 1076028796u, 3859211180u, 0u, 4u, 1071834492u, 3859211180u, 0, FREXP_TOLERANCE, 0},
{ 302, 1067940450u, 1744531824u, 0u, 4294967292u, 1072134754u, 1744531824u, 0, FREXP_TOLERANCE, 0},
{ 303, 1042831340u, 1958025850u, 0u, 4294967268u, 1072191468u, 1958025850u, 0, FREXP_TOLERANCE, 0},
{ 304, 3236511256u, 2472176453u, 0u, 16u, 3219734040u, 2472176453u, 0, FREXP_TOLERANCE, 0},
{ 305, 3233107089u, 182132862u, 0u, 13u, 3219475601u, 182132862u, 0, FREXP_TOLERANCE, 0},
{ 306, 3250520938u, 3924356991u, 0u, 29u, 3220112234u, 3924356991u, 0, FREXP_TOLERANCE, 0},
{ 307, 3230501884u, 35632886u, 0u, 10u, 3220016124u, 35632886u, 0, FREXP_TOLERANCE, 0},
{ 308, 3209806504u, 1453402523u, 0u, 4294967287u, 3219243688u, 1453402523u, 0, FREXP_TOLERANCE, 0},
{ 309, 1083522102u, 743225214u, 0u, 11u, 1071987766u, 743225214u, 0, FREXP_TOLERANCE, 0},
{ 310, 3202890678u, 142917400u, 0u, 4294967280u, 3219667894u, 142917400u, 0, FREXP_TOLERANCE, 0},
{ 311, 1080684976u, 1472665012u, 0u, 8u, 1072296368u, 1472665012u, 0, FREXP_TOLERANCE, 0},
{ 312, 3203138231u, 256588219u, 0u, 4294967280u, 3219915447u, 256588219u, 0, FREXP_TOLERANCE, 0},
{ 313, 1094982162u, 1062927000u, 0u, 22u, 1071913490u, 1062927000u, 0, FREXP_TOLERANCE, 0},
{ 314, 1061134072u, 931677439u, 0u, 4294967285u, 1072668408u, 931677439u, 0, FREXP_TOLERANCE, 0},
{ 315, 1058377732u, 2320910576u, 0u, 4294967283u, 1072009220u, 2320910576u, 0, FREXP_TOLERANCE, 0},
{ 316, 1055663370u, 288059864u, 0u, 4294967280u, 1072440586u, 288059864u, 0, FREXP_TOLERANCE, 0},
{ 317, 1078958093u, 1448349062u, 0u, 6u, 1072666637u, 1448349062u, 0, FREXP_TOLERANCE, 0},
{ 318, 3199478070u, 3454027134u, 0u, 4294967277u, 3219401014u, 3454027134u, 0, FREXP_TOLERANCE, 0},
{ 319, 3237458798u, 4215445172u, 0u, 17u, 3219633006u, 4215445172u, 0, FREXP_TOLERANCE, 0},
{ 320, 3196654963u, 2231888973u, 0u, 4294967274u, 3219723635u, 2231888973u, 0, FREXP_TOLERANCE, 0},
{ 321, 3246632231u, 40413554u, 0u, 26u, 3219369255u, 40413554u, 0, FREXP_TOLERANCE, 0},
{ 322, 3232578253u, 983832844u, 0u, 12u, 3219995341u, 983832844u, 0, FREXP_TOLERANCE, 0},
{ 323, 3223721534u, 3995725873u, 0u, 4u, 3219527230u, 3995725873u, 0, FREXP_TOLERANCE, 0},
{ 324, 1050082319u, 777231627u, 0u, 4294967275u, 1072102415u, 777231627u, 0, FREXP_TOLERANCE, 0},
{ 325, 1040986626u, 672789828u, 0u, 4294967266u, 1072443906u, 672789828u, 0, FREXP_TOLERANCE, 0},
{ 326, 3253385962u, 2982787335u, 0u, 32u, 3219831530u, 2982787335u, 0, FREXP_TOLERANCE, 0},
{ 327, 1068390875u, 2075971825u, 0u, 4294967292u, 1072585179u, 2075971825u, 0, FREXP_TOLERANCE, 0},
{ 328, 1070166500u, 4034633931u, 0u, 4294967294u, 1072263652u, 4034633931u, 0, FREXP_TOLERANCE, 0},
{ 329, 3210046177u, 1018222907u, 0u, 4294967287u, 3219483361u, 1018222907u, 0, FREXP_TOLERANCE, 0},
{ 330, 3244621407u, 3090050495u, 0u, 24u, 3219455583u, 3090050495u, 0, FREXP_TOLERANCE, 0},
{ 331, 1067680885u, 937732557u, 0u, 4294967292u, 1071875189u, 937732557u, 0, FREXP_TOLERANCE, 0},
{ 332, 3200798890u, 2557898276u, 0u, 4294967278u, 3219673258u, 2557898276u, 0, FREXP_TOLERANCE, 0},
{ 333, 1078342316u, 130346162u, 0u, 6u, 1072050860u, 130346162u, 0, FREXP_TOLERANCE, 0},
{ 334, 3223590310u, 275568693u, 0u, 4u, 3219396006u, 275568693u, 0, FREXP_TOLERANCE, 0},
{ 335, 1042898869u, 3807416441u, 0u, 4294967268u, 1072258997u, 3807416441u, 0, FREXP_TOLERANCE, 0},
{ 336, 1075961161u, 3706820266u, 0u, 4u, 1071766857u, 3706820266u, 0, FREXP_TOLERANCE, 0},
{ 337, 3216099005u, 1710131411u, 0u, 4294967293u, 3219244733u, 1710131411u, 0, FREXP_TOLERANCE, 0},
{ 338, 1078123323u, 1900790503u, 0u, 6u, 1071831867u, 1900790503u, 0, FREXP_TOLERANCE, 0},
{ 339, 3238819361u, 3420420033u, 0u, 18u, 3219944993u, 3420420033u, 0, FREXP_TOLERANCE, 0},
{ 340, 3210844787u, 588423066u, 0u, 4294967288u, 3219233395u, 588423066u, 0, FREXP_TOLERANCE, 0},
{ 341, 1049684114u, 1160162008u, 0u, 4294967275u, 1071704210u, 1160162008u, 0, FREXP_TOLERANCE, 0},
{ 342, 3246307879u, 4265764460u, 0u, 25u, 3220093479u, 4265764460u, 0, FREXP_TOLERANCE, 0},
{ 343, 1102543434u, 366653268u, 0u, 29u, 1072134730u, 366653268u, 0, FREXP_TOLERANCE, 0},
{ 344, 3188814424u, 466059202u, 0u, 4294967267u, 3219223128u, 466059202u, 0, FREXP_TOLERANCE, 0},
{ 345, 3226627739u, 1325936170u, 0u, 7u, 3219287707u, 1325936170u, 0, FREXP_TOLERANCE, 0},
{ 346, 3221436876u, 680097612u, 0u, 2u, 3219339724u, 680097612u, 0, FREXP_TOLERANCE, 0},
{ 347, 3240391116u, 1827735934u, 0u, 20u, 3219419596u, 1827735934u, 0, FREXP_TOLERANCE, 0},
{ 348, 3200554324u, 2875599271u, 0u, 4294967278u, 3219428692u, 2875599271u, 0, FREXP_TOLERANCE, 0},
{ 349, 3191030402u, 3117037091u, 0u, 4294967269u, 3219341954u, 3117037091u, 0, FREXP_TOLERANCE, 0},
{ 350, 3239246636u, 15838845u, 0u, 19u, 3219323692u, 15838845u, 0, FREXP_TOLERANCE, 0},
{ 351, 1051974004u, 749718883u, 0u, 4294967277u, 1071896948u, 749718883u, 0, FREXP_TOLERANCE, 0},
{ 352, 3223587064u, 1523766569u, 0u, 4u, 3219392760u, 1523766569u, 0, FREXP_TOLERANCE, 0},
{ 353, 1044833651u, 1966536294u, 0u, 4294967270u, 1072096627u, 1966536294u, 0, FREXP_TOLERANCE, 0},
{ 354, 3250158026u, 699164258u, 0u, 29u, 3219749322u, 699164258u, 0, FREXP_TOLERANCE, 0},
{ 355, 1098048435u, 3759049394u, 0u, 25u, 1071834035u, 3759049394u, 0, FREXP_TOLERANCE, 0},
{ 356, 1106085272u, 1183789499u, 0u, 32u, 1072530840u, 1183789499u, 0, FREXP_TOLERANCE, 0},
{ 357, 1081201623u, 1970107747u, 0u, 9u, 1071764439u, 1970107747u, 0, FREXP_TOLERANCE, 0},
{ 358, 1095245453u, 2308233883u, 0u, 22u, 1072176781u, 2308233883u, 0, FREXP_TOLERANCE, 0},
{ 359, 1084756444u, 1491017852u, 0u, 12u, 1072173532u, 1491017852u, 0, FREXP_TOLERANCE, 0},
{ 360, 1041444355u, 1723375725u, 0u, 4294967267u, 1071853059u, 1723375725u, 0, FREXP_TOLERANCE, 0},
{ 361, 3216630070u, 1141349287u, 0u, 4294967293u, 3219775798u, 1141349287u, 0, FREXP_TOLERANCE, 0},
{ 362, 1097465301u, 3403438584u, 0u, 24u, 1072299477u, 3403438584u, 0, FREXP_TOLERANCE, 0},
{ 363, 3230571908u, 1711085243u, 0u, 10u, 3220086148u, 1711085243u, 0, FREXP_TOLERANCE, 0},
{ 364, 3250239076u, 1377484108u, 0u, 29u, 3219830372u, 1377484108u, 0, FREXP_TOLERANCE, 0},
{ 365, 1098385019u, 2880275004u, 0u, 25u, 1072170619u, 2880275004u, 0, FREXP_TOLERANCE, 0},
{ 366, 1084039594u, 1611394950u, 0u, 11u, 1072505258u, 1611394950u, 0, FREXP_TOLERANCE, 0},
{ 367, 3234221435u, 2626629370u, 0u, 14u, 3219541371u, 2626629370u, 0, FREXP_TOLERANCE, 0},
{ 368, 1063771493u, 1499080813u, 0u, 4294967288u, 1072160101u, 1499080813u, 0, FREXP_TOLERANCE, 0},
{ 369, 1055231263u, 3936262414u, 0u, 4294967280u, 1072008479u, 3936262414u, 0, FREXP_TOLERANCE, 0},
{ 370, 1103919063u, 3175668759u, 0u, 30u, 1072461783u, 3175668759u, 0, FREXP_TOLERANCE, 0},
{ 371, 3207981719u, 1270950554u, 0u, 4294967285u, 3219516055u, 1270950554u, 0, FREXP_TOLERANCE, 0},
{ 372, 3194616071u, 3680565379u, 0u, 4294967272u, 3219781895u, 3680565379u, 0, FREXP_TOLERANCE, 0},
{ 373, 3208148223u, 1066985223u, 0u, 4294967285u, 3219682559u, 1066985223u, 0, FREXP_TOLERANCE, 0},
{ 374, 3221613219u, 4089383168u, 0u, 2u, 3219516067u, 4089383168u, 0, FREXP_TOLERANCE, 0},
{ 375, 3217058839u, 4017329311u, 0u, 4294967294u, 3219155991u, 4017329311u, 0, FREXP_TOLERANCE, 0},
{ 376, 3208334452u, 1667591498u, 0u, 4294967285u, 3219868788u, 1667591498u, 0, FREXP_TOLERANCE, 0},
{ 377, 1088164157u, 3154656624u, 0u, 15u, 1072435517u, 3154656624u, 0, FREXP_TOLERANCE, 0},
{ 378, 1061894279u, 3886344038u, 0u, 4294967286u, 1072380039u, 3886344038u, 0, FREXP_TOLERANCE, 0},
{ 379, 1050652945u, 977586119u, 0u, 4294967275u, 1072673041u, 977586119u, 0, FREXP_TOLERANCE, 0},
{ 380, 3209762784u, 953839852u, 0u, 4294967287u, 3219199968u, 953839852u, 0, FREXP_TOLERANCE, 0},
{ 381, 1104965247u, 143071571u, 0u, 31u, 1072459391u, 143071571u, 0, FREXP_TOLERANCE, 0},
{ 382, 3206165386u, 913097445u, 0u, 4294967283u, 3219796874u, 913097445u, 0, FREXP_TOLERANCE, 0},
{ 383, 3190565456u, 1371169579u, 0u, 4294967268u, 3219925584u, 1371169579u, 0, FREXP_TOLERANCE, 0},
{ 384, 1057079837u, 2594818628u, 0u, 4294967282u, 1071759901u, 2594818628u, 0, FREXP_TOLERANCE, 0},
{ 385, 3251793336u, 2259342224u, 0u, 31u, 3219287480u, 2259342224u, 0, FREXP_TOLERANCE, 0},
{ 386, 3217432469u, 1824221478u, 0u, 4294967294u, 3219529621u, 1824221478u, 0, FREXP_TOLERANCE, 0},
{ 387, 3246834775u, 1576604497u, 0u, 26u, 3219571799u, 1576604497u, 0, FREXP_TOLERANCE, 0},
{ 388, 1079368611u, 185078728u, 0u, 7u, 1072028579u, 185078728u, 0, FREXP_TOLERANCE, 0},
{ 389, 3221679427u, 444800035u, 0u, 2u, 3219582275u, 444800035u, 0, FREXP_TOLERANCE, 0},
{ 390, 3243343143u, 1734989302u, 0u, 23u, 3219225895u, 1734989302u, 0, FREXP_TOLERANCE, 0},
{ 391, 1072748883u, 130452005u, 0u, 1u, 1071700307u, 130452005u, 0, FREXP_TOLERANCE, 0},
{ 392, 1041548088u, 2158433515u, 0u, 4294967267u, 1071956792u, 2158433515u, 0, FREXP_TOLERANCE, 0},
{ 393, 3234695968u, 1941318385u, 0u, 14u, 3220015904u, 1941318385u, 0, FREXP_TOLERANCE, 0},
{ 394, 1045807374u, 792193370u, 0u, 4294967271u, 1072021774u, 792193370u, 0, FREXP_TOLERANCE, 0},
{ 395, 3238299666u, 1299392207u, 0u, 18u, 3219425298u, 1299392207u, 0, FREXP_TOLERANCE, 0},
{ 396, 3212131720u, 3205732280u, 0u, 4294967289u, 3219471752u, 3205732280u, 0, FREXP_TOLERANCE, 0},
{ 397, 1098698804u, 3035093505u, 0u, 25u, 1072484404u, 3035093505u, 0, FREXP_TOLERANCE, 0},
{ 398, 1052187689u, 3287702190u, 0u, 4294967277u, 1072110633u, 3287702190u, 0, FREXP_TOLERANCE, 0},
{ 399, 3246676260u, 2160225215u, 0u, 26u, 3219413284u, 2160225215u, 0, FREXP_TOLERANCE, 0},
{ 400, 1102624859u, 836655570u, 0u, 29u, 1072216155u, 836655570u, 0, FREXP_TOLERANCE, 0},
{ 401, 1096723626u, 3360816360u, 0u, 23u, 1072606378u, 3360816360u, 0, FREXP_TOLERANCE, 0},
{ 402, 3246176356u, 172860634u, 0u, 25u, 3219961956u, 172860634u, 0, FREXP_TOLERANCE, 0},
{ 403, 1070995788u, 146831910u, 0u, 4294967295u, 1072044364u, 146831910u, 0, FREXP_TOLERANCE, 0},
{ 404, 1051558014u, 2340722078u, 0u, 4294967276u, 1072529534u, 2340722078u, 0, FREXP_TOLERANCE, 0},
{ 405, 3230416351u, 1603798153u, 0u, 10u, 3219930591u, 1603798153u, 0, FREXP_TOLERANCE, 0},
{ 406, 3207725532u, 1099413093u, 0u, 4294967285u, 3219259868u, 1099413093u, 0, FREXP_TOLERANCE, 0},
{ 407, 3246678378u, 2429340443u, 0u, 26u, 3219415402u, 2429340443u, 0, FREXP_TOLERANCE, 0},
{ 408, 3190303581u, 3223770005u, 0u, 4294967268u, 3219663709u, 3223770005u, 0, FREXP_TOLERANCE, 0},
{ 409, 1075882959u, 955542166u, 0u, 4u, 1071688655u, 955542166u, 0, FREXP_TOLERANCE, 0},
{ 410, 3230415151u, 275583938u, 0u, 10u, 3219929391u, 275583938u, 0, FREXP_TOLERANCE, 0},
{ 411, 1092971882u, 513397822u, 0u, 20u, 1072000362u, 513397822u, 0, FREXP_TOLERANCE, 0},
{ 412, 1090646554u, 2089321329u, 0u, 18u, 1071772186u, 2089321329u, 0, FREXP_TOLERANCE, 0},
{ 413, 3193169876u, 2782073372u, 0u, 4294967271u, 3219384276u, 2782073372u, 0, FREXP_TOLERANCE, 0},
{ 414, 1046063872u, 4023829068u, 0u, 4294967271u, 1072278272u, 4023829068u, 0, FREXP_TOLERANCE, 0},
{ 415, 1098564822u, 3242223094u, 0u, 25u, 1072350422u, 3242223094u, 0, FREXP_TOLERANCE, 0},
{ 416, 3194111199u, 4264674108u, 0u, 4294967272u, 3219277023u, 4264674108u, 0, FREXP_TOLERANCE, 0},
{ 417, 3238510821u, 3506346169u, 0u, 18u, 3219636453u, 3506346169u, 0, FREXP_TOLERANCE, 0},
{ 418, 1047020885u, 1742757458u, 0u, 4294967272u, 1072186709u, 1742757458u, 0, FREXP_TOLERANCE, 0},
{ 419, 3192664477u, 1265459564u, 0u, 4294967270u, 3219927453u, 1265459564u, 0, FREXP_TOLERANCE, 0},
{ 420, 3193450280u, 3650514880u, 0u, 4294967271u, 3219664680u, 3650514880u, 0, FREXP_TOLERANCE, 0},
{ 421, 1081755890u, 1525260440u, 0u, 9u, 1072318706u, 1525260440u, 0, FREXP_TOLERANCE, 0},
{ 422, 3235452527u, 2612331392u, 0u, 15u, 3219723887u, 2612331392u, 0, FREXP_TOLERANCE, 0},
{ 423, 3248668920u, 1263613754u, 0u, 28u, 3219308792u, 1263613754u, 0, FREXP_TOLERANCE, 0},
{ 424, 3219096387u, 635677201u, 0u, 4294967295u, 3220144963u, 635677201u, 0, FREXP_TOLERANCE, 0},
{ 425, 3206272087u, 4140947288u, 0u, 4294967283u, 3219903575u, 4140947288u, 0, FREXP_TOLERANCE, 0},
{ 426, 3200792376u, 2013265346u, 0u, 4294967278u, 3219666744u, 2013265346u, 0, FREXP_TOLERANCE, 0},
{ 427, 3249974392u, 1912759945u, 0u, 29u, 3219565688u, 1912759945u, 0, FREXP_TOLERANCE, 0},
{ 428, 3237045253u, 1351396825u, 0u, 17u, 3219219461u, 1351396825u, 0, FREXP_TOLERANCE, 0},
{ 429, 3248205162u, 1001433078u, 0u, 27u, 3219893610u, 1001433078u, 0, FREXP_TOLERANCE, 0},
{ 430, 3206926643u, 2741676659u, 0u, 4294967284u, 3219509555u, 2741676659u, 0, FREXP_TOLERANCE, 0},
{ 431, 1080923606u, 1088945233u, 0u, 8u, 1072534998u, 1088945233u, 0, FREXP_TOLERANCE, 0},
{ 432, 1085095743u, 3986114865u, 0u, 12u, 1072512831u, 3986114865u, 0, FREXP_TOLERANCE, 0},
{ 433, 3215734057u, 831239754u, 0u, 4294967292u, 3219928361u, 831239754u, 0, FREXP_TOLERANCE, 0},
{ 434, 1099828675u, 3071308141u, 0u, 26u, 1072565699u, 3071308141u, 0, FREXP_TOLERANCE, 0},
{ 435, 3225834497u, 3473592372u, 0u, 6u, 3219543041u, 3473592372u, 0, FREXP_TOLERANCE, 0},
{ 436, 1102759382u, 1309576357u, 0u, 29u, 1072350678u, 1309576357u, 0, FREXP_TOLERANCE, 0},
{ 437, 3251186706u, 2042340367u, 0u, 30u, 3219729426u, 2042340367u, 0, FREXP_TOLERANCE, 0},
{ 438, 1091945628u, 2062772374u, 0u, 19u, 1072022684u, 2062772374u, 0, FREXP_TOLERANCE, 0},
{ 439, 3194765687u, 1840632537u, 0u, 4294967272u, 3219931511u, 1840632537u, 0, FREXP_TOLERANCE, 0},
{ 440, 1096533424u, 807510337u, 0u, 23u, 1072416176u, 807510337u, 0, FREXP_TOLERANCE, 0},
{ 441, 3231451722u, 144814872u, 0u, 11u, 3219917386u, 144814872u, 0, FREXP_TOLERANCE, 0},
{ 442, 3212698915u, 2282965697u, 0u, 4294967289u, 3220038947u, 2282965697u, 0, FREXP_TOLERANCE, 0},
{ 443, 1071236430u, 2552499583u, 0u, 4294967295u, 1072285006u, 2552499583u, 0, FREXP_TOLERANCE, 0},
{ 444, 3229111426u, 1470130815u, 0u, 9u, 3219674242u, 1470130815u, 0, FREXP_TOLERANCE, 0},
{ 445, 3243093065u, 2858583811u, 0u, 22u, 3220024393u, 2858583811u, 0, FREXP_TOLERANCE, 0},
{ 446, 1089760910u, 6360994u, 0u, 17u, 1071935118u, 6360994u, 0, FREXP_TOLERANCE, 0},
{ 447, 3198264929u, 1614537194u, 0u, 4294967276u, 3219236449u, 1614537194u, 0, FREXP_TOLERANCE, 0},
{ 448, 1075198900u, 4088705365u, 0u, 3u, 1072053172u, 4088705365u, 0, FREXP_TOLERANCE, 0},
{ 449, 3250939070u, 3545570051u, 0u, 30u, 3219481790u, 3545570051u, 0, FREXP_TOLERANCE, 0},
{ 450, 1065221325u, 1629217700u, 0u, 4294967289u, 1072561357u, 1629217700u, 0, FREXP_TOLERANCE, 0},
{ 451, 1072744324u, 1813392963u, 0u, 1u, 1071695748u, 1813392963u, 0, FREXP_TOLERANCE, 0},
{ 452, 3235313361u, 3772501596u, 0u, 15u, 3219584721u, 3772501596u, 0, FREXP_TOLERANCE, 0},
{ 453, 3196802686u, 2406734491u, 0u, 4294967274u, 3219871358u, 2406734491u, 0, FREXP_TOLERANCE, 0},
{ 454, 1042055360u, 89226663u, 0u, 4294967267u, 1072464064u, 89226663u, 0, FREXP_TOLERANCE, 0},
{ 455, 3195751081u, 1618759139u, 0u, 4294967273u, 3219868329u, 1618759139u, 0, FREXP_TOLERANCE, 0},
{ 456, 3194723421u, 3888234802u, 0u, 4294967272u, 3219889245u, 3888234802u, 0, FREXP_TOLERANCE, 0},
{ 457, 1055357248u, 3590035633u, 0u, 4294967280u, 1072134464u, 3590035633u, 0, FREXP_TOLERANCE, 0},
{ 458, 3212424262u, 2892456615u, 0u, 4294967289u, 3219764294u, 2892456615u, 0, FREXP_TOLERANCE, 0},
{ 459, 3189943060u, 2431246964u, 0u, 4294967268u, 3219303188u, 2431246964u, 0, FREXP_TOLERANCE, 0},
{ 460, 3241512456u, 183850734u, 0u, 21u, 3219492360u, 183850734u, 0, FREXP_TOLERANCE, 0},
{ 461, 1089501101u, 3088319870u, 0u, 17u, 1071675309u, 3088319870u, 0, FREXP_TOLERANCE, 0},
{ 462, 3211544311u, 862225364u, 0u, 4294967288u, 3219932919u, 862225364u, 0, FREXP_TOLERANCE, 0},
{ 463, 3235294664u, 3495352775u, 0u, 15u, 3219566024u, 3495352775u, 0, FREXP_TOLERANCE, 0},
{ 464, 1058576726u, 596957268u, 0u, 4294967283u, 1072208214u, 596957268u, 0, FREXP_TOLERANCE, 0},
{ 465, 1046553348u, 1839214511u, 0u, 4294967272u, 1071719172u, 1839214511u, 0, FREXP_TOLERANCE, 0},
{ 466, 3205004060u, 1923240983u, 0u, 4294967282u, 3219684124u, 1923240983u, 0, FREXP_TOLERANCE, 0},
{ 467, 1058073864u, 739619702u, 0u, 4294967283u, 1071705352u, 739619702u, 0, FREXP_TOLERANCE, 0},
{ 468, 3223356436u, 2689885273u, 0u, 4u, 3219162132u, 2689885273u, 0, FREXP_TOLERANCE, 0},
{ 469, 3200324971u, 2143376228u, 0u, 4294967278u, 3219199339u, 2143376228u, 0, FREXP_TOLERANCE, 0},
{ 470, 1098306332u, 3760236188u, 0u, 25u, 1072091932u, 3760236188u, 0, FREXP_TOLERANCE, 0},
{ 471, 1074621795u, 671680995u, 0u, 2u, 1072524643u, 671680995u, 0, FREXP_TOLERANCE, 0},
{ 472, 1091262633u, 2315535361u, 0u, 18u, 1072388265u, 2315535361u, 0, FREXP_TOLERANCE, 0},
{ 473, 3214165989u, 2493598049u, 0u, 4294967291u, 3219408869u, 2493598049u, 0, FREXP_TOLERANCE, 0},
{ 474, 3194927008u, 1689107592u, 0u, 4294967272u, 3220092832u, 1689107592u, 0, FREXP_TOLERANCE, 0},
{ 475, 3189989959u, 1578976988u, 0u, 4294967268u, 3219350087u, 1578976988u, 0, FREXP_TOLERANCE, 0},
{ 476, 1066368383u, 2117279163u, 0u, 4294967290u, 1072659839u, 2117279163u, 0, FREXP_TOLERANCE, 0},
{ 477, 3222988111u, 3425290087u, 0u, 3u, 3219842383u, 3425290087u, 0, FREXP_TOLERANCE, 0},
{ 478, 1098487295u, 1263412017u, 0u, 25u, 1072272895u, 1263412017u, 0, FREXP_TOLERANCE, 0},
{ 479, 3208432764u, 3635396812u, 0u, 4294967285u, 3219967100u, 3635396812u, 0, FREXP_TOLERANCE, 0},
{ 480, 1070999426u, 3965655689u, 0u, 4294967295u, 1072048002u, 3965655689u, 0, FREXP_TOLERANCE, 0},
{ 481, 1060196346u, 2183973116u, 0u, 4294967285u, 1071730682u, 2183973116u, 0, FREXP_TOLERANCE, 0},
{ 482, 1101098363u, 1118613350u, 0u, 28u, 1071738235u, 1118613350u, 0, FREXP_TOLERANCE, 0},
{ 483, 3221946089u, 199516350u, 0u, 2u, 3219848937u, 199516350u, 0, FREXP_TOLERANCE, 0},
{ 484, 1078368488u, 164621458u, 0u, 6u, 1072077032u, 164621458u, 0, FREXP_TOLERANCE, 0},
{ 485, 3187706018u, 3570940805u, 0u, 4294967266u, 3219163298u, 3570940805u, 0, FREXP_TOLERANCE, 0},
{ 486, 3230316437u, 3596080877u, 0u, 10u, 3219830677u, 3596080877u, 0, FREXP_TOLERANCE, 0},
{ 487, 3208209565u, 980880313u, 0u, 4294967285u, 3219743901u, 980880313u, 0, FREXP_TOLERANCE, 0},
{ 488, 1079833442u, 884465057u, 0u, 7u, 1072493410u, 884465057u, 0, FREXP_TOLERANCE, 0},
{ 489, 1099977124u, 2558179220u, 0u, 27u, 1071665572u, 2558179220u, 0, FREXP_TOLERANCE, 0},
{ 490, 1052873711u, 1233598120u, 0u, 4294967278u, 1071748079u, 1233598120u, 0, FREXP_TOLERANCE, 0},
{ 491, 1047115221u, 1909994277u, 0u, 4294967272u, 1072281045u, 1909994277u, 0, FREXP_TOLERANCE, 0},
{ 492, 1085015978u, 2991527452u, 0u, 12u, 1072433066u, 2991527452u, 0, FREXP_TOLERANCE, 0},
{ 493, 1060855260u, 1680290941u, 0u, 4294967285u, 1072389596u, 1680290941u, 0, FREXP_TOLERANCE, 0},
{ 494, 1074309900u, 2943870846u, 0u, 2u, 1072212748u, 2943870846u, 0, FREXP_TOLERANCE, 0},
{ 495, 1059496132u, 1451927357u, 0u, 4294967284u, 1072079044u, 1451927357u, 0, FREXP_TOLERANCE, 0},
{ 496, 3228615456u, 1502585517u, 0u, 9u, 3219178272u, 1502585517u, 0, FREXP_TOLERANCE, 0},
{ 497, 3236211951u, 751136990u, 0u, 16u, 3219434735u, 751136990u, 0, FREXP_TOLERANCE, 0},
{ 498, 3230392165u, 3493275472u, 0u, 10u, 3219906405u, 3493275472u, 0, FREXP_TOLERANCE, 0},
{ 499, 1098365967u, 1209623292u, 0u, 25u, 1072151567u, 1209623292u, 0, FREXP_TOLERANCE, 0},
{ 500, 3238056647u, 979495322u, 0u, 18u, 3219182279u, 979495322u, 0, FREXP_TOLERANCE, 0},
{ 501, 3250424296u, 1717672108u, 0u, 29u, 3220015592u, 1717672108u, 0, FREXP_TOLERANCE, 0},
{ 502, 1048120593u, 531240316u, 0u, 4294967273u, 1072237841u, 531240316u, 0, FREXP_TOLERANCE, 0},
{ 503, 1054174923u, 3548721654u, 0u, 4294967279u, 1072000715u, 3548721654u, 0, FREXP_TOLERANCE, 0},
{ 504, 1086112947u, 3391817224u, 0u, 13u, 1072481459u, 3391817224u, 0, FREXP_TOLERANCE, 0},
{ 505, 1077836851u, 2758195125u, 0u, 5u, 1072593971u, 2758195125u, 0, FREXP_TOLERANCE, 0},
{ 506, 1100880260u, 2028440924u, 0u, 27u, 1072568708u, 2028440924u, 0, FREXP_TOLERANCE, 0},
{ 507, 1084223893u, 2750123373u, 0u, 11u, 1072689557u, 2750123373u, 0, FREXP_TOLERANCE, 0},
{ 508, 3232200256u, 1086294931u, 0u, 12u, 3219617344u, 1086294931u, 0, FREXP_TOLERANCE, 0},
{ 509, 1043958672u, 2986160931u, 0u, 4294967269u, 1072270224u, 2986160931u, 0, FREXP_TOLERANCE, 0},
{ 510, 1076097908u, 2540046258u, 0u, 4u, 1071903604u, 2540046258u, 0, FREXP_TOLERANCE, 0},
{ 511, 3235476602u, 451471221u, 0u, 15u, 3219747962u, 451471221u, 0, FREXP_TOLERANCE, 0},
{ 512, 1064816262u, 4187644495u, 0u, 4294967289u, 1072156294u, 4187644495u, 0, FREXP_TOLERANCE, 0},
{ 513, 1099460228u, 2439500162u, 0u, 26u, 1072197252u, 2439500162u, 0, FREXP_TOLERANCE, 0},
{ 514, 1065280276u, 1979490284u, 0u, 4294967289u, 1072620308u, 1979490284u, 0, FREXP_TOLERANCE, 0},
{ 515, 1040415832u, 2283342035u, 0u, 4294967266u, 1071873112u, 2283342035u, 0, FREXP_TOLERANCE, 0},
{ 516, 1078398157u, 1345997553u, 0u, 6u, 1072106701u, 1345997553u, 0, FREXP_TOLERANCE, 0},
{ 517, 3213249348u, 179066662u, 0u, 4294967290u, 3219540804u, 179066662u, 0, FREXP_TOLERANCE, 0},
{ 518, 1103272172u, 1217337578u, 0u, 30u, 1071814892u, 1217337578u, 0, FREXP_TOLERANCE, 0},
{ 519, 3211562377u, 3779303391u, 0u, 4294967288u, 3219950985u, 3779303391u, 0, FREXP_TOLERANCE, 0},
{ 520, 3210023352u, 3115946280u, 0u, 4294967287u, 3219460536u, 3115946280u, 0, FREXP_TOLERANCE, 0},
{ 521, 3192989874u, 286247089u, 0u, 4294967271u, 3219204274u, 286247089u, 0, FREXP_TOLERANCE, 0},
{ 522, 1085153597u, 713645369u, 0u, 12u, 1072570685u, 713645369u, 0, FREXP_TOLERANCE, 0},
{ 523, 1093670500u, 1468283899u, 0u, 21u, 1071650404u, 1468283899u, 0, FREXP_TOLERANCE, 0},
{ 524, 1042831668u, 2022736418u, 0u, 4294967268u, 1072191796u, 2022736418u, 0, FREXP_TOLERANCE, 0},
{ 525, 1083139105u, 3305564080u, 0u, 10u, 1072653345u, 3305564080u, 0, FREXP_TOLERANCE, 0},
{ 526, 1065483445u, 482392433u, 0u, 4294967290u, 1071774901u, 482392433u, 0, FREXP_TOLERANCE, 0},
{ 527, 3201695807u, 2256346551u, 0u, 4294967279u, 3219521599u, 2256346551u, 0, FREXP_TOLERANCE, 0},
{ 528, 3222430705u, 2071674991u, 0u, 3u, 3219284977u, 2071674991u, 0, FREXP_TOLERANCE, 0},
{ 529, 3204024695u, 2295269094u, 0u, 4294967281u, 3219753335u, 2295269094u, 0, FREXP_TOLERANCE, 0},
{ 530, 1084451053u, 2773103941u, 0u, 12u, 1071868141u, 2773103941u, 0, FREXP_TOLERANCE, 0},
{ 531, 1078173946u, 1482721827u, 0u, 6u, 1071882490u, 1482721827u, 0, FREXP_TOLERANCE, 0},
{ 532, 1092243422u, 3125409590u, 0u, 19u, 1072320478u, 3125409590u, 0, FREXP_TOLERANCE, 0},
{ 533, 3221065973u, 1381740563u, 0u, 1u, 3220017397u, 1381740563u, 0, FREXP_TOLERANCE, 0},
{ 534, 1071545057u, 2918235653u, 0u, 4294967295u, 1072593633u, 2918235653u, 0, FREXP_TOLERANCE, 0},
{ 535, 3238715972u, 1105857967u, 0u, 18u, 3219841604u, 1105857967u, 0, FREXP_TOLERANCE, 0},
{ 536, 3241990046u, 2703723225u, 0u, 21u, 3219969950u, 2703723225u, 0, FREXP_TOLERANCE, 0},
{ 537, 1043015571u, 174689677u, 0u, 4294967268u, 1072375699u, 174689677u, 0, FREXP_TOLERANCE, 0},
{ 538, 1079333374u, 3947057014u, 0u, 7u, 1071993342u, 3947057014u, 0, FREXP_TOLERANCE, 0},
{ 539, 1090461859u, 2023082423u, 0u, 17u, 1072636067u, 2023082423u, 0, FREXP_TOLERANCE, 0},
{ 540, 3242081486u, 1169047927u, 0u, 21u, 3220061390u, 1169047927u, 0, FREXP_TOLERANCE, 0},
{ 541, 1064525899u, 3742487766u, 0u, 4294967289u, 1071865931u, 3742487766u, 0, FREXP_TOLERANCE, 0},
{ 542, 1043425732u, 194972788u, 0u, 4294967269u, 1071737284u, 194972788u, 0, FREXP_TOLERANCE, 0},
{ 543, 3213791827u, 2136071361u, 0u, 4294967290u, 3220083283u, 2136071361u, 0, FREXP_TOLERANCE, 0},
{ 544, 3211529757u, 993675115u, 0u, 4294967288u, 3219918365u, 993675115u, 0, FREXP_TOLERANCE, 0},
{ 545, 3213663381u, 210772141u, 0u, 4294967290u, 3219954837u, 210772141u, 0, FREXP_TOLERANCE, 0},
{ 546, 3241441539u, 580731413u, 0u, 21u, 3219421443u, 580731413u, 0, FREXP_TOLERANCE, 0},
{ 547, 1093840413u, 1751560711u, 0u, 21u, 1071820317u, 1751560711u, 0, FREXP_TOLERANCE, 0},
{ 548, 1074522705u, 180987057u, 0u, 2u, 1072425553u, 180987057u, 0, FREXP_TOLERANCE, 0},
{ 549, 1066754591u, 2552236599u, 0u, 4294967291u, 1071997471u, 2552236599u, 0, FREXP_TOLERANCE, 0},
{ 550, 1088658621u, 2112468655u, 0u, 16u, 1071881405u, 2112468655u, 0, FREXP_TOLERANCE, 0},
{ 551, 3189290617u, 1578223762u, 0u, 4294967267u, 3219699321u, 1578223762u, 0, FREXP_TOLERANCE, 0},
{ 552, 3224596567u, 2456166162u, 0u, 5u, 3219353687u, 2456166162u, 0, FREXP_TOLERANCE, 0},
{ 553, 1058506965u, 2110924310u, 0u, 4294967283u, 1072138453u, 2110924310u, 0, FREXP_TOLERANCE, 0},
{ 554, 1086207177u, 3161208323u, 0u, 13u, 1072575689u, 3161208323u, 0, FREXP_TOLERANCE, 0},
{ 555, 3231863394u, 2352173188u, 0u, 12u, 3219280482u, 2352173188u, 0, FREXP_TOLERANCE, 0},
{ 556, 1079361728u, 4070222179u, 0u, 7u, 1072021696u, 4070222179u, 0, FREXP_TOLERANCE, 0},
{ 557, 1101012904u, 2481562701u, 0u, 28u, 1071652776u, 2481562701u, 0, FREXP_TOLERANCE, 0},
{ 558, 1090937016u, 3809489716u, 0u, 18u, 1072062648u, 3809489716u, 0, FREXP_TOLERANCE, 0},
{ 559, 3197002651u, 330905705u, 0u, 4294967274u, 3220071323u, 330905705u, 0, FREXP_TOLERANCE, 0},
{ 560, 1086260896u, 90264431u, 0u, 13u, 1072629408u, 90264431u, 0, FREXP_TOLERANCE, 0},
{ 561, 1040729961u, 4162008079u, 0u, 4294967266u, 1072187241u, 4162008079u, 0, FREXP_TOLERANCE, 0},
{ 562, 3194387916u, 759522153u, 0u, 4294967272u, 3219553740u, 759522153u, 0, FREXP_TOLERANCE, 0},
{ 563, 1081015037u, 1839697482u, 0u, 8u, 1072626429u, 1839697482u, 0, FREXP_TOLERANCE, 0},
{ 564, 3216442625u, 2211508949u, 0u, 4294967293u, 3219588353u, 2211508949u, 0, FREXP_TOLERANCE, 0},
{ 565, 3249807211u, 3736863454u, 0u, 29u, 3219398507u, 3736863454u, 0, FREXP_TOLERANCE, 0},
{ 566, 1063475914u, 3150741666u, 0u, 4294967288u, 1071864522u, 3150741666u, 0, FREXP_TOLERANCE, 0},
{ 567, 1060785883u, 4200269406u, 0u, 4294967285u, 1072320219u, 4200269406u, 0, FREXP_TOLERANCE, 0},
{ 568, 3236646101u, 1061812176u, 0u, 16u, 3219868885u, 1061812176u, 0, FREXP_TOLERANCE, 0},
{ 569, 1080217979u, 106027290u, 0u, 8u, 1071829371u, 106027290u, 0, FREXP_TOLERANCE, 0},
{ 570, 3234978297u, 2245237549u, 0u, 15u, 3219249657u, 2245237549u, 0, FREXP_TOLERANCE, 0},
{ 571, 3246984334u, 2132131375u, 0u, 26u, 3219721358u, 2132131375u, 0, FREXP_TOLERANCE, 0},
{ 572, 3250483427u, 3449276437u, 0u, 29u, 3220074723u, 3449276437u, 0, FREXP_TOLERANCE, 0},
{ 573, 1089388778u, 2334440944u, 0u, 16u, 1072611562u, 2334440944u, 0, FREXP_TOLERANCE, 0},
{ 574, 1105423490u, 4004336184u, 0u, 32u, 1071869058u, 4004336184u, 0, FREXP_TOLERANCE, 0},
{ 575, 3218772704u, 4090088208u, 0u, 4294967295u, 3219821280u, 4090088208u, 0, FREXP_TOLERANCE, 0},
{ 576, 1042030013u, 3898658299u, 0u, 4294967267u, 1072438717u, 3898658299u, 0, FREXP_TOLERANCE, 0},
{ 577, 3207908064u, 2272831437u, 0u, 4294967285u, 3219442400u, 2272831437u, 0, FREXP_TOLERANCE, 0},
{ 578, 3253082595u, 2639188641u, 0u, 32u, 3219528163u, 2639188641u, 0, FREXP_TOLERANCE, 0},
{ 579, 1054766684u, 1856594168u, 0u, 4294967279u, 1072592476u, 1856594168u, 0, FREXP_TOLERANCE, 0},
{ 580, 3189515294u, 4101853676u, 0u, 4294967267u, 3219923998u, 4101853676u, 0, FREXP_TOLERANCE, 0},
{ 581, 1076012412u, 2211699255u, 0u, 4u, 1071818108u, 2211699255u, 0, FREXP_TOLERANCE, 0},
{ 582, 3195060344u, 3865018604u, 0u, 4294967273u, 3219177592u, 3865018604u, 0, FREXP_TOLERANCE, 0},
{ 583, 3242767010u, 996259334u, 0u, 22u, 3219698338u, 996259334u, 0, FREXP_TOLERANCE, 0},
{ 584, 3241496889u, 3782673116u, 0u, 21u, 3219476793u, 3782673116u, 0, FREXP_TOLERANCE, 0},
{ 585, 1099130747u, 3840380763u, 0u, 26u, 1071867771u, 3840380763u, 0, FREXP_TOLERANCE, 0},
{ 586, 1048674041u, 550040067u, 0u, 4294967274u, 1071742713u, 550040067u, 0, FREXP_TOLERANCE, 0},
{ 587, 3251419593u, 95874100u, 0u, 30u, 3219962313u, 95874100u, 0, FREXP_TOLERANCE, 0},
{ 588, 3237232828u, 2645647822u, 0u, 17u, 3219407036u, 2645647822u, 0, FREXP_TOLERANCE, 0},
{ 589, 1043665640u, 3441419500u, 0u, 4294967269u, 1071977192u, 3441419500u, 0, FREXP_TOLERANCE, 0},
{ 590, 3252367038u, 876710419u, 0u, 31u, 3219861182u, 876710419u, 0, FREXP_TOLERANCE, 0},
{ 591, 3238593552u, 2560836004u, 0u, 18u, 3219719184u, 2560836004u, 0, FREXP_TOLERANCE, 0},
{ 592, 3199616543u, 1180840586u, 0u, 4294967277u, 3219539487u, 1180840586u, 0, FREXP_TOLERANCE, 0},
{ 593, 3221602966u, 2218230392u, 0u, 2u, 3219505814u, 2218230392u, 0, FREXP_TOLERANCE, 0},
{ 594, 3227485787u, 3947214579u, 0u, 7u, 3220145755u, 3947214579u, 0, FREXP_TOLERANCE, 0},
{ 595, 1079539654u, 1447312532u, 0u, 7u, 1072199622u, 1447312532u, 0, FREXP_TOLERANCE, 0},
{ 596, 1081476588u, 780366847u, 0u, 9u, 1072039404u, 780366847u, 0, FREXP_TOLERANCE, 0},
{ 597, 1072569643u, 2842113832u, 0u, 0u, 1072569643u, 2842113832u, 0, FREXP_TOLERANCE, 0},
{ 598, 3216156731u, 225159029u, 0u, 4294967293u, 3219302459u, 225159029u, 0, FREXP_TOLERANCE, 0},
{ 599, 1098117193u, 1601981129u, 0u, 25u, 1071902793u, 1601981129u, 0, FREXP_TOLERANCE, 0},
{ 600, 3234628869u, 2236538344u, 0u, 14u, 3219948805u, 2236538344u, 0, FREXP_TOLERANCE, 0},
{ 601, 1085173524u, 2194185737u, 0u, 12u, 1072590612u, 2194185737u, 0, FREXP_TOLERANCE, 0},
{ 602, 3242362684u, 87913366u, 0u, 22u, 3219294012u, 87913366u, 0, FREXP_TOLERANCE, 0},
{ 603, 3199083880u, 1346862963u, 0u, 4294967276u, 3220055400u, 1346862963u, 0, FREXP_TOLERANCE, 0},
{ 604, 1077836259u, 3604666660u, 0u, 5u, 1072593379u, 3604666660u, 0, FREXP_TOLERANCE, 0},
{ 605, 3212255979u, 3115209742u, 0u, 4294967289u, 3219596011u, 3115209742u, 0, FREXP_TOLERANCE, 0},
{ 606, 1099332326u, 1325101950u, 0u, 26u, 1072069350u, 1325101950u, 0, FREXP_TOLERANCE, 0},
{ 607, 3224546042u, 3889223100u, 0u, 5u, 3219303162u, 3889223100u, 0, FREXP_TOLERANCE, 0},
{ 608, 1053247613u, 3371396923u, 0u, 4294967278u, 1072121981u, 3371396923u, 0, FREXP_TOLERANCE, 0},
{ 609, 3220477868u, 4163120793u, 0u, 1u, 3219429292u, 4163120793u, 0, FREXP_TOLERANCE, 0},
{ 610, 1075022670u, 1387631215u, 0u, 3u, 1071876942u, 1387631215u, 0, FREXP_TOLERANCE, 0},
{ 611, 3205481779u, 1532426189u, 0u, 4294967282u, 3220161843u, 1532426189u, 0, FREXP_TOLERANCE, 0},
{ 612, 1063168268u, 3397022615u, 0u, 4294967287u, 1072605452u, 3397022615u, 0, FREXP_TOLERANCE, 0},
{ 613, 3201033321u, 89324166u, 0u, 4294967278u, 3219907689u, 89324166u, 0, FREXP_TOLERANCE, 0},
{ 614, 1079206060u, 3429424710u, 0u, 7u, 1071866028u, 3429424710u, 0, FREXP_TOLERANCE, 0},
{ 615, 3192325102u, 747591401u, 0u, 4294967270u, 3219588078u, 747591401u, 0, FREXP_TOLERANCE, 0},
{ 616, 1072238381u, 2803213904u, 0u, 0u, 1072238381u, 2803213904u, 0, FREXP_TOLERANCE, 0},
{ 617, 1091113780u, 271904221u, 0u, 18u, 1072239412u, 271904221u, 0, FREXP_TOLERANCE, 0},
{ 618, 1044258318u, 1858545114u, 0u, 4294967269u, 1072569870u, 1858545114u, 0, FREXP_TOLERANCE, 0},
{ 619, 3228068914u, 314958082u, 0u, 8u, 3219680306u, 314958082u, 0, FREXP_TOLERANCE, 0},
{ 620, 3249912496u, 2966213175u, 0u, 29u, 3219503792u, 2966213175u, 0, FREXP_TOLERANCE, 0},
{ 621, 3197179414u, 3119528953u, 0u, 4294967275u, 3219199510u, 3119528953u, 0, FREXP_TOLERANCE, 0},
{ 622, 3217179014u, 2908718240u, 0u, 4294967294u, 3219276166u, 2908718240u, 0, FREXP_TOLERANCE, 0},
{ 623, 3242467576u, 2018361566u, 0u, 22u, 3219398904u, 2018361566u, 0, FREXP_TOLERANCE, 0},
{ 624, 1100926600u, 3985805054u, 0u, 27u, 1072615048u, 3985805054u, 0, FREXP_TOLERANCE, 0},
{ 625, 1070132580u, 409584884u, 0u, 4294967294u, 1072229732u, 409584884u, 0, FREXP_TOLERANCE, 0},
{ 626, 3239758947u, 755795129u, 0u, 19u, 3219836003u, 755795129u, 0, FREXP_TOLERANCE, 0},
{ 627, 1075772446u, 1819156379u, 0u, 3u, 1072626718u, 1819156379u, 0, FREXP_TOLERANCE, 0},
{ 628, 3251342302u, 2982669005u, 0u, 30u, 3219885022u, 2982669005u, 0, FREXP_TOLERANCE, 0},
{ 629, 1101563433u, 2080534280u, 0u, 28u, 1072203305u, 2080534280u, 0, FREXP_TOLERANCE, 0},
{ 630, 3188254060u, 449171797u, 0u, 4294967266u, 3219711340u, 449171797u, 0, FREXP_TOLERANCE, 0},
{ 631, 1095956900u, 168744837u, 0u, 23u, 1071839652u, 168744837u, 0, FREXP_TOLERANCE, 0},
{ 632, 3214950009u, 1322217822u, 0u, 4294967292u, 3219144313u, 1322217822u, 0, FREXP_TOLERANCE, 0},
{ 633, 3254226900u, 3250487255u, 0u, 33u, 3219623892u, 3250487255u, 0, FREXP_TOLERANCE, 0},
{ 634, 1062120700u, 1876195180u, 0u, 4294967286u, 1072606460u, 1876195180u, 0, FREXP_TOLERANCE, 0},
{ 635, 3226343480u, 1336400247u, 0u, 6u, 3220052024u, 1336400247u, 0, FREXP_TOLERANCE, 0},
{ 636, 1098057903u, 3314079581u, 0u, 25u, 1071843503u, 3314079581u, 0, FREXP_TOLERANCE, 0},
{ 637, 3203678820u, 265025555u, 0u, 4294967281u, 3219407460u, 265025555u, 0, FREXP_TOLERANCE, 0},
{ 638, 1063854282u, 3779482256u, 0u, 4294967288u, 1072242890u, 3779482256u, 0, FREXP_TOLERANCE, 0},
{ 639, 1067300501u, 887044257u, 0u, 4294967291u, 1072543381u, 887044257u, 0, FREXP_TOLERANCE, 0},
{ 640, 1054789618u, 2732056261u, 0u, 4294967279u, 1072615410u, 2732056261u, 0, FREXP_TOLERANCE, 0},
{ 641, 1050106742u, 4027115185u, 0u, 4294967275u, 1072126838u, 4027115185u, 0, FREXP_TOLERANCE, 0},
{ 642, 3191764868u, 2940199511u, 0u, 4294967269u, 3220076420u, 2940199511u, 0, FREXP_TOLERANCE, 0},
{ 643, 3202500155u, 2875684421u, 0u, 4294967280u, 3219277371u, 2875684421u, 0, FREXP_TOLERANCE, 0},
{ 644, 3227459837u, 2251967570u, 0u, 7u, 3220119805u, 2251967570u, 0, FREXP_TOLERANCE, 0},
{ 645, 1063244412u, 284173546u, 0u, 4294967287u, 1072681596u, 284173546u, 0, FREXP_TOLERANCE, 0},
{ 646, 3238823679u, 3557800647u, 0u, 18u, 3219949311u, 3557800647u, 0, FREXP_TOLERANCE, 0},
{ 647, 1101458560u, 3147771266u, 0u, 28u, 1072098432u, 3147771266u, 0, FREXP_TOLERANCE, 0},
{ 648, 3220110464u, 2933364246u, 0u, 0u, 3220110464u, 2933364246u, 0, FREXP_TOLERANCE, 0},
{ 649, 1064853160u, 3366183281u, 0u, 4294967289u, 1072193192u, 3366183281u, 0, FREXP_TOLERANCE, 0},
{ 650, 3234870843u, 537442654u, 0u, 15u, 3219142203u, 537442654u, 0, FREXP_TOLERANCE, 0},
{ 651, 3244118788u, 2529029548u, 0u, 23u, 3220001540u, 2529029548u, 0, FREXP_TOLERANCE, 0},
{ 652, 3249882819u, 3781513577u, 0u, 29u, 3219474115u, 3781513577u, 0, FREXP_TOLERANCE, 0},
{ 653, 3213436354u, 1080845539u, 0u, 4294967290u, 3219727810u, 1080845539u, 0, FREXP_TOLERANCE, 0},
{ 654, 3206760016u, 911778687u, 0u, 4294967284u, 3219342928u, 911778687u, 0, FREXP_TOLERANCE, 0},
{ 655, 3191951036u, 469586759u, 0u, 4294967270u, 3219214012u, 469586759u, 0, FREXP_TOLERANCE, 0},
{ 656, 1091830022u, 3080528840u, 0u, 19u, 1071907078u, 3080528840u, 0, FREXP_TOLERANCE, 0},
{ 657, 1080249104u, 2863108169u, 0u, 8u, 1071860496u, 2863108169u, 0, FREXP_TOLERANCE, 0},
{ 658, 3225605506u, 2508274250u, 0u, 6u, 3219314050u, 2508274250u, 0, FREXP_TOLERANCE, 0},
{ 659, 3210826984u, 4080017377u, 0u, 4294967288u, 3219215592u, 4080017377u, 0, FREXP_TOLERANCE, 0},
{ 660, 3206492941u, 1470284690u, 0u, 4294967283u, 3220124429u, 1470284690u, 0, FREXP_TOLERANCE, 0},
{ 661, 3207120390u, 3867917386u, 0u, 4294967284u, 3219703302u, 3867917386u, 0, FREXP_TOLERANCE, 0},
{ 662, 1102054928u, 3504746045u, 0u, 29u, 1071646224u, 3504746045u, 0, FREXP_TOLERANCE, 0},
{ 663, 1064522279u, 2962134101u, 0u, 4294967289u, 1071862311u, 2962134101u, 0, FREXP_TOLERANCE, 0},
{ 664, 3244741577u, 3390537350u, 0u, 24u, 3219575753u, 3390537350u, 0, FREXP_TOLERANCE, 0},
{ 665, 1088201813u, 1702237980u, 0u, 15u, 1072473173u, 1702237980u, 0, FREXP_TOLERANCE, 0},
{ 666, 1071598971u, 1102587474u, 0u, 4294967295u, 1072647547u, 1102587474u, 0, FREXP_TOLERANCE, 0},
{ 667, 3202970118u, 2180218657u, 0u, 4294967280u, 3219747334u, 2180218657u, 0, FREXP_TOLERANCE, 0},
{ 668, 3211592260u, 1206527853u, 0u, 4294967288u, 3219980868u, 1206527853u, 0, FREXP_TOLERANCE, 0},
{ 669, 3197084744u, 394130786u, 0u, 4294967274u, 3220153416u, 394130786u, 0, FREXP_TOLERANCE, 0},
{ 670, 3242511482u, 2437699868u, 0u, 22u, 3219442810u, 2437699868u, 0, FREXP_TOLERANCE, 0},
{ 671, 1044237059u, 849581558u, 0u, 4294967269u, 1072548611u, 849581558u, 0, FREXP_TOLERANCE, 0},
{ 672, 3252006507u, 2008614943u, 0u, 31u, 3219500651u, 2008614943u, 0, FREXP_TOLERANCE, 0},
{ 673, 3210140014u, 3128971673u, 0u, 4294967287u, 3219577198u, 3128971673u, 0, FREXP_TOLERANCE, 0},
{ 674, 3249137531u, 2773583059u, 0u, 28u, 3219777403u, 2773583059u, 0, FREXP_TOLERANCE, 0},
{ 675, 1085029866u, 590727700u, 0u, 12u, 1072446954u, 590727700u, 0, FREXP_TOLERANCE, 0},
{ 676, 3248651761u, 2183878539u, 0u, 28u, 3219291633u, 2183878539u, 0, FREXP_TOLERANCE, 0},
{ 677, 1101098629u, 820687580u, 0u, 28u, 1071738501u, 820687580u, 0, FREXP_TOLERANCE, 0},
{ 678, 3208143496u, 1402434664u, 0u, 4294967285u, 3219677832u, 1402434664u, 0, FREXP_TOLERANCE, 0},
{ 679, 3252290835u, 1873709254u, 0u, 31u, 3219784979u, 1873709254u, 0, FREXP_TOLERANCE, 0},
{ 680, 3245167989u, 44275991u, 0u, 24u, 3220002165u, 44275991u, 0, FREXP_TOLERANCE, 0},
{ 681, 3189668753u, 1174874204u, 0u, 4294967267u, 3220077457u, 1174874204u, 0, FREXP_TOLERANCE, 0},
{ 682, 3208263730u, 2360372288u, 0u, 4294967285u, 3219798066u, 2360372288u, 0, FREXP_TOLERANCE, 0},
{ 683, 1103854676u, 937573440u, 0u, 30u, 1072397396u, 937573440u, 0, FREXP_TOLERANCE, 0},
{ 684, 3208953761u, 211240241u, 0u, 4294967286u, 3219439521u, 211240241u, 0, FREXP_TOLERANCE, 0},
{ 685, 3243548934u, 2469774991u, 0u, 23u, 3219431686u, 2469774991u, 0, FREXP_TOLERANCE, 0},
{ 686, 1043117070u, 3380071805u, 0u, 4294967268u, 1072477198u, 3380071805u, 0, FREXP_TOLERANCE, 0},
{ 687, 1058121042u, 442507560u, 0u, 4294967283u, 1071752530u, 442507560u, 0, FREXP_TOLERANCE, 0},
{ 688, 3254252803u, 3257889649u, 0u, 33u, 3219649795u, 3257889649u, 0, FREXP_TOLERANCE, 0},
{ 689, 1068850520u, 1854921625u, 0u, 4294967293u, 1071996248u, 1854921625u, 0, FREXP_TOLERANCE, 0},
{ 690, 1049810168u, 2729627545u, 0u, 4294967275u, 1071830264u, 2729627545u, 0, FREXP_TOLERANCE, 0},
{ 691, 3254712629u, 4001809575u, 0u, 33u, 3220109621u, 4001809575u, 0, FREXP_TOLERANCE, 0},
{ 692, 3240128649u, 278261523u, 0u, 20u, 3219157129u, 278261523u, 0, FREXP_TOLERANCE, 0},
{ 693, 1087224694u, 1793907966u, 0u, 14u, 1072544630u, 1793907966u, 0, FREXP_TOLERANCE, 0},
{ 694, 3238955714u, 398859249u, 0u, 18u, 3220081346u, 398859249u, 0, FREXP_TOLERANCE, 0},
{ 695, 3200952547u, 2511916952u, 0u, 4294967278u, 3219826915u, 2511916952u, 0, FREXP_TOLERANCE, 0},
{ 696, 3219195283u, 1697158299u, 0u, 0u, 3219195283u, 1697158299u, 0, FREXP_TOLERANCE, 0},
{ 697, 1069985548u, 3230931724u, 0u, 4294967294u, 1072082700u, 3230931724u, 0, FREXP_TOLERANCE, 0},
{ 698, 3243897690u, 3508781585u, 0u, 23u, 3219780442u, 3508781585u, 0, FREXP_TOLERANCE, 0},
{ 699, 1103847606u, 1674254897u, 0u, 30u, 1072390326u, 1674254897u, 0, FREXP_TOLERANCE, 0},
{ 700, 1046547577u, 217148561u, 0u, 4294967272u, 1071713401u, 217148561u, 0, FREXP_TOLERANCE, 0},
{ 701, 3211263954u, 3275604304u, 0u, 4294967288u, 3219652562u, 3275604304u, 0, FREXP_TOLERANCE, 0},
{ 702, 3194840159u, 2991205850u, 0u, 4294967272u, 3220005983u, 2991205850u, 0, FREXP_TOLERANCE, 0},
{ 703, 3195249375u, 3509997278u, 0u, 4294967273u, 3219366623u, 3509997278u, 0, FREXP_TOLERANCE, 0},
{ 704, 3248888030u, 3897986511u, 0u, 28u, 3219527902u, 3897986511u, 0, FREXP_TOLERANCE, 0},
{ 705, 1047182435u, 2156824613u, 0u, 4294967272u, 1072348259u, 2156824613u, 0, FREXP_TOLERANCE, 0},
{ 706, 1042295665u, 1239257646u, 0u, 4294967268u, 1071655793u, 1239257646u, 0, FREXP_TOLERANCE, 0},
{ 707, 3213264085u, 1073153314u, 0u, 4294967290u, 3219555541u, 1073153314u, 0, FREXP_TOLERANCE, 0},
{ 708, 3250031627u, 2567234990u, 0u, 29u, 3219622923u, 2567234990u, 0, FREXP_TOLERANCE, 0},
{ 709, 3190593412u, 4261696995u, 0u, 4294967268u, 3219953540u, 4261696995u, 0, FREXP_TOLERANCE, 0},
{ 710, 3197784432u, 323702024u, 0u, 4294967275u, 3219804528u, 323702024u, 0, FREXP_TOLERANCE, 0},
{ 711, 3243690997u, 4075177615u, 0u, 23u, 3219573749u, 4075177615u, 0, FREXP_TOLERANCE, 0},
{ 712, 3202791065u, 1919006082u, 0u, 4294967280u, 3219568281u, 1919006082u, 0, FREXP_TOLERANCE, 0},
{ 713, 3239270013u, 386429966u, 0u, 19u, 3219347069u, 386429966u, 0, FREXP_TOLERANCE, 0},
{ 714, 1086504491u, 3698826164u, 0u, 14u, 1071824427u, 3698826164u, 0, FREXP_TOLERANCE, 0},
{ 715, 1078327190u, 1681986446u, 0u, 6u, 1072035734u, 1681986446u, 0, FREXP_TOLERANCE, 0},
{ 716, 3194985869u, 3072950140u, 0u, 4294967272u, 3220151693u, 3072950140u, 0, FREXP_TOLERANCE, 0},
{ 717, 3217311933u, 3719038997u, 0u, 4294967294u, 3219409085u, 3719038997u, 0, FREXP_TOLERANCE, 0},
{ 718, 1055433962u, 3331415058u, 0u, 4294967280u, 1072211178u, 3331415058u, 0, FREXP_TOLERANCE, 0},
{ 719, 1060749713u, 2420250111u, 0u, 4294967285u, 1072284049u, 2420250111u, 0, FREXP_TOLERANCE, 0},
{ 720, 3238002206u, 1928661079u, 0u, 17u, 3220176414u, 1928661079u, 0, FREXP_TOLERANCE, 0},
{ 721, 1081914210u, 3679866727u, 0u, 9u, 1072477026u, 3679866727u, 0, FREXP_TOLERANCE, 0},
{ 722, 3227386672u, 1273835792u, 0u, 7u, 3220046640u, 1273835792u, 0, FREXP_TOLERANCE, 0},
{ 723, 1041622738u, 2682092368u, 0u, 4294967267u, 1072031442u, 2682092368u, 0, FREXP_TOLERANCE, 0},
{ 724, 3234222284u, 1325425811u, 0u, 14u, 3219542220u, 1325425811u, 0, FREXP_TOLERANCE, 0},
{ 725, 1056312613u, 4175172697u, 0u, 4294967281u, 1072041253u, 4175172697u, 0, FREXP_TOLERANCE, 0},
{ 726, 3208346191u, 2130706153u, 0u, 4294967285u, 3219880527u, 2130706153u, 0, FREXP_TOLERANCE, 0},
{ 727, 1092089624u, 1200784450u, 0u, 19u, 1072166680u, 1200784450u, 0, FREXP_TOLERANCE, 0},
{ 728, 1083605096u, 1248595607u, 0u, 11u, 1072070760u, 1248595607u, 0, FREXP_TOLERANCE, 0},
{ 729, 3213890863u, 1897285171u, 0u, 4294967291u, 3219133743u, 1897285171u, 0, FREXP_TOLERANCE, 0},
{ 730, 3251296075u, 944966123u, 0u, 30u, 3219838795u, 944966123u, 0, FREXP_TOLERANCE, 0},
{ 731, 3241371250u, 2270747330u, 0u, 21u, 3219351154u, 2270747330u, 0, FREXP_TOLERANCE, 0},
{ 732, 3230692631u, 422503284u, 0u, 11u, 3219158295u, 422503284u, 0, FREXP_TOLERANCE, 0},
{ 733, 1084120037u, 2857564741u, 0u, 11u, 1072585701u, 2857564741u, 0, FREXP_TOLERANCE, 0},
{ 734, 1075647403u, 3308906709u, 0u, 3u, 1072501675u, 3308906709u, 0, FREXP_TOLERANCE, 0},
{ 735, 3203475098u, 1380066948u, 0u, 4294967281u, 3219203738u, 1380066948u, 0, FREXP_TOLERANCE, 0},
{ 736, 3232612906u, 2613634294u, 0u, 12u, 3220029994u, 2613634294u, 0, FREXP_TOLERANCE, 0},
{ 737, 1063890856u, 4022784584u, 0u, 4294967288u, 1072279464u, 4022784584u, 0, FREXP_TOLERANCE, 0},
{ 738, 1060483857u, 3264056381u, 0u, 4294967285u, 1072018193u, 3264056381u, 0, FREXP_TOLERANCE, 0},
{ 739, 1044637404u, 1778509100u, 0u, 4294967270u, 1071900380u, 1778509100u, 0, FREXP_TOLERANCE, 0},
{ 740, 3213146285u, 2665833973u, 0u, 4294967290u, 3219437741u, 2665833973u, 0, FREXP_TOLERANCE, 0},
{ 741, 3216727300u, 1859175955u, 0u, 4294967293u, 3219873028u, 1859175955u, 0, FREXP_TOLERANCE, 0},
{ 742, 1079949560u, 4258450607u, 0u, 7u, 1072609528u, 4258450607u, 0, FREXP_TOLERANCE, 0},
{ 743, 1048277388u, 4128020197u, 0u, 4294967273u, 1072394636u, 4128020197u, 0, FREXP_TOLERANCE, 0},
{ 744, 1076266146u, 4122840980u, 0u, 4u, 1072071842u, 4122840980u, 0, FREXP_TOLERANCE, 0},
{ 745, 3193183163u, 2454653987u, 0u, 4294967271u, 3219397563u, 2454653987u, 0, FREXP_TOLERANCE, 0},
{ 746, 3229487005u, 2977478685u, 0u, 9u, 3220049821u, 2977478685u, 0, FREXP_TOLERANCE, 0},
{ 747, 3253556483u, 1355181872u, 0u, 32u, 3220002051u, 1355181872u, 0, FREXP_TOLERANCE, 0},
{ 748, 1095308770u, 436846481u, 0u, 22u, 1072240098u, 436846481u, 0, FREXP_TOLERANCE, 0},
{ 749, 3246605302u, 2592856453u, 0u, 26u, 3219342326u, 2592856453u, 0, FREXP_TOLERANCE, 0},
{ 750, 3247825559u, 3195234082u, 0u, 27u, 3219514007u, 3195234082u, 0, FREXP_TOLERANCE, 0},
{ 751, 3222118023u, 3554670043u, 0u, 2u, 3220020871u, 3554670043u, 0, FREXP_TOLERANCE, 0},
{ 752, 1091621009u, 3321236467u, 0u, 19u, 1071698065u, 3321236467u, 0, FREXP_TOLERANCE, 0},
{ 753, 1069012833u, 1936670355u, 0u, 4294967293u, 1072158561u, 1936670355u, 0, FREXP_TOLERANCE, 0},
{ 754, 1095715713u, 2958468553u, 0u, 22u, 1072647041u, 2958468553u, 0, FREXP_TOLERANCE, 0},
{ 755, 3192291109u, 2960339502u, 0u, 4294967270u, 3219554085u, 2960339502u, 0, FREXP_TOLERANCE, 0},
{ 756, 1098808013u, 1044068983u, 0u, 25u, 1072593613u, 1044068983u, 0, FREXP_TOLERANCE, 0},
{ 757, 3196691185u, 4093388677u, 0u, 4294967274u, 3219759857u, 4093388677u, 0, FREXP_TOLERANCE, 0},
{ 758, 1095478112u, 1735930261u, 0u, 22u, 1072409440u, 1735930261u, 0, FREXP_TOLERANCE, 0},
{ 759, 1091040302u, 1807398746u, 0u, 18u, 1072165934u, 1807398746u, 0, FREXP_TOLERANCE, 0},
{ 760, 3195743135u, 4261616162u, 0u, 4294967273u, 3219860383u, 4261616162u, 0, FREXP_TOLERANCE, 0},
{ 761, 3209294194u, 3250576797u, 0u, 4294967286u, 3219779954u, 3250576797u, 0, FREXP_TOLERANCE, 0},
{ 762, 1059002384u, 3043079652u, 0u, 4294967283u, 1072633872u, 3043079652u, 0, FREXP_TOLERANCE, 0},
{ 763, 1069207109u, 666051428u, 0u, 4294967293u, 1072352837u, 666051428u, 0, FREXP_TOLERANCE, 0},
{ 764, 3208765404u, 1912684117u, 0u, 4294967286u, 3219251164u, 1912684117u, 0, FREXP_TOLERANCE, 0},
{ 765, 1103487420u, 1949030179u, 0u, 30u, 1072030140u, 1949030179u, 0, FREXP_TOLERANCE, 0},
{ 766, 1096388934u, 896459246u, 0u, 23u, 1072271686u, 896459246u, 0, FREXP_TOLERANCE, 0},
{ 767, 1054300653u, 622499767u, 0u, 4294967279u, 1072126445u, 622499767u, 0, FREXP_TOLERANCE, 0},
{ 768, 1066707637u, 1490260486u, 0u, 4294967291u, 1071950517u, 1490260486u, 0, FREXP_TOLERANCE, 0},
{ 769, 1106688493u, 1490616165u, 0u, 33u, 1072085485u, 1490616165u, 0, FREXP_TOLERANCE, 0},
{ 770, 3251242436u, 795675736u, 0u, 30u, 3219785156u, 795675736u, 0, FREXP_TOLERANCE, 0},
{ 771, 1080943896u, 3662877092u, 0u, 8u, 1072555288u, 3662877092u, 0, FREXP_TOLERANCE, 0},
{ 772, 3234317146u, 3200513112u, 0u, 14u, 3219637082u, 3200513112u, 0, FREXP_TOLERANCE, 0},
{ 773, 1084088786u, 1356101968u, 0u, 11u, 1072554450u, 1356101968u, 0, FREXP_TOLERANCE, 0},
{ 774, 3236536816u, 3062844611u, 0u, 16u, 3219759600u, 3062844611u, 0, FREXP_TOLERANCE, 0},
{ 775, 3219922640u, 2284484846u, 0u, 0u, 3219922640u, 2284484846u, 0, FREXP_TOLERANCE, 0},
{ 776, 3219498359u, 3240896015u, 0u, 0u, 3219498359u, 3240896015u, 0, FREXP_TOLERANCE, 0},
{ 777, 3235759689u, 494503287u, 0u, 15u, 3220031049u, 494503287u, 0, FREXP_TOLERANCE, 0},
{ 778, 1092811254u, 142673998u, 0u, 20u, 1071839734u, 142673998u, 0, FREXP_TOLERANCE, 0},
{ 779, 3252125916u, 3394882641u, 0u, 31u, 3219620060u, 3394882641u, 0, FREXP_TOLERANCE, 0},
{ 780, 3225306538u, 364852125u, 0u, 5u, 3220063658u, 364852125u, 0, FREXP_TOLERANCE, 0},
{ 781, 3225261763u, 193885269u, 0u, 5u, 3220018883u, 193885269u, 0, FREXP_TOLERANCE, 0},
{ 782, 1088149839u, 1359805831u, 0u, 15u, 1072421199u, 1359805831u, 0, FREXP_TOLERANCE, 0},
{ 783, 3200484782u, 592580907u, 0u, 4294967278u, 3219359150u, 592580907u, 0, FREXP_TOLERANCE, 0},
{ 784, 3199560872u, 3086438952u, 0u, 4294967277u, 3219483816u, 3086438952u, 0, FREXP_TOLERANCE, 0},
{ 785, 1059518664u, 1778008540u, 0u, 4294967284u, 1072101576u, 1778008540u, 0, FREXP_TOLERANCE, 0},
{ 786, 1049064687u, 73581647u, 0u, 4294967274u, 1072133359u, 73581647u, 0, FREXP_TOLERANCE, 0},
{ 787, 3246733598u, 233240285u, 0u, 26u, 3219470622u, 233240285u, 0, FREXP_TOLERANCE, 0},
{ 788, 1081923320u, 2710903921u, 0u, 9u, 1072486136u, 2710903921u, 0, FREXP_TOLERANCE, 0},
{ 789, 1069513767u, 3719878805u, 0u, 4294967293u, 1072659495u, 3719878805u, 0, FREXP_TOLERANCE, 0},
{ 790, 1079866720u, 3615458228u, 0u, 7u, 1072526688u, 3615458228u, 0, FREXP_TOLERANCE, 0},
{ 791, 3221194724u, 3647632375u, 0u, 1u, 3220146148u, 3647632375u, 0, FREXP_TOLERANCE, 0},
{ 792, 3247225271u, 3839959621u, 0u, 26u, 3219962295u, 3839959621u, 0, FREXP_TOLERANCE, 0},
{ 793, 1103401096u, 2232210456u, 0u, 30u, 1071943816u, 2232210456u, 0, FREXP_TOLERANCE, 0},
{ 794, 3235434773u, 224271737u, 0u, 15u, 3219706133u, 224271737u, 0, FREXP_TOLERANCE, 0},
{ 795, 3193003684u, 2134662911u, 0u, 4294967271u, 3219218084u, 2134662911u, 0, FREXP_TOLERANCE, 0},
{ 796, 3190390590u, 4239009051u, 0u, 4294967268u, 3219750718u, 4239009051u, 0, FREXP_TOLERANCE, 0},
{ 797, 1080526145u, 2305279897u, 0u, 8u, 1072137537u, 2305279897u, 0, FREXP_TOLERANCE, 0},
{ 798, 1077668039u, 1854523320u, 0u, 5u, 1072425159u, 1854523320u, 0, FREXP_TOLERANCE, 0},
{ 799, 3219864259u, 538224650u, 0u, 0u, 3219864259u, 538224650u, 0, FREXP_TOLERANCE, 0},
{ 800, 3206153057u, 1379649610u, 0u, 4294967283u, 3219784545u, 1379649610u, 0, FREXP_TOLERANCE, 0},
{ 801, 3196410507u, 3683897920u, 0u, 4294967274u, 3219479179u, 3683897920u, 0, FREXP_TOLERANCE, 0},
{ 802, 3244167599u, 3647579469u, 0u, 23u, 3220050351u, 3647579469u, 0, FREXP_TOLERANCE, 0},
{ 803, 1090280933u, 2694093608u, 0u, 17u, 1072455141u, 2694093608u, 0, FREXP_TOLERANCE, 0},
{ 804, 1042775347u, 598406111u, 0u, 4294967268u, 1072135475u, 598406111u, 0, FREXP_TOLERANCE, 0},
{ 805, 3211635392u, 872706833u, 0u, 4294967288u, 3220024000u, 872706833u, 0, FREXP_TOLERANCE, 0},
{ 806, 1084802480u, 2200602798u, 0u, 12u, 1072219568u, 2200602798u, 0, FREXP_TOLERANCE, 0},
{ 807, 1042339597u, 904146293u, 0u, 4294967268u, 1071699725u, 904146293u, 0, FREXP_TOLERANCE, 0},
{ 808, 1060867322u, 1729685598u, 0u, 4294967285u, 1072401658u, 1729685598u, 0, FREXP_TOLERANCE, 0},
{ 809, 3195694970u, 1894173462u, 0u, 4294967273u, 3219812218u, 1894173462u, 0, FREXP_TOLERANCE, 0},
{ 810, 3232800651u, 191960416u, 0u, 13u, 3219169163u, 191960416u, 0, FREXP_TOLERANCE, 0},
{ 811, 1091225343u, 3521028551u, 0u, 18u, 1072350975u, 3521028551u, 0, FREXP_TOLERANCE, 0},
{ 812, 1054522089u, 3287274359u, 0u, 4294967279u, 1072347881u, 3287274359u, 0, FREXP_TOLERANCE, 0},
{ 813, 1095386964u, 959640601u, 0u, 22u, 1072318292u, 959640601u, 0, FREXP_TOLERANCE, 0},
{ 814, 3201578263u, 4136915018u, 0u, 4294967279u, 3219404055u, 4136915018u, 0, FREXP_TOLERANCE, 0},
{ 815, 1064005451u, 1553716379u, 0u, 4294967288u, 1072394059u, 1553716379u, 0, FREXP_TOLERANCE, 0},
{ 816, 1106027987u, 984725765u, 0u, 32u, 1072473555u, 984725765u, 0, FREXP_TOLERANCE, 0},
{ 817, 3238832641u, 2287646644u, 0u, 18u, 3219958273u, 2287646644u, 0, FREXP_TOLERANCE, 0},
{ 818, 3240329321u, 2276183378u, 0u, 20u, 3219357801u, 2276183378u, 0, FREXP_TOLERANCE, 0},
{ 819, 1068209174u, 3940225170u, 0u, 4294967292u, 1072403478u, 3940225170u, 0, FREXP_TOLERANCE, 0},
{ 820, 3199544434u, 997572161u, 0u, 4294967277u, 3219467378u, 997572161u, 0, FREXP_TOLERANCE, 0},
{ 821, 3212768361u, 36116288u, 0u, 4294967289u, 3220108393u, 36116288u, 0, FREXP_TOLERANCE, 0},
{ 822, 3206886566u, 4196602670u, 0u, 4294967284u, 3219469478u, 4196602670u, 0, FREXP_TOLERANCE, 0},
{ 823, 3241695853u, 3550227562u, 0u, 21u, 3219675757u, 3550227562u, 0, FREXP_TOLERANCE, 0},
{ 824, 3207257983u, 2747744117u, 0u, 4294967284u, 3219840895u, 2747744117u, 0, FREXP_TOLERANCE, 0},
{ 825, 1104236126u, 507130047u, 0u, 31u, 1071730270u, 507130047u, 0, FREXP_TOLERANCE, 0},
{ 826, 1048359321u, 3229888373u, 0u, 4294967273u, 1072476569u, 3229888373u, 0, FREXP_TOLERANCE, 0},
{ 827, 3222996778u, 2210969014u, 0u, 3u, 3219851050u, 2210969014u, 0, FREXP_TOLERANCE, 0},
{ 828, 1081031001u, 1946786091u, 0u, 8u, 1072642393u, 1946786091u, 0, FREXP_TOLERANCE, 0},
{ 829, 3236306990u, 4059150589u, 0u, 16u, 3219529774u, 4059150589u, 0, FREXP_TOLERANCE, 0},
{ 830, 3189759234u, 1177045799u, 0u, 4294967267u, 3220167938u, 1177045799u, 0, FREXP_TOLERANCE, 0},
{ 831, 1093103612u, 2664812822u, 0u, 20u, 1072132092u, 2664812822u, 0, FREXP_TOLERANCE, 0},
{ 832, 1050343198u, 2034180320u, 0u, 4294967275u, 1072363294u, 2034180320u, 0, FREXP_TOLERANCE, 0},
{ 833, 3213779117u, 1175750283u, 0u, 4294967290u, 3220070573u, 1175750283u, 0, FREXP_TOLERANCE, 0},
{ 834, 3235559706u, 1424491340u, 0u, 15u, 3219831066u, 1424491340u, 0, FREXP_TOLERANCE, 0},
{ 835, 3213904193u, 1630036121u, 0u, 4294967291u, 3219147073u, 1630036121u, 0, FREXP_TOLERANCE, 0},
{ 836, 3231972785u, 3195479448u, 0u, 12u, 3219389873u, 3195479448u, 0, FREXP_TOLERANCE, 0},
{ 837, 1090429875u, 2527029044u, 0u, 17u, 1072604083u, 2527029044u, 0, FREXP_TOLERANCE, 0},
{ 838, 1046927050u, 4000723255u, 0u, 4294967272u, 1072092874u, 4000723255u, 0, FREXP_TOLERANCE, 0},
{ 839, 1085208677u, 3335703647u, 0u, 12u, 1072625765u, 3335703647u, 0, FREXP_TOLERANCE, 0},
{ 840, 3237349676u, 3869440059u, 0u, 17u, 3219523884u, 3869440059u, 0, FREXP_TOLERANCE, 0},
{ 841, 1091433848u, 3888398377u, 0u, 18u, 1072559480u, 3888398377u, 0, FREXP_TOLERANCE, 0},
{ 842, 3196041693u, 1290567220u, 0u, 4294967273u, 3220158941u, 1290567220u, 0, FREXP_TOLERANCE, 0},
{ 843, 1066679070u, 3242451480u, 0u, 4294967291u, 1071921950u, 3242451480u, 0, FREXP_TOLERANCE, 0},
{ 844, 3248384948u, 707431021u, 0u, 27u, 3220073396u, 707431021u, 0, FREXP_TOLERANCE, 0},
{ 845, 1083230509u, 2739665123u, 0u, 11u, 1071696173u, 2739665123u, 0, FREXP_TOLERANCE, 0},
{ 846, 1060777905u, 1733073225u, 0u, 4294967285u, 1072312241u, 1733073225u, 0, FREXP_TOLERANCE, 0},
{ 847, 1078517061u, 1297274853u, 0u, 6u, 1072225605u, 1297274853u, 0, FREXP_TOLERANCE, 0},
{ 848, 3208848704u, 3341639139u, 0u, 4294967286u, 3219334464u, 3341639139u, 0, FREXP_TOLERANCE, 0},
{ 849, 1046570941u, 2228057309u, 0u, 4294967272u, 1071736765u, 2228057309u, 0, FREXP_TOLERANCE, 0},
{ 850, 1084318902u, 1317851136u, 0u, 12u, 1071735990u, 1317851136u, 0, FREXP_TOLERANCE, 0},
{ 851, 1088255327u, 270039934u, 0u, 15u, 1072526687u, 270039934u, 0, FREXP_TOLERANCE, 0},
{ 852, 3241414679u, 3063626339u, 0u, 21u, 3219394583u, 3063626339u, 0, FREXP_TOLERANCE, 0},
{ 853, 3219178350u, 83062251u, 0u, 0u, 3219178350u, 83062251u, 0, FREXP_TOLERANCE, 0},
{ 854, 3211262173u, 2659016437u, 0u, 4294967288u, 3219650781u, 2659016437u, 0, FREXP_TOLERANCE, 0},
{ 855, 1095743886u, 3833539373u, 0u, 22u, 1072675214u, 3833539373u, 0, FREXP_TOLERANCE, 0},
{ 856, 3206667189u, 1567476111u, 0u, 4294967284u, 3219250101u, 1567476111u, 0, FREXP_TOLERANCE, 0},
{ 857, 3205195072u, 2382776852u, 0u, 4294967282u, 3219875136u, 2382776852u, 0, FREXP_TOLERANCE, 0},
{ 858, 3249232579u, 1546622468u, 0u, 28u, 3219872451u, 1546622468u, 0, FREXP_TOLERANCE, 0},
{ 859, 1085536439u, 1714300821u, 0u, 13u, 1071904951u, 1714300821u, 0, FREXP_TOLERANCE, 0},
{ 860, 1104130938u, 4167591598u, 0u, 30u, 1072673658u, 4167591598u, 0, FREXP_TOLERANCE, 0},
{ 861, 1051092760u, 2798720100u, 0u, 4294967276u, 1072064280u, 2798720100u, 0, FREXP_TOLERANCE, 0},
{ 862, 1086978789u, 449990704u, 0u, 14u, 1072298725u, 449990704u, 0, FREXP_TOLERANCE, 0},
{ 863, 3231198415u, 4039516226u, 0u, 11u, 3219664079u, 4039516226u, 0, FREXP_TOLERANCE, 0},
{ 864, 3244344107u, 4272932619u, 0u, 24u, 3219178283u, 4272932619u, 0, FREXP_TOLERANCE, 0},
{ 865, 3222708441u, 1683007544u, 0u, 3u, 3219562713u, 1683007544u, 0, FREXP_TOLERANCE, 0},
{ 866, 1091105663u, 3805494321u, 0u, 18u, 1072231295u, 3805494321u, 0, FREXP_TOLERANCE, 0},
{ 867, 3220852948u, 2072627412u, 0u, 1u, 3219804372u, 2072627412u, 0, FREXP_TOLERANCE, 0},
{ 868, 1094383324u, 3394151662u, 0u, 21u, 1072363228u, 3394151662u, 0, FREXP_TOLERANCE, 0},
{ 869, 3220570024u, 1120106427u, 0u, 1u, 3219521448u, 1120106427u, 0, FREXP_TOLERANCE, 0},
{ 870, 3223631624u, 3404608264u, 0u, 4u, 3219437320u, 3404608264u, 0, FREXP_TOLERANCE, 0},
{ 871, 1097859997u, 559918757u, 0u, 25u, 1071645597u, 559918757u, 0, FREXP_TOLERANCE, 0},
{ 872, 3205077053u, 908100198u, 0u, 4294967282u, 3219757117u, 908100198u, 0, FREXP_TOLERANCE, 0},
{ 873, 1042677918u, 2026673913u, 0u, 4294967268u, 1072038046u, 2026673913u, 0, FREXP_TOLERANCE, 0},
{ 874, 3244833635u, 2844573214u, 0u, 24u, 3219667811u, 2844573214u, 0, FREXP_TOLERANCE, 0},
{ 875, 3254567259u, 3946837259u, 0u, 33u, 3219964251u, 3946837259u, 0, FREXP_TOLERANCE, 0},
{ 876, 3234993796u, 3850406820u, 0u, 15u, 3219265156u, 3850406820u, 0, FREXP_TOLERANCE, 0},
{ 877, 1057479809u, 3139330994u, 0u, 4294967282u, 1072159873u, 3139330994u, 0, FREXP_TOLERANCE, 0},
{ 878, 1046133568u, 1539650690u, 0u, 4294967271u, 1072347968u, 1539650690u, 0, FREXP_TOLERANCE, 0},
{ 879, 3236705500u, 1554593884u, 0u, 16u, 3219928284u, 1554593884u, 0, FREXP_TOLERANCE, 0},
{ 880, 3228899878u, 2813752562u, 0u, 9u, 3219462694u, 2813752562u, 0, FREXP_TOLERANCE, 0},
{ 881, 1056505004u, 3804703138u, 0u, 4294967281u, 1072233644u, 3804703138u, 0, FREXP_TOLERANCE, 0},
{ 882, 1072931071u, 2053677923u, 0u, 1u, 1071882495u, 2053677923u, 0, FREXP_TOLERANCE, 0},
{ 883, 3244864299u, 289355864u, 0u, 24u, 3219698475u, 289355864u, 0, FREXP_TOLERANCE, 0},
{ 884, 1078453818u, 2143066338u, 0u, 6u, 1072162362u, 2143066338u, 0, FREXP_TOLERANCE, 0},
{ 885, 3203939880u, 2157691971u, 0u, 4294967281u, 3219668520u, 2157691971u, 0, FREXP_TOLERANCE, 0},
{ 886, 1106629150u, 110806409u, 0u, 33u, 1072026142u, 110806409u, 0, FREXP_TOLERANCE, 0},
{ 887, 1082157019u, 3570399481u, 0u, 10u, 1071671259u, 3570399481u, 0, FREXP_TOLERANCE, 0},
{ 888, 1085637605u, 180265334u, 0u, 13u, 1072006117u, 180265334u, 0, FREXP_TOLERANCE, 0},
{ 889, 3200980182u, 558779875u, 0u, 4294967278u, 3219854550u, 558779875u, 0, FREXP_TOLERANCE, 0},
{ 890, 3202046748u, 2338464653u, 0u, 4294967279u, 3219872540u, 2338464653u, 0, FREXP_TOLERANCE, 0},
{ 891, 1045705464u, 1703969219u, 0u, 4294967271u, 1071919864u, 1703969219u, 0, FREXP_TOLERANCE, 0},
{ 892, 3229797258u, 1417521063u, 0u, 10u, 3219311498u, 1417521063u, 0, FREXP_TOLERANCE, 0},
{ 893, 3237782261u, 3917440951u, 0u, 17u, 3219956469u, 3917440951u, 0, FREXP_TOLERANCE, 0},
{ 894, 1051668894u, 3736066983u, 0u, 4294967276u, 1072640414u, 3736066983u, 0, FREXP_TOLERANCE, 0},
{ 895, 1064752080u, 3106613409u, 0u, 4294967289u, 1072092112u, 3106613409u, 0, FREXP_TOLERANCE, 0},
{ 896, 1066627453u, 2735392257u, 0u, 4294967291u, 1071870333u, 2735392257u, 0, FREXP_TOLERANCE, 0},
{ 897, 1065665372u, 2229777605u, 0u, 4294967290u, 1071956828u, 2229777605u, 0, FREXP_TOLERANCE, 0},
{ 898, 1065061963u, 2405869925u, 0u, 4294967289u, 1072401995u, 2405869925u, 0, FREXP_TOLERANCE, 0},
{ 899, 3239463229u, 3967957902u, 0u, 19u, 3219540285u, 3967957902u, 0, FREXP_TOLERANCE, 0},
{ 900, 1057416138u, 3459188071u, 0u, 4294967282u, 1072096202u, 3459188071u, 0, FREXP_TOLERANCE, 0},
{ 901, 1068639210u, 3699016825u, 0u, 4294967293u, 1071784938u, 3699016825u, 0, FREXP_TOLERANCE, 0},
{ 902, 3249713090u, 796144848u, 0u, 29u, 3219304386u, 796144848u, 0, FREXP_TOLERANCE, 0},
{ 903, 3228816396u, 3285165564u, 0u, 9u, 3219379212u, 3285165564u, 0, FREXP_TOLERANCE, 0},
{ 904, 3211948811u, 401510871u, 0u, 4294967289u, 3219288843u, 401510871u, 0, FREXP_TOLERANCE, 0},
{ 905, 1094257658u, 634857910u, 0u, 21u, 1072237562u, 634857910u, 0, FREXP_TOLERANCE, 0},
{ 906, 3199607513u, 914218057u, 0u, 4294967277u, 3219530457u, 914218057u, 0, FREXP_TOLERANCE, 0},
{ 907, 1083743336u, 2030735578u, 0u, 11u, 1072209000u, 2030735578u, 0, FREXP_TOLERANCE, 0},
{ 908, 3233855943u, 965677531u, 0u, 14u, 3219175879u, 965677531u, 0, FREXP_TOLERANCE, 0},
{ 909, 1079556815u, 3957229084u, 0u, 7u, 1072216783u, 3957229084u, 0, FREXP_TOLERANCE, 0},
{ 910, 1051050470u, 3123776651u, 0u, 4294967276u, 1072021990u, 3123776651u, 0, FREXP_TOLERANCE, 0},
{ 911, 3221863333u, 162122081u, 0u, 2u, 3219766181u, 162122081u, 0, FREXP_TOLERANCE, 0},
{ 912, 3239376395u, 108064594u, 0u, 19u, 3219453451u, 108064594u, 0, FREXP_TOLERANCE, 0},
{ 913, 3237271786u, 869031839u, 0u, 17u, 3219445994u, 869031839u, 0, FREXP_TOLERANCE, 0},
{ 914, 3225020876u, 1344301606u, 0u, 5u, 3219777996u, 1344301606u, 0, FREXP_TOLERANCE, 0},
{ 915, 3214433474u, 946696117u, 0u, 4294967291u, 3219676354u, 946696117u, 0, FREXP_TOLERANCE, 0},
{ 916, 3231825228u, 1700703647u, 0u, 12u, 3219242316u, 1700703647u, 0, FREXP_TOLERANCE, 0},
{ 917, 1075492875u, 3394168074u, 0u, 3u, 1072347147u, 3394168074u, 0, FREXP_TOLERANCE, 0},
{ 918, 1076939786u, 1666995668u, 0u, 5u, 1071696906u, 1666995668u, 0, FREXP_TOLERANCE, 0},
{ 919, 3208774795u, 2488789804u, 0u, 4294967286u, 3219260555u, 2488789804u, 0, FREXP_TOLERANCE, 0},
{ 920, 3238508333u, 1506943664u, 0u, 18u, 3219633965u, 1506943664u, 0, FREXP_TOLERANCE, 0},
{ 921, 1072788663u, 3844072288u, 0u, 1u, 1071740087u, 3844072288u, 0, FREXP_TOLERANCE, 0},
{ 922, 3202592279u, 2630019853u, 0u, 4294967280u, 3219369495u, 2630019853u, 0, FREXP_TOLERANCE, 0},
{ 923, 3219934542u, 1244307192u, 0u, 0u, 3219934542u, 1244307192u, 0, FREXP_TOLERANCE, 0},
{ 924, 3191297711u, 2540916692u, 0u, 4294967269u, 3219609263u, 2540916692u, 0, FREXP_TOLERANCE, 0},
{ 925, 3200062692u, 2871645739u, 0u, 4294967277u, 3219985636u, 2871645739u, 0, FREXP_TOLERANCE, 0},
{ 926, 3239081581u, 1440249115u, 0u, 19u, 3219158637u, 1440249115u, 0, FREXP_TOLERANCE, 0},
{ 927, 1068350633u, 1231934926u, 0u, 4294967292u, 1072544937u, 1231934926u, 0, FREXP_TOLERANCE, 0},
{ 928, 3236746788u, 603977748u, 0u, 16u, 3219969572u, 603977748u, 0, FREXP_TOLERANCE, 0},
{ 929, 3195449689u, 2386312545u, 0u, 4294967273u, 3219566937u, 2386312545u, 0, FREXP_TOLERANCE, 0},
{ 930, 1063169277u, 2715234268u, 0u, 4294967287u, 1072606461u, 2715234268u, 0, FREXP_TOLERANCE, 0},
{ 931, 1087803418u, 915867083u, 0u, 15u, 1072074778u, 915867083u, 0, FREXP_TOLERANCE, 0},
{ 932, 1046790892u, 3347417612u, 0u, 4294967272u, 1071956716u, 3347417612u, 0, FREXP_TOLERANCE, 0},
{ 933, 1105984188u, 3553288373u, 0u, 32u, 1072429756u, 3553288373u, 0, FREXP_TOLERANCE, 0},
{ 934, 1065698616u, 2906680663u, 0u, 4294967290u, 1071990072u, 2906680663u, 0, FREXP_TOLERANCE, 0},
{ 935, 1045506226u, 2342364630u, 0u, 4294967271u, 1071720626u, 2342364630u, 0, FREXP_TOLERANCE, 0},
{ 936, 1051356723u, 4019093203u, 0u, 4294967276u, 1072328243u, 4019093203u, 0, FREXP_TOLERANCE, 0},
{ 937, 3201169162u, 2911548084u, 0u, 4294967278u, 3220043530u, 2911548084u, 0, FREXP_TOLERANCE, 0},
{ 938, 1105282515u, 2476735795u, 0u, 32u, 1071728083u, 2476735795u, 0, FREXP_TOLERANCE, 0},
{ 939, 1050472772u, 1836216409u, 0u, 4294967275u, 1072492868u, 1836216409u, 0, FREXP_TOLERANCE, 0},
{ 940, 1101062307u, 2519592554u, 0u, 28u, 1071702179u, 2519592554u, 0, FREXP_TOLERANCE, 0},
{ 941, 1070178161u, 1235369496u, 0u, 4294967294u, 1072275313u, 1235369496u, 0, FREXP_TOLERANCE, 0},
{ 942, 3222946447u, 668087854u, 0u, 3u, 3219800719u, 668087854u, 0, FREXP_TOLERANCE, 0},
{ 943, 3208554596u, 2981820811u, 0u, 4294967285u, 3220088932u, 2981820811u, 0, FREXP_TOLERANCE, 0},
{ 944, 1059838516u, 2845580478u, 0u, 4294967284u, 1072421428u, 2845580478u, 0, FREXP_TOLERANCE, 0},
{ 945, 3193931414u, 1565550570u, 0u, 4294967271u, 3220145814u, 1565550570u, 0, FREXP_TOLERANCE, 0},
{ 946, 3217165795u, 4162017137u, 0u, 4294967294u, 3219262947u, 4162017137u, 0, FREXP_TOLERANCE, 0},
{ 947, 3237251378u, 2808968027u, 0u, 17u, 3219425586u, 2808968027u, 0, FREXP_TOLERANCE, 0},
{ 948, 1055630096u, 1782326814u, 0u, 4294967280u, 1072407312u, 1782326814u, 0, FREXP_TOLERANCE, 0},
{ 949, 1053576974u, 1492622658u, 0u, 4294967278u, 1072451342u, 1492622658u, 0, FREXP_TOLERANCE, 0},
{ 950, 3216653077u, 3972512122u, 0u, 4294967293u, 3219798805u, 3972512122u, 0, FREXP_TOLERANCE, 0},
{ 951, 3222171679u, 2722693603u, 0u, 2u, 3220074527u, 2722693603u, 0, FREXP_TOLERANCE, 0},
{ 952, 3227814791u, 3169731970u, 0u, 8u, 3219426183u, 3169731970u, 0, FREXP_TOLERANCE, 0},
{ 953, 3217906631u, 899763203u, 0u, 4294967294u, 3220003783u, 899763203u, 0, FREXP_TOLERANCE, 0},
{ 954, 3207606001u, 2804747833u, 0u, 4294967285u, 3219140337u, 2804747833u, 0, FREXP_TOLERANCE, 0},
{ 955, 3230670325u, 3789058912u, 0u, 11u, 3219135989u, 3789058912u, 0, FREXP_TOLERANCE, 0},
{ 956, 3228095081u, 4135937628u, 0u, 8u, 3219706473u, 4135937628u, 0, FREXP_TOLERANCE, 0},
{ 957, 1060199382u, 1682808307u, 0u, 4294967285u, 1071733718u, 1682808307u, 0, FREXP_TOLERANCE, 0},
{ 958, 3206960335u, 232877759u, 0u, 4294967284u, 3219543247u, 232877759u, 0, FREXP_TOLERANCE, 0},
{ 959, 3242091486u, 2851963139u, 0u, 21u, 3220071390u, 2851963139u, 0, FREXP_TOLERANCE, 0},
{ 960, 3246852961u, 2590862592u, 0u, 26u, 3219589985u, 2590862592u, 0, FREXP_TOLERANCE, 0},
{ 961, 1081200406u, 2422232642u, 0u, 9u, 1071763222u, 2422232642u, 0, FREXP_TOLERANCE, 0},
{ 962, 3234779662u, 290458310u, 0u, 14u, 3220099598u, 290458310u, 0, FREXP_TOLERANCE, 0},
{ 963, 3210671078u, 1082582386u, 0u, 4294967287u, 3220108262u, 1082582386u, 0, FREXP_TOLERANCE, 0},
{ 964, 1075605675u, 2602133689u, 0u, 3u, 1072459947u, 2602133689u, 0, FREXP_TOLERANCE, 0},
{ 965, 3239818611u, 1789635787u, 0u, 19u, 3219895667u, 1789635787u, 0, FREXP_TOLERANCE, 0},
{ 966, 1059414278u, 1048286093u, 0u, 4294967284u, 1071997190u, 1048286093u, 0, FREXP_TOLERANCE, 0},
{ 967, 1098330542u, 231339448u, 0u, 25u, 1072116142u, 231339448u, 0, FREXP_TOLERANCE, 0},
{ 968, 1055573265u, 504907415u, 0u, 4294967280u, 1072350481u, 504907415u, 0, FREXP_TOLERANCE, 0},
{ 969, 1063211461u, 1153251200u, 0u, 4294967287u, 1072648645u, 1153251200u, 0, FREXP_TOLERANCE, 0},
{ 970, 3204617090u, 1772013857u, 0u, 4294967282u, 3219297154u, 1772013857u, 0, FREXP_TOLERANCE, 0},
{ 971, 1099551055u, 1082898276u, 0u, 26u, 1072288079u, 1082898276u, 0, FREXP_TOLERANCE, 0},
{ 972, 3212089272u, 1449080862u, 0u, 4294967289u, 3219429304u, 1449080862u, 0, FREXP_TOLERANCE, 0},
{ 973, 1086008285u, 3177299045u, 0u, 13u, 1072376797u, 3177299045u, 0, FREXP_TOLERANCE, 0},
{ 974, 1058862813u, 809400815u, 0u, 4294967283u, 1072494301u, 809400815u, 0, FREXP_TOLERANCE, 0},
{ 975, 3230854550u, 1924429710u, 0u, 11u, 3219320214u, 1924429710u, 0, FREXP_TOLERANCE, 0},
{ 976, 1056464743u, 3349283177u, 0u, 4294967281u, 1072193383u, 3349283177u, 0, FREXP_TOLERANCE, 0},
{ 977, 3245473391u, 42238036u, 0u, 25u, 3219258991u, 42238036u, 0, FREXP_TOLERANCE, 0},
{ 978, 1042379500u, 2113559863u, 0u, 4294967268u, 1071739628u, 2113559863u, 0, FREXP_TOLERANCE, 0},
{ 979, 1064761243u, 3304403230u, 0u, 4294967289u, 1072101275u, 3304403230u, 0, FREXP_TOLERANCE, 0},
{ 980, 3217556703u, 58952646u, 0u, 4294967294u, 3219653855u, 58952646u, 0, FREXP_TOLERANCE, 0},
{ 981, 3212669530u, 1645486982u, 0u, 4294967289u, 3220009562u, 1645486982u, 0, FREXP_TOLERANCE, 0},
{ 982, 3224301095u, 3636267471u, 0u, 4u, 3220106791u, 3636267471u, 0, FREXP_TOLERANCE, 0},
{ 983, 1062762009u, 619402181u, 0u, 4294967287u, 1072199193u, 619402181u, 0, FREXP_TOLERANCE, 0},
{ 984, 3235208235u, 557360557u, 0u, 15u, 3219479595u, 557360557u, 0, FREXP_TOLERANCE, 0},
{ 985, 3238238394u, 110029735u, 0u, 18u, 3219364026u, 110029735u, 0, FREXP_TOLERANCE, 0},
{ 986, 1046937383u, 984375729u, 0u, 4294967272u, 1072103207u, 984375729u, 0, FREXP_TOLERANCE, 0},
{ 987, 3189496738u, 4063688092u, 0u, 4294967267u, 3219905442u, 4063688092u, 0, FREXP_TOLERANCE, 0},
{ 988, 3203235744u, 1049950343u, 0u, 4294967280u, 3220012960u, 1049950343u, 0, FREXP_TOLERANCE, 0},
{ 989, 1062350619u, 650996069u, 0u, 4294967287u, 1071787803u, 650996069u, 0, FREXP_TOLERANCE, 0},
{ 990, 1054971928u, 3953359826u, 0u, 4294967280u, 1071749144u, 3953359826u, 0, FREXP_TOLERANCE, 0},
{ 991, 3227055805u, 66926332u, 0u, 7u, 3219715773u, 66926332u, 0, FREXP_TOLERANCE, 0},
{ 992, 1090561839u, 1379780888u, 0u, 18u, 1071687471u, 1379780888u, 0, FREXP_TOLERANCE, 0},
{ 993, 3233453307u, 2803378256u, 0u, 13u, 3219821819u, 2803378256u, 0, FREXP_TOLERANCE, 0},
{ 994, 1086057989u, 498534626u, 0u, 13u, 1072426501u, 498534626u, 0, FREXP_TOLERANCE, 0},
{ 995, 1082618553u, 2846400785u, 0u, 10u, 1072132793u, 2846400785u, 0, FREXP_TOLERANCE, 0},
{ 996, 1047142525u, 1375153550u, 0u, 4294967272u, 1072308349u, 1375153550u, 0, FREXP_TOLERANCE, 0},
{ 997, 1044581201u, 2869128958u, 0u, 4294967270u, 1071844177u, 2869128958u, 0, FREXP_TOLERANCE, 0},
{ 998, 1070972315u, 4246440273u, 0u, 4294967295u, 1072020891u, 4246440273u, 0, FREXP_TOLERANCE, 0},
{ 999, 1051832506u, 3112381207u, 0u, 4294967277u, 1071755450u, 3112381207u, 0, FREXP_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_FREXP_H multiple inclusion protection

// EOF frexp.h
