//==========================================================================
//
//      plf_misc.c
//
//      HAL platform miscellaneous functions
//
//==========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: nickg, jlarmour
// Date:         1999-01-21
// Purpose:      HAL miscellaneous functions
// Description:  This file contains miscellaneous functions provided by the
//               HAL.
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/hal.h>

#include <cyg/infra/cyg_type.h>         // Base types
#include <cyg/infra/cyg_trac.h>         // tracing macros
#include <cyg/infra/cyg_ass.h>          // assertion macros

#include <cyg/hal/hal_arch.h>           // architectural definitions

#include <cyg/hal/hal_intr.h>           // Interrupt handling

#include <cyg/hal/hal_cache.h>          // Cache handling

/* pjo, 18 oct 1999; include pc_outb definition. */
#include <cyg/hal/plf_misc.h>

/*------------------------------------------------------------------------*/

extern void patch_dbg_syscalls(void * vector);

/*------------------------------------------------------------------------*/


// pjo, 21 jan 2000
#ifdef CYGPKG_KERNEL

volatile int hal_pc_fpe_interrupts = 0 ;
volatile int hal_pc_fpe_switches = 0 ;
volatile cyg_uint32 hal_pc_fpe_owner = 0 ;


cyg_uint32 hal_pc_fpe_isr(cyg_vector_t vector, cyg_addrword_t data)
{	return CYG_ISR_CALL_DSR ;
}


void hal_pc_fpe_dsr(cyg_vector_t vector, cyg_ucount32 count, cyg_addrword_t data)
{
	cyg_handle_t me ;
	cyg_addrword_t stack ;
	cyg_uint32 * p ;

	hal_pc_fpe_interrupts++ ;

/* Gotta turn that darn interrupt off!  Otherwise we're in a loop! */
	asm("
		movl %%cr0, %%eax
		andl $0xFFFFFFF7, %%eax
		movl %%eax, %%cr0
		"
	:	/* No outputs. */
	:	/* No inputs. */
	:	"eax"
	);

	me = cyg_thread_self() ;

	if (hal_pc_fpe_owner != me)
	{	if (hal_pc_fpe_owner)
		{	/* Then save his state at the bottom of his stack. */
			stack = cyg_thread_get_stack_base(hal_pc_fpe_owner) ;
			p = (cyg_uint32*) stack ;
			stack = (cyg_addrword_t) &(p[1]);
			asm("movl %0, %%eax
				fsave (%%eax)"
				:	/* No outputs. */
				:	"g" (stack)
				:	"eax") ;
			p[0] = 0xCAFEBABE ;
		}
		hal_pc_fpe_owner = me ;
		stack = cyg_thread_get_stack_base(hal_pc_fpe_owner) ;
		p = (cyg_uint32*) stack ;
		if (p[0] == 0xCAFEBABE)
		{	stack = (cyg_addrword_t) &(p[1]) ;
			asm("movl %0, %%eax
				frstor (%%eax)"
				:	/* No outputs. */
				:	"g" (stack)
				:	"eax");
		}

		hal_pc_fpe_switches++ ;
	}
}


cyg_interrupt hal_pc_fpe_interrupt_object ;
cyg_handle_t hal_pc_fpe_interrupt ;

#endif /* CYGPKG_KERNEL */



void hal_platform_init(void)
{

    HAL_ICACHE_INVALIDATE_ALL();    
    HAL_ICACHE_ENABLE();
    HAL_DCACHE_INVALIDATE_ALL();
    HAL_DCACHE_ENABLE();

#if defined(CYGDBG_HAL_DEBUG_GDB_CTRLC_SUPPORT)    
        {
            void hal_ctrlc_isr_init(void);
            hal_ctrlc_isr_init();
        }

#endif
        
#if defined(CYGFUN_HAL_COMMON_KERNEL_SUPPORT)   && \
    defined(CYG_HAL_USE_ROM_MONITOR)            && \
    defined(CYG_HAL_USE_ROM_MONITOR_CYGMON)
    {
        patch_dbg_syscalls( (void *)(&hal_vsr_table[0]) );
    }
#endif
    

// pjo, 21 jan 2000
#ifdef CYGPKG_KERNEL
/* Connect to the floating point interrupt. */
	cyg_interrupt_create(CYGNUM_HAL_VECTOR_NO_DEVICE, 1, 0,
				hal_pc_fpe_isr, hal_pc_fpe_dsr,
				&hal_pc_fpe_interrupt, &hal_pc_fpe_interrupt_object);
	cyg_interrupt_attach(hal_pc_fpe_interrupt);
#endif /* CYGPKG_KERNEL */
}



// pjo, 18 oct 1999
#if 0
/* These functions were declared 'inline' in plf_misc.h. */
int pc_outb(int port, int value)
{
	asm("
		movl %0, %%eax
		movl %1, %%edx
		outb %%al, %%dx
		"
	:	/* No outputs. */
	:	"g" (value), "g" (port)
	:	"eax", "edx"
	);

	return value ;
}


int pc_inb(int port)
{	int r ;

	asm("
		movl %1, %%edx
		inb %%dx, %%al
		cbtw
		cwtl
		movl %%eax, %0
		"
	:	"=g" (r)
	:	"g" (port)
	:	"eax", "edx"
	);

	return r ;
}


int pc_outw(int port, int value)
{
	asm("
		movl %0, %%eax
		movl %1, %%edx
		outw %%ax, %%dx
		"
	:	/* No outputs. */
	:	"g" (value), "g" (port)
	:	"eax", "edx"
	);

	return value ;
}


int pc_inw(int port)
{	int r ;

	asm("
		movl %1, %%edx
		inw %%dx, %%ax
		cwtl
		movl %%eax, %0
		"
	:	"=g" (r)
	:	"g" (port)
	:	"eax", "edx"
	);

	return r ;
}
#endif


void hal_pc_reset(void)
{
/* Use Intel's IDT triple-fault trick. */
	asm("

		movl $badIdt, %eax
		lidt (%eax)
		int $3
		hlt

		.align 4

badIdt:
		.word		0
		.long		0
	") ;
}


/*------------------------------------------------------------------------*/
/* End of plf_misc.c                                                      */
