;; $Id: dbgraph.dsl,v 1.1 1998/02/18 13:14:11 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ==================== GRAPHICS ====================

;; NOTE: display #f doesn't seem to work right in the RTF back end...


(define (graphic-file filename)
  (let ((ext (file-extension filename)))
    (if (or (not filename)
	    (not %graphic-default-extension%)
	    (member ext %graphic-extensions%))
	filename
	(string-append filename "." %graphic-default-extension%))))

(define ($img$ #!optional (nd (current-node)) (display #f))
  (let ((fileref (attribute-string "fileref" nd))
	(entityref (attribute-string "entityref" nd))
	(format (attribute-string "format" nd))
	(align (attribute-string "align" nd)))
    (make external-graphic
      notation-system-id: (if format format "")
      entity-system-id: (if fileref 
			    (graphic-file fileref)
			    (if entityref 
				(entity-generated-system-id entityref)
				""))
      display?: display
      display-alignment: (cond ((equal? align "CENTER") 'center)
			       ((equal? align "RIGHT") 'end)
			       (else 'start)))))

(element GRAPHIC
  (make paragraph
    space-before: %block-sep%
    space-after: %block-sep%
    ($img$ (current-node) #t)))

(element INLINEGRAPHIC ($img$))


