;; $Id: dbfootn.dsl,v 1.1 1998/02/18 13:13:37 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ======================================================================
;; Handle footnotes in body text

(element FOOTNOTE ;; A footnote inserts a reference to itself
  (let ((id (if (attribute-string "ID")
		(attribute-string "ID")
		(generate-xptr))))
    (make element gi: "A"
	  attributes: (list
		       (list "NAME" id)
		       (list "HREF" (string-append "#FTN." id)))
	  (literal 
	   (string-append 
	    "[" ($footnote-number$ (current-node)) "]")))))
      

(element FOOTNOTEREF
  (let* ((target (element-with-id (attribute-string "LINKEND")))
	 (id (if (attribute-string "ID" target)
		 (attribute-string "ID" target)
		 (generate-xptr target))))
    (make element gi: "A"
	  attributes: (list
		       (list "HREF" (string-append "#FTN." id)))
	  (literal 
	   (string-append
	    "[" ($footnote-number$ target) "] ")))))


(define ($chunk-footnote-number$ footnote)
  (let* ((chunk (chunk-level-parent footnote))
	 (footnotes (select-elements (descendants chunk) "FOOTNOTE")))
    (let loop ((nl footnotes) (num 1))
      (if (node-list-empty? nl)
	  0
	  (if (node-list=? footnote (node-list-first nl))
	      num
	      (loop (node-list-rest nl)
		    (+ num 1)))))))

(define ($table-footnote-number$ footnote)
  (let* ((chunk (ancestor "TGROUP" footnote))
	 (footnotes (select-elements (descendants chunk) "FOOTNOTE")))
    (let loop ((nl footnotes) (num 1))
      (if (node-list-empty? nl)
	  0
	  (if (node-list=? footnote (node-list-first nl))
	      num
	      (loop (node-list-rest nl)
		    (+ num 1)))))))

(define ($footnote-number$ footnote)
  (if (node-list-empty? (ancestor "TGROUP" footnote))
      (format-number ($chunk-footnote-number$ footnote) "1")
      (format-number ($table-footnote-number$ footnote) "a")))

(mode footnote-mode
  (element FOOTNOTE
    (process-children))

  (element (FOOTNOTE PARA)
    (let ((id (if (attribute-string "ID" (parent (current-node)))
		  (attribute-string "ID" (parent (current-node)))
		  (generate-xptr (parent (current-node))))))
      (make element gi: "P"
	    (if (= (child-number) 1)
		(make element gi: "A"
		      attributes: (list
				   (list "NAME" (string-append "FTN." id))
				   (list "HREF" (href-to (parent (current-node)))))
		      (literal 
		       (string-append
			"[" ($footnote-number$ (parent (current-node))) "] ")))
		      (literal ""))
	    (process-children))))
)

;; ======================================================================
;; Handle table footnotes

(define (table-footnote-number footnote)
  (format-number (component-child-number footnote 
					 '("TABLE" "INFORMALTABLE")) "a"))

(element (ENTRY PARA FOOTNOTE)
  (make element gi: "SUP"
	(literal (table-footnote-number (current-node)))))

(define (make-table-endnote-header)
  (make sequence
    (literal %gentext-table-endnotes%)
    (make empty-element gi: "BR")))

(define (make-table-endnotes)
  (let* ((footnotes (select-elements (descendants (current-node)) 
				     "FOOTNOTE"))
	 (tgroup (ancestor-member (current-node) '("TGROUP")))
	 (cols   (string->number (attribute-string "COLS" tgroup))))
    (if (node-list-empty? footnotes) 
	(empty-sosofo)
	(make element gi: "TR"
	  (make element gi: "TD"
		attributes: (list 
			     (list "COLSPAN" (number->string cols)))
		(make-table-endnote-header)
		(with-mode table-footnote-mode
		  (process-node-list footnotes)))))))

(mode table-footnote-mode
  (element FOOTNOTE
    (process-children))

  (element (FOOTNOTE PARA)
    (let* ((target (parent (current-node)))
	   (fnnum (table-footnote-number target))
	   (idstr (if (attribute-string "ID" target)
		      (attribute-string "ID" target)
		      (generate-xptr target))))
      (make sequence
	(if (= (child-number) 1)
	    (make element gi: "A"
		  attributes: (list (list "NAME" (string-append "FTN." idstr)))
		  (literal fnnum 
			   (gentext-label-title-sep "FOOTNOTE")))
	    (empty-sosofo))
	(process-children)
	(make empty-element gi: "BR")))))

