;; $Id: dbcompon.dsl,v 1.1 1998/02/18 13:13:36 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================= COMPONENTS =============================
;;
;; in docbook, components are containers at the chapter/appendix level

(define ($component$)
  (html-document (with-mode title-mode (process-first-descendant "TITLE"))
		 ($component-body$)))

(define ($component-separator$) 
  (if (or (not nochunks) (node-list=? (current-node) (sgml-root-element)))
      (empty-sosofo)
      (make empty-element gi: "HR")))

(define ($component-body$)
  (make sequence
    ($component-separator$)
    ($component-title$)
    (if ($generate-chapter-toc$)
	($chapter-toc$)
	(empty-sosofo))
    (process-children)))

(define ($component-title$ #!optional (titlegi "H1") (subtitlegi "H2"))
  (let* ((info (cond
		((equal? (gi) "APPENDIX")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "ARTICLE")
		 (select-elements (children (current-node)) "ARTHEADER"))
		((equal? (gi) "BIBLIOGRAPHY")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "CHAPTER")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "DEDICATION")
		 (empty-node-list))
		((equal? (gi) "GLOSSARY")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "INDEX")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "PREFACE")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "REFERENCE")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "SETINDEX")
		 (select-elements (children (current-node)) "DOCINFO"))
		(else
		 (empty-node-list))))
	 (exp-children (if (node-list-empty? info)
			   (empty-node-list)
			   (expand-children (children info) '("BOOKBIBLIO" 
							      "BIBLIOMISC"
							      "BIBLIOSET"))))
	 (parent-titles (select-elements (children (current-node)) "TITLE"))
	 (info-titles   (select-elements exp-children "TITLE"))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children "SUBTITLE")))
    (make sequence
      (make element gi: titlegi
	    (make element gi: "A"
		  attributes: (list (list "NAME" (element-id)))
		  (if (and %chapter-autolabel%
			   (or (equal? (gi) "CHAPTER")
			       (equal? (gi) "APPENDIX")))
		      (literal (gentext-element-name-space (gi))
			       (element-label (current-node))
			       (gentext-label-title-sep (gi)))
		      (empty-sosofo))
		  (element-title-sosofo (current-node))))
      (if (node-list-empty? subtitles) 
	  (empty-sosofo)
	  (with-mode subtitle-mode
	    (make element gi: subtitlegi
		  (process-node-list subtitles)))))))

(define ($chapter-toc$)
  ;; Called by the TITLE element so that it can come after the TITLE
  (build-toc (ancestor-member (current-node) component-element-list)
	     (toc-depth 
	      (ancestor-member (current-node) component-element-list))
	     #t))

(element APPENDIX ($component$))
(element (APPENDIX TITLE) (empty-sosofo))

(element CHAPTER ($component$))
(element (CHAPTER TITLE) (empty-sosofo))

(element PREFACE ($component$))
(element (PREFACE TITLE) (empty-sosofo))

;; Dedication is empty except in a special mode so that it can be
;; reordered (made to come before the TOCs)...see dbttlpg.dsl
(element DEDICATION (empty-sosofo))

(element ARTICLE ($component$))
