/*
 * This file is released under the GPL.
 *
 * Multipath support for job disks.
 */

#include <dm.h>
#include <dm-hw-handler.h>
#include <scsi/scsi.h>
#include <scsi/scsi_cmnd.h>
#include <scsi/scsi_ioctl.h>
#include <linux/genhd.h>

/*
 * This struct scsi_disk and scsi_disk() macro are copied from sd.c.
 * Think of a better way.  Probably need to work with linux-scsi.
 * Just making the scsi_disk() macro be exported from sd.c would
 * make it work.
 */
struct scsi_disk {
        struct scsi_driver *driver;     /* always &sd_template */
        struct scsi_device *device;
        struct kref     kref;
        struct gendisk  *disk;
        unsigned int    openers;        /* protected by BKL for now, yuck */
        sector_t        capacity;       /* size in 512-byte sectors */
        u32             index;
        u8              media_present;
        u8              write_prot;
        unsigned        WCE : 1;        /* state of disk WCE bit */
        unsigned        RCD : 1;        /* state of disk RCD bit, unused */
};


static inline struct scsi_disk *scsi_disk(struct gendisk *disk)
{
        return container_of(disk->private_data, struct scsi_disk, driver);
}

static void sstart_pg_init(struct hw_handler *hwh, unsigned bypassed,
			struct path *path)
{
	struct block_device *bdev = path->dev->bdev;
	struct gendisk *disk = bdev->bd_disk;
	struct scsi_device *sdev = scsi_disk(disk)->device;
	int result;

	result = scsi_ioctl(sdev, SCSI_IOCTL_START_UNIT, NULL);
	dm_pg_init_complete(path, result?MP_FAIL_PATH:0);
}

static int sstart_ctr(struct hw_handler *hwh, unsigned argc, char **argv)
{
	hwh->context = NULL;
	
	return 0;
}

static void sstart_dtr(struct hw_handler *hwh)
{
}

static unsigned sstart_err(struct hw_handler *hwh, struct bio *bio)
{
	/*
	 * Try default handler
	 * Is more needed here?
	 */
	return dm_scsi_err_handler(hwh, bio);
}

static struct hw_handler_type sstart_hwh = {
	.name = "sstart",
	.module = THIS_MODULE,
	.create = sstart_ctr,
	.destroy = sstart_dtr,
	.pg_init = sstart_pg_init,
	.error = sstart_err,
};

static int __init dm_sstart_init(void)
{
	int r = dm_register_hw_handler(&sstart_hwh);

	if (r < 0)
		DMERR("sstart: register failed %d", r);

	DMINFO("dm-sstart version 0.0.3 loaded");

	return r;
}

static void __exit dm_sstart_exit(void)
{
	int r = dm_unregister_hw_handler(&sstart_hwh);

	if (r < 0)
		DMERR("sstart: unregister failed %d", r);
}

module_init(dm_sstart_init);
module_exit(dm_sstart_exit);

MODULE_DESCRIPTION(DM_NAME "JBOD start/stop hardware handler");
MODULE_AUTHOR("whoever finishes this");
MODULE_LICENSE("GPL");
