/* data-source.c generated by valac 0.38.8, the Vala compiler
 * generated from data-source.vala, do not modify */

/* 
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_DATA_SOURCE (zeitgeist_data_source_get_type ())
#define ZEITGEIST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource))
#define ZEITGEIST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSourceClass))
#define ZEITGEIST_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DATA_SOURCE))
#define ZEITGEIST_IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DATA_SOURCE))
#define ZEITGEIST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSourceClass))

typedef struct _ZeitgeistDataSource ZeitgeistDataSource;
typedef struct _ZeitgeistDataSourceClass ZeitgeistDataSourceClass;
typedef struct _ZeitgeistDataSourcePrivate ZeitgeistDataSourcePrivate;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
enum  {
	ZEITGEIST_DATA_SOURCE_0_PROPERTY,
	ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY,
	ZEITGEIST_DATA_SOURCE_NAME_PROPERTY,
	ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY,
	ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY,
	ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY,
	ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY,
	ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY,
	ZEITGEIST_DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistDataSource {
	GObject parent_instance;
	ZeitgeistDataSourcePrivate * priv;
};

struct _ZeitgeistDataSourceClass {
	GObjectClass parent_class;
};

struct _ZeitgeistDataSourcePrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	GPtrArray* _event_templates;
	gboolean _enabled;
	gboolean _running;
	gint64 _timestamp;
};

typedef enum  {
	ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT,
	ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS
} ZeitgeistDataModelError;
#define ZEITGEIST_DATA_MODEL_ERROR zeitgeist_data_model_error_quark ()

static gpointer zeitgeist_data_source_parent_class = NULL;

GType zeitgeist_data_source_get_type (void) G_GNUC_CONST;
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSourcePrivate))
ZeitgeistDataSource* zeitgeist_data_source_new (void);
ZeitgeistDataSource* zeitgeist_data_source_construct (GType object_type);
void zeitgeist_data_source_set_enabled (ZeitgeistDataSource* self, gboolean value);
ZeitgeistDataSource* zeitgeist_data_source_new_full (const gchar* unique_id, const gchar* name, const gchar* description, GPtrArray* templates);
ZeitgeistDataSource* zeitgeist_data_source_construct_full (GType object_type, const gchar* unique_id, const gchar* name, const gchar* description, GPtrArray* templates);
GQuark zeitgeist_data_model_error_quark (void);
ZeitgeistDataSource* zeitgeist_data_source_new_from_variant (GVariant* variant, gboolean reset_running, GError** error);
ZeitgeistDataSource* zeitgeist_data_source_construct_from_variant (GType object_type, GVariant* variant, gboolean reset_running, GError** error);
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
void zeitgeist_data_source_set_unique_id (ZeitgeistDataSource* self, const gchar* value);
void zeitgeist_data_source_set_name (ZeitgeistDataSource* self, const gchar* value);
void zeitgeist_data_source_set_description (ZeitgeistDataSource* self, const gchar* value);
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error);
void zeitgeist_data_source_set_event_templates (ZeitgeistDataSource* self, GPtrArray* value);
void zeitgeist_data_source_set_running (ZeitgeistDataSource* self, gboolean value);
void zeitgeist_data_source_set_timestamp (ZeitgeistDataSource* self, gint64 value);
GVariant* zeitgeist_data_source_to_variant (ZeitgeistDataSource* self);
const gchar* zeitgeist_data_source_get_unique_id (ZeitgeistDataSource* self);
const gchar* zeitgeist_data_source_get_name (ZeitgeistDataSource* self);
const gchar* zeitgeist_data_source_get_description (ZeitgeistDataSource* self);
GPtrArray* zeitgeist_data_source_get_event_templates (ZeitgeistDataSource* self);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
gboolean zeitgeist_data_source_get_running (ZeitgeistDataSource* self);
gint64 zeitgeist_data_source_get_timestamp (ZeitgeistDataSource* self);
gboolean zeitgeist_data_source_get_enabled (ZeitgeistDataSource* self);
static void zeitgeist_data_source_finalize (GObject * obj);
static void _vala_zeitgeist_data_source_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_data_source_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES "a(sssa(" ZEITGEIST_UTILS_SIG_EVENT ")bxb)"
GPtrArray* zeitgeist_data_sources_from_variant (GVariant* sources_variant, GError** error);
static void _g_object_unref0_ (gpointer var);
GVariant* zeitgeist_data_sources_to_variant (GHashTable* sources);
static gint __lambda4_ (ZeitgeistDataSource* a, ZeitgeistDataSource* b);
static gint ___lambda4__gcompare_func (gconstpointer a, gconstpointer b);


/**
         * ZeitgeistDataSource
         *
         * Abstracts data sources used by the ZeitgeistDataSourceRegistry extension
         * 
         * ZeitgeistDataSource represents a data source used to insert events into
         * Zeitgeist. The data sources are identified using the unique_id property,
         * and when querying the data source registry you get other interesting
         * information like timestamp of the last action of the data source, flag
         * whether it is currently running etc.
         *
         */
ZeitgeistDataSource* zeitgeist_data_source_construct (GType object_type) {
	ZeitgeistDataSource * self = NULL;
	self = (ZeitgeistDataSource*) g_object_new (object_type, NULL);
	zeitgeist_data_source_set_enabled (self, TRUE);
	return self;
}


ZeitgeistDataSource* zeitgeist_data_source_new (void) {
	return zeitgeist_data_source_construct (ZEITGEIST_TYPE_DATA_SOURCE);
}


ZeitgeistDataSource* zeitgeist_data_source_construct_full (GType object_type, const gchar* unique_id, const gchar* name, const gchar* description, GPtrArray* templates) {
	ZeitgeistDataSource * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GPtrArray* _tmp3_;
	g_return_val_if_fail (unique_id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	_tmp0_ = unique_id;
	_tmp1_ = name;
	_tmp2_ = description;
	_tmp3_ = templates;
	self = (ZeitgeistDataSource*) g_object_new (object_type, "unique-id", _tmp0_, "name", _tmp1_, "description", _tmp2_, "event-templates", _tmp3_, NULL);
	zeitgeist_data_source_set_enabled (self, TRUE);
	return self;
}


ZeitgeistDataSource* zeitgeist_data_source_new_full (const gchar* unique_id, const gchar* name, const gchar* description, GPtrArray* templates) {
	return zeitgeist_data_source_construct_full (ZEITGEIST_TYPE_DATA_SOURCE, unique_id, name, description, templates);
}


ZeitgeistDataSource* zeitgeist_data_source_construct_from_variant (GType object_type, GVariant* variant, gboolean reset_running, GError** error) {
	ZeitgeistDataSource * self = NULL;
	gboolean _tmp0_ = FALSE;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	GVariantIter* iter = NULL;
	GVariant* _tmp5_;
	GVariantIter* _tmp6_;
	gsize _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	const gchar* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	const gchar* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	const gchar* _tmp16_;
	GPtrArray* _tmp17_ = NULL;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GPtrArray* _tmp20_;
	GPtrArray* _tmp21_;
	gsize _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (variant != NULL, NULL);
	self = (ZeitgeistDataSource*) g_object_new (object_type, NULL);
	_tmp1_ = variant;
	_tmp2_ = g_variant_get_type_string (_tmp1_);
	if (g_strcmp0 (_tmp2_, "(sssa(" ZEITGEIST_UTILS_SIG_EVENT ")bxb)") == 0) {
		_tmp0_ = TRUE;
	} else {
		GVariant* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = variant;
		_tmp4_ = g_variant_get_type_string (_tmp3_);
		_tmp0_ = g_strcmp0 (_tmp4_, "sssa(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0;
	}
	g_warn_if_fail (_tmp0_);
	_tmp5_ = variant;
	_tmp6_ = g_variant_iter_new (_tmp5_);
	iter = _tmp6_;
	_tmp7_ = g_variant_iter_n_children (iter);
	_vala_assert (_tmp7_ >= ((gsize) 4), "iter.n_children () >= 4");
	_tmp8_ = g_variant_iter_next_value (iter);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_get_string (_tmp9_, NULL);
	zeitgeist_data_source_set_unique_id (self, _tmp10_);
	_g_variant_unref0 (_tmp9_);
	_tmp11_ = g_variant_iter_next_value (iter);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_string (_tmp12_, NULL);
	zeitgeist_data_source_set_name (self, _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = g_variant_iter_next_value (iter);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_string (_tmp15_, NULL);
	zeitgeist_data_source_set_description (self, _tmp16_);
	_g_variant_unref0 (_tmp15_);
	_tmp18_ = g_variant_iter_next_value (iter);
	_tmp19_ = _tmp18_;
	_tmp20_ = zeitgeist_events_from_variant (_tmp19_, &_inner_error_);
	_tmp21_ = _tmp20_;
	_g_variant_unref0 (_tmp19_);
	_tmp17_ = _tmp21_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_data_source_set_event_templates (self, _tmp17_);
	_tmp22_ = g_variant_iter_n_children (iter);
	if (_tmp22_ > ((gsize) 4)) {
		GVariant* _tmp23_;
		GVariant* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		gint64 _tmp29_;
		GVariant* _tmp30_;
		GVariant* _tmp31_;
		gboolean _tmp32_;
		_tmp23_ = g_variant_iter_next_value (iter);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_variant_get_boolean (_tmp24_);
		zeitgeist_data_source_set_running (self, _tmp25_);
		_g_variant_unref0 (_tmp24_);
		_tmp26_ = reset_running;
		if (_tmp26_) {
			zeitgeist_data_source_set_running (self, FALSE);
		}
		_tmp27_ = g_variant_iter_next_value (iter);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_variant_get_int64 (_tmp28_);
		zeitgeist_data_source_set_timestamp (self, _tmp29_);
		_g_variant_unref0 (_tmp28_);
		_tmp30_ = g_variant_iter_next_value (iter);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_variant_get_boolean (_tmp31_);
		zeitgeist_data_source_set_enabled (self, _tmp32_);
		_g_variant_unref0 (_tmp31_);
	}
	_g_ptr_array_unref0 (_tmp17_);
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistDataSource* zeitgeist_data_source_new_from_variant (GVariant* variant, gboolean reset_running, GError** error) {
	return zeitgeist_data_source_construct_from_variant (ZEITGEIST_TYPE_DATA_SOURCE, variant, reset_running, error);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


GVariant* zeitgeist_data_source_to_variant (ZeitgeistDataSource* self) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	const gchar* _tmp5_;
	GVariantBuilder* _tmp6_;
	const gchar* _tmp7_;
	GVariantBuilder* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GPtrArray* _tmp11_;
	GVariantBuilder* _tmp23_;
	gboolean _tmp24_;
	GVariantBuilder* _tmp25_;
	gint64 _tmp26_;
	GVariantBuilder* _tmp27_;
	gboolean _tmp28_;
	GVariantBuilder* _tmp29_;
	GVariant* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(sssa(" ZEITGEIST_UTILS_SIG_EVENT ")bxb)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = vb;
	_tmp5_ = self->priv->_unique_id;
	g_variant_builder_add (_tmp4_, "s", _tmp5_, NULL);
	_tmp6_ = vb;
	_tmp7_ = self->priv->_name;
	g_variant_builder_add (_tmp6_, "s", _tmp7_, NULL);
	_tmp8_ = vb;
	_tmp9_ = self->priv->_description;
	g_variant_builder_add (_tmp8_, "s", _tmp9_, NULL);
	_tmp11_ = self->priv->_event_templates;
	if (_tmp11_ != NULL) {
		GPtrArray* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = self->priv->_event_templates;
		_tmp13_ = g_ptr_array_get_length (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ > 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GVariantBuilder* _tmp15_;
		GPtrArray* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		_tmp15_ = vb;
		_tmp16_ = self->priv->_event_templates;
		_tmp17_ = zeitgeist_events_to_variant (_tmp16_);
		_tmp18_ = _tmp17_;
		g_variant_builder_add_value (_tmp15_, _tmp18_);
		_g_variant_unref0 (_tmp18_);
	} else {
		GVariantBuilder* _tmp19_;
		GVariantType* _tmp20_;
		GVariantType* _tmp21_;
		GVariantBuilder* _tmp22_;
		_tmp19_ = vb;
		_tmp20_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
		_tmp21_ = _tmp20_;
		g_variant_builder_open (_tmp19_, _tmp21_);
		_g_variant_type_free0 (_tmp21_);
		_tmp22_ = vb;
		g_variant_builder_close (_tmp22_);
	}
	_tmp23_ = vb;
	_tmp24_ = self->priv->_running;
	g_variant_builder_add (_tmp23_, "b", _tmp24_, NULL);
	_tmp25_ = vb;
	_tmp26_ = self->priv->_timestamp;
	g_variant_builder_add (_tmp25_, "x", _tmp26_, NULL);
	_tmp27_ = vb;
	_tmp28_ = self->priv->_enabled;
	g_variant_builder_add (_tmp27_, "b", _tmp28_, NULL);
	_tmp29_ = vb;
	_tmp30_ = g_variant_builder_end (_tmp29_);
	g_variant_ref_sink (_tmp30_);
	result = _tmp30_;
	_g_variant_builder_unref0 (vb);
	return result;
}


const gchar* zeitgeist_data_source_get_unique_id (ZeitgeistDataSource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


void zeitgeist_data_source_set_unique_id (ZeitgeistDataSource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, zeitgeist_data_source_get_unique_id (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY]);
	}
}


const gchar* zeitgeist_data_source_get_name (ZeitgeistDataSource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void zeitgeist_data_source_set_name (ZeitgeistDataSource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, zeitgeist_data_source_get_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_NAME_PROPERTY]);
	}
}


const gchar* zeitgeist_data_source_get_description (ZeitgeistDataSource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


void zeitgeist_data_source_set_description (ZeitgeistDataSource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, zeitgeist_data_source_get_description (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY]);
	}
}


GPtrArray* zeitgeist_data_source_get_event_templates (ZeitgeistDataSource* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_templates;
	result = _tmp0_;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void zeitgeist_data_source_set_event_templates (ZeitgeistDataSource* self, GPtrArray* value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_data_source_get_event_templates (self) != value) {
		GPtrArray* _tmp0_;
		GPtrArray* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
		_g_ptr_array_unref0 (self->priv->_event_templates);
		self->priv->_event_templates = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY]);
	}
}


gboolean zeitgeist_data_source_get_enabled (ZeitgeistDataSource* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


void zeitgeist_data_source_set_enabled (ZeitgeistDataSource* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_data_source_get_enabled (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_enabled = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY]);
	}
}


gboolean zeitgeist_data_source_get_running (ZeitgeistDataSource* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_running;
	result = _tmp0_;
	return result;
}


void zeitgeist_data_source_set_running (ZeitgeistDataSource* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_data_source_get_running (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_running = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY]);
	}
}


gint64 zeitgeist_data_source_get_timestamp (ZeitgeistDataSource* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}


void zeitgeist_data_source_set_timestamp (ZeitgeistDataSource* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_data_source_get_timestamp (self) != value) {
		gint64 _tmp0_;
		_tmp0_ = value;
		self->priv->_timestamp = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY]);
	}
}


static void zeitgeist_data_source_class_init (ZeitgeistDataSourceClass * klass) {
	zeitgeist_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDataSourcePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_data_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_data_source_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_data_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_NAME_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY] = g_param_spec_boxed ("event-templates", "event-templates", "event-templates", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY] = g_param_spec_boolean ("running", "running", "running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY, zeitgeist_data_source_properties[ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void zeitgeist_data_source_instance_init (ZeitgeistDataSource * self) {
	self->priv = ZEITGEIST_DATA_SOURCE_GET_PRIVATE (self);
}


static void zeitgeist_data_source_finalize (GObject * obj) {
	ZeitgeistDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_ptr_array_unref0 (self->priv->_event_templates);
	G_OBJECT_CLASS (zeitgeist_data_source_parent_class)->finalize (obj);
}


GType zeitgeist_data_source_get_type (void) {
	static volatile gsize zeitgeist_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDataSource), 0, (GInstanceInitFunc) zeitgeist_data_source_instance_init, NULL };
		GType zeitgeist_data_source_type_id;
		zeitgeist_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDataSource", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_data_source_type_id__volatile, zeitgeist_data_source_type_id);
	}
	return zeitgeist_data_source_type_id__volatile;
}


static void _vala_zeitgeist_data_source_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
	switch (property_id) {
		case ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, zeitgeist_data_source_get_unique_id (self));
		break;
		case ZEITGEIST_DATA_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, zeitgeist_data_source_get_name (self));
		break;
		case ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, zeitgeist_data_source_get_description (self));
		break;
		case ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY:
		g_value_set_boxed (value, zeitgeist_data_source_get_event_templates (self));
		break;
		case ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY:
		g_value_set_boolean (value, zeitgeist_data_source_get_enabled (self));
		break;
		case ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY:
		g_value_set_boolean (value, zeitgeist_data_source_get_running (self));
		break;
		case ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, zeitgeist_data_source_get_timestamp (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_data_source_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
	switch (property_id) {
		case ZEITGEIST_DATA_SOURCE_UNIQUE_ID_PROPERTY:
		zeitgeist_data_source_set_unique_id (self, g_value_get_string (value));
		break;
		case ZEITGEIST_DATA_SOURCE_NAME_PROPERTY:
		zeitgeist_data_source_set_name (self, g_value_get_string (value));
		break;
		case ZEITGEIST_DATA_SOURCE_DESCRIPTION_PROPERTY:
		zeitgeist_data_source_set_description (self, g_value_get_string (value));
		break;
		case ZEITGEIST_DATA_SOURCE_EVENT_TEMPLATES_PROPERTY:
		zeitgeist_data_source_set_event_templates (self, g_value_get_boxed (value));
		break;
		case ZEITGEIST_DATA_SOURCE_ENABLED_PROPERTY:
		zeitgeist_data_source_set_enabled (self, g_value_get_boolean (value));
		break;
		case ZEITGEIST_DATA_SOURCE_RUNNING_PROPERTY:
		zeitgeist_data_source_set_running (self, g_value_get_boolean (value));
		break;
		case ZEITGEIST_DATA_SOURCE_TIMESTAMP_PROPERTY:
		zeitgeist_data_source_set_timestamp (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


GPtrArray* zeitgeist_data_sources_from_variant (GVariant* sources_variant, GError** error) {
	GPtrArray* result = NULL;
	GPtrArray* sources = NULL;
	GPtrArray* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sources_variant != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	sources = _tmp0_;
	_tmp1_ = sources_variant;
	_tmp2_ = g_variant_get_type_string (_tmp1_);
	g_warn_if_fail (g_strcmp0 (_tmp2_, ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES) == 0);
	{
		GVariantIter* _ds_variant_it = NULL;
		GVariant* _tmp3_;
		GVariantIter* _tmp4_;
		GVariant* ds_variant = NULL;
		_tmp3_ = sources_variant;
		_tmp4_ = g_variant_iter_new (_tmp3_);
		_ds_variant_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_;
			GVariant* _tmp7_;
			ZeitgeistDataSource* _tmp8_ = NULL;
			GVariant* _tmp9_;
			ZeitgeistDataSource* _tmp10_;
			GPtrArray* _tmp11_;
			ZeitgeistDataSource* _tmp12_;
			_tmp5_ = _ds_variant_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (ds_variant);
			ds_variant = _tmp6_;
			_tmp7_ = ds_variant;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp9_ = ds_variant;
			_tmp10_ = zeitgeist_data_source_new_from_variant (_tmp9_, FALSE, &_inner_error_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_ptr_array_unref0 (sources);
					return NULL;
				} else {
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_ptr_array_unref0 (sources);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp11_ = sources;
			_tmp12_ = _tmp8_;
			_tmp8_ = NULL;
			g_ptr_array_add (_tmp11_, _tmp12_);
			_g_object_unref0 (_tmp8_);
		}
		_g_variant_unref0 (ds_variant);
		_g_variant_iter_free0 (_ds_variant_it);
	}
	result = sources;
	return result;
}


static gint __lambda4_ (ZeitgeistDataSource* a, ZeitgeistDataSource* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	ZeitgeistDataSource* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ZeitgeistDataSource* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = zeitgeist_data_source_get_unique_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = zeitgeist_data_source_get_unique_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
	result = _tmp7_;
	return result;
}


static gint ___lambda4__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda4_ ((ZeitgeistDataSource*) a, (ZeitgeistDataSource*) b);
	return result;
}


GVariant* zeitgeist_data_sources_to_variant (GHashTable* sources) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GList* data_sources = NULL;
	GHashTable* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GVariantBuilder* _tmp11_;
	GVariant* _tmp12_;
	g_return_val_if_fail (sources != NULL, NULL);
	_tmp0_ = g_variant_type_new (ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = sources;
	_tmp5_ = g_hash_table_get_values (_tmp4_);
	data_sources = _tmp5_;
	data_sources = g_list_sort (data_sources, ___lambda4__gcompare_func);
	_tmp6_ = data_sources;
	{
		GList* ds_collection = NULL;
		GList* ds_it = NULL;
		ds_collection = _tmp6_;
		for (ds_it = ds_collection; ds_it != NULL; ds_it = ds_it->next) {
			ZeitgeistDataSource* ds = NULL;
			ds = (ZeitgeistDataSource*) ds_it->data;
			{
				GVariantBuilder* _tmp7_;
				ZeitgeistDataSource* _tmp8_;
				GVariant* _tmp9_;
				GVariant* _tmp10_;
				_tmp7_ = vb;
				_tmp8_ = ds;
				_tmp9_ = zeitgeist_data_source_to_variant (_tmp8_);
				_tmp10_ = _tmp9_;
				g_variant_builder_add_value (_tmp7_, _tmp10_);
				_g_variant_unref0 (_tmp10_);
			}
		}
	}
	_tmp11_ = vb;
	_tmp12_ = g_variant_builder_end (_tmp11_);
	g_variant_ref_sink (_tmp12_);
	result = _tmp12_;
	_g_list_free0 (data_sources);
	_g_variant_builder_unref0 (vb);
	return result;
}



