/* kde-recent-document-provider.c generated by valac 0.38.8, the Vala compiler
 * generated from kde-recent-document-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"
#include <gio/gdesktopappinfo.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_RECENT_DOCUMENTS_KDE (recent_documents_kde_get_type ())
#define RECENT_DOCUMENTS_KDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDE))
#define RECENT_DOCUMENTS_KDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDEClass))
#define IS_RECENT_DOCUMENTS_KDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_DOCUMENTS_KDE))
#define IS_RECENT_DOCUMENTS_KDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_DOCUMENTS_KDE))
#define RECENT_DOCUMENTS_KDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDEClass))

typedef struct _RecentDocumentsKDE RecentDocumentsKDE;
typedef struct _RecentDocumentsKDEClass RecentDocumentsKDEClass;
typedef struct _RecentDocumentsKDEPrivate RecentDocumentsKDEPrivate;
enum  {
	RECENT_DOCUMENTS_KDE_0_PROPERTY,
	RECENT_DOCUMENTS_KDE_UNIQUE_ID_PROPERTY,
	RECENT_DOCUMENTS_KDE_NAME_PROPERTY,
	RECENT_DOCUMENTS_KDE_DESCRIPTION_PROPERTY,
	RECENT_DOCUMENTS_KDE_DATAHUB_PROPERTY,
	RECENT_DOCUMENTS_KDE_ENABLED_PROPERTY,
	RECENT_DOCUMENTS_KDE_REGISTER_PROPERTY,
	RECENT_DOCUMENTS_KDE_NUM_PROPERTIES
};
static GParamSpec* recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RecentDocumentsKdeProcessEventData RecentDocumentsKdeProcessEventData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _RecentDocumentsKdeParseFileData RecentDocumentsKdeParseFileData;
typedef struct _RecentDocumentsKdeCrawlAllItemsData RecentDocumentsKdeCrawlAllItemsData;

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _RecentDocumentsKDE {
	DataProvider parent_instance;
	RecentDocumentsKDEPrivate * priv;
};

struct _RecentDocumentsKDEClass {
	DataProviderClass parent_class;
};

struct _RecentDocumentsKDEPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	gchar* recent_document_path;
	GFile* recent_documents_directory;
	GFileMonitor* monitor;
	gchar** ignored_actors;
	gint ignored_actors_length1;
	gint _ignored_actors_size_;
	GRegex* recent_regex;
	GRegex* url_regex;
};

struct _RecentDocumentsKdeProcessEventData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RecentDocumentsKDE* self;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event_type;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GFileMonitorEvent _tmp2_;
	GFileMonitorEvent _tmp3_;
	GFileMonitorEvent _tmp4_;
	ZeitgeistEvent* event;
	GFile* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistEvent* _tmp7_;
	GPtrArray* events;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	ZeitgeistEvent* _tmp10_;
	GPtrArray* _tmp11_;
	GError* err;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError * _inner_error_;
};

struct _RecentDocumentsKdeParseFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RecentDocumentsKDE* self;
	GFile* file;
	ZeitgeistEvent* result;
	GTimeVal timeval;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GFileInfo* recent_info;
	GFile* _tmp5_;
	GFileInfo* _tmp6_;
	GFileType file_type;
	GFileInfo* _tmp7_;
	guint32 _tmp8_;
	GFileType _tmp9_;
	GFileInfo* _tmp10_;
	GTimeVal _tmp11_;
	gint64 event_time;
	GTimeVal _tmp12_;
	gint64 _tmp13_;
	gchar* content;
	GFile* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GRegex* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GKeyFile* recent_file;
	GKeyFile* _tmp25_;
	GKeyFile* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gchar* basename;
	GKeyFile* _tmp31_;
	gchar* _tmp32_;
	gchar* uri;
	GKeyFile* _tmp33_;
	gchar* _tmp34_;
	gchar* desktop_entry_name;
	GKeyFile* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GRegex* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* actor;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	GFile* subject_file;
	const gchar* _tmp52_;
	GFile* _tmp53_;
	GFileInfo* subject_info;
	GFile* _tmp54_;
	GFileInfo* _tmp55_;
	GFileInfo* _tmp56_;
	GTimeVal _tmp57_;
	gint64 modification_time;
	GTimeVal _tmp58_;
	gint64 _tmp59_;
	GFileInfo* _tmp60_;
	guint64 _tmp61_;
	GFileInfo* _tmp62_;
	guint32 _tmp63_;
	gint64 creation_time;
	GTimeVal _tmp64_;
	gint64 _tmp65_;
	gchar* mimetype;
	GFileInfo* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* event_interpretation;
	gint64 creation_diff;
	gint64 _tmp69_;
	gint64 _tmp70_;
	gint64 modification_diff;
	gint64 _tmp71_;
	gint64 _tmp72_;
	gint64 _tmp73_;
	gint64 _tmp74_;
	gchar* _tmp75_;
	gint64 _tmp76_;
	gint64 _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* origin;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	ZeitgeistSubject* subject;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	ZeitgeistSubject* _tmp90_;
	ZeitgeistEvent* event;
	const gchar* _tmp91_;
	const gchar* _tmp92_;
	ZeitgeistEvent* _tmp93_;
	ZeitgeistEvent* _tmp94_;
	ZeitgeistSubject* _tmp95_;
	ZeitgeistEvent* _tmp96_;
	gint64 _tmp97_;
	GError * _inner_error_;
};

struct _RecentDocumentsKdeCrawlAllItemsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RecentDocumentsKDE* self;
	GPtrArray* events;
	GPtrArray* _tmp0_;
	GFile* directory;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFileEnumerator* enumerator;
	GFile* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileInfo* fi;
	GFileInfo* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileInfo* _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GFile* file;
	GFile* _tmp10_;
	GFileInfo* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	ZeitgeistEvent* event;
	GFile* _tmp14_;
	ZeitgeistEvent* _tmp15_;
	ZeitgeistEvent* _tmp16_;
	GPtrArray* _tmp17_;
	ZeitgeistEvent* _tmp18_;
	GError* err;
	GFileEnumerator* _tmp19_;
	GPtrArray* _tmp20_;
	GError * _inner_error_;
};


static gpointer recent_documents_kde_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType recent_documents_kde_get_type (void) G_GNUC_CONST;
#define RECENT_DOCUMENTS_KDE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDEPrivate))
#define RECENT_DOCUMENTS_KDE_RECENT_DOCUMENTS_PATH "/.kde/share/apps/RecentDocuments"
#define RECENT_DOCUMENTS_KDE_RECENT_FILE_GROUP "Desktop Entry"
#define RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR ","
#define RECENT_DOCUMENTS_KDE_FILE_ATTRIBUTE_QUERY_RECENT G_FILE_ATTRIBUTE_STANDARD_TYPE RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR G_FILE_ATTRIBUTE_TIME_MODIFIED RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC
#define RECENT_DOCUMENTS_KDE_FILE_ATTRIBUTE_QUERY_SUBJECT G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR G_FILE_ATTRIBUTE_TIME_MODIFIED RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR G_FILE_ATTRIBUTE_TIME_CHANGED RECENT_DOCUMENTS_KDE_ATTRIBUTE_SEPARATOR G_FILE_ATTRIBUTE_TIME_CHANGED_USEC
#define RECENT_DOCUMENTS_KDE_TIME_EPSILON 100
#define RECENT_DOCUMENTS_KDE_RECENT_REGEX_REPLACEMENT "URL="
RecentDocumentsKDE* recent_documents_kde_new (DataHub* datahub, GError** error);
RecentDocumentsKDE* recent_documents_kde_construct (GType object_type, DataHub* datahub, GError** error);
static void recent_documents_kde_real_start (DataProvider* base);
DataHub* data_provider_get_datahub (DataProvider* self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
static void recent_documents_kde_process_event (RecentDocumentsKDE* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void recent_documents_kde_process_event_finish (RecentDocumentsKDE* self, GAsyncResult* _res_);
static void _recent_documents_kde_process_event_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void recent_documents_kde_crawl_all_items (RecentDocumentsKDE* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void recent_documents_kde_crawl_all_items_finish (RecentDocumentsKDE* self, GAsyncResult* _res_, GError** error);
static void recent_documents_kde_real_stop (DataProvider* base);
static void recent_documents_kde_process_event_data_free (gpointer _data);
static void recent_documents_kde_process_event_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean recent_documents_kde_process_event_co (RecentDocumentsKdeProcessEventData* _data_);
static void recent_documents_kde_parse_file (RecentDocumentsKDE* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static ZeitgeistEvent* recent_documents_kde_parse_file_finish (RecentDocumentsKDE* self, GAsyncResult* _res_, GError** error);
static void recent_documents_kde_process_event_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void recent_documents_kde_parse_file_data_free (gpointer _data);
static void recent_documents_kde_parse_file_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean recent_documents_kde_parse_file_co (RecentDocumentsKdeParseFileData* _data_);
static void recent_documents_kde_parse_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* utils_get_file_contents (GFile* file);
static gchar* recent_documents_kde_get_actor_for_desktop_entry_name (RecentDocumentsKDE* self, const gchar* desktop_entry_name);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static void recent_documents_kde_crawl_all_items_data_free (gpointer _data);
static void recent_documents_kde_crawl_all_items_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean recent_documents_kde_crawl_all_items_co (RecentDocumentsKdeCrawlAllItemsData* _data_);
static void recent_documents_kde_crawl_all_items_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * recent_documents_kde_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void recent_documents_kde_finalize (GObject * obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_recent_documents_kde_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_recent_documents_kde_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


RecentDocumentsKDE* recent_documents_kde_construct (GType object_type, DataHub* datahub, GError** error) {
	RecentDocumentsKDE * self = NULL;
	DataHub* _tmp0_;
	g_return_val_if_fail (datahub != NULL, NULL);
	_tmp0_ = datahub;
	self = (RecentDocumentsKDE*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,kde-recent", "name", "Recently Used Documents (KDE)", "description", "Logs events from KRecentDocument", "datahub", _tmp0_, NULL);
	return self;
}


RecentDocumentsKDE* recent_documents_kde_new (DataHub* datahub, GError** error) {
	return recent_documents_kde_construct (TYPE_RECENT_DOCUMENTS_KDE, datahub, error);
}


static void _recent_documents_kde_process_event_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	recent_documents_kde_process_event ((RecentDocumentsKDE*) self, file, other_file, event_type, NULL, NULL);
}


static void recent_documents_kde_real_start (DataProvider* base) {
	RecentDocumentsKDE * self;
	DataHub* _tmp0_;
	DataHub* _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	GFileMonitor* _tmp4_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = data_provider_get_datahub ((DataProvider*) self);
	_tmp1_ = _tmp0_;
	_tmp3_ = data_hub_get_data_source_actors (_tmp1_, TRUE, &_tmp2_);
	self->priv->ignored_actors = (_vala_array_free (self->priv->ignored_actors, self->priv->ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	self->priv->ignored_actors = _tmp3_;
	self->priv->ignored_actors_length1 = _tmp2_;
	self->priv->_ignored_actors_size_ = self->priv->ignored_actors_length1;
	_tmp4_ = self->priv->monitor;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _recent_documents_kde_process_event_g_file_monitor_changed, self, 0);
	recent_documents_kde_crawl_all_items (self, NULL, NULL);
}


static void recent_documents_kde_real_stop (DataProvider* base) {
	RecentDocumentsKDE * self;
	GFileMonitor* _tmp0_;
	guint _tmp1_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _recent_documents_kde_process_event_g_file_monitor_changed, self);
}


static void recent_documents_kde_process_event_data_free (gpointer _data) {
	RecentDocumentsKdeProcessEventData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->other_file);
	_g_object_unref0 (_data_->self);
	g_slice_free (RecentDocumentsKdeProcessEventData, _data_);
}


static void recent_documents_kde_process_event_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RecentDocumentsKdeProcessEventData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void recent_documents_kde_process_event (RecentDocumentsKDE* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RecentDocumentsKdeProcessEventData* _data_;
	RecentDocumentsKDE* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFileMonitorEvent _tmp5_;
	_data_ = g_slice_new0 (RecentDocumentsKdeProcessEventData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, recent_documents_kde_process_event_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, recent_documents_kde_process_event_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = other_file;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->other_file);
	_data_->other_file = _tmp4_;
	_tmp5_ = event_type;
	_data_->event_type = _tmp5_;
	recent_documents_kde_process_event_co (_data_);
}


static void recent_documents_kde_process_event_finish (RecentDocumentsKDE* self, GAsyncResult* _res_) {
	RecentDocumentsKdeProcessEventData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void recent_documents_kde_process_event_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RecentDocumentsKdeProcessEventData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	recent_documents_kde_process_event_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gboolean recent_documents_kde_process_event_co (RecentDocumentsKdeProcessEventData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = _data_->event_type;
	if (_data_->_tmp2_ == G_FILE_MONITOR_EVENT_CREATED) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->event_type;
		_data_->_tmp1_ = _data_->_tmp3_ == G_FILE_MONITOR_EVENT_CHANGED;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->event_type;
		_data_->_tmp0_ = _data_->_tmp4_ == G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED;
	}
	if (_data_->_tmp0_) {
		{
			_data_->_tmp5_ = _data_->file;
			_data_->_state_ = 1;
			recent_documents_kde_parse_file (_data_->self, _data_->_tmp5_, recent_documents_kde_process_event_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = recent_documents_kde_parse_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->event = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp7_ = _data_->event;
			if (_data_->_tmp7_ != NULL) {
				_data_->_tmp8_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
				_data_->events = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->events;
				_data_->_tmp10_ = _data_->event;
				_data_->event = NULL;
				g_ptr_array_add (_data_->_tmp9_, _data_->_tmp10_);
				_data_->_tmp11_ = _data_->events;
				g_signal_emit_by_name ((DataProvider*) _data_->self, "items-available", _data_->_tmp11_);
				_g_ptr_array_unref0 (_data_->events);
			}
			_g_object_unref0 (_data_->event);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->err = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = _data_->file;
			_data_->_tmp13_ = g_file_get_path (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp15_ = _data_->err;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			g_warning ("kde-recent-document-provider.vala:131: Couldn't process %s: %s", _data_->_tmp14_, _data_->_tmp16_);
			_g_free0 (_data_->_tmp14_);
			_g_error_free0 (_data_->err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void recent_documents_kde_parse_file_data_free (gpointer _data) {
	RecentDocumentsKdeParseFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RecentDocumentsKdeParseFileData, _data_);
}


static void recent_documents_kde_parse_file_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RecentDocumentsKdeParseFileData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void recent_documents_kde_parse_file (RecentDocumentsKDE* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RecentDocumentsKdeParseFileData* _data_;
	RecentDocumentsKDE* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data_ = g_slice_new0 (RecentDocumentsKdeParseFileData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, recent_documents_kde_parse_file_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, recent_documents_kde_parse_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	recent_documents_kde_parse_file_co (_data_);
}


static ZeitgeistEvent* recent_documents_kde_parse_file_finish (RecentDocumentsKDE* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistEvent* result;
	RecentDocumentsKdeParseFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void recent_documents_kde_parse_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RecentDocumentsKdeParseFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	recent_documents_kde_parse_file_co (_data_);
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean recent_documents_kde_parse_file_co (RecentDocumentsKdeParseFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->file;
	_data_->_tmp1_ = g_file_get_basename (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_str_has_suffix (_data_->_tmp2_, ".desktop");
	_data_->_tmp4_ = !_data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	if (_data_->_tmp4_) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->file;
	_data_->_state_ = 1;
	g_file_query_info_async (_data_->_tmp5_, RECENT_DOCUMENTS_KDE_FILE_ATTRIBUTE_QUERY_RECENT, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, recent_documents_kde_parse_file_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = g_file_query_info_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
	_data_->recent_info = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->recent_info;
	_data_->_tmp8_ = g_file_info_get_attribute_uint32 (_data_->_tmp7_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
	_data_->file_type = (GFileType) _data_->_tmp8_;
	_data_->_tmp9_ = _data_->file_type;
	if (_data_->_tmp9_ != G_FILE_TYPE_REGULAR) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->recent_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->recent_info;
	memset (&_data_->_tmp11_, 0, sizeof (GTimeVal));
	g_file_info_get_modification_time (_data_->_tmp10_, &_data_->_tmp11_);
	_data_->timeval = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->timeval;
	_data_->_tmp13_ = zeitgeist_timestamp_from_timeval (&_data_->_tmp12_);
	_data_->event_time = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->file;
	_data_->_tmp15_ = utils_get_file_contents (_data_->_tmp14_);
	_data_->content = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->content;
	if (_data_->_tmp16_ == NULL) {
		_data_->result = NULL;
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->self->priv->recent_regex;
	_data_->_tmp19_ = _data_->content;
	_data_->_tmp20_ = _data_->content;
	_data_->_tmp21_ = strlen (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = g_regex_replace (_data_->_tmp18_, _data_->_tmp19_, (gssize) _data_->_tmp22_, 0, RECENT_DOCUMENTS_KDE_RECENT_REGEX_REPLACEMENT, 0, &_data_->_inner_error_);
	_data_->_tmp17_ = _data_->_tmp23_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp24_ = _data_->_tmp17_;
	_data_->_tmp17_ = NULL;
	_g_free0 (_data_->content);
	_data_->content = _data_->_tmp24_;
	_data_->_tmp25_ = g_key_file_new ();
	_data_->recent_file = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->recent_file;
	_data_->_tmp27_ = _data_->content;
	_data_->_tmp28_ = _data_->content;
	_data_->_tmp29_ = strlen (_data_->_tmp28_);
	_data_->_tmp30_ = _data_->_tmp29_;
	g_key_file_load_from_data (_data_->_tmp26_, _data_->_tmp27_, (gsize) _data_->_tmp30_, G_KEY_FILE_NONE, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = _data_->recent_file;
	_data_->_tmp32_ = g_key_file_get_string (_data_->_tmp31_, RECENT_DOCUMENTS_KDE_RECENT_FILE_GROUP, "Name", &_data_->_inner_error_);
	_data_->basename = _data_->_tmp32_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp33_ = _data_->recent_file;
	_data_->_tmp34_ = g_key_file_get_string (_data_->_tmp33_, RECENT_DOCUMENTS_KDE_RECENT_FILE_GROUP, "URL", &_data_->_inner_error_);
	_data_->uri = _data_->_tmp34_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->basename);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = _data_->recent_file;
	_data_->_tmp36_ = g_key_file_get_string (_data_->_tmp35_, RECENT_DOCUMENTS_KDE_RECENT_FILE_GROUP, "X-KDE-LastOpenedWith", &_data_->_inner_error_);
	_data_->desktop_entry_name = _data_->_tmp36_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->basename);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = _data_->self->priv->url_regex;
	_data_->_tmp39_ = _data_->uri;
	_data_->_tmp40_ = _data_->uri;
	_data_->_tmp41_ = strlen (_data_->_tmp40_);
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = g_get_home_dir ();
	_data_->_tmp44_ = g_regex_replace (_data_->_tmp38_, _data_->_tmp39_, (gssize) _data_->_tmp42_, 0, _data_->_tmp43_, 0, &_data_->_inner_error_);
	_data_->_tmp37_ = _data_->_tmp44_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->desktop_entry_name);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->basename);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp45_ = _data_->_tmp37_;
	_data_->_tmp37_ = NULL;
	_g_free0 (_data_->uri);
	_data_->uri = _data_->_tmp45_;
	_data_->_tmp46_ = _data_->desktop_entry_name;
	_data_->_tmp47_ = recent_documents_kde_get_actor_for_desktop_entry_name (_data_->self, _data_->_tmp46_);
	_data_->actor = _data_->_tmp47_;
	_data_->_tmp48_ = _data_->actor;
	if (_data_->_tmp48_ == NULL) {
		_data_->_tmp49_ = _data_->desktop_entry_name;
		g_warning ("kde-recent-document-provider.vala:174: Couldn't find actor for '%s'.", _data_->_tmp49_);
		_data_->result = NULL;
		_g_free0 (_data_->actor);
		_g_free0 (_data_->_tmp37_);
		_g_free0 (_data_->desktop_entry_name);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->basename);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp50_ = _data_->actor;
	_data_->_tmp51_ = _data_->self->priv->ignored_actors;
	_data_->_tmp51__length1 = _data_->self->priv->ignored_actors_length1;
	if (_vala_string_array_contains (_data_->_tmp51_, _data_->_tmp51__length1, _data_->_tmp50_)) {
		_data_->result = NULL;
		_g_free0 (_data_->actor);
		_g_free0 (_data_->_tmp37_);
		_g_free0 (_data_->desktop_entry_name);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->basename);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp52_ = _data_->uri;
	_data_->_tmp53_ = g_file_new_for_uri (_data_->_tmp52_);
	_data_->subject_file = _data_->_tmp53_;
	_data_->_tmp54_ = _data_->subject_file;
	_data_->_tmp55_ = g_file_query_info (_data_->_tmp54_, RECENT_DOCUMENTS_KDE_FILE_ATTRIBUTE_QUERY_SUBJECT, G_FILE_QUERY_INFO_NONE, NULL, &_data_->_inner_error_);
	_data_->subject_info = _data_->_tmp55_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->subject_file);
		_g_free0 (_data_->actor);
		_g_free0 (_data_->_tmp37_);
		_g_free0 (_data_->desktop_entry_name);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->basename);
		_g_key_file_unref0 (_data_->recent_file);
		_g_free0 (_data_->_tmp17_);
		_g_free0 (_data_->content);
		_g_object_unref0 (_data_->recent_info);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp56_ = _data_->subject_info;
	memset (&_data_->_tmp57_, 0, sizeof (GTimeVal));
	g_file_info_get_modification_time (_data_->_tmp56_, &_data_->_tmp57_);
	_data_->timeval = _data_->_tmp57_;
	_data_->_tmp58_ = _data_->timeval;
	_data_->_tmp59_ = zeitgeist_timestamp_from_timeval (&_data_->_tmp58_);
	_data_->modification_time = _data_->_tmp59_;
	_data_->_tmp60_ = _data_->subject_info;
	_data_->_tmp61_ = g_file_info_get_attribute_uint64 (_data_->_tmp60_, G_FILE_ATTRIBUTE_TIME_CHANGED);
	_data_->timeval.tv_sec = (glong) _data_->_tmp61_;
	_data_->_tmp62_ = _data_->subject_info;
	_data_->_tmp63_ = g_file_info_get_attribute_uint32 (_data_->_tmp62_, G_FILE_ATTRIBUTE_TIME_CHANGED_USEC);
	_data_->timeval.tv_usec = (glong) _data_->_tmp63_;
	_data_->_tmp64_ = _data_->timeval;
	_data_->_tmp65_ = zeitgeist_timestamp_from_timeval (&_data_->_tmp64_);
	_data_->creation_time = _data_->_tmp65_;
	_data_->_tmp66_ = _data_->subject_info;
	_data_->_tmp67_ = g_file_info_get_attribute_string (_data_->_tmp66_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	_data_->_tmp68_ = g_strdup (_data_->_tmp67_);
	_data_->mimetype = _data_->_tmp68_;
	_data_->_tmp69_ = _data_->event_time;
	_data_->_tmp70_ = _data_->creation_time;
	_data_->creation_diff = _data_->_tmp69_ - _data_->_tmp70_;
	_data_->_tmp71_ = _data_->event_time;
	_data_->_tmp72_ = _data_->modification_time;
	_data_->modification_diff = _data_->_tmp71_ - _data_->_tmp72_;
	_data_->_tmp73_ = _data_->creation_diff;
	_data_->_tmp74_ = llabs (_data_->_tmp73_);
	if (_data_->_tmp74_ < ((gint64) RECENT_DOCUMENTS_KDE_TIME_EPSILON)) {
		_data_->_tmp75_ = g_strdup (ZEITGEIST_ZG_CREATE_EVENT);
		_g_free0 (_data_->event_interpretation);
		_data_->event_interpretation = _data_->_tmp75_;
	} else {
		_data_->_tmp76_ = _data_->modification_diff;
		_data_->_tmp77_ = llabs (_data_->_tmp76_);
		if (_data_->_tmp77_ < ((gint64) RECENT_DOCUMENTS_KDE_TIME_EPSILON)) {
			_data_->_tmp78_ = g_strdup (ZEITGEIST_ZG_MODIFY_EVENT);
			_g_free0 (_data_->event_interpretation);
			_data_->event_interpretation = _data_->_tmp78_;
		} else {
			_data_->_tmp79_ = g_strdup (ZEITGEIST_ZG_ACCESS_EVENT);
			_g_free0 (_data_->event_interpretation);
			_data_->event_interpretation = _data_->_tmp79_;
		}
	}
	_data_->_tmp80_ = _data_->uri;
	_data_->_tmp81_ = g_path_get_dirname (_data_->_tmp80_);
	_data_->origin = _data_->_tmp81_;
	_data_->_tmp82_ = _data_->uri;
	_data_->_tmp83_ = _data_->mimetype;
	_data_->_tmp84_ = zeitgeist_interpretation_for_mimetype (_data_->_tmp83_);
	_data_->_tmp85_ = _data_->uri;
	_data_->_tmp86_ = zeitgeist_manifestation_for_uri (_data_->_tmp85_);
	_data_->_tmp87_ = _data_->mimetype;
	_data_->_tmp88_ = _data_->origin;
	_data_->_tmp89_ = _data_->basename;
	_data_->_tmp90_ = zeitgeist_subject_new_full (_data_->_tmp82_, _data_->_tmp84_, _data_->_tmp86_, _data_->_tmp87_, _data_->_tmp88_, _data_->_tmp89_, "");
	_data_->subject = _data_->_tmp90_;
	_data_->_tmp91_ = _data_->event_interpretation;
	_data_->_tmp92_ = _data_->actor;
	_data_->_tmp93_ = zeitgeist_event_new_full (_data_->_tmp91_, ZEITGEIST_ZG_USER_ACTIVITY, _data_->_tmp92_, NULL, NULL, NULL);
	_data_->event = _data_->_tmp93_;
	_data_->_tmp94_ = _data_->event;
	_data_->_tmp95_ = _data_->subject;
	zeitgeist_event_add_subject (_data_->_tmp94_, _data_->_tmp95_);
	_data_->_tmp96_ = _data_->event;
	_data_->_tmp97_ = _data_->event_time;
	zeitgeist_event_set_timestamp (_data_->_tmp96_, _data_->_tmp97_);
	_data_->result = _data_->event;
	_g_object_unref0 (_data_->subject);
	_g_free0 (_data_->origin);
	_g_free0 (_data_->event_interpretation);
	_g_free0 (_data_->mimetype);
	_g_object_unref0 (_data_->subject_info);
	_g_object_unref0 (_data_->subject_file);
	_g_free0 (_data_->actor);
	_g_free0 (_data_->_tmp37_);
	_g_free0 (_data_->desktop_entry_name);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->basename);
	_g_key_file_unref0 (_data_->recent_file);
	_g_free0 (_data_->_tmp17_);
	_g_free0 (_data_->content);
	_g_object_unref0 (_data_->recent_info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* recent_documents_kde_get_actor_for_desktop_entry_name (RecentDocumentsKDE* self, const gchar* desktop_entry_name) {
	gchar* result = NULL;
	static const gchar* desktop_prefixes[] = {"", "kde-", "kde4-"};
	GDesktopAppInfo* dae = NULL;
	gchar* desktop_id = NULL;
	GDesktopAppInfo* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_entry_name != NULL, NULL);
	dae = NULL;
	desktop_id = NULL;
	{
		const gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = desktop_prefixes;
		prefix_collection_length1 = G_N_ELEMENTS (desktop_prefixes);
		for (prefix_it = 0; prefix_it < G_N_ELEMENTS (desktop_prefixes); prefix_it = prefix_it + 1) {
			const gchar* prefix = NULL;
			prefix = prefix_collection[prefix_it];
			{
				const gchar* _tmp0_;
				const gchar* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				GDesktopAppInfo* _tmp4_;
				GDesktopAppInfo* _tmp5_;
				_tmp0_ = prefix;
				_tmp1_ = desktop_entry_name;
				_tmp2_ = g_strdup_printf ("%s%s.desktop", _tmp0_, _tmp1_);
				_g_free0 (desktop_id);
				desktop_id = _tmp2_;
				_tmp3_ = desktop_id;
				_tmp4_ = g_desktop_app_info_new (_tmp3_);
				_g_object_unref0 (dae);
				dae = _tmp4_;
				_tmp5_ = dae;
				if (_tmp5_ != NULL) {
					break;
				}
			}
		}
	}
	_tmp6_ = dae;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = desktop_id;
		_tmp8_ = g_strdup_printf ("application://%s", _tmp7_);
		result = _tmp8_;
		_g_free0 (desktop_id);
		_g_object_unref0 (dae);
		return result;
	}
	result = NULL;
	_g_free0 (desktop_id);
	_g_object_unref0 (dae);
	return result;
}


static void recent_documents_kde_crawl_all_items_data_free (gpointer _data) {
	RecentDocumentsKdeCrawlAllItemsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RecentDocumentsKdeCrawlAllItemsData, _data_);
}


static void recent_documents_kde_crawl_all_items_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RecentDocumentsKdeCrawlAllItemsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void recent_documents_kde_crawl_all_items (RecentDocumentsKDE* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RecentDocumentsKdeCrawlAllItemsData* _data_;
	RecentDocumentsKDE* _tmp0_;
	_data_ = g_slice_new0 (RecentDocumentsKdeCrawlAllItemsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, recent_documents_kde_crawl_all_items_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, recent_documents_kde_crawl_all_items_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	recent_documents_kde_crawl_all_items_co (_data_);
}


static void recent_documents_kde_crawl_all_items_finish (RecentDocumentsKDE* self, GAsyncResult* _res_, GError** error) {
	RecentDocumentsKdeCrawlAllItemsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void recent_documents_kde_crawl_all_items_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RecentDocumentsKdeCrawlAllItemsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	recent_documents_kde_crawl_all_items_co (_data_);
}


static gboolean recent_documents_kde_crawl_all_items_co (RecentDocumentsKdeCrawlAllItemsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->recent_document_path;
	_data_->_tmp2_ = g_file_new_for_path (_data_->_tmp1_);
	_data_->directory = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->directory;
	_data_->_tmp4_ = g_file_enumerate_children (_data_->_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_data_->_inner_error_);
	_data_->enumerator = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->directory);
		_g_ptr_array_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp6_ = _data_->enumerator;
		_data_->_tmp7_ = g_file_enumerator_next_file (_data_->_tmp6_, NULL, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->fi);
			_g_object_unref0 (_data_->enumerator);
			_g_object_unref0 (_data_->directory);
			_g_ptr_array_unref0 (_data_->events);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_object_unref0 (_data_->fi);
		_data_->fi = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->fi;
		if (!(_data_->_tmp9_ != NULL)) {
			_g_object_unref0 (_data_->_tmp5_);
			break;
		}
		_data_->_tmp10_ = _data_->directory;
		_data_->_tmp11_ = _data_->fi;
		_data_->_tmp12_ = g_file_info_get_name (_data_->_tmp11_);
		_data_->_tmp13_ = g_file_get_child (_data_->_tmp10_, _data_->_tmp12_);
		_data_->file = _data_->_tmp13_;
		{
			_data_->_tmp14_ = _data_->file;
			_data_->_state_ = 1;
			recent_documents_kde_parse_file (_data_->self, _data_->_tmp14_, recent_documents_kde_crawl_all_items_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp15_ = recent_documents_kde_parse_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->event = _data_->_tmp15_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_data_->_tmp16_ = _data_->event;
			if (_data_->_tmp16_ != NULL) {
				_data_->_tmp17_ = _data_->events;
				_data_->_tmp18_ = _data_->event;
				_data_->event = NULL;
				g_ptr_array_add (_data_->_tmp17_, _data_->_tmp18_);
			}
			_g_object_unref0 (_data_->event);
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->err = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->err);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->_tmp5_);
			_g_object_unref0 (_data_->fi);
			_g_object_unref0 (_data_->enumerator);
			_g_object_unref0 (_data_->directory);
			_g_ptr_array_unref0 (_data_->events);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->file);
		_g_object_unref0 (_data_->_tmp5_);
	}
	_data_->_tmp19_ = _data_->enumerator;
	g_file_enumerator_close (_data_->_tmp19_, NULL, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->fi);
		_g_object_unref0 (_data_->enumerator);
		_g_object_unref0 (_data_->directory);
		_g_ptr_array_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->events;
	g_signal_emit_by_name ((DataProvider*) _data_->self, "items-available", _data_->_tmp20_);
	_g_object_unref0 (_data_->fi);
	_g_object_unref0 (_data_->enumerator);
	_g_object_unref0 (_data_->directory);
	_g_ptr_array_unref0 (_data_->events);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* recent_documents_kde_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	RecentDocumentsKDE* self;
	const gchar* _tmp0_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


static void recent_documents_kde_real_set_unique_id (DataProvider* base, const gchar* value) {
	RecentDocumentsKDE* self;
	self = (RecentDocumentsKDE*) base;
	if (g_strcmp0 (value, recent_documents_kde_real_get_unique_id (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_UNIQUE_ID_PROPERTY]);
	}
}


static const gchar* recent_documents_kde_real_get_name (DataProvider* base) {
	const gchar* result;
	RecentDocumentsKDE* self;
	const gchar* _tmp0_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void recent_documents_kde_real_set_name (DataProvider* base, const gchar* value) {
	RecentDocumentsKDE* self;
	self = (RecentDocumentsKDE*) base;
	if (g_strcmp0 (value, recent_documents_kde_real_get_name (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_NAME_PROPERTY]);
	}
}


static const gchar* recent_documents_kde_real_get_description (DataProvider* base) {
	const gchar* result;
	RecentDocumentsKDE* self;
	const gchar* _tmp0_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void recent_documents_kde_real_set_description (DataProvider* base, const gchar* value) {
	RecentDocumentsKDE* self;
	self = (RecentDocumentsKDE*) base;
	if (g_strcmp0 (value, recent_documents_kde_real_get_description (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_DESCRIPTION_PROPERTY]);
	}
}


static DataHub* recent_documents_kde_real_get_datahub (DataProvider* base) {
	DataHub* result;
	RecentDocumentsKDE* self;
	DataHub* _tmp0_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}


static void recent_documents_kde_real_set_datahub (DataProvider* base, DataHub* value) {
	RecentDocumentsKDE* self;
	self = (RecentDocumentsKDE*) base;
	if (recent_documents_kde_real_get_datahub (base) != value) {
		DataHub* _tmp0_;
		DataHub* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_datahub);
		self->priv->_datahub = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_DATAHUB_PROPERTY]);
	}
}


static gboolean recent_documents_kde_real_get_enabled (DataProvider* base) {
	gboolean result;
	RecentDocumentsKDE* self;
	gboolean _tmp0_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void recent_documents_kde_real_set_enabled (DataProvider* base, gboolean value) {
	RecentDocumentsKDE* self;
	self = (RecentDocumentsKDE*) base;
	if (recent_documents_kde_real_get_enabled (base) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_enabled = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_ENABLED_PROPERTY]);
	}
}


static gboolean recent_documents_kde_real_get_register (DataProvider* base) {
	gboolean result;
	RecentDocumentsKDE* self;
	gboolean _tmp0_;
	self = (RecentDocumentsKDE*) base;
	_tmp0_ = self->priv->_register;
	result = _tmp0_;
	return result;
}


static void recent_documents_kde_real_set_register (DataProvider* base, gboolean value) {
	RecentDocumentsKDE* self;
	self = (RecentDocumentsKDE*) base;
	if (recent_documents_kde_real_get_register (base) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_register = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_REGISTER_PROPERTY]);
	}
}


static GObject * recent_documents_kde_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RecentDocumentsKDE * self;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (recent_documents_kde_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDE);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("URL\\[[^]]+\\]=", 0, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->recent_regex);
		self->priv->recent_regex = _tmp2_;
		_tmp4_ = g_regex_new ("\\$HOME", 0, 0, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (self->priv->url_regex);
		self->priv->url_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("kde-recent-document-provider.vala:84: Couldn't process regex: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp8_ = g_get_home_dir ();
	_tmp9_ = g_strconcat (_tmp8_, RECENT_DOCUMENTS_KDE_RECENT_DOCUMENTS_PATH, NULL);
	_g_free0 (self->priv->recent_document_path);
	self->priv->recent_document_path = _tmp9_;
	_tmp10_ = self->priv->recent_document_path;
	_tmp11_ = g_file_new_for_path (_tmp10_);
	_g_object_unref0 (self->priv->recent_documents_directory);
	self->priv->recent_documents_directory = _tmp11_;
	{
		GFileMonitor* _tmp12_ = NULL;
		GFile* _tmp13_;
		GFileMonitor* _tmp14_;
		GFileMonitor* _tmp15_;
		_tmp13_ = self->priv->recent_documents_directory;
		_tmp14_ = g_file_monitor_directory (_tmp13_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch4_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp15_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = err;
		_tmp17_ = _tmp16_->message;
		g_warning ("kde-recent-document-provider.vala:95: Couldn't set up monitor: %s", _tmp17_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void recent_documents_kde_class_init (RecentDocumentsKDEClass * klass) {
	recent_documents_kde_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RecentDocumentsKDEPrivate));
	((DataProviderClass *) klass)->start = (void (*) (DataProvider *)) recent_documents_kde_real_start;
	((DataProviderClass *) klass)->stop = (void (*) (DataProvider *)) recent_documents_kde_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = recent_documents_kde_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = recent_documents_kde_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = recent_documents_kde_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = recent_documents_kde_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = recent_documents_kde_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = recent_documents_kde_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = recent_documents_kde_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = recent_documents_kde_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = recent_documents_kde_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = recent_documents_kde_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = recent_documents_kde_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = recent_documents_kde_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_recent_documents_kde_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_recent_documents_kde_set_property;
	G_OBJECT_CLASS (klass)->constructor = recent_documents_kde_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_documents_kde_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_DOCUMENTS_KDE_UNIQUE_ID_PROPERTY, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_DOCUMENTS_KDE_NAME_PROPERTY, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_DOCUMENTS_KDE_DESCRIPTION_PROPERTY, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_DOCUMENTS_KDE_DATAHUB_PROPERTY, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_DATAHUB_PROPERTY] = g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_DOCUMENTS_KDE_ENABLED_PROPERTY, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_DOCUMENTS_KDE_REGISTER_PROPERTY, recent_documents_kde_properties[RECENT_DOCUMENTS_KDE_REGISTER_PROPERTY] = g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void recent_documents_kde_instance_init (RecentDocumentsKDE * self) {
	self->priv = RECENT_DOCUMENTS_KDE_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
}


static void recent_documents_kde_finalize (GObject * obj) {
	RecentDocumentsKDE * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDE);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_free0 (self->priv->recent_document_path);
	_g_object_unref0 (self->priv->recent_documents_directory);
	_g_object_unref0 (self->priv->monitor);
	self->priv->ignored_actors = (_vala_array_free (self->priv->ignored_actors, self->priv->ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (self->priv->recent_regex);
	_g_regex_unref0 (self->priv->url_regex);
	G_OBJECT_CLASS (recent_documents_kde_parent_class)->finalize (obj);
}


GType recent_documents_kde_get_type (void) {
	static volatile gsize recent_documents_kde_type_id__volatile = 0;
	if (g_once_init_enter (&recent_documents_kde_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RecentDocumentsKDEClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_documents_kde_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentDocumentsKDE), 0, (GInstanceInitFunc) recent_documents_kde_instance_init, NULL };
		GType recent_documents_kde_type_id;
		recent_documents_kde_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "RecentDocumentsKDE", &g_define_type_info, 0);
		g_once_init_leave (&recent_documents_kde_type_id__volatile, recent_documents_kde_type_id);
	}
	return recent_documents_kde_type_id__volatile;
}


static void _vala_recent_documents_kde_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RecentDocumentsKDE * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDE);
	switch (property_id) {
		case RECENT_DOCUMENTS_KDE_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case RECENT_DOCUMENTS_KDE_NAME_PROPERTY:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case RECENT_DOCUMENTS_KDE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case RECENT_DOCUMENTS_KDE_DATAHUB_PROPERTY:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case RECENT_DOCUMENTS_KDE_ENABLED_PROPERTY:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case RECENT_DOCUMENTS_KDE_REGISTER_PROPERTY:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_recent_documents_kde_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RecentDocumentsKDE * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDE);
	switch (property_id) {
		case RECENT_DOCUMENTS_KDE_UNIQUE_ID_PROPERTY:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_DOCUMENTS_KDE_NAME_PROPERTY:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_DOCUMENTS_KDE_DESCRIPTION_PROPERTY:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_DOCUMENTS_KDE_DATAHUB_PROPERTY:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case RECENT_DOCUMENTS_KDE_ENABLED_PROPERTY:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case RECENT_DOCUMENTS_KDE_REGISTER_PROPERTY:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



