#define IN_TP_QT_HEADER
#include "TelepathyQt/account.h"

namespace Tp
{
namespace Client
{

AccountInterface::AccountInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

AccountInterface::AccountInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

AccountInterface::AccountInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void AccountInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(Removed()), NULL, NULL);
    disconnect(this, SIGNAL(AccountPropertyChanged(const QVariantMap&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

AccountInterfaceAddressingInterface::AccountInterfaceAddressingInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

AccountInterfaceAddressingInterface::AccountInterfaceAddressingInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

AccountInterfaceAddressingInterface::AccountInterfaceAddressingInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

AccountInterfaceAddressingInterface::AccountInterfaceAddressingInterface(const Tp::Client::AccountInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

AccountInterfaceAddressingInterface::AccountInterfaceAddressingInterface(const Tp::Client::AccountInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void AccountInterfaceAddressingInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

AccountInterfaceAvatarInterface::AccountInterfaceAvatarInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

AccountInterfaceAvatarInterface::AccountInterfaceAvatarInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

AccountInterfaceAvatarInterface::AccountInterfaceAvatarInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

AccountInterfaceAvatarInterface::AccountInterfaceAvatarInterface(const Tp::Client::AccountInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

AccountInterfaceAvatarInterface::AccountInterfaceAvatarInterface(const Tp::Client::AccountInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void AccountInterfaceAvatarInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(AvatarChanged()), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

AccountInterfaceStorageInterface::AccountInterfaceStorageInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

AccountInterfaceStorageInterface::AccountInterfaceStorageInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

AccountInterfaceStorageInterface::AccountInterfaceStorageInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

AccountInterfaceStorageInterface::AccountInterfaceStorageInterface(const Tp::Client::AccountInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

AccountInterfaceStorageInterface::AccountInterfaceStorageInterface(const Tp::Client::AccountInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void AccountInterfaceStorageInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
