#include "TelepathyQt/_gen/svc-connection.h"

#include "TelepathyQt/_gen/svc-connection.moc.hpp"

#include <TelepathyQt/Constants>
#include <TelepathyQt/MethodInvocationContext>

namespace Tp
{
namespace Service
{

ConnectionAdaptor::ConnectionAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(selfHandleChanged(uint)), SIGNAL(SelfHandleChanged(uint)));
    connect(adaptee, SIGNAL(selfContactChanged(uint, const QString&)), SIGNAL(SelfContactChanged(uint, const QString&)));
    connect(adaptee, SIGNAL(newChannel(const QDBusObjectPath&, const QString&, uint, uint, bool)), SIGNAL(NewChannel(const QDBusObjectPath&, const QString&, uint, uint, bool)));
    connect(adaptee, SIGNAL(connectionError(const QString&, const QVariantMap&)), SIGNAL(ConnectionError(const QString&, const QVariantMap&)));
    connect(adaptee, SIGNAL(statusChanged(uint, uint)), SIGNAL(StatusChanged(uint, uint)));
}

ConnectionAdaptor::~ConnectionAdaptor()
{
}

QStringList ConnectionAdaptor::Interfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("interfaces"));
}

uint ConnectionAdaptor::SelfHandle() const
{
    return qvariant_cast< uint >(adaptee()->property("selfHandle"));
}

QString ConnectionAdaptor::SelfID() const
{
    return qvariant_cast< QString >(adaptee()->property("selfID"));
}

uint ConnectionAdaptor::Status() const
{
    return qvariant_cast< uint >(adaptee()->property("status"));
}

bool ConnectionAdaptor::HasImmortalHandles() const
{
    return qvariant_cast< bool >(adaptee()->property("hasImmortalHandles"));
}

void ConnectionAdaptor::Connect(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("connect(Tp::Service::ConnectionAdaptor::ConnectContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    ConnectContextPtr ctx = ConnectContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "connect",
        Q_ARG(Tp::Service::ConnectionAdaptor::ConnectContextPtr, ctx));
}

void ConnectionAdaptor::Disconnect(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("disconnect(Tp::Service::ConnectionAdaptor::DisconnectContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    DisconnectContextPtr ctx = DisconnectContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "disconnect",
        Q_ARG(Tp::Service::ConnectionAdaptor::DisconnectContextPtr, ctx));
}

QStringList ConnectionAdaptor::GetInterfaces(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getInterfaces(Tp::Service::ConnectionAdaptor::GetInterfacesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    GetInterfacesContextPtr ctx = GetInterfacesContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getInterfaces",
        Q_ARG(Tp::Service::ConnectionAdaptor::GetInterfacesContextPtr, ctx));
    return QStringList();
}

QString ConnectionAdaptor::GetProtocol(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getProtocol(Tp::Service::ConnectionAdaptor::GetProtocolContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    GetProtocolContextPtr ctx = GetProtocolContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getProtocol",
        Q_ARG(Tp::Service::ConnectionAdaptor::GetProtocolContextPtr, ctx));
    return QString();
}

uint ConnectionAdaptor::GetSelfHandle(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getSelfHandle(Tp::Service::ConnectionAdaptor::GetSelfHandleContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetSelfHandleContextPtr ctx = GetSelfHandleContextPtr(
            new Tp::MethodInvocationContext< uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getSelfHandle",
        Q_ARG(Tp::Service::ConnectionAdaptor::GetSelfHandleContextPtr, ctx));
    return uint();
}

uint ConnectionAdaptor::GetStatus(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getStatus(Tp::Service::ConnectionAdaptor::GetStatusContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetStatusContextPtr ctx = GetStatusContextPtr(
            new Tp::MethodInvocationContext< uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getStatus",
        Q_ARG(Tp::Service::ConnectionAdaptor::GetStatusContextPtr, ctx));
    return uint();
}

void ConnectionAdaptor::HoldHandles(uint handleType, const Tp::UIntList& handles, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("holdHandles(uint,Tp::UIntList,Tp::Service::ConnectionAdaptor::HoldHandlesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    HoldHandlesContextPtr ctx = HoldHandlesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "holdHandles",
        Q_ARG(uint, handleType), Q_ARG(Tp::UIntList, handles),
        Q_ARG(Tp::Service::ConnectionAdaptor::HoldHandlesContextPtr, ctx));
}

QStringList ConnectionAdaptor::InspectHandles(uint handleType, const Tp::UIntList& handles, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("inspectHandles(uint,Tp::UIntList,Tp::Service::ConnectionAdaptor::InspectHandlesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    InspectHandlesContextPtr ctx = InspectHandlesContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "inspectHandles",
        Q_ARG(uint, handleType), Q_ARG(Tp::UIntList, handles),
        Q_ARG(Tp::Service::ConnectionAdaptor::InspectHandlesContextPtr, ctx));
    return QStringList();
}

Tp::ChannelInfoList ConnectionAdaptor::ListChannels(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("listChannels(Tp::Service::ConnectionAdaptor::ListChannelsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ChannelInfoList();
    }

    ListChannelsContextPtr ctx = ListChannelsContextPtr(
            new Tp::MethodInvocationContext< Tp::ChannelInfoList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "listChannels",
        Q_ARG(Tp::Service::ConnectionAdaptor::ListChannelsContextPtr, ctx));
    return Tp::ChannelInfoList();
}

void ConnectionAdaptor::ReleaseHandles(uint handleType, const Tp::UIntList& handles, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("releaseHandles(uint,Tp::UIntList,Tp::Service::ConnectionAdaptor::ReleaseHandlesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    ReleaseHandlesContextPtr ctx = ReleaseHandlesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "releaseHandles",
        Q_ARG(uint, handleType), Q_ARG(Tp::UIntList, handles),
        Q_ARG(Tp::Service::ConnectionAdaptor::ReleaseHandlesContextPtr, ctx));
}

QDBusObjectPath ConnectionAdaptor::RequestChannel(const QString& type, uint handleType, uint handle, bool suppressHandler, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestChannel(QString,uint,uint,bool,Tp::Service::ConnectionAdaptor::RequestChannelContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QDBusObjectPath();
    }

    RequestChannelContextPtr ctx = RequestChannelContextPtr(
            new Tp::MethodInvocationContext< QDBusObjectPath >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestChannel",
        Q_ARG(QString, type), Q_ARG(uint, handleType), Q_ARG(uint, handle), Q_ARG(bool, suppressHandler),
        Q_ARG(Tp::Service::ConnectionAdaptor::RequestChannelContextPtr, ctx));
    return QDBusObjectPath();
}

Tp::UIntList ConnectionAdaptor::RequestHandles(uint handleType, const QStringList& identifiers, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestHandles(uint,QStringList,Tp::Service::ConnectionAdaptor::RequestHandlesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    RequestHandlesContextPtr ctx = RequestHandlesContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestHandles",
        Q_ARG(uint, handleType), Q_ARG(QStringList, identifiers),
        Q_ARG(Tp::Service::ConnectionAdaptor::RequestHandlesContextPtr, ctx));
    return Tp::UIntList();
}

void ConnectionAdaptor::AddClientInterest(const QStringList& tokens, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("addClientInterest(QStringList,Tp::Service::ConnectionAdaptor::AddClientInterestContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AddClientInterestContextPtr ctx = AddClientInterestContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "addClientInterest",
        Q_ARG(QStringList, tokens),
        Q_ARG(Tp::Service::ConnectionAdaptor::AddClientInterestContextPtr, ctx));
}

void ConnectionAdaptor::RemoveClientInterest(const QStringList& tokens, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeClientInterest(QStringList,Tp::Service::ConnectionAdaptor::RemoveClientInterestContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveClientInterestContextPtr ctx = RemoveClientInterestContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeClientInterest",
        Q_ARG(QStringList, tokens),
        Q_ARG(Tp::Service::ConnectionAdaptor::RemoveClientInterestContextPtr, ctx));
}

ConnectionInterfaceAddressingAdaptor::ConnectionInterfaceAddressingAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ConnectionInterfaceAddressingAdaptor::~ConnectionInterfaceAddressingAdaptor()
{
}

Tp::AddressingNormalizationMap ConnectionInterfaceAddressingAdaptor::GetContactsByVCardField(const QString& field, const QStringList& addresses, const QStringList& interfaces, const QDBusMessage& dbusMessage, Tp::ContactAttributesMap& attributes)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactsByVCardField(QString,QStringList,QStringList,Tp::Service::ConnectionInterfaceAddressingAdaptor::GetContactsByVCardFieldContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::AddressingNormalizationMap();
    }

    GetContactsByVCardFieldContextPtr ctx = GetContactsByVCardFieldContextPtr(
            new Tp::MethodInvocationContext< Tp::AddressingNormalizationMap, Tp::ContactAttributesMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactsByVCardField",
        Q_ARG(QString, field), Q_ARG(QStringList, addresses), Q_ARG(QStringList, interfaces),
        Q_ARG(Tp::Service::ConnectionInterfaceAddressingAdaptor::GetContactsByVCardFieldContextPtr, ctx));
    return Tp::AddressingNormalizationMap();
}

Tp::AddressingNormalizationMap ConnectionInterfaceAddressingAdaptor::GetContactsByURI(const QStringList& URIs, const QStringList& interfaces, const QDBusMessage& dbusMessage, Tp::ContactAttributesMap& attributes)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactsByURI(QStringList,QStringList,Tp::Service::ConnectionInterfaceAddressingAdaptor::GetContactsByURIContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::AddressingNormalizationMap();
    }

    GetContactsByURIContextPtr ctx = GetContactsByURIContextPtr(
            new Tp::MethodInvocationContext< Tp::AddressingNormalizationMap, Tp::ContactAttributesMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactsByURI",
        Q_ARG(QStringList, URIs), Q_ARG(QStringList, interfaces),
        Q_ARG(Tp::Service::ConnectionInterfaceAddressingAdaptor::GetContactsByURIContextPtr, ctx));
    return Tp::AddressingNormalizationMap();
}

ConnectionInterfaceAliasingAdaptor::ConnectionInterfaceAliasingAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(aliasesChanged(const Tp::AliasPairList&)), SIGNAL(AliasesChanged(const Tp::AliasPairList&)));
}

ConnectionInterfaceAliasingAdaptor::~ConnectionInterfaceAliasingAdaptor()
{
}

uint ConnectionInterfaceAliasingAdaptor::GetAliasFlags(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getAliasFlags(Tp::Service::ConnectionInterfaceAliasingAdaptor::GetAliasFlagsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetAliasFlagsContextPtr ctx = GetAliasFlagsContextPtr(
            new Tp::MethodInvocationContext< uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getAliasFlags",
        Q_ARG(Tp::Service::ConnectionInterfaceAliasingAdaptor::GetAliasFlagsContextPtr, ctx));
    return uint();
}

QStringList ConnectionInterfaceAliasingAdaptor::RequestAliases(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestAliases(Tp::UIntList,Tp::Service::ConnectionInterfaceAliasingAdaptor::RequestAliasesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    RequestAliasesContextPtr ctx = RequestAliasesContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestAliases",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceAliasingAdaptor::RequestAliasesContextPtr, ctx));
    return QStringList();
}

Tp::AliasMap ConnectionInterfaceAliasingAdaptor::GetAliases(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getAliases(Tp::UIntList,Tp::Service::ConnectionInterfaceAliasingAdaptor::GetAliasesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::AliasMap();
    }

    GetAliasesContextPtr ctx = GetAliasesContextPtr(
            new Tp::MethodInvocationContext< Tp::AliasMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getAliases",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceAliasingAdaptor::GetAliasesContextPtr, ctx));
    return Tp::AliasMap();
}

void ConnectionInterfaceAliasingAdaptor::SetAliases(const Tp::AliasMap& aliases, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setAliases(Tp::AliasMap,Tp::Service::ConnectionInterfaceAliasingAdaptor::SetAliasesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetAliasesContextPtr ctx = SetAliasesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setAliases",
        Q_ARG(Tp::AliasMap, aliases),
        Q_ARG(Tp::Service::ConnectionInterfaceAliasingAdaptor::SetAliasesContextPtr, ctx));
}

ConnectionInterfaceAnonymityAdaptor::ConnectionInterfaceAnonymityAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(anonymityModesChanged(uint)), SIGNAL(AnonymityModesChanged(uint)));
}

ConnectionInterfaceAnonymityAdaptor::~ConnectionInterfaceAnonymityAdaptor()
{
}

uint ConnectionInterfaceAnonymityAdaptor::SupportedAnonymityModes() const
{
    return qvariant_cast< uint >(adaptee()->property("supportedAnonymityModes"));
}

bool ConnectionInterfaceAnonymityAdaptor::AnonymityMandatory() const
{
    return qvariant_cast< bool >(adaptee()->property("anonymityMandatory"));
}

void ConnectionInterfaceAnonymityAdaptor::SetAnonymityMandatory(const bool &newValue)
{
    adaptee()->setProperty("anonymityMandatory", qVariantFromValue(newValue));
}

uint ConnectionInterfaceAnonymityAdaptor::AnonymityModes() const
{
    return qvariant_cast< uint >(adaptee()->property("anonymityModes"));
}

void ConnectionInterfaceAnonymityAdaptor::SetAnonymityModes(const uint &newValue)
{
    adaptee()->setProperty("anonymityModes", qVariantFromValue(newValue));
}

ConnectionInterfaceAvatarsAdaptor::ConnectionInterfaceAvatarsAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(avatarUpdated(uint, const QString&)), SIGNAL(AvatarUpdated(uint, const QString&)));
    connect(adaptee, SIGNAL(avatarRetrieved(uint, const QString&, const QByteArray&, const QString&)), SIGNAL(AvatarRetrieved(uint, const QString&, const QByteArray&, const QString&)));
}

ConnectionInterfaceAvatarsAdaptor::~ConnectionInterfaceAvatarsAdaptor()
{
}

QStringList ConnectionInterfaceAvatarsAdaptor::SupportedAvatarMIMETypes() const
{
    return qvariant_cast< QStringList >(adaptee()->property("supportedAvatarMIMETypes"));
}

uint ConnectionInterfaceAvatarsAdaptor::MinimumAvatarHeight() const
{
    return qvariant_cast< uint >(adaptee()->property("minimumAvatarHeight"));
}

uint ConnectionInterfaceAvatarsAdaptor::MinimumAvatarWidth() const
{
    return qvariant_cast< uint >(adaptee()->property("minimumAvatarWidth"));
}

uint ConnectionInterfaceAvatarsAdaptor::RecommendedAvatarHeight() const
{
    return qvariant_cast< uint >(adaptee()->property("recommendedAvatarHeight"));
}

uint ConnectionInterfaceAvatarsAdaptor::RecommendedAvatarWidth() const
{
    return qvariant_cast< uint >(adaptee()->property("recommendedAvatarWidth"));
}

uint ConnectionInterfaceAvatarsAdaptor::MaximumAvatarHeight() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumAvatarHeight"));
}

uint ConnectionInterfaceAvatarsAdaptor::MaximumAvatarWidth() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumAvatarWidth"));
}

uint ConnectionInterfaceAvatarsAdaptor::MaximumAvatarBytes() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumAvatarBytes"));
}

QStringList ConnectionInterfaceAvatarsAdaptor::GetAvatarRequirements(const QDBusMessage& dbusMessage, ushort& minWidth, ushort& minHeight, ushort& maxWidth, ushort& maxHeight, uint& maxBytes)
{
    if (adaptee()->metaObject()->indexOfMethod("getAvatarRequirements(Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetAvatarRequirementsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    GetAvatarRequirementsContextPtr ctx = GetAvatarRequirementsContextPtr(
            new Tp::MethodInvocationContext< QStringList, ushort, ushort, ushort, ushort, uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getAvatarRequirements",
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetAvatarRequirementsContextPtr, ctx));
    return QStringList();
}

QStringList ConnectionInterfaceAvatarsAdaptor::GetAvatarTokens(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getAvatarTokens(Tp::UIntList,Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetAvatarTokensContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    GetAvatarTokensContextPtr ctx = GetAvatarTokensContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getAvatarTokens",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetAvatarTokensContextPtr, ctx));
    return QStringList();
}

Tp::AvatarTokenMap ConnectionInterfaceAvatarsAdaptor::GetKnownAvatarTokens(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getKnownAvatarTokens(Tp::UIntList,Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetKnownAvatarTokensContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::AvatarTokenMap();
    }

    GetKnownAvatarTokensContextPtr ctx = GetKnownAvatarTokensContextPtr(
            new Tp::MethodInvocationContext< Tp::AvatarTokenMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getKnownAvatarTokens",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetKnownAvatarTokensContextPtr, ctx));
    return Tp::AvatarTokenMap();
}

QByteArray ConnectionInterfaceAvatarsAdaptor::RequestAvatar(uint contact, const QDBusMessage& dbusMessage, QString& MIMEType)
{
    if (adaptee()->metaObject()->indexOfMethod("requestAvatar(uint,Tp::Service::ConnectionInterfaceAvatarsAdaptor::RequestAvatarContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QByteArray();
    }

    RequestAvatarContextPtr ctx = RequestAvatarContextPtr(
            new Tp::MethodInvocationContext< QByteArray, QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestAvatar",
        Q_ARG(uint, contact),
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::RequestAvatarContextPtr, ctx));
    return QByteArray();
}

void ConnectionInterfaceAvatarsAdaptor::RequestAvatars(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestAvatars(Tp::UIntList,Tp::Service::ConnectionInterfaceAvatarsAdaptor::RequestAvatarsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RequestAvatarsContextPtr ctx = RequestAvatarsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestAvatars",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::RequestAvatarsContextPtr, ctx));
}

QString ConnectionInterfaceAvatarsAdaptor::SetAvatar(const QByteArray& avatar, const QString& MIMEType, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setAvatar(QByteArray,QString,Tp::Service::ConnectionInterfaceAvatarsAdaptor::SetAvatarContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    SetAvatarContextPtr ctx = SetAvatarContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setAvatar",
        Q_ARG(QByteArray, avatar), Q_ARG(QString, MIMEType),
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::SetAvatarContextPtr, ctx));
    return QString();
}

void ConnectionInterfaceAvatarsAdaptor::ClearAvatar(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("clearAvatar(Tp::Service::ConnectionInterfaceAvatarsAdaptor::ClearAvatarContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    ClearAvatarContextPtr ctx = ClearAvatarContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "clearAvatar",
        Q_ARG(Tp::Service::ConnectionInterfaceAvatarsAdaptor::ClearAvatarContextPtr, ctx));
}

ConnectionInterfaceBalanceAdaptor::ConnectionInterfaceBalanceAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(balanceChanged(const Tp::CurrencyAmount&)), SIGNAL(BalanceChanged(const Tp::CurrencyAmount&)));
}

ConnectionInterfaceBalanceAdaptor::~ConnectionInterfaceBalanceAdaptor()
{
}

Tp::CurrencyAmount ConnectionInterfaceBalanceAdaptor::AccountBalance() const
{
    return qvariant_cast< Tp::CurrencyAmount >(adaptee()->property("accountBalance"));
}

QString ConnectionInterfaceBalanceAdaptor::ManageCreditURI() const
{
    return qvariant_cast< QString >(adaptee()->property("manageCreditURI"));
}

ConnectionInterfaceCellularAdaptor::ConnectionInterfaceCellularAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(imsiChanged(const QString&)), SIGNAL(IMSIChanged(const QString&)));
}

ConnectionInterfaceCellularAdaptor::~ConnectionInterfaceCellularAdaptor()
{
}

uint ConnectionInterfaceCellularAdaptor::MessageValidityPeriod() const
{
    return qvariant_cast< uint >(adaptee()->property("messageValidityPeriod"));
}

void ConnectionInterfaceCellularAdaptor::SetMessageValidityPeriod(const uint &newValue)
{
    adaptee()->setProperty("messageValidityPeriod", qVariantFromValue(newValue));
}

bool ConnectionInterfaceCellularAdaptor::OverrideMessageServiceCentre() const
{
    return qvariant_cast< bool >(adaptee()->property("overrideMessageServiceCentre"));
}

void ConnectionInterfaceCellularAdaptor::SetOverrideMessageServiceCentre(const bool &newValue)
{
    adaptee()->setProperty("overrideMessageServiceCentre", qVariantFromValue(newValue));
}

QString ConnectionInterfaceCellularAdaptor::MessageServiceCentre() const
{
    return qvariant_cast< QString >(adaptee()->property("messageServiceCentre"));
}

void ConnectionInterfaceCellularAdaptor::SetMessageServiceCentre(const QString &newValue)
{
    adaptee()->setProperty("messageServiceCentre", qVariantFromValue(newValue));
}

QString ConnectionInterfaceCellularAdaptor::IMSI() const
{
    return qvariant_cast< QString >(adaptee()->property("imsi"));
}

bool ConnectionInterfaceCellularAdaptor::MessageReducedCharacterSet() const
{
    return qvariant_cast< bool >(adaptee()->property("messageReducedCharacterSet"));
}

void ConnectionInterfaceCellularAdaptor::SetMessageReducedCharacterSet(const bool &newValue)
{
    adaptee()->setProperty("messageReducedCharacterSet", qVariantFromValue(newValue));
}

QString ConnectionInterfaceCellularAdaptor::MessageNationalCharacterSet() const
{
    return qvariant_cast< QString >(adaptee()->property("messageNationalCharacterSet"));
}

void ConnectionInterfaceCellularAdaptor::SetMessageNationalCharacterSet(const QString &newValue)
{
    adaptee()->setProperty("messageNationalCharacterSet", qVariantFromValue(newValue));
}

ConnectionInterfaceClientTypesAdaptor::ConnectionInterfaceClientTypesAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(clientTypesUpdated(uint, const QStringList&)), SIGNAL(ClientTypesUpdated(uint, const QStringList&)));
}

ConnectionInterfaceClientTypesAdaptor::~ConnectionInterfaceClientTypesAdaptor()
{
}

Tp::ContactClientTypes ConnectionInterfaceClientTypesAdaptor::GetClientTypes(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getClientTypes(Tp::UIntList,Tp::Service::ConnectionInterfaceClientTypesAdaptor::GetClientTypesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactClientTypes();
    }

    GetClientTypesContextPtr ctx = GetClientTypesContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactClientTypes >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getClientTypes",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceClientTypesAdaptor::GetClientTypesContextPtr, ctx));
    return Tp::ContactClientTypes();
}

QStringList ConnectionInterfaceClientTypesAdaptor::RequestClientTypes(uint contact, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestClientTypes(uint,Tp::Service::ConnectionInterfaceClientTypesAdaptor::RequestClientTypesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    RequestClientTypesContextPtr ctx = RequestClientTypesContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestClientTypes",
        Q_ARG(uint, contact),
        Q_ARG(Tp::Service::ConnectionInterfaceClientTypesAdaptor::RequestClientTypesContextPtr, ctx));
    return QStringList();
}

ConnectionInterfaceContactBlockingAdaptor::ConnectionInterfaceContactBlockingAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(blockedContactsChanged(const Tp::HandleIdentifierMap&, const Tp::HandleIdentifierMap&)), SIGNAL(BlockedContactsChanged(const Tp::HandleIdentifierMap&, const Tp::HandleIdentifierMap&)));
}

ConnectionInterfaceContactBlockingAdaptor::~ConnectionInterfaceContactBlockingAdaptor()
{
}

uint ConnectionInterfaceContactBlockingAdaptor::ContactBlockingCapabilities() const
{
    return qvariant_cast< uint >(adaptee()->property("contactBlockingCapabilities"));
}

void ConnectionInterfaceContactBlockingAdaptor::BlockContacts(const Tp::UIntList& contacts, bool reportAbusive, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("blockContacts(Tp::UIntList,bool,Tp::Service::ConnectionInterfaceContactBlockingAdaptor::BlockContactsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    BlockContactsContextPtr ctx = BlockContactsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "blockContacts",
        Q_ARG(Tp::UIntList, contacts), Q_ARG(bool, reportAbusive),
        Q_ARG(Tp::Service::ConnectionInterfaceContactBlockingAdaptor::BlockContactsContextPtr, ctx));
}

void ConnectionInterfaceContactBlockingAdaptor::UnblockContacts(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("unblockContacts(Tp::UIntList,Tp::Service::ConnectionInterfaceContactBlockingAdaptor::UnblockContactsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    UnblockContactsContextPtr ctx = UnblockContactsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "unblockContacts",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactBlockingAdaptor::UnblockContactsContextPtr, ctx));
}

Tp::HandleIdentifierMap ConnectionInterfaceContactBlockingAdaptor::RequestBlockedContacts(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestBlockedContacts(Tp::Service::ConnectionInterfaceContactBlockingAdaptor::RequestBlockedContactsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::HandleIdentifierMap();
    }

    RequestBlockedContactsContextPtr ctx = RequestBlockedContactsContextPtr(
            new Tp::MethodInvocationContext< Tp::HandleIdentifierMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestBlockedContacts",
        Q_ARG(Tp::Service::ConnectionInterfaceContactBlockingAdaptor::RequestBlockedContactsContextPtr, ctx));
    return Tp::HandleIdentifierMap();
}

ConnectionInterfaceContactCapabilitiesAdaptor::ConnectionInterfaceContactCapabilitiesAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(contactCapabilitiesChanged(const Tp::ContactCapabilitiesMap&)), SIGNAL(ContactCapabilitiesChanged(const Tp::ContactCapabilitiesMap&)));
}

ConnectionInterfaceContactCapabilitiesAdaptor::~ConnectionInterfaceContactCapabilitiesAdaptor()
{
}

void ConnectionInterfaceContactCapabilitiesAdaptor::UpdateCapabilities(const Tp::HandlerCapabilitiesList& handlerCapabilities, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("updateCapabilities(Tp::HandlerCapabilitiesList,Tp::Service::ConnectionInterfaceContactCapabilitiesAdaptor::UpdateCapabilitiesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    UpdateCapabilitiesContextPtr ctx = UpdateCapabilitiesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "updateCapabilities",
        Q_ARG(Tp::HandlerCapabilitiesList, handlerCapabilities),
        Q_ARG(Tp::Service::ConnectionInterfaceContactCapabilitiesAdaptor::UpdateCapabilitiesContextPtr, ctx));
}

Tp::ContactCapabilitiesMap ConnectionInterfaceContactCapabilitiesAdaptor::GetContactCapabilities(const Tp::UIntList& handles, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactCapabilities(Tp::UIntList,Tp::Service::ConnectionInterfaceContactCapabilitiesAdaptor::GetContactCapabilitiesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactCapabilitiesMap();
    }

    GetContactCapabilitiesContextPtr ctx = GetContactCapabilitiesContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactCapabilitiesMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactCapabilities",
        Q_ARG(Tp::UIntList, handles),
        Q_ARG(Tp::Service::ConnectionInterfaceContactCapabilitiesAdaptor::GetContactCapabilitiesContextPtr, ctx));
    return Tp::ContactCapabilitiesMap();
}

ConnectionInterfaceContactGroupsAdaptor::ConnectionInterfaceContactGroupsAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(groupsChanged(const Tp::UIntList&, const QStringList&, const QStringList&)), SIGNAL(GroupsChanged(const Tp::UIntList&, const QStringList&, const QStringList&)));
    connect(adaptee, SIGNAL(groupsCreated(const QStringList&)), SIGNAL(GroupsCreated(const QStringList&)));
    connect(adaptee, SIGNAL(groupRenamed(const QString&, const QString&)), SIGNAL(GroupRenamed(const QString&, const QString&)));
    connect(adaptee, SIGNAL(groupsRemoved(const QStringList&)), SIGNAL(GroupsRemoved(const QStringList&)));
}

ConnectionInterfaceContactGroupsAdaptor::~ConnectionInterfaceContactGroupsAdaptor()
{
}

bool ConnectionInterfaceContactGroupsAdaptor::DisjointGroups() const
{
    return qvariant_cast< bool >(adaptee()->property("disjointGroups"));
}

uint ConnectionInterfaceContactGroupsAdaptor::GroupStorage() const
{
    return qvariant_cast< uint >(adaptee()->property("groupStorage"));
}

QStringList ConnectionInterfaceContactGroupsAdaptor::Groups() const
{
    return qvariant_cast< QStringList >(adaptee()->property("groups"));
}

void ConnectionInterfaceContactGroupsAdaptor::SetContactGroups(uint contact, const QStringList& groups, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setContactGroups(uint,QStringList,Tp::Service::ConnectionInterfaceContactGroupsAdaptor::SetContactGroupsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetContactGroupsContextPtr ctx = SetContactGroupsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setContactGroups",
        Q_ARG(uint, contact), Q_ARG(QStringList, groups),
        Q_ARG(Tp::Service::ConnectionInterfaceContactGroupsAdaptor::SetContactGroupsContextPtr, ctx));
}

void ConnectionInterfaceContactGroupsAdaptor::SetGroupMembers(const QString& group, const Tp::UIntList& members, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setGroupMembers(QString,Tp::UIntList,Tp::Service::ConnectionInterfaceContactGroupsAdaptor::SetGroupMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetGroupMembersContextPtr ctx = SetGroupMembersContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setGroupMembers",
        Q_ARG(QString, group), Q_ARG(Tp::UIntList, members),
        Q_ARG(Tp::Service::ConnectionInterfaceContactGroupsAdaptor::SetGroupMembersContextPtr, ctx));
}

void ConnectionInterfaceContactGroupsAdaptor::AddToGroup(const QString& group, const Tp::UIntList& members, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("addToGroup(QString,Tp::UIntList,Tp::Service::ConnectionInterfaceContactGroupsAdaptor::AddToGroupContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AddToGroupContextPtr ctx = AddToGroupContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "addToGroup",
        Q_ARG(QString, group), Q_ARG(Tp::UIntList, members),
        Q_ARG(Tp::Service::ConnectionInterfaceContactGroupsAdaptor::AddToGroupContextPtr, ctx));
}

void ConnectionInterfaceContactGroupsAdaptor::RemoveFromGroup(const QString& group, const Tp::UIntList& members, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeFromGroup(QString,Tp::UIntList,Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RemoveFromGroupContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveFromGroupContextPtr ctx = RemoveFromGroupContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeFromGroup",
        Q_ARG(QString, group), Q_ARG(Tp::UIntList, members),
        Q_ARG(Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RemoveFromGroupContextPtr, ctx));
}

void ConnectionInterfaceContactGroupsAdaptor::RemoveGroup(const QString& group, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeGroup(QString,Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RemoveGroupContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveGroupContextPtr ctx = RemoveGroupContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeGroup",
        Q_ARG(QString, group),
        Q_ARG(Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RemoveGroupContextPtr, ctx));
}

void ConnectionInterfaceContactGroupsAdaptor::RenameGroup(const QString& oldName, const QString& newName, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("renameGroup(QString,QString,Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RenameGroupContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RenameGroupContextPtr ctx = RenameGroupContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "renameGroup",
        Q_ARG(QString, oldName), Q_ARG(QString, newName),
        Q_ARG(Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RenameGroupContextPtr, ctx));
}

ConnectionInterfaceContactInfoAdaptor::ConnectionInterfaceContactInfoAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(contactInfoChanged(uint, const Tp::ContactInfoFieldList&)), SIGNAL(ContactInfoChanged(uint, const Tp::ContactInfoFieldList&)));
}

ConnectionInterfaceContactInfoAdaptor::~ConnectionInterfaceContactInfoAdaptor()
{
}

uint ConnectionInterfaceContactInfoAdaptor::ContactInfoFlags() const
{
    return qvariant_cast< uint >(adaptee()->property("contactInfoFlags"));
}

Tp::FieldSpecs ConnectionInterfaceContactInfoAdaptor::SupportedFields() const
{
    return qvariant_cast< Tp::FieldSpecs >(adaptee()->property("supportedFields"));
}

Tp::ContactInfoMap ConnectionInterfaceContactInfoAdaptor::GetContactInfo(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactInfo(Tp::UIntList,Tp::Service::ConnectionInterfaceContactInfoAdaptor::GetContactInfoContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactInfoMap();
    }

    GetContactInfoContextPtr ctx = GetContactInfoContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactInfoMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactInfo",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactInfoAdaptor::GetContactInfoContextPtr, ctx));
    return Tp::ContactInfoMap();
}

void ConnectionInterfaceContactInfoAdaptor::RefreshContactInfo(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("refreshContactInfo(Tp::UIntList,Tp::Service::ConnectionInterfaceContactInfoAdaptor::RefreshContactInfoContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RefreshContactInfoContextPtr ctx = RefreshContactInfoContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "refreshContactInfo",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactInfoAdaptor::RefreshContactInfoContextPtr, ctx));
}

Tp::ContactInfoFieldList ConnectionInterfaceContactInfoAdaptor::RequestContactInfo(uint contact, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestContactInfo(uint,Tp::Service::ConnectionInterfaceContactInfoAdaptor::RequestContactInfoContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactInfoFieldList();
    }

    RequestContactInfoContextPtr ctx = RequestContactInfoContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactInfoFieldList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestContactInfo",
        Q_ARG(uint, contact),
        Q_ARG(Tp::Service::ConnectionInterfaceContactInfoAdaptor::RequestContactInfoContextPtr, ctx));
    return Tp::ContactInfoFieldList();
}

void ConnectionInterfaceContactInfoAdaptor::SetContactInfo(const Tp::ContactInfoFieldList& contactInfo, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setContactInfo(Tp::ContactInfoFieldList,Tp::Service::ConnectionInterfaceContactInfoAdaptor::SetContactInfoContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetContactInfoContextPtr ctx = SetContactInfoContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setContactInfo",
        Q_ARG(Tp::ContactInfoFieldList, contactInfo),
        Q_ARG(Tp::Service::ConnectionInterfaceContactInfoAdaptor::SetContactInfoContextPtr, ctx));
}

ConnectionInterfaceContactListAdaptor::ConnectionInterfaceContactListAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(contactListStateChanged(uint)), SIGNAL(ContactListStateChanged(uint)));
    connect(adaptee, SIGNAL(contactsChangedWithID(const Tp::ContactSubscriptionMap&, const Tp::HandleIdentifierMap&, const Tp::HandleIdentifierMap&)), SIGNAL(ContactsChangedWithID(const Tp::ContactSubscriptionMap&, const Tp::HandleIdentifierMap&, const Tp::HandleIdentifierMap&)));
    connect(adaptee, SIGNAL(contactsChanged(const Tp::ContactSubscriptionMap&, const Tp::UIntList&)), SIGNAL(ContactsChanged(const Tp::ContactSubscriptionMap&, const Tp::UIntList&)));
}

ConnectionInterfaceContactListAdaptor::~ConnectionInterfaceContactListAdaptor()
{
}

uint ConnectionInterfaceContactListAdaptor::ContactListState() const
{
    return qvariant_cast< uint >(adaptee()->property("contactListState"));
}

bool ConnectionInterfaceContactListAdaptor::ContactListPersists() const
{
    return qvariant_cast< bool >(adaptee()->property("contactListPersists"));
}

bool ConnectionInterfaceContactListAdaptor::CanChangeContactList() const
{
    return qvariant_cast< bool >(adaptee()->property("canChangeContactList"));
}

bool ConnectionInterfaceContactListAdaptor::RequestUsesMessage() const
{
    return qvariant_cast< bool >(adaptee()->property("requestUsesMessage"));
}

bool ConnectionInterfaceContactListAdaptor::DownloadAtConnection() const
{
    return qvariant_cast< bool >(adaptee()->property("downloadAtConnection"));
}

Tp::ContactAttributesMap ConnectionInterfaceContactListAdaptor::GetContactListAttributes(const QStringList& interfaces, bool hold, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactListAttributes(QStringList,bool,Tp::Service::ConnectionInterfaceContactListAdaptor::GetContactListAttributesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactAttributesMap();
    }

    GetContactListAttributesContextPtr ctx = GetContactListAttributesContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactAttributesMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactListAttributes",
        Q_ARG(QStringList, interfaces), Q_ARG(bool, hold),
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::GetContactListAttributesContextPtr, ctx));
    return Tp::ContactAttributesMap();
}

void ConnectionInterfaceContactListAdaptor::RequestSubscription(const Tp::UIntList& contacts, const QString& message, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestSubscription(Tp::UIntList,QString,Tp::Service::ConnectionInterfaceContactListAdaptor::RequestSubscriptionContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RequestSubscriptionContextPtr ctx = RequestSubscriptionContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestSubscription",
        Q_ARG(Tp::UIntList, contacts), Q_ARG(QString, message),
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::RequestSubscriptionContextPtr, ctx));
}

void ConnectionInterfaceContactListAdaptor::AuthorizePublication(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("authorizePublication(Tp::UIntList,Tp::Service::ConnectionInterfaceContactListAdaptor::AuthorizePublicationContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AuthorizePublicationContextPtr ctx = AuthorizePublicationContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "authorizePublication",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::AuthorizePublicationContextPtr, ctx));
}

void ConnectionInterfaceContactListAdaptor::RemoveContacts(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeContacts(Tp::UIntList,Tp::Service::ConnectionInterfaceContactListAdaptor::RemoveContactsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveContactsContextPtr ctx = RemoveContactsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeContacts",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::RemoveContactsContextPtr, ctx));
}

void ConnectionInterfaceContactListAdaptor::Unsubscribe(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("unsubscribe(Tp::UIntList,Tp::Service::ConnectionInterfaceContactListAdaptor::UnsubscribeContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    UnsubscribeContextPtr ctx = UnsubscribeContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "unsubscribe",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::UnsubscribeContextPtr, ctx));
}

void ConnectionInterfaceContactListAdaptor::Unpublish(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("unpublish(Tp::UIntList,Tp::Service::ConnectionInterfaceContactListAdaptor::UnpublishContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    UnpublishContextPtr ctx = UnpublishContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "unpublish",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::UnpublishContextPtr, ctx));
}

void ConnectionInterfaceContactListAdaptor::Download(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("download(Tp::Service::ConnectionInterfaceContactListAdaptor::DownloadContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    DownloadContextPtr ctx = DownloadContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "download",
        Q_ARG(Tp::Service::ConnectionInterfaceContactListAdaptor::DownloadContextPtr, ctx));
}

ConnectionInterfaceContactsAdaptor::ConnectionInterfaceContactsAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ConnectionInterfaceContactsAdaptor::~ConnectionInterfaceContactsAdaptor()
{
}

QStringList ConnectionInterfaceContactsAdaptor::ContactAttributeInterfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("contactAttributeInterfaces"));
}

Tp::ContactAttributesMap ConnectionInterfaceContactsAdaptor::GetContactAttributes(const Tp::UIntList& handles, const QStringList& interfaces, bool hold, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactAttributes(Tp::UIntList,QStringList,bool,Tp::Service::ConnectionInterfaceContactsAdaptor::GetContactAttributesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactAttributesMap();
    }

    GetContactAttributesContextPtr ctx = GetContactAttributesContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactAttributesMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactAttributes",
        Q_ARG(Tp::UIntList, handles), Q_ARG(QStringList, interfaces), Q_ARG(bool, hold),
        Q_ARG(Tp::Service::ConnectionInterfaceContactsAdaptor::GetContactAttributesContextPtr, ctx));
    return Tp::ContactAttributesMap();
}

uint ConnectionInterfaceContactsAdaptor::GetContactByID(const QString& identifier, const QStringList& interfaces, const QDBusMessage& dbusMessage, QVariantMap& attributes)
{
    if (adaptee()->metaObject()->indexOfMethod("getContactByID(QString,QStringList,Tp::Service::ConnectionInterfaceContactsAdaptor::GetContactByIDContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetContactByIDContextPtr ctx = GetContactByIDContextPtr(
            new Tp::MethodInvocationContext< uint, QVariantMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getContactByID",
        Q_ARG(QString, identifier), Q_ARG(QStringList, interfaces),
        Q_ARG(Tp::Service::ConnectionInterfaceContactsAdaptor::GetContactByIDContextPtr, ctx));
    return uint();
}

ConnectionInterfaceLocationAdaptor::ConnectionInterfaceLocationAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(locationUpdated(uint, const QVariantMap&)), SIGNAL(LocationUpdated(uint, const QVariantMap&)));
}

ConnectionInterfaceLocationAdaptor::~ConnectionInterfaceLocationAdaptor()
{
}

Tp::UIntList ConnectionInterfaceLocationAdaptor::LocationAccessControlTypes() const
{
    return qvariant_cast< Tp::UIntList >(adaptee()->property("locationAccessControlTypes"));
}

Tp::RichPresenceAccessControl ConnectionInterfaceLocationAdaptor::LocationAccessControl() const
{
    return qvariant_cast< Tp::RichPresenceAccessControl >(adaptee()->property("locationAccessControl"));
}

void ConnectionInterfaceLocationAdaptor::SetLocationAccessControl(const Tp::RichPresenceAccessControl &newValue)
{
    adaptee()->setProperty("locationAccessControl", qVariantFromValue(newValue));
}

uint ConnectionInterfaceLocationAdaptor::SupportedLocationFeatures() const
{
    return qvariant_cast< uint >(adaptee()->property("supportedLocationFeatures"));
}

Tp::ContactLocations ConnectionInterfaceLocationAdaptor::GetLocations(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getLocations(Tp::UIntList,Tp::Service::ConnectionInterfaceLocationAdaptor::GetLocationsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ContactLocations();
    }

    GetLocationsContextPtr ctx = GetLocationsContextPtr(
            new Tp::MethodInvocationContext< Tp::ContactLocations >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getLocations",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceLocationAdaptor::GetLocationsContextPtr, ctx));
    return Tp::ContactLocations();
}

QVariantMap ConnectionInterfaceLocationAdaptor::RequestLocation(uint contact, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestLocation(uint,Tp::Service::ConnectionInterfaceLocationAdaptor::RequestLocationContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QVariantMap();
    }

    RequestLocationContextPtr ctx = RequestLocationContextPtr(
            new Tp::MethodInvocationContext< QVariantMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestLocation",
        Q_ARG(uint, contact),
        Q_ARG(Tp::Service::ConnectionInterfaceLocationAdaptor::RequestLocationContextPtr, ctx));
    return QVariantMap();
}

void ConnectionInterfaceLocationAdaptor::SetLocation(const QVariantMap& location, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setLocation(QVariantMap,Tp::Service::ConnectionInterfaceLocationAdaptor::SetLocationContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetLocationContextPtr ctx = SetLocationContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setLocation",
        Q_ARG(QVariantMap, location),
        Q_ARG(Tp::Service::ConnectionInterfaceLocationAdaptor::SetLocationContextPtr, ctx));
}

ConnectionInterfaceMailNotificationAdaptor::ConnectionInterfaceMailNotificationAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(mailsReceived(const Tp::MailList&)), SIGNAL(MailsReceived(const Tp::MailList&)));
    connect(adaptee, SIGNAL(unreadMailsChanged(uint, const Tp::MailList&, const QStringList&)), SIGNAL(UnreadMailsChanged(uint, const Tp::MailList&, const QStringList&)));
}

ConnectionInterfaceMailNotificationAdaptor::~ConnectionInterfaceMailNotificationAdaptor()
{
}

uint ConnectionInterfaceMailNotificationAdaptor::MailNotificationFlags() const
{
    return qvariant_cast< uint >(adaptee()->property("mailNotificationFlags"));
}

uint ConnectionInterfaceMailNotificationAdaptor::UnreadMailCount() const
{
    return qvariant_cast< uint >(adaptee()->property("unreadMailCount"));
}

Tp::MailList ConnectionInterfaceMailNotificationAdaptor::UnreadMails() const
{
    return qvariant_cast< Tp::MailList >(adaptee()->property("unreadMails"));
}

QString ConnectionInterfaceMailNotificationAdaptor::MailAddress() const
{
    return qvariant_cast< QString >(adaptee()->property("mailAddress"));
}

Tp::MailURL ConnectionInterfaceMailNotificationAdaptor::RequestInboxURL(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestInboxURL(Tp::Service::ConnectionInterfaceMailNotificationAdaptor::RequestInboxURLContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::MailURL();
    }

    RequestInboxURLContextPtr ctx = RequestInboxURLContextPtr(
            new Tp::MethodInvocationContext< Tp::MailURL >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestInboxURL",
        Q_ARG(Tp::Service::ConnectionInterfaceMailNotificationAdaptor::RequestInboxURLContextPtr, ctx));
    return Tp::MailURL();
}

Tp::MailURL ConnectionInterfaceMailNotificationAdaptor::RequestMailURL(const QString& ID, const QDBusVariant& URLData, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestMailURL(QString,QDBusVariant,Tp::Service::ConnectionInterfaceMailNotificationAdaptor::RequestMailURLContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::MailURL();
    }

    RequestMailURLContextPtr ctx = RequestMailURLContextPtr(
            new Tp::MethodInvocationContext< Tp::MailURL >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestMailURL",
        Q_ARG(QString, ID), Q_ARG(QDBusVariant, URLData),
        Q_ARG(Tp::Service::ConnectionInterfaceMailNotificationAdaptor::RequestMailURLContextPtr, ctx));
    return Tp::MailURL();
}

ConnectionInterfacePowerSavingAdaptor::ConnectionInterfacePowerSavingAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(powerSavingChanged(bool)), SIGNAL(PowerSavingChanged(bool)));
}

ConnectionInterfacePowerSavingAdaptor::~ConnectionInterfacePowerSavingAdaptor()
{
}

bool ConnectionInterfacePowerSavingAdaptor::PowerSavingActive() const
{
    return qvariant_cast< bool >(adaptee()->property("powerSavingActive"));
}

void ConnectionInterfacePowerSavingAdaptor::SetPowerSaving(bool activate, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setPowerSaving(bool,Tp::Service::ConnectionInterfacePowerSavingAdaptor::SetPowerSavingContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetPowerSavingContextPtr ctx = SetPowerSavingContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setPowerSaving",
        Q_ARG(bool, activate),
        Q_ARG(Tp::Service::ConnectionInterfacePowerSavingAdaptor::SetPowerSavingContextPtr, ctx));
}

ConnectionInterfaceRequestsAdaptor::ConnectionInterfaceRequestsAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(newChannels(const Tp::ChannelDetailsList&)), SIGNAL(NewChannels(const Tp::ChannelDetailsList&)));
    connect(adaptee, SIGNAL(channelClosed(const QDBusObjectPath&)), SIGNAL(ChannelClosed(const QDBusObjectPath&)));
}

ConnectionInterfaceRequestsAdaptor::~ConnectionInterfaceRequestsAdaptor()
{
}

Tp::ChannelDetailsList ConnectionInterfaceRequestsAdaptor::Channels() const
{
    return qvariant_cast< Tp::ChannelDetailsList >(adaptee()->property("channels"));
}

Tp::RequestableChannelClassList ConnectionInterfaceRequestsAdaptor::RequestableChannelClasses() const
{
    return qvariant_cast< Tp::RequestableChannelClassList >(adaptee()->property("requestableChannelClasses"));
}

QDBusObjectPath ConnectionInterfaceRequestsAdaptor::CreateChannel(const QVariantMap& request, const QDBusMessage& dbusMessage, QVariantMap& properties)
{
    if (adaptee()->metaObject()->indexOfMethod("createChannel(QVariantMap,Tp::Service::ConnectionInterfaceRequestsAdaptor::CreateChannelContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QDBusObjectPath();
    }

    CreateChannelContextPtr ctx = CreateChannelContextPtr(
            new Tp::MethodInvocationContext< QDBusObjectPath, QVariantMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "createChannel",
        Q_ARG(QVariantMap, request),
        Q_ARG(Tp::Service::ConnectionInterfaceRequestsAdaptor::CreateChannelContextPtr, ctx));
    return QDBusObjectPath();
}

bool ConnectionInterfaceRequestsAdaptor::EnsureChannel(const QVariantMap& request, const QDBusMessage& dbusMessage, QDBusObjectPath& channel, QVariantMap& properties)
{
    if (adaptee()->metaObject()->indexOfMethod("ensureChannel(QVariantMap,Tp::Service::ConnectionInterfaceRequestsAdaptor::EnsureChannelContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return bool();
    }

    EnsureChannelContextPtr ctx = EnsureChannelContextPtr(
            new Tp::MethodInvocationContext< bool, QDBusObjectPath, QVariantMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "ensureChannel",
        Q_ARG(QVariantMap, request),
        Q_ARG(Tp::Service::ConnectionInterfaceRequestsAdaptor::EnsureChannelContextPtr, ctx));
    return bool();
}

ConnectionInterfaceServicePointAdaptor::ConnectionInterfaceServicePointAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(servicePointsChanged(const Tp::ServicePointInfoList&)), SIGNAL(ServicePointsChanged(const Tp::ServicePointInfoList&)));
}

ConnectionInterfaceServicePointAdaptor::~ConnectionInterfaceServicePointAdaptor()
{
}

Tp::ServicePointInfoList ConnectionInterfaceServicePointAdaptor::KnownServicePoints() const
{
    return qvariant_cast< Tp::ServicePointInfoList >(adaptee()->property("knownServicePoints"));
}

ConnectionInterfaceSimplePresenceAdaptor::ConnectionInterfaceSimplePresenceAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(presencesChanged(const Tp::SimpleContactPresences&)), SIGNAL(PresencesChanged(const Tp::SimpleContactPresences&)));
}

ConnectionInterfaceSimplePresenceAdaptor::~ConnectionInterfaceSimplePresenceAdaptor()
{
}

Tp::SimpleStatusSpecMap ConnectionInterfaceSimplePresenceAdaptor::Statuses() const
{
    return qvariant_cast< Tp::SimpleStatusSpecMap >(adaptee()->property("statuses"));
}

uint ConnectionInterfaceSimplePresenceAdaptor::MaximumStatusMessageLength() const
{
    return qvariant_cast< uint >(adaptee()->property("maximumStatusMessageLength"));
}

void ConnectionInterfaceSimplePresenceAdaptor::SetPresence(const QString& status, const QString& statusMessage, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setPresence(QString,QString,Tp::Service::ConnectionInterfaceSimplePresenceAdaptor::SetPresenceContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetPresenceContextPtr ctx = SetPresenceContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setPresence",
        Q_ARG(QString, status), Q_ARG(QString, statusMessage),
        Q_ARG(Tp::Service::ConnectionInterfaceSimplePresenceAdaptor::SetPresenceContextPtr, ctx));
}

Tp::SimpleContactPresences ConnectionInterfaceSimplePresenceAdaptor::GetPresences(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getPresences(Tp::UIntList,Tp::Service::ConnectionInterfaceSimplePresenceAdaptor::GetPresencesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::SimpleContactPresences();
    }

    GetPresencesContextPtr ctx = GetPresencesContextPtr(
            new Tp::MethodInvocationContext< Tp::SimpleContactPresences >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getPresences",
        Q_ARG(Tp::UIntList, contacts),
        Q_ARG(Tp::Service::ConnectionInterfaceSimplePresenceAdaptor::GetPresencesContextPtr, ctx));
    return Tp::SimpleContactPresences();
}

}
}