/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.40 from the
 * contents of rxvtperl.xs. Do not edit this file, edit rxvtperl.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
/*----------------------------------------------------------------------*
 * File:	rxvtperl.xs
 *----------------------------------------------------------------------*
 *
 * All portions of code are copyright by their respective author/s.
 * Copyright (c) 2005-2014 Marc Lehmann <schmorp@schmorp.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------*/

#define line_t perl_line_t
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#undef line_t
#undef bool // perl defines it's own bool type, except with g++... what a trap

#include "../config.h"

#include <stddef.h>
#include <stdarg.h>

#include "unistd.h"

#include "ev_cpp.h"
#include "rxvt.h"
#include "keyboard.h"
#include "rxvtutil.h"
#include "rxvtperl.h"

#include "perlxsi.c"

#define GRAB_CURSOR THIS->scrollBar.leftptr_cursor

#undef LINENO
#define LINENO(n) MOD (THIS->term_start + int(n), THIS->total_rows)
#undef ROW
#define ROW(n) THIS->row_buf [LINENO (n)]

/////////////////////////////////////////////////////////////////////////////

typedef char *		octet_string;
typedef char *		utf8_string;

typedef int		render_repeat_mode;

#if HAVE_PIXBUF
typedef GdkPixbuf *	urxvt__pixbuf;
#endif
#if HAVE_IMG
typedef rxvt_img *	urxvt__img;
typedef rxvt_img::nv	rxvt_img__nv;

/////////////////////////////////////////////////////////////////////////////

static rgba
parse_rgba (SV *sv, rxvt_screen *s = 0)
{
  rgba c;

  if (SvROK (sv))
    {
      AV *av = (AV *)SvRV (sv);

      if (SvTYPE ((SV *)av) != SVt_PVAV)
        croak ("colour must be either a colour string, or an array,");

      int len = av_len (av) + 1;

      if (len != 1 && len != 3 && len != 4)
        croak ("component colour array must have 1, 3 or 4 components,");

      c.a = rgba::MAX_CC;

      c.r = c.g = c.b = float_to_component (SvIV (*av_fetch (av, 0, 0)));

      if (len >= 3)
        {
          c.g = float_to_component (SvIV (*av_fetch (av, 1, 0)));
          c.b = float_to_component (SvIV (*av_fetch (av, 2, 0)));

          if (len >= 4)
            c.a = float_to_component (SvIV (*av_fetch (av, 3, 0)));
        }
    }
  else if (s)
    {
      rxvt_color rc;
      rc.set (s, SvPVbyte_nolen (sv));
      rc.get (c);
    }
  else
    croak ("unable to parse colour,");

  return c;
}

/////////////////////////////////////////////////////////////////////////////
#endif

static wchar_t *
sv2wcs (SV *sv)
{
  STRLEN len;
  char *str = SvPVutf8 (sv, len);
  return rxvt_utf8towcs (str, len);
}

static SV *
wcs2sv (wchar_t *wstr, int len = -1)
{
  char *str = rxvt_wcstoutf8 (wstr, len);

  SV *sv = newSVpv (str, 0);
  SvUTF8_on (sv);
  free (str);

  return sv;
}

static SV *
newSVptr (void *ptr, const char *klass)
{
  HV *hv = newHV ();
  sv_magic ((SV *)hv, 0, PERL_MAGIC_ext, (char *)ptr, 0);
  return sv_bless (newRV_noinc ((SV *)hv), gv_stashpv (klass, 1));
}

static void
clearSVptr (SV *sv)
{
  if (SvROK (sv))
    sv = SvRV (sv);

  hv_clear ((HV *)sv);
  sv_unmagic (sv, PERL_MAGIC_ext);
}

static long
SvPTR (SV *sv, const char *klass)
{
  if (!sv_derived_from (sv, klass))
    croak ("object of type %s expected", klass);

  MAGIC *mg = mg_find (SvRV (sv), PERL_MAGIC_ext);

  if (!mg)
    croak ("perl code used %s object, but C++ object is already destroyed, caught", klass);

  return (long)mg->mg_ptr;
}

#define newSVterm(term) SvREFCNT_inc ((SV *)(term)->perl.self)
#define SvTERM(sv) (rxvt_term *)SvPTR ((sv), "urxvt::term")

/////////////////////////////////////////////////////////////////////////////

#define SvOVERLAY(sv) (overlay *)SvPTR (sv, "urxvt::overlay")

class overlay : overlay_base
{
  rxvt_term *THIS;
  AV *overlay_av;
  int border;

public:
  HV *self;

  overlay (rxvt_term *THIS, int x_, int y_, int w_, int h_, rend_t rstyle, int border);
  ~overlay ();

  void show ();
  void hide ();

  void swap ();

  void set (int x, int y, SV *str, SV *rend);
};

overlay::overlay (rxvt_term *THIS, int x_, int y_, int w_, int h_, rend_t rstyle, int border)
: THIS(THIS), border(border == 2), overlay_av (0)
{
  x = x_;
  y = y_;
  w = w_;
  h = h_;

  if (w < 0) w = 0;
  if (h < 0) h = 0;

  if (border == 2)
    {
      w += 2;
      h += 2;
    }

  text = new text_t *[h];
  rend = new rend_t *[h];

  for (int y = 0; y < h; y++)
    {
      text_t *tp = text[y] = new text_t[w];
      rend_t *rp = rend[y] = new rend_t[w];

      text_t t0, t1, t2;
      rend_t r = rstyle;

      if (border == 2)
        {
          if (y == 0)
            t0 = 0x2554, t1 = 0x2550, t2 = 0x2557;
          else if (y < h - 1)
            t0 = 0x2551, t1 = 0x0020, t2 = 0x2551;
          else
            t0 = 0x255a, t1 = 0x2550, t2 = 0x255d;

          *tp++ = t0;
          *rp++ = r;

          for (int x = w - 2; x-- > 0; )
            {
              *tp++ = t1;
              *rp++ = r;
            }

          *tp = t2;
          *rp = r;
        }
      else
        for (int x = w; x-- > 0; )
          {
            *tp++ = 0x0020;
            *rp++ = r;
          }
    }

  show ();
}

overlay::~overlay ()
{
  hide ();

  for (int y = h; y--; )
    {
      delete [] text[y];
      delete [] rend[y];
    }

  delete [] text;
  delete [] rend;
}

void
overlay::show ()
{
  if (overlay_av)
    return;

  overlay_av = (AV *)SvREFCNT_inc (SvRV (
        *hv_fetch ((HV *)SvRV ((SV *)THIS->perl.self), "_overlay", 8, 0)
     ));
  av_push (overlay_av, newSViv ((long)this));

  THIS->want_refresh = 1;
  THIS->refresh_check ();
}

void
overlay::hide ()
{
  if (!overlay_av)
    return;

  int i;

  for (i = AvFILL (overlay_av); i >= 0; i--)
    if (SvIV (*av_fetch (overlay_av, i, 1)) == (long)this)
      break;

  for (; i < AvFILL (overlay_av); i++)
    av_store (overlay_av, i, SvREFCNT_inc (*av_fetch (overlay_av, i + 1, 0)));

  av_pop (overlay_av);

  SvREFCNT_dec (overlay_av);
  overlay_av = 0;

  THIS->want_refresh = 1;
  THIS->refresh_check ();
}

void overlay::swap ()
{
  int ov_x = max (0, min (MOD (x, THIS->ncol), THIS->ncol - w));
  int ov_y = max (0, min (MOD (y, THIS->nrow), THIS->nrow - h));

  int ov_w = min (w, THIS->ncol - ov_x);
  int ov_h = min (h, THIS->nrow - ov_y);

  // hide cursor if it is within the overlay area
  if (IN_RANGE_EXC (THIS->screen.cur.col - ov_x, 0, ov_w)
      && IN_RANGE_EXC (THIS->screen.cur.row - ov_y, 0, ov_h))
    THIS->screen.flags &= ~Screen_VisibleCursor;

  for (int y = ov_h; y--; )
    {
      text_t *t1 = text [y];
      rend_t *r1 = rend [y];

      text_t *t2 = ROW(y + ov_y + THIS->view_start).t + ov_x;
      rend_t *r2 = ROW(y + ov_y + THIS->view_start).r + ov_x;

      for (int x = ov_w; x--; )
        {
          text_t t = *t1; *t1++ = *t2; *t2++ = t;
          rend_t r = *r1; *r1++ = *r2; *r2++ = SET_FONT (r, THIS->fontset [GET_STYLE (r)]->find_font (t));
        }
    }

}

void overlay::set (int x, int y, SV *text, SV *rend)
{
  x += border;
  y += border;

  if (!IN_RANGE_EXC (y, 0, h - border))
    return;

  wchar_t *wtext = sv2wcs (text);

  for (int col = min (wcslen (wtext), w - x - border); col--; )
    this->text [y][x + col] = wtext [col];

  free (wtext);

  if (rend)
    {
      if (!SvROK (rend) || SvTYPE (SvRV (rend)) != SVt_PVAV)
        croak ("rend must be arrayref");

      AV *av = (AV *)SvRV (rend);

      for (int col = min (AvFILL (av) + 1, w - x - border); col--; )
        this->rend [y][x + col] = SvIV (*av_fetch (av, col, 1));
    }

  THIS->want_refresh = 1;
  THIS->refresh_check ();
}

/////////////////////////////////////////////////////////////////////////////

#include "iom_perl.h"

/////////////////////////////////////////////////////////////////////////////

struct rxvt_perl_interp rxvt_perl;

static PerlInterpreter *perl;

rxvt_perl_interp::~rxvt_perl_interp ()
{
  if (perl)
    {
      perl_destruct (perl);
      perl_free (perl);
      PERL_SYS_TERM ();
    }
}

void
rxvt_perl_interp::init ()
{
  if (!perl)
    {
      rxvt_push_locale (""); // perl init destroys current locale

      {
        perl_environ = rxvt_environ;
        localise_env set_environ (perl_environ);

        char *args[] = {
          "",
          "-e"
          "BEGIN {"
          "   urxvt->bootstrap;"
          "   unshift @INC, '" LIBDIR "';"
          "}"
          ""
          "use urxvt;"
        };
        int argc = ecb_array_length (args);
        char **argv = args;

        PERL_SYS_INIT3 (&argc, &argv, &environ);
        perl = perl_alloc ();
        perl_construct (perl);

        if (perl_parse (perl, xs_init, argc, argv, (char **)NULL)
            || perl_run (perl))
          {
            rxvt_warn ("unable to initialize perl-interpreter, continuing without.\n");

            perl_destruct (perl);
            perl_free (perl);
            perl = 0;
          }
      }

      rxvt_pop_locale ();
    }
}

void
rxvt_perl_interp::init (rxvt_term *term)
{
  init ();

  if (perl && !term->perl.self)
    {
      // runs outside of perls ENV
      term->perl.self = (void *)newSVptr ((void *)term, "urxvt::term");
      hv_store ((HV *)SvRV ((SV *)term->perl.self), "_overlay", 8, newRV_noinc ((SV *)newAV ()), 0);
      hv_store ((HV *)SvRV ((SV *)term->perl.self), "_selection", 10, newRV_noinc ((SV *)newAV ()), 0);
    }
}

void
rxvt_perl_interp::eval (const char *str)
{
  eval_pv (str, 1);
}

void
rxvt_perl_interp::usage (rxvt_term *term, int type)
{
  localise_env set_environ (perl_environ);

  ENTER;
  SAVETMPS;

  dSP;
  PUSHMARK (SP);
  EXTEND (SP, 2);
  PUSHs (sv_2mortal (newSVterm (term)));
  PUSHs (sv_2mortal (newSViv (type)));
  PUTBACK;
  call_pv ("urxvt::usage", G_VOID | G_DISCARD);

  FREETMPS;
  LEAVE;
}

uint8_t
rxvt_perl_interp::parse_resource (rxvt_term *term, const char *name, bool arg, bool longopt, bool flag, const char *value)
{
  localise_env set_environ (perl_environ);

  ENTER;
  SAVETMPS;

  dSP;
  PUSHMARK (SP);
  EXTEND (SP, 6);
  PUSHs (sv_2mortal (newSVterm (term)));
  PUSHs (sv_2mortal (newSVpv (name, 0)));
  PUSHs (arg     ? &PL_sv_yes : &PL_sv_no);
  PUSHs (longopt ? &PL_sv_yes : &PL_sv_no);
  PUSHs (flag    ? &PL_sv_yes : &PL_sv_no);
  PUSHs (value ? sv_2mortal (newSVpv (value, 0)) : &PL_sv_undef);
  PUTBACK;
  call_pv ("urxvt::parse_resource", G_SCALAR);
  SPAGAIN;

  uint8_t ret = POPi;

  FREETMPS;
  LEAVE;

  return ret;
}

static void
_keysym_resource_push (rxvt_term *term, const char *k, const char *v)
{
  unsigned int state;

  if (term->parse_keysym (k, state) == -1)
    return;

  dSP;
  XPUSHs (sv_2mortal (newSVpv (v, 0)));
  PUTBACK;
}

static void
_keysym_resources (rxvt_term *term)
{
  term->enumerate_keysym_resources (_keysym_resource_push);
}

static void
ungrab (rxvt_term *THIS)
{
  if (THIS->perl.grabtime)
    {
      XUngrabKeyboard (THIS->dpy, THIS->perl.grabtime);
      XUngrabPointer  (THIS->dpy, THIS->perl.grabtime);
      THIS->perl.grabtime = 0;
    }
}

bool
rxvt_perl_interp::invoke (rxvt_term *term, hook_type htype, ...)
{
  if (!perl || !term->perl.self)
    return false;

  localise_env set_environ (perl_environ);

  // pre-handling of some events
  if (htype == HOOK_REFRESH_END)
    {
      AV *av = (AV *)SvRV (*hv_fetch ((HV *)SvRV ((SV *)term->perl.self), "_overlay", 8, 0));

      for (int i = 0; i <= AvFILL (av); i++)
        ((overlay *)SvIV (*av_fetch (av, i, 0)))->swap ();
    }
  else if (htype == HOOK_DESTROY)
    {
      AV *av = (AV *)SvRV (*hv_fetch ((HV *)SvRV ((SV *)term->perl.self), "_selection", 10, 0));

      for (int i = AvFILL (av); i >= 0; i--)
        {
          rxvt_selection *req = (rxvt_selection *)SvIV (*av_fetch (av, i, 0));
          delete req;
        }
    }

  bool event_consumed;

  if (term->perl.should_invoke [htype])
    {
      dSP;
      va_list ap;

      va_start (ap, htype);

      ENTER;
      SAVETMPS;

      PUSHMARK (SP);

      EXTEND (SP, 2);
      PUSHs (sv_2mortal (newSVterm (term)));
      PUSHs (sv_2mortal (newSViv (htype)));

      for (;;) {
        data_type dt = (data_type)va_arg (ap, int);

        switch (dt)
          {
            case DT_INT:
              XPUSHs (sv_2mortal (newSViv (va_arg (ap, int))));
              break;

            case DT_LONG:
              XPUSHs (sv_2mortal (newSViv (va_arg (ap, long))));
              break;

            case DT_STR:
              XPUSHs (sv_2mortal (newSVpv (va_arg (ap, char *), 0)));
              break;

            case DT_STR_LEN:
              {
                char *str = va_arg (ap, char *);
                int len   = va_arg (ap, int);

                XPUSHs (sv_2mortal (newSVpvn (str, len)));
              }
              break;

            case DT_WCS_LEN:
              {
                wchar_t *wstr = va_arg (ap, wchar_t *);
                int wlen      = va_arg (ap, int);

                XPUSHs (sv_2mortal (wcs2sv (wstr, wlen)));
              }
             break;

            case DT_LCS_LEN:
              {
                long *lstr = va_arg (ap, long *);
                int llen   = va_arg (ap, int);

                XPUSHs (sv_2mortal (newSVpvn ((char *)lstr, llen * sizeof (long))));
              }
             break;

            case DT_XEVENT:
              {
                XEvent *xe = va_arg (ap, XEvent *);
                HV *hv = newHV ();

#               define set(name, sv) hv_store (hv, # name,  sizeof (# name) - 1, sv, 0)
#               define setiv(name, val) hv_store (hv, # name,  sizeof (# name) - 1, newSViv (val), 0)
#               define setuv(name, val) hv_store (hv, # name,  sizeof (# name) - 1, newSVuv (val), 0)
#               undef set

                setiv (type,       xe->type);
                setiv (send_event, xe->xany.send_event);
                setiv (serial,     xe->xany.serial);

                switch (xe->type)
                  {
                    case KeyPress:
                    case KeyRelease:
                    case ButtonPress:
                    case ButtonRelease:
                    case MotionNotify:
                      setuv (window,    xe->xmotion.window);
                      setuv (root,      xe->xmotion.root);
                      setuv (subwindow, xe->xmotion.subwindow);
                      setuv (time,      xe->xmotion.time);
                      setiv (x,         xe->xmotion.x);
                      setiv (y,         xe->xmotion.y);
                      setiv (row,       xe->xmotion.y / term->fheight + term->view_start);
                      setiv (col,       xe->xmotion.x / term->fwidth);
                      setiv (x_root,    xe->xmotion.x_root);
                      setiv (y_root,    xe->xmotion.y_root);
                      setuv (state,     xe->xmotion.state);

                      switch (xe->type)
                        {
                          case KeyPress:
                          case KeyRelease:
                            setuv (keycode, xe->xkey.keycode);
                            break;

                          case ButtonPress:
                          case ButtonRelease:
                            setuv (button,  xe->xbutton.button);
                            break;

                          case MotionNotify:
                            setiv (is_hint, xe->xmotion.is_hint);
                            break;
                        }

                      break;

                    case MapNotify:
                    case UnmapNotify:
                    case ConfigureNotify:
                      setuv (event,  xe->xconfigure.event);
                      setuv (window, xe->xconfigure.window);

                      switch (xe->type)
                        {
                          case ConfigureNotify:
                            setiv (x,      xe->xconfigure.x);
                            setiv (y,      xe->xconfigure.y);
                            setiv (width,  xe->xconfigure.width);
                            setiv (height, xe->xconfigure.height);
                            setuv (above,  xe->xconfigure.above);
                            break;
                        }

                      break;

                    case PropertyNotify:
                      setuv (window,       xe->xproperty.window);
                      setuv (atom,         xe->xproperty.atom);
                      setuv (time,         xe->xproperty.time);
                      setiv (state,        xe->xproperty.state);
                      break;

                    case ClientMessage:
                      setuv (window,       xe->xclient.window);
                      setuv (message_type, xe->xclient.message_type);
                      setuv (format,       xe->xclient.format);
                      setuv (l0,           xe->xclient.data.l[0]);
                      setuv (l1,           xe->xclient.data.l[1]);
                      setuv (l2,           xe->xclient.data.l[2]);
                      setuv (l3,           xe->xclient.data.l[3]);
                      setuv (l4,           xe->xclient.data.l[4]);
                      break;
                  }

                XPUSHs (sv_2mortal (newRV_noinc ((SV *)hv)));
              }
              break;

            case DT_END:
              goto call;

            default:
              rxvt_fatal ("FATAL: unable to pass data type %d\n", dt);
          }
      }

    call:
      va_end (ap);

      PUTBACK;
      int count = call_pv ("urxvt::invoke", G_ARRAY | G_EVAL);
      SPAGAIN;

      if (count)
        {
          SV *status = POPs;
          count = SvTRUE (status);
        }

      PUTBACK;
      FREETMPS;
      LEAVE;

      if (SvTRUE (ERRSV))
        {
          rxvt_warn ("perl hook %d evaluation error: %s", htype, SvPVbyte_nolen (ERRSV));
          ungrab (term); // better lose the grab than the session
        }

      event_consumed = !!count;
    }
  else
    event_consumed = false;

  // post-handling of some events
  if (htype == HOOK_REFRESH_BEGIN)
    {
      AV *av = (AV *)SvRV (*hv_fetch ((HV *)SvRV ((SV *)term->perl.self), "_overlay", 8, 0));

      for (int i = AvFILL (av); i >= 0; i--)
        ((overlay *)SvIV (*av_fetch (av, i, 0)))->swap ();
    }
  else if (htype == HOOK_DESTROY)
    {
      clearSVptr ((SV *)term->perl.self);
      SvREFCNT_dec ((SV *)term->perl.self);

      // don't allow further calls
      term->perl.self = 0;
    }

  return event_consumed;
}

void
rxvt_perl_interp::selection_finish (rxvt_selection *sel, char *data, unsigned int len)
{
  localise_env set_environ (perl_environ);

  ENTER;
  SAVETMPS;

  dSP;
  XPUSHs (sv_2mortal (newSVpvn (data, len)));
  PUTBACK;
  call_sv ((SV *)sel->cb_sv, G_VOID | G_DISCARD | G_EVAL);

  if (SvTRUE (ERRSV))
    rxvt_warn ("perl selection callback evaluation error: %s", SvPVbyte_nolen (ERRSV));

  FREETMPS;
  LEAVE;
}

/////////////////////////////////////////////////////////////////////////////

#line 798 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 942 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

XS_EUPXS(XS_urxvt_log); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_log)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "msg");
    {
	utf8_string        msg = SvPVutf8_nolen (ST(0)) /* imperfect, destroys references */
;
#line 1034 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_log ("%s", msg);
#line 955 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt_warn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_warn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "msg");
    {
	utf8_string        msg = SvPVutf8_nolen (ST(0)) /* imperfect, destroys references */
;
#line 1039 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_warn ("%s", msg);
#line 972 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt_fatal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_fatal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "msg");
    {
	utf8_string        msg = SvPVutf8_nolen (ST(0)) /* imperfect, destroys references */
;
#line 1044 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_fatal ("%s", msg);
#line 989 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__exit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__exit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "status");
    {
	int	status = (int)SvIV(ST(0))
;

	_exit(status);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt_catch_fatal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_catch_fatal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "block");
    {
	SV *	block = ST(0)
;
#line 1053 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        try
          {
            PUSHMARK (SP);
            PUTBACK;
            call_sv (block, G_VOID | G_DISCARD);
            SPAGAIN;
          }
        catch (const rxvt_failure_exception &e)
          {
            croak ("rxvt_fatal exception caught, trying to continue.");
          }
#line 1032 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt_NOW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_NOW)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	NV	RETVAL;
	dXSTARG;
#line 1068 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = ev::now ();
#line 1049 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_GET_BASEFG); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_GET_BASEFG)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "rend");
    {
	int	RETVAL;
	dXSTARG;
	int	rend = (int)SvIV(ST(0))
;
#line 1075 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = GET_BASEFG (rend);
#line 1069 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_GET_BASEBG); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_GET_BASEBG)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "rend");
    {
	int	RETVAL;
	dXSTARG;
	int	rend = (int)SvIV(ST(0))
;
#line 1082 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = GET_BASEBG (rend);
#line 1089 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_SET_FGCOLOR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_SET_FGCOLOR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "rend, new_color");
    {
	int	RETVAL;
	dXSTARG;
	int	rend = (int)SvIV(ST(0))
;
	int	new_color = (int)SvIV(ST(1))
;
#line 1089 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = SET_FGCOLOR (rend, clamp (new_color, 0, TOTAL_COLORS - 1));
#line 1111 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_SET_BGCOLOR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_SET_BGCOLOR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "rend, new_color");
    {
	int	RETVAL;
	dXSTARG;
	int	rend = (int)SvIV(ST(0))
;
	int	new_color = (int)SvIV(ST(1))
;
#line 1096 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = SET_BGCOLOR (rend, clamp (new_color, 0, TOTAL_COLORS - 1));
#line 1133 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_GET_CUSTOM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_GET_CUSTOM)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "rend");
    {
	int	RETVAL;
	dXSTARG;
	int	rend = (int)SvIV(ST(0))
;
#line 1103 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = (rend & RS_customMask) >> RS_customShift;
#line 1153 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_SET_CUSTOM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_SET_CUSTOM)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "rend, new_value");
    {
	int	RETVAL;
	dXSTARG;
	int	rend = (int)SvIV(ST(0))
;
	int	new_value = (int)SvIV(ST(1))
;
#line 1110 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        if (!IN_RANGE_EXC (new_value, 0, RS_customCount))
          croak ("custom value out of range, must be 0..%d", RS_customCount - 1);

        RETVAL = (rend & ~RS_customMask)
               | ((new_value << RS_customShift) & RS_customMask);
}
#line 1181 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt_termlist); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt_termlist)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1123 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        EXTEND (SP, rxvt_term::termlist.size ());

        for (rxvt_term **t = rxvt_term::termlist.begin (); t < rxvt_term::termlist.end (); t++)
          if ((*t)->perl.self)
            PUSHs (sv_2mortal (newSVterm (*t)));
}
#line 1205 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__new_selection_request); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__new_selection_request)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "term, selnum, tm, win, prop, cb");
    {
	IV	RETVAL;
	dXSTARG;
	rxvt_term *	term = SvTERM (ST(0))
;
	int	selnum = (int)SvIV(ST(1))
;
	Time	tm = (Time)SvUV(ST(2))
;
	Window	win = (Window)SvUV(ST(3))
;
	Atom	prop = (Atom)SvUV(ST(4))
;
	SV *	cb = ST(5)
;
#line 1134 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_selection *req = new rxvt_selection (term->display, selnum, tm, win, prop, term);
        req->cb_sv = newSVsv (cb);
        AV *av = (AV *)SvRV (*hv_fetch ((HV *)SvRV ((SV *)term->perl.self), "_selection", 10, 0));
        av_push (av, newSViv ((IV)req));
        RETVAL = (IV)req;
#line 1239 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__delete_selection_request); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__delete_selection_request)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "req_");
    {
	IV	req_ = (IV)SvIV(ST(0))
;
#line 1145 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_selection *req = (rxvt_selection *)req_;
        AV *av = (AV *)SvRV (*hv_fetch ((HV *)SvRV ((SV *)req->term->perl.self), "_selection", 10, 0));
        int i;

        for (i = AvFILL (av); i >= 0; i--)
          if (SvIV (*av_fetch (av, i, 1)) == req_)
            break;

        for (; i < AvFILL (av); i++)
          av_store (av, i, SvREFCNT_inc (*av_fetch (av, i + 1, 0)));

        av_pop (av);

        delete req;
#line 1270 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "env, arg");
    {
	SV *	RETVAL;
	AV *	env;
	AV *	arg;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    env = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"urxvt::term::_new",
				"env");
		}
	} STMT_END
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    arg = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"urxvt::term::_new",
				"arg");
		}
	} STMT_END
;
#line 1165 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        rxvt_term *term = new rxvt_term;

	stringvec *argv = new stringvec;
        for (int i = 0; i <= AvFILL (arg); i++)
          argv->push_back (strdup (SvPVbyte_nolen (*av_fetch (arg, i, 1))));

	stringvec *envv = new stringvec;
        for (int i = AvFILL (env) + 1; i--; )
          envv->push_back (strdup (SvPVbyte_nolen (*av_fetch (env, i, 1))));

        try
          {
            term->init (argv, envv);
          }
        catch (const class rxvt_failure_exception &e)
          {
            term->destroy ();
            croak ("error while initializing new terminal instance");
          }

        RETVAL = term && term->perl.self
                 ? newSVterm (term) : &PL_sv_undef;
}
#line 1339 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_destroy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_destroy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;

	THIS->destroy();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_set_should_invoke); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_set_should_invoke)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, htype, inc");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	htype = (int)SvIV(ST(1))
;
	int	inc = (int)SvIV(ST(2))
;
#line 1198 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        uint8_t &count = THIS->perl.should_invoke [htype];
        uint8_t prev = count;
        count += inc;
        if (!prev != !count)
	  {
            // hook status changed, react
            switch (htype)
              {
                case HOOK_POSITION_CHANGE:
                  if (count)
                    THIS->get_window_origin (THIS->parent_x, THIS->parent_y);
              }
	  }
#line 1390 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_put_option_db); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_put_option_db)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, specifier, value");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	octet_string        specifier = SvPVbyte_nolen (ST(1))
;
	octet_string        value = SvPVbyte_nolen (ST(2))
;
#line 1215 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XrmPutStringResource (&THIS->option_db, specifier, value);
#line 1411 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term__keysym_resources); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term__keysym_resources)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1220 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        PUTBACK;
        _keysym_resources (THIS);
        SPAGAIN;
#line 1432 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_grab_button); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_grab_button)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, button, modifiers, window= THIS->vt");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	button = (int)SvIV(ST(1))
;
	U32	modifiers = (unsigned long)SvUV(ST(2))
;
	Window	window;

	if (items < 4)
	    window = THIS->vt;
	else {
	    window = (Window)SvUV(ST(3))
;
	}
#line 1227 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = XGrabButton (THIS->dpy, button, modifiers, window, 1,
                              ButtonPressMask | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask | PointerMotionMask,
                              GrabModeSync, GrabModeSync, None, GRAB_CURSOR);
#line 1466 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_ungrab_button); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ungrab_button)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, button, modifiers, window= THIS->vt");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	button = (int)SvIV(ST(1))
;
	U32	modifiers = (unsigned long)SvUV(ST(2))
;
	Window	window;

	if (items < 4)
	    window = THIS->vt;
	else {
	    window = (Window)SvUV(ST(3))
;
	}
#line 1235 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = XUngrabButton (THIS->dpy, button, modifiers, window);
#line 1498 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XGrabKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XGrabKey)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 7)
       croak_xs_usage(cv,  "THIS, keycode, modifiers, window= THIS->vt, owner_events= 1, pointer_mode= GrabModeAsync, keyboard_mode= GrabModeAsync");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	keycode = (int)SvIV(ST(1))
;
	U32	modifiers = (unsigned long)SvUV(ST(2))
;
	Window	window;
	int	owner_events;
	int	pointer_mode;
	int	keyboard_mode;

	if (items < 4)
	    window = THIS->vt;
	else {
	    window = (Window)SvUV(ST(3))
;
	}

	if (items < 5)
	    owner_events = 1;
	else {
	    owner_events = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    pointer_mode = GrabModeAsync;
	else {
	    pointer_mode = (int)SvIV(ST(5))
;
	}

	if (items < 7)
	    keyboard_mode = GrabModeAsync;
	else {
	    keyboard_mode = (int)SvIV(ST(6))
;
	}
#line 1242 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XGrabKey (THIS->dpy, keycode, modifiers, window, owner_events, pointer_mode, keyboard_mode);
#line 1552 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XUngrabKey); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XUngrabKey)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, keycode, modifiers, window= THIS->vt");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	keycode = (int)SvIV(ST(1))
;
	U32	modifiers = (unsigned long)SvUV(ST(2))
;
	Window	window;

	if (items < 4)
	    window = THIS->vt;
	else {
	    window = (Window)SvUV(ST(3))
;
	}
#line 1247 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
	XUngrabKey (THIS->dpy, keycode, modifiers, window);
#line 1581 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_grab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_grab)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, eventtime, sync= 0");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	RETVAL;
	Time	eventtime = (Time)SvUV(ST(1))
;
	int	sync;

	if (items < 3)
	    sync = 0;
	else {
	    sync = (int)SvIV(ST(2))
;
	}
#line 1252 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        int mode = sync ? GrabModeSync : GrabModeAsync;

        THIS->perl.grabtime = 0;

        if (!XGrabPointer (THIS->dpy, THIS->vt, 0,
                           ButtonPressMask | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask | PointerMotionMask,
                           mode, mode, None, GRAB_CURSOR, eventtime))
          if (!XGrabKeyboard (THIS->dpy, THIS->vt, 0, mode, mode, eventtime))
            THIS->perl.grabtime = eventtime;
          else
            XUngrabPointer (THIS->dpy, eventtime);

        RETVAL = !!THIS->perl.grabtime;
}
#line 1623 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_allow_events_async); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_allow_events_async)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1273 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XAllowEvents (THIS->dpy, AsyncBoth,      THIS->perl.grabtime);
#line 1641 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_allow_events_sync); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_allow_events_sync)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1278 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XAllowEvents (THIS->dpy, SyncBoth,       THIS->perl.grabtime);
#line 1658 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_allow_events_replay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_allow_events_replay)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1283 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XAllowEvents (THIS->dpy, ReplayPointer,  THIS->perl.grabtime);
        XAllowEvents (THIS->dpy, ReplayKeyboard, THIS->perl.grabtime);
#line 1676 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_ungrab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ungrab)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1289 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        ungrab (THIS);
#line 1693 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XStringToKeysym); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XStringToKeysym)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, string");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	octet_string        string = SvPVbyte_nolen (ST(1))
;
#line 1294 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = XStringToKeysym (string);
#line 1714 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XKeysymToString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XKeysymToString)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, sym");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	char *	RETVAL;
	dXSTARG;
	int	sym = (int)SvIV(ST(1))
;
#line 1300 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = XKeysymToString (sym);
#line 1736 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XKeysymToKeycode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XKeysymToKeycode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, sym");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	sym = (int)SvIV(ST(1))
;
#line 1306 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = XKeysymToKeycode (THIS->dpy, sym);
#line 1758 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XKeycodeToKeysym); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XKeycodeToKeysym)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, code, index");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	code = (int)SvIV(ST(1))
;
	int	index = (int)SvIV(ST(2))
;
#line 1312 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = rxvt_XKeycodeToKeysym (THIS->dpy, code, index);
#line 1782 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_strwidth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_strwidth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, str");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	SV *	str = ST(1)
;
#line 1318 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        wchar_t *wstr = sv2wcs (str);

	rxvt_push_locale (THIS->locale);
        RETVAL = 0;
        for (wchar_t *wc = wstr; *wc; wc++)
          {
            int w = WCWIDTH (*wc);

            if (w)
              RETVAL += max (w, 1);
          }
        rxvt_pop_locale ();

        free (wstr);
}
#line 1819 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_locale_encode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_locale_encode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, str");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
	SV *	str = ST(1)
;
#line 1340 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        wchar_t *wstr = sv2wcs (str);

	rxvt_push_locale (THIS->locale);
        char *mbstr = rxvt_wcstombs (wstr);
        rxvt_pop_locale ();

        free (wstr);

        RETVAL = newSVpv (mbstr, 0);
        free (mbstr);
}
#line 1851 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_locale_decode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_locale_decode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, octets");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
	SV *	octets = ST(1)
;
#line 1358 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	STRLEN len;
        char *data = SvPVbyte (octets, len);

	rxvt_push_locale (THIS->locale);
        wchar_t *wstr = rxvt_mbstowcs (data, len);
        rxvt_pop_locale ();

        RETVAL = wcs2sv (wstr);
        free (wstr);
}
#line 1883 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#define TERM_OFFSET(sym) offsetof (TermWin_t, sym)
#define TERM_OFFSET_width       TERM_OFFSET(width)
#define TERM_OFFSET_height      TERM_OFFSET(height)
#define TERM_OFFSET_fwidth      TERM_OFFSET(fwidth)
#define TERM_OFFSET_fheight     TERM_OFFSET(fheight)
#define TERM_OFFSET_fbase       TERM_OFFSET(fbase)
#define TERM_OFFSET_nrow        TERM_OFFSET(nrow)
#define TERM_OFFSET_ncol        TERM_OFFSET(ncol)
#define TERM_OFFSET_focus       TERM_OFFSET(focus)
#define TERM_OFFSET_mapped      TERM_OFFSET(mapped)
#define TERM_OFFSET_int_bwidth  TERM_OFFSET(int_bwidth)
#define TERM_OFFSET_ext_bwidth  TERM_OFFSET(ext_bwidth)
#define TERM_OFFSET_lineSpace   TERM_OFFSET(lineSpace)
#define TERM_OFFSET_letterSpace TERM_OFFSET(letterSpace)
#define TERM_OFFSET_saveLines   TERM_OFFSET(saveLines)
#define TERM_OFFSET_total_rows  TERM_OFFSET(total_rows)
#define TERM_OFFSET_top_row     TERM_OFFSET(top_row)

XS_EUPXS(XS_urxvt__term_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_width)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, new_value= NO_INIT");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	new_value;

	if (items >= 2) {
	    new_value = (int)SvIV(ST(1))
;
	}
#line 1411 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = *(int *)((char *)THIS + ix);
        if (items > 1)
          *(int *)((char *)THIS + ix) = new_value;
#line 1930 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_ModLevel3Mask); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ModLevel3Mask)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	unsigned int	RETVAL;
	dXSTARG;
#line 1426 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        switch (ix)
          {
            case 0: RETVAL = THIS->ModLevel3Mask;  break;
            case 1: RETVAL = THIS->ModMetaMask;    break;
            case 2: RETVAL = THIS->ModNumLockMask; break;
            case 3: RETVAL = THIS->current_screen; break;
#ifdef CURSOR_BLINK
            case 4: RETVAL = THIS->hidden_cursor;  break;
#endif
          }
#line 1960 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_display_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_display_id)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	char *	RETVAL;
	dXSTARG;
#line 1445 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        switch (ix)
          {
            case 0: RETVAL = THIS->display->id; break;
            case 1: RETVAL = THIS->locale;      break;
          }
#line 1985 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_envv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_envv)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
#line 1458 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	stringvec *vec = ix ? THIS->argv : THIS->envv;

        EXTEND (SP, vec->size ());

        for (char **i = vec->begin (); i != vec->end (); ++i)
          if (*i)
            PUSHs (sv_2mortal (newSVpv (*i, 0)));
}
#line 2015 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_pty_ev_events); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_pty_ev_events)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, events= ev::UNDEF");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	events;

	if (items < 2)
	    events = ev::UNDEF;
	else {
	    events = (int)SvIV(ST(1))
;
	}
#line 1471 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->pty_ev.events;
        if (events != ev::UNDEF)
          THIS->pty_ev.set (events);
#line 2045 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_pty_fd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_pty_fd)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 1480 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->pty->pty;
#line 2065 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_parent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_parent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	RETVAL;
	dXSTARG;
#line 1487 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->parent;
#line 2085 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_parent_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_parent_x)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 1494 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->parent_x;
#line 2105 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_parent_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_parent_y)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 1501 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->parent_y;
#line 2125 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_vt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_vt)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	RETVAL;
	dXSTARG;
#line 1508 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->vt;
#line 2145 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_vt_emask_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_vt_emask_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, emask");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	U32	emask = (unsigned long)SvUV(ST(1))
;
#line 1515 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        THIS->vt_emask_perl |= emask;
        THIS->vt_select_input ();
#line 2166 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_rstyle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_rstyle)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, new_rstyle= THIS->rstyle");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	U32	RETVAL;
	dXSTARG;
	U32	new_rstyle;

	if (items < 2)
	    new_rstyle = THIS->rstyle;
	else {
	    new_rstyle = (unsigned long)SvUV(ST(1))
;
	}
#line 1521 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->rstyle;
        THIS->rstyle = new_rstyle;
#line 2194 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_view_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_view_start)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, newval= 1");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	newval;

	if (items < 2)
	    newval = 1;
	else {
	    newval = (int)SvIV(ST(1))
;
	}
#line 1530 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        RETVAL = THIS->view_start;

        if (newval <= 0)
          THIS->scr_changeview (max (newval, THIS->top_row));
}
#line 2227 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_set_urgency); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_set_urgency)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, enable");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	enable = (bool)SvTRUE(ST(1))
;

	THIS->set_urgency(enable);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_focus_in); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_focus_in)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;

	THIS->focus_in();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_focus_out); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_focus_out)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;

	THIS->focus_out();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_key_press); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_key_press)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, state, keycode, time= CurrentTime");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	unsigned int	state = (unsigned int)SvUV(ST(1))
;
	unsigned int	keycode = (unsigned int)SvUV(ST(2))
;
	Time	time;

	if (items < 4)
	    time = CurrentTime;
	else {
	    time = (Time)SvUV(ST(3))
;
	}
#line 1553 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        XKeyEvent xkey;

        memset (&xkey, 0, sizeof (xkey));

        xkey.time      = time;
        xkey.state     = state;
        xkey.keycode   = keycode;

        xkey.type      = ix ? KeyRelease : KeyPress;
        xkey.display   = THIS->dpy;
        xkey.window    = THIS->vt;
        xkey.root      = THIS->display->root;
        xkey.subwindow = THIS->vt;

        if (ix)
          THIS->key_release (xkey);
        else
          THIS->key_press (xkey);
}
#line 2327 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_want_refresh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_want_refresh)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1577 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        THIS->want_refresh = 1;
	THIS->refresh_check ();
#line 2345 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_refresh_check); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_refresh_check)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;

	THIS->refresh_check();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_ROW_t); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ROW_t)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 6)
       croak_xs_usage(cv,  "THIS, row_number, new_text= 0, start_col= 0, start_ofs= 0, max_len= MAX_COLS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	row_number = (int)SvIV(ST(1))
;
	SV *	new_text;
	int	start_col;
	int	start_ofs;
	int	max_len;

	if (items < 3)
	    new_text = 0;
	else {
	    new_text = ST(2)
;
	}

	if (items < 4)
	    start_col = 0;
	else {
	    start_col = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    start_ofs = 0;
	else {
	    start_ofs = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    max_len = MAX_COLS;
	else {
	    max_len = (int)SvIV(ST(5))
;
	}
#line 1586 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        if (!IN_RANGE_EXC (row_number, THIS->top_row, THIS->nrow))
          XSRETURN_EMPTY;

        line_t &l = ROW(row_number);

        if (GIMME_V != G_VOID)
          {
            wchar_t *wstr = rxvt_temp_buf<wchar_t> (THIS->ncol);

            for (int col = 0; col < THIS->ncol; col++)
              wstr [col] = l.t [col];

            XPUSHs (sv_2mortal (wcs2sv (wstr, THIS->ncol)));
          }

        if (new_text)
          {
            wchar_t *wstr = sv2wcs (new_text);

            int len = min (wcslen (wstr) - start_ofs, max_len);

            if (start_col < 0 || start_col + len > THIS->ncol)
              {
                free (wstr);
                croak ("new_text extends beyond horizontal margins");
              }

            for (int col = start_col; col < start_col + len; col++)
              {
                l.t [col] = wstr [start_ofs + col - start_col];
                l.r [col] = SET_FONT (l.r [col], THIS->fontset [GET_STYLE (l.r [col])]->find_font (l.t [col]));
              }

            free (wstr);
          }
}
#line 2450 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_ROW_r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ROW_r)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 6)
       croak_xs_usage(cv,  "THIS, row_number, new_rend= 0, start_col= 0, start_ofs= 0, max_len= MAX_COLS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	row_number = (int)SvIV(ST(1))
;
	SV *	new_rend;
	int	start_col;
	int	start_ofs;
	int	max_len;

	if (items < 3)
	    new_rend = 0;
	else {
	    new_rend = ST(2)
;
	}

	if (items < 4)
	    start_col = 0;
	else {
	    start_col = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    start_ofs = 0;
	else {
	    start_ofs = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    max_len = MAX_COLS;
	else {
	    max_len = (int)SvIV(ST(5))
;
	}
#line 1627 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        if (!IN_RANGE_EXC (row_number, THIS->top_row, THIS->nrow))
          XSRETURN_EMPTY;

        line_t &l = ROW(row_number);

        if (GIMME_V != G_VOID)
          {
            AV *av = newAV ();

            av_extend (av, THIS->ncol - 1);
            for (int col = 0; col < THIS->ncol; col++)
              av_store (av, col, newSViv (l.r [col]));

            XPUSHs (sv_2mortal (newRV_noinc ((SV *)av)));
          }

        if (new_rend)
          {
            if (!SvROK (new_rend) || SvTYPE (SvRV (new_rend)) != SVt_PVAV)
              croak ("new_rend must be arrayref");

            AV *av = (AV *)SvRV (new_rend);
            int len = min (AvFILL (av) + 1 - start_ofs, max_len);

            if (start_col < 0 || start_col + len > THIS->ncol)
              croak ("new_rend array extends beyond horizontal margins");

            for (int col = start_col; col < start_col + len; col++)
              {
                rend_t r = SvIV (*av_fetch (av, start_ofs + col - start_col, 1)) & ~RS_fontMask;

                l.r [col] = SET_FONT (r, THIS->fontset [GET_STYLE (r)]->find_font (l.t [col]));
              }
          }
}
#line 2539 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_ROW_l); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ROW_l)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, row_number, new_length= -1");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	row_number = (int)SvIV(ST(1))
;
	int	new_length;

	if (items < 3)
	    new_length = -1;
	else {
	    new_length = (int)SvIV(ST(2))
;
	}
#line 1667 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        if (!IN_RANGE_EXC (row_number, THIS->top_row, THIS->nrow))
          XSRETURN_EMPTY;

        line_t &l = ROW(row_number);
        RETVAL = l.l;

        if (new_length >= 0)
          l.l = new_length;
}
#line 2578 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_ROW_is_longer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_ROW_is_longer)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, row_number, new_is_longer= -1");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	RETVAL;
	int	row_number = (int)SvIV(ST(1))
;
	int	new_is_longer;

	if (items < 3)
	    new_is_longer = -1;
	else {
	    new_is_longer = (int)SvIV(ST(2))
;
	}
#line 1683 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        if (!IN_RANGE_EXC (row_number, THIS->top_row, THIS->nrow))
          XSRETURN_EMPTY;

        line_t &l = ROW(row_number);
        RETVAL = l.is_longer ();

        if (new_is_longer >= 0)
          l.is_longer (new_is_longer);
}
#line 2616 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_special_encode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_special_encode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, string");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
	SV *	string = ST(1)
;
#line 1699 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        wchar_t *wstr = sv2wcs (string);
        int wlen = wcslen (wstr);
        wchar_t *rstr = rxvt_temp_buf<wchar_t> (wlen * 2); // cannot become longer

	rxvt_push_locale (THIS->locale);

        wchar_t *r = rstr;
        for (wchar_t *s = wstr; *s; s++)
          {
            int w = WCWIDTH (*s);

            if (w == 0)
              {
                if (r == rstr)
                  croak ("leading combining character unencodable");

                unicode_t n = rxvt_compose (r[-1], *s);
                if (n == NOCHAR)
                  n = rxvt_composite.compose (r[-1], *s);

                r[-1] = n;
              }
#if !UNICODE_3
            else if (*s >= 0x10000)
              *r++ = rxvt_composite.compose (*s);
#endif
            else
              *r++ = *s;

            // the *2 above only allows wcwidth <= 2
            if (w > 1)
              *r++ = NOCHAR;
          }

	rxvt_pop_locale ();

        free (wstr);
        RETVAL = wcs2sv (rstr, r - rstr);
}
#line 2676 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_special_decode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_special_decode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, text");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
	SV *	text = ST(1)
;
#line 1745 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        wchar_t *wstr = sv2wcs (text);
        int dlen = 0;

        // find length
        for (wchar_t *s = wstr; *s; s++)
          if (*s == NOCHAR)
            ;
          else if (IS_COMPOSE (*s))
            dlen += rxvt_composite.expand (*s, 0);
          else
            dlen++;

        wchar_t *rstr = rxvt_temp_buf<wchar_t> (dlen);

        // decode
        wchar_t *r = rstr;
        for (wchar_t *s = wstr; *s; s++)
          if (*s == NOCHAR)
            ;
          else if (IS_COMPOSE (*s))
            r += rxvt_composite.expand (*s, r);
          else
            *r++ = *s;

        free (wstr);
        RETVAL = wcs2sv (rstr, r - rstr);
}
#line 2725 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term__resource); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term__resource)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, name, index, newval= 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	octet_string        name = SvPVbyte_nolen (ST(1))
;
	int	index = (int)SvIV(ST(2))
;
	SV *	newval;

	if (items < 4)
	    newval = 0;
	else {
	    newval = ST(3)
;
	}
#line 1779 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	static const struct resval { const char *name; int value; } *rs, rslist [] = {
#	  define def(name) { # name, Rs_ ## name },
#	  define reserve(name,count)
#	  include "rsinc.h"
#	  undef def
#	  undef reserve
        };

        rs = rslist + ecb_array_length (rslist);

        if (*name)
          {
            do {
              if (rs-- == rslist)
                croak ("no such resource '%s', requested", name);
            } while (strcmp (name, rs->name));

            index += rs->value;
          }
        else
          {
            --rs;
            name = "";
          }

        if (!IN_RANGE_EXC (index, 0, NUM_RESOURCES))
          croak ("requested out-of-bound resource %s+%d,", name, index - rs->value);

        if (GIMME_V != G_VOID)
          XPUSHs (THIS->rs [index] ? sv_2mortal (newSVpv (THIS->rs [index], 0)) : &PL_sv_undef);

        if (newval)
          {
            if (SvOK (newval))
              {
                char *str = strdup (SvPVbyte_nolen (newval));
                THIS->rs [index] = str;
                THIS->allocated.push_back (str);
              }
            else
              THIS->rs [index] = 0;
          }
}
#line 2801 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_x_resource); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_x_resource)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, name");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	const char *	RETVAL;
	dXSTARG;
	octet_string        name = SvPVbyte_nolen (ST(1))
;

	RETVAL = THIS->x_resource(name);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_option); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_option)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, optval, set= -1");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	RETVAL;
	U8	optval = (U8)SvUV(ST(1))
;
	int	set;

	if (items < 3)
	    set = -1;
	else {
	    set = (int)SvIV(ST(2))
;
	}
#line 1830 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	RETVAL = THIS->option (optval);

        if (set >= 0)
          {
            THIS->set_option (optval, set);

            if (THIS->init_done) // avoid doing this before START
              switch (optval)
                {
                  case Opt_skipBuiltinGlyphs:
                    THIS->set_fonts ();
                    THIS->scr_remap_chars ();
                    THIS->scr_touch (true);
                    THIS->want_refresh = 1;
                    THIS->refresh_check ();
                    break;
#ifdef CURSOR_BLINK
                  case Opt_cursorBlink:
                    THIS->cursor_blink_reset ();
                    break;
#endif

                  case Opt_cursorUnderline:
                    THIS->cursor_type = set ? 1 : 0;
                    THIS->want_refresh = 1;
                    THIS->refresh_check ();
                    break;

                }
          }
}
#line 2882 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_lookup_keysym); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_lookup_keysym)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, keysym, state");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
	int	keysym = (int)SvIV(ST(1))
;
	unsigned int	state = (unsigned int)SvUV(ST(2))
;
#line 1872 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        keysym_t *key = THIS->keyboard->lookup_keysym (THIS, keysym, state);
        RETVAL = key ? sv_2mortal (newSVpv (key->str, 0)) : &PL_sv_undef;
}
#line 2908 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_bind_action); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_bind_action)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, keysym, action");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	RETVAL;
	octet_string        keysym = SvPVbyte_nolen (ST(1))
;
	octet_string        action = SvPVbyte_nolen (ST(2))
;
#line 1884 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = 0 < THIS->bind_action (keysym, action);
        THIS->keyboard->register_done ();
#line 2934 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_register_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_register_command)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, keysym, state, str");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	keysym = (int)SvIV(ST(1))
;
	unsigned int	state = (unsigned int)SvUV(ST(2))
;
	SV *	str = ST(3)
;
#line 1892 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        wchar_t *wstr = sv2wcs (str);
        THIS->keyboard->register_action (keysym, state, wstr);
        free (wstr);
#line 2960 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_screen_cur); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_screen_cur)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "THIS, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
#line 1905 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        row_col_t &rc = ix == 0 ? THIS->screen.cur
                      : ix == 1 ? THIS->selection.beg
                      : ix == 2 ? THIS->selection.end
                      :           THIS->selection.mark;

        if (GIMME_V != G_VOID)
          {
            EXTEND (SP, 2);
            PUSHs (sv_2mortal (newSViv (rc.row)));
            PUSHs (sv_2mortal (newSViv (rc.col)));
          }

        if (items >= 3)
          {
            rc.row = SvIV (ST (1));
            rc.col = SvIV (ST (2));

            if (ix == 2)
              {
                if (rc.col == 0)
                  {
                    // col == 0 means end of previous line
                    rc.row--;
                    rc.col = THIS->ncol;
                  }
                else if (IN_RANGE_EXC (rc.row, THIS->top_row, THIS->nrow)
                         && rc.col > ROW(rc.row).l)
                  {
                    // col >= length means while line and add newline
                    rc.col = THIS->ncol;
                  }
              }

            clamp_it (rc.col, 0, THIS->ncol);
            clamp_it (rc.row, THIS->top_row, THIS->nrow - 1);

            if (ix)
              {
                THIS->selection.screen = THIS->current_screen;

                THIS->selection_changed ();
                THIS->refresh_check ();
              }
          }
}
#line 3025 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_selection_screen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_selection_screen)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, screen= -1");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	int	screen;

	if (items < 2)
	    screen = -1;
	else {
	    screen = (int)SvIV(ST(1))
;
	}
#line 1955 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->selection.screen;
        if (screen >= 0)
          THIS->selection.screen = screen;
#line 3055 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_selection_request); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_selection_request)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, tm, selnum");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Time	tm = (Time)SvUV(ST(1))
;
	int	selnum = (int)SvIV(ST(2))
;

	THIS->selection_request(tm, selnum);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_selection_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_selection_clear)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, clipboard= false");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	clipboard;

	if (items < 2)
	    clipboard = false;
	else {
	    clipboard = (bool)SvTRUE(ST(1))
;
	}

	THIS->selection_clear(clipboard);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_selection_make); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_selection_make)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, eventtime, rect= false");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Time	eventtime = (Time)SvUV(ST(1))
;
	bool	rect;

	if (items < 3)
	    rect = false;
	else {
	    rect = (bool)SvTRUE(ST(2))
;
	}
#line 1970 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        THIS->selection.op = SELECTION_CONT;
        THIS->selection.rect = rect;
        THIS->selection_make (eventtime);
#line 3129 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_selection_grab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_selection_grab)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, eventtime, clipboard= false");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	RETVAL;
	dXSTARG;
	Time	eventtime = (Time)SvUV(ST(1))
;
	bool	clipboard;

	if (items < 3)
	    clipboard = false;
	else {
	    clipboard = (bool)SvTRUE(ST(2))
;
	}

	RETVAL = THIS->selection_grab(eventtime, clipboard);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_selection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_selection)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, newtext= 0, clipboard= false");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	newtext;
	bool	clipboard;

	if (items < 2)
	    newtext = 0;
	else {
	    newtext = ST(1)
;
	}

	if (items < 3)
	    clipboard = false;
	else {
	    clipboard = (bool)SvTRUE(ST(2))
;
	}
#line 1980 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        wchar_t * &text   = clipboard ? THIS->selection.clip_text : THIS->selection.text;
        unsigned int &len = clipboard ? THIS->selection.clip_len  : THIS->selection.len;

        if (GIMME_V != G_VOID)
          XPUSHs (text
                  ? sv_2mortal (wcs2sv (text, len))
                  : &PL_sv_undef);

        if (newtext)
          {
            free (text);

            text = sv2wcs (newtext);
            len = wcslen (text);
          }
}
#line 3209 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_cur_charset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_cur_charset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	char	RETVAL;
	dXSTARG;
#line 2001 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->charsets [THIS->screen.charset];
#line 3229 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHp((char *)&RETVAL, 1);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_scr_xor_rect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_scr_xor_rect)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 7)
       croak_xs_usage(cv,  "THIS, beg_row, beg_col, end_row, end_col, rstyle1= RS_RVid, rstyle2= RS_RVid | RS_Uline");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	beg_row = (int)SvIV(ST(1))
;
	int	beg_col = (int)SvIV(ST(2))
;
	int	end_row = (int)SvIV(ST(3))
;
	int	end_col = (int)SvIV(ST(4))
;
	U32	rstyle1;
	U32	rstyle2;

	if (items < 6)
	    rstyle1 = RS_RVid;
	else {
	    rstyle1 = (unsigned long)SvUV(ST(5))
;
	}

	if (items < 7)
	    rstyle2 = RS_RVid | RS_Uline;
	else {
	    rstyle2 = (unsigned long)SvUV(ST(6))
;
	}

	THIS->scr_xor_rect(beg_row, beg_col, end_row, end_col, rstyle1, rstyle2);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_scr_xor_span); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_scr_xor_span)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 6)
       croak_xs_usage(cv,  "THIS, beg_row, beg_col, end_row, end_col, rstyle= RS_RVid");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	beg_row = (int)SvIV(ST(1))
;
	int	beg_col = (int)SvIV(ST(2))
;
	int	end_row = (int)SvIV(ST(3))
;
	int	end_col = (int)SvIV(ST(4))
;
	U32	rstyle;

	if (items < 6)
	    rstyle = RS_RVid;
	else {
	    rstyle = (unsigned long)SvUV(ST(5))
;
	}

	THIS->scr_xor_span(beg_row, beg_col, end_row, end_col, rstyle);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_scr_bell); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_scr_bell)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;

	THIS->scr_bell();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_scr_recolor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_scr_recolor)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, refresh= true");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	refresh;

	if (items < 2)
	    refresh = true;
	else {
	    refresh = (bool)SvTRUE(ST(1))
;
	}

	THIS->scr_recolor(refresh);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_scr_change_screen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_scr_change_screen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, screen");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	int	screen = (int)SvIV(ST(1))
;

	THIS->scr_change_screen(screen);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_scr_add_lines); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_scr_add_lines)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, string");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	string = ST(1)
;
#line 2023 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        wchar_t *wstr = sv2wcs (string);
        THIS->scr_add_lines (wstr, wcslen (wstr));
        free (wstr);
}
#line 3383 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_tt_write_user_input); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_tt_write_user_input)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, octets");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	octets = ST(1)
;
#line 2032 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
          STRLEN len;
          char *str = SvPVbyte (octets, len);
#line 3403 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

	THIS->tt_write_user_input(str, len);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_tt_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_tt_write)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, octets");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	octets = ST(1)
;
#line 2040 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
          STRLEN len;
          char *str = SvPVbyte (octets, len);
#line 3425 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

	THIS->tt_write(str, len);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_tt_paste); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_tt_paste)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, octets");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	octets = ST(1)
;
#line 2048 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        STRLEN len;
        char *str = SvPVbyte (octets, len);
#line 3447 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

	THIS->tt_paste(str, len);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_cmd_parse); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_cmd_parse)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, octets");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	octets = ST(1)
;
#line 2056 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	STRLEN len;
        char *str = SvPVbyte (octets, len);

        char *old_cmdbuf_ptr  = THIS->cmdbuf_ptr;
        char *old_cmdbuf_endp = THIS->cmdbuf_endp;

        THIS->cmdbuf_ptr  = str;
        THIS->cmdbuf_endp = str + len;

	rxvt_push_locale (THIS->locale);
        THIS->cmd_parse ();
	rxvt_pop_locale ();

        THIS->cmdbuf_ptr  = old_cmdbuf_ptr;
        THIS->cmdbuf_endp = old_cmdbuf_endp;
}
#line 3484 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_overlay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_overlay)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 7)
       croak_xs_usage(cv,  "THIS, x, y, w, h, rstyle= OVERLAY_RSTYLE, border= 2");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	SV *	RETVAL;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	int	w = (int)SvIV(ST(3))
;
	int	h = (int)SvIV(ST(4))
;
	int	rstyle;
	int	border;

	if (items < 6)
	    rstyle = OVERLAY_RSTYLE;
	else {
	    rstyle = (int)SvIV(ST(5))
;
	}

	if (items < 7)
	    border = 2;
	else {
	    border = (int)SvIV(ST(6))
;
	}
#line 2077 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        overlay *o = new overlay (THIS, x, y, w, h, rstyle, border);
        RETVAL = newSVptr ((void *)o, "urxvt::overlay");
        o->self = (HV *)SvRV (RETVAL);
}
#line 3530 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XListProperties); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XListProperties)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, window");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
#line 2092 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	int count;
	Atom *props = XListProperties (THIS->dpy, window, &count);

        EXTEND (SP, count);
        while (count--)
          PUSHs (newSVuv ((U32)props [count]));

        XFree (props);
}
#line 3562 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_XGetWindowProperty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XGetWindowProperty)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, window, property");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
	Atom	property = (Atom)SvUV(ST(2))
;
#line 2106 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        Atom type;
        int format;
        unsigned long nitems;
        unsigned long bytes_after;
        unsigned char *prop;

	XGetWindowProperty (THIS->dpy, window, property,
                            0, 1<<24, 0, AnyPropertyType,
                            &type, &format, &nitems, &bytes_after, &prop);

        if (type != None)
          {
            int elemsize = format == 16 ? sizeof (short)
                         : format == 32 ? sizeof (long)
                         :                1;

            EXTEND (SP, 3);
            PUSHs (newSVuv ((U32)type));
            PUSHs (newSViv (format));
            PUSHs (newSVpvn ((char *)prop, nitems * elemsize));
            XFree (prop);
          }
}
#line 3609 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_XChangeProperty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XChangeProperty)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "THIS, window, property, type, format, data");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
	Atom	property = (Atom)SvUV(ST(2))
;
	Atom	type = (Atom)SvUV(ST(3))
;
	int	format = (int)SvIV(ST(4))
;
	SV *	data = ST(5)
;
#line 2134 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	STRLEN len;
        char *data_ = SvPVbyte (data, len);

        int elemsize = format == 16 ? sizeof (short)
                     : format == 32 ? sizeof (long)
                     :                1;

	XChangeProperty (THIS->dpy, window, property,
                         type, format, PropModeReplace,
                         (unsigned char *)data_, len / elemsize);
}
#line 3648 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XInternAtom); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XInternAtom)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "term, atom_name, only_if_exists= FALSE");
    {
	Atom	RETVAL;
	dXSTARG;
	rxvt_term *	term = SvTERM (ST(0))
;
	octet_string        atom_name = SvPVbyte_nolen (ST(1))
;
	int	only_if_exists;

	if (items < 3)
	    only_if_exists = FALSE;
	else {
	    only_if_exists = (int)SvIV(ST(2))
;
	}

	RETVAL = XInternAtom(term->dpy, atom_name, only_if_exists);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XGetAtomName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XGetAtomName)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "term, atom");
    {
	char *	RETVAL;
	dXSTARG;
	rxvt_term *	term = SvTERM (ST(0))
;
	Atom	atom = (Atom)SvUV(ST(1))
;

	RETVAL = XGetAtomName(term->dpy, atom);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
#line 2155 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XFree (RETVAL);
#line 3701 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_XDeleteProperty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XDeleteProperty)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "term, window, property");
    {
	rxvt_term *	term = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
	Atom	property = (Atom)SvUV(ST(2))
;

	XDeleteProperty(term->dpy, window, property);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_DefaultRootWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_DefaultRootWindow)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	RETVAL;
	dXSTARG;
#line 2164 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->display->root;
#line 3740 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#if 0
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_urxvt__term_XCreateSimpleWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XCreateSimpleWindow)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "term, parent, x, y, width, height");
    {
	Window	RETVAL;
	dXSTARG;
	rxvt_term *	term = SvTERM (ST(0))
;
	Window	parent = (Window)SvUV(ST(1))
;
	int	x = (int)SvIV(ST(2))
;
	int	y = (int)SvIV(ST(3))
;
	unsigned int	width = (unsigned int)SvUV(ST(4))
;
	unsigned int	height = (unsigned int)SvUV(ST(5))
;

	RETVAL = XCreateSimpleWindow(term->dpy, (Window)parent,
                x, y, width, height, 0,
                term->pix_colors_focused[Color_border],
                term->pix_colors_focused[Color_border]);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_urxvt__term_XReparentWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XReparentWindow)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "term, window, parent, x= 0, y= 0");
    {
	rxvt_term *	term = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
	Window	parent = (Window)SvUV(ST(2))
;
	int	x;
	int	y;

	if (items < 4)
	    x = 0;
	else {
	    x = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    y = 0;
	else {
	    y = (int)SvIV(ST(4))
;
	}

	XReparentWindow(term->dpy, window, parent, x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XMapWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XMapWindow)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "term, window");
    {
	rxvt_term *	term = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;

	XMapWindow(term->dpy, window);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XUnmapWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XUnmapWindow)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "term, window");
    {
	rxvt_term *	term = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;

	XUnmapWindow(term->dpy, window);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XMoveResizeWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XMoveResizeWindow)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "term, window, x, y, width, height");
    {
	rxvt_term *	term = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
	int	x = (int)SvIV(ST(2))
;
	int	y = (int)SvIV(ST(3))
;
	unsigned int	width = (unsigned int)SvUV(ST(4))
;
	unsigned int	height = (unsigned int)SvUV(ST(5))
;

	XMoveResizeWindow(term->dpy, window, x, y, width, height);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XChangeInput); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XChangeInput)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, window, add_events, del_events= 0");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	window = (Window)SvUV(ST(1))
;
	U32	add_events = (unsigned long)SvUV(ST(2))
;
	U32	del_events;

	if (items < 4)
	    del_events = 0;
	else {
	    del_events = (unsigned long)SvUV(ST(3))
;
	}
#line 2198 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
	XWindowAttributes attr;
        XGetWindowAttributes (THIS->dpy, window, &attr);
        XSelectInput (THIS->dpy, window, attr.your_event_mask | add_events & ~del_events);
}
#line 3908 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__term_XTranslateCoordinates); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_XTranslateCoordinates)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "THIS, src, dst, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	Window	src = (Window)SvUV(ST(1))
;
	Window	dst = (Window)SvUV(ST(2))
;
	int	x = (int)SvIV(ST(3))
;
	int	y = (int)SvIV(ST(4))
;
#line 2207 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
        int dx, dy;
        Window child;

        if (XTranslateCoordinates (THIS->dpy, src, dst, x, y, &dx, &dy, &child))
          {
            EXTEND (SP, 3);
            PUSHs (newSViv (dx));
            PUSHs (newSViv (dy));
            PUSHs (newSVuv (child));
          }
}
#line 3946 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__term_has_render); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_has_render)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	RETVAL;
#line 2226 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->display->flags & DISPLAY_HAS_RENDER;
#line 3965 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__term_background_geometry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_background_geometry)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, border= false");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	bool	border;

	if (items < 2)
	    border = false;
	else {
	    border = (bool)SvTRUE(ST(1))
;
	}
#line 2233 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
	EXTEND (SP, 4);
        PUSHs (sv_2mortal (newSViv (THIS->parent_x + (border ? THIS->window_vt_x : 0))));
        PUSHs (sv_2mortal (newSViv (THIS->parent_y + (border ? THIS->window_vt_y : 0))));
        PUSHs (sv_2mortal (newSViv (border ? THIS->vt_width  : THIS->szHint.width )));
        PUSHs (sv_2mortal (newSViv (border ? THIS->vt_height : THIS->szHint.height)));
#line 3997 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}

#if HAVE_IMG
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_urxvt__term_new_img); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_new_img)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 6)
       croak_xs_usage(cv,  "THIS, format= &PL_sv_undef, x= 0, y= 0, width= 1, height= 1");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	rxvt_img *	RETVAL;
	SV *	format;
	int	x;
	int	y;
	int	width;
	int	height;

	if (items < 2)
	    format = &PL_sv_undef;
	else {
	    format = ST(1)
;
	}

	if (items < 3)
	    x = 0;
	else {
	    x = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    y = 0;
	else {
	    y = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    width = 1;
	else {
	    width = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    height = 1;
	else {
	    height = (int)SvIV(ST(5))
;
	}
#line 2244 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        XRenderPictFormat *f = SvOK (format)
                             ? XRenderFindStandardFormat (THIS->dpy, SvIV (format))
                             : XRenderFindVisualFormat   (THIS->dpy, THIS->visual);
        RETVAL = new rxvt_img (THIS, f, x, y, width, height);
        RETVAL->alloc ();
#line 4063 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if ENABLE_TRANSPARENCY
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_urxvt__term_new_img_from_root); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_new_img_from_root)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	rxvt_img *	RETVAL;
#line 2257 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = rxvt_img::new_from_root (THIS);
#line 4090 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#if HAVE_PIXBUF
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_urxvt__term_new_img_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_new_img_from_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, filename");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	rxvt_img *	RETVAL;
	octet_string        filename = SvPVbyte_nolen (ST(1))
;
#line 2268 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        try
          {
            RETVAL = rxvt_img::new_from_file (THIS, filename);
          }
        catch (const class rxvt_failure_exception &e)
          {
            croak ("new_img_from_file failed");
          }
#line 4127 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_urxvt__term_set_background); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__term_set_background)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, img, border= false");
    {
	rxvt_term *	THIS = SvTERM (ST(0))
;
	rxvt_img *	img;
	bool	border;

        if (SvROK (ST(1)) && sv_derived_from (ST(1), "urxvt::img"))
          img = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(1))));
        else
          croak ("%s is not of type urxvt::img", "img")
;

	if (items < 3)
	    border = false;
	else {
	    border = (bool)SvTRUE(ST(2))
;
	}
#line 2284 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        delete THIS->bg_img;
        THIS->bg_img = 0;
        THIS->bg_flags = 0;

        if (img) // TODO: cannot be false
          {
            img = img->clone (); // own the img

            if (img->repeat != RepeatNormal) // X11 only supports RepeatNormal as bg pixmap
              img->sub_rect (0, 0,
                             border ? THIS->vt_width  : THIS->szHint.width,
                             border ? THIS->vt_height : THIS->szHint.height)
                 ->replace (img);

            // just in case, should usually be a nop
            img->reify ()
               ->replace (img);

            img->convert_format (XRenderFindVisualFormat (THIS->dpy, THIS->visual), THIS->pix_colors [Color_bg])
               ->replace (img);

            THIS->bg_img = img;
            THIS->bg_flags |= rxvt_term::BG_NEEDS_REFRESH | rxvt_term::BG_INHIBIT_RENDER;

            if (!border)
              THIS->bg_flags |= rxvt_term::BG_IS_TRANSPARENT;
          }
#line 4192 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_urxvt__overlay_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__overlay_set)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "THIS, x, y, text, rend= 0");
    {
	overlay *	THIS = SvOVERLAY (ST(0))
;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	SV *	text = ST(3)
;
	SV *	rend;

	if (items < 5)
	    rend = 0;
	else {
	    rend = ST(4)
;
	}

	THIS->set(x, y, text, rend);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__overlay_show); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__overlay_show)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	overlay *	THIS = SvOVERLAY (ST(0))
;

	THIS->show();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__overlay_hide); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__overlay_hide)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	overlay *	THIS = SvOVERLAY (ST(0))
;

	THIS->hide();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__overlay_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__overlay_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	overlay *	THIS = SvOVERLAY (ST(0))
;

	delete THIS;
    }
    XSRETURN_EMPTY;
}


/* INCLUDE:  Including '$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |' from 'rxvtperl.xs' */


XS_EUPXS(XS_urxvt__watcher_cb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__watcher_cb)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, cb");
    {
	perl_watcher *	THIS = SvWATCHER (ST(0))
;
	IOM_CHAINED	RETVAL;
	SV *	cb = ST(1)
;
#line 45 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->cb (cb);
#line 4294 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	SV *	RETVAL;
#line 58 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        timer *w =  new timer;
        w->start (0);
        RETVAL = newSVptr ((void *)(perl_watcher *)w, "urxvt::timer");
        w->self = (HV *)SvRV (RETVAL);
#line 4321 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_at); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_at)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	timer *	THIS = SvTIMER (ST(0))
;
	NV	RETVAL;
	dXSTARG;
#line 69 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        RETVAL = THIS->remaining () + ev_now ();
#line 4342 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_interval); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_interval)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, repeat");
    {
	timer *	THIS = SvTIMER (ST(0))
;
	IOM_CHAINED	RETVAL;
	NV	repeat = (NV)SvNV(ST(1))
;
#line 76 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->repeat = repeat;
#line 4363 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_set)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, tstamp, repeat= THIS->repeat");
    {
	timer *	THIS = SvTIMER (ST(0))
;
	IOM_CHAINED	RETVAL;
	NV	tstamp = (NV)SvNV(ST(1))
;
	NV	repeat;

	if (items < 3)
	    repeat = THIS->repeat;
	else {
	    repeat = (NV)SvNV(ST(2))
;
	}
#line 83 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->set (tstamp, repeat);
#line 4397 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_start)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, tstamp= ev::now (), repeat= THIS->repeat");
    {
	timer *	THIS = SvTIMER (ST(0))
;
	IOM_CHAINED	RETVAL;
	NV	tstamp;
	NV	repeat;

	if (items < 2)
	    tstamp = ev::now ();
	else {
	    tstamp = (NV)SvNV(ST(1))
;
	}

	if (items < 3)
	    repeat = THIS->repeat;
	else {
	    repeat = (NV)SvNV(ST(2))
;
	}
#line 90 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->start (tstamp - ev::now (), repeat);
#line 4437 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_after); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_after)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, delay, repeat= THIS->repeat");
    {
	timer *	THIS = SvTIMER (ST(0))
;
	IOM_CHAINED	RETVAL;
	NV	delay = (NV)SvNV(ST(1))
;
	NV	repeat;

	if (items < 3)
	    repeat = THIS->repeat;
	else {
	    repeat = (NV)SvNV(ST(2))
;
	}
#line 97 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->start (delay, repeat);
#line 4471 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	timer *	THIS = SvTIMER (ST(0))
;
	IOM_CHAINED	RETVAL;
#line 104 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->stop ();
#line 4495 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__timer_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__timer_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	timer *	THIS = SvTIMER (ST(0))
;

	delete THIS;
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__iow_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iow_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	SV *	RETVAL;
#line 120 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        iow *w =  new iow;
        RETVAL = newSVptr ((void *)(perl_watcher *)w, "urxvt::iow");
        w->self = (HV *)SvRV (RETVAL);
#line 4537 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iow_fd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iow_fd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, fd");
    {
	iow *	THIS = SvIOW (ST(0))
;
	IOM_CHAINED	RETVAL;
	int	fd = (int)SvIV(ST(1))
;
#line 129 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->fd = fd;
#line 4559 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iow_events); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iow_events)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, events");
    {
	iow *	THIS = SvIOW (ST(0))
;
	IOM_CHAINED	RETVAL;
	short	events = (short)SvIV(ST(1))
;
#line 136 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->events = events;
#line 4585 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iow_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iow_start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	iow *	THIS = SvIOW (ST(0))
;
	IOM_CHAINED	RETVAL;
#line 143 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->start ();
#line 4609 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iow_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iow_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	iow *	THIS = SvIOW (ST(0))
;
	IOM_CHAINED	RETVAL;
#line 150 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->stop ();
#line 4633 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iow_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iow_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	iow *	THIS = SvIOW (ST(0))
;

	delete THIS;
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__iw_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iw_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	SV *	RETVAL;
#line 166 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        iw *w =  new iw;
        RETVAL = newSVptr ((void *)(perl_watcher *)w, "urxvt::iw");
        w->self = (HV *)SvRV (RETVAL);
#line 4675 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iw_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iw_start)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	iw *	THIS = SvIW (ST(0))
;
	IOM_CHAINED	RETVAL;
#line 175 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->start ();
#line 4695 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iw_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iw_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	iw *	THIS = SvIW (ST(0))
;
	IOM_CHAINED	RETVAL;
#line 182 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->stop ();
#line 4719 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__iw_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__iw_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	iw *	THIS = SvIW (ST(0))
;

	delete THIS;
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__pw_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pw_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	SV *	RETVAL;
#line 198 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        pw *w =  new pw;
        RETVAL = newSVptr ((void *)(perl_watcher *)w, "urxvt::pw");
        w->self = (HV *)SvRV (RETVAL);
#line 4761 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__pw_start); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pw_start)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, pid");
    {
	pw *	THIS = SvPW (ST(0))
;
	IOM_CHAINED	RETVAL;
	int	pid = (int)SvIV(ST(1))
;
#line 207 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->start (pid);
#line 4783 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__pw_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pw_stop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	pw *	THIS = SvPW (ST(0))
;
	IOM_CHAINED	RETVAL;
#line 214 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        THIS->stop ();
#line 4807 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVsv (ST(0));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__pw_rpid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pw_rpid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	pw *	THIS = SvPW (ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 221 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        RETVAL = THIS->rpid;
#line 4832 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__pw_rstatus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pw_rstatus)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	pw *	THIS = SvPW (ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 228 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
        RETVAL = THIS->rstatus;
#line 4852 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__pw_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pw_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	pw *	THIS = SvPW (ST(0))
;

	delete THIS;
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'rxvtperl.xs' from '$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |' */

#if HAVE_PIXBUF
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_urxvt__pixbuf_new_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pixbuf_new_from_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "klass, filename");
    {
	urxvt__pixbuf	RETVAL;
	SV *	klass = ST(0)
;
	octet_string        filename = SvPVbyte_nolen (ST(1))
;

	RETVAL = gdk_pixbuf_new_from_file(filename, 0);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "urxvt::pixbuf", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__pixbuf_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__pixbuf_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	urxvt__pixbuf	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(urxvt__pixbuf,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"urxvt::pixbuf::DESTROY",
			"self")
;
#line 2344 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        g_object_unref (self);
#line 4926 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if HAVE_IMG
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_urxvt__img_geometry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_geometry)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_img *	THIS;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;
#line 2358 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        EXTEND (SP, 4);
        PUSHs (sv_2mortal (newSViv (THIS->x)));
        PUSHs (sv_2mortal (newSViv (THIS->y)));
        PUSHs (sv_2mortal (newSViv (THIS->w)));
        PUSHs (sv_2mortal (newSViv (THIS->h)));
#line 4958 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__img_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_x)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;
	int	RETVAL;
	dXSTARG;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;
#line 2372 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        switch (ix)
          {
            case 0: RETVAL = THIS->x; break;
            case 1: RETVAL = THIS->y; break;
            case 2: RETVAL = THIS->w; break;
            case 3: RETVAL = THIS->h; break;
          }
#line 4990 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_pm); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_pm)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;
	Pixmap	RETVAL;
	dXSTARG;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;
#line 2385 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        RETVAL = THIS->pm;
#line 5015 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_fill); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_fill)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 6)
       croak_xs_usage(cv,  "THIS, c, x= 0, y= 0, w= THIS->w, h= THIS->h");
    {
	rxvt_img *	THIS;
	SV *	c = ST(1)
;
	int	x;
	int	y;
	int	w;
	int	h;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	if (items < 3)
	    x = 0;
	else {
	    x = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    y = 0;
	else {
	    y = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    w = THIS->w;
	else {
	    w = (int)SvIV(ST(4))
;
	}

	if (items < 6)
	    h = THIS->h;
	else {
	    h = (int)SvIV(ST(5))
;
	}
#line 2393 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rgba cc = parse_rgba (c, THIS->s);
#line 5072 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

	THIS->fill(cc, x, y, w, h);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;
#line 2399 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        delete THIS;
#line 5096 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_add_alpha); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_add_alpha)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	THIS->add_alpha();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_unshare); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_unshare)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	THIS->unshare();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_repeat_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_repeat_mode)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, repeat= 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rxvt_img *	THIS;
	render_repeat_mode	repeat;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	if (items < 2)
	    repeat = 0;
	else {
	    if (SvOK (ST(1)))
	  {
		repeat = SvIV (ST(1));
	    if (repeat != RepeatNone && repeat != RepeatNormal && repeat != RepeatPad && repeat != RepeatReflect)
	      croak ("invalid repeat mode specified (%d)\n", repeat);
	  }
	else
	  repeat = RepeatNormal
;
	}
#line 2410 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        if (items >= 2)
          THIS->repeat_mode (repeat);
        if (GIMME_V != G_VOID)
          XPUSHs (sv_2mortal (newSViv (THIS->repeat)));
#line 5180 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_urxvt__img_move); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_move)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, dx, dy");
    {
	rxvt_img *	THIS;
	int	dx = (int)SvIV(ST(1))
;
	int	dy = (int)SvIV(ST(2))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	THIS->move(dx, dy);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_brightness); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_brightness)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "THIS, r, g, b, a= 1.");
    {
	rxvt_img *	THIS;
	rxvt_img__nv	r = (rxvt_img__nv)SvNV(ST(1))
;
	rxvt_img__nv	g = (rxvt_img__nv)SvNV(ST(2))
;
	rxvt_img__nv	b = (rxvt_img__nv)SvNV(ST(3))
;
	rxvt_img__nv	a;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	if (items < 5)
	    a = 1.;
	else {
	    a = (rxvt_img__nv)SvNV(ST(4))
;
	}

	THIS->brightness(r, g, b, a);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_contrast); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_contrast)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "THIS, r, g, b, a= 1.");
    {
	rxvt_img *	THIS;
	rxvt_img__nv	r = (rxvt_img__nv)SvNV(ST(1))
;
	rxvt_img__nv	g = (rxvt_img__nv)SvNV(ST(2))
;
	rxvt_img__nv	b = (rxvt_img__nv)SvNV(ST(3))
;
	rxvt_img__nv	a;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	if (items < 5)
	    a = 1.;
	else {
	    a = (rxvt_img__nv)SvNV(ST(4))
;
	}

	THIS->contrast(r, g, b, a);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_draw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_draw)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "THIS, img, op= PictOpOver, mask= 1.");
    {
	rxvt_img *	THIS;
	rxvt_img *	img;
	int	op;
	rxvt_img__nv	mask;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

        if (SvROK (ST(1)) && sv_derived_from (ST(1), "urxvt::img"))
          img = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(1))));
        else
          croak ("%s is not of type urxvt::img", "img")
;

	if (items < 3)
	    op = PictOpOver;
	else {
	    op = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    mask = 1.;
	else {
	    mask = (rxvt_img__nv)SvNV(ST(3))
;
	}

	THIS->draw(img, op, mask);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_urxvt__img_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->clone();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_reify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_reify)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->reify();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_sub_rect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_sub_rect)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "THIS, x, y, width, height");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->sub_rect(x, y, width, height);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_blur); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_blur)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, rh, rv");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	int	rh = (int)SvIV(ST(1))
;
	int	rv = (int)SvIV(ST(2))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->blur(rh, rv);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_muladd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_muladd)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, mul, add");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	rxvt_img__nv	mul = (rxvt_img__nv)SvNV(ST(1))
;
	rxvt_img__nv	add = (rxvt_img__nv)SvNV(ST(2))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->muladd(mul, add);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_transform); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_transform)
{
    dVAR; dXSARGS;
    if (items != 10)
       croak_xs_usage(cv,  "THIS, p11, p12, p13, p21, p22, p23, p31, p32, p33");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	rxvt_img__nv	p11 = (rxvt_img__nv)SvNV(ST(1))
;
	rxvt_img__nv	p12 = (rxvt_img__nv)SvNV(ST(2))
;
	rxvt_img__nv	p13 = (rxvt_img__nv)SvNV(ST(3))
;
	rxvt_img__nv	p21 = (rxvt_img__nv)SvNV(ST(4))
;
	rxvt_img__nv	p22 = (rxvt_img__nv)SvNV(ST(5))
;
	rxvt_img__nv	p23 = (rxvt_img__nv)SvNV(ST(6))
;
	rxvt_img__nv	p31 = (rxvt_img__nv)SvNV(ST(7))
;
	rxvt_img__nv	p32 = (rxvt_img__nv)SvNV(ST(8))
;
	rxvt_img__nv	p33 = (rxvt_img__nv)SvNV(ST(9))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;
#line 2445 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_img::nv matrix[3][3] = {
          { p11, p12, p13 },
          { p21, p22, p23 },
          { p31, p32, p33 }
        };
#line 5521 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

	RETVAL = THIS->transform(matrix);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_scale); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_scale)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "THIS, new_width, new_height");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	int	new_width = (int)SvIV(ST(1))
;
	int	new_height = (int)SvIV(ST(2))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->scale(new_width, new_height);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_rotate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_rotate)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, x, y, phi");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	rxvt_img__nv	phi = (rxvt_img__nv)SvNV(ST(3))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->rotate(x, y, phi);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_tint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_tint)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, c");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	SV *	c = ST(1)
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;
#line 2461 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rgba cc = parse_rgba (c, THIS->s);
#line 5620 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

	RETVAL = THIS->tint(cc);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_shade); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_shade)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, factor");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	rxvt_img__nv	factor = (rxvt_img__nv)SvNV(ST(1))
;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	RETVAL = THIS->shade(factor);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_urxvt__img_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_urxvt__img_filter)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, name, params= &PL_sv_undef");
    {
	rxvt_img *	THIS;
	rxvt_img *	RETVAL;
	octet_string        name = SvPVbyte_nolen (ST(1))
;
	SV *	params;

        if (SvROK (ST(0)) && sv_derived_from (ST(0), "urxvt::img"))
          THIS = INT2PTR (rxvt_img *, SvIV ((SV *) SvRV (ST(0))));
        else
          croak ("%s is not of type urxvt::img", "THIS")
;

	if (items < 3)
	    params = &PL_sv_undef;
	else {
	    params = ST(2)
;
	}
#line 2470 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
        rxvt_img::nv *vparams = 0;
        int nparams = 0;

        if (SvOK (params))
	  {
            if (!SvROK (params) || SvTYPE (SvRV (params)) != SVt_PVAV)
              croak ("rxvt_img::filter: params must be an array reference with parameter values");

            nparams = av_len ((AV *)SvRV (params)) + 1;
            vparams = (rxvt_img::nv *)malloc (nparams * sizeof (rxvt_img::nv));

            for (int i = 0; i < nparams; ++i)
              vparams [i] = SvNV (*av_fetch ((AV *)SvRV (params), i, 1));
          }

        RETVAL = THIS->filter (name, nparams, vparams);
        free (vparams);
#line 5707 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "urxvt::img", (void *)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_urxvt); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_urxvt)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("urxvt::log", XS_urxvt_log, file, "$");
        (void)newXSproto_portable("urxvt::warn", XS_urxvt_warn, file, "$");
        (void)newXSproto_portable("urxvt::fatal", XS_urxvt_fatal, file, "$");
        (void)newXSproto_portable("urxvt::_exit", XS_urxvt__exit, file, "$");
        (void)newXSproto_portable("urxvt::catch_fatal", XS_urxvt_catch_fatal, file, "&");
        (void)newXSproto_portable("urxvt::NOW", XS_urxvt_NOW, file, "");
        (void)newXSproto_portable("urxvt::GET_BASEFG", XS_urxvt_GET_BASEFG, file, "$");
        (void)newXSproto_portable("urxvt::GET_BASEBG", XS_urxvt_GET_BASEBG, file, "$");
        (void)newXSproto_portable("urxvt::SET_FGCOLOR", XS_urxvt_SET_FGCOLOR, file, "$$");
        (void)newXSproto_portable("urxvt::SET_BGCOLOR", XS_urxvt_SET_BGCOLOR, file, "$$");
        (void)newXSproto_portable("urxvt::GET_CUSTOM", XS_urxvt_GET_CUSTOM, file, "$");
        (void)newXSproto_portable("urxvt::SET_CUSTOM", XS_urxvt_SET_CUSTOM, file, "$$");
        (void)newXSproto_portable("urxvt::termlist", XS_urxvt_termlist, file, "");
        (void)newXSproto_portable("urxvt::_new_selection_request", XS_urxvt__new_selection_request, file, "$$$$$$");
        (void)newXSproto_portable("urxvt::_delete_selection_request", XS_urxvt__delete_selection_request, file, "$");
        (void)newXSproto_portable("urxvt::term::_new", XS_urxvt__term__new, file, "$$");
        (void)newXSproto_portable("urxvt::term::destroy", XS_urxvt__term_destroy, file, "$");
        (void)newXSproto_portable("urxvt::term::set_should_invoke", XS_urxvt__term_set_should_invoke, file, "$$$");
        (void)newXSproto_portable("urxvt::term::put_option_db", XS_urxvt__term_put_option_db, file, "$$$");
        (void)newXSproto_portable("urxvt::term::_keysym_resources", XS_urxvt__term__keysym_resources, file, "$");
        (void)newXSproto_portable("urxvt::term::grab_button", XS_urxvt__term_grab_button, file, "$$$;$");
        (void)newXSproto_portable("urxvt::term::ungrab_button", XS_urxvt__term_ungrab_button, file, "$$$;$");
        (void)newXSproto_portable("urxvt::term::XGrabKey", XS_urxvt__term_XGrabKey, file, "$$$;$$$$");
        (void)newXSproto_portable("urxvt::term::XUngrabKey", XS_urxvt__term_XUngrabKey, file, "$$$;$");
        (void)newXSproto_portable("urxvt::term::grab", XS_urxvt__term_grab, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::allow_events_async", XS_urxvt__term_allow_events_async, file, "$");
        (void)newXSproto_portable("urxvt::term::allow_events_sync", XS_urxvt__term_allow_events_sync, file, "$");
        (void)newXSproto_portable("urxvt::term::allow_events_replay", XS_urxvt__term_allow_events_replay, file, "$");
        (void)newXSproto_portable("urxvt::term::ungrab", XS_urxvt__term_ungrab, file, "$");
        (void)newXSproto_portable("urxvt::term::XStringToKeysym", XS_urxvt__term_XStringToKeysym, file, "$$");
        (void)newXSproto_portable("urxvt::term::XKeysymToString", XS_urxvt__term_XKeysymToString, file, "$$");
        (void)newXSproto_portable("urxvt::term::XKeysymToKeycode", XS_urxvt__term_XKeysymToKeycode, file, "$$");
        (void)newXSproto_portable("urxvt::term::XKeycodeToKeysym", XS_urxvt__term_XKeycodeToKeysym, file, "$$$");
        (void)newXSproto_portable("urxvt::term::strwidth", XS_urxvt__term_strwidth, file, "$$");
        (void)newXSproto_portable("urxvt::term::locale_encode", XS_urxvt__term_locale_encode, file, "$$");
        (void)newXSproto_portable("urxvt::term::locale_decode", XS_urxvt__term_locale_decode, file, "$$");
        cv = newXSproto_portable("urxvt::term::ext_bwidth", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_ext_bwidth;
        cv = newXSproto_portable("urxvt::term::fbase", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_fbase;
        cv = newXSproto_portable("urxvt::term::fheight", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_fheight;
        cv = newXSproto_portable("urxvt::term::focus", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_focus;
        cv = newXSproto_portable("urxvt::term::fwidth", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_fwidth;
        cv = newXSproto_portable("urxvt::term::height", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_height;
        cv = newXSproto_portable("urxvt::term::int_bwidth", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_int_bwidth;
        cv = newXSproto_portable("urxvt::term::letterSpace", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_letterSpace;
        cv = newXSproto_portable("urxvt::term::lineSpace", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_lineSpace;
        cv = newXSproto_portable("urxvt::term::mapped", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_mapped;
        cv = newXSproto_portable("urxvt::term::ncol", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_ncol;
        cv = newXSproto_portable("urxvt::term::nrow", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_nrow;
        cv = newXSproto_portable("urxvt::term::saveLines", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_saveLines;
        cv = newXSproto_portable("urxvt::term::top_row", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_top_row;
        cv = newXSproto_portable("urxvt::term::total_rows", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_total_rows;
        cv = newXSproto_portable("urxvt::term::width", XS_urxvt__term_width, file, "$;$");
        XSANY.any_i32 = TERM_OFFSET_width;
        cv = newXSproto_portable("urxvt::term::ModLevel3Mask", XS_urxvt__term_ModLevel3Mask, file, "$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("urxvt::term::ModMetaMask", XS_urxvt__term_ModLevel3Mask, file, "$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("urxvt::term::ModNumLockMask", XS_urxvt__term_ModLevel3Mask, file, "$");
        XSANY.any_i32 = 2;
        cv = newXSproto_portable("urxvt::term::current_screen", XS_urxvt__term_ModLevel3Mask, file, "$");
        XSANY.any_i32 = 3;
        cv = newXSproto_portable("urxvt::term::hidden_cursor", XS_urxvt__term_ModLevel3Mask, file, "$");
        XSANY.any_i32 = 4;
        cv = newXSproto_portable("urxvt::term::display_id", XS_urxvt__term_display_id, file, "$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("urxvt::term::locale", XS_urxvt__term_display_id, file, "$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("urxvt::term::argv", XS_urxvt__term_envv, file, "$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("urxvt::term::envv", XS_urxvt__term_envv, file, "$");
        XSANY.any_i32 = 0;
        (void)newXSproto_portable("urxvt::term::pty_ev_events", XS_urxvt__term_pty_ev_events, file, "$;$");
        (void)newXSproto_portable("urxvt::term::pty_fd", XS_urxvt__term_pty_fd, file, "$");
        (void)newXSproto_portable("urxvt::term::parent", XS_urxvt__term_parent, file, "$");
        (void)newXSproto_portable("urxvt::term::parent_x", XS_urxvt__term_parent_x, file, "$");
        (void)newXSproto_portable("urxvt::term::parent_y", XS_urxvt__term_parent_y, file, "$");
        (void)newXSproto_portable("urxvt::term::vt", XS_urxvt__term_vt, file, "$");
        (void)newXSproto_portable("urxvt::term::vt_emask_add", XS_urxvt__term_vt_emask_add, file, "$$");
        (void)newXSproto_portable("urxvt::term::rstyle", XS_urxvt__term_rstyle, file, "$;$");
        (void)newXSproto_portable("urxvt::term::view_start", XS_urxvt__term_view_start, file, "$;$");
        (void)newXSproto_portable("urxvt::term::set_urgency", XS_urxvt__term_set_urgency, file, "$$");
        (void)newXSproto_portable("urxvt::term::focus_in", XS_urxvt__term_focus_in, file, "$");
        (void)newXSproto_portable("urxvt::term::focus_out", XS_urxvt__term_focus_out, file, "$");
        cv = newXSproto_portable("urxvt::term::key_press", XS_urxvt__term_key_press, file, "$$$;$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("urxvt::term::key_release", XS_urxvt__term_key_press, file, "$$$;$");
        XSANY.any_i32 = 1;
        (void)newXSproto_portable("urxvt::term::want_refresh", XS_urxvt__term_want_refresh, file, "$");
        (void)newXSproto_portable("urxvt::term::refresh_check", XS_urxvt__term_refresh_check, file, "$");
        (void)newXSproto_portable("urxvt::term::ROW_t", XS_urxvt__term_ROW_t, file, "$$;$$$$");
        (void)newXSproto_portable("urxvt::term::ROW_r", XS_urxvt__term_ROW_r, file, "$$;$$$$");
        (void)newXSproto_portable("urxvt::term::ROW_l", XS_urxvt__term_ROW_l, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::ROW_is_longer", XS_urxvt__term_ROW_is_longer, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::special_encode", XS_urxvt__term_special_encode, file, "$$");
        (void)newXSproto_portable("urxvt::term::special_decode", XS_urxvt__term_special_decode, file, "$$");
        (void)newXSproto_portable("urxvt::term::_resource", XS_urxvt__term__resource, file, "$$$;$");
        (void)newXSproto_portable("urxvt::term::x_resource", XS_urxvt__term_x_resource, file, "$$");
        (void)newXSproto_portable("urxvt::term::option", XS_urxvt__term_option, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::lookup_keysym", XS_urxvt__term_lookup_keysym, file, "$$$");
        cv = newXSproto_portable("urxvt::term::bind_action", XS_urxvt__term_bind_action, file, "$$$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("urxvt::term::parse_keysym", XS_urxvt__term_bind_action, file, "$$$");
        XSANY.any_i32 = 1;
        (void)newXSproto_portable("urxvt::term::register_command", XS_urxvt__term_register_command, file, "$$$$");
        cv = newXSproto_portable("urxvt::term::screen_cur", XS_urxvt__term_screen_cur, file, "$;$$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("urxvt::term::selection_beg", XS_urxvt__term_screen_cur, file, "$;$$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("urxvt::term::selection_end", XS_urxvt__term_screen_cur, file, "$;$$");
        XSANY.any_i32 = 2;
        cv = newXSproto_portable("urxvt::term::selection_mark", XS_urxvt__term_screen_cur, file, "$;$$");
        XSANY.any_i32 = 3;
        (void)newXSproto_portable("urxvt::term::selection_screen", XS_urxvt__term_selection_screen, file, "$;$");
        (void)newXSproto_portable("urxvt::term::selection_request", XS_urxvt__term_selection_request, file, "$$$");
        (void)newXSproto_portable("urxvt::term::selection_clear", XS_urxvt__term_selection_clear, file, "$;$");
        (void)newXSproto_portable("urxvt::term::selection_make", XS_urxvt__term_selection_make, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::selection_grab", XS_urxvt__term_selection_grab, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::selection", XS_urxvt__term_selection, file, "$;$$");
        (void)newXSproto_portable("urxvt::term::cur_charset", XS_urxvt__term_cur_charset, file, "$");
        (void)newXSproto_portable("urxvt::term::scr_xor_rect", XS_urxvt__term_scr_xor_rect, file, "$$$$$;$$");
        (void)newXSproto_portable("urxvt::term::scr_xor_span", XS_urxvt__term_scr_xor_span, file, "$$$$$;$");
        (void)newXSproto_portable("urxvt::term::scr_bell", XS_urxvt__term_scr_bell, file, "$");
        (void)newXSproto_portable("urxvt::term::scr_recolor", XS_urxvt__term_scr_recolor, file, "$;$");
        (void)newXSproto_portable("urxvt::term::scr_change_screen", XS_urxvt__term_scr_change_screen, file, "$$");
        (void)newXSproto_portable("urxvt::term::scr_add_lines", XS_urxvt__term_scr_add_lines, file, "$$");
        (void)newXSproto_portable("urxvt::term::tt_write_user_input", XS_urxvt__term_tt_write_user_input, file, "$$");
        (void)newXSproto_portable("urxvt::term::tt_write", XS_urxvt__term_tt_write, file, "$$");
        (void)newXSproto_portable("urxvt::term::tt_paste", XS_urxvt__term_tt_paste, file, "$$");
        (void)newXSproto_portable("urxvt::term::cmd_parse", XS_urxvt__term_cmd_parse, file, "$$");
        (void)newXSproto_portable("urxvt::term::overlay", XS_urxvt__term_overlay, file, "$$$$$;$$");
        (void)newXSproto_portable("urxvt::term::XListProperties", XS_urxvt__term_XListProperties, file, "$$");
        (void)newXSproto_portable("urxvt::term::XGetWindowProperty", XS_urxvt__term_XGetWindowProperty, file, "$$$");
        (void)newXSproto_portable("urxvt::term::XChangeProperty", XS_urxvt__term_XChangeProperty, file, "$$$$$$");
        (void)newXSproto_portable("urxvt::term::XInternAtom", XS_urxvt__term_XInternAtom, file, "$$;$");
        (void)newXSproto_portable("urxvt::term::XGetAtomName", XS_urxvt__term_XGetAtomName, file, "$$");
        (void)newXSproto_portable("urxvt::term::XDeleteProperty", XS_urxvt__term_XDeleteProperty, file, "$$$");
        (void)newXSproto_portable("urxvt::term::DefaultRootWindow", XS_urxvt__term_DefaultRootWindow, file, "$");
#if XSubPPtmpAAAA
        (void)newXSproto_portable("urxvt::term::XCreateSimpleWindow", XS_urxvt__term_XCreateSimpleWindow, file, "$$$$$$");
#endif
        (void)newXSproto_portable("urxvt::term::XReparentWindow", XS_urxvt__term_XReparentWindow, file, "$$$;$$");
        (void)newXSproto_portable("urxvt::term::XMapWindow", XS_urxvt__term_XMapWindow, file, "$$");
        (void)newXSproto_portable("urxvt::term::XUnmapWindow", XS_urxvt__term_XUnmapWindow, file, "$$");
        (void)newXSproto_portable("urxvt::term::XMoveResizeWindow", XS_urxvt__term_XMoveResizeWindow, file, "$$$$$$");
        (void)newXSproto_portable("urxvt::term::XChangeInput", XS_urxvt__term_XChangeInput, file, "$$$;$");
        (void)newXSproto_portable("urxvt::term::XTranslateCoordinates", XS_urxvt__term_XTranslateCoordinates, file, "$$$$$");
        (void)newXSproto_portable("urxvt::term::has_render", XS_urxvt__term_has_render, file, "$");
        (void)newXSproto_portable("urxvt::term::background_geometry", XS_urxvt__term_background_geometry, file, "$;$");
#if XSubPPtmpAAAB
        (void)newXSproto_portable("urxvt::term::new_img", XS_urxvt__term_new_img, file, "$;$$$$$");
#if XSubPPtmpAAAC
        (void)newXSproto_portable("urxvt::term::new_img_from_root", XS_urxvt__term_new_img_from_root, file, "$");
#endif
#if XSubPPtmpAAAD
        (void)newXSproto_portable("urxvt::term::new_img_from_file", XS_urxvt__term_new_img_from_file, file, "$$");
#endif
        (void)newXSproto_portable("urxvt::term::set_background", XS_urxvt__term_set_background, file, "$$;$");
#endif
        (void)newXSproto_portable("urxvt::overlay::set", XS_urxvt__overlay_set, file, "$$$$;$");
        (void)newXSproto_portable("urxvt::overlay::show", XS_urxvt__overlay_show, file, "$");
        (void)newXSproto_portable("urxvt::overlay::hide", XS_urxvt__overlay_hide, file, "$");
        (void)newXSproto_portable("urxvt::overlay::DESTROY", XS_urxvt__overlay_DESTROY, file, "$");
        (void)newXSproto_portable("urxvt::watcher::cb", XS_urxvt__watcher_cb, file, "$$");
        (void)newXSproto_portable("urxvt::timer::new", XS_urxvt__timer_new, file, "$");
        (void)newXSproto_portable("urxvt::timer::at", XS_urxvt__timer_at, file, "$");
        (void)newXSproto_portable("urxvt::timer::interval", XS_urxvt__timer_interval, file, "$$");
        (void)newXSproto_portable("urxvt::timer::set", XS_urxvt__timer_set, file, "$$;$");
        (void)newXSproto_portable("urxvt::timer::start", XS_urxvt__timer_start, file, "$;$$");
        (void)newXSproto_portable("urxvt::timer::after", XS_urxvt__timer_after, file, "$$;$");
        (void)newXSproto_portable("urxvt::timer::stop", XS_urxvt__timer_stop, file, "$");
        (void)newXSproto_portable("urxvt::timer::DESTROY", XS_urxvt__timer_DESTROY, file, "$");
        (void)newXSproto_portable("urxvt::iow::new", XS_urxvt__iow_new, file, "$");
        (void)newXSproto_portable("urxvt::iow::fd", XS_urxvt__iow_fd, file, "$$");
        (void)newXSproto_portable("urxvt::iow::events", XS_urxvt__iow_events, file, "$$");
        (void)newXSproto_portable("urxvt::iow::start", XS_urxvt__iow_start, file, "$");
        (void)newXSproto_portable("urxvt::iow::stop", XS_urxvt__iow_stop, file, "$");
        (void)newXSproto_portable("urxvt::iow::DESTROY", XS_urxvt__iow_DESTROY, file, "$");
        (void)newXSproto_portable("urxvt::iw::new", XS_urxvt__iw_new, file, "$");
        (void)newXSproto_portable("urxvt::iw::start", XS_urxvt__iw_start, file, "$");
        (void)newXSproto_portable("urxvt::iw::stop", XS_urxvt__iw_stop, file, "$");
        (void)newXSproto_portable("urxvt::iw::DESTROY", XS_urxvt__iw_DESTROY, file, "$");
        (void)newXSproto_portable("urxvt::pw::new", XS_urxvt__pw_new, file, "$");
        (void)newXSproto_portable("urxvt::pw::start", XS_urxvt__pw_start, file, "$$");
        (void)newXSproto_portable("urxvt::pw::stop", XS_urxvt__pw_stop, file, "$");
        (void)newXSproto_portable("urxvt::pw::rpid", XS_urxvt__pw_rpid, file, "$");
        (void)newXSproto_portable("urxvt::pw::rstatus", XS_urxvt__pw_rstatus, file, "$");
        (void)newXSproto_portable("urxvt::pw::DESTROY", XS_urxvt__pw_DESTROY, file, "$");
#if XSubPPtmpAAAE
        (void)newXSproto_portable("urxvt::pixbuf::new_from_file", XS_urxvt__pixbuf_new_from_file, file, "$$");
        (void)newXSproto_portable("urxvt::pixbuf::DESTROY", XS_urxvt__pixbuf_DESTROY, file, "$");
#endif
#if XSubPPtmpAAAF
        (void)newXSproto_portable("urxvt::img::geometry", XS_urxvt__img_geometry, file, "$");
        cv = newXSproto_portable("urxvt::img::h", XS_urxvt__img_x, file, "$");
        XSANY.any_i32 = 3;
        cv = newXSproto_portable("urxvt::img::w", XS_urxvt__img_x, file, "$");
        XSANY.any_i32 = 2;
        cv = newXSproto_portable("urxvt::img::x", XS_urxvt__img_x, file, "$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("urxvt::img::y", XS_urxvt__img_x, file, "$");
        XSANY.any_i32 = 1;
        (void)newXSproto_portable("urxvt::img::pm", XS_urxvt__img_pm, file, "$");
        (void)newXSproto_portable("urxvt::img::fill", XS_urxvt__img_fill, file, "$;$$$$");
        (void)newXSproto_portable("urxvt::img::DESTROY", XS_urxvt__img_DESTROY, file, "$");
        (void)newXSproto_portable("urxvt::img::add_alpha", XS_urxvt__img_add_alpha, file, "$");
        (void)newXSproto_portable("urxvt::img::unshare", XS_urxvt__img_unshare, file, "$");
        (void)newXSproto_portable("urxvt::img::repeat_mode", XS_urxvt__img_repeat_mode, file, "$;$");
        (void)newXSproto_portable("urxvt::img::move", XS_urxvt__img_move, file, "$$$");
        (void)newXSproto_portable("urxvt::img::brightness", XS_urxvt__img_brightness, file, "$$$$;$");
        (void)newXSproto_portable("urxvt::img::contrast", XS_urxvt__img_contrast, file, "$$$$;$");
        (void)newXSproto_portable("urxvt::img::draw", XS_urxvt__img_draw, file, "$$;$$");
        (void)newXSproto_portable("urxvt::img::clone", XS_urxvt__img_clone, file, "$");
        (void)newXSproto_portable("urxvt::img::reify", XS_urxvt__img_reify, file, "$");
        (void)newXSproto_portable("urxvt::img::sub_rect", XS_urxvt__img_sub_rect, file, "$$$$$");
        (void)newXSproto_portable("urxvt::img::blur", XS_urxvt__img_blur, file, "$$$");
        (void)newXSproto_portable("urxvt::img::muladd", XS_urxvt__img_muladd, file, "$$$");
        (void)newXSproto_portable("urxvt::img::transform", XS_urxvt__img_transform, file, "$$$$$$$$$$");
        (void)newXSproto_portable("urxvt::img::scale", XS_urxvt__img_scale, file, "$$$");
        (void)newXSproto_portable("urxvt::img::rotate", XS_urxvt__img_rotate, file, "$$$$");
        (void)newXSproto_portable("urxvt::img::tint", XS_urxvt__img_tint, file, "$$");
        (void)newXSproto_portable("urxvt::img::shade", XS_urxvt__img_shade, file, "$$");
        (void)newXSproto_portable("urxvt::img::filter", XS_urxvt__img_filter, file, "$$;$");
#endif

    /* Initialisation Section */

#line 793 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.xs"
{
  sv_setsv (get_sv ("urxvt::LIBDIR",   1), newSVpvn (LIBDIR,   sizeof (LIBDIR)   - 1));
  sv_setsv (get_sv ("urxvt::RESNAME",  1), newSVpvn (RESNAME,  sizeof (RESNAME)  - 1));
  sv_setsv (get_sv ("urxvt::RESCLASS", 1), newSVpvn (RESCLASS, sizeof (RESCLASS) - 1));
  sv_setsv (get_sv ("urxvt::RXVTNAME", 1), newSVpvn (RXVTNAME, sizeof (RXVTNAME) - 1));

  AV *hookname = get_av ("urxvt::HOOKNAME", 1);
# define def(sym) av_store (hookname, HOOK_ ## sym, newSVpv (# sym, 0));
# include "hookinc.h"
# undef def

  HV *option = get_hv ("urxvt::OPTION", 1);
# define def(name) hv_store (option, # name, sizeof (# name) - 1, newSVuv (Opt_ ## name), 0);
# define nodef(name)
# include "optinc.h"
# undef nodef
# undef def

  HV *stash = gv_stashpv ("urxvt", 1);
  static const struct {
    const char *name;
    IV iv;
  } *civ, const_iv[] = {
#   define const_iv(name) { # name, (IV)name }
    const_iv (HOOK_INIT),
    const_iv (HOOK_DESTROY),
    const_iv (HOOK_ACTION),

    const_iv (NUM_RESOURCES),
    const_iv (DEFAULT_RSTYLE),
    const_iv (OVERLAY_RSTYLE),
    const_iv (Color_Bits),
    const_iv (RS_bgShift), const_iv (RS_bgMask),
    const_iv (RS_fgShift), const_iv (RS_fgMask),
    const_iv (RS_Careful),
    const_iv (RS_fontCount),
    const_iv (RS_fontShift),
    const_iv (RS_fontMask),
    const_iv (RS_baseattrMask),
    const_iv (RS_attrMask),
    const_iv (RS_redraw),
    const_iv (RS_Sel),
    const_iv (RS_Bold),
    const_iv (RS_Italic),
    const_iv (RS_Blink),
    const_iv (RS_RVid),
    const_iv (RS_Uline),

    // TODO: should support all colour constants, create colorinc.h &c
    const_iv (Color_fg),
    const_iv (Color_bg),
#if OFF_FOCUS_FADING
    const_iv (Color_fade),
#endif
    const_iv (Color_pointer_fg),
    const_iv (Color_pointer_bg),
    const_iv (Color_border),
    const_iv (NRS_COLORS),
    const_iv (TOTAL_COLORS),

    const_iv (CurrentTime),
    const_iv (ShiftMask),
    const_iv (LockMask),
    const_iv (ControlMask),
    const_iv (Mod1Mask),
    const_iv (Mod2Mask),
    const_iv (Mod3Mask),
    const_iv (Mod4Mask),
    const_iv (Mod5Mask),
    const_iv (Button1Mask),
    const_iv (Button2Mask),
    const_iv (Button3Mask),
    const_iv (Button4Mask),
    const_iv (Button5Mask),
    const_iv (AnyModifier),

    const_iv (NoSymbol),
    const_iv (GrabModeSync),
    const_iv (GrabModeAsync),

    const_iv (NoEventMask),
    const_iv (KeyPressMask),
    const_iv (KeyReleaseMask),
    const_iv (ButtonPressMask),
    const_iv (ButtonReleaseMask),
    const_iv (EnterWindowMask),
    const_iv (LeaveWindowMask),
    const_iv (PointerMotionMask),
    const_iv (PointerMotionHintMask),
    const_iv (Button1MotionMask),
    const_iv (Button2MotionMask),
    const_iv (Button3MotionMask),
    const_iv (Button4MotionMask),
    const_iv (Button5MotionMask),
    const_iv (ButtonMotionMask),
    const_iv (KeymapStateMask),
    const_iv (ExposureMask),
    const_iv (VisibilityChangeMask),
    const_iv (StructureNotifyMask),
    const_iv (ResizeRedirectMask),
    const_iv (SubstructureNotifyMask),
    const_iv (SubstructureRedirectMask),
    const_iv (FocusChangeMask),
    const_iv (PropertyChangeMask),
    const_iv (ColormapChangeMask),
    const_iv (OwnerGrabButtonMask),

    const_iv (KeyPress),
    const_iv (KeyRelease),
    const_iv (ButtonPress),
    const_iv (ButtonRelease),
    const_iv (MotionNotify),
    const_iv (EnterNotify),
    const_iv (LeaveNotify),
    const_iv (FocusIn),
    const_iv (FocusOut),
    const_iv (KeymapNotify),
    const_iv (Expose),
    const_iv (GraphicsExpose),
    const_iv (NoExpose),
    const_iv (VisibilityNotify),
    const_iv (CreateNotify),
    const_iv (DestroyNotify),
    const_iv (UnmapNotify),
    const_iv (MapNotify),
    const_iv (MapRequest),
    const_iv (ReparentNotify),
    const_iv (ConfigureNotify),
    const_iv (ConfigureRequest),
    const_iv (GravityNotify),
    const_iv (ResizeRequest),
    const_iv (CirculateNotify),
    const_iv (CirculateRequest),
    const_iv (PropertyNotify),
    const_iv (SelectionClear),
    const_iv (SelectionRequest),
    const_iv (SelectionNotify),
    const_iv (ColormapNotify),
    const_iv (ClientMessage),
    const_iv (MappingNotify),
#   if ENABLE_XIM_ONTHESPOT
    const_iv (XIMReverse),
    const_iv (XIMUnderline),
    const_iv (XIMHighlight),
    const_iv (XIMPrimary),
    const_iv (XIMSecondary),
    const_iv (XIMTertiary),
    const_iv (XIMVisibleToForward),
    const_iv (XIMVisibleToBackword),
    const_iv (XIMVisibleToCenter),
#if XRENDER
    const_iv (PictStandardARGB32),
    const_iv (PictStandardRGB24),
    const_iv (PictStandardA8),
    const_iv (PictStandardA4),
    const_iv (PictStandardA1),
    const_iv (RepeatNone),
    const_iv (RepeatNormal),
    const_iv (RepeatPad),
    const_iv (RepeatReflect),
    // all versions
    const_iv (PictOpClear),
    const_iv (PictOpSrc),
    const_iv (PictOpDst),
    const_iv (PictOpOver),
    const_iv (PictOpOverReverse),
    const_iv (PictOpIn),
    const_iv (PictOpInReverse),
    const_iv (PictOpOut),
    const_iv (PictOpOutReverse),
    const_iv (PictOpAtop),
    const_iv (PictOpAtopReverse),
    const_iv (PictOpXor),
    const_iv (PictOpAdd),
    const_iv (PictOpSaturate),
    // 0.2+
    const_iv (PictOpDisjointClear),
    const_iv (PictOpDisjointSrc),
    const_iv (PictOpDisjointDst),
    const_iv (PictOpDisjointOver),
    const_iv (PictOpDisjointOverReverse),
    const_iv (PictOpDisjointIn),
    const_iv (PictOpDisjointInReverse),
    const_iv (PictOpDisjointOut),
    const_iv (PictOpDisjointOutReverse),
    const_iv (PictOpDisjointAtop),
    const_iv (PictOpDisjointAtopReverse),
    const_iv (PictOpDisjointXor),
    const_iv (PictOpConjointClear),
    const_iv (PictOpConjointSrc),
    const_iv (PictOpConjointDst),
    const_iv (PictOpConjointOver),
    const_iv (PictOpConjointOverReverse),
    const_iv (PictOpConjointIn),
    const_iv (PictOpConjointInReverse),
    const_iv (PictOpConjointOut),
    const_iv (PictOpConjointOutReverse),
    const_iv (PictOpConjointAtop),
    const_iv (PictOpConjointAtopReverse),
    const_iv (PictOpConjointXor),
    // 0.11+
    const_iv (PictOpMultiply),
    const_iv (PictOpScreen),
    const_iv (PictOpOverlay),
    const_iv (PictOpDarken),
    const_iv (PictOpLighten),
    const_iv (PictOpColorDodge),
    const_iv (PictOpColorBurn),
    const_iv (PictOpHardLight),
    const_iv (PictOpSoftLight),
    const_iv (PictOpDifference),
    const_iv (PictOpExclusion),
    const_iv (PictOpHSLHue),
    const_iv (PictOpHSLSaturation),
    const_iv (PictOpHSLColor),
    const_iv (PictOpHSLLuminosity),
#endif
#   if 0
    const_iv (XIMForwardChar),
    const_iv (XIMBackwardChar),
    const_iv (XIMForwardWord),
    const_iv (XIMBackwardWord),
    const_iv (XIMCaretUp),
    const_iv (XIMCaretDown),
    const_iv (XIMNextLine),
    const_iv (XIMPreviousLine),
    const_iv (XIMLineStart),
    const_iv (XIMLineEnd),
    const_iv (XIMAbsolutePosition),
    const_iv (XIMDontChange),
#   endif
#   endif
  };

  for (civ = const_iv + ecb_array_length (const_iv); civ > const_iv; civ--)
    newCONSTSUB (stash, (char *)civ[-1].name, newSViv (civ[-1].iv));
}

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#endif
#line 6 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/$PERL <iom_perl.xs -pe s/IOM_MODULE/urxvt/g,s/IOM_CLASS/urxvt/g |"
{
  {
    HV *stash     = gv_stashpv ("urxvt", 1);
    SV *baseclass = newSVpv ("urxvt::watcher", 0);

    static const struct {
      const char *name;
      IV iv;
    } *civ, iom_const_iv[] = {
#   define iom_const_iv(name) { # name, (IV)name }
      iom_const_iv (EV_NONE),
      iom_const_iv (EV_READ),
      iom_const_iv (EV_WRITE),
#   undef iom_const
    };

    for (civ = iom_const_iv + sizeof (iom_const_iv) / sizeof (iom_const_iv [0]); civ > iom_const_iv; civ--)
      newCONSTSUB (stash, (char *)civ[-1].name, newSViv (civ[-1].iv));

    /* slightly dirty to put the same scalar into all those arrays, but */
    /* we do not expect users to modify them anyways */
    av_push (get_av ("urxvt" "::timer::ISA", 1), SvREFCNT_inc (baseclass));
    av_push (get_av ("urxvt"   "::iow::ISA", 1), SvREFCNT_inc (baseclass));
    av_push (get_av ("urxvt"    "::pw::ISA", 1), SvREFCNT_inc (baseclass));
    av_push (get_av ("urxvt"    "::iw::ISA", 1), SvREFCNT_inc (baseclass));

    SvREFCNT_dec (baseclass);
  }
}

#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#line 6270 "/wip/cygport-git/rxvt-unicode/rxvt-unicode-9.22-5.x86_64/src/rxvt-unicode-9.22/src/rxvtperl.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

