/* cdsl_map.h
 * Copyright (c) 2009 Charles S. Wilson
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef CDSL_MAP_H
#define CDSL_MAP_H

#include "cdsl_rbtree.h"
#ifdef __cplusplus
extern "C" {
#endif

/* opaque types */
typedef cdsl_rbtrav_t cdsl_map_iter_t;
typedef cdsl_rbtree_t cdsl_map_t;
typedef struct cdsl_map_data cdsl_map_data_t;

/* User-defined item handling */
typedef int   (*cdsl_map_key_cmp_f) (void *k1, void *k2);
typedef void *(*cdsl_map_key_dup_f) (void *k);
typedef void  (*cdsl_map_key_rel_f) (void *k);
typedef void *(*cdsl_map_val_dup_f) (void *v);
typedef void  (*cdsl_map_val_rel_f) (void *v);

cdsl_map_t *      cdsl_map_new         (cdsl_map_key_cmp_f cmp,
                                        cdsl_map_key_dup_f kdup,
                                        cdsl_map_key_rel_f krel,
                                        cdsl_map_val_dup_f vdup,
                                        cdsl_map_val_rel_f vrel);
void              cdsl_map_delete      (cdsl_map_t * map);
void              cdsl_map_clear       (cdsl_map_t * map);
void *            cdsl_map_key         (cdsl_map_iter_t *iter);
void *            cdsl_map_value       (cdsl_map_iter_t *iter);
void *            cdsl_map_key_data    (cdsl_map_data_t *data); /* use inside cdsl_map_cmp_f impl */
void *            cdsl_map_value_data  (cdsl_map_data_t *data);

cdsl_map_data_t * cdsl_map_data_new    (cdsl_map_t *self, void *key, void *value);
void              cdsl_map_data_delete (cdsl_map_t *self, cdsl_map_data_t *data);

int               cdsl_map_insert      (cdsl_map_t *self, void *key, void *value);
int               cdsl_map_erase       (cdsl_map_t *self, void *key);
int               cdsl_map_find        (cdsl_map_t *self, void *key, cdsl_map_iter_t *iter);
size_t            cdsl_map_size        (cdsl_map_t *self);
int               cdsl_map_empty       (cdsl_map_t *self);

cdsl_map_iter_t * cdsl_map_iter_new    (cdsl_map_t *self);
void              cdsl_map_iter_delete (cdsl_map_iter_t *iter);
void              cdsl_map_first       (cdsl_map_t *self, cdsl_map_iter_t *iter);
void              cdsl_map_last        (cdsl_map_t *self, cdsl_map_iter_t *iter);
void              cdsl_map_next        (cdsl_map_iter_t *iter);
void              cdsl_map_prev        (cdsl_map_iter_t *iter);
int               cdsl_map_iter_end    (cdsl_map_iter_t *iter);

#ifdef __cplusplus
}
#endif

#endif /* CDSL_MAP_H */
