/* cdsl_dlist.h - simple doubly-linked list
 * Copyright (c) 2009 Charles Wilson
 * This file is part of the C Data Structures Library.
 *
 * Derived from code released into the public domain by Julienne Walker:
 * http://eternallyconfuzzled.com/tuts/datastructures/jsw_tut_linklist.aspx
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef CDSL_DLIST_H
#define CDSL_DLIST_H


#ifdef __cplusplus
#include <cstddef>

using std::size_t;

extern "C"
  {
#else
#include <stddef.h>
#endif

    /* Opaque types */
    typedef struct cdsl_dlist_node cdsl_dlist_node_t;
    typedef struct cdsl_dlist      cdsl_dlist_t;

    /* User-defined item handling */
    typedef int   (*cdsl_dlist_cmp_f) (const void *p1, const void *p2);
    typedef void  (*cdsl_dlist_rel_f) (void *p);

    /* life cycle */
    cdsl_dlist_t      *cdsl_dlist_new_list     (void);
    void               cdsl_dlist_destroy_list (cdsl_dlist_t *list, cdsl_dlist_rel_f destroy);
    cdsl_dlist_node_t *cdsl_dlist_destroy_node (cdsl_dlist_node_t *node, cdsl_dlist_rel_f destroy);

    /* mutation */
    cdsl_dlist_node_t *cdsl_dlist_insert_after  (cdsl_dlist_t *list, cdsl_dlist_node_t *pos, void *data);
    cdsl_dlist_node_t *cdsl_dlist_insert_before (cdsl_dlist_t *list, cdsl_dlist_node_t *pos, void *data);
    cdsl_dlist_node_t *cdsl_dlist_remove_node   (cdsl_dlist_t *list, cdsl_dlist_node_t *pos);
    cdsl_dlist_node_t *cdsl_dlist_insert_sorted (cdsl_dlist_t *list, void *data, cdsl_dlist_cmp_f compare);
    void               cdsl_dlist_sort          (cdsl_dlist_t *list, cdsl_dlist_cmp_f compare);

    /* iterating */
    cdsl_dlist_node_t *cdsl_dlist_begin (cdsl_dlist_t *list);
    cdsl_dlist_node_t *cdsl_dlist_end   (cdsl_dlist_t *list);
    cdsl_dlist_node_t *cdsl_dlist_next  (cdsl_dlist_node_t *node);
    cdsl_dlist_node_t *cdsl_dlist_prev  (cdsl_dlist_node_t *node);
    cdsl_dlist_node_t *cdsl_dlist_rbegin(cdsl_dlist_t *list);
    cdsl_dlist_node_t *cdsl_dlist_rend  (cdsl_dlist_t *list);
    cdsl_dlist_node_t *cdsl_dlist_rnext (cdsl_dlist_node_t *node);
    cdsl_dlist_node_t *cdsl_dlist_rprev (cdsl_dlist_node_t *node);

    /* misc */
    void              *cdsl_dlist_value (cdsl_dlist_node_t *node);
    size_t             cdsl_dlist_size  (cdsl_dlist_t *list);
    cdsl_dlist_node_t *cdsl_dlist_find  (cdsl_dlist_t *list, void *data, cdsl_dlist_cmp_f compare);

#ifdef __cplusplus
  }
#endif

#endif

