/**
 * @file
 * Test code for the editor state
 *
 * @authors
 * Copyright (C) 2022 Richard Russon <rich@flatcap.org>
 *
 * @copyright
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define TEST_NO_MAIN
#include "config.h"
#include "acutest.h"
#include <stddef.h>
#include "editor/lib.h"

void test_editor_state(void)
{
  enter_state_resize(NULL, 16);

  struct EnterState *es = enter_state_new();

  for (size_t i = 0; i < 1000; i++)
  {
    enter_state_resize(es, i);
  }

  enter_state_free(&es);

  enter_state_free(NULL);
}
