/* completion.c generated by valac 0.36.5, the Vala compiler
 * generated from completion.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Sébastien Wilmet
 *          Pieter Pareit
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include <tepl/tepl.h>
#include "config.h"


#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND (completion_provider_completion_command_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_ARGUMENT (completion_provider_completion_argument_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE (completion_provider_completion_choice_get_type ())
typedef struct _CompletionProviderCompletionChoice CompletionProviderCompletionChoice;
typedef struct _CompletionProviderCompletionArgument CompletionProviderCompletionArgument;
typedef struct _CompletionProviderCompletionCommand CompletionProviderCompletionCommand;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define COMPLETION_PROVIDER_TYPE_ARGUMENT_CONTEXT (completion_provider_argument_context_get_type ())
typedef struct _CompletionProviderArgumentContext CompletionProviderArgumentContext;
#define _completion_provider_completion_command_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_command_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _completion_provider_completion_choice_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_choice_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderCompletionChoice {
	gchar* name;
	gchar* package;
	gchar* insert;
	gchar* insert_after;
};

struct _CompletionProviderCompletionArgument {
	gchar* label;
	gboolean optional;
	CompletionProviderCompletionChoice* choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _CompletionProviderCompletionCommand {
	gchar* name;
	gchar* package;
	CompletionProviderCompletionArgument* args;
	gint args_length1;
	gint _args_size_;
};

struct _CompletionProviderPrivate {
	GSettings* _settings;
	GList* _proposals;
	GeeHashMap* _commands;
	GeeHashMap* _environments;
	CompletionProviderCompletionCommand _current_command;
	CompletionProviderCompletionArgument _current_arg;
	CompletionProviderCompletionChoice _current_choice;
	GdkPixbuf* _icon_cmd;
	GdkPixbuf* _icon_choice;
	GdkPixbuf* _icon_package_required;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
};

struct _CompletionProviderArgumentContext {
	gchar* cmd_name;
	gchar* arg_contents;
	GeeArrayList* args_types;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};


static gpointer completion_provider_parent_class = NULL;
static CompletionProvider* completion_provider__instance;
static CompletionProvider* completion_provider__instance = NULL;
static GtkSourceCompletionProviderIface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;

GType completion_provider_get_type (void) G_GNUC_CONST;
static GType completion_provider_completion_command_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_choice_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest);
static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self);
static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest);
static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self);
static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest);
static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self);
#define COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_PROVIDER, CompletionProviderPrivate))
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static CompletionProvider* completion_provider_new (void);
static CompletionProvider* completion_provider_construct (GType object_type);
static void completion_provider_load_data (CompletionProvider* self);
CompletionProvider* completion_provider_get_default (void);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static void completion_provider_show_no_proposals (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_populate_command (CompletionProvider* self, GtkSourceCompletionContext* context, const gchar* cmd);
static GType completion_provider_argument_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self, CompletionProviderArgumentContext* dest);
static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self);
static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, CompletionProviderArgumentContext* info);
static void completion_provider_populate_argument (CompletionProvider* self, GtkSourceCompletionContext* context, CompletionProviderArgumentContext* info);
static gboolean completion_provider_is_user_request (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_show_all_proposals (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_show_filtered_proposals (CompletionProvider* self, GtkSourceCompletionContext* context, GList* proposals_to_filter, const gchar* prefix);
static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderArgumentContext* arg_context);
static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self, const gchar* arg_cmd, GeeArrayList* arguments);
static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint cur_arg);
static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args);
static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b);
static void completion_provider_init_calltip_window (CompletionProvider* self);
static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup);
GType main_window_get_type (void) G_GNUC_CONST;
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
MainWindow* latexila_app_get_active_main_window (LatexilaApp* self);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
static void completion_provider_get_begin_arg_pos (CompletionProvider* self, GtkTextIter* in_arg_pos, GtkTextIter* result);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd);
static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* arg_cmd, const gchar* arg_contents);
static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter);
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_document_view (DocumentTab* self);
gchar* document_view_get_indentation_style (DocumentView* self);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self, GtkTextIter* iter);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, gint index);
static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self, CompletionProviderCompletionCommand* cmd);
gchar* utils_load_file (GFile* file);
static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static void completion_provider_parser_add_command (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void completion_provider_parser_add_argument (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void completion_provider_parser_add_choice (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _vala_array_add2 (CompletionProviderCompletionArgument* * array, int* length, int* size, const CompletionProviderCompletionArgument* value);
static void _vala_array_add3 (CompletionProviderCompletionChoice* * array, int* length, int* size, const CompletionProviderCompletionChoice* value);
static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument * array, gint array_length);
static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length);
static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice * array, gint array_length);
static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length);
static void completion_provider_finalize (GObject * obj);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	GSettings* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = latexila_utils_get_pixbuf_from_icon_name ("completion_cmd", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_cmd);
	self->priv->_icon_cmd = _tmp1_;
	_tmp2_ = latexila_utils_get_pixbuf_from_icon_name ("gray-square", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_choice);
	self->priv->_icon_choice = _tmp2_;
	_tmp3_ = latexila_utils_get_pixbuf_from_icon_name ("dialog-warning", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_package_required);
	self->priv->_icon_package_required = _tmp3_;
	completion_provider_load_data (self);
	return self;
}


static CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CompletionProvider* completion_provider_get_default (void) {
	CompletionProvider* result = NULL;
	CompletionProvider* _tmp0_;
	CompletionProvider* _tmp2_;
	CompletionProvider* _tmp3_;
	_tmp0_ = completion_provider__instance;
	if (_tmp0_ == NULL) {
		CompletionProvider* _tmp1_;
		_tmp1_ = completion_provider_new ();
		_g_object_unref0 (completion_provider__instance);
		completion_provider__instance = _tmp1_;
	}
	_tmp2_ = completion_provider__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (CompletionProvider*) base;
	_tmp0_ = g_strdup ("LaTeX");
	result = _tmp0_;
	return result;
}


static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	GtkSourceCompletionActivation result = 0;
	GtkSourceCompletionActivation activation = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_;
	self = (CompletionProvider*) base;
	activation = GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "interactive-completion");
	if (_tmp1_) {
		GtkSourceCompletionActivation _tmp2_;
		_tmp2_ = activation;
		activation = _tmp2_ | GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE;
	}
	result = activation;
	return result;
}


static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTextBuffer* buf = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gtk_text_iter_get_buffer (&iter);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	buf = _tmp4_;
	_tmp5_ = buf;
	_tmp6_ = gtk_text_buffer_get_has_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		result = FALSE;
		_g_object_unref0 (buf);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (buf);
	return result;
}


static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	CompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* cmd = NULL;
	GtkSourceCompletionContext* _tmp1_;
	GtkTextIter* _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkSourceCompletionContext* _tmp7_;
	GtkTextIter* _tmp8_;
	GtkTextIter* _tmp9_;
	GtkTextIter prev = {0};
	GtkTextIter _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp15_;
	GtkTextIter _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	_tmp1_ = context;
	g_object_get (_tmp1_, "iter", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = *_tmp3_;
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
	cmd = _tmp5_;
	_tmp6_ = cmd;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_free0 (cmd);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp7_ = context;
	g_object_get (_tmp7_, "iter", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_vala_iter = *_tmp9_;
	_tmp10_ = _vala_iter;
	prev = _tmp10_;
	_tmp12_ = gtk_text_iter_backward_char (&prev);
	if (_tmp12_) {
		gunichar _tmp13_;
		_tmp13_ = gtk_text_iter_get_char (&prev);
		_tmp11_ = _tmp13_ == ((gunichar) '\\');
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkTextIter _tmp14_;
		_tmp14_ = prev;
		_vala_iter = _tmp14_;
		result = TRUE;
		_g_free0 (cmd);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp15_ = gtk_text_iter_starts_word (&_vala_iter);
	if (!_tmp15_) {
		gtk_text_iter_backward_visible_word_start (&_vala_iter);
	}
	_tmp16_ = _vala_iter;
	prev = _tmp16_;
	_tmp18_ = gtk_text_iter_backward_char (&prev);
	if (_tmp18_) {
		gunichar _tmp19_;
		_tmp19_ = gtk_text_iter_get_char (&prev);
		_tmp17_ = _tmp19_ == ((gunichar) '\\');
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GtkTextIter _tmp20_;
		_tmp20_ = prev;
		_vala_iter = _tmp20_;
	}
	result = TRUE;
	_g_free0 (cmd);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


/*************************************************************************/
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	GtkTextIter iter = {0};
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* cmd = NULL;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	CompletionProviderArgumentContext info = {0};
	gboolean in_arg = FALSE;
	GtkTextIter _tmp9_;
	CompletionProviderArgumentContext _tmp10_ = {0};
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkSourceCompletionContext* _tmp15_;
	gboolean _tmp16_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		GtkSourceCompletionContext* _tmp3_;
		_tmp3_ = context;
		completion_provider_show_no_proposals (self, _tmp3_);
		return;
	}
	_tmp4_ = iter;
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
	cmd = _tmp5_;
	_tmp6_ = cmd;
	if (_tmp6_ != NULL) {
		GtkSourceCompletionContext* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = context;
		_tmp8_ = cmd;
		completion_provider_populate_command (self, _tmp7_, _tmp8_);
		_g_free0 (cmd);
		return;
	}
	_tmp9_ = iter;
	_tmp11_ = completion_provider_in_latex_command_argument (self, &_tmp9_, &_tmp10_);
	completion_provider_argument_context_destroy (&info);
	info = _tmp10_;
	in_arg = _tmp11_;
	_tmp12_ = in_arg;
	if (_tmp12_) {
		GtkSourceCompletionContext* _tmp13_;
		CompletionProviderArgumentContext _tmp14_;
		_tmp13_ = context;
		_tmp14_ = info;
		completion_provider_populate_argument (self, _tmp13_, &_tmp14_);
		completion_provider_argument_context_destroy (&info);
		_g_free0 (cmd);
		return;
	}
	_tmp15_ = context;
	_tmp16_ = completion_provider_is_user_request (self, _tmp15_);
	if (_tmp16_) {
		GtkSourceCompletionContext* _tmp17_;
		_tmp17_ = context;
		completion_provider_show_all_proposals (self, _tmp17_);
	} else {
		GtkSourceCompletionContext* _tmp18_;
		_tmp18_ = context;
		completion_provider_show_no_proposals (self, _tmp18_);
	}
	completion_provider_argument_context_destroy (&info);
	_g_free0 (cmd);
}


static void completion_provider_populate_command (CompletionProvider* self, GtkSourceCompletionContext* context, const gchar* cmd) {
	GtkSourceCompletionContext* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp8_;
	GtkSourceCompletionContext* _tmp10_;
	GList* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (cmd != NULL);
	_tmp0_ = context;
	_tmp1_ = completion_provider_is_user_request (self, _tmp0_);
	if (!_tmp1_) {
		guint min_nb_chars = 0U;
		GSettings* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		guint _tmp6_;
		_tmp2_ = self->priv->_settings;
		g_settings_get (_tmp2_, "interactive-completion-num", "u", &min_nb_chars);
		_tmp3_ = cmd;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = min_nb_chars;
		if (((guint) _tmp5_) <= _tmp6_) {
			GtkSourceCompletionContext* _tmp7_;
			_tmp7_ = context;
			completion_provider_show_no_proposals (self, _tmp7_);
			return;
		}
	}
	_tmp8_ = cmd;
	if (g_strcmp0 (_tmp8_, "\\") == 0) {
		GtkSourceCompletionContext* _tmp9_;
		_tmp9_ = context;
		completion_provider_show_all_proposals (self, _tmp9_);
		return;
	}
	_tmp10_ = context;
	_tmp11_ = self->priv->_proposals;
	_tmp12_ = cmd;
	completion_provider_show_filtered_proposals (self, _tmp10_, _tmp11_, _tmp12_);
}


static void completion_provider_populate_argument (CompletionProvider* self, GtkSourceCompletionContext* context, CompletionProviderArgumentContext* info) {
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	GList* proposals_to_filter = NULL;
	CompletionProviderArgumentContext _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	GtkSourceCompletionContext* _tmp15_;
	GList* _tmp16_;
	CompletionProviderArgumentContext _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *info;
	_tmp2_ = _tmp1_.cmd_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	if (!_tmp3_) {
		GtkSourceCompletionContext* _tmp4_;
		_tmp4_ = context;
		completion_provider_show_no_proposals (self, _tmp4_);
		return;
	}
	_tmp5_ = *info;
	_tmp6_ = completion_provider_get_argument_proposals (self, &_tmp5_);
	proposals_to_filter = _tmp6_;
	_tmp7_ = proposals_to_filter;
	if (_tmp7_ == NULL) {
		GtkSourceCompletionContext* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = context;
		_tmp9_ = completion_provider_is_user_request (self, _tmp8_);
		if (_tmp9_) {
			CompletionProviderArgumentContext _tmp10_;
			const gchar* _tmp11_;
			CompletionProviderArgumentContext _tmp12_;
			GeeArrayList* _tmp13_;
			_tmp10_ = *info;
			_tmp11_ = _tmp10_.cmd_name;
			_tmp12_ = *info;
			_tmp13_ = _tmp12_.args_types;
			completion_provider_show_calltip_cmd_prototype (self, _tmp11_, _tmp13_);
		} else {
			GtkSourceCompletionContext* _tmp14_;
			_tmp14_ = context;
			completion_provider_show_no_proposals (self, _tmp14_);
		}
		return;
	}
	_tmp15_ = context;
	_tmp16_ = proposals_to_filter;
	_tmp17_ = *info;
	_tmp18_ = _tmp17_.arg_contents;
	completion_provider_show_filtered_proposals (self, _tmp15_, _tmp16_, _tmp18_);
}


static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderArgumentContext* arg_context) {
	GList* result = NULL;
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	CompletionProviderCompletionCommand cmd = {0};
	GeeHashMap* _tmp4_;
	CompletionProviderArgumentContext _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_;
	CompletionProviderCompletionCommand* _tmp8_;
	CompletionProviderCompletionCommand _tmp9_ = {0};
	CompletionProviderCompletionCommand _tmp10_;
	gchar* cmd_info = NULL;
	CompletionProviderCompletionCommand _tmp11_;
	gchar* _tmp12_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp13_;
	CompletionProviderCompletionArgument* _tmp14_;
	gint _tmp14__length1;
	CompletionProviderArgumentContext _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	CompletionProviderCompletionArgument arg = {0};
	CompletionProviderCompletionCommand _tmp19_;
	CompletionProviderCompletionArgument* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	CompletionProviderCompletionArgument _tmp22_;
	CompletionProviderCompletionArgument _tmp23_ = {0};
	GList* items = NULL;
	CompletionProviderCompletionArgument _tmp24_;
	CompletionProviderCompletionChoice* _tmp25_;
	gint _tmp25__length1;
	GList* _tmp54_;
	GList* _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg_context != NULL, NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *arg_context;
	_tmp2_ = _tmp1_.cmd_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	g_return_val_if_fail (_tmp3_, NULL);
	_tmp4_ = self->priv->_commands;
	_tmp5_ = *arg_context;
	_tmp6_ = _tmp5_.cmd_name;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp6_);
	_tmp8_ = (CompletionProviderCompletionCommand*) _tmp7_;
	completion_provider_completion_command_copy (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_completion_provider_completion_command_free0 (_tmp8_);
	cmd = _tmp10_;
	_tmp11_ = cmd;
	_tmp12_ = completion_provider_get_command_info (self, &_tmp11_, -1);
	cmd_info = _tmp12_;
	_tmp13_ = cmd;
	_tmp14_ = _tmp13_.args;
	_tmp14__length1 = _tmp13_.args_length1;
	_tmp15_ = *arg_context;
	_tmp16_ = _tmp15_.args_types;
	_tmp17_ = completion_provider_get_argument_num (self, _tmp14_, _tmp14__length1, _tmp16_);
	arg_num = _tmp17_;
	_tmp18_ = arg_num;
	if (_tmp18_ == -1) {
		result = NULL;
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	_tmp19_ = cmd;
	_tmp20_ = _tmp19_.args;
	_tmp20__length1 = _tmp19_.args_length1;
	_tmp21_ = arg_num;
	_tmp22_ = _tmp20_[_tmp21_ - 1];
	completion_provider_completion_argument_copy (&_tmp22_, &_tmp23_);
	arg = _tmp23_;
	items = NULL;
	_tmp24_ = arg;
	_tmp25_ = _tmp24_.choices;
	_tmp25__length1 = _tmp24_.choices_length1;
	{
		CompletionProviderCompletionChoice* choice_collection = NULL;
		gint choice_collection_length1 = 0;
		gint _choice_collection_size_ = 0;
		gint choice_it = 0;
		choice_collection = _tmp25_;
		choice_collection_length1 = _tmp25__length1;
		for (choice_it = 0; choice_it < _tmp25__length1; choice_it = choice_it + 1) {
			CompletionProviderCompletionChoice _tmp26_ = {0};
			CompletionProviderCompletionChoice choice = {0};
			completion_provider_completion_choice_copy (&choice_collection[choice_it], &_tmp26_);
			choice = _tmp26_;
			{
				GdkPixbuf* pixbuf = NULL;
				gchar* arg_info = NULL;
				CompletionProviderCompletionChoice _tmp27_;
				const gchar* _tmp28_;
				GtkSourceCompletionItem* item = NULL;
				GtkSourceCompletionItem* _tmp39_;
				GtkSourceCompletionItem* _tmp40_;
				CompletionProviderCompletionChoice _tmp41_;
				const gchar* _tmp42_;
				GtkSourceCompletionItem* _tmp43_;
				CompletionProviderCompletionChoice _tmp44_;
				const gchar* _tmp45_;
				GtkSourceCompletionItem* _tmp46_;
				GdkPixbuf* _tmp47_;
				const gchar* _tmp48_ = NULL;
				const gchar* _tmp49_;
				GtkSourceCompletionItem* _tmp51_;
				GtkSourceCompletionItem* _tmp52_;
				GtkSourceCompletionItem* _tmp53_;
				arg_info = NULL;
				_tmp27_ = choice;
				_tmp28_ = _tmp27_.package;
				if (_tmp28_ != NULL) {
					GdkPixbuf* _tmp29_;
					GdkPixbuf* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					CompletionProviderCompletionChoice _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp29_ = self->priv->_icon_package_required;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp30_;
					_tmp31_ = cmd_info;
					_tmp32_ = g_strconcat (_tmp31_, "\nPackage: ", NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = choice;
					_tmp35_ = _tmp34_.package;
					_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
					_g_free0 (arg_info);
					arg_info = _tmp36_;
					_g_free0 (_tmp33_);
				} else {
					GdkPixbuf* _tmp37_;
					GdkPixbuf* _tmp38_;
					_tmp37_ = self->priv->_icon_choice;
					_tmp38_ = _g_object_ref0 (_tmp37_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp38_;
				}
				_tmp39_ = gtk_source_completion_item_new2 ();
				item = _tmp39_;
				_tmp40_ = item;
				_tmp41_ = choice;
				_tmp42_ = _tmp41_.name;
				gtk_source_completion_item_set_label (_tmp40_, _tmp42_);
				_tmp43_ = item;
				_tmp44_ = choice;
				_tmp45_ = _tmp44_.name;
				gtk_source_completion_item_set_text (_tmp43_, _tmp45_);
				_tmp46_ = item;
				_tmp47_ = pixbuf;
				gtk_source_completion_item_set_icon (_tmp46_, _tmp47_);
				_tmp49_ = arg_info;
				_tmp48_ = _tmp49_;
				if (_tmp48_ == NULL) {
					const gchar* _tmp50_;
					_tmp50_ = cmd_info;
					_tmp48_ = _tmp50_;
				}
				_tmp51_ = item;
				gtk_source_completion_item_set_info (_tmp51_, _tmp48_);
				_tmp52_ = item;
				_tmp53_ = _g_object_ref0 (_tmp52_);
				items = g_list_prepend (items, _tmp53_);
				_g_object_unref0 (item);
				_g_free0 (arg_info);
				_g_object_unref0 (pixbuf);
				completion_provider_completion_choice_destroy (&choice);
			}
		}
	}
	_tmp54_ = items;
	if (_tmp54_ == NULL) {
		result = NULL;
		completion_provider_completion_argument_destroy (&arg);
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	items = g_list_sort (items, (GCompareFunc) completion_provider_compare_proposals);
	_tmp55_ = items;
	result = _tmp55_;
	completion_provider_completion_argument_destroy (&arg);
	_g_free0 (cmd_info);
	completion_provider_completion_command_destroy (&cmd);
	return result;
}


static void completion_provider_show_no_proposals (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GtkSourceCompletionContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	gtk_source_completion_context_add_proposals (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), NULL, TRUE);
}


static void completion_provider_show_all_proposals (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GtkSourceCompletionContext* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = self->priv->_proposals;
	gtk_source_completion_context_add_proposals (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp1_, TRUE);
}


static void completion_provider_show_filtered_proposals (CompletionProvider* self, GtkSourceCompletionContext* context, GList* proposals_to_filter, const gchar* prefix) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GList* filtered_proposals = NULL;
	GList* _tmp5_;
	GList* _tmp16_;
	GtkSourceCompletionContext* _tmp22_;
	GList* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp1_ = prefix;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = prefix;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		GtkSourceCompletionContext* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = context;
		_tmp4_ = proposals_to_filter;
		gtk_source_completion_context_add_proposals (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp4_, TRUE);
		return;
	}
	filtered_proposals = NULL;
	_tmp5_ = proposals_to_filter;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp5_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkSourceCompletionItem* _tmp6_;
			GtkSourceCompletionItem* item = NULL;
			_tmp6_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
			item = _tmp6_;
			{
				GtkSourceCompletionItem* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp7_ = item;
				g_object_get (_tmp7_, "text", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_tmp11_ = prefix;
				_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp10_);
				if (_tmp13_) {
					GtkSourceCompletionItem* _tmp14_;
					GtkSourceCompletionItem* _tmp15_;
					_tmp14_ = item;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					filtered_proposals = g_list_prepend (filtered_proposals, _tmp15_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp16_ = filtered_proposals;
	if (_tmp16_ != NULL) {
		filtered_proposals = g_list_reverse (filtered_proposals);
	} else {
		GtkSourceCompletionItem* dummy_proposal = NULL;
		GtkSourceCompletionItem* _tmp17_;
		GtkSourceCompletionItem* _tmp18_;
		GtkSourceCompletionItem* _tmp19_;
		GtkSourceCompletionItem* _tmp20_;
		GtkSourceCompletionItem* _tmp21_;
		_tmp17_ = gtk_source_completion_item_new2 ();
		dummy_proposal = _tmp17_;
		_tmp18_ = dummy_proposal;
		gtk_source_completion_item_set_label (_tmp18_, _ ("No matching proposal"));
		_tmp19_ = dummy_proposal;
		gtk_source_completion_item_set_text (_tmp19_, "");
		_tmp20_ = dummy_proposal;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		filtered_proposals = g_list_prepend (filtered_proposals, _tmp21_);
		_g_object_unref0 (dummy_proposal);
	}
	_tmp22_ = context;
	_tmp23_ = filtered_proposals;
	gtk_source_completion_context_add_proposals (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp23_, TRUE);
	__g_list_free__g_object_unref0_0 (filtered_proposals);
}


/*************************************************************************/
static void completion_provider_init_calltip_window (CompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	GtkSourceCompletionInfo* _tmp2_;
	GtkLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_completion_info_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_calltip_window);
	self->priv->_calltip_window = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_calltip_window_label);
	self->priv->_calltip_window_label = _tmp1_;
	_tmp2_ = self->priv->_calltip_window;
	_tmp3_ = self->priv->_calltip_window_label;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
}


static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self, const gchar* arg_cmd, GeeArrayList* arguments) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	CompletionProviderCompletionCommand command = {0};
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_;
	CompletionProviderCompletionCommand* _tmp6_;
	CompletionProviderCompletionCommand _tmp7_ = {0};
	CompletionProviderCompletionCommand _tmp8_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp9_;
	CompletionProviderCompletionArgument* _tmp10_;
	gint _tmp10__length1;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg_cmd != NULL);
	g_return_if_fail (arguments != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = arg_cmd;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	g_return_if_fail (_tmp2_);
	_tmp3_ = self->priv->_commands;
	_tmp4_ = arg_cmd;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	_tmp6_ = (CompletionProviderCompletionCommand*) _tmp5_;
	completion_provider_completion_command_copy (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_completion_provider_completion_command_free0 (_tmp6_);
	command = _tmp8_;
	_tmp9_ = command;
	_tmp10_ = _tmp9_.args;
	_tmp10__length1 = _tmp9_.args_length1;
	_tmp11_ = arguments;
	_tmp12_ = completion_provider_get_argument_num (self, _tmp10_, _tmp10__length1, _tmp11_);
	arg_num = _tmp12_;
	_tmp13_ = arg_num;
	if (_tmp13_ != -1) {
		gchar* info = NULL;
		CompletionProviderCompletionCommand _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp14_ = command;
		_tmp15_ = arg_num;
		_tmp16_ = completion_provider_get_command_info (self, &_tmp14_, _tmp15_);
		info = _tmp16_;
		_tmp17_ = info;
		completion_provider_show_calltip_info (self, _tmp17_);
		_g_free0 (info);
	}
	completion_provider_completion_command_destroy (&command);
}


static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup) {
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	MainWindow* window = NULL;
	LatexilaApp* _tmp3_;
	LatexilaApp* _tmp4_;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
	GtkSourceCompletionInfo* _tmp7_;
	GtkSourceCompletionInfo* _tmp8_;
	DocumentView* _tmp9_;
	DocumentView* _tmp10_;
	GtkTextIter cursor_pos = {0};
	GtkTextBuffer* buffer = NULL;
	DocumentView* _tmp11_;
	DocumentView* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextMark* _tmp16_;
	GtkTextIter _tmp17_ = {0};
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp18_;
	GtkTextIter _tmp19_ = {0};
	GtkSourceCompletionInfo* _tmp20_;
	DocumentView* _tmp21_;
	DocumentView* _tmp22_;
	GtkTextIter _tmp23_;
	GtkSourceCompletionInfo* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ == NULL) {
		completion_provider_init_calltip_window (self);
	}
	_tmp1_ = self->priv->_calltip_window_label;
	_tmp2_ = markup;
	gtk_label_set_markup (_tmp1_, _tmp2_);
	_tmp3_ = latexila_app_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = latexila_app_get_active_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	window = _tmp6_;
	g_return_if_fail (window != NULL);
	_tmp7_ = self->priv->_calltip_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, (GtkWindow*) window);
	_tmp8_ = self->priv->_calltip_window;
	_tmp9_ = main_window_get_active_view (window);
	_tmp10_ = _tmp9_;
	gtk_window_set_attached_to ((GtkWindow*) _tmp8_, (GtkWidget*) _tmp10_);
	_tmp11_ = main_window_get_active_view (window);
	_tmp12_ = _tmp11_;
	_tmp13_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	buffer = _tmp15_;
	_tmp16_ = gtk_text_buffer_get_insert (buffer);
	gtk_text_buffer_get_iter_at_mark (buffer, &_tmp17_, _tmp16_);
	cursor_pos = _tmp17_;
	_tmp18_ = cursor_pos;
	completion_provider_get_begin_arg_pos (self, &_tmp18_, &_tmp19_);
	begin_arg_pos = _tmp19_;
	_tmp20_ = self->priv->_calltip_window;
	_tmp21_ = main_window_get_active_view (window);
	_tmp22_ = _tmp21_;
	_tmp23_ = begin_arg_pos;
	gtk_source_completion_info_move_to_iter (_tmp20_, (GtkTextView*) _tmp22_, &_tmp23_);
	_tmp24_ = self->priv->_calltip_window;
	gtk_widget_show_all ((GtkWidget*) _tmp24_);
	_g_object_unref0 (buffer);
	_g_object_unref0 (window);
}


void completion_provider_hide_calltip_window (CompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ != NULL) {
		GtkSourceCompletionInfo* _tmp1_;
		_tmp1_ = self->priv->_calltip_window;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}


/*************************************************************************/
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	CompletionProvider * self;
	gboolean result = FALSE;
	gchar* text = NULL;
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* cmd = NULL;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = text;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = text;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp5_ = *iter;
	_tmp6_ = completion_provider_get_latex_command_at_iter (self, &_tmp5_);
	cmd = _tmp6_;
	_tmp8_ = cmd;
	if (_tmp8_ != NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = text;
		_tmp10_ = g_str_has_prefix (_tmp9_, "\\");
		_tmp7_ = _tmp10_;
	}
	if (_tmp7_) {
		GtkSourceCompletionProposal* _tmp11_;
		GtkTextIter _tmp12_;
		const gchar* _tmp13_;
		_tmp11_ = proposal;
		_tmp12_ = *iter;
		_tmp13_ = cmd;
		completion_provider_activate_proposal_command_name (self, _tmp11_, &_tmp12_, _tmp13_);
	} else {
		CompletionProviderArgumentContext info = {0};
		GtkTextIter _tmp14_;
		CompletionProviderArgumentContext _tmp15_ = {0};
		gboolean _tmp16_;
		_tmp14_ = *iter;
		_tmp16_ = completion_provider_in_latex_command_argument (self, &_tmp14_, &_tmp15_);
		completion_provider_argument_context_destroy (&info);
		info = _tmp15_;
		if (_tmp16_) {
			GtkSourceCompletionProposal* _tmp17_;
			GtkTextIter _tmp18_;
			CompletionProviderArgumentContext _tmp19_;
			const gchar* _tmp20_;
			CompletionProviderArgumentContext _tmp21_;
			const gchar* _tmp22_;
			_tmp17_ = proposal;
			_tmp18_ = *iter;
			_tmp19_ = info;
			_tmp20_ = _tmp19_.cmd_name;
			_tmp21_ = info;
			_tmp22_ = _tmp21_.arg_contents;
			completion_provider_activate_proposal_argument_choice (self, _tmp17_, &_tmp18_, _tmp20_, _tmp22_);
		} else {
			g_warning ("completion.vala:421: Not in a LaTeX command argument.");
		}
		completion_provider_argument_context_destroy (&info);
	}
	result = TRUE;
	_g_free0 (cmd);
	_g_free0 (text);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd) {
	gchar* text = NULL;
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp7_;
	glong _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextMark* old_pos_mark = NULL;
	GtkTextBuffer* _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextMark* _tmp17_;
	GtkTextMark* _tmp18_;
	GtkTextBuffer* _tmp19_;
	GtkTextBuffer* _tmp20_;
	const gchar* _tmp21_;
	GtkTextBuffer* _tmp22_;
	GtkTextIter old_pos_iter = {0};
	GtkTextBuffer* _tmp23_;
	GtkTextMark* _tmp24_;
	GtkTextIter _tmp25_ = {0};
	GtkTextBuffer* _tmp26_;
	GtkTextMark* _tmp27_;
	GtkTextIter match_end = {0};
	GtkTextIter _tmp28_;
	GtkTextIter _tmp29_ = {0};
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = cmd;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = cmd;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	index_start = (glong) _tmp2_;
	_tmp7_ = text;
	_tmp8_ = index_start;
	_tmp9_ = text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp7_, _tmp8_, (glong) _tmp11_);
	text_to_insert = _tmp12_;
	_tmp13_ = gtk_text_iter_get_buffer (iter);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	doc = _tmp14_;
	_tmp15_ = doc;
	_tmp16_ = *iter;
	_tmp17_ = gtk_text_buffer_create_mark (_tmp15_, NULL, &_tmp16_, TRUE);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	old_pos_mark = _tmp18_;
	_tmp19_ = doc;
	gtk_text_buffer_begin_user_action (_tmp19_);
	_tmp20_ = doc;
	_tmp21_ = text_to_insert;
	gtk_text_buffer_insert (_tmp20_, iter, _tmp21_, -1);
	_tmp22_ = doc;
	gtk_text_buffer_end_user_action (_tmp22_);
	_tmp23_ = doc;
	_tmp24_ = old_pos_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp23_, &_tmp25_, _tmp24_);
	old_pos_iter = _tmp25_;
	_tmp26_ = doc;
	_tmp27_ = old_pos_mark;
	gtk_text_buffer_delete_mark (_tmp26_, _tmp27_);
	_tmp28_ = *iter;
	_tmp30_ = gtk_text_iter_forward_search (&old_pos_iter, "{", GTK_TEXT_SEARCH_TEXT_ONLY | GTK_TEXT_SEARCH_VISIBLE_ONLY, NULL, &_tmp29_, &_tmp28_);
	match_end = _tmp29_;
	if (_tmp30_) {
		GtkTextBuffer* _tmp31_;
		GtkTextIter _tmp32_;
		_tmp31_ = doc;
		_tmp32_ = match_end;
		gtk_text_buffer_place_cursor (_tmp31_, &_tmp32_);
	}
	_g_object_unref0 (old_pos_mark);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* arg_cmd, const gchar* arg_contents) {
	gchar* text = NULL;
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp7_;
	glong _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GtkTextBuffer* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (arg_cmd != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = arg_contents;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = arg_contents;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	index_start = (glong) _tmp2_;
	_tmp7_ = text;
	_tmp8_ = index_start;
	_tmp9_ = text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp7_, _tmp8_, (glong) _tmp11_);
	text_to_insert = _tmp12_;
	_tmp13_ = gtk_text_iter_get_buffer (iter);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	doc = _tmp14_;
	_tmp15_ = doc;
	gtk_text_buffer_begin_user_action (_tmp15_);
	_tmp16_ = doc;
	_tmp17_ = text_to_insert;
	gtk_text_buffer_insert (_tmp16_, iter, _tmp17_, -1);
	_tmp18_ = arg_cmd;
	if (g_strcmp0 (_tmp18_, "\\begin") == 0) {
		gunichar _tmp19_;
		GtkTextBuffer* _tmp21_;
		GtkTextBuffer* _tmp22_;
		const gchar* _tmp23_;
		GtkTextIter _tmp24_;
		_tmp19_ = gtk_text_iter_get_char (iter);
		if (_tmp19_ == ((gunichar) '}')) {
			gtk_text_iter_forward_char (iter);
		} else {
			GtkTextBuffer* _tmp20_;
			_tmp20_ = doc;
			gtk_text_buffer_insert (_tmp20_, iter, "}", -1);
		}
		_tmp21_ = doc;
		gtk_text_buffer_end_user_action (_tmp21_);
		_tmp22_ = doc;
		gtk_text_buffer_begin_user_action (_tmp22_);
		_tmp23_ = text;
		_tmp24_ = *iter;
		completion_provider_close_environment (self, _tmp23_, &_tmp24_);
	} else {
	}
	_tmp25_ = doc;
	gtk_text_buffer_end_user_action (_tmp25_);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter) {
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gchar* cur_indent = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar* indent = NULL;
	Document* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentView* _tmp6_;
	DocumentView* _tmp7_;
	gchar* _tmp8_;
	CompletionProviderCompletionChoice* env = NULL;
	GeeHashMap* _tmp9_;
	const gchar* _tmp10_;
	gpointer _tmp11_;
	Document* _tmp12_;
	Document* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	CompletionProviderCompletionChoice* _tmp21_;
	GtkTextMark* cursor_pos = NULL;
	Document* _tmp27_;
	GtkTextIter _tmp28_;
	GtkTextMark* _tmp29_;
	GtkTextMark* _tmp30_;
	gboolean _tmp31_ = FALSE;
	CompletionProviderCompletionChoice* _tmp32_;
	Document* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	Document* _tmp45_;
	GtkTextMark* _tmp46_;
	GtkTextIter _tmp47_ = {0};
	Document* _tmp48_;
	GtkTextMark* _tmp49_;
	Document* _tmp50_;
	GtkTextIter _tmp51_;
	Document* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (env_name != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = *iter;
	_tmp3_ = tepl_iter_get_line_indentation (&_tmp2_);
	cur_indent = _tmp3_;
	_tmp4_ = doc;
	_tmp5_ = _tmp4_->tab;
	_tmp6_ = document_tab_get_document_view (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_view_get_indentation_style (_tmp7_);
	indent = _tmp8_;
	_tmp9_ = self->priv->_environments;
	_tmp10_ = env_name;
	_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
	env = (CompletionProviderCompletionChoice*) _tmp11_;
	_tmp12_ = doc;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp12_);
	_tmp13_ = doc;
	_tmp14_ = cur_indent;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = indent;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("\n", _tmp15_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	document_insert (_tmp13_, iter, _tmp19_, -1);
	_g_free0 (_tmp19_);
	_tmp21_ = env;
	if (_tmp21_ != NULL) {
		CompletionProviderCompletionChoice* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = env;
		_tmp23_ = (*_tmp22_).insert;
		_tmp20_ = _tmp23_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		Document* _tmp24_;
		CompletionProviderCompletionChoice* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = doc;
		_tmp25_ = env;
		_tmp26_ = (*_tmp25_).insert;
		document_insert (_tmp24_, iter, _tmp26_, -1);
	}
	_tmp27_ = doc;
	_tmp28_ = *iter;
	_tmp29_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp27_, NULL, &_tmp28_, TRUE);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	cursor_pos = _tmp30_;
	_tmp32_ = env;
	if (_tmp32_ != NULL) {
		CompletionProviderCompletionChoice* _tmp33_;
		const gchar* _tmp34_;
		_tmp33_ = env;
		_tmp34_ = (*_tmp33_).insert_after;
		_tmp31_ = _tmp34_ != NULL;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		Document* _tmp35_;
		CompletionProviderCompletionChoice* _tmp36_;
		const gchar* _tmp37_;
		_tmp35_ = doc;
		_tmp36_ = env;
		_tmp37_ = (*_tmp36_).insert_after;
		document_insert (_tmp35_, iter, _tmp37_, -1);
	}
	_tmp38_ = doc;
	_tmp39_ = cur_indent;
	_tmp40_ = string_to_string (_tmp39_);
	_tmp41_ = env_name;
	_tmp42_ = string_to_string (_tmp41_);
	_tmp43_ = g_strconcat ("\n", _tmp40_, "\\end{", _tmp42_, "}", NULL);
	_tmp44_ = _tmp43_;
	document_insert (_tmp38_, iter, _tmp44_, -1);
	_g_free0 (_tmp44_);
	_tmp45_ = doc;
	_tmp46_ = cursor_pos;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp45_, &_tmp47_, _tmp46_);
	*iter = _tmp47_;
	_tmp48_ = doc;
	_tmp49_ = cursor_pos;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp48_, _tmp49_);
	_tmp50_ = doc;
	_tmp51_ = *iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp50_, &_tmp51_);
	_tmp52_ = doc;
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp52_);
	_g_object_unref0 (cursor_pos);
	_completion_provider_completion_choice_free0 (env);
	_g_free0 (indent);
	_g_free0 (cur_indent);
	_g_object_unref0 (doc);
}


/*************************************************************************/
static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		gunichar _tmp4_;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static void completion_provider_get_begin_arg_pos (CompletionProvider* self, GtkTextIter* in_arg_pos, GtkTextIter* result) {
	gchar* text = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gint index = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gunichar cur_char = 0U;
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (in_arg_pos != NULL);
	_tmp0_ = *in_arg_pos;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	index = _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gunichar _tmp10_;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp10_ = cur_char;
		if (_tmp10_ == ((gunichar) '[')) {
			_tmp9_ = TRUE;
		} else {
			gunichar _tmp11_;
			_tmp11_ = cur_char;
			_tmp9_ = _tmp11_ == ((gunichar) '{');
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			gint _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = text;
			_tmp13_ = index;
			_tmp14_ = utils_char_is_escaped (_tmp12_, (glong) _tmp13_);
			_tmp8_ = !_tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			break;
		}
	}
	_tmp15_ = *in_arg_pos;
	begin_arg_pos = _tmp15_;
	_tmp16_ = index;
	gtk_text_iter_set_visible_line_index (&begin_arg_pos, _tmp16_);
	gtk_text_iter_forward_char (&begin_arg_pos);
	*result = begin_arg_pos;
	_g_free0 (text);
	return;
}


static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gchar* text = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = strlen (text);
	_tmp3_ = _tmp2_;
	_tmp4_ = completion_provider_get_latex_command_at_index (self, text, _tmp3_);
	result = _tmp4_;
	_g_free0 (text);
	return result;
}


static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, gint index) {
	gchar* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint cur_index = 0;
	gint _tmp4_;
	gunichar cur_char = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (_tmp0_ <= _tmp3_, NULL);
	_tmp4_ = index;
	cur_index = _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_;
		gunichar _tmp8_;
		gboolean _tmp16_ = FALSE;
		gunichar _tmp17_;
		gboolean _tmp18_;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &cur_index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = cur_char;
		if (_tmp8_ == ((gunichar) '\\')) {
			const gchar* _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = text;
			_tmp10_ = cur_index;
			_tmp11_ = utils_char_is_escaped (_tmp9_, (glong) _tmp10_);
			if (_tmp11_) {
				break;
			}
			_tmp12_ = text;
			_tmp13_ = cur_index;
			_tmp14_ = index;
			_tmp15_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp14_);
			result = _tmp15_;
			return result;
		}
		_tmp17_ = cur_char;
		_tmp18_ = g_unichar_isalpha (_tmp17_);
		if (!_tmp18_) {
			gunichar _tmp19_;
			_tmp19_ = cur_char;
			_tmp16_ = _tmp19_ != ((gunichar) '*');
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			break;
		}
	}
	result = NULL;
	return result;
}


static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, CompletionProviderArgumentContext* info) {
	CompletionProviderArgumentContext _vala_info = {0};
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gchar* text = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint last_index = 0;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cur_index = 0;
	gint _tmp6_;
	gboolean in_prev_arg = FALSE;
	gunichar prev_arg_opening_bracket = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	completion_provider_argument_context_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (CompletionProviderArgumentContext));
	_g_free0 (_vala_info.cmd_name);
	_vala_info.cmd_name = NULL;
	_g_free0 (_vala_info.arg_contents);
	_vala_info.arg_contents = NULL;
	_tmp0_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_vala_info.args_types);
	_vala_info.args_types = _tmp0_;
	_tmp1_ = *iter;
	_tmp2_ = completion_provider_get_text_line_to_iter (self, &_tmp1_);
	text = _tmp2_;
	_tmp3_ = text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	last_index = _tmp5_;
	_tmp6_ = last_index;
	cur_index = _tmp6_;
	while (TRUE) {
		gunichar cur_char = 0U;
		const gchar* _tmp7_;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_;
		gboolean _tmp10_ = FALSE;
		gunichar _tmp11_;
		gboolean opening_bracket = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_;
		_tmp7_ = text;
		_tmp9_ = string_get_prev_char (_tmp7_, &cur_index, &_tmp8_);
		cur_char = _tmp8_;
		if (!_tmp9_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		_tmp11_ = cur_char;
		if (_tmp11_ == ((gunichar) '{')) {
			_tmp10_ = TRUE;
		} else {
			gunichar _tmp12_;
			_tmp12_ = cur_char;
			_tmp10_ = _tmp12_ == ((gunichar) '[');
		}
		opening_bracket = _tmp10_;
		_tmp14_ = opening_bracket;
		if (_tmp14_) {
			const gchar* _tmp15_;
			gint _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = text;
			_tmp16_ = cur_index;
			_tmp17_ = utils_char_is_escaped (_tmp15_, (glong) _tmp16_);
			_tmp13_ = !_tmp17_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			CompletionProviderArgumentContext _tmp18_;
			GeeArrayList* _tmp19_;
			gunichar _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gchar* _tmp24_;
			_tmp18_ = _vala_info;
			_tmp19_ = _tmp18_.args_types;
			_tmp20_ = cur_char;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp19_, 0, (gpointer) ((gintptr) (_tmp20_ == ((gunichar) '['))));
			_tmp21_ = text;
			_tmp22_ = cur_index;
			_tmp23_ = last_index;
			_tmp24_ = string_slice (_tmp21_, (glong) (_tmp22_ + 1), (glong) _tmp23_);
			_g_free0 (_vala_info.arg_contents);
			_vala_info.arg_contents = _tmp24_;
			break;
		}
	}
	in_prev_arg = FALSE;
	prev_arg_opening_bracket = (gunichar) '{';
	while (TRUE) {
		gunichar cur_char = 0U;
		const gchar* _tmp25_;
		gunichar _tmp26_ = 0U;
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp25_ = text;
		_tmp27_ = string_get_prev_char (_tmp25_, &cur_index, &_tmp26_);
		cur_char = _tmp26_;
		if (!_tmp27_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		_tmp28_ = in_prev_arg;
		if (_tmp28_) {
			gunichar _tmp29_;
			gunichar _tmp30_;
			_tmp29_ = cur_char;
			_tmp30_ = prev_arg_opening_bracket;
			if (_tmp29_ == _tmp30_) {
				const gchar* _tmp31_;
				gint _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = text;
				_tmp32_ = cur_index;
				_tmp33_ = utils_char_is_escaped (_tmp31_, (glong) _tmp32_);
				in_prev_arg = _tmp33_;
			}
		} else {
			gboolean _tmp34_ = FALSE;
			gunichar _tmp35_;
			_tmp35_ = cur_char;
			if (_tmp35_ == ((gunichar) '}')) {
				_tmp34_ = TRUE;
			} else {
				gunichar _tmp36_;
				_tmp36_ = cur_char;
				_tmp34_ = _tmp36_ == ((gunichar) ']');
			}
			if (_tmp34_) {
				const gchar* _tmp37_;
				gint _tmp38_;
				gboolean _tmp39_;
				gchar _tmp40_ = '\0';
				gunichar _tmp41_;
				CompletionProviderArgumentContext _tmp42_;
				GeeArrayList* _tmp43_;
				gunichar _tmp44_;
				_tmp37_ = text;
				_tmp38_ = cur_index;
				_tmp39_ = utils_char_is_escaped (_tmp37_, (glong) _tmp38_);
				if (_tmp39_) {
					result = FALSE;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				}
				in_prev_arg = TRUE;
				_tmp41_ = cur_char;
				if (_tmp41_ == ((gunichar) '}')) {
					_tmp40_ = '{';
				} else {
					_tmp40_ = '[';
				}
				prev_arg_opening_bracket = (gunichar) _tmp40_;
				_tmp42_ = _vala_info;
				_tmp43_ = _tmp42_.args_types;
				_tmp44_ = cur_char;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp43_, 0, (gpointer) ((gintptr) (_tmp44_ == ((gunichar) ']'))));
			} else {
				gboolean _tmp45_ = FALSE;
				gunichar _tmp46_;
				gboolean _tmp47_;
				_tmp46_ = cur_char;
				_tmp47_ = g_unichar_isalpha (_tmp46_);
				if (_tmp47_) {
					_tmp45_ = TRUE;
				} else {
					gunichar _tmp48_;
					_tmp48_ = cur_char;
					_tmp45_ = _tmp48_ == ((gunichar) '*');
				}
				if (_tmp45_) {
					const gchar* _tmp49_;
					gint _tmp50_;
					gchar* _tmp51_;
					CompletionProviderArgumentContext _tmp52_;
					const gchar* _tmp53_;
					_tmp49_ = text;
					_tmp50_ = cur_index;
					_tmp51_ = completion_provider_get_latex_command_at_index (self, _tmp49_, _tmp50_ + 1);
					_g_free0 (_vala_info.cmd_name);
					_vala_info.cmd_name = _tmp51_;
					_tmp52_ = _vala_info;
					_tmp53_ = _tmp52_.cmd_name;
					result = _tmp53_ != NULL;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				} else {
					gunichar _tmp54_;
					gboolean _tmp55_;
					_tmp54_ = cur_char;
					_tmp55_ = g_unichar_isspace (_tmp54_);
					if (!_tmp55_) {
						result = FALSE;
						_g_free0 (text);
						if (info) {
							*info = _vala_info;
						} else {
							completion_provider_argument_context_destroy (&_vala_info);
						}
						return result;
					}
				}
			}
		}
	}
	_g_free0 (text);
	if (info) {
		*info = _vala_info;
	} else {
		completion_provider_argument_context_destroy (&_vala_info);
	}
}


/*************************************************************************/
static gboolean completion_provider_is_user_request (CompletionProvider* self, GtkSourceCompletionContext* context) {
	gboolean result = FALSE;
	GtkSourceCompletionContext* _tmp0_;
	GtkSourceCompletionActivation _tmp1_;
	GtkSourceCompletionActivation _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	g_object_get (_tmp0_, "activation", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}


static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b) {
	gint result = 0;
	GtkSourceCompletionItem* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkSourceCompletionItem* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	g_object_get (_tmp0_, "text", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	g_object_get (_tmp4_, "text", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate (_tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gint line = 0;
	gint _tmp0_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter iter_start = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = gtk_text_iter_get_buffer (iter);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	gtk_text_buffer_get_iter_at_line (doc, &_tmp3_, line);
	iter_start = _tmp3_;
	_tmp4_ = iter_start;
	_tmp5_ = *iter;
	_tmp6_ = gtk_text_buffer_get_text (doc, &_tmp4_, &_tmp5_, FALSE);
	result = _tmp6_;
	_g_object_unref0 (doc);
	return result;
}


static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint cur_arg) {
	gchar* result = NULL;
	gchar* info = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionCommand _tmp33_;
	const gchar* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	info = _tmp2_;
	arg_num = 1;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				gint _tmp6_;
				gint _tmp7_;
				CompletionProviderCompletionArgument _tmp10_;
				gboolean _tmp11_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp32_;
				_tmp6_ = arg_num;
				_tmp7_ = cur_arg;
				if (_tmp6_ == _tmp7_) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = info;
					_tmp9_ = g_strconcat (_tmp8_, "<b>", NULL);
					_g_free0 (info);
					info = _tmp9_;
				}
				_tmp10_ = arg;
				_tmp11_ = _tmp10_.optional;
				if (_tmp11_) {
					const gchar* _tmp12_;
					CompletionProviderCompletionArgument _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp12_ = info;
					_tmp13_ = arg;
					_tmp14_ = _tmp13_.label;
					_tmp15_ = g_strconcat ("[", _tmp14_, NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp16_, "]", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
					_g_free0 (info);
					info = _tmp19_;
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
				} else {
					const gchar* _tmp20_;
					CompletionProviderCompletionArgument _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp20_ = info;
					_tmp21_ = arg;
					_tmp22_ = _tmp21_.label;
					_tmp23_ = g_strconcat ("{", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "}", NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
					_g_free0 (info);
					info = _tmp27_;
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
				}
				_tmp28_ = arg_num;
				_tmp29_ = cur_arg;
				if (_tmp28_ == _tmp29_) {
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp30_ = info;
					_tmp31_ = g_strconcat (_tmp30_, "</b>", NULL);
					_g_free0 (info);
					info = _tmp31_;
				}
				_tmp32_ = arg_num;
				arg_num = _tmp32_ + 1;
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	_tmp33_ = *cmd;
	_tmp34_ = _tmp33_.package;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		CompletionProviderCompletionCommand _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp35_ = info;
		_tmp36_ = *cmd;
		_tmp37_ = _tmp36_.package;
		_tmp38_ = g_strconcat ("\nPackage: ", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
		_g_free0 (info);
		info = _tmp40_;
		_g_free0 (_tmp39_);
	}
	result = info;
	return result;
}


static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args) {
	gint result = 0;
	CompletionProviderCompletionArgument* _tmp0_;
	gint _tmp0__length1;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint num = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (args != NULL, 0);
	_tmp0_ = all_args;
	_tmp0__length1 = all_args_length1;
	_tmp1_ = args;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0__length1 < _tmp3_) {
		result = -1;
		return result;
	}
	num = 0;
	{
		GeeArrayList* _arg_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _arg_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp4_ = args;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gboolean arg = FALSE;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			gint _tmp27_;
			_tmp9_ = _arg_index;
			_arg_index = _tmp9_ + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = _arg_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			arg = (gboolean) ((gintptr) _tmp14_);
			while (TRUE) {
				CompletionProviderCompletionArgument* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				CompletionProviderCompletionArgument* _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				CompletionProviderCompletionArgument _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				gint _tmp26_;
				_tmp15_ = all_args;
				_tmp15__length1 = all_args_length1;
				_tmp16_ = num;
				if (_tmp15__length1 <= _tmp16_) {
					result = -1;
					_g_object_unref0 (_arg_list);
					return result;
				}
				_tmp17_ = all_args;
				_tmp17__length1 = all_args_length1;
				_tmp18_ = num;
				_tmp19_ = _tmp17_[_tmp18_];
				_tmp20_ = _tmp19_.optional;
				_tmp21_ = arg;
				if (_tmp20_ == _tmp21_) {
					break;
				} else {
					CompletionProviderCompletionArgument* _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					CompletionProviderCompletionArgument _tmp24_;
					gboolean _tmp25_;
					_tmp22_ = all_args;
					_tmp22__length1 = all_args_length1;
					_tmp23_ = num;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = _tmp24_.optional;
					if (!_tmp25_) {
						result = -1;
						_g_object_unref0 (_arg_list);
						return result;
					}
				}
				_tmp26_ = num;
				num = _tmp26_ + 1;
			}
			_tmp27_ = num;
			num = _tmp27_ + 1;
		}
		_g_object_unref0 (_arg_list);
	}
	result = num;
	return result;
}


static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self, CompletionProviderCompletionCommand* cmd) {
	gchar* result = NULL;
	gchar* text_to_insert = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	text_to_insert = _tmp2_;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				CompletionProviderCompletionArgument _tmp6_;
				gboolean _tmp7_;
				_tmp6_ = arg;
				_tmp7_ = _tmp6_.optional;
				if (!_tmp7_) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = text_to_insert;
					_tmp9_ = g_strconcat (_tmp8_, "{}", NULL);
					_g_free0 (text_to_insert);
					text_to_insert = _tmp9_;
				}
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	result = text_to_insert;
	return result;
}


/*************************************************************************/
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	completion_provider_parser_start ((CompletionProvider*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	completion_provider_parser_end ((CompletionProvider*) self, context, element_name, error);
}


static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	completion_provider_parser_text ((CompletionProvider*) self, context, text, text_len, error);
}


static void completion_provider_load_data (CompletionProvider* self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* file = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* contents = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND, (GBoxedCopyFunc) completion_provider_completion_command_dup, (GDestroyNotify) completion_provider_completion_command_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_commands);
	self->priv->_commands = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE, (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GDestroyNotify) completion_provider_completion_choice_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_environments);
	self->priv->_environments = _tmp1_;
	_tmp2_ = g_build_filename (DATA_DIR, "completion.xml", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file = _tmp5_;
	_tmp6_ = file;
	_tmp7_ = utils_load_file (_tmp6_);
	contents = _tmp7_;
	_tmp8_ = contents;
	if (_tmp8_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp9_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp10_;
		GMarkupParseContext* _tmp11_;
		GMarkupParseContext* _tmp12_;
		const gchar* _tmp13_;
		_tmp9_.start_element = _completion_provider_parser_start_gmarkup_parser_start_element_func;
		_tmp9_.end_element = _completion_provider_parser_end_gmarkup_parser_end_element_func;
		_tmp9_.text = _completion_provider_parser_text_gmarkup_parser_text_func;
		_tmp9_.passthrough = NULL;
		_tmp9_.error = NULL;
		parser = _tmp9_;
		_tmp10_ = parser;
		_tmp11_ = g_markup_parse_context_new (&_tmp10_, 0, self, NULL);
		context = _tmp11_;
		_tmp12_ = context;
		_tmp13_ = contents;
		g_markup_parse_context_parse (_tmp12_, _tmp13_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch2_g_error;
		}
		self->priv->_proposals = g_list_sort (self->priv->_proposals, (GCompareFunc) completion_provider_compare_proposals);
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("completion.vala:804: Impossible to load completion data: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
}


static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("commands")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_values;
				_tmp5__length1 = attr_values_length1;
				completion_provider_parser_add_command (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp5__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				_tmp6_ = attr_names;
				_tmp6__length1 = attr_names_length1;
				_tmp7_ = attr_values;
				_tmp7__length1 = attr_values_length1;
				completion_provider_parser_add_argument (self, _tmp6_, _tmp6__length1, _tmp7_, _tmp7__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp8_ = attr_names;
				_tmp8__length1 = attr_names_length1;
				_tmp9_ = attr_values;
				_tmp9__length1 = attr_values_length1;
				completion_provider_parser_add_choice (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp9__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("insert")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("insert_after"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("placeholder")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("component"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GError* _tmp15_;
				GError* _tmp16_;
				_tmp10_ = name;
				_tmp11_ = g_strconcat ("unknown element \"", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_inner_error_ = _tmp16_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void completion_provider_parser_add_command (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	memset (&self->priv->_current_command, 0, sizeof (CompletionProviderCompletionCommand));
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar** _tmp3_;
				gint _tmp3__length1;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				static GQuark _tmp8_label2 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attr_num;
				_tmp3_ = attr_names;
				_tmp3__length1 = attr_names_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_num;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							gchar** _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp10_ = attr_values;
							_tmp10__length1 = attr_values_length1;
							_tmp11_ = attr_num;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = g_strconcat ("\\", _tmp12_, NULL);
							_g_free0 (self->priv->_current_command.name);
							self->priv->_current_command.name = _tmp13_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							gchar** _tmp14_;
							gint _tmp14__length1;
							gint _tmp15_;
							const gchar* _tmp16_;
							gchar* _tmp17_;
							_tmp14_ = attr_values;
							_tmp14__length1 = attr_values_length1;
							_tmp15_ = attr_num;
							_tmp16_ = _tmp14_[_tmp15_];
							_tmp17_ = g_strdup (_tmp16_);
							_g_free0 (self->priv->_current_command.package);
							self->priv->_current_command.package = _tmp17_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("environment")))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp18_;
							gint _tmp18__length1;
							gint _tmp19_;
							const gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							GError* _tmp25_;
							GError* _tmp26_;
							_tmp18_ = attr_names;
							_tmp18__length1 = attr_names_length1;
							_tmp19_ = attr_num;
							_tmp20_ = _tmp18_[_tmp19_];
							_tmp21_ = g_strconcat ("unknown command attribute \"", _tmp20_, NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (_tmp22_, "\"", NULL);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (_tmp24_);
							_g_free0 (_tmp22_);
							_inner_error_ = _tmp26_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void completion_provider_parser_add_argument (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	memset (&self->priv->_current_arg, 0, sizeof (CompletionProviderCompletionArgument));
	self->priv->_current_arg.optional = FALSE;
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar** _tmp3_;
				gint _tmp3__length1;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attr_num;
				_tmp3_ = attr_names;
				_tmp3__length1 = attr_names_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_num;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("label")))) {
					switch (0) {
						default:
						{
							gchar** _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp10_ = attr_values;
							_tmp10__length1 = attr_values_length1;
							_tmp11_ = attr_num;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = g_strdup (_tmp12_);
							_g_free0 (self->priv->_current_arg.label);
							self->priv->_current_arg.label = _tmp13_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("type")))) {
					switch (0) {
						default:
						{
							gchar** _tmp14_;
							gint _tmp14__length1;
							gint _tmp15_;
							const gchar* _tmp16_;
							_tmp14_ = attr_values;
							_tmp14__length1 = attr_values_length1;
							_tmp15_ = attr_num;
							_tmp16_ = _tmp14_[_tmp15_];
							self->priv->_current_arg.optional = g_strcmp0 (_tmp16_, "optional") == 0;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp17_;
							gint _tmp17__length1;
							gint _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							GError* _tmp24_;
							GError* _tmp25_;
							_tmp17_ = attr_names;
							_tmp17__length1 = attr_names_length1;
							_tmp18_ = attr_num;
							_tmp19_ = _tmp17_[_tmp18_];
							_tmp20_ = g_strconcat ("unknown argument attribute \"", _tmp19_, NULL);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_strconcat (_tmp21_, "\"", NULL);
							_tmp23_ = _tmp22_;
							_tmp24_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp23_);
							_tmp25_ = _tmp24_;
							_g_free0 (_tmp23_);
							_g_free0 (_tmp21_);
							_inner_error_ = _tmp25_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void completion_provider_parser_add_choice (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	memset (&self->priv->_current_choice, 0, sizeof (CompletionProviderCompletionChoice));
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar** _tmp3_;
				gint _tmp3__length1;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attr_num;
				_tmp3_ = attr_names;
				_tmp3__length1 = attr_names_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_num;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							gchar** _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp10_ = attr_values;
							_tmp10__length1 = attr_values_length1;
							_tmp11_ = attr_num;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = g_strdup (_tmp12_);
							_g_free0 (self->priv->_current_choice.name);
							self->priv->_current_choice.name = _tmp13_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							gchar** _tmp14_;
							gint _tmp14__length1;
							gint _tmp15_;
							const gchar* _tmp16_;
							gchar* _tmp17_;
							_tmp14_ = attr_values;
							_tmp14__length1 = attr_values_length1;
							_tmp15_ = attr_num;
							_tmp16_ = _tmp14_[_tmp15_];
							_tmp17_ = g_strdup (_tmp16_);
							_g_free0 (self->priv->_current_choice.package);
							self->priv->_current_choice.package = _tmp17_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp18_;
							gint _tmp18__length1;
							gint _tmp19_;
							const gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							GError* _tmp25_;
							GError* _tmp26_;
							_tmp18_ = attr_names;
							_tmp18__length1 = attr_names_length1;
							_tmp19_ = attr_num;
							_tmp20_ = _tmp18_[_tmp19_];
							_tmp21_ = g_strconcat ("unknown choice attribute \"", _tmp20_, NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (_tmp22_, "\"", NULL);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (_tmp24_);
							_g_free0 (_tmp22_);
							_inner_error_ = _tmp26_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_add2 (CompletionProviderCompletionArgument* * array, int* length, int* size, const CompletionProviderCompletionArgument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionArgument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add3 (CompletionProviderCompletionChoice* * array, int* length, int* size, const CompletionProviderCompletionChoice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionChoice, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				GdkPixbuf* _tmp4_ = NULL;
				CompletionProviderCompletionCommand _tmp5_;
				const gchar* _tmp6_;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp9_;
				GtkSourceCompletionItem* item = NULL;
				GtkSourceCompletionItem* _tmp10_;
				GtkSourceCompletionItem* _tmp11_;
				CompletionProviderCompletionCommand _tmp12_;
				const gchar* _tmp13_;
				GtkSourceCompletionItem* _tmp14_;
				CompletionProviderCompletionCommand _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GtkSourceCompletionItem* _tmp18_;
				GdkPixbuf* _tmp19_;
				GtkSourceCompletionItem* _tmp20_;
				CompletionProviderCompletionCommand _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GtkSourceCompletionItem* _tmp24_;
				GtkSourceCompletionItem* _tmp25_;
				CompletionProviderCompletionCommand _tmp26_;
				CompletionProviderCompletionArgument* _tmp27_;
				gint _tmp27__length1;
				_tmp5_ = self->priv->_current_command;
				_tmp6_ = _tmp5_.package;
				if (_tmp6_ != NULL) {
					GdkPixbuf* _tmp7_;
					_tmp7_ = self->priv->_icon_package_required;
					_tmp4_ = _tmp7_;
				} else {
					GdkPixbuf* _tmp8_;
					_tmp8_ = self->priv->_icon_cmd;
					_tmp4_ = _tmp8_;
				}
				_tmp9_ = _g_object_ref0 (_tmp4_);
				pixbuf = _tmp9_;
				_tmp10_ = gtk_source_completion_item_new2 ();
				item = _tmp10_;
				_tmp11_ = item;
				_tmp12_ = self->priv->_current_command;
				_tmp13_ = _tmp12_.name;
				gtk_source_completion_item_set_label (_tmp11_, _tmp13_);
				_tmp14_ = item;
				_tmp15_ = self->priv->_current_command;
				_tmp16_ = completion_provider_get_command_text_to_insert (self, &_tmp15_);
				_tmp17_ = _tmp16_;
				gtk_source_completion_item_set_text (_tmp14_, _tmp17_);
				_g_free0 (_tmp17_);
				_tmp18_ = item;
				_tmp19_ = pixbuf;
				gtk_source_completion_item_set_icon (_tmp18_, _tmp19_);
				_tmp20_ = item;
				_tmp21_ = self->priv->_current_command;
				_tmp22_ = completion_provider_get_command_info (self, &_tmp21_, -1);
				_tmp23_ = _tmp22_;
				gtk_source_completion_item_set_info (_tmp20_, _tmp23_);
				_g_free0 (_tmp23_);
				_tmp24_ = item;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				self->priv->_proposals = g_list_prepend (self->priv->_proposals, _tmp25_);
				_tmp26_ = self->priv->_current_command;
				_tmp27_ = _tmp26_.args;
				_tmp27__length1 = _tmp26_.args_length1;
				if (0 < _tmp27__length1) {
					GeeHashMap* _tmp28_;
					CompletionProviderCompletionCommand _tmp29_;
					const gchar* _tmp30_;
					CompletionProviderCompletionCommand _tmp31_;
					_tmp28_ = self->priv->_commands;
					_tmp29_ = self->priv->_current_command;
					_tmp30_ = _tmp29_.name;
					_tmp31_ = self->priv->_current_command;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp30_, &_tmp31_);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (pixbuf);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionArgument* _tmp32_;
				gint _tmp32__length1;
				CompletionProviderCompletionArgument _tmp33_;
				CompletionProviderCompletionArgument _tmp34_ = {0};
				_tmp32_ = self->priv->_current_command.args;
				_tmp32__length1 = self->priv->_current_command.args_length1;
				_tmp33_ = self->priv->_current_arg;
				completion_provider_completion_argument_copy (&_tmp33_, &_tmp34_);
				_vala_array_add2 (&self->priv->_current_command.args, &self->priv->_current_command.args_length1, &self->priv->_current_command._args_size_, &_tmp34_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionChoice* _tmp35_;
				gint _tmp35__length1;
				CompletionProviderCompletionChoice _tmp36_;
				CompletionProviderCompletionChoice _tmp37_ = {0};
				gboolean _tmp38_ = FALSE;
				CompletionProviderCompletionChoice _tmp39_;
				const gchar* _tmp40_;
				_tmp35_ = self->priv->_current_arg.choices;
				_tmp35__length1 = self->priv->_current_arg.choices_length1;
				_tmp36_ = self->priv->_current_choice;
				completion_provider_completion_choice_copy (&_tmp36_, &_tmp37_);
				_vala_array_add3 (&self->priv->_current_arg.choices, &self->priv->_current_arg.choices_length1, &self->priv->_current_arg._choices_size_, &_tmp37_);
				_tmp39_ = self->priv->_current_choice;
				_tmp40_ = _tmp39_.insert;
				if (_tmp40_ != NULL) {
					_tmp38_ = TRUE;
				} else {
					CompletionProviderCompletionChoice _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = self->priv->_current_choice;
					_tmp42_ = _tmp41_.insert_after;
					_tmp38_ = _tmp42_ != NULL;
				}
				if (_tmp38_) {
					GeeHashMap* _tmp43_;
					CompletionProviderCompletionChoice _tmp44_;
					const gchar* _tmp45_;
					CompletionProviderCompletionChoice _tmp46_;
					_tmp43_ = self->priv->_environments;
					_tmp44_ = self->priv->_current_choice;
					_tmp45_ = _tmp44_.name;
					_tmp46_ = self->priv->_current_choice;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp43_, _tmp45_, &_tmp46_);
				}
				break;
			}
		}
	}
}


static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("insert")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = text;
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (self->priv->_current_choice.insert);
				self->priv->_current_choice.insert = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("insert_after")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = text;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (self->priv->_current_choice.insert_after);
				self->priv->_current_choice.insert_after = _tmp8_;
				break;
			}
		}
	}
}


static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_argument_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length) {
	CompletionProviderCompletionArgument* result;
	int i;
	result = g_new0 (CompletionProviderCompletionArgument, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionArgument _tmp0_ = {0};
		completion_provider_completion_argument_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionArgument* _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).args;
	_tmp4__length1 = (*self).args_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	(*dest).args = (_vala_CompletionProviderCompletionArgument_array_free ((*dest).args, (*dest).args_length1), NULL);
	(*dest).args = _tmp5_;
	(*dest).args_length1 = _tmp5__length1;
	(*dest)._args_size_ = (*dest).args_length1;
}


static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	(*self).args = (_vala_CompletionProviderCompletionArgument_array_free ((*self).args, (*self).args_length1), NULL);
}


static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self) {
	CompletionProviderCompletionCommand* dup;
	dup = g_new0 (CompletionProviderCompletionCommand, 1);
	completion_provider_completion_command_copy (self, dup);
	return dup;
}


static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self) {
	completion_provider_completion_command_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_command_get_type (void) {
	static volatile gsize completion_provider_completion_command_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_command_type_id__volatile)) {
		GType completion_provider_completion_command_type_id;
		completion_provider_completion_command_type_id = g_boxed_type_register_static ("CompletionProviderCompletionCommand", (GBoxedCopyFunc) completion_provider_completion_command_dup, (GBoxedFreeFunc) completion_provider_completion_command_free);
		g_once_init_leave (&completion_provider_completion_command_type_id__volatile, completion_provider_completion_command_type_id);
	}
	return completion_provider_completion_command_type_id__volatile;
}


static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_choice_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length) {
	CompletionProviderCompletionChoice* result;
	int i;
	result = g_new0 (CompletionProviderCompletionChoice, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionChoice _tmp0_ = {0};
		completion_provider_completion_choice_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	CompletionProviderCompletionChoice* _tmp3_;
	gint _tmp3__length1;
	CompletionProviderCompletionChoice* _tmp4_;
	gint _tmp4__length1;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).optional;
	(*dest).optional = _tmp2_;
	_tmp3_ = (*self).choices;
	_tmp3__length1 = (*self).choices_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*dest).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*dest).choices, (*dest).choices_length1), NULL);
	(*dest).choices = _tmp4_;
	(*dest).choices_length1 = _tmp4__length1;
	(*dest)._choices_size_ = (*dest).choices_length1;
}


static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self) {
	_g_free0 ((*self).label);
	(*self).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*self).choices, (*self).choices_length1), NULL);
}


static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self) {
	CompletionProviderCompletionArgument* dup;
	dup = g_new0 (CompletionProviderCompletionArgument, 1);
	completion_provider_completion_argument_copy (self, dup);
	return dup;
}


static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self) {
	completion_provider_completion_argument_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_argument_get_type (void) {
	static volatile gsize completion_provider_completion_argument_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_argument_type_id__volatile)) {
		GType completion_provider_completion_argument_type_id;
		completion_provider_completion_argument_type_id = g_boxed_type_register_static ("CompletionProviderCompletionArgument", (GBoxedCopyFunc) completion_provider_completion_argument_dup, (GBoxedFreeFunc) completion_provider_completion_argument_free);
		g_once_init_leave (&completion_provider_completion_argument_type_id__volatile, completion_provider_completion_argument_type_id);
	}
	return completion_provider_completion_argument_type_id__volatile;
}


static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).insert;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).insert);
	(*dest).insert = _tmp5_;
	_tmp6_ = (*self).insert_after;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).insert_after);
	(*dest).insert_after = _tmp7_;
}


static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	_g_free0 ((*self).insert);
	_g_free0 ((*self).insert_after);
}


static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self) {
	CompletionProviderCompletionChoice* dup;
	dup = g_new0 (CompletionProviderCompletionChoice, 1);
	completion_provider_completion_choice_copy (self, dup);
	return dup;
}


static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self) {
	completion_provider_completion_choice_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_choice_get_type (void) {
	static volatile gsize completion_provider_completion_choice_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_choice_type_id__volatile)) {
		GType completion_provider_completion_choice_type_id;
		completion_provider_completion_choice_type_id = g_boxed_type_register_static ("CompletionProviderCompletionChoice", (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GBoxedFreeFunc) completion_provider_completion_choice_free);
		g_once_init_leave (&completion_provider_completion_choice_type_id__volatile, completion_provider_completion_choice_type_id);
	}
	return completion_provider_completion_choice_type_id__volatile;
}


static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self, CompletionProviderArgumentContext* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	_tmp0_ = (*self).cmd_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).cmd_name);
	(*dest).cmd_name = _tmp1_;
	_tmp2_ = (*self).arg_contents;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).arg_contents);
	(*dest).arg_contents = _tmp3_;
	_tmp4_ = (*self).args_types;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).args_types);
	(*dest).args_types = _tmp5_;
}


static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self) {
	_g_free0 ((*self).cmd_name);
	_g_free0 ((*self).arg_contents);
	_g_object_unref0 ((*self).args_types);
}


static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self) {
	CompletionProviderArgumentContext* dup;
	dup = g_new0 (CompletionProviderArgumentContext, 1);
	completion_provider_argument_context_copy (self, dup);
	return dup;
}


static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self) {
	completion_provider_argument_context_destroy (self);
	g_free (self);
}


static GType completion_provider_argument_context_get_type (void) {
	static volatile gsize completion_provider_argument_context_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_argument_context_type_id__volatile)) {
		GType completion_provider_argument_context_type_id;
		completion_provider_argument_context_type_id = g_boxed_type_register_static ("CompletionProviderArgumentContext", (GBoxedCopyFunc) completion_provider_argument_context_dup, (GBoxedFreeFunc) completion_provider_argument_context_free);
		g_once_init_leave (&completion_provider_argument_context_type_id__volatile, completion_provider_argument_context_type_id);
	}
	return completion_provider_argument_context_type_id__volatile;
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider *)) completion_provider_real_get_name;
	iface->get_activation = (GtkSourceCompletionActivation (*) (GtkSourceCompletionProvider *)) completion_provider_real_get_activation;
	iface->match = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*)) completion_provider_real_match;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
	iface->populate = (void (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*)) completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
}


static void completion_provider_instance_init (CompletionProvider * self) {
	self->priv = COMPLETION_PROVIDER_GET_PRIVATE (self);
	self->priv->_calltip_window = NULL;
	self->priv->_calltip_window_label = NULL;
}


static void completion_provider_finalize (GObject * obj) {
	CompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROVIDER, CompletionProvider);
	_g_object_unref0 (self->priv->_settings);
	__g_list_free__g_object_unref0_0 (self->priv->_proposals);
	_g_object_unref0 (self->priv->_commands);
	_g_object_unref0 (self->priv->_environments);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	_g_object_unref0 (self->priv->_icon_cmd);
	_g_object_unref0 (self->priv->_icon_choice);
	_g_object_unref0 (self->priv->_icon_package_required);
	_g_object_unref0 (self->priv->_calltip_window);
	_g_object_unref0 (self->priv->_calltip_window_label);
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



