/* This code was generated by generate.  Do not edit. */

#include <gnumeric-config.h>
#include <gnumeric.h>
#include <goffice/goffice.h>
#include <gnm-plugin.h>
#include <func.h>
#include <gnm-i18n.h>
#include <value.h>
#include <mathfunc.h>
#include <sf-dpq.h>
#include "extra.h"

GNM_PLUGIN_MODULE_HEADER;

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dbeta[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DBETA:probability density function of the beta distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("a:the first shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("b:the second scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the beta distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dbeta(0.4,1,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PBETA,R.QBETA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dbeta (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float a = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dbeta (x, a, b, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pbeta[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PBETA:cumulative distribution function of the beta distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("a:the first shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("b:the second scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the beta distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pbeta(0.4,1,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBETA,R.QBETA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pbeta (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float a = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pbeta (x, a, b, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qbeta[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QBETA:probability quantile function of the beta distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("a:the first shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("b:the second scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the beta distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qbeta(0.3,1,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBETA,R.PBETA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qbeta (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float a = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qbeta (p, a, b, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DBINOM:probability density function of the binomial distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the binomial distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dbinom(4,10,0.4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PBINOM,R.QBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dbinom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dbinom (x, n, psuc, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PBINOM:cumulative distribution function of the binomial distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the binomial distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pbinom(4,10,0.4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBINOM,R.QBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pbinom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pbinom (x, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QBINOM:probability quantile function of the binomial distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of trials") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the binomial distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qbinom(0.3,10,0.4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DBINOM,R.PBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qbinom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qbinom (p, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dcauchy[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DCAUCHY:probability density function of the Cauchy distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("location:the center of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dcauchy(1.5,1,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PCAUCHY,R.QCAUCHY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dcauchy (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float location = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dcauchy (x, location, scale, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pcauchy[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PCAUCHY:cumulative distribution function of the Cauchy distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("location:the center of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pcauchy(1.5,1,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCAUCHY,R.QCAUCHY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pcauchy (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float location = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pcauchy (x, location, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qcauchy[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QCAUCHY:probability quantile function of the Cauchy distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("location:the center of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Cauchy distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qcauchy(0.3,1,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCAUCHY,R.PCAUCHY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qcauchy (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float location = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qcauchy (p, location, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dchisq[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DCHISQ:probability density function of the chi-square distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_ODF, F_("A two argument invocation R.DCHISQ(@{x},@{df}) is exported to OpenFormula as CHISQDIST(@{x},@{df},FALSE()).") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dchisq(2.5,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PCHISQ,R.QCHISQ" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dchisq (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float df = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dchisq (x, df, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pchisq[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PCHISQ:cumulative distribution function of the chi-square distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the chi-square distribution.") },
	{ GNM_FUNC_HELP_ODF, F_("A two argument invocation R.PCHISQ(@{x},@{df}) is exported to OpenFormula as CHISQDIST(@{x},@{df}).") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pchisq(2.5,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCHISQ,R.QCHISQ" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pchisq (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float df = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pchisq (x, df, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qchisq[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QCHISQ:probability quantile function of the chi-square distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the chi-square distribution.") },
	{ GNM_FUNC_HELP_ODF, F_("A two argument invocation R.QCHISQ(@{p},@{df}) is exported to OpenFormula as CHISQINV(@{p},@{df}).") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qchisq(0.3,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DCHISQ,R.PCHISQ" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qchisq (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float df = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qchisq (p, df, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dexp[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DEXP:probability density function of the exponential distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the exponential distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dexp(1.5,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PEXP,R.QEXP" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dexp (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dexp (x, scale, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pexp[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PEXP:cumulative distribution function of the exponential distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the exponential distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pexp(1.5,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DEXP,R.QEXP" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pexp (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pexp (x, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qexp[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QEXP:probability quantile function of the exponential distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the exponential distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qexp(0.3,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DEXP,R.PEXP" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qexp (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qexp (p, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_df[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DF:probability density function of the F distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n1:the first number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("n2:the second number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the F distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.df(1.5,2,3)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PF,R.QF" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_df (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n1 = value_get_as_float (args[1]);
	gnm_float n2 = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (df (x, n1, n2, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pf[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PF:cumulative distribution function of the F distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n1:the first number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("n2:the second number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the F distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pf(1.5,2,3)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DF,R.QF" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pf (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n1 = value_get_as_float (args[1]);
	gnm_float n2 = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pf (x, n1, n2, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qf[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QF:probability quantile function of the F distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("n1:the first number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("n2:the second number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the F distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qf(0.3,2,3)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DF,R.PF" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qf (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n1 = value_get_as_float (args[1]);
	gnm_float n2 = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qf (p, n1, n2, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dgamma[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DGAMMA:probability density function of the gamma distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the gamma distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dgamma(3,5,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PGAMMA,R.QGAMMA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dgamma (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dgamma (x, shape, scale, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pgamma[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PGAMMA:cumulative distribution function of the gamma distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the gamma distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pgamma(3,5,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGAMMA,R.QGAMMA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pgamma (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pgamma (x, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qgamma[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QGAMMA:probability quantile function of the gamma distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the gamma distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qgamma(0.3,5,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGAMMA,R.PGAMMA" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qgamma (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qgamma (p, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dgeom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DGEOM:probability density function of the geometric distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the geometric distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dgeom(3,0.2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PGEOM,R.QGEOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dgeom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float psuc = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dgeom (x, psuc, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pgeom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PGEOM:cumulative distribution function of the geometric distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the geometric distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pgeom(3,0.2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGEOM,R.QGEOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pgeom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float psuc = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pgeom (x, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qgeom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QGEOM:probability quantile function of the geometric distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the geometric distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qgeom(0.3,0.2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGEOM,R.PGEOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qgeom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float psuc = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qgeom (p, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dgumbel[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DGUMBEL:probability density function of the Gumbel distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("mu:the location parameter of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("beta:the scale parameter of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Gumbel distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dgumbel(2.5,2,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PGUMBEL,R.QGUMBEL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dgumbel (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float beta = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dgumbel (x, mu, beta, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pgumbel[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PGUMBEL:cumulative distribution function of the Gumbel distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("mu:the location parameter of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("beta:the scale parameter of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Gumbel distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pgumbel(2.5,2,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGUMBEL,R.QGUMBEL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pgumbel (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float beta = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pgumbel (x, mu, beta, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qgumbel[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QGUMBEL:probability quantile function of the Gumbel distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("mu:the location parameter of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("beta:the scale parameter of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Gumbel distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qgumbel(0.3,2,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DGUMBEL,R.PGUMBEL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qgumbel (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float beta = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qgumbel (p, mu, beta, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dhyper[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DHYPER:probability density function of the hypergeometric distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("r:the number of red balls") },
	{ GNM_FUNC_HELP_ARG, F_("b:the number of black balls") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of balls drawn") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dhyper(12,50,450,100)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PHYPER,R.QHYPER" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dhyper (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float r = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gnm_float n = value_get_as_float (args[3]);
	gboolean give_log = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (dhyper (x, r, b, n, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_phyper[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PHYPER:cumulative distribution function of the hypergeometric distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("r:the number of red balls") },
	{ GNM_FUNC_HELP_ARG, F_("b:the number of black balls") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of balls drawn") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.phyper(12,50,450,100)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DHYPER,R.QHYPER" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_phyper (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float r = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gnm_float n = value_get_as_float (args[3]);
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (phyper (x, r, b, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qhyper[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QHYPER:probability quantile function of the hypergeometric distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("r:the number of red balls") },
	{ GNM_FUNC_HELP_ARG, F_("b:the number of black balls") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of balls drawn") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the hypergeometric distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qhyper(0.3,50,450,100)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DHYPER,R.PHYPER" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qhyper (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float r = value_get_as_float (args[1]);
	gnm_float b = value_get_as_float (args[2]);
	gnm_float n = value_get_as_float (args[3]);
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (qhyper (p, r, b, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dlnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DLNORM:probability density function of the log-normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("logmean:mean of the underlying normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("logsd:standard deviation of the underlying normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dlnorm(2.5,1,2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PLNORM,R.QLNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dlnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float logmean = value_get_as_float (args[1]);
	gnm_float logsd = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dlnorm (x, logmean, logsd, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_plnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PLNORM:cumulative distribution function of the log-normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("logmean:mean of the underlying normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("logsd:standard deviation of the underlying normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the log-normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.plnorm(2.5,1,2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DLNORM,R.QLNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_plnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float logmean = value_get_as_float (args[1]);
	gnm_float logsd = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (plnorm (x, logmean, logsd, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qlnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QLNORM:probability quantile function of the log-normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("logmean:mean of the underlying normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("logsd:standard deviation of the underlying normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the log-normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qlnorm(0.3,1,2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DLNORM,R.PLNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qlnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float logmean = value_get_as_float (args[1]);
	gnm_float logsd = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qlnorm (p, logmean, logsd, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dnbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DNBINOM:probability density function of the negative binomial distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation (number of failures)") },
	{ GNM_FUNC_HELP_ARG, F_("n:required number of successes") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dnbinom(8,10,0.45)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PNBINOM,R.QNBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dnbinom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dnbinom (x, n, psuc, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pnbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PNBINOM:cumulative distribution function of the negative binomial distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation (number of failures)") },
	{ GNM_FUNC_HELP_ARG, F_("n:required number of successes") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pnbinom(8,10,0.45)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNBINOM,R.QNBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pnbinom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pnbinom (x, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qnbinom[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QNBINOM:probability quantile function of the negative binomial distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("n:required number of successes") },
	{ GNM_FUNC_HELP_ARG, F_("psuc:the probability of success in each trial") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the negative binomial distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qnbinom(0.3,10,0.45)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNBINOM,R.PNBINOM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qnbinom (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float psuc = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qnbinom (p, n, psuc, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DNORM:probability density function of the normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("mu:mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("sigma:standard deviation of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dnorm(1,0,1)" },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dnorm(2,0,1)" },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dnorm(3,0,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PNORM,R.QNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float sigma = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dnorm (x, mu, sigma, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PNORM:cumulative distribution function of the normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("mu:mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("sigma:standard deviation of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pnorm(1,0,1)" },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pnorm(2,0,1)" },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pnorm(3,0,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNORM,R.QNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float sigma = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pnorm (x, mu, sigma, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QNORM:probability quantile function of the normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("mu:mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("sigma:standard deviation of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qnorm(0.3,0,1)" },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qnorm(0.3,0,1)" },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qnorm(0.3,0,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DNORM,R.PNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float mu = value_get_as_float (args[1]);
	gnm_float sigma = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qnorm (p, mu, sigma, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dpois[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DPOIS:probability density function of the Poisson distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("lambda:the mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dpois(4,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PPOIS,R.QPOIS" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dpois (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float lambda = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dpois (x, lambda, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_ppois[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PPOIS:cumulative distribution function of the Poisson distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("lambda:the mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Poisson distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.ppois(4,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DPOIS,R.QPOIS" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_ppois (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float lambda = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (ppois (x, lambda, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qpois[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QPOIS:probability quantile function of the Poisson distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("lambda:the mean of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Poisson distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qpois(0.3,4)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DPOIS,R.PPOIS" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qpois (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float lambda = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qpois (p, lambda, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_drayleigh[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DRAYLEIGH:probability density function of the Rayleigh distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Rayleigh distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.drayleigh(2,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PRAYLEIGH,R.QRAYLEIGH" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_drayleigh (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (drayleigh (x, scale, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_prayleigh[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PRAYLEIGH:cumulative distribution function of the Rayleigh distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Rayleigh distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.prayleigh(2,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DRAYLEIGH,R.QRAYLEIGH" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_prayleigh (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (prayleigh (x, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qrayleigh[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QRAYLEIGH:probability quantile function of the Rayleigh distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Rayleigh distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qrayleigh(0.3,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DRAYLEIGH,R.PRAYLEIGH" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qrayleigh (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float scale = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qrayleigh (p, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dsnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DSNORM:probability density function of the skew-normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("location:the location parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the skew-normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dsnorm(3,2,0,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PSNORM,R.QSNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dsnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float location = value_get_as_float (args[2]);
	gnm_float scale = value_get_as_float (args[3]);
	gboolean give_log = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (dsnorm (x, shape, location, scale, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_psnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PSNORM:cumulative distribution function of the skew-normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("location:the location parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the skew-normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.psnorm(3,2,0,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DSNORM,R.QSNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_psnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float location = value_get_as_float (args[2]);
	gnm_float scale = value_get_as_float (args[3]);
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (psnorm (x, shape, location, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qsnorm[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QSNORM:probability quantile function of the skew-normal distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("location:the location parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the skew-normal distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qsnorm(0.3,2,0,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DSNORM,R.PSNORM" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qsnorm (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float location = value_get_as_float (args[2]);
	gnm_float scale = value_get_as_float (args[3]);
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (qsnorm (p, shape, location, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dst[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DST:probability density function of the skew-t distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the skew-t distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dst(2,5,2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PST,R.QST" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dst (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float shape = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dst (x, n, shape, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pst[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PST:cumulative distribution function of the skew-t distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the skew-t distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pst(2,5,2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DST,R.QST" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pst (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float shape = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pst (x, n, shape, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qst[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QST:probability quantile function of the skew-t distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the skew-t distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qst(0.3,5,2)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DST,R.PST" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qst (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gnm_float shape = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qst (p, n, shape, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dt[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DT:probability density function of the Student t distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Student t distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dt(1.5,5)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PT,R.QT" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dt (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gboolean give_log = args[2] ? value_get_as_checked_bool (args[2]) : FALSE;

	return value_new_float (dt (x, n, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pt[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PT:cumulative distribution function of the Student t distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Student t distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pt(1.5,5)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DT,R.QT" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pt (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (pt (x, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qt[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QT:probability quantile function of the Student t distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("n:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Student t distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qt(0.3,5)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DT,R.PT" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qt (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float n = value_get_as_float (args[1]);
	gboolean lower_tail = args[2] ? value_get_as_checked_bool (args[2]) : TRUE;
	gboolean log_p = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (qt (p, n, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_ptukey[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PTUKEY:cumulative distribution function of the Studentized range distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("nmeans:the number of means") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("nranges:the number of ranges; default is 1") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Studentized range distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.QTUKEY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_ptukey (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float nmeans = value_get_as_float (args[1]);
	gnm_float df = value_get_as_float (args[2]);
	gnm_float nranges = args[3] ? value_get_as_float (args[3]) : 1;
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (ptukey (x, nmeans, df, nranges, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qtukey[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QTUKEY:probability quantile function of the Studentized range distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("nmeans:the number of means") },
	{ GNM_FUNC_HELP_ARG, F_("df:the number of degrees of freedom of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("nranges:the number of ranges; default is 1") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Studentized range distribution.") },
	{ GNM_FUNC_HELP_SEEALSO, "R.PTUKEY" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qtukey (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float nmeans = value_get_as_float (args[1]);
	gnm_float df = value_get_as_float (args[2]);
	gnm_float nranges = args[3] ? value_get_as_float (args[3]) : 1;
	gboolean lower_tail = args[4] ? value_get_as_checked_bool (args[4]) : TRUE;
	gboolean log_p = args[5] ? value_get_as_checked_bool (args[5]) : FALSE;

	return value_new_float (qtukey (p, nmeans, df, nranges, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_dweibull[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.DWEIBULL:probability density function of the Weibull distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("give_log:if true, log of the result will be returned instead") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability density function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.dweibull(2.1,1.5,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.PWEIBULL,R.QWEIBULL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_dweibull (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean give_log = args[3] ? value_get_as_checked_bool (args[3]) : FALSE;

	return value_new_float (dweibull (x, shape, scale, give_log));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_pweibull[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.PWEIBULL:cumulative distribution function of the Weibull distribution") },
	{ GNM_FUNC_HELP_ARG, F_("x:observation") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the cumulative distribution function of the Weibull distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.pweibull(2.1,1.5,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DWEIBULL,R.QWEIBULL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_pweibull (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float x = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (pweibull (x, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

static GnmFuncHelp const help_r_qweibull[] = {
	{ GNM_FUNC_HELP_NAME, F_("R.QWEIBULL:probability quantile function of the Weibull distribution") },
	{ GNM_FUNC_HELP_ARG, F_("p:probability or natural logarithm of the probability") },
	{ GNM_FUNC_HELP_ARG, F_("shape:the shape parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("scale:the scale parameter of the distribution") },
	{ GNM_FUNC_HELP_ARG, F_("lower_tail:if true (the default), the lower tail of the distribution is considered") },
	{ GNM_FUNC_HELP_ARG, F_("log_p:if true, the natural logarithm of the probability is given or returned; defaults to false") },
	{ GNM_FUNC_HELP_DESCRIPTION, F_("This function returns the probability quantile function, i.e., the inverse of the cumulative distribution function, of the Weibull distribution.") },
	{ GNM_FUNC_HELP_EXAMPLES, "=r.qweibull(0.3,1.5,1)" },
	{ GNM_FUNC_HELP_SEEALSO, "R.DWEIBULL,R.PWEIBULL" },
	{ GNM_FUNC_HELP_END }
};

static GnmValue *
gnumeric_r_qweibull (GnmFuncEvalInfo *ei, GnmValue const * const *args)
{
	gnm_float p = value_get_as_float (args[0]);
	gnm_float shape = value_get_as_float (args[1]);
	gnm_float scale = value_get_as_float (args[2]);
	gboolean lower_tail = args[3] ? value_get_as_checked_bool (args[3]) : TRUE;
	gboolean log_p = args[4] ? value_get_as_checked_bool (args[4]) : FALSE;

	return value_new_float (qweibull (p, shape, scale, lower_tail, log_p));
}

/* ------------------------------------------------------------------------- */

G_MODULE_EXPORT void
go_plugin_init (GOPlugin *plugin, GOCmdContext *cc)
{
}

G_MODULE_EXPORT void
go_plugin_shutdown (GOPlugin *plugin, GOCmdContext *cc)
{
}

/* ------------------------------------------------------------------------- */

GnmFuncDescriptor const rstat_functions[] = {
	{
		"r.dbeta",
		"fff|b",
		help_r_dbeta,
		gnumeric_r_dbeta, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pbeta",
		"fff|bb",
		help_r_pbeta,
		gnumeric_r_pbeta, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qbeta",
		"fff|bb",
		help_r_qbeta,
		gnumeric_r_qbeta, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dbinom",
		"fff|b",
		help_r_dbinom,
		gnumeric_r_dbinom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pbinom",
		"fff|bb",
		help_r_pbinom,
		gnumeric_r_pbinom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qbinom",
		"fff|bb",
		help_r_qbinom,
		gnumeric_r_qbinom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dcauchy",
		"fff|b",
		help_r_dcauchy,
		gnumeric_r_dcauchy, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pcauchy",
		"fff|bb",
		help_r_pcauchy,
		gnumeric_r_pcauchy, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qcauchy",
		"fff|bb",
		help_r_qcauchy,
		gnumeric_r_qcauchy, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dchisq",
		"ff|b",
		help_r_dchisq,
		gnumeric_r_dchisq, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pchisq",
		"ff|bb",
		help_r_pchisq,
		gnumeric_r_pchisq, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qchisq",
		"ff|bb",
		help_r_qchisq,
		gnumeric_r_qchisq, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dexp",
		"ff|b",
		help_r_dexp,
		gnumeric_r_dexp, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pexp",
		"ff|bb",
		help_r_pexp,
		gnumeric_r_pexp, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qexp",
		"ff|bb",
		help_r_qexp,
		gnumeric_r_qexp, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.df",
		"fff|b",
		help_r_df,
		gnumeric_r_df, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pf",
		"fff|bb",
		help_r_pf,
		gnumeric_r_pf, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qf",
		"fff|bb",
		help_r_qf,
		gnumeric_r_qf, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dgamma",
		"fff|b",
		help_r_dgamma,
		gnumeric_r_dgamma, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pgamma",
		"fff|bb",
		help_r_pgamma,
		gnumeric_r_pgamma, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qgamma",
		"fff|bb",
		help_r_qgamma,
		gnumeric_r_qgamma, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dgeom",
		"ff|b",
		help_r_dgeom,
		gnumeric_r_dgeom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pgeom",
		"ff|bb",
		help_r_pgeom,
		gnumeric_r_pgeom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qgeom",
		"ff|bb",
		help_r_qgeom,
		gnumeric_r_qgeom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dgumbel",
		"fff|b",
		help_r_dgumbel,
		gnumeric_r_dgumbel, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pgumbel",
		"fff|bb",
		help_r_pgumbel,
		gnumeric_r_pgumbel, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qgumbel",
		"fff|bb",
		help_r_qgumbel,
		gnumeric_r_qgumbel, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dhyper",
		"ffff|b",
		help_r_dhyper,
		gnumeric_r_dhyper, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.phyper",
		"ffff|bb",
		help_r_phyper,
		gnumeric_r_phyper, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qhyper",
		"ffff|bb",
		help_r_qhyper,
		gnumeric_r_qhyper, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dlnorm",
		"fff|b",
		help_r_dlnorm,
		gnumeric_r_dlnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.plnorm",
		"fff|bb",
		help_r_plnorm,
		gnumeric_r_plnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qlnorm",
		"fff|bb",
		help_r_qlnorm,
		gnumeric_r_qlnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dnbinom",
		"fff|b",
		help_r_dnbinom,
		gnumeric_r_dnbinom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pnbinom",
		"fff|bb",
		help_r_pnbinom,
		gnumeric_r_pnbinom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qnbinom",
		"fff|bb",
		help_r_qnbinom,
		gnumeric_r_qnbinom, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dnorm",
		"fff|b",
		help_r_dnorm,
		gnumeric_r_dnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pnorm",
		"fff|bb",
		help_r_pnorm,
		gnumeric_r_pnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qnorm",
		"fff|bb",
		help_r_qnorm,
		gnumeric_r_qnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.dpois",
		"ff|b",
		help_r_dpois,
		gnumeric_r_dpois, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.ppois",
		"ff|bb",
		help_r_ppois,
		gnumeric_r_ppois, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qpois",
		"ff|bb",
		help_r_qpois,
		gnumeric_r_qpois, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.drayleigh",
		"ff|b",
		help_r_drayleigh,
		gnumeric_r_drayleigh, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.prayleigh",
		"ff|bb",
		help_r_prayleigh,
		gnumeric_r_prayleigh, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qrayleigh",
		"ff|bb",
		help_r_qrayleigh,
		gnumeric_r_qrayleigh, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dsnorm",
		"ffff|b",
		help_r_dsnorm,
		gnumeric_r_dsnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.psnorm",
		"ffff|bb",
		help_r_psnorm,
		gnumeric_r_psnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qsnorm",
		"ffff|bb",
		help_r_qsnorm,
		gnumeric_r_qsnorm, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dst",
		"fff|b",
		help_r_dst,
		gnumeric_r_dst, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.pst",
		"fff|bb",
		help_r_pst,
		gnumeric_r_pst, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qst",
		"fff|bb",
		help_r_qst,
		gnumeric_r_qst, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dt",
		"ff|b",
		help_r_dt,
		gnumeric_r_dt, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pt",
		"ff|bb",
		help_r_pt,
		gnumeric_r_pt, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qt",
		"ff|bb",
		help_r_qt,
		gnumeric_r_qt, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.ptukey",
		"fff|fbb",
		help_r_ptukey,
		gnumeric_r_ptukey, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.qtukey",
		"fff|fbb",
		help_r_qtukey,
		gnumeric_r_qtukey, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_NO_TESTSUITE,
	},
	{
		"r.dweibull",
		"fff|b",
		help_r_dweibull,
		gnumeric_r_dweibull, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.pweibull",
		"fff|bb",
		help_r_pweibull,
		gnumeric_r_pweibull, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{
		"r.qweibull",
		"fff|bb",
		help_r_qweibull,
		gnumeric_r_qweibull, NULL, NULL, NULL,
		GNM_FUNC_SIMPLE, GNM_FUNC_IMPL_STATUS_UNIQUE_TO_GNUMERIC, GNM_FUNC_TEST_STATUS_EXHAUSTIVE,
	},
	{ NULL }
};
