static const char* gblur_1d_cl_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <https://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright 2013 Victor Oliveira <victormatheus@gmail.com>                   \n"
" * Copyright 2013 T\303\251o Mazars      <teomazars@gmail.com>                \n"
" */                                                                           \n"
"                                                                              \n"
"__kernel void fir_ver_blur(const global float4 *src_buf,                      \n"
"                                 global float4 *dst_buf,                      \n"
"                           const global float  *cmatrix,                      \n"
"                           const        int     clen)                         \n"
"{                                                                             \n"
"    const int gidx          = get_global_id (0);                              \n"
"    const int gidy          = get_global_id (1);                              \n"
"    const int src_rowstride = get_global_size (0);                            \n"
"    const int dst_rowstride = get_global_size (0);                            \n"
"                                                                              \n"
"    const int half_clen     = clen / 2;                                       \n"
"                                                                              \n"
"    const int src_offset    = gidx + (gidy + half_clen) * src_rowstride;      \n"
"    const int dst_offset    = gidx +  gidy              * dst_rowstride;      \n"
"                                                                              \n"
"    const int src_start_ind = src_offset - half_clen * src_rowstride;         \n"
"                                                                              \n"
"    float4 v = 0.0f;                                                          \n"
"                                                                              \n"
"    for (int i = 0; i < clen; i++)                                            \n"
"      {                                                                       \n"
"        v += src_buf[src_start_ind + i * src_rowstride] * cmatrix[i];         \n"
"      }                                                                       \n"
"                                                                              \n"
"    dst_buf[dst_offset] = v;                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"__kernel void fir_hor_blur(const global float4 *src_buf,                      \n"
"                                 global float4 *dst_buf,                      \n"
"                           const global float  *cmatrix,                      \n"
"                           const        int     clen)                         \n"
"{                                                                             \n"
"    const int gidx          = get_global_id (0);                              \n"
"    const int gidy          = get_global_id (1);                              \n"
"    const int src_rowstride = get_global_size (0) + clen - 1; /*== 2*(clen/2) */\n"
"    const int dst_rowstride = get_global_size (0);                            \n"
"                                                                              \n"
"    const int half_clen     = clen / 2;                                       \n"
"                                                                              \n"
"    const int src_offset    = gidx + gidy * src_rowstride + half_clen;        \n"
"    const int dst_offset    = gidx + gidy * dst_rowstride;                    \n"
"                                                                              \n"
"    const int src_start_ind = src_offset - half_clen;                         \n"
"                                                                              \n"
"    float4 v = 0.0f;                                                          \n"
"                                                                              \n"
"    for (int i = 0; i < clen; i++)                                            \n"
"      {                                                                       \n"
"        v += src_buf[src_start_ind + i] * cmatrix[i];                         \n"
"      }                                                                       \n"
"                                                                              \n"
"    dst_buf[dst_offset] = v;                                                  \n"
"}                                                                             \n"
;
