/* Assistant.c generated by valac 0.30.2, the Vala compiler
 * generated from Assistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "widgets.h"
#include <gobject/gvaluecollector.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__assistant_page_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__assistant_page_info_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AssistantPageInfoPrivate AssistantPageInfoPrivate;
typedef struct _Block1Data Block1Data;
#define _assistant_page_info_unref0(var) ((var == NULL) ? NULL : (var = (assistant_page_info_unref (var), NULL)))
typedef struct _AssistantParamSpecPageInfo AssistantParamSpecPageInfo;

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantPrivate {
	gchar* _apply_text;
	gboolean _last_op_was_back;
	GtkLabel* header_title;
	GtkButtonBox* button_box;
	GtkWidget* back_button;
	GtkWidget* forward_button;
	GtkWidget* cancel_button;
	GtkWidget* close_button;
	GtkWidget* resume_button;
	GtkWidget* apply_button;
	gboolean interrupt_can_continue;
	gboolean interrupted_from_hidden;
	GList* interrupted;
	GList* infos;
	GtkRequisition page_box_req;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AssistantPageInfoPrivate * priv;
	GtkWidget* page;
	gchar* title;
	AssistantType type;
};

struct _AssistantPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (AssistantPageInfo *self);
};

struct _Block1Data {
	int _ref_count_;
	Assistant* self;
	gint response_id;
};

struct _AssistantParamSpecPageInfo {
	GParamSpec parent_instance;
};


static gpointer assistant_parent_class = NULL;
static gpointer assistant_page_info_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
gpointer assistant_page_info_ref (gpointer instance);
void assistant_page_info_unref (gpointer instance);
GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void assistant_value_set_page_info (GValue* value, gpointer v_object);
void assistant_value_take_page_info (GValue* value, gpointer v_object);
gpointer assistant_value_get_page_info (const GValue* value);
GType assistant_page_info_get_type (void) G_GNUC_CONST;
#define ASSISTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT, AssistantPrivate))
enum  {
	ASSISTANT_DUMMY_PROPERTY,
	ASSISTANT_APPLY_TEXT,
	ASSISTANT_LAST_OP_WAS_BACK
};
GType assistant_type_get_type (void) G_GNUC_CONST;
static void _assistant_page_info_unref0_ (gpointer var);
static void _g_list_free__assistant_page_info_unref0_ (GList* self);
#define ASSISTANT_APPLY 1
#define ASSISTANT_BACK 2
#define ASSISTANT_FORWARD 3
#define ASSISTANT_CANCEL 4
#define ASSISTANT_CLOSE 5
#define ASSISTANT_RESUME 6
void assistant_allow_forward (Assistant* self, gboolean allow);
void assistant_set_header_icon (Assistant* self, const gchar* name);
static void assistant_handle_response (Assistant* self, gint resp);
void assistant_go_back (Assistant* self);
void assistant_go_forward (Assistant* self);
void assistant_hide_for_now (Assistant* self);
gboolean assistant_is_interrupted (Assistant* self);
void assistant_skip (Assistant* self);
gboolean assistant_get_last_op_was_back (Assistant* self);
static gboolean assistant_is_interrupt_type (AssistantType type);
static void assistant_set_last_op_was_back (Assistant* self, gboolean value);
static void assistant_page_changed (Assistant* self);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void assistant_use_title (Assistant* self, AssistantPageInfo* info);
static void assistant_set_buttons (Assistant* self);
static void assistant_reset_size (Assistant* self, GtkWidget* page);
static GtkButton* assistant_add_button (Assistant* self, const gchar* label, gint response_id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
const gchar* assistant_get_apply_text (Assistant* self);
static gboolean assistant_set_first_page (Assistant* self);
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
AssistantPageInfo* assistant_page_info_new (void);
AssistantPageInfo* assistant_page_info_construct (GType object_type);
static gboolean _assistant_set_first_page_gsource_func (gpointer self);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
Assistant* assistant_construct (GType object_type);
void assistant_set_apply_text (Assistant* self, const gchar* value);
static GObject * assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _assistant_handle_response_assistant_response (Assistant* _sender, gint response, gpointer self);
enum  {
	ASSISTANT_PAGE_INFO_DUMMY_PROPERTY
};
static void assistant_page_info_finalize (AssistantPageInfo* obj);
static void assistant_finalize (GObject* obj);
static void _vala_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType assistant_type_get_type (void) {
	static volatile gsize assistant_type_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ASSISTANT_TYPE_NORMAL, "ASSISTANT_TYPE_NORMAL", "normal"}, {ASSISTANT_TYPE_INTERRUPT, "ASSISTANT_TYPE_INTERRUPT", "interrupt"}, {ASSISTANT_TYPE_CHECK, "ASSISTANT_TYPE_CHECK", "check"}, {ASSISTANT_TYPE_SUMMARY, "ASSISTANT_TYPE_SUMMARY", "summary"}, {ASSISTANT_TYPE_PROGRESS, "ASSISTANT_TYPE_PROGRESS", "progress"}, {ASSISTANT_TYPE_FINISH, "ASSISTANT_TYPE_FINISH", "finish"}, {0, NULL, NULL}};
		GType assistant_type_type_id;
		assistant_type_type_id = g_enum_register_static ("AssistantType", values);
		g_once_init_leave (&assistant_type_type_id__volatile, assistant_type_type_id);
	}
	return assistant_type_type_id__volatile;
}


static void _assistant_page_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (assistant_page_info_unref (var), NULL));
}


static void _g_list_free__assistant_page_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _assistant_page_info_unref0_, NULL);
	g_list_free (self);
}


void assistant_allow_forward (Assistant* self, gboolean allow) {
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->current;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_ = NULL;
		_tmp2_ = self->priv->forward_button;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->forward_button;
		_tmp4_ = allow;
		gtk_widget_set_sensitive (_tmp3_, _tmp4_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void assistant_set_header_icon (Assistant* self, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = gtk_window_get_icon_name ((GtkWindow*) self);
		_tmp2_ = _tmp1_;
		name = _tmp2_;
	}
	{
		GtkIconTheme* theme = NULL;
		GdkScreen* _tmp3_ = NULL;
		GtkIconTheme* _tmp4_ = NULL;
		GtkIconTheme* _tmp5_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		GtkImage* _tmp8_ = NULL;
		_tmp3_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp4_ = gtk_icon_theme_get_for_screen (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		theme = _tmp5_;
		_tmp6_ = name;
		_tmp7_ = gtk_icon_theme_load_icon (theme, _tmp6_, 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
		pixbuf = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (theme);
			goto __catch1_g_error;
		}
		_tmp8_ = self->header_icon;
		g_object_set (_tmp8_, "pixbuf", pixbuf, NULL);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (theme);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void assistant_handle_response (Assistant* self, gint resp) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = resp;
	switch (_tmp0_) {
		case ASSISTANT_BACK:
		{
			assistant_go_back (self);
			break;
		}
		case ASSISTANT_APPLY:
		case ASSISTANT_FORWARD:
		{
			assistant_go_forward (self);
			break;
		}
		default:
		case ASSISTANT_CANCEL:
		{
			g_signal_emit_by_name (self, "canceled");
			break;
		}
		case ASSISTANT_CLOSE:
		{
			g_signal_emit_by_name (self, "closed");
			break;
		}
		case ASSISTANT_RESUME:
		{
			g_signal_emit_by_name (self, "resumed");
			break;
		}
	}
}


void assistant_hide_for_now (Assistant* self) {
	g_return_if_fail (self != NULL);
	deja_dup_hide_background_window_for_shell ((GtkWindow*) self);
}


gboolean assistant_is_interrupted (Assistant* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->interrupted;
	result = _tmp0_ != NULL;
	return result;
}


void assistant_skip (Assistant* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_last_op_was_back;
	if (_tmp0_) {
		assistant_go_back (self);
	} else {
		assistant_go_forward (self);
	}
}


static gboolean assistant_is_interrupt_type (AssistantType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	AssistantType _tmp1_ = 0;
	_tmp1_ = type;
	if (_tmp1_ == ASSISTANT_TYPE_INTERRUPT) {
		_tmp0_ = TRUE;
	} else {
		AssistantType _tmp2_ = 0;
		_tmp2_ = type;
		_tmp0_ = _tmp2_ == ASSISTANT_TYPE_CHECK;
	}
	result = _tmp0_;
	return result;
}


void assistant_go_back (Assistant* self) {
	GList* next = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interrupted;
	if (_tmp0_ != NULL) {
		GList* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		_tmp1_ = self->priv->interrupted;
		_tmp2_ = _tmp1_->prev;
		next = _tmp2_;
	} else {
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		_tmp3_ = self->current;
		_tmp4_ = _tmp3_->prev;
		next = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			GList* _tmp6_ = NULL;
			GList* _tmp11_ = NULL;
			GList* _tmp12_ = NULL;
			_tmp6_ = next;
			if (_tmp6_ != NULL) {
				GList* _tmp7_ = NULL;
				gconstpointer _tmp8_ = NULL;
				AssistantType _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
				_tmp7_ = next;
				_tmp8_ = _tmp7_->data;
				_tmp9_ = ((AssistantPageInfo*) _tmp8_)->type;
				_tmp10_ = assistant_is_interrupt_type (_tmp9_);
				_tmp5_ = _tmp10_;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp11_ = next;
			_tmp12_ = _tmp11_->prev;
			next = _tmp12_;
		}
	}
	_tmp13_ = next;
	if (_tmp13_ != NULL) {
		GList* _tmp14_ = NULL;
		assistant_set_last_op_was_back (self, TRUE);
		_tmp14_ = next;
		self->current = _tmp14_;
		assistant_page_changed (self);
		g_signal_emit_by_name (self, "backward");
	}
}


void assistant_go_forward (Assistant* self) {
	GList* next = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interrupted;
	if (_tmp0_ != NULL) {
		GList* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->interrupted;
		next = _tmp1_;
		_tmp2_ = self->priv->interrupted_from_hidden;
		if (_tmp2_) {
			assistant_hide_for_now (self);
		}
	} else {
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		_tmp4_ = self->current;
		if (_tmp4_ == NULL) {
			GList* _tmp5_ = NULL;
			_tmp5_ = self->priv->infos;
			_tmp3_ = _tmp5_;
		} else {
			GList* _tmp6_ = NULL;
			GList* _tmp7_ = NULL;
			_tmp6_ = self->current;
			_tmp7_ = _tmp6_->next;
			_tmp3_ = _tmp7_;
		}
		next = _tmp3_;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			GList* _tmp9_ = NULL;
			GList* _tmp14_ = NULL;
			GList* _tmp15_ = NULL;
			_tmp9_ = next;
			if (_tmp9_ != NULL) {
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				AssistantType _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				_tmp10_ = next;
				_tmp11_ = _tmp10_->data;
				_tmp12_ = ((AssistantPageInfo*) _tmp11_)->type;
				_tmp13_ = assistant_is_interrupt_type (_tmp12_);
				_tmp8_ = _tmp13_;
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp14_ = next;
			_tmp15_ = _tmp14_->next;
			next = _tmp15_;
		}
	}
	_tmp16_ = next;
	if (_tmp16_ != NULL) {
		GList* _tmp17_ = NULL;
		assistant_set_last_op_was_back (self, FALSE);
		_tmp17_ = next;
		self->current = _tmp17_;
		assistant_page_changed (self);
		g_signal_emit_by_name (self, "forward");
	}
}


void assistant_go_to_page (Assistant* self, GtkWidget* page) {
	GList* i = NULL;
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->infos;
	i = _tmp0_;
	while (TRUE) {
		GList* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GList* _tmp7_ = NULL;
		GList* _tmp8_ = NULL;
		_tmp1_ = i;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = i;
		_tmp3_ = _tmp2_->data;
		_tmp4_ = ((AssistantPageInfo*) _tmp3_)->page;
		_tmp5_ = page;
		if (_tmp4_ == _tmp5_) {
			GList* _tmp6_ = NULL;
			_tmp6_ = i;
			self->current = _tmp6_;
			assistant_page_changed (self);
			break;
		}
		_tmp7_ = i;
		_tmp8_ = _tmp7_->next;
		i = _tmp8_;
	}
}


void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue) {
	GList* was = NULL;
	GList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkWidget* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->current;
	was = _tmp0_;
	_tmp1_ = can_continue;
	self->priv->interrupt_can_continue = _tmp1_;
	_tmp2_ = page;
	assistant_go_to_page (self, _tmp2_);
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		self->priv->interrupted_from_hidden = TRUE;
	}
	_tmp5_ = was;
	self->priv->interrupted = _tmp5_;
}


static void assistant_use_title (Assistant* self, AssistantPageInfo* info) {
	gchar* title = NULL;
	AssistantPageInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = _tmp0_->title;
	_tmp2_ = g_markup_printf_escaped ("<span size=\"xx-large\" weight=\"ultrabold\">%s</span>", _tmp1_);
	title = _tmp2_;
	_tmp3_ = self->priv->header_title;
	gtk_label_set_markup (_tmp3_, title);
	_g_free0 (title);
}


static void assistant_page_changed (Assistant* self) {
	GList* _tmp0_ = NULL;
	AssistantPageInfo* info = NULL;
	GList* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	AssistantPageInfo* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	AssistantPageInfo* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->current;
	g_return_if_fail (_tmp0_ != NULL);
	self->priv->interrupted = NULL;
	self->priv->interrupted_from_hidden = FALSE;
	_tmp1_ = self->current;
	_tmp2_ = _tmp1_->data;
	info = (AssistantPageInfo*) _tmp2_;
	assistant_set_header_icon (self, NULL);
	_tmp3_ = info;
	_tmp4_ = _tmp3_->page;
	g_signal_emit_by_name (self, "prepare", _tmp4_);
	_tmp5_ = self->current;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = ((AssistantPageInfo*) _tmp6_)->page;
	_tmp8_ = info;
	_tmp9_ = _tmp8_->page;
	if (_tmp7_ == _tmp9_) {
		AssistantPageInfo* _tmp10_ = NULL;
		GtkWidget* child = NULL;
		GtkEventBox* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		GtkWidget* _tmp14_ = NULL;
		GtkEventBox* _tmp18_ = NULL;
		AssistantPageInfo* _tmp19_ = NULL;
		GtkWidget* _tmp20_ = NULL;
		AssistantPageInfo* _tmp21_ = NULL;
		GtkWidget* _tmp22_ = NULL;
		AssistantPageInfo* _tmp23_ = NULL;
		GtkWidget* _tmp24_ = NULL;
		GtkWidget* w = NULL;
		GtkWidget* _tmp25_ = NULL;
		GtkWidget* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		GtkWidget* _tmp28_ = NULL;
		_tmp10_ = info;
		assistant_use_title (self, _tmp10_);
		assistant_set_buttons (self);
		_tmp11_ = self->page_box;
		_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		child = _tmp13_;
		_tmp14_ = child;
		if (_tmp14_ != NULL) {
			GtkWidget* _tmp15_ = NULL;
			GtkEventBox* _tmp16_ = NULL;
			GtkWidget* _tmp17_ = NULL;
			_tmp15_ = child;
			gtk_widget_hide (_tmp15_);
			_tmp16_ = self->page_box;
			_tmp17_ = child;
			gtk_container_remove ((GtkContainer*) _tmp16_, _tmp17_);
		}
		_tmp18_ = self->page_box;
		_tmp19_ = info;
		_tmp20_ = _tmp19_->page;
		gtk_container_add ((GtkContainer*) _tmp18_, _tmp20_);
		_tmp21_ = info;
		_tmp22_ = _tmp21_->page;
		gtk_widget_show (_tmp22_);
		_tmp23_ = info;
		_tmp24_ = _tmp23_->page;
		assistant_reset_size (self, _tmp24_);
		_tmp25_ = gtk_window_get_focus ((GtkWindow*) self);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		w = _tmp26_;
		_tmp28_ = w;
		if (_tmp28_ != NULL) {
			GtkWidget* _tmp29_ = NULL;
			GType _tmp30_ = 0UL;
			_tmp29_ = w;
			_tmp30_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp29_);
			_tmp27_ = _tmp30_ == gtk_label_get_type ();
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GtkWidget* _tmp31_ = NULL;
			_tmp31_ = w;
			gtk_label_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_label_get_type (), GtkLabel), -1, -1);
		}
		_g_object_unref0 (w);
		_g_object_unref0 (child);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Assistant* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_) {
	Assistant* self;
	gint _tmp0_ = 0;
	self = _data1_->self;
	_tmp0_ = _data1_->response_id;
	g_signal_emit_by_name (self, "response", _tmp0_);
}


static void ___lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda4_ (self);
}


static GtkButton* assistant_add_button (Assistant* self, const gchar* label, gint response_id) {
	GtkButton* result = NULL;
	Block1Data* _data1_;
	gint _tmp0_ = 0;
	GtkButton* btn = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButtonBox* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = response_id;
	_data1_->response_id = _tmp0_;
	_tmp1_ = label;
	_tmp2_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp1_);
	g_object_ref_sink (_tmp2_);
	btn = _tmp2_;
	gtk_widget_set_can_default ((GtkWidget*) btn, TRUE);
	g_signal_connect_data (btn, "clicked", (GCallback) ___lambda4__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_widget_show ((GtkWidget*) btn);
	_tmp3_ = self->priv->button_box;
	gtk_box_pack_end ((GtkBox*) _tmp3_, (GtkWidget*) btn, FALSE, TRUE, (guint) 0);
	result = btn;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void assistant_set_buttons (Assistant* self) {
	GList* _tmp0_ = NULL;
	AssistantPageInfo* info = NULL;
	GList* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean show_cancel = FALSE;
	gboolean show_back = FALSE;
	gboolean show_forward = FALSE;
	gboolean show_apply = FALSE;
	gboolean show_close = FALSE;
	gboolean show_resume = FALSE;
	gchar* forward_text = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	AssistantPageInfo* _tmp5_ = NULL;
	AssistantType _tmp6_ = 0;
	GtkButtonBox* area = NULL;
	GtkButtonBox* _tmp16_ = NULL;
	GtkButtonBox* _tmp17_ = NULL;
	GtkWidget* _tmp18_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	GtkWidget* _tmp26_ = NULL;
	GtkWidget* _tmp30_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp60_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->current;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->current;
	_tmp2_ = _tmp1_->data;
	info = (AssistantPageInfo*) _tmp2_;
	show_cancel = FALSE;
	show_back = FALSE;
	show_forward = FALSE;
	show_apply = FALSE;
	show_close = FALSE;
	show_resume = FALSE;
	_tmp3_ = _ ("_Forward");
	_tmp4_ = g_strdup (_tmp3_);
	forward_text = _tmp4_;
	_tmp5_ = info;
	_tmp6_ = _tmp5_->type;
	switch (_tmp6_) {
		default:
		case ASSISTANT_TYPE_NORMAL:
		{
			GList* _tmp7_ = NULL;
			GList* _tmp8_ = NULL;
			show_cancel = TRUE;
			_tmp7_ = self->current;
			_tmp8_ = _tmp7_->prev;
			show_back = _tmp8_ != NULL;
			show_forward = TRUE;
			break;
		}
		case ASSISTANT_TYPE_SUMMARY:
		{
			GList* _tmp9_ = NULL;
			GList* _tmp10_ = NULL;
			show_cancel = TRUE;
			_tmp9_ = self->current;
			_tmp10_ = _tmp9_->prev;
			show_back = _tmp10_ != NULL;
			show_apply = TRUE;
			break;
		}
		case ASSISTANT_TYPE_INTERRUPT:
		{
			gboolean _tmp11_ = FALSE;
			show_cancel = TRUE;
			_tmp11_ = self->priv->interrupt_can_continue;
			if (_tmp11_) {
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				show_forward = TRUE;
				_tmp12_ = _ ("Co_ntinue");
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (forward_text);
				forward_text = _tmp13_;
			}
			break;
		}
		case ASSISTANT_TYPE_CHECK:
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			show_close = TRUE;
			show_forward = TRUE;
			_tmp14_ = C_ ("verb", "_Test");
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (forward_text);
			forward_text = _tmp15_;
			break;
		}
		case ASSISTANT_TYPE_PROGRESS:
		{
			show_cancel = TRUE;
			show_resume = TRUE;
			break;
		}
		case ASSISTANT_TYPE_FINISH:
		{
			show_close = TRUE;
			break;
		}
	}
	_tmp16_ = self->priv->button_box;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	area = _tmp17_;
	_tmp18_ = self->priv->cancel_button;
	if (_tmp18_ != NULL) {
		GtkButtonBox* _tmp19_ = NULL;
		GtkWidget* _tmp20_ = NULL;
		GtkWidget* _tmp21_ = NULL;
		_tmp19_ = area;
		_tmp20_ = self->priv->cancel_button;
		gtk_container_remove ((GtkContainer*) _tmp19_, _tmp20_);
		_tmp21_ = self->priv->cancel_button;
		deja_dup_destroy_widget (_tmp21_);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = NULL;
	}
	_tmp22_ = self->priv->close_button;
	if (_tmp22_ != NULL) {
		GtkButtonBox* _tmp23_ = NULL;
		GtkWidget* _tmp24_ = NULL;
		GtkWidget* _tmp25_ = NULL;
		_tmp23_ = area;
		_tmp24_ = self->priv->close_button;
		gtk_container_remove ((GtkContainer*) _tmp23_, _tmp24_);
		_tmp25_ = self->priv->close_button;
		deja_dup_destroy_widget (_tmp25_);
		_g_object_unref0 (self->priv->close_button);
		self->priv->close_button = NULL;
	}
	_tmp26_ = self->priv->back_button;
	if (_tmp26_ != NULL) {
		GtkButtonBox* _tmp27_ = NULL;
		GtkWidget* _tmp28_ = NULL;
		GtkWidget* _tmp29_ = NULL;
		_tmp27_ = area;
		_tmp28_ = self->priv->back_button;
		gtk_container_remove ((GtkContainer*) _tmp27_, _tmp28_);
		_tmp29_ = self->priv->back_button;
		deja_dup_destroy_widget (_tmp29_);
		_g_object_unref0 (self->priv->back_button);
		self->priv->back_button = NULL;
	}
	_tmp30_ = self->priv->resume_button;
	if (_tmp30_ != NULL) {
		GtkButtonBox* _tmp31_ = NULL;
		GtkWidget* _tmp32_ = NULL;
		GtkWidget* _tmp33_ = NULL;
		_tmp31_ = area;
		_tmp32_ = self->priv->resume_button;
		gtk_container_remove ((GtkContainer*) _tmp31_, _tmp32_);
		_tmp33_ = self->priv->resume_button;
		deja_dup_destroy_widget (_tmp33_);
		_g_object_unref0 (self->priv->resume_button);
		self->priv->resume_button = NULL;
	}
	_tmp34_ = self->priv->forward_button;
	if (_tmp34_ != NULL) {
		GtkButtonBox* _tmp35_ = NULL;
		GtkWidget* _tmp36_ = NULL;
		GtkWidget* _tmp37_ = NULL;
		_tmp35_ = area;
		_tmp36_ = self->priv->forward_button;
		gtk_container_remove ((GtkContainer*) _tmp35_, _tmp36_);
		_tmp37_ = self->priv->forward_button;
		deja_dup_destroy_widget (_tmp37_);
		_g_object_unref0 (self->priv->forward_button);
		self->priv->forward_button = NULL;
	}
	_tmp38_ = self->priv->apply_button;
	if (_tmp38_ != NULL) {
		GtkButtonBox* _tmp39_ = NULL;
		GtkWidget* _tmp40_ = NULL;
		GtkWidget* _tmp41_ = NULL;
		_tmp39_ = area;
		_tmp40_ = self->priv->apply_button;
		gtk_container_remove ((GtkContainer*) _tmp39_, _tmp40_);
		_tmp41_ = self->priv->apply_button;
		deja_dup_destroy_widget (_tmp41_);
		_g_object_unref0 (self->priv->apply_button);
		self->priv->apply_button = NULL;
	}
	_tmp42_ = show_cancel;
	if (_tmp42_) {
		const gchar* _tmp43_ = NULL;
		GtkButton* _tmp44_ = NULL;
		_tmp43_ = _ ("_Cancel");
		_tmp44_ = assistant_add_button (self, _tmp43_, ASSISTANT_CANCEL);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = (GtkWidget*) _tmp44_;
	}
	_tmp45_ = show_close;
	if (_tmp45_) {
		const gchar* _tmp46_ = NULL;
		GtkButton* _tmp47_ = NULL;
		GtkWidget* _tmp48_ = NULL;
		_tmp46_ = _ ("_Close");
		_tmp47_ = assistant_add_button (self, _tmp46_, ASSISTANT_CLOSE);
		_g_object_unref0 (self->priv->close_button);
		self->priv->close_button = (GtkWidget*) _tmp47_;
		_tmp48_ = self->priv->close_button;
		gtk_widget_grab_default (_tmp48_);
	}
	_tmp49_ = show_back;
	if (_tmp49_) {
		const gchar* _tmp50_ = NULL;
		GtkButton* _tmp51_ = NULL;
		_tmp50_ = _ ("_Back");
		_tmp51_ = assistant_add_button (self, _tmp50_, ASSISTANT_BACK);
		_g_object_unref0 (self->priv->back_button);
		self->priv->back_button = (GtkWidget*) _tmp51_;
	}
	_tmp52_ = show_resume;
	if (_tmp52_) {
		const gchar* _tmp53_ = NULL;
		GtkButton* _tmp54_ = NULL;
		GtkWidget* _tmp55_ = NULL;
		_tmp53_ = _ ("_Resume Later");
		_tmp54_ = assistant_add_button (self, _tmp53_, ASSISTANT_RESUME);
		_g_object_unref0 (self->priv->resume_button);
		self->priv->resume_button = (GtkWidget*) _tmp54_;
		_tmp55_ = self->priv->resume_button;
		gtk_widget_grab_default (_tmp55_);
	}
	_tmp56_ = show_forward;
	if (_tmp56_) {
		const gchar* _tmp57_ = NULL;
		GtkButton* _tmp58_ = NULL;
		GtkWidget* _tmp59_ = NULL;
		_tmp57_ = forward_text;
		_tmp58_ = assistant_add_button (self, _tmp57_, ASSISTANT_FORWARD);
		_g_object_unref0 (self->priv->forward_button);
		self->priv->forward_button = (GtkWidget*) _tmp58_;
		_tmp59_ = self->priv->forward_button;
		gtk_widget_grab_default (_tmp59_);
	}
	_tmp60_ = show_apply;
	if (_tmp60_) {
		const gchar* _tmp61_ = NULL;
		GtkButton* _tmp62_ = NULL;
		GtkWidget* _tmp63_ = NULL;
		_tmp61_ = self->priv->_apply_text;
		_tmp62_ = assistant_add_button (self, _tmp61_, ASSISTANT_APPLY);
		_g_object_unref0 (self->priv->apply_button);
		self->priv->apply_button = (GtkWidget*) _tmp62_;
		_tmp63_ = self->priv->apply_button;
		gtk_widget_grab_default (_tmp63_);
	}
	_g_object_unref0 (area);
	_g_free0 (forward_text);
}


static gboolean assistant_set_first_page (Assistant* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->current = NULL;
	assistant_go_forward (self);
	result = FALSE;
	return result;
}


static gpointer _assistant_page_info_ref0 (gpointer self) {
	return self ? assistant_page_info_ref (self) : NULL;
}


static gboolean _assistant_set_first_page_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_set_first_page ((Assistant*) self);
	return result;
}


void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type) {
	gboolean was_empty = FALSE;
	GList* _tmp0_ = NULL;
	AssistantPageInfo* info = NULL;
	AssistantPageInfo* _tmp1_ = NULL;
	AssistantPageInfo* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	AssistantPageInfo* _tmp5_ = NULL;
	AssistantType _tmp6_ = 0;
	AssistantPageInfo* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	AssistantPageInfo* _tmp9_ = NULL;
	AssistantPageInfo* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkWidget* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->infos;
	was_empty = _tmp0_ == NULL;
	_tmp1_ = assistant_page_info_new ();
	info = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = page;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_tmp2_->page);
	_tmp2_->page = _tmp4_;
	_tmp5_ = info;
	_tmp6_ = type;
	_tmp5_->type = _tmp6_;
	_tmp7_ = info;
	_tmp8_ = g_strdup ("");
	_g_free0 (_tmp7_->title);
	_tmp7_->title = _tmp8_;
	_tmp9_ = info;
	_tmp10_ = _assistant_page_info_ref0 (_tmp9_);
	self->priv->infos = g_list_append (self->priv->infos, _tmp10_);
	_tmp11_ = page;
	gtk_widget_show_all (_tmp11_);
	_tmp12_ = was_empty;
	if (_tmp12_) {
		GtkEventBox* _tmp13_ = NULL;
		GtkRequisition _tmp14_ = {0};
		_tmp13_ = self->page_box;
		gtk_widget_get_preferred_size ((GtkWidget*) _tmp13_, NULL, &_tmp14_);
		self->priv->page_box_req = _tmp14_;
	}
	_tmp15_ = page;
	assistant_reset_size (self, _tmp15_);
	_tmp16_ = was_empty;
	if (_tmp16_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _assistant_set_first_page_gsource_func, g_object_ref (self), g_object_unref);
	}
	_assistant_page_info_unref0 (info);
}


static void assistant_reset_size (Assistant* self, GtkWidget* page) {
	GtkRequisition pagereq = {0};
	gint boxw = 0;
	gint boxh = 0;
	GtkEventBox* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkWidget* _tmp3_ = NULL;
	GtkRequisition _tmp4_ = {0};
	GtkEventBox* _tmp5_ = NULL;
	GtkRequisition _tmp6_ = {0};
	gint _tmp7_ = 0;
	GtkRequisition _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkRequisition _tmp11_ = {0};
	gint _tmp12_ = 0;
	GtkRequisition _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->page_box;
	gtk_widget_get_size_request ((GtkWidget*) _tmp0_, &_tmp1_, &_tmp2_);
	boxw = _tmp1_;
	boxh = _tmp2_;
	_tmp3_ = page;
	gtk_widget_get_preferred_size (_tmp3_, NULL, &_tmp4_);
	pagereq = _tmp4_;
	_tmp5_ = self->page_box;
	_tmp6_ = pagereq;
	_tmp7_ = _tmp6_.width;
	_tmp8_ = self->priv->page_box_req;
	_tmp9_ = _tmp8_.width;
	_tmp10_ = MAX (boxw, _tmp7_ + _tmp9_);
	_tmp11_ = pagereq;
	_tmp12_ = _tmp11_.height;
	_tmp13_ = self->priv->page_box_req;
	_tmp14_ = _tmp13_.height;
	_tmp15_ = MAX (boxh, _tmp12_ + _tmp14_);
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, _tmp10_, _tmp15_);
}


void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->infos;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp0_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			AssistantPageInfo* _tmp1_ = NULL;
			AssistantPageInfo* info = NULL;
			_tmp1_ = _assistant_page_info_ref0 ((AssistantPageInfo*) info_it->data);
			info = _tmp1_;
			{
				AssistantPageInfo* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
				GtkWidget* _tmp4_ = NULL;
				_tmp2_ = info;
				_tmp3_ = _tmp2_->page;
				_tmp4_ = page;
				if (_tmp3_ == _tmp4_) {
					AssistantPageInfo* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					gchar* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					GList* _tmp9_ = NULL;
					_tmp5_ = info;
					_tmp6_ = title;
					_tmp7_ = g_strdup (_tmp6_);
					_g_free0 (_tmp5_->title);
					_tmp5_->title = _tmp7_;
					_tmp9_ = self->current;
					if (_tmp9_ != NULL) {
						GList* _tmp10_ = NULL;
						gconstpointer _tmp11_ = NULL;
						GtkWidget* _tmp12_ = NULL;
						GtkWidget* _tmp13_ = NULL;
						_tmp10_ = self->current;
						_tmp11_ = _tmp10_->data;
						_tmp12_ = ((AssistantPageInfo*) _tmp11_)->page;
						_tmp13_ = page;
						_tmp8_ = _tmp12_ == _tmp13_;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						AssistantPageInfo* _tmp14_ = NULL;
						_tmp14_ = info;
						assistant_use_title (self, _tmp14_);
					}
					_assistant_page_info_unref0 (info);
					break;
				}
				_assistant_page_info_unref0 (info);
			}
		}
	}
}


Assistant* assistant_construct (GType object_type) {
	Assistant * self = NULL;
	self = (Assistant*) g_object_new (object_type, NULL);
	return self;
}


const gchar* assistant_get_apply_text (Assistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apply_text;
	result = _tmp0_;
	return result;
}


void assistant_set_apply_text (Assistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_apply_text);
	self->priv->_apply_text = _tmp1_;
	g_object_notify ((GObject *) self, "apply-text");
}


gboolean assistant_get_last_op_was_back (Assistant* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_last_op_was_back;
	result = _tmp0_;
	return result;
}


static void assistant_set_last_op_was_back (Assistant* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_last_op_was_back = _tmp0_;
	g_object_notify ((GObject *) self, "last-op-was-back");
}


static void _assistant_handle_response_assistant_response (Assistant* _sender, gint response, gpointer self) {
	assistant_handle_response ((Assistant*) self, response);
}


static GObject * assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Assistant * self;
	GtkBox* evbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkEventBox* ebox = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GtkBox* ehbox = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkImage* _tmp11_ = NULL;
	GtkEventBox* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkEventBox* _tmp15_ = NULL;
	GtkEventBox* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkEventBox* _tmp18_ = NULL;
	GtkButtonBox* _tmp19_ = NULL;
	GtkButtonBox* _tmp20_ = NULL;
	GtkButtonBox* _tmp21_ = NULL;
	GtkButtonBox* _tmp22_ = NULL;
	GtkBox* dlg_vbox = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	GtkBox* _tmp25_ = NULL;
	GtkBox* _tmp26_ = NULL;
	GtkButtonBox* _tmp27_ = NULL;
	GtkBox* _tmp28_ = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkEventBox* _tmp30_ = NULL;
	GtkEventBox* _tmp31_ = NULL;
	GtkEventBox* _tmp32_ = NULL;
	GtkStyleContext* _tmp33_ = NULL;
	GdkRGBA _tmp34_ = {0};
	GtkEventBox* _tmp35_ = NULL;
	GtkEventBox* _tmp36_ = NULL;
	GtkStyleContext* _tmp37_ = NULL;
	GdkRGBA _tmp38_ = {0};
	parent_class = G_OBJECT_CLASS (assistant_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT, Assistant);
	__g_list_free__assistant_page_info_unref0_0 (self->priv->infos);
	self->priv->infos = NULL;
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	evbox = _tmp0_;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	ebox = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	ehbox = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->header_title);
	self->priv->header_title = _tmp3_;
	_tmp4_ = self->priv->header_title;
	gtk_widget_set_name ((GtkWidget*) _tmp4_, "header");
	_tmp5_ = self->priv->header_title;
	gtk_label_set_xalign (_tmp5_, 0.f);
	_tmp6_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->header_icon);
	self->header_icon = _tmp6_;
	_tmp7_ = ehbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp7_, (guint) 6);
	_tmp8_ = ehbox;
	_tmp9_ = self->priv->header_title;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_tmp10_ = ehbox;
	_tmp11_ = self->header_icon;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = ebox;
	_tmp13_ = ehbox;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = evbox;
	_tmp15_ = ebox;
	gtk_box_pack_start (_tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
	_tmp16_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->page_box);
	self->page_box = _tmp16_;
	_tmp17_ = evbox;
	_tmp18_ = self->page_box;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->button_box);
	self->priv->button_box = _tmp19_;
	_tmp20_ = self->priv->button_box;
	gtk_button_box_set_layout (_tmp20_, GTK_BUTTONBOX_END);
	_tmp21_ = self->priv->button_box;
	gtk_container_set_border_width ((GtkContainer*) _tmp21_, (guint) 12);
	_tmp22_ = self->priv->button_box;
	gtk_box_set_spacing ((GtkBox*) _tmp22_, 12);
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp23_);
	dlg_vbox = _tmp23_;
	_tmp24_ = dlg_vbox;
	_tmp25_ = evbox;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, TRUE, TRUE, (guint) 0);
	_tmp26_ = dlg_vbox;
	_tmp27_ = self->priv->button_box;
	gtk_box_pack_end (_tmp26_, (GtkWidget*) _tmp27_, FALSE, TRUE, (guint) 0);
	_tmp28_ = dlg_vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp28_);
	_tmp29_ = dlg_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = ebox;
	gtk_widget_ensure_style ((GtkWidget*) _tmp30_);
	_tmp31_ = ebox;
	_tmp32_ = ebox;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_get_background_color (_tmp33_, GTK_STATE_FLAG_SELECTED, &_tmp34_);
	gtk_widget_override_background_color ((GtkWidget*) _tmp31_, GTK_STATE_FLAG_NORMAL, &_tmp34_);
	_tmp35_ = ebox;
	_tmp36_ = ebox;
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) _tmp36_);
	gtk_style_context_get_color (_tmp37_, GTK_STATE_FLAG_SELECTED, &_tmp38_);
	gtk_widget_override_color ((GtkWidget*) _tmp35_, GTK_STATE_FLAG_NORMAL, &_tmp38_);
	g_signal_connect_object (self, "response", (GCallback) _assistant_handle_response_assistant_response, self, 0);
	_g_object_unref0 (dlg_vbox);
	_g_object_unref0 (ehbox);
	_g_object_unref0 (ebox);
	_g_object_unref0 (evbox);
	return obj;
}


AssistantPageInfo* assistant_page_info_construct (GType object_type) {
	AssistantPageInfo* self = NULL;
	self = (AssistantPageInfo*) g_type_create_instance (object_type);
	return self;
}


AssistantPageInfo* assistant_page_info_new (void) {
	return assistant_page_info_construct (ASSISTANT_TYPE_PAGE_INFO);
}


static void assistant_value_page_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void assistant_value_page_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		assistant_page_info_unref (value->data[0].v_pointer);
	}
}


static void assistant_value_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = assistant_page_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer assistant_value_page_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* assistant_value_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AssistantPageInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = assistant_page_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* assistant_value_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AssistantPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = assistant_page_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AssistantParamSpecPageInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ASSISTANT_TYPE_PAGE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer assistant_value_get_page_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO), NULL);
	return value->data[0].v_pointer;
}


void assistant_value_set_page_info (GValue* value, gpointer v_object) {
	AssistantPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ASSISTANT_TYPE_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		assistant_page_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		assistant_page_info_unref (old);
	}
}


void assistant_value_take_page_info (GValue* value, gpointer v_object) {
	AssistantPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ASSISTANT_TYPE_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		assistant_page_info_unref (old);
	}
}


static void assistant_page_info_class_init (AssistantPageInfoClass * klass) {
	assistant_page_info_parent_class = g_type_class_peek_parent (klass);
	((AssistantPageInfoClass *) klass)->finalize = assistant_page_info_finalize;
}


static void assistant_page_info_instance_init (AssistantPageInfo * self) {
	self->ref_count = 1;
}


static void assistant_page_info_finalize (AssistantPageInfo* obj) {
	AssistantPageInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->page);
	_g_free0 (self->title);
}


GType assistant_page_info_get_type (void) {
	static volatile gsize assistant_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { assistant_value_page_info_init, assistant_value_page_info_free_value, assistant_value_page_info_copy_value, assistant_value_page_info_peek_pointer, "p", assistant_value_page_info_collect_value, "p", assistant_value_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AssistantPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantPageInfo), 0, (GInstanceInitFunc) assistant_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType assistant_page_info_type_id;
		assistant_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AssistantPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&assistant_page_info_type_id__volatile, assistant_page_info_type_id);
	}
	return assistant_page_info_type_id__volatile;
}


gpointer assistant_page_info_ref (gpointer instance) {
	AssistantPageInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void assistant_page_info_unref (gpointer instance) {
	AssistantPageInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ASSISTANT_PAGE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void assistant_class_init (AssistantClass * klass) {
	assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_APPLY_TEXT, g_param_spec_string ("apply-text", "apply-text", "apply-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_LAST_OP_WAS_BACK, g_param_spec_boolean ("last-op-was-back", "last-op-was-back", "last-op-was-back", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("response", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	g_signal_new ("canceled", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("closed", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("resumed", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("prepare", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gtk_widget_get_type ());
	g_signal_new ("forward", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("backward", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void assistant_instance_init (Assistant * self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self->priv = ASSISTANT_GET_PRIVATE (self);
	_tmp0_ = _ ("_OK");
	_tmp1_ = g_strdup (_tmp0_);
	self->priv->_apply_text = _tmp1_;
	self->priv->_last_op_was_back = FALSE;
	self->priv->interrupt_can_continue = TRUE;
	self->priv->interrupted_from_hidden = FALSE;
}


static void assistant_finalize (GObject* obj) {
	Assistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT, Assistant);
	_g_free0 (self->priv->_apply_text);
	_g_object_unref0 (self->priv->header_title);
	_g_object_unref0 (self->header_icon);
	_g_object_unref0 (self->priv->button_box);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->forward_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->resume_button);
	_g_object_unref0 (self->priv->apply_button);
	_g_object_unref0 (self->page_box);
	__g_list_free__assistant_page_info_unref0_0 (self->priv->infos);
	G_OBJECT_CLASS (assistant_parent_class)->finalize (obj);
}


/**
 * Yes, this is a silly reimplementation of Gtk.Assistant.
 * But Gtk.Assistant has some ridiculous map/unmap logic that resets the page
 * history when unmapped and generally doesn't work when unmapped.  Since
 * continuing to work when hidden is important for us, this is a
 * reimplementation of just the bits we use.
 */
GType assistant_get_type (void) {
	static volatile gsize assistant_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Assistant), 0, (GInstanceInitFunc) assistant_instance_init, NULL };
		GType assistant_type_id;
		assistant_type_id = g_type_register_static (gtk_window_get_type (), "Assistant", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&assistant_type_id__volatile, assistant_type_id);
	}
	return assistant_type_id__volatile;
}


static void _vala_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Assistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT, Assistant);
	switch (property_id) {
		case ASSISTANT_APPLY_TEXT:
		g_value_set_string (value, assistant_get_apply_text (self));
		break;
		case ASSISTANT_LAST_OP_WAS_BACK:
		g_value_set_boolean (value, assistant_get_last_op_was_back (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Assistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT, Assistant);
	switch (property_id) {
		case ASSISTANT_APPLY_TEXT:
		assistant_set_apply_text (self, g_value_get_string (value));
		break;
		case ASSISTANT_LAST_OP_WAS_BACK:
		assistant_set_last_op_was_back (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



