#!/usr/bin/perl

###############################################################################
###############################################################################
##
##  Copyright (C) 2005-2007 Red Hat, Inc.  All rights reserved.
##
##  This copyrighted material is made available to anyone wishing to use,
##  modify, copy, or redistribute it subject to the terms and conditions
##  of the GNU General Public License v.2.
##
###############################################################################
###############################################################################

use Getopt::Std;

# Get the program name from $0 and strip directory names
$_=$0;
s/.*\///;
my $pname = $_;


# Default is to use ssh for connection to the host
# for this to be effective you'll need to have an ssh key on the VMs
# that can log in to the host without a passphrase.
# If you device to use rsh then you'll need to edit /root/.rhosts
#
# Also note that you'll need to set /proc/sys/kernel/sysrq to "1" in 
# the VMs for this to work at all.
#
$opt_c = "ssh";
$opt_u = "root";

# WARNING!! Do not add code bewteen "#BEGIN_VERSION_GENERATION" and
# "#END_VERSION_GENERATION"  It is generated by the Makefile

#BEGIN_VERSION_GENERATION
$FENCE_RELEASE_NAME="";
$REDHAT_COPYRIGHT="";
$BUILD_DATE="";
#END_VERSION_GENERATION

sub usage
{
	print "Usage:\n";
	print "\n";
	print "$pname [options]\n";
	print "\n";
	print "Options:\n";
	print "  -h               This help message\n";
	print "  -s <ip>          IP address or hostname of host system\n";
	print "  -d <domain>      Domain name of system to fence\n";
	print "  -u <name>        User name (default root)\n";
	print "  -c <cmd>         Command to log into host (default ssh) \n";

	exit 0;
}

sub fail
{
	($msg)=@_;
	print $msg."\n" unless defined $opt_q;

	if (defined $t)
	{
		# make sure we don't get stuck in a loop due to errors
		$t->errmode('return');

		logout() if $logged_in;
		$t->close
	}
	exit 1;
}

sub fail_usage
{
	($msg)=@_;
	print STDERR $msg."\n" if $msg;
	print STDERR "Please use '-h' for usage.\n";
	exit 1;
}

sub version
{
	print "$pname $FENCE_RELEASE_NAME $BUILD_DATE\n";
	print "$REDHAT_COPYRIGHT\n" if ( $REDHAT_COPYRIGHT );
	exit 0;
}




sub get_options_stdin
{
	my $opt;
	my $line = 0;
	while( defined($in = <>) )
	{
		$_ = $in;
		chomp;

		# strip leading and trailing whitespace
		s/^\s*//;
		s/\s*$//;

		# skip comments
		next if /^#/;

		$line+=1;
		$opt=$_;
		next unless $opt;

		($name,$val)=split /\s*=\s*/, $opt;

		if ( $name eq "" )
		{
			print STDERR "parse error: illegal name in option $line\n";
			exit 2;
		}
		# DO NOTHING -- this field is used by fenced
		elsif ($name eq "agent" )
		{
		}
		elsif ($name eq "host" )
		{
			$opt_s = $val;
		}
		elsif ($name eq "domain" )
		{
			$opt_d = $val;
		}
		elsif ($name eq "user" )
		{
			$opt_u = $val;
		}
		elsif ($name eq "cmd" )
		{
			$opt_c = $val;
		}
		# Maybe password...
		# Excess name/vals will fail
		else
		{
			fail "parse error: unknown option \"$opt\"";
		}
	}
}


### MAIN #######################################################
if (@ARGV > 0) {
	getopts("hs:d:u:c:vV") || fail_usage ;

	usage if defined $opt_h;
	version if defined $opt_V;

	fail_usage "Unknown parameter." if (@ARGV > 0);

	fail_usage "No '-d' flag specified." unless defined $opt_d;
	fail_usage "No '-s' flag specified." unless defined $opt_s;

    } else {
	get_options_stdin();

	fail "failed: no host system name" unless defined $opt_s;
	fail "failed: no domain to fence" unless defined $opt_d;

    }

exit system ("$opt_c -l $opt_u $opt_s xm sysrq $opt_d b");


