/* clearing house for ld emulation states
Copyright (C) 1991 Free Software Foundation, Inc.

This file is part of GLD, the Gnu Linker.

GLD is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GLD is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLD; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * $Id: ldemul.c,v 1.11 1991/11/12 03:03:19 bothner Exp $ 
 */

#include "bfd.h"
#include "sysdep.h"

#include "config.h"
#include "ld.h"
#include "ldemul.h"
#include "ldmisc.h"

extern ld_emulation_xfer_type ld_lnk960_emulation;
extern ld_emulation_xfer_type ld_gldm88kbcs_emulation;
extern ld_emulation_xfer_type ld_gld_emulation;
extern ld_emulation_xfer_type ld_vanilla_emulation;
extern ld_emulation_xfer_type ld_gld68k_emulation;
extern ld_emulation_xfer_type ld_gld960_emulation;
extern ld_emulation_xfer_type ld_gld29k_emulation;
extern ld_emulation_xfer_type ld_gldnews_emulation;
extern ld_emulation_xfer_type ld_gldi386aout_emulation;
extern ld_emulation_xfer_type ld_h8300hds_emulation;
extern ld_emulation_xfer_type ld_ebmon29k_emulation;

ld_emulation_xfer_type *ld_emulation;

void
ldemul_hll(name)
char *name;
{
  ld_emulation->hll(name);
}


void ldemul_syslib(name)
char *name;
{
  ld_emulation->syslib(name);
}

void
ldemul_after_parse()
{
  ld_emulation->after_parse();
}

void
ldemul_before_parse()
{
  ld_emulation->before_parse();
}

void 
ldemul_after_allocation()
{
  ld_emulation->after_allocation();
}

void 
ldemul_before_allocation()
{
  if (ld_emulation->before_allocation) {
    ld_emulation->before_allocation();
  }
}


void
ldemul_set_output_arch()
{
  ld_emulation->set_output_arch();
}

char *
ldemul_choose_target()
{
  return ld_emulation->choose_target();
}

char *
ldemul_get_script()
{
  return ld_emulation->get_script();
}

void
ldemul_choose_mode(target)
char *target;
{
  if (strcmp(target,LNK960_EMULATION_NAME)==0) {
    ld_emulation = &ld_lnk960_emulation;
  }
  else if (strcmp(target,GLD960_EMULATION_NAME)==0) {
    ld_emulation = &ld_gld960_emulation;
  }
  else if (strcmp(target,GLDM88KBCS_EMULATION_NAME)==0) {
    ld_emulation = &ld_gldm88kbcs_emulation;
  }
#ifndef GNU960
  else if (strcmp(target,GLD_EMULATION_NAME)==0) {
    ld_emulation = &ld_gld_emulation;
  }
  else if (strcmp(target,VANILLA_EMULATION_NAME)==0) {
    ld_emulation = &ld_vanilla_emulation;
  }
   else if (strcmp(target,GLDI386AOUT_EMULATION_NAME)==0) {
     ld_emulation = &ld_gldi386aout_emulation;	
   }
  else if (strcmp(target,H8300HDS_EMULATION_NAME)==0) {
    ld_emulation = &ld_h8300hds_emulation;
  }
  else if (strcmp(target,GLD68K_EMULATION_NAME)==0) {
    ld_emulation = &ld_gld68k_emulation;
  }
  else if (strcmp(target,GLD29K_EMULATION_NAME)==0) {
    ld_emulation = &ld_gld29k_emulation;	
  }
  else if (strcmp(target,GLDNEWS_EMULATION_NAME)==0) {
    ld_emulation = &ld_gldnews_emulation;	
  }
  else if (strcmp(target,EBMON29K_EMULATION_NAME)==0) {
    ld_emulation = &ld_ebmon29k_emulation;	
  }
#endif
  else {
    einfo("%P%F unrecognised emulation mode: %s\n",target);
  }
}



