#!/usr/bin/env python

# A simple application.


import sys, string
from qt import *


fileopen = [
    '16 13 5 1',
    '. c #040404',
    '# c #808304',
    'a c None',
    'b c #f3f704',
    'c c #f3f7f3',
    'aaaaaaaaa...aaaa',
    'aaaaaaaa.aaa.a.a',
    'aaaaaaaaaaaaa..a',
    'a...aaaaaaaa...a',
    '.bcb.......aaaaa',
    '.cbcbcbcbc.aaaaa',
    '.bcbcbcbcb.aaaaa',
    '.cbcb...........',
    '.bcb.#########.a',
    '.cb.#########.aa',
    '.b.#########.aaa',
    '..#########.aaaa',
    '...........aaaaa'
]

filesave = [
    '14 14 4 1',
    '. c #040404',
    '# c #808304',
    'a c #bfc2bf',
    'b c None',
    '..............',
    '.#.aaaaaaaa.a.',
    '.#.aaaaaaaa...',
    '.#.aaaaaaaa.#.',
    '.#.aaaaaaaa.#.',
    '.#.aaaaaaaa.#.',
    '.#.aaaaaaaa.#.',
    '.##........##.',
    '.############.',
    '.##.........#.',
    '.##......aa.#.',
    '.##......aa.#.',
    '.##......aa.#.',
    'b.............'
]

fileprint = [
    '16 14 6 1',
    '. c #000000',
    '# c #848284',
    'a c #c6c3c6',
    'b c #ffff00',
    'c c #ffffff',
    'd c None',
    'ddddd.........dd',
    'dddd.cccccccc.dd',
    'dddd.c.....c.ddd',
    'ddd.cccccccc.ddd',
    'ddd.c.....c....d',
    'dd.cccccccc.a.a.',
    'd..........a.a..',
    '.aaaaaaaaaa.a.a.',
    '.............aa.',
    '.aaaaaa###aa.a.d',
    '.aaaaaabbbaa...d',
    '.............a.d',
    'd.aaaaaaaaa.a.dd',
    'dd...........ddd'
]


fileOpenText = \
'''<img source="fileopen">
Click this button to open a <em>new file</em>.<br><br>
You can also select the <b>Open</b> command from the <b>File</b> menu.'''

fileSaveText = \
'''Click this button to save the file you are editing.<br><br>
You will be prompted for a filename.<br><br>
You can also select the <b>Save</b> command from the <b>File</b> menu.'''

filePrintText = \
'''Click this button to print the file you are editing.<br><br>
You can also select the <b>Print</b> command from the <b>File</b> menu.'''


editorList = []


class ApplicationWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self,None,'example application main window',Qt.WDestructiveClose)

        self.filename = QString.null
        self.printer = QPrinter()

        self.fileTools = QToolBar(self,'file operations')

        openIcon = QPixmap(fileopen)
        self.fileOpen = QToolButton(openIcon,'Open File',QString.null,self.load,self.fileTools,'open file')

        saveIcon = QPixmap(filesave)
        self.fileSave = QToolButton(saveIcon,'Save File',QString.null,self.save,self.fileTools,'save file')
	      
        printIcon = QPixmap(fileprint)
        self.filePrint = QToolButton(printIcon,'Print File',QString.null,self.printDoc,self.fileTools,'print file')

        QWhatsThis.whatsThisButton(self.fileTools)

        QWhatsThis.add(self.fileOpen,fileOpenText)
        QMimeSourceFactory.defaultFactory().setPixmap('fileopen',openIcon)
        QWhatsThis.add(self.fileSave,fileSaveText)
        QWhatsThis.add(self.filePrint,filePrintText)

        self.file = QPopupMenu(self)
        self.menuBar().insertItem('&File',self.file)

        self.file.insertItem('&New',self.newDoc,Qt.CTRL + Qt.Key_N)

        id = self.file.insertItem(QIconSet(openIcon),'&Open',self.load,Qt.CTRL + Qt.Key_O)
        self.file.setWhatsThis(id,fileOpenText)

        id = self.file.insertItem(QIconSet(saveIcon),'&Save',self.save,Qt.CTRL + Qt.Key_S)
        self.file.setWhatsThis(id,fileSaveText)

        id = self.file.insertItem('Save &as',self.saveAs)
        self.file.setWhatsThis(id,fileSaveText)

        self.file.insertSeparator()

        id = self.file.insertItem(QIconSet(printIcon),'&Print',self.printDoc,Qt.CTRL + Qt.Key_P)
        self.file.setWhatsThis(id,filePrintText)

        self.file.insertSeparator()

        self.file.insertItem('&Close',self,SLOT('close()'),Qt.CTRL + Qt.Key_W)
        self.file.insertItem('&Quit',qApp,SLOT('closeAllWindows()'),Qt.CTRL + Qt.Key_Q)

        self.help = QPopupMenu(self)
        self.menuBar().insertSeparator()
        self.menuBar().insertItem('&Help',self.help)

        self.help.insertItem('&About',self.about,Qt.Key_F1)
        self.help.insertItem('About &Qt',self.aboutQt)

        self.e = QMultiLineEdit(self,'editor')
        self.e.setFocus()
        self.setCentralWidget(self.e)

        self.statusBar().message('Ready',2000)
        self.resize(450,600)

    def newDoc(self):
        ed = ApplicationWindow()
        ed.show()
        editorList.append(ed)

    def load(self):
        fn = QFileDialog.getOpenFileName(QString.null,QString.null,self)
        if fn.isEmpty():
            self.statusBar().message('Loading aborted',2000)
            return

        fileName = str(fn)

        self.e.setAutoUpdate(0)
        self.e.clear()

        try:
            f = open(fileName,'r')
        except:
            return

        for l in f.readlines():
            self.e.append(string.rstrip(l))

        f.close()

        self.e.setAutoUpdate(1)
        self.e.repaint()
        self.e.setEdited(0)
        self.setCaption(fileName)
        self.statusBar().message('Loaded document %s' % (fileName),2000)

    def save(self):
        if self.filename.isEmpty():
            self.saveAs()
            return

        try:
            f = open(str(self.filename),'w+')
        except:
            self.statusBar().message('Could not write to %s' % (self.filename),2000)
            return

        f.write(str(self.e.text()))
        f.close()

        self.e.setEdited(0)
        self.setCaption(self.filename)
        self.statusBar().message('File %s saved' % (self.filename),2000)

    def saveAs(self):
        fn = QFileDialog.getSaveFileName(QString.null,QString.null,self)
        if not fn.isEmpty():
            self.filename = fn
            self.save()
        else:
            self.statusBar().message('Saving aborted',2000)

    def printDoc(self):
        Margin = 10
        pageNo = 1

        if self.printer.setup(self):
            self.statusBar().message('Printing...')

            p = QPainter()
            p.begin(self.printer)
            p.setFont(self.e.font())
            yPos = 0
            fm = p.fontMetrics()
            metrics = QPaintDeviceMetrics(self.printer)

            for i in range(self.e.numLines):
                if Margin + yPos > metrics.height() - Margin:
                    pageNo = pageNo + 1
                    self.statusBar().message('Printing (page %d)...' % (pageNo))
                    self.printer.newPage()
                    yPos = 0

                p.drawText(Margin,Margin + yPos,metrics.width(),fm.lineSpacing(),Qt.ExpandTabs | Qt.DontClip,self.e.textLine(i))
                yPos = yPos + fm.lineSpacing()

            p.end()
            self.statusBar().message('Printing completed',2000)
        else:
            self.statusBar().message('Printing aborted',2000)
 
    def closeEvent(self,ce):
        if not self.e.edited():
            ce.accept()
            return

        rc = QMessageBox.information(self,'Qt Application Example',
                    'The document has been changed since the last save.',
                    'Save Now','Cancel','Leave Anyway',0,1)

        if rc == 0:
            self.save()
            ce.accept()
        elif rc == 2:
            ce.accept()
        else:
            ce.ignore()

    def about(self):
        QMessageBox.about(self,'Qt Application Example',
            'This example demonstrates simple use of QMainWindow,\nQMenuBar and QToolBar.')

    def aboutQt(self):
        QMessageBox.aboutQt(self,'Qt Application Example')


a = QApplication(sys.argv)
mw = ApplicationWindow()
mw.setCaption('Document 1')
mw.show()
a.connect(a, SIGNAL('lastWindowClosed()'), a, SLOT('quit()'))
a.exec_loop()
