//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QRegExp;
import org.kde.qt.QWidget;

/**

 @brief A generic implementation of the "replace" function.
 <b></b>etail:
 This class includes prompt handling etc. Also provides some
 static functions which can be used to create custom behavior
 instead of using the class directly.
 <b></b>xample:
 To use the class to implement a complete replace feature:
 In the slot connect to the replace action, after using KReplaceDialog:
 <pre>
  // This creates a replace-on-prompt dialog if needed.
  m_replace = new KReplace(pattern, replacement, options, this);
  // Connect signals to code which handles highlighting
  // of found text, and on-the-fly replacement.
  connect( m_replace, SIGNAL("highlight( String, int, int )"),
          this, SLOT("slotHighlight( String, int, int )") );
  // Connect findNext signal - called when pressing the button in the dialog
  connect( m_replace, SIGNAL("findNext()"),
          this, SLOT("slotReplaceNext()") );
  // Connect replace signal - called when doing a replacement
  connect( m_replace, SIGNAL("replace(String, int, int, int)"),
          this, SLOT("slotReplace(String, int, int, int)") );
 </pre>
  Then initialize the variables determining the "current position"
  (to the cursor, if the option FromCursor is set,
   to the beginning of the selection if the option SelectedText is set,
   and to the beginning of the document otherwise).
  Initialize the "end of search" variables as well (end of doc or end of selection).
  Swap begin and end if FindBackwards.
  Finally, call slotReplaceNext();
 <pre>
  void slotReplaceNext()
  {
      KFind.Result res = KFind.NoMatch;
      while ( res == KFind.NoMatch && <position not at end> ) {
          if ( m_replace.needData() )
              m_replace.setData( <current text fragment> );
          // Let KReplace inspect the text fragment, and display a dialog if a match is found
          res = m_replace.replace();
          if ( res == KFind.NoMatch ) {
              <Move to the next text fragment, honoring the FindBackwards setting for the direction>
          }
      }
      if ( res == KFind.NoMatch ) // i.e. at end
          <Call either  m_replace.displayFinalDialog(); delete m_replace; m_replace = null;
           or           if ( m_replace.shouldRestart() ) { reinit (w/o FromCursor) and call slotReplaceNext(); }
                        else { m_replace.closeReplaceNextDialog(); }>
  }
 </pre>
  Don't forget delete m_find in the destructor of your class,
  unless you gave it a parent widget on construction.
  See {@link KReplaceSignals} for signals emitted by KReplace
		@author S.R.Haque <srhaque@iee.org>, David Faure <faure@kde.org>

		@short    @brief A generic implementation of the "replace" function.

*/
public class KReplace extends KFind  {
	protected KReplace(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Only use this constructor if you don't use KFindDialog, or if
		 you use it as a modal dialog.
		     		@short    Only use this constructor if you don't use KFindDialog, or if  you use it as a modal dialog.
	*/
	public KReplace(String pattern, String replacement, long options, QWidget parent) {
		super((Class) null);
		newKReplace(pattern,replacement,options,parent);
	}
	private native void newKReplace(String pattern, String replacement, long options, QWidget parent);
	public KReplace(String pattern, String replacement, long options) {
		super((Class) null);
		newKReplace(pattern,replacement,options);
	}
	private native void newKReplace(String pattern, String replacement, long options);
	/**	
		 This is the recommended constructor if you also use KReplaceDialog (non-modal).
		 You should pass the pointer to it here, so that when a message box
		 appears it has the right parent. Don't worry about deletion, KReplace
		 will notice if the find dialog is closed.
		     		@short    This is the recommended constructor if you also use KReplaceDialog (non-modal).
	*/
	public KReplace(String pattern, String replacement, long options, QWidget parent, QWidget replaceDialog) {
		super((Class) null);
		newKReplace(pattern,replacement,options,parent,replaceDialog);
	}
	private native void newKReplace(String pattern, String replacement, long options, QWidget parent, QWidget replaceDialog);
	/**	
		 Return the number of replacements made (i.e. the number of times
		 the replace signal was emitted).
		 Can be used in a dialog box to tell the user how many replacements were made.
		 The final dialog does so already, unless you used setDisplayFinalDialog(false).
		     		@short    Return the number of replacements made (i.
	*/
	public native int numReplacements();
	/**	
		 Call this to reset the numMatches & numReplacements counts.
		 Can be useful if reusing the same KReplace for different operations,
		 or when restarting from the beginning of the document.
		     		@short    Call this to reset the numMatches & numReplacements counts.
	*/
	public native void resetCounts();
	/**	
		 Walk the text fragment (e.g. kwrite line, kspread cell) looking for matches.
		 For each match, if prompt-on-replace is specified, emits the highlight() signal
		 and displays the prompt-for-replace dialog before doing the replace.
		     		@short    Walk the text fragment (e.
	*/
	public native int replace();
	/**	
		 Return (or create) the dialog that shows the "find next?" prompt.
		 Usually you don't need to call this.
		 One case where it can be useful, is when the user selects the "Find"
		 menu item while a find operation is under way. In that case, the
		 program may want to call setActiveWindow() on that dialog.
		     		@short    Return (or create) the dialog that shows the "find next?" prompt.
	*/
	public native KDialogBase replaceNextDialog(boolean create);
	public native KDialogBase replaceNextDialog();
	/**	
		 Close the "replace next?" dialog. The application should do this when
		 the last match was hit. If the application deletes the KReplace, then
		 "find previous" won't be possible anymore.
		     		@short    Close the "replace next?" dialog.
	*/
	public native void closeReplaceNextDialog();
	/**	
		 Returns true if we should restart the search from scratch.
		 Can ask the user, or return false (if we already searched/replaced the
		 whole document without the PromptOnReplace option).
			@param forceAsking set to true if the user modified the document during the
		 search. In that case it makes sense to restart the search again.
			@param showNumMatches set to true if the dialog should show the number of
		 matches. Set to false if the application provides a "find previous" action,
		 in which case the match count will be erroneous when hitting the end,
		 and we could even be hitting the beginning of the document (so not all
		 matches have even been seen).
		     		@short    Returns true if we should restart the search from scratch.
	*/
	public native boolean shouldRestart(boolean forceAsking, boolean showNumMatches);
	public native boolean shouldRestart(boolean forceAsking);
	public native boolean shouldRestart();
	/**	
		 Displays the final dialog telling the user how many replacements were made.
		 Call either this or shouldRestart().
		     		@short    Displays the final dialog telling the user how many replacements were made.
	*/
	public native void displayFinalDialog();
	/**	
		 Search the given string, replaces with the given replacement string,
		 and returns whether a match was found. If one is,
		 the replacement string length is also returned.
			 A performance optimised version of the function is provided for use
		 with regular expressions.
			@param text The string to search.
			@param pattern The pattern to look for.
			@param replacement The replacement string to insert into the text.
			@param index The starting index into the string.
			@param options The options to use.
			@param replacedLength Output parameter, contains the length of the replaced string.
		 Not always the same as replacement.length(), when backreferences are used.
				@return The index at which a match was found, or -1 if no match was found.
     
		@short    Search the given string, replaces with the given replacement string,  and returns whether a match was found.
	*/
	public static native int replace(StringBuffer text, String pattern, String replacement, int index, long options, int[] replacedLength);
	public static native int replace(StringBuffer text, QRegExp pattern, String replacement, int index, long options, int[] replacedLength);
	protected native void slotSkip();
	protected native void slotReplace();
	protected native void slotReplaceAll();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
