.TH XScreenSaver 1 "08 Feb 2000" "X Version 11"
.SH NAME
critical \- Draw a system showing self-organizing criticality
.SH SYNOPSIS
.B critical
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP] [\-background \fIcolor\fP] [\-window] [\-root] [\-mono] [\-install] [\-visual \fIvisual\fP] [\-delay \fIseconds\fP] [\-random \fIboolean\fP] [\-ncolors \fIint\fP] [\-offset \fIint\fP] 
[\-fps]
.SH DESCRIPTION
The \fIcritical\fP program displays a self-organizing critical system
that gradually emerges from chaos.

\fIcritical\fP performs a simulation on a two-dimensional array of
integers.  The array is initialized to random values.  On each
iteration, it draws a line to the array position with the greatest
value.  It then replaces that location and the eight neighboring
locations with randomly-selected values.

The lines are initially random, but over time a chaotic
self-organizing system evolves: areas of the screen which happen to
have lower values are less likely to be updated to new values, and so
the line tends to avoid those areas.  Eventually, the histogram of
changes approaches the power-law curve typical of such systems.

The simplest documented self-organizing system is the one-dimensional
equivalent of \fIcritical\fP.

I heard about this algorithm second-hand: apparently there was an
article in \fIScientific American\fP describing it sometime in 1997.
.SH OPTIONS
.I critical
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fIusecs\fP
Number of microseconds to wait after drawing each line.
.TP 8
.B \-random \fIboolean\fP
Whether to use randomly selected colours rather than a cycle around
the colour wheel.
.TP 8
.B \-offset \fIinteger\fP
The maximum random radius increment to use.
.TP 8
.B \-ncolors \fIinteger\fP
How many colors should be allocated in the color ramp (note that this
value interacts with \fIoffset\fP.)
.TP 8
.B \-trail \fIinteger\fP
Length of the trail: between 5 and 100 is nice.
.TP 8
.B \-fps
Display the current frame rate and CPU load.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.BR xscreensaver-command (1)
.BR xscreensaver-demo (1)
.SH COPYRIGHT
Copyright \(co 1998 by Martin Pool.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  No representations are made about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
.SH AUTHOR
Martin Pool <mbp@humbug.org.au>, 1998-2000.  Based in part on the
XScreenSaver code by Jamie Zawinski <jwz@jwz.org>.
