/* basicdoclet.c generated by valac, the Vala compiler
 * generated from basicdoclet.vala, do not modify */

/* basicdoclet.vala
 *
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <vala.h>

#define VALADOC_HTML_BASIC_DOCLET_css_inline_navigation "navi_inline"
#define VALADOC_HTML_BASIC_DOCLET_css_package_index "package_index"
#define VALADOC_HTML_BASIC_DOCLET_css_brief_description "brief_description"
#define VALADOC_HTML_BASIC_DOCLET_css_description "description"
#define VALADOC_HTML_BASIC_DOCLET_css_known_list "known_nodes"
#define VALADOC_HTML_BASIC_DOCLET_css_leaf_brief_description "leaf_brief_description"
#define VALADOC_HTML_BASIC_DOCLET_css_leaf_code_definition "leaf_code_definition"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline_text "text"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline_toggle "toggle"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline "headline"
#define VALADOC_HTML_BASIC_DOCLET_css_box_content "content"
#define VALADOC_HTML_BASIC_DOCLET_css_box_column "column"
#define VALADOC_HTML_BASIC_DOCLET_css_box "box"
#define VALADOC_HTML_BASIC_DOCLET_css_namespace_note "namespace_note"
#define VALADOC_HTML_BASIC_DOCLET_css_package_note "package_note"
#define VALADOC_HTML_BASIC_DOCLET_css_site_header "site_header"
#define VALADOC_HTML_BASIC_DOCLET_css_navi "navi_main"
#define VALADOC_HTML_BASIC_DOCLET_css_navi_hr "navi_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table_name "main_errordomain_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table_text "main_errordomain_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table "main_errordomain_table"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table_name "main_enum_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table_text "main_enum_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table "main_enum_table"
#define VALADOC_HTML_BASIC_DOCLET_css_diagram "main_diagram"
#define VALADOC_HTML_BASIC_DOCLET_css_see_list "main_see_list"
#define VALADOC_HTML_BASIC_DOCLET_css_wiki_table "main_table"
#define VALADOC_HTML_BASIC_DOCLET_css_notification_area "main_notification"
#define VALADOC_HTML_BASIC_DOCLET_css_source_sample "main_sourcesample"
#define VALADOC_HTML_BASIC_DOCLET_css_exception_table "main_parameter_table"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table_text "main_parameter_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table_name "main_parameter_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table "main_parameter_table"
#define VALADOC_HTML_BASIC_DOCLET_css_title "main_title"
#define VALADOC_HTML_BASIC_DOCLET_css_other_type "main_other_type"
#define VALADOC_HTML_BASIC_DOCLET_css_basic_type "main_basic_type"
#define VALADOC_HTML_BASIC_DOCLET_css_keyword "main_keyword"
#define VALADOC_HTML_BASIC_DOCLET_css_optional_parameter "main_optional_parameter"
#define VALADOC_HTML_BASIC_DOCLET_css_code_definition "main_code_definition"
#define VALADOC_HTML_BASIC_DOCLET_css_headline_hr "main_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_hr "main_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_list_errdom "main_list_errdom"
#define VALADOC_HTML_BASIC_DOCLET_css_list_en "main_list_en"
#define VALADOC_HTML_BASIC_DOCLET_css_list_ns "main_list_ns"
#define VALADOC_HTML_BASIC_DOCLET_css_list_cl "main_list_cl"
#define VALADOC_HTML_BASIC_DOCLET_css_list_iface "main_list_iface"
#define VALADOC_HTML_BASIC_DOCLET_css_list_stru "main_list_stru"
#define VALADOC_HTML_BASIC_DOCLET_css_list_field "main_list_field"
#define VALADOC_HTML_BASIC_DOCLET_css_list_prop "main_list_prop"
#define VALADOC_HTML_BASIC_DOCLET_css_list_del "main_list_del"
#define VALADOC_HTML_BASIC_DOCLET_css_list_sig "main_list_sig"
#define VALADOC_HTML_BASIC_DOCLET_css_list_m "main_list_m"
#define VALADOC_HTML_BASIC_DOCLET_css_style_navigation "site_navigation"
#define VALADOC_HTML_BASIC_DOCLET_css_style_content "site_content"
#define VALADOC_HTML_BASIC_DOCLET_css_style_body "site_body"
#define VALADOC_HTML_BASIC_DOCLET_css_deprecated "deprecated"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	VALADOC_HTML_BASIC_DOCLET_0_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_NUM_PROPERTIES
};
static GParamSpec* valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_markup_writer_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_markup_writer_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHtmlBasicDocletPrivate {
	ValadocHtmlLinkHelper* _linker;
	ValadocSettings* _settings;
	gchar* _wiki_index_name;
	guint html_id_counter;
};

static gint ValadocHtmlBasicDoclet_private_offset;
static gpointer valadoc_html_basic_doclet_parent_class = NULL;
static ValadocApiNodeType* valadoc_html_basic_doclet_inheritable_members;
static gint valadoc_html_basic_doclet_inheritable_members_length1;
static ValadocApiNodeType* valadoc_html_basic_doclet_inheritable_members = NULL;
static gint valadoc_html_basic_doclet_inheritable_members_length1 = 0;
static gint _valadoc_html_basic_doclet_inheritable_members_size_ = 0;
static ValadocDocletIface * valadoc_html_basic_doclet_valadoc_doclet_parent_iface = NULL;

static void valadoc_html_basic_doclet_real_process (ValadocHtmlBasicDoclet* self,
                                             ValadocSettings* settings,
                                             ValadocApiTree* tree,
                                             ValadocErrorReporter* reporter);
static gchar* valadoc_html_basic_doclet_real_get_img_path_html (ValadocHtmlBasicDoclet* self,
                                                         ValadocApiNode* element,
                                                         const gchar* type);
static gchar* valadoc_html_basic_doclet_real_get_img_path (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* element,
                                                    const gchar* type);
static gchar* valadoc_html_basic_doclet_real_get_icon_directory (ValadocHtmlBasicDoclet* self);
static ValadocApiTypeSymbol* valadoc_html_basic_doclet_unpack_type_reference (ValadocHtmlBasicDoclet* self,
                                                                       ValadocApiTypeReference* type_reference);
static void valadoc_html_basic_doclet_real_write_wiki_page (ValadocHtmlBasicDoclet* self,
                                                     ValadocWikiPage* page,
                                                     const gchar* contentp,
                                                     const gchar* css_path,
                                                     const gchar* js_path,
                                                     const gchar* pkg_name);
static gboolean valadoc_html_basic_doclet_has_brief_description (ValadocHtmlBasicDoclet* self,
                                                          ValadocApiNode* element);
static void valadoc_html_basic_doclet_write_brief_description (ValadocHtmlBasicDoclet* self,
                                                        ValadocApiNode* element,
                                                        ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_documentation (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* element,
                                                    ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_attributes (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiSymbol* element,
                                                 ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_signature (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* element,
                                                ValadocApiNode* pos);
static inline ValaArrayList* valadoc_html_basic_doclet_get_accessible_nodes_from_list (ValadocHtmlBasicDoclet* self,
                                                                         ValaCollection* nodes);
static void valadoc_html_basic_doclet_write_known_symbols_note (ValadocHtmlBasicDoclet* self,
                                                         ValaCollection* nodes2,
                                                         ValadocApiNode* container,
                                                         const gchar* headline);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (ValadocHtmlBasicDoclet* self,
                                                                       ValadocApiClass* cl,
                                                                       ValadocApiNode* container);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (ValadocHtmlBasicDoclet* self,
                                                                           ValadocApiInterface* iface,
                                                                           ValadocApiNode* container);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (ValadocHtmlBasicDoclet* self,
                                                                        ValadocApiStruct* str,
                                                                        ValadocApiNode* container);
static inline gboolean valadoc_html_basic_doclet_has_visible_inheritable_children (ValadocHtmlBasicDoclet* self,
                                                                     ValadocApiTypeSymbol* symbol);
static void valadoc_html_basic_doclet_write_inherited_members_headline (ValadocHtmlBasicDoclet* self);
static void valadoc_html_basic_doclet_write_inherited_symbols_note (ValadocHtmlBasicDoclet* self,
                                                             ValadocApiTypeSymbol* symbol,
                                                             const gchar* type,
                                                             ValadocApiNode* container);
static void valadoc_html_basic_doclet_finalize (GObject * obj);
static GType valadoc_html_basic_doclet_get_type_once (void);
static void _vala_valadoc_html_basic_doclet_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_valadoc_html_basic_doclet_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
valadoc_html_basic_doclet_get_instance_private (ValadocHtmlBasicDoclet* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocHtmlBasicDoclet_private_offset);
}

ValadocHtmlLinkHelper*
valadoc_html_basic_doclet_get_linker (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlLinkHelper* result;
	ValadocHtmlLinkHelper* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_linker;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
valadoc_html_basic_doclet_set_linker (ValadocHtmlBasicDoclet* self,
                                      ValadocHtmlLinkHelper* value)
{
	ValadocHtmlLinkHelper* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_html_basic_doclet_get_linker (self);
	if (old_value != value) {
		ValadocHtmlLinkHelper* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_linker);
		self->priv->_linker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY]);
	}
}

ValadocSettings*
valadoc_html_basic_doclet_get_settings (ValadocHtmlBasicDoclet* self)
{
	ValadocSettings* result;
	ValadocSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
valadoc_html_basic_doclet_set_settings (ValadocHtmlBasicDoclet* self,
                                        ValadocSettings* value)
{
	ValadocSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_html_basic_doclet_get_settings (self);
	if (old_value != value) {
		ValadocSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY]);
	}
}

const gchar*
valadoc_html_basic_doclet_get_wiki_index_name (ValadocHtmlBasicDoclet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wiki_index_name;
	result = _tmp0_;
	return result;
}

void
valadoc_html_basic_doclet_set_wiki_index_name (ValadocHtmlBasicDoclet* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_html_basic_doclet_get_wiki_index_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_wiki_index_name);
		self->priv->_wiki_index_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY]);
	}
}

static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}

static void
valadoc_html_basic_doclet_real_process (ValadocHtmlBasicDoclet* self,
                                        ValadocSettings* settings,
                                        ValadocApiTree* tree,
                                        ValadocErrorReporter* reporter)
{
	ValadocErrorReporter* _tmp0_;
	ValadocApiTree* _tmp1_;
	ValadocHtmlCssClassResolver* _tmp2_;
	ValadocHtmlLinkHelper* _tmp3_;
	ValadocHtmlLinkHelper* _tmp4_;
	ValadocHtmlLinkHelper* _tmp5_;
	ValadocHtmlCssClassResolver* _tmp6_;
	ValadocHtmlHtmlRenderer* _tmp7_;
	ValadocHtmlLinkHelper* _tmp8_;
	ValadocHtmlSimpleChartFactory* _tmp9_;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->reporter);
	self->reporter = _tmp0_;
	valadoc_html_basic_doclet_set_settings (self, settings);
	_tmp1_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->tree);
	self->tree = _tmp1_;
	_tmp2_ = valadoc_html_css_class_resolver_new ();
	_g_object_unref0 (self->cssresolver);
	self->cssresolver = _tmp2_;
	_tmp3_ = valadoc_html_link_helper_new ();
	_tmp4_ = _tmp3_;
	valadoc_html_basic_doclet_set_linker (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_linker;
	_tmp6_ = self->cssresolver;
	_tmp7_ = valadoc_html_html_renderer_new (settings, _tmp5_, _tmp6_);
	_g_object_unref0 (self->_renderer);
	self->_renderer = _tmp7_;
	_tmp8_ = self->priv->_linker;
	_tmp9_ = valadoc_html_simple_chart_factory_new (settings, _tmp8_);
	_g_object_unref0 (self->image_factory);
	self->image_factory = (ValadocChartsFactory*) _tmp9_;
}

void
valadoc_html_basic_doclet_process (ValadocHtmlBasicDoclet* self,
                                   ValadocSettings* settings,
                                   ValadocApiTree* tree,
                                   ValadocErrorReporter* reporter)
{
	ValadocHtmlBasicDocletClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self);
	if (_klass_->process) {
		_klass_->process (self, settings, tree, reporter);
	}
}

gchar*
valadoc_html_basic_doclet_get_link (ValadocHtmlBasicDoclet* self,
                                    ValadocApiNode* to,
                                    ValadocApiNode* from)
{
	ValadocHtmlLinkHelper* _tmp0_;
	ValadocSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	_tmp0_ = self->priv->_linker;
	_tmp1_ = self->priv->_settings;
	_tmp2_ = valadoc_html_link_helper_get_relative_link (_tmp0_, (ValadocDocumentation*) from, (ValadocDocumentation*) to, _tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
valadoc_html_basic_doclet_real_get_img_path_html (ValadocHtmlBasicDoclet* self,
                                                  ValadocApiNode* element,
                                                  const gchar* type)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = valadoc_api_node_get_full_name (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, type, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename ("img", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

gchar*
valadoc_html_basic_doclet_get_img_path_html (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* element,
                                             const gchar* type)
{
	ValadocHtmlBasicDocletClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self);
	if (_klass_->get_img_path_html) {
		return _klass_->get_img_path_html (self, element, type);
	}
	return NULL;
}

static gchar*
valadoc_html_basic_doclet_real_get_img_path (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* element,
                                             const gchar* type)
{
	ValadocSettings* _tmp0_;
	const gchar* _tmp1_;
	ValadocApiPackage* _tmp2_;
	ValadocApiPackage* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = _tmp0_->path;
	_tmp2_ = valadoc_documentation_get_package ((ValadocDocumentation*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = valadoc_api_node_get_full_name (element);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ".", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, type, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename (_tmp1_, _tmp5_, "img", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = _tmp13_;
	return result;
}

gchar*
valadoc_html_basic_doclet_get_img_path (ValadocHtmlBasicDoclet* self,
                                        ValadocApiNode* element,
                                        const gchar* type)
{
	ValadocHtmlBasicDocletClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self);
	if (_klass_->get_img_path) {
		return _klass_->get_img_path (self, element, type);
	}
	return NULL;
}

static gchar*
valadoc_html_basic_doclet_real_get_icon_directory (ValadocHtmlBasicDoclet* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("..");
	result = _tmp0_;
	return result;
}

gchar*
valadoc_html_basic_doclet_get_icon_directory (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlBasicDocletClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self);
	if (_klass_->get_icon_directory) {
		return _klass_->get_icon_directory (self);
	}
	return NULL;
}

static ValadocApiTypeSymbol*
valadoc_html_basic_doclet_unpack_type_reference (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiTypeReference* type_reference)
{
	ValadocApiItem* pos = NULL;
	ValadocApiItem* _tmp0_;
	ValadocApiTypeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 ((ValadocApiItem*) type_reference);
	pos = _tmp0_;
	while (TRUE) {
		ValadocApiItem* _tmp1_;
		ValadocApiItem* _tmp2_;
		_tmp1_ = pos;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = pos;
		if (VALADOC_API_IS_TYPEREFERENCE (_tmp2_)) {
			ValadocApiItem* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			_tmp3_ = pos;
			_tmp4_ = valadoc_api_typereference_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference));
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (pos);
			pos = _tmp6_;
		} else {
			ValadocApiItem* _tmp7_;
			_tmp7_ = pos;
			if (VALADOC_API_IS_ARRAY (_tmp7_)) {
				ValadocApiItem* _tmp8_;
				ValadocApiItem* _tmp9_;
				ValadocApiItem* _tmp10_;
				ValadocApiItem* _tmp11_;
				_tmp8_ = pos;
				_tmp9_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (pos);
				pos = _tmp11_;
			} else {
				ValadocApiItem* _tmp12_;
				_tmp12_ = pos;
				if (VALADOC_API_IS_POINTER (_tmp12_)) {
					ValadocApiItem* _tmp13_;
					ValadocApiItem* _tmp14_;
					ValadocApiItem* _tmp15_;
					ValadocApiItem* _tmp16_;
					_tmp13_ = pos;
					_tmp14_ = valadoc_api_pointer_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_API_TYPE_POINTER, ValadocApiPointer));
					_tmp15_ = _tmp14_;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (pos);
					pos = _tmp16_;
				} else {
					ValadocApiItem* _tmp17_;
					ValadocApiItem* _tmp18_;
					ValadocApiTypeSymbol* _tmp19_;
					_tmp17_ = pos;
					_vala_assert (VALADOC_API_IS_TYPESYMBOL (_tmp17_), "pos is TypeSymbol");
					_tmp18_ = pos;
					_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALADOC_API_TYPE_TYPESYMBOL, ValadocApiTypeSymbol));
					result = _tmp19_;
					_g_object_unref0 (pos);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (pos);
	return result;
}

void
valadoc_html_basic_doclet_write_navi_entry_html_template (ValadocHtmlBasicDoclet* self,
                                                          const gchar* style,
                                                          const gchar* content,
                                                          gboolean is_deprecated)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (style);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "li", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (is_deprecated) {
		ValadocHtmlMarkupWriter* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		ValadocHtmlMarkupWriter* _tmp10_;
		ValadocHtmlMarkupWriter* _tmp11_;
		_tmp5_ = self->writer;
		_tmp6_ = g_strdup ("class");
		_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
		_tmp8_ = g_new0 (gchar*, 2 + 1);
		_tmp8_[0] = _tmp6_;
		_tmp8_[1] = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp9__length1 = 2;
		valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "span", _tmp9_, (gint) 2);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = self->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp10_, content);
		_tmp11_ = self->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "span");
	} else {
		ValadocHtmlMarkupWriter* _tmp12_;
		_tmp12_ = self->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp12_, content);
	}
	_tmp13_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp13_, "li");
}

void
valadoc_html_basic_doclet_write_navi_entry_html_template_with_link (ValadocHtmlBasicDoclet* self,
                                                                    const gchar* style,
                                                                    const gchar* link,
                                                                    const gchar* content,
                                                                    gboolean is_deprecated)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	g_return_if_fail (link != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (style);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "li", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (is_deprecated) {
		ValadocHtmlMarkupWriter* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		ValadocHtmlMarkupWriter* _tmp10_;
		ValadocHtmlMarkupWriter* _tmp11_;
		_tmp5_ = self->writer;
		_tmp6_ = g_strdup ("class");
		_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
		_tmp8_ = g_new0 (gchar*, 2 + 1);
		_tmp8_[0] = _tmp6_;
		_tmp8_[1] = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp9__length1 = 2;
		valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "span", _tmp9_, (gint) 2);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = self->writer;
		valadoc_html_markup_writer_link (_tmp10_, link, content, NULL);
		_tmp11_ = self->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "span");
	} else {
		ValadocHtmlMarkupWriter* _tmp12_;
		_tmp12_ = self->writer;
		valadoc_html_markup_writer_link (_tmp12_, link, content, NULL);
	}
	_tmp13_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp13_, "li");
}

void
valadoc_html_basic_doclet_write_navi_entry (ValadocHtmlBasicDoclet* self,
                                            ValadocApiNode* element,
                                            ValadocApiNode* pos,
                                            const gchar* style,
                                            gboolean link,
                                            gboolean full_name)
{
	gchar* name = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean is_deprecated = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	g_return_if_fail (style != NULL);
	if (full_name == TRUE) {
		_tmp0_ = VALADOC_API_IS_NAMESPACE (element);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* tmp = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gchar* _tmp5_;
		_tmp1_ = valadoc_api_node_get_full_name (element);
		tmp = _tmp1_;
		_tmp3_ = tmp;
		if (_tmp3_ == NULL) {
			_tmp2_ = "Global Namespace";
		} else {
			const gchar* _tmp4_;
			_tmp4_ = tmp;
			_tmp2_ = _tmp4_;
		}
		_tmp5_ = g_strdup (_tmp2_);
		_g_free0 (name);
		name = _tmp5_;
		_g_free0 (tmp);
	} else {
		gchar* tmp = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		gchar* _tmp12_;
		_tmp6_ = valadoc_api_node_get_name (element);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		tmp = _tmp8_;
		_tmp10_ = tmp;
		if (_tmp10_ == NULL) {
			_tmp9_ = "Global Namespace";
		} else {
			const gchar* _tmp11_;
			_tmp11_ = tmp;
			_tmp9_ = _tmp11_;
		}
		_tmp12_ = g_strdup (_tmp9_);
		_g_free0 (name);
		name = _tmp12_;
		_g_free0 (tmp);
	}
	if (VALADOC_API_IS_SYMBOL (element)) {
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		_tmp15_ = _tmp14_;
		_tmp13_ = _tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	is_deprecated = _tmp13_;
	if (link == TRUE) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp16_ = valadoc_html_basic_doclet_get_link (self, element, pos);
		_tmp17_ = _tmp16_;
		_tmp18_ = name;
		valadoc_html_basic_doclet_write_navi_entry_html_template_with_link (self, style, _tmp17_, _tmp18_, is_deprecated);
		_g_free0 (_tmp17_);
	} else {
		const gchar* _tmp19_;
		_tmp19_ = name;
		valadoc_html_basic_doclet_write_navi_entry_html_template (self, style, _tmp19_, is_deprecated);
	}
	_g_free0 (name);
}

void
valadoc_html_basic_doclet_write_wiki_pages (ValadocHtmlBasicDoclet* self,
                                            ValadocApiTree* tree,
                                            const gchar* css_path_wiki,
                                            const gchar* js_path_wiki,
                                            const gchar* contentp)
{
	ValadocWikiPageTree* _tmp0_;
	ValadocWikiPageTree* _tmp1_;
	ValadocWikiPageTree* _tmp2_;
	ValadocWikiPageTree* _tmp3_;
	ValaCollection* pages = NULL;
	ValadocWikiPageTree* _tmp4_;
	ValadocWikiPageTree* _tmp5_;
	ValaCollection* _tmp6_;
	ValaCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (css_path_wiki != NULL);
	g_return_if_fail (js_path_wiki != NULL);
	g_return_if_fail (contentp != NULL);
	_tmp0_ = valadoc_api_tree_get_wikitree (tree);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = valadoc_api_tree_get_wikitree (tree);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = valadoc_api_tree_get_wikitree (tree);
	_tmp5_ = _tmp4_;
	_tmp6_ = valadoc_wiki_page_tree_get_pages (_tmp5_);
	pages = _tmp6_;
	_tmp7_ = pages;
	_tmp8_ = vala_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 0) {
		_vala_iterable_unref0 (pages);
		return;
	}
	g_mkdir (contentp, 0777);
	_tmp10_ = g_build_filename (contentp, "img", NULL);
	_tmp11_ = _tmp10_;
	g_mkdir (_tmp11_, 0777);
	_g_free0 (_tmp11_);
	{
		ValaIterator* _page_it = NULL;
		ValaCollection* _tmp12_;
		ValaIterator* _tmp13_;
		_tmp12_ = pages;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_page_it = _tmp13_;
		while (TRUE) {
			ValaIterator* _tmp14_;
			ValadocWikiPage* page = NULL;
			ValaIterator* _tmp15_;
			gpointer _tmp16_;
			ValadocWikiPage* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = _page_it;
			if (!vala_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _page_it;
			_tmp16_ = vala_iterator_get (_tmp15_);
			page = (ValadocWikiPage*) _tmp16_;
			_tmp17_ = page;
			_tmp18_ = valadoc_wiki_page_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->_wiki_index_name;
			if (g_strcmp0 (_tmp19_, _tmp20_) != 0) {
				ValadocWikiPage* _tmp21_;
				ValadocSettings* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = page;
				_tmp22_ = self->priv->_settings;
				_tmp23_ = _tmp22_->pkg_name;
				valadoc_html_basic_doclet_write_wiki_page (self, _tmp21_, contentp, css_path_wiki, js_path_wiki, _tmp23_);
			}
			_g_object_unref0 (page);
		}
		_vala_iterator_unref0 (_page_it);
	}
	_vala_iterable_unref0 (pages);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
valadoc_html_basic_doclet_real_write_wiki_page (ValadocHtmlBasicDoclet* self,
                                                ValadocWikiPage* page,
                                                const gchar* contentp,
                                                const gchar* css_path,
                                                const gchar* js_path,
                                                const gchar* pkg_name)
{
	FILE* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FILE* _tmp14_;
	FILE* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlHtmlRenderer* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	ValadocHtmlHtmlRenderer* _tmp19_;
	ValadocHtmlHtmlRenderer* _tmp20_;
	ValadocContentPage* _tmp21_;
	ValadocContentPage* _tmp22_;
	g_return_if_fail (page != NULL);
	g_return_if_fail (contentp != NULL);
	g_return_if_fail (css_path != NULL);
	g_return_if_fail (js_path != NULL);
	g_return_if_fail (pkg_name != NULL);
	_tmp0_ = valadoc_wiki_page_get_name (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_wiki_page_get_name (page);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp1_, (glong) 0, (glong) (_tmp5_ - 7));
	_tmp7_ = _tmp6_;
	_tmp8_ = string_replace (_tmp7_, "/", ".");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "htm", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename (contentp, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_fopen (_tmp13_, "w");
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	file = _tmp15_;
	_tmp16_ = valadoc_html_markup_writer_new (file, TRUE);
	_valadoc_markup_writer_unref0 (self->writer);
	self->writer = _tmp16_;
	_tmp17_ = self->_renderer;
	_tmp18_ = self->writer;
	valadoc_html_html_renderer_set_writer (_tmp17_, _tmp18_);
	valadoc_html_basic_doclet_write_file_header (self, css_path, js_path, pkg_name);
	_tmp19_ = self->_renderer;
	valadoc_html_html_renderer_set_container (_tmp19_, (ValadocDocumentation*) page);
	_tmp20_ = self->_renderer;
	_tmp21_ = valadoc_wiki_page_get_documentation (page);
	_tmp22_ = _tmp21_;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp20_, (ValadocContentContentElement*) _tmp22_);
	valadoc_html_basic_doclet_write_file_footer (self);
	_fclose0 (file);
}

void
valadoc_html_basic_doclet_write_wiki_page (ValadocHtmlBasicDoclet* self,
                                           ValadocWikiPage* page,
                                           const gchar* contentp,
                                           const gchar* css_path,
                                           const gchar* js_path,
                                           const gchar* pkg_name)
{
	ValadocHtmlBasicDocletClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self);
	if (_klass_->write_wiki_page) {
		_klass_->write_wiki_page (self, page, contentp, css_path, js_path, pkg_name);
	}
}

void
valadoc_html_basic_doclet_write_navi_top_entry (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* element,
                                                ValadocApiNode* parent)
{
	gchar* style = NULL;
	ValadocHtmlCssClassResolver* _tmp0_;
	gchar* _tmp1_;
	ValadocHtmlMarkupWriter* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp7_ = FALSE;
	ValadocHtmlMarkupWriter* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->cssresolver;
	_tmp1_ = valadoc_html_css_class_resolver_resolve (_tmp0_, element);
	style = _tmp1_;
	_tmp2_ = self->writer;
	_tmp3_ = g_strdup ("class");
	_tmp4_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp2_, "ul", _tmp6_, (gint) 2);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	if (element == parent) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = parent == NULL;
	}
	if (_tmp7_) {
		const gchar* _tmp8_;
		_tmp8_ = style;
		valadoc_html_basic_doclet_write_navi_entry (self, element, parent, _tmp8_, FALSE, FALSE);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = style;
		valadoc_html_basic_doclet_write_navi_entry (self, element, parent, _tmp9_, TRUE, FALSE);
	}
	_tmp10_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp10_, "ul");
	_tmp11_ = self->writer;
	_tmp12_ = g_strdup ("class");
	_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi_hr);
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp11_, "hr", _tmp15_, (gint) 2);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (style);
}

void
valadoc_html_basic_doclet_write_top_element_template (ValadocHtmlBasicDoclet* self,
                                                      const gchar* link)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	ValadocHtmlMarkupWriter* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	ValadocHtmlMarkupWriter* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (link != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = self->writer;
	_tmp6_ = g_strdup ("class");
	_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_package_index);
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "li", _tmp9_, (gint) 2);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = self->writer;
	valadoc_html_markup_writer_link (_tmp10_, link, "Packages", NULL);
	_tmp11_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "li");
	_tmp12_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp12_, "ul");
	_tmp13_ = self->writer;
	_tmp14_ = g_strdup ("class");
	_tmp15_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi_hr);
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp14_;
	_tmp16_[1] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp13_, "hr", _tmp17_, (gint) 2);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
}

void
valadoc_html_basic_doclet_write_top_elements (ValadocHtmlBasicDoclet* self,
                                              ValadocApiNode* element,
                                              ValadocApiNode* parent)
{
	ValaArrayList* lst = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocApiNode* pos = NULL;
	ValadocApiNode* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	lst = _tmp1_;
	_tmp2_ = _g_object_ref0 (element);
	pos = _tmp2_;
	_tmp3_ = self->package_list_link;
	valadoc_html_basic_doclet_write_top_element_template (self, _tmp3_);
	while (TRUE) {
		ValadocApiNode* _tmp4_;
		ValaArrayList* _tmp5_;
		ValadocApiNode* _tmp6_;
		ValadocApiNode* _tmp7_;
		ValadocApiItem* _tmp8_;
		ValadocApiItem* _tmp9_;
		ValadocApiNode* _tmp10_;
		_tmp4_ = pos;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = lst;
		_tmp6_ = pos;
		vala_collection_add ((ValaCollection*) _tmp5_, _tmp6_);
		_tmp7_ = pos;
		_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_NODE, ValadocApiNode));
		_g_object_unref0 (pos);
		pos = _tmp10_;
	}
	{
		gint i = 0;
		ValaArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = lst;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		i = _tmp13_ - 1;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				ValadocApiNode* el = NULL;
				ValaArrayList* _tmp16_;
				gpointer _tmp17_;
				ValadocApiNode* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ - 1;
				}
				_tmp14_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp16_ = lst;
				_tmp17_ = vala_list_get ((ValaList*) _tmp16_, i);
				el = (ValadocApiNode*) _tmp17_;
				_tmp18_ = el;
				_tmp19_ = valadoc_api_node_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ != NULL) {
					ValadocApiNode* _tmp21_;
					_tmp21_ = el;
					valadoc_html_basic_doclet_write_navi_top_entry (self, _tmp21_, parent);
				}
				_g_object_unref0 (el);
			}
		}
	}
	_g_object_unref0 (pos);
	_vala_iterable_unref0 (lst);
}

void
valadoc_html_basic_doclet_fetch_subnamespace_names (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* node,
                                                    ValaArrayList* namespaces)
{
	ValaList* children = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (namespaces != NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, VALADOC_API_NODE_TYPE_NAMESPACE, TRUE);
	children = _tmp0_;
	_tmp1_ = children;
	vala_list_sort (_tmp1_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp2_;
		gint _child_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
		_tmp2_ = children;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValadocApiNode* _tmp10_;
			ValadocApiNode* _tmp11_;
			_child_index = _child_index + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = vala_list_get (_tmp8_, _child_index);
			child = (ValadocApiNode*) _tmp9_;
			_tmp10_ = child;
			vala_collection_add ((ValaCollection*) namespaces, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
			_tmp11_ = child;
			valadoc_html_basic_doclet_fetch_subnamespace_names (self, _tmp11_, namespaces);
			_g_object_unref0 (child);
		}
	}
	_vala_iterable_unref0 (children);
}

void
valadoc_html_basic_doclet_write_navi_package (ValadocHtmlBasicDoclet* self,
                                              ValadocApiPackage* package)
{
	ValaArrayList* ns_list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValadocHtmlMarkupWriter* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	ValadocApiNamespace* globals = NULL;
	ValadocApiNamespace* _tmp31_;
	ValadocHtmlMarkupWriter* _tmp46_;
	ValadocHtmlMarkupWriter* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	ns_list = _tmp1_;
	_tmp2_ = ns_list;
	valadoc_html_basic_doclet_fetch_subnamespace_names (self, (ValadocApiNode*) package, _tmp2_);
	_tmp3_ = self->writer;
	_tmp4_ = g_strdup ("class");
	_tmp5_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "div", _tmp7_, (gint) 2);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_top_elements (self, (ValadocApiNode*) package, (ValadocApiNode*) package);
	_tmp8_ = self->writer;
	_tmp9_ = g_strdup ("class");
	_tmp10_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp8_, "ul", _tmp12_, (gint) 2);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	globals = NULL;
	{
		ValaArrayList* _ns_list = NULL;
		ValaArrayList* _tmp13_;
		gint _ns_size = 0;
		ValaArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _ns_index = 0;
		_tmp13_ = ns_list;
		_ns_list = _tmp13_;
		_tmp14_ = _ns_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_ns_size = _tmp16_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValadocApiNamespace* ns = NULL;
			ValaArrayList* _tmp19_;
			gpointer _tmp20_;
			ValadocApiNamespace* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_ns_index = _ns_index + 1;
			_tmp17_ = _ns_index;
			_tmp18_ = _ns_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _ns_list;
			_tmp20_ = vala_list_get ((ValaList*) _tmp19_, _ns_index);
			ns = (ValadocApiNamespace*) _tmp20_;
			_tmp21_ = ns;
			_tmp22_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ == NULL) {
				ValadocApiNamespace* _tmp24_;
				ValadocApiNamespace* _tmp25_;
				_tmp24_ = ns;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				_g_object_unref0 (globals);
				globals = _tmp25_;
			} else {
				ValadocApiNamespace* _tmp26_;
				ValadocHtmlCssClassResolver* _tmp27_;
				ValadocApiNamespace* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp26_ = ns;
				_tmp27_ = self->cssresolver;
				_tmp28_ = ns;
				_tmp29_ = valadoc_html_css_class_resolver_resolve (_tmp27_, (ValadocApiNode*) _tmp28_);
				_tmp30_ = _tmp29_;
				valadoc_html_basic_doclet_write_navi_entry (self, (ValadocApiNode*) _tmp26_, (ValadocApiNode*) package, _tmp30_, TRUE, TRUE);
				_g_free0 (_tmp30_);
			}
			_g_object_unref0 (ns);
		}
	}
	_tmp31_ = globals;
	if (_tmp31_ != NULL) {
		ValadocApiNamespace* _tmp32_;
		ValadocApiNamespace* _tmp33_;
		ValadocApiNamespace* _tmp34_;
		ValadocApiNamespace* _tmp35_;
		ValadocApiNamespace* _tmp36_;
		ValadocApiNamespace* _tmp37_;
		ValadocApiNamespace* _tmp38_;
		ValadocApiNamespace* _tmp39_;
		ValadocApiNamespace* _tmp40_;
		ValadocApiNamespace* _tmp41_;
		ValadocApiNamespace* _tmp42_;
		ValadocApiNamespace* _tmp43_;
		ValadocApiNamespace* _tmp44_;
		ValadocApiNamespace* _tmp45_;
		_tmp32_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp32_, VALADOC_API_NODE_TYPE_ERROR_CODE, (ValadocApiNode*) package);
		_tmp33_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp33_, VALADOC_API_NODE_TYPE_ENUM_VALUE, (ValadocApiNode*) package);
		_tmp34_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp34_, VALADOC_API_NODE_TYPE_ENUM, (ValadocApiNode*) package);
		_tmp35_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp35_, VALADOC_API_NODE_TYPE_INTERFACE, (ValadocApiNode*) package);
		_tmp36_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp36_, VALADOC_API_NODE_TYPE_CLASS, (ValadocApiNode*) package);
		_tmp37_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp37_, VALADOC_API_NODE_TYPE_STRUCT, (ValadocApiNode*) package);
		_tmp38_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp38_, VALADOC_API_NODE_TYPE_CONSTANT, (ValadocApiNode*) package);
		_tmp39_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp39_, VALADOC_API_NODE_TYPE_PROPERTY, (ValadocApiNode*) package);
		_tmp40_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp40_, VALADOC_API_NODE_TYPE_DELEGATE, (ValadocApiNode*) package);
		_tmp41_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp41_, VALADOC_API_NODE_TYPE_STATIC_METHOD, (ValadocApiNode*) package);
		_tmp42_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp42_, VALADOC_API_NODE_TYPE_CREATION_METHOD, (ValadocApiNode*) package);
		_tmp43_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp43_, VALADOC_API_NODE_TYPE_METHOD, (ValadocApiNode*) package);
		_tmp44_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp44_, VALADOC_API_NODE_TYPE_SIGNAL, (ValadocApiNode*) package);
		_tmp45_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp45_, VALADOC_API_NODE_TYPE_FIELD, (ValadocApiNode*) package);
	}
	_tmp46_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp46_, "ul");
	_tmp47_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp47_, "div");
	_g_object_unref0 (globals);
	_vala_iterable_unref0 (ns_list);
}

void
valadoc_html_basic_doclet_write_navi_symbol (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* node)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_top_elements (self, node, node);
	valadoc_html_basic_doclet_write_navi_symbol_inline (self, node, node);
	_tmp5_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp5_, "div");
}

void
valadoc_html_basic_doclet_write_navi_leaf_symbol (ValadocHtmlBasicDoclet* self,
                                                  ValadocApiNode* node)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocApiItem* _tmp5_;
	ValadocApiItem* _tmp6_;
	ValadocApiItem* _tmp7_;
	ValadocApiItem* _tmp8_;
	ValadocHtmlMarkupWriter* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
	_tmp6_ = _tmp5_;
	valadoc_html_basic_doclet_write_top_elements (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALADOC_API_TYPE_NODE, ValadocApiNode), node);
	_tmp7_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
	_tmp8_ = _tmp7_;
	valadoc_html_basic_doclet_write_navi_symbol_inline (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_NODE, ValadocApiNode), node);
	_tmp9_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp9_, "div");
}

void
valadoc_html_basic_doclet_write_navi_symbol_inline (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* node,
                                                    ValadocApiNode* parent)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_NAMESPACE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_ERROR_CODE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_ENUM_VALUE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_ENUM, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_INTERFACE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_CLASS, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_STRUCT, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_CONSTANT, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_PROPERTY, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_DELEGATE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_STATIC_METHOD, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_CREATION_METHOD, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_METHOD, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_SIGNAL, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_FIELD, parent);
	_tmp5_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp5_, "ul");
}

void
valadoc_html_basic_doclet_write_navi_children (ValadocHtmlBasicDoclet* self,
                                               ValadocApiNode* node,
                                               ValadocApiNodeType type,
                                               ValadocApiNode* parent)
{
	ValaList* children = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, type, TRUE);
	children = _tmp0_;
	_tmp1_ = children;
	vala_list_sort (_tmp1_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp2_;
		gint _child_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
		_tmp2_ = children;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValadocApiNode* _tmp10_;
			ValadocHtmlCssClassResolver* _tmp11_;
			ValadocApiNode* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			ValadocApiNode* _tmp15_;
			_child_index = _child_index + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = vala_list_get (_tmp8_, _child_index);
			child = (ValadocApiNode*) _tmp9_;
			_tmp10_ = child;
			_tmp11_ = self->cssresolver;
			_tmp12_ = child;
			_tmp13_ = valadoc_html_css_class_resolver_resolve (_tmp11_, _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = child;
			valadoc_html_basic_doclet_write_navi_entry (self, _tmp10_, parent, _tmp14_, _tmp15_ != parent, FALSE);
			_g_free0 (_tmp14_);
			_g_object_unref0 (child);
		}
	}
	_vala_iterable_unref0 (children);
}

void
valadoc_html_basic_doclet_write_package_note (ValadocHtmlBasicDoclet* self,
                                              ValadocApiNode* element)
{
	gchar* package = NULL;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValadocHtmlMarkupWriter* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocHtmlMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	gchar* _tmp16_;
	ValadocApiPackage* _tmp17_;
	ValadocApiPackage* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	ValadocMarkupWriter* _tmp22_;
	const gchar* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocHtmlMarkupWriter* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_documentation_get_package ((ValadocDocumentation*) element);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	package = _tmp4_;
	_tmp5_ = package;
	if (_tmp5_ == NULL) {
		_g_free0 (package);
		return;
	}
	_tmp6_ = self->writer;
	_tmp7_ = g_strdup ("class");
	_tmp8_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_package_note);
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "div", _tmp10_, (gint) 2);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = self->writer;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "b", NULL, (gint) 0);
	_tmp13_ = valadoc_markup_writer_text (_tmp12_, "Package:");
	valadoc_markup_writer_end_tag (_tmp13_, "b");
	_tmp14_ = self->writer;
	_tmp15_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp14_, " ");
	_tmp16_ = g_strdup ("href");
	_tmp17_ = valadoc_documentation_get_package ((ValadocDocumentation*) element);
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp18_, element);
	_tmp20_ = g_new0 (gchar*, 2 + 1);
	_tmp20_[0] = _tmp16_;
	_tmp20_[1] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 2;
	_tmp22_ = valadoc_markup_writer_start_tag (_tmp15_, "a", _tmp21_, (gint) 2);
	_tmp23_ = package;
	_tmp24_ = valadoc_markup_writer_text (_tmp22_, _tmp23_);
	valadoc_markup_writer_end_tag (_tmp24_, "a");
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp25_, "div");
	_g_free0 (package);
}

void
valadoc_html_basic_doclet_write_namespace_note (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* element)
{
	ValadocApiNamespace* ns = NULL;
	ValadocApiNamespace* _tmp0_;
	ValadocApiNamespace* _tmp1_;
	ValadocApiNamespace* _tmp2_;
	ValadocApiNamespace* _tmp3_;
	ValadocApiNamespace* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocHtmlMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	gchar* _tmp17_;
	ValadocApiNamespace* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	ValadocMarkupWriter* _tmp22_;
	ValadocApiNamespace* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValadocMarkupWriter* _tmp26_;
	ValadocHtmlMarkupWriter* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_api_node_get_nspace (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ns = _tmp2_;
	_tmp3_ = ns;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (ns);
		return;
	}
	_tmp4_ = ns;
	_tmp5_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (ns);
		return;
	}
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_namespace_note);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "div", _tmp11_, (gint) 2);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = self->writer;
	_tmp13_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "b", NULL, (gint) 0);
	_tmp14_ = valadoc_markup_writer_text (_tmp13_, "Namespace:");
	valadoc_markup_writer_end_tag (_tmp14_, "b");
	_tmp15_ = self->writer;
	_tmp16_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp15_, " ");
	_tmp17_ = g_strdup ("href");
	_tmp18_ = ns;
	_tmp19_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp18_, element);
	_tmp20_ = g_new0 (gchar*, 2 + 1);
	_tmp20_[0] = _tmp17_;
	_tmp20_[1] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 2;
	_tmp22_ = valadoc_markup_writer_start_tag (_tmp16_, "a", _tmp21_, (gint) 2);
	_tmp23_ = ns;
	_tmp24_ = valadoc_api_node_get_full_name ((ValadocApiNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = valadoc_markup_writer_text (_tmp22_, _tmp25_);
	valadoc_markup_writer_end_tag (_tmp26_, "a");
	_g_free0 (_tmp25_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp27_, "div");
	_g_object_unref0 (ns);
}

static gboolean
valadoc_html_basic_doclet_has_brief_description (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiNode* element)
{
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element != NULL, FALSE);
	_tmp0_ = valadoc_api_node_get_documentation (element);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != NULL;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
valadoc_html_basic_doclet_write_brief_description (ValadocHtmlBasicDoclet* self,
                                                   ValadocApiNode* element,
                                                   ValadocApiNode* pos)
{
	ValadocContentComment* doctree = NULL;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentComment* _tmp3_;
	ValaList* description = NULL;
	ValadocContentComment* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_api_node_get_documentation (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doctree = _tmp2_;
	_tmp3_ = doctree;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (doctree);
		return;
	}
	_tmp4_ = doctree;
	_tmp5_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	description = _tmp7_;
	_tmp8_ = description;
	_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		ValadocHtmlMarkupWriter* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		ValadocHtmlHtmlRenderer* _tmp16_;
		ValadocHtmlHtmlRenderer* _tmp17_;
		ValadocHtmlHtmlRenderer* _tmp18_;
		ValaList* _tmp19_;
		gpointer _tmp20_;
		ValadocContentBlock* _tmp21_;
		ValadocHtmlHtmlRenderer* _tmp22_;
		ValadocHtmlMarkupWriter* _tmp23_;
		_tmp11_ = self->writer;
		_tmp12_ = g_strdup ("class");
		_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_brief_description);
		_tmp14_ = g_new0 (gchar*, 2 + 1);
		_tmp14_[0] = _tmp12_;
		_tmp14_[1] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 2;
		valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "span", _tmp15_, (gint) 2);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp16_ = self->_renderer;
		valadoc_html_html_renderer_set_container (_tmp16_, (ValadocDocumentation*) pos);
		_tmp17_ = self->_renderer;
		valadoc_html_html_renderer_set_owner (_tmp17_, (ValadocDocumentation*) element);
		_tmp18_ = self->_renderer;
		_tmp19_ = description;
		_tmp20_ = vala_list_get (_tmp19_, 0);
		_tmp21_ = (ValadocContentBlock*) _tmp20_;
		valadoc_content_content_renderer_render_children ((ValadocContentContentRenderer*) _tmp18_, (ValadocContentContentElement*) _tmp21_);
		_g_object_unref0 (_tmp21_);
		_tmp22_ = self->_renderer;
		valadoc_html_html_renderer_set_owner (_tmp22_, NULL);
		_tmp23_ = self->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp23_, "span");
	}
	_vala_iterable_unref0 (description);
	_g_object_unref0 (doctree);
}

static void
valadoc_html_basic_doclet_write_documentation (ValadocHtmlBasicDoclet* self,
                                               ValadocApiNode* element,
                                               ValadocApiNode* pos)
{
	ValadocContentComment* doctree = NULL;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean is_deprecated = FALSE;
	gboolean _tmp6_ = FALSE;
	ValadocContentComment* _tmp7_;
	ValadocHtmlMarkupWriter* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	ValadocHtmlHtmlRenderer* _tmp13_;
	ValadocContentComment* _tmp90_;
	ValadocHtmlHtmlRenderer* _tmp94_;
	ValadocHtmlMarkupWriter* _tmp95_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_api_node_get_documentation (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doctree = _tmp2_;
	if (VALADOC_API_IS_SYMBOL (element)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	is_deprecated = _tmp3_;
	_tmp7_ = doctree;
	if (_tmp7_ == NULL) {
		_tmp6_ = !is_deprecated;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_g_object_unref0 (doctree);
		return;
	}
	_tmp8_ = self->writer;
	_tmp9_ = g_strdup ("class");
	_tmp10_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_description);
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp8_, "div", _tmp12_, (gint) 2);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = self->_renderer;
	valadoc_html_html_renderer_set_owner (_tmp13_, (ValadocDocumentation*) element);
	if (is_deprecated) {
		ValadocApiSymbol* symbol = NULL;
		ValadocApiSymbol* _tmp14_;
		ValadocApiAttribute* version = NULL;
		ValadocApiAttribute* deprecated = NULL;
		gchar* replacement = NULL;
		gchar* since = NULL;
		ValadocApiSymbol* _tmp15_;
		ValadocApiAttribute* _tmp16_;
		ValadocApiAttribute* _tmp17_;
		ValadocHtmlMarkupWriter* _tmp37_;
		ValadocHtmlMarkupWriter* _tmp38_;
		ValadocHtmlMarkupWriter* _tmp39_;
		ValadocHtmlMarkupWriter* _tmp40_;
		ValadocHtmlMarkupWriter* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		const gchar* _tmp46_;
		ValadocHtmlMarkupWriter* _tmp51_;
		gboolean _tmp52_ = FALSE;
		const gchar* _tmp53_;
		ValadocHtmlMarkupWriter* _tmp89_;
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		symbol = _tmp14_;
		_tmp15_ = symbol;
		_tmp16_ = valadoc_api_symbol_get_attribute (_tmp15_, "Version");
		_g_object_unref0 (version);
		version = _tmp16_;
		_tmp17_ = version;
		if (_tmp17_ != NULL) {
			ValadocApiAttribute* _tmp18_;
			ValaCodeNode* _tmp19_;
			ValaCodeNode* _tmp20_;
			gchar* _tmp21_;
			ValadocApiAttribute* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaCodeNode* _tmp24_;
			gchar* _tmp25_;
			_tmp18_ = version;
			_tmp19_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "replacement", NULL);
			_g_free0 (replacement);
			replacement = _tmp21_;
			_tmp22_ = version;
			_tmp23_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "deprecated_since", NULL);
			_g_free0 (since);
			since = _tmp25_;
		} else {
			ValadocApiSymbol* _tmp26_;
			ValadocApiAttribute* _tmp27_;
			ValadocApiAttribute* _tmp28_;
			_tmp26_ = symbol;
			_tmp27_ = valadoc_api_symbol_get_attribute (_tmp26_, "Deprecated");
			_g_object_unref0 (deprecated);
			deprecated = _tmp27_;
			_tmp28_ = deprecated;
			if (_tmp28_ != NULL) {
				ValadocApiAttribute* _tmp29_;
				ValaCodeNode* _tmp30_;
				ValaCodeNode* _tmp31_;
				gchar* _tmp32_;
				ValadocApiAttribute* _tmp33_;
				ValaCodeNode* _tmp34_;
				ValaCodeNode* _tmp35_;
				gchar* _tmp36_;
				_tmp29_ = deprecated;
				_tmp30_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "replacement", NULL);
				_g_free0 (replacement);
				replacement = _tmp32_;
				_tmp33_ = deprecated;
				_tmp34_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "version", NULL);
				_g_free0 (since);
				since = _tmp36_;
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp37_ = self->writer;
		valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp37_, "p", NULL, (gint) 0);
		_tmp38_ = self->writer;
		valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp38_, "b", NULL, (gint) 0);
		_tmp39_ = self->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp39_, "Warning:");
		_tmp40_ = self->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp40_, "b");
		_tmp41_ = self->writer;
		_tmp42_ = valadoc_api_node_get_name (element);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf (" %s is deprecated", _tmp43_);
		_tmp45_ = _tmp44_;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp41_, _tmp45_);
		_g_free0 (_tmp45_);
		_tmp46_ = since;
		if (_tmp46_ != NULL) {
			ValadocHtmlMarkupWriter* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp47_ = self->writer;
			_tmp48_ = since;
			_tmp49_ = g_strdup_printf (" since %s", _tmp48_);
			_tmp50_ = _tmp49_;
			valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp47_, _tmp50_);
			_g_free0 (_tmp50_);
		}
		_tmp51_ = self->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp51_, ".");
		_tmp53_ = replacement;
		if (_tmp53_ != NULL) {
			const gchar* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			_tmp54_ = replacement;
			_tmp55_ = strlen (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp52_ = _tmp56_ > 2;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			ValadocApiNode* replacement_node = NULL;
			ValadocApiTree* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValadocApiNode* _tmp64_;
			ValadocApiNode* _tmp65_;
			ValadocHtmlMarkupWriter* _tmp66_;
			ValadocApiNode* _tmp67_;
			ValadocHtmlMarkupWriter* _tmp88_;
			_tmp57_ = self->tree;
			_tmp58_ = replacement;
			_tmp59_ = replacement;
			_tmp60_ = strlen (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = string_substring (_tmp58_, (glong) 1, (glong) (_tmp61_ - 2));
			_tmp63_ = _tmp62_;
			_tmp64_ = valadoc_api_tree_search_symbol_str (_tmp57_, pos, _tmp63_);
			_tmp65_ = _tmp64_;
			_g_free0 (_tmp63_);
			replacement_node = _tmp65_;
			_tmp66_ = self->writer;
			valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp66_, " Use ");
			_tmp67_ = replacement_node;
			if (_tmp67_ == NULL) {
				ValadocHtmlMarkupWriter* _tmp68_;
				const gchar* _tmp69_;
				_tmp68_ = self->writer;
				_tmp69_ = replacement;
				valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp68_, _tmp69_);
			} else {
				gchar* link = NULL;
				ValadocApiNode* _tmp70_;
				gchar* _tmp71_;
				const gchar* _tmp72_;
				_tmp70_ = replacement_node;
				_tmp71_ = valadoc_html_basic_doclet_get_link (self, _tmp70_, pos);
				link = _tmp71_;
				_tmp72_ = link;
				if (_tmp72_ != NULL) {
					gchar* css = NULL;
					ValadocHtmlCssClassResolver* _tmp73_;
					ValadocApiNode* _tmp74_;
					gchar* _tmp75_;
					ValadocHtmlMarkupWriter* _tmp76_;
					const gchar* _tmp77_;
					ValadocApiNode* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					const gchar* _tmp81_;
					_tmp73_ = self->cssresolver;
					_tmp74_ = replacement_node;
					_tmp75_ = valadoc_html_css_class_resolver_resolve (_tmp73_, _tmp74_);
					css = _tmp75_;
					_tmp76_ = self->writer;
					_tmp77_ = link;
					_tmp78_ = replacement_node;
					_tmp79_ = valadoc_api_node_get_full_name (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = css;
					valadoc_html_markup_writer_link (_tmp76_, _tmp77_, _tmp80_, _tmp81_);
					_g_free0 (_tmp80_);
					_g_free0 (css);
				} else {
					ValadocHtmlMarkupWriter* _tmp82_;
					ValadocMarkupWriter* _tmp83_;
					ValadocApiNode* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					ValadocMarkupWriter* _tmp87_;
					_tmp82_ = self->writer;
					_tmp83_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp82_, "code", NULL, (gint) 0);
					_tmp84_ = replacement_node;
					_tmp85_ = valadoc_api_node_get_full_name (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = valadoc_markup_writer_text (_tmp83_, _tmp86_);
					valadoc_markup_writer_end_tag (_tmp87_, "code");
					_g_free0 (_tmp86_);
				}
				_g_free0 (link);
			}
			_tmp88_ = self->writer;
			valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp88_, ".");
			_g_object_unref0 (replacement_node);
		}
		_tmp89_ = self->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp89_, "p");
		_g_free0 (since);
		_g_free0 (replacement);
		_g_object_unref0 (deprecated);
		_g_object_unref0 (version);
		_g_object_unref0 (symbol);
	}
	_tmp90_ = doctree;
	if (_tmp90_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp91_;
		ValadocHtmlHtmlRenderer* _tmp92_;
		ValadocContentComment* _tmp93_;
		_tmp91_ = self->_renderer;
		valadoc_html_html_renderer_set_container (_tmp91_, (ValadocDocumentation*) pos);
		_tmp92_ = self->_renderer;
		_tmp93_ = doctree;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp92_, (ValadocContentContentElement*) _tmp93_);
	}
	_tmp94_ = self->_renderer;
	valadoc_html_html_renderer_set_owner (_tmp94_, NULL);
	_tmp95_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp95_, "div");
	_g_object_unref0 (doctree);
}

static void
valadoc_html_basic_doclet_write_attributes (ValadocHtmlBasicDoclet* self,
                                            ValadocApiSymbol* element,
                                            ValadocApiNode* pos)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlHtmlRenderer* _tmp1_;
	ValadocHtmlMarkupWriter* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = self->_renderer;
	valadoc_html_html_renderer_set_container (_tmp1_, (ValadocDocumentation*) pos);
	{
		ValaIterator* _att_it = NULL;
		ValaCollection* _tmp2_;
		ValaCollection* _tmp3_;
		ValaIterator* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp2_ = valadoc_api_symbol_get_attributes (element);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_iterable_iterator ((ValaIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_iterable_unref0 (_tmp3_);
		_att_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			ValadocApiAttribute* att = NULL;
			ValaIterator* _tmp7_;
			gpointer _tmp8_;
			ValadocHtmlHtmlRenderer* _tmp9_;
			ValadocApiAttribute* _tmp10_;
			ValadocContentInline* _tmp11_;
			ValadocContentInline* _tmp12_;
			ValadocHtmlMarkupWriter* _tmp13_;
			_tmp6_ = _att_it;
			if (!vala_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _att_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			att = (ValadocApiAttribute*) _tmp8_;
			_tmp9_ = self->_renderer;
			_tmp10_ = att;
			_tmp11_ = valadoc_api_item_get_signature ((ValadocApiItem*) _tmp10_);
			_tmp12_ = _tmp11_;
			valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp9_, (ValadocContentContentElement*) _tmp12_);
			_tmp13_ = self->writer;
			valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp13_, "br", NULL, (gint) 0);
			_g_object_unref0 (att);
		}
		_vala_iterator_unref0 (_att_it);
	}
	_tmp14_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp14_, TRUE);
}

static void
valadoc_html_basic_doclet_write_signature (ValadocHtmlBasicDoclet* self,
                                           ValadocApiNode* element,
                                           ValadocApiNode* pos)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlHtmlRenderer* _tmp1_;
	ValadocHtmlHtmlRenderer* _tmp2_;
	ValadocContentInline* _tmp3_;
	ValadocContentInline* _tmp4_;
	ValadocHtmlMarkupWriter* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = self->_renderer;
	valadoc_html_html_renderer_set_container (_tmp1_, (ValadocDocumentation*) pos);
	_tmp2_ = self->_renderer;
	_tmp3_ = valadoc_api_item_get_signature ((ValadocApiItem*) element);
	_tmp4_ = _tmp3_;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp2_, (ValadocContentContentElement*) _tmp4_);
	_tmp5_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp5_, TRUE);
}

gboolean
valadoc_html_basic_doclet_is_internal_node (ValadocHtmlBasicDoclet* self,
                                            ValadocApiNode* node)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (VALADOC_API_IS_PACKAGE (node)) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = VALADOC_API_IS_NAMESPACE (node);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = VALADOC_API_IS_INTERFACE (node);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = VALADOC_API_IS_CLASS (node);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = VALADOC_API_IS_STRUCT (node);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALADOC_API_IS_ENUM (node);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALADOC_API_IS_ENUM_VALUE (node);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALADOC_API_IS_ERROR_DOMAIN (node);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALADOC_API_IS_ERROR_CODE (node);
	}
	result = _tmp0_;
	return result;
}

void
valadoc_html_basic_doclet_write_navi_packages_inline (ValadocHtmlBasicDoclet* self,
                                                      ValadocApiTree* tree)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaIterator* _pkg_it = NULL;
		ValaCollection* _tmp5_;
		ValaCollection* _tmp6_;
		ValaIterator* _tmp7_;
		ValaIterator* _tmp8_;
		_tmp5_ = valadoc_api_tree_get_package_list (tree);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_iterable_iterator ((ValaIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_vala_iterable_unref0 (_tmp6_);
		_pkg_it = _tmp8_;
		while (TRUE) {
			ValaIterator* _tmp9_;
			ValadocApiPackage* pkg = NULL;
			ValaIterator* _tmp10_;
			gpointer _tmp11_;
			ValadocApiPackage* _tmp12_;
			ValadocSettings* _tmp13_;
			_tmp9_ = _pkg_it;
			if (!vala_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _pkg_it;
			_tmp11_ = vala_iterator_get (_tmp10_);
			pkg = (ValadocApiPackage*) _tmp11_;
			_tmp12_ = pkg;
			_tmp13_ = self->priv->_settings;
			if (valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp12_, _tmp13_)) {
				ValadocHtmlMarkupWriter* _tmp14_;
				gchar* _tmp15_;
				ValadocHtmlCssClassResolver* _tmp16_;
				ValadocApiPackage* _tmp17_;
				gchar* _tmp18_;
				gchar** _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				ValadocHtmlMarkupWriter* _tmp21_;
				ValadocHtmlLinkHelper* _tmp22_;
				ValadocApiPackage* _tmp23_;
				ValadocSettings* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValadocApiPackage* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValadocHtmlMarkupWriter* _tmp30_;
				_tmp14_ = self->writer;
				_tmp15_ = g_strdup ("class");
				_tmp16_ = self->cssresolver;
				_tmp17_ = pkg;
				_tmp18_ = valadoc_html_css_class_resolver_resolve (_tmp16_, (ValadocApiNode*) _tmp17_);
				_tmp19_ = g_new0 (gchar*, 2 + 1);
				_tmp19_[0] = _tmp15_;
				_tmp19_[1] = _tmp18_;
				_tmp20_ = _tmp19_;
				_tmp20__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "li", _tmp20_, (gint) 2);
				_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
				_tmp21_ = self->writer;
				_tmp22_ = self->priv->_linker;
				_tmp23_ = pkg;
				_tmp24_ = self->priv->_settings;
				_tmp25_ = valadoc_html_link_helper_get_package_link (_tmp22_, _tmp23_, _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = pkg;
				_tmp28_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp27_);
				_tmp29_ = _tmp28_;
				valadoc_html_markup_writer_link (_tmp21_, _tmp26_, _tmp29_, NULL);
				_g_free0 (_tmp26_);
				_tmp30_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp30_, "li");
			} else {
				ValadocHtmlMarkupWriter* _tmp31_;
				gchar* _tmp32_;
				ValadocHtmlCssClassResolver* _tmp33_;
				ValadocApiPackage* _tmp34_;
				gchar* _tmp35_;
				gchar** _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				ValadocHtmlMarkupWriter* _tmp38_;
				ValadocApiPackage* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				ValadocHtmlMarkupWriter* _tmp42_;
				_tmp31_ = self->writer;
				_tmp32_ = g_strdup ("class");
				_tmp33_ = self->cssresolver;
				_tmp34_ = pkg;
				_tmp35_ = valadoc_html_css_class_resolver_resolve (_tmp33_, (ValadocApiNode*) _tmp34_);
				_tmp36_ = g_new0 (gchar*, 2 + 1);
				_tmp36_[0] = _tmp32_;
				_tmp36_[1] = _tmp35_;
				_tmp37_ = _tmp36_;
				_tmp37__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp31_, "li", _tmp37_, (gint) 2);
				_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
				_tmp38_ = self->writer;
				_tmp39_ = pkg;
				_tmp40_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp38_, _tmp41_);
				_tmp42_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp42_, "li");
			}
			_g_object_unref0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	_tmp43_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp43_, "ul");
}

void
valadoc_html_basic_doclet_write_navi_packages (ValadocHtmlBasicDoclet* self,
                                               ValadocApiTree* tree)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_navi_packages_inline (self, tree);
	_tmp5_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp5_, "div");
}

void
valadoc_html_basic_doclet_write_package_index_content (ValadocHtmlBasicDoclet* self,
                                                       ValadocApiTree* tree)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	ValadocMarkupWriter* _tmp10_;
	ValadocMarkupWriter* _tmp11_;
	ValadocHtmlMarkupWriter* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	ValadocWikiPage* _tmp17_ = NULL;
	ValadocWikiPageTree* _tmp18_;
	ValadocWikiPageTree* _tmp19_;
	ValadocWikiPage* wikiindex = NULL;
	ValadocWikiPage* _tmp24_;
	ValadocWikiPage* _tmp25_;
	ValadocHtmlMarkupWriter* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocHtmlMarkupWriter* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	ValadocMarkupWriter* _tmp44_;
	ValadocMarkupWriter* _tmp45_;
	ValadocHtmlMarkupWriter* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = self->writer;
	_tmp6_ = g_strdup ("class");
	_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 2;
	_tmp10_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "h1", _tmp9_, (gint) 2);
	_tmp11_ = valadoc_markup_writer_text (_tmp10_, "Packages:");
	valadoc_markup_writer_end_tag (_tmp11_, "h1");
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = self->writer;
	_tmp13_ = g_strdup ("class");
	_tmp14_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp15_ = g_new0 (gchar*, 2 + 1);
	_tmp15_[0] = _tmp13_;
	_tmp15_[1] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp12_, "hr", _tmp16_, (gint) 2);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = valadoc_api_tree_get_wikitree (tree);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == NULL) {
		_g_object_unref0 (_tmp17_);
		_tmp17_ = NULL;
	} else {
		ValadocWikiPageTree* _tmp20_;
		ValadocWikiPageTree* _tmp21_;
		const gchar* _tmp22_;
		ValadocWikiPage* _tmp23_;
		_tmp20_ = valadoc_api_tree_get_wikitree (tree);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_wiki_index_name;
		_tmp23_ = valadoc_wiki_page_tree_search (_tmp21_, _tmp22_);
		_g_object_unref0 (_tmp17_);
		_tmp17_ = _tmp23_;
	}
	_tmp24_ = _g_object_ref0 (_tmp17_);
	wikiindex = _tmp24_;
	_tmp25_ = wikiindex;
	if (_tmp25_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp26_;
		ValadocWikiPage* _tmp27_;
		ValadocHtmlHtmlRenderer* _tmp28_;
		ValadocWikiPage* _tmp29_;
		ValadocContentPage* _tmp30_;
		ValadocContentPage* _tmp31_;
		_tmp26_ = self->_renderer;
		_tmp27_ = wikiindex;
		valadoc_html_html_renderer_set_container (_tmp26_, (ValadocDocumentation*) _tmp27_);
		_tmp28_ = self->_renderer;
		_tmp29_ = wikiindex;
		_tmp30_ = valadoc_wiki_page_get_documentation (_tmp29_);
		_tmp31_ = _tmp30_;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp28_, (ValadocContentContentElement*) _tmp31_);
	}
	_tmp32_ = self->writer;
	_tmp33_ = g_strdup ("class");
	_tmp34_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp35_ = g_new0 (gchar*, 2 + 1);
	_tmp35_[0] = _tmp33_;
	_tmp35_[1] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 2;
	_tmp37_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp32_, "h2", _tmp36_, (gint) 2);
	_tmp38_ = valadoc_markup_writer_text (_tmp37_, "Content:");
	valadoc_markup_writer_end_tag (_tmp38_, "h2");
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = self->writer;
	_tmp40_ = g_strdup ("class");
	_tmp41_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp42_ = g_new0 (gchar*, 2 + 1);
	_tmp42_[0] = _tmp40_;
	_tmp42_[1] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 2;
	_tmp44_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp39_, "h3", _tmp43_, (gint) 2);
	_tmp45_ = valadoc_markup_writer_text (_tmp44_, "Packages:");
	valadoc_markup_writer_end_tag (_tmp45_, "h3");
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_navi_packages_inline (self, tree);
	_tmp46_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp46_, "div");
	_g_object_unref0 (wikiindex);
	_g_object_unref0 (_tmp17_);
}

static inline ValaArrayList*
valadoc_html_basic_doclet_get_accessible_nodes_from_list (ValadocHtmlBasicDoclet* self,
                                                          ValaCollection* nodes)
{
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nodes != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	list = _tmp1_;
	{
		ValaIterator* _node_it = NULL;
		ValaIterator* _tmp2_;
		_tmp2_ = vala_iterable_iterator ((ValaIterable*) nodes);
		_node_it = _tmp2_;
		while (TRUE) {
			ValaIterator* _tmp3_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp4_;
			gpointer _tmp5_;
			ValadocApiNode* _tmp6_;
			ValadocSettings* _tmp7_;
			_tmp3_ = _node_it;
			if (!vala_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _node_it;
			_tmp5_ = vala_iterator_get (_tmp4_);
			node = (ValadocApiNode*) _tmp5_;
			_tmp6_ = node;
			_tmp7_ = self->priv->_settings;
			if (valadoc_api_node_is_browsable (_tmp6_, _tmp7_)) {
				ValaArrayList* _tmp8_;
				ValadocApiNode* _tmp9_;
				_tmp8_ = list;
				_tmp9_ = node;
				vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
	result = list;
	return result;
}

static void
valadoc_html_basic_doclet_write_known_symbols_note (ValadocHtmlBasicDoclet* self,
                                                    ValaCollection* nodes2,
                                                    ValadocApiNode* container,
                                                    const gchar* headline)
{
	ValaArrayList* nodes = NULL;
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaArrayList* _tmp4_;
	gchar* html_id = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint _tmp9_;
	ValadocHtmlMarkupWriter* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	ValadocHtmlMarkupWriter* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	gint* list_sizes = NULL;
	gint* _tmp25_;
	gint list_sizes_length1;
	gint _list_sizes_size_;
	gint* _tmp26_;
	gint _tmp26__length1;
	ValaArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint* _tmp30_;
	gint _tmp30__length1;
	gint* _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_;
	gint* _tmp33_;
	gint _tmp33__length1;
	gint* _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	gint* _tmp36_;
	gint _tmp36__length1;
	gint* _tmp37_;
	gint _tmp37__length1;
	gint _tmp38_;
	gint* _tmp39_;
	gint _tmp39__length1;
	gint* _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	ValadocHtmlMarkupWriter* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	ValaIterator* iter = NULL;
	ValaArrayList* _tmp50_;
	ValaIterator* _tmp51_;
	ValadocHtmlMarkupWriter* _tmp95_;
	ValadocHtmlMarkupWriter* _tmp96_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nodes2 != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (headline != NULL);
	_tmp0_ = valadoc_html_basic_doclet_get_accessible_nodes_from_list (self, nodes2);
	nodes = _tmp0_;
	_tmp1_ = nodes;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_vala_iterable_unref0 (nodes);
		return;
	}
	_tmp4_ = nodes;
	vala_list_sort ((ValaList*) _tmp4_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	_tmp5_ = g_strdup_printf ("%u", self->priv->html_id_counter);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("box-content-", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	html_id = _tmp8_;
	_tmp9_ = self->priv->html_id_counter;
	self->priv->html_id_counter = _tmp9_ + 1;
	_tmp10_ = self->writer;
	_tmp11_ = g_strdup ("class");
	_tmp12_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box);
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp10_, "div", _tmp14_, (gint) 2);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = self->writer;
	_tmp16_ = g_strdup ("class");
	_tmp17_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_headline);
	_tmp18_ = g_strdup ("onclick");
	_tmp19_ = html_id;
	_tmp20_ = g_strdup_printf ("toggle_box (this, '%s')", _tmp19_);
	_tmp21_ = g_new0 (gchar*, 4 + 1);
	_tmp21_[0] = _tmp16_;
	_tmp21_[1] = _tmp17_;
	_tmp21_[2] = _tmp18_;
	_tmp21_[3] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 4;
	_tmp23_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "div", _tmp22_, (gint) 4);
	_tmp24_ = valadoc_markup_writer_text (_tmp23_, headline);
	valadoc_markup_writer_end_tag (_tmp24_, "div");
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_new0 (gint, 3);
	_tmp25_[0] = 0;
	_tmp25_[1] = 0;
	_tmp25_[2] = 0;
	list_sizes = _tmp25_;
	list_sizes_length1 = 3;
	_list_sizes_size_ = list_sizes_length1;
	_tmp26_ = list_sizes;
	_tmp26__length1 = list_sizes_length1;
	_tmp27_ = nodes;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp26_[0] = _tmp29_;
	_tmp30_ = list_sizes;
	_tmp30__length1 = list_sizes_length1;
	_tmp31_ = list_sizes;
	_tmp31__length1 = list_sizes_length1;
	_tmp32_ = _tmp31_[0];
	_tmp30_[2] = _tmp32_ / 3;
	_tmp33_ = list_sizes;
	_tmp33__length1 = list_sizes_length1;
	_tmp34_ = list_sizes;
	_tmp34__length1 = list_sizes_length1;
	_tmp35_ = _tmp34_[2];
	_tmp33_[0] -= _tmp35_;
	_tmp36_ = list_sizes;
	_tmp36__length1 = list_sizes_length1;
	_tmp37_ = list_sizes;
	_tmp37__length1 = list_sizes_length1;
	_tmp38_ = _tmp37_[0];
	_tmp36_[1] = _tmp38_ / 2;
	_tmp39_ = list_sizes;
	_tmp39__length1 = list_sizes_length1;
	_tmp40_ = list_sizes;
	_tmp40__length1 = list_sizes_length1;
	_tmp41_ = _tmp40_[1];
	_tmp39_[0] -= _tmp41_;
	_tmp42_ = self->writer;
	_tmp43_ = g_strdup ("class");
	_tmp44_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_content);
	_tmp45_ = g_strdup ("id");
	_tmp46_ = html_id;
	_tmp47_ = g_strdup (_tmp46_);
	_tmp48_ = g_new0 (gchar*, 4 + 1);
	_tmp48_[0] = _tmp43_;
	_tmp48_[1] = _tmp44_;
	_tmp48_[2] = _tmp45_;
	_tmp48_[3] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 4;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp42_, "div", _tmp49_, (gint) 4);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = nodes;
	_tmp51_ = vala_iterable_iterator ((ValaIterable*) _tmp50_);
	iter = _tmp51_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp52_ = FALSE;
			_tmp52_ = TRUE;
			while (TRUE) {
				gint* _tmp54_;
				gint _tmp54__length1;
				ValadocHtmlMarkupWriter* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar** _tmp58_;
				gchar** _tmp59_;
				gint _tmp59__length1;
				ValadocHtmlMarkupWriter* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar** _tmp63_;
				gchar** _tmp64_;
				gint _tmp64__length1;
				ValadocHtmlMarkupWriter* _tmp93_;
				ValadocHtmlMarkupWriter* _tmp94_;
				if (!_tmp52_) {
					gint _tmp53_;
					_tmp53_ = i;
					i = _tmp53_ + 1;
				}
				_tmp52_ = FALSE;
				_tmp54_ = list_sizes;
				_tmp54__length1 = list_sizes_length1;
				if (!(i < _tmp54__length1)) {
					break;
				}
				_tmp55_ = self->writer;
				_tmp56_ = g_strdup ("class");
				_tmp57_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_column);
				_tmp58_ = g_new0 (gchar*, 2 + 1);
				_tmp58_[0] = _tmp56_;
				_tmp58_[1] = _tmp57_;
				_tmp59_ = _tmp58_;
				_tmp59__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp55_, "div", _tmp59_, (gint) 2);
				_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
				_tmp60_ = self->writer;
				_tmp61_ = g_strdup ("class");
				_tmp62_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
				_tmp63_ = g_new0 (gchar*, 2 + 1);
				_tmp63_[0] = _tmp61_;
				_tmp63_[1] = _tmp62_;
				_tmp64_ = _tmp63_;
				_tmp64__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp60_, "ul", _tmp64_, (gint) 2);
				_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
				{
					gint p = 0;
					p = 0;
					{
						gboolean _tmp65_ = FALSE;
						_tmp65_ = TRUE;
						while (TRUE) {
							gboolean _tmp67_ = FALSE;
							gint* _tmp68_;
							gint _tmp68__length1;
							gint _tmp69_;
							ValadocApiNode* node = NULL;
							ValaIterator* _tmp71_;
							gpointer _tmp72_;
							ValadocHtmlMarkupWriter* _tmp73_;
							gchar* _tmp74_;
							ValadocHtmlCssClassResolver* _tmp75_;
							ValadocApiNode* _tmp76_;
							gchar* _tmp77_;
							gchar** _tmp78_;
							gchar** _tmp79_;
							gint _tmp79__length1;
							gchar* link = NULL;
							ValadocApiNode* _tmp80_;
							gchar* _tmp81_;
							const gchar* _tmp82_;
							ValadocHtmlMarkupWriter* _tmp92_;
							if (!_tmp65_) {
								gint _tmp66_;
								_tmp66_ = p;
								p = _tmp66_ + 1;
							}
							_tmp65_ = FALSE;
							_tmp68_ = list_sizes;
							_tmp68__length1 = list_sizes_length1;
							_tmp69_ = _tmp68_[i];
							if (p < _tmp69_) {
								ValaIterator* _tmp70_;
								_tmp70_ = iter;
								_tmp67_ = vala_iterator_next (_tmp70_);
							} else {
								_tmp67_ = FALSE;
							}
							if (!_tmp67_) {
								break;
							}
							_tmp71_ = iter;
							_tmp72_ = vala_iterator_get (_tmp71_);
							node = (ValadocApiNode*) _tmp72_;
							_tmp73_ = self->writer;
							_tmp74_ = g_strdup ("class");
							_tmp75_ = self->cssresolver;
							_tmp76_ = node;
							_tmp77_ = valadoc_html_css_class_resolver_resolve (_tmp75_, _tmp76_);
							_tmp78_ = g_new0 (gchar*, 2 + 1);
							_tmp78_[0] = _tmp74_;
							_tmp78_[1] = _tmp77_;
							_tmp79_ = _tmp78_;
							_tmp79__length1 = 2;
							valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp73_, "li", _tmp79_, (gint) 2);
							_tmp79_ = (_vala_array_free (_tmp79_, _tmp79__length1, (GDestroyNotify) g_free), NULL);
							_tmp80_ = node;
							_tmp81_ = valadoc_html_basic_doclet_get_link (self, _tmp80_, container);
							link = _tmp81_;
							_tmp82_ = link;
							if (_tmp82_ == NULL) {
								ValadocHtmlMarkupWriter* _tmp83_;
								ValadocApiNode* _tmp84_;
								const gchar* _tmp85_;
								const gchar* _tmp86_;
								_tmp83_ = self->writer;
								_tmp84_ = node;
								_tmp85_ = valadoc_api_node_get_name (_tmp84_);
								_tmp86_ = _tmp85_;
								valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp83_, _tmp86_);
							} else {
								ValadocHtmlMarkupWriter* _tmp87_;
								const gchar* _tmp88_;
								ValadocApiNode* _tmp89_;
								const gchar* _tmp90_;
								const gchar* _tmp91_;
								_tmp87_ = self->writer;
								_tmp88_ = link;
								_tmp89_ = node;
								_tmp90_ = valadoc_api_node_get_name (_tmp89_);
								_tmp91_ = _tmp90_;
								valadoc_html_markup_writer_link (_tmp87_, _tmp88_, _tmp91_, NULL);
							}
							_tmp92_ = self->writer;
							valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp92_, "li");
							_g_free0 (link);
							_g_object_unref0 (node);
						}
					}
				}
				_tmp93_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp93_, "ul");
				_tmp94_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp94_, "div");
			}
		}
	}
	_tmp95_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp95_, "div");
	_tmp96_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp96_, "div");
	_vala_iterator_unref0 (iter);
	list_sizes = (g_free (list_sizes), NULL);
	_g_free0 (html_id);
	_vala_iterable_unref0 (nodes);
}

void
valadoc_html_basic_doclet_write_symbol_content (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* node)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	ValadocMarkupWriter* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	ValadocHtmlMarkupWriter* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	ValadocMarkupWriter* _tmp24_;
	ValadocMarkupWriter* _tmp25_;
	ValadocHtmlMarkupWriter* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	ValadocHtmlMarkupWriter* _tmp31_;
	ValadocApiItem* _tmp55_;
	ValadocApiItem* _tmp56_;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	ValadocHtmlMarkupWriter* _tmp70_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = self->writer;
	_tmp6_ = g_strdup ("class");
	_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 2;
	_tmp10_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "h1", _tmp9_, (gint) 2);
	_tmp11_ = valadoc_api_node_get_name (node);
	_tmp12_ = _tmp11_;
	_tmp13_ = valadoc_markup_writer_text (_tmp10_, _tmp12_);
	valadoc_markup_writer_end_tag (_tmp13_, "h1");
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = self->writer;
	_tmp15_ = g_strdup ("class");
	_tmp16_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp17_ = g_new0 (gchar*, 2 + 1);
	_tmp17_[0] = _tmp15_;
	_tmp17_[1] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp14_, "hr", _tmp18_, (gint) 2);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_image_block (self, node);
	_tmp19_ = self->writer;
	_tmp20_ = g_strdup ("class");
	_tmp21_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp22_ = g_new0 (gchar*, 2 + 1);
	_tmp22_[0] = _tmp20_;
	_tmp22_[1] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 2;
	_tmp24_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "h2", _tmp23_, (gint) 2);
	_tmp25_ = valadoc_markup_writer_text (_tmp24_, "Description:");
	valadoc_markup_writer_end_tag (_tmp25_, "h2");
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = self->writer;
	_tmp27_ = g_strdup ("class");
	_tmp28_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_code_definition);
	_tmp29_ = g_new0 (gchar*, 2 + 1);
	_tmp29_[0] = _tmp27_;
	_tmp29_[1] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp26_, "div", _tmp30_, (gint) 2);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	if (VALADOC_API_IS_SYMBOL (node)) {
		valadoc_html_basic_doclet_write_attributes (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), node);
	}
	valadoc_html_basic_doclet_write_signature (self, node, node);
	_tmp31_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp31_, "div");
	valadoc_html_basic_doclet_write_documentation (self, node, node);
	if (VALADOC_API_IS_CLASS (node)) {
		ValadocApiClass* cl = NULL;
		ValadocApiClass* _tmp32_;
		ValadocApiClass* _tmp33_;
		ValaCollection* _tmp34_;
		ValaCollection* _tmp35_;
		ValadocApiClass* _tmp36_;
		ValadocApiClass* _tmp37_;
		ValaCollection* _tmp38_;
		ValaCollection* _tmp39_;
		ValadocApiClass* _tmp40_;
		_tmp32_ = _g_object_ref0 (VALADOC_API_IS_CLASS (node) ? ((ValadocApiClass*) node) : NULL);
		cl = _tmp32_;
		_tmp33_ = cl;
		_tmp34_ = valadoc_api_class_get_known_child_classes (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = cl;
		valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp35_, (ValadocApiNode*) _tmp36_, "All known sub-classes:");
		_vala_iterable_unref0 (_tmp35_);
		_tmp37_ = cl;
		_tmp38_ = valadoc_api_class_get_known_derived_interfaces (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = cl;
		valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp39_, (ValadocApiNode*) _tmp40_, "Required by:");
		_vala_iterable_unref0 (_tmp39_);
		_g_object_unref0 (cl);
	} else {
		if (VALADOC_API_IS_INTERFACE (node)) {
			ValadocApiInterface* iface = NULL;
			ValadocApiInterface* _tmp41_;
			ValadocApiInterface* _tmp42_;
			ValaCollection* _tmp43_;
			ValaCollection* _tmp44_;
			ValadocApiInterface* _tmp45_;
			ValadocApiInterface* _tmp46_;
			ValaCollection* _tmp47_;
			ValaCollection* _tmp48_;
			ValadocApiInterface* _tmp49_;
			_tmp41_ = _g_object_ref0 (VALADOC_API_IS_INTERFACE (node) ? ((ValadocApiInterface*) node) : NULL);
			iface = _tmp41_;
			_tmp42_ = iface;
			_tmp43_ = valadoc_api_interface_get_known_implementations (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = iface;
			valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp44_, (ValadocApiNode*) _tmp45_, "All known implementing classes:");
			_vala_iterable_unref0 (_tmp44_);
			_tmp46_ = iface;
			_tmp47_ = valadoc_api_interface_get_known_related_interfaces (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = iface;
			valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp48_, (ValadocApiNode*) _tmp49_, "All known sub-interfaces:");
			_vala_iterable_unref0 (_tmp48_);
			_g_object_unref0 (iface);
		} else {
			if (VALADOC_API_IS_STRUCT (node)) {
				ValadocApiStruct* stru = NULL;
				ValadocApiStruct* _tmp50_;
				ValadocApiStruct* _tmp51_;
				ValaCollection* _tmp52_;
				ValaCollection* _tmp53_;
				ValadocApiStruct* _tmp54_;
				_tmp50_ = _g_object_ref0 (VALADOC_API_IS_STRUCT (node) ? ((ValadocApiStruct*) node) : NULL);
				stru = _tmp50_;
				_tmp51_ = stru;
				_tmp52_ = valadoc_api_struct_get_known_child_structs (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = stru;
				valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp53_, (ValadocApiNode*) _tmp54_, "All known sub-structs:");
				_vala_iterable_unref0 (_tmp53_);
				_g_object_unref0 (stru);
			}
		}
	}
	_tmp55_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
	_tmp56_ = _tmp55_;
	if (VALADOC_API_IS_NAMESPACE (_tmp56_)) {
		ValadocHtmlMarkupWriter* _tmp57_;
		_tmp57_ = self->writer;
		valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp57_, "br", NULL, (gint) 0);
		valadoc_html_basic_doclet_write_namespace_note (self, node);
		valadoc_html_basic_doclet_write_package_note (self, node);
	}
	if (VALADOC_API_IS_METHOD (node)) {
		_tmp59_ = TRUE;
	} else {
		_tmp59_ = VALADOC_API_IS_DELEGATE (node);
	}
	if (_tmp59_) {
		_tmp58_ = TRUE;
	} else {
		_tmp58_ = VALADOC_API_IS_SIGNAL (node);
	}
	if (!_tmp58_) {
		ValadocApiNodeType* _tmp60_;
		ValadocApiNodeType* _tmp61_;
		gint _tmp61__length1;
		gboolean _tmp62_;
		_tmp60_ = g_new0 (ValadocApiNodeType, 13);
		_tmp60_[0] = VALADOC_API_NODE_TYPE_ERROR_CODE;
		_tmp60_[1] = VALADOC_API_NODE_TYPE_ENUM_VALUE;
		_tmp60_[2] = VALADOC_API_NODE_TYPE_CREATION_METHOD;
		_tmp60_[3] = VALADOC_API_NODE_TYPE_STATIC_METHOD;
		_tmp60_[4] = VALADOC_API_NODE_TYPE_CLASS;
		_tmp60_[5] = VALADOC_API_NODE_TYPE_STRUCT;
		_tmp60_[6] = VALADOC_API_NODE_TYPE_ENUM;
		_tmp60_[7] = VALADOC_API_NODE_TYPE_DELEGATE;
		_tmp60_[8] = VALADOC_API_NODE_TYPE_METHOD;
		_tmp60_[9] = VALADOC_API_NODE_TYPE_SIGNAL;
		_tmp60_[10] = VALADOC_API_NODE_TYPE_PROPERTY;
		_tmp60_[11] = VALADOC_API_NODE_TYPE_FIELD;
		_tmp60_[12] = VALADOC_API_NODE_TYPE_CONSTANT;
		_tmp61_ = _tmp60_;
		_tmp61__length1 = 13;
		_tmp62_ = valadoc_api_node_has_children (node, _tmp61_, (gint) 13);
		_tmp61_ = (g_free (_tmp61_), NULL);
		if (_tmp62_) {
			ValadocHtmlMarkupWriter* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar** _tmp66_;
			gchar** _tmp67_;
			gint _tmp67__length1;
			ValadocMarkupWriter* _tmp68_;
			ValadocMarkupWriter* _tmp69_;
			_tmp63_ = self->writer;
			_tmp64_ = g_strdup ("class");
			_tmp65_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
			_tmp66_ = g_new0 (gchar*, 2 + 1);
			_tmp66_[0] = _tmp64_;
			_tmp66_[1] = _tmp65_;
			_tmp67_ = _tmp66_;
			_tmp67__length1 = 2;
			_tmp68_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp63_, "h2", _tmp67_, (gint) 2);
			_tmp69_ = valadoc_markup_writer_text (_tmp68_, "Content:");
			valadoc_markup_writer_end_tag (_tmp69_, "h2");
			_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_ERROR_CODE, "Error codes", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_ENUM_VALUE, "Enum values", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_CLASS, "Classes", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_STRUCT, "Structs", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_ENUM, "Enums", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_PROPERTY, "Properties", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_STATIC_METHOD, "Static methods", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_CREATION_METHOD, "Creation methods", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_METHOD, "Methods", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_SIGNAL, "Signals", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_FIELD, "Fields", node);
		}
	}
	if (VALADOC_API_IS_CLASS (node)) {
		valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_CLASS, ValadocApiClass), node);
	} else {
		if (VALADOC_API_IS_INTERFACE (node)) {
			valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface), node);
		} else {
			if (VALADOC_API_IS_STRUCT (node)) {
				valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_STRUCT, ValadocApiStruct), node);
			}
		}
	}
	_tmp70_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp70_, "div");
}

static inline gboolean
valadoc_html_basic_doclet_has_visible_inheritable_children (ValadocHtmlBasicDoclet* self,
                                                            ValadocApiTypeSymbol* symbol)
{
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	ValadocSettings* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = valadoc_html_basic_doclet_inheritable_members;
	_tmp0__length1 = valadoc_html_basic_doclet_inheritable_members_length1;
	_tmp1_ = self->priv->_settings;
	result = valadoc_api_node_has_visible_children_by_types ((ValadocApiNode*) symbol, _tmp0_, (gint) _tmp0__length1, _tmp1_);
	return result;
}

static void
valadoc_html_basic_doclet_write_inherited_members_headline (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "h3", _tmp4_, (gint) 2);
	_tmp6_ = valadoc_markup_writer_text (_tmp5_, "Inherited Members:");
	valadoc_markup_writer_end_tag (_tmp6_, "h3");
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}

static void
valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (ValadocHtmlBasicDoclet* self,
                                                                  ValadocApiClass* cl,
                                                                  ValadocApiNode* container)
{
	gboolean headline_printed = FALSE;
	ValadocApiClass* base_class = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiClass* _tmp3_;
	ValaCollection* printed_interfaces = NULL;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (container != NULL);
	headline_printed = FALSE;
	_tmp0_ = valadoc_api_class_get_base_type (cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp1_);
	_tmp3_ = VALADOC_API_IS_CLASS (_tmp2_) ? ((ValadocApiClass*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	base_class = _tmp3_;
	while (TRUE) {
		ValadocApiClass* _tmp4_;
		gboolean _tmp5_ = FALSE;
		ValadocApiClass* _tmp7_;
		ValadocApiClass* _tmp8_;
		ValadocApiTypeReference* _tmp9_;
		ValadocApiTypeReference* _tmp10_;
		ValadocApiTypeSymbol* _tmp11_;
		ValadocApiClass* _tmp12_;
		_tmp4_ = base_class;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		if (!headline_printed) {
			ValadocApiClass* _tmp6_;
			_tmp6_ = base_class;
			_tmp5_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp6_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			valadoc_html_basic_doclet_write_inherited_members_headline (self);
			headline_printed = TRUE;
		}
		_tmp7_ = base_class;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp7_, "class", container);
		_tmp8_ = base_class;
		_tmp9_ = valadoc_api_class_get_base_type (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp10_);
		_tmp12_ = VALADOC_API_IS_CLASS (_tmp11_) ? ((ValadocApiClass*) _tmp11_) : NULL;
		if (_tmp12_ == NULL) {
			_g_object_unref0 (_tmp11_);
		}
		_g_object_unref0 (base_class);
		base_class = _tmp12_;
	}
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_array_list_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp13_);
	printed_interfaces = (ValaCollection*) _tmp14_;
	{
		ValaIterator* _iface_ref_it = NULL;
		ValaCollection* _tmp15_;
		ValaCollection* _tmp16_;
		ValaIterator* _tmp17_;
		ValaIterator* _tmp18_;
		_tmp15_ = valadoc_api_class_get_full_implemented_interface_list (cl);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_iterable_iterator ((ValaIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_vala_iterable_unref0 (_tmp16_);
		_iface_ref_it = _tmp18_;
		while (TRUE) {
			ValaIterator* _tmp19_;
			ValadocApiTypeReference* iface_ref = NULL;
			ValaIterator* _tmp20_;
			gpointer _tmp21_;
			ValadocApiInterface* iface = NULL;
			ValadocApiTypeReference* _tmp22_;
			ValadocApiTypeSymbol* _tmp23_;
			gboolean _tmp24_ = FALSE;
			ValadocApiInterface* _tmp28_;
			ValaCollection* _tmp29_;
			ValadocApiInterface* _tmp30_;
			_tmp19_ = _iface_ref_it;
			if (!vala_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _iface_ref_it;
			_tmp21_ = vala_iterator_get (_tmp20_);
			iface_ref = (ValadocApiTypeReference*) _tmp21_;
			_tmp22_ = iface_ref;
			_tmp23_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp22_);
			iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
			if (!headline_printed) {
				ValadocApiInterface* _tmp25_;
				_tmp25_ = iface;
				_tmp24_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp25_);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				valadoc_html_basic_doclet_write_inherited_members_headline (self);
				headline_printed = TRUE;
			} else {
				ValaCollection* _tmp26_;
				ValadocApiInterface* _tmp27_;
				_tmp26_ = printed_interfaces;
				_tmp27_ = iface;
				if (vala_collection_contains (_tmp26_, _tmp27_)) {
					_g_object_unref0 (iface);
					_g_object_unref0 (iface_ref);
					continue;
				}
			}
			_tmp28_ = iface;
			valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp28_, "interface", container);
			_tmp29_ = printed_interfaces;
			_tmp30_ = iface;
			vala_collection_add (_tmp29_, _tmp30_);
			_g_object_unref0 (iface);
			_g_object_unref0 (iface_ref);
		}
		_vala_iterator_unref0 (_iface_ref_it);
	}
	_vala_iterable_unref0 (printed_interfaces);
	_g_object_unref0 (base_class);
}

static void
valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (ValadocHtmlBasicDoclet* self,
                                                                      ValadocApiInterface* iface,
                                                                      ValadocApiNode* container)
{
	gboolean headline_printed = FALSE;
	ValadocApiClass* base_class = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiClass* _tmp3_;
	ValaCollection* printed_interfaces = NULL;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (container != NULL);
	headline_printed = FALSE;
	_tmp0_ = valadoc_api_interface_get_base_type (iface);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp1_);
	_tmp3_ = VALADOC_API_IS_CLASS (_tmp2_) ? ((ValadocApiClass*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	base_class = _tmp3_;
	while (TRUE) {
		ValadocApiClass* _tmp4_;
		gboolean _tmp5_ = FALSE;
		ValadocApiClass* _tmp7_;
		ValadocApiClass* _tmp8_;
		ValadocApiTypeReference* _tmp9_;
		ValadocApiTypeReference* _tmp10_;
		ValadocApiTypeSymbol* _tmp11_;
		ValadocApiClass* _tmp12_;
		_tmp4_ = base_class;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		if (!headline_printed) {
			ValadocApiClass* _tmp6_;
			_tmp6_ = base_class;
			_tmp5_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp6_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			valadoc_html_basic_doclet_write_inherited_members_headline (self);
			headline_printed = TRUE;
		}
		_tmp7_ = base_class;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp7_, "class", container);
		_tmp8_ = base_class;
		_tmp9_ = valadoc_api_class_get_base_type (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp10_);
		_tmp12_ = VALADOC_API_IS_CLASS (_tmp11_) ? ((ValadocApiClass*) _tmp11_) : NULL;
		if (_tmp12_ == NULL) {
			_g_object_unref0 (_tmp11_);
		}
		_g_object_unref0 (base_class);
		base_class = _tmp12_;
	}
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_array_list_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp13_);
	printed_interfaces = (ValaCollection*) _tmp14_;
	{
		ValaIterator* _pre_ref_it = NULL;
		ValaCollection* _tmp15_;
		ValaCollection* _tmp16_;
		ValaIterator* _tmp17_;
		ValaIterator* _tmp18_;
		_tmp15_ = valadoc_api_interface_get_full_implemented_interface_list (iface);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_iterable_iterator ((ValaIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_vala_iterable_unref0 (_tmp16_);
		_pre_ref_it = _tmp18_;
		while (TRUE) {
			ValaIterator* _tmp19_;
			ValadocApiTypeReference* pre_ref = NULL;
			ValaIterator* _tmp20_;
			gpointer _tmp21_;
			ValadocApiInterface* pre = NULL;
			ValadocApiTypeReference* _tmp22_;
			ValadocApiTypeSymbol* _tmp23_;
			gboolean _tmp24_ = FALSE;
			ValadocApiInterface* _tmp28_;
			ValaCollection* _tmp29_;
			ValadocApiInterface* _tmp30_;
			_tmp19_ = _pre_ref_it;
			if (!vala_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _pre_ref_it;
			_tmp21_ = vala_iterator_get (_tmp20_);
			pre_ref = (ValadocApiTypeReference*) _tmp21_;
			_tmp22_ = pre_ref;
			_tmp23_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp22_);
			pre = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
			if (!headline_printed) {
				ValadocApiInterface* _tmp25_;
				_tmp25_ = pre;
				_tmp24_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp25_);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				valadoc_html_basic_doclet_write_inherited_members_headline (self);
				headline_printed = TRUE;
			} else {
				ValaCollection* _tmp26_;
				ValadocApiInterface* _tmp27_;
				_tmp26_ = printed_interfaces;
				_tmp27_ = pre;
				if (vala_collection_contains (_tmp26_, _tmp27_)) {
					_g_object_unref0 (pre);
					_g_object_unref0 (pre_ref);
					continue;
				}
			}
			_tmp28_ = pre;
			valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp28_, "interface", container);
			_tmp29_ = printed_interfaces;
			_tmp30_ = pre;
			vala_collection_add (_tmp29_, _tmp30_);
			_g_object_unref0 (pre);
			_g_object_unref0 (pre_ref);
		}
		_vala_iterator_unref0 (_pre_ref_it);
	}
	_vala_iterable_unref0 (printed_interfaces);
	_g_object_unref0 (base_class);
}

static void
valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (ValadocHtmlBasicDoclet* self,
                                                                   ValadocApiStruct* str,
                                                                   ValadocApiNode* container)
{
	ValadocApiStruct* base_struct = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiStruct* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValadocApiStruct* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = valadoc_api_struct_get_base_type (str);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp1_);
	_tmp3_ = VALADOC_API_IS_STRUCT (_tmp2_) ? ((ValadocApiStruct*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	base_struct = _tmp3_;
	_tmp5_ = base_struct;
	if (_tmp5_ != NULL) {
		ValadocApiStruct* _tmp6_;
		_tmp6_ = base_struct;
		_tmp4_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValadocApiStruct* _tmp7_;
		valadoc_html_basic_doclet_write_inherited_members_headline (self);
		_tmp7_ = base_struct;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp7_, "struct", container);
	}
	_g_object_unref0 (base_struct);
}

static void
valadoc_html_basic_doclet_write_inherited_symbols_note (ValadocHtmlBasicDoclet* self,
                                                        ValadocApiTypeSymbol* symbol,
                                                        const gchar* type,
                                                        ValadocApiNode* container)
{
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = valadoc_html_basic_doclet_inheritable_members;
	_tmp0__length1 = valadoc_html_basic_doclet_inheritable_members_length1;
	_tmp1_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) symbol, _tmp0_, (gint) _tmp0__length1, FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_node_get_full_name ((ValadocApiNode*) symbol);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("All known members inherited from %s %s", type, _tmp4_);
	_tmp6_ = _tmp5_;
	valadoc_html_basic_doclet_write_known_symbols_note (self, (ValaCollection*) _tmp2_, container, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_vala_iterable_unref0 (_tmp2_);
}

void
valadoc_html_basic_doclet_write_child_namespaces (ValadocHtmlBasicDoclet* self,
                                                  ValadocApiNode* node,
                                                  ValadocApiNode* parent)
{
	ValaArrayList* namespaces = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ValaArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp15_ = FALSE;
	gboolean with_childs = FALSE;
	ValadocHtmlMarkupWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocHtmlMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	ValadocHtmlMarkupWriter* _tmp66_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	namespaces = _tmp1_;
	_tmp2_ = namespaces;
	valadoc_html_basic_doclet_fetch_subnamespace_names (self, node, _tmp2_);
	_tmp3_ = namespaces;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		_vala_iterable_unref0 (namespaces);
		return;
	}
	_tmp6_ = namespaces;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 1) {
		ValaArrayList* _tmp9_;
		gpointer _tmp10_;
		ValadocApiNamespace* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp9_ = namespaces;
		_tmp10_ = vala_list_get ((ValaList*) _tmp9_, 0);
		_tmp11_ = (ValadocApiNamespace*) _tmp10_;
		_tmp12_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_ == NULL;
		_g_object_unref0 (_tmp11_);
		if (_tmp14_) {
			_vala_iterable_unref0 (namespaces);
			return;
		}
	}
	if (parent != NULL) {
		_tmp15_ = VALADOC_API_IS_PACKAGE (parent);
	} else {
		_tmp15_ = FALSE;
	}
	with_childs = _tmp15_;
	_tmp16_ = self->writer;
	_tmp17_ = g_strdup ("class");
	_tmp18_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp19_ = g_new0 (gchar*, 2 + 1);
	_tmp19_[0] = _tmp17_;
	_tmp19_[1] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 2;
	_tmp21_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "h3", _tmp20_, (gint) 2);
	_tmp22_ = valadoc_markup_writer_text (_tmp21_, "Namespaces:");
	valadoc_markup_writer_end_tag (_tmp22_, "h3");
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = self->writer;
	_tmp24_ = g_strdup ("class");
	_tmp25_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
	_tmp26_ = g_new0 (gchar*, 2 + 1);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp23_, "ul", _tmp27_, (gint) 2);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp28_;
		gint _child_size = 0;
		ValaArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _child_index = 0;
		_tmp28_ = namespaces;
		_child_list = _tmp28_;
		_tmp29_ = _child_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_child_size = _tmp31_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValadocApiNamespace* child = NULL;
			ValaArrayList* _tmp34_;
			gpointer _tmp35_;
			ValadocApiNamespace* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_child_index = _child_index + 1;
			_tmp32_ = _child_index;
			_tmp33_ = _child_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _child_list;
			_tmp35_ = vala_list_get ((ValaList*) _tmp34_, _child_index);
			child = (ValadocApiNamespace*) _tmp35_;
			_tmp36_ = child;
			_tmp37_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			if (_tmp38_ != NULL) {
				ValadocHtmlMarkupWriter* _tmp39_;
				gchar* _tmp40_;
				ValadocHtmlCssClassResolver* _tmp41_;
				ValadocApiNamespace* _tmp42_;
				gchar* _tmp43_;
				gchar** _tmp44_;
				gchar** _tmp45_;
				gint _tmp45__length1;
				ValadocHtmlMarkupWriter* _tmp46_;
				ValadocApiNamespace* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				ValadocApiNamespace* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				ValadocApiNamespace* _tmp53_;
				ValadocHtmlMarkupWriter* _tmp56_;
				_tmp39_ = self->writer;
				_tmp40_ = g_strdup ("class");
				_tmp41_ = self->cssresolver;
				_tmp42_ = child;
				_tmp43_ = valadoc_html_css_class_resolver_resolve (_tmp41_, (ValadocApiNode*) _tmp42_);
				_tmp44_ = g_new0 (gchar*, 2 + 1);
				_tmp44_[0] = _tmp40_;
				_tmp44_[1] = _tmp43_;
				_tmp45_ = _tmp44_;
				_tmp45__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp39_, "li", _tmp45_, (gint) 2);
				_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
				_tmp46_ = self->writer;
				_tmp47_ = child;
				_tmp48_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp47_, parent);
				_tmp49_ = _tmp48_;
				_tmp50_ = child;
				_tmp51_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				valadoc_html_markup_writer_link (_tmp46_, _tmp49_, _tmp52_, NULL);
				_g_free0 (_tmp49_);
				_tmp53_ = child;
				if (valadoc_html_basic_doclet_has_brief_description (self, (ValadocApiNode*) _tmp53_)) {
					ValadocHtmlMarkupWriter* _tmp54_;
					ValadocApiNamespace* _tmp55_;
					_tmp54_ = self->writer;
					valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp54_, " - ");
					_tmp55_ = child;
					valadoc_html_basic_doclet_write_brief_description (self, (ValadocApiNode*) _tmp55_, parent);
				}
				_tmp56_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp56_, "li");
				if (with_childs == TRUE) {
					ValadocApiNamespace* _tmp57_;
					ValadocApiNamespace* _tmp58_;
					ValadocApiNamespace* _tmp59_;
					ValadocApiNamespace* _tmp60_;
					ValadocApiNamespace* _tmp61_;
					ValadocApiNamespace* _tmp62_;
					ValadocApiNamespace* _tmp63_;
					ValadocApiNamespace* _tmp64_;
					ValadocApiNamespace* _tmp65_;
					_tmp57_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp57_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", parent);
					_tmp58_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp58_, VALADOC_API_NODE_TYPE_CLASS, "Classes", parent);
					_tmp59_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp59_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", parent);
					_tmp60_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp60_, VALADOC_API_NODE_TYPE_ENUM, "Enums", parent);
					_tmp61_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp61_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", parent);
					_tmp62_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp62_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", parent);
					_tmp63_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp63_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", parent);
					_tmp64_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp64_, VALADOC_API_NODE_TYPE_METHOD, "Methods", parent);
					_tmp65_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp65_, VALADOC_API_NODE_TYPE_FIELD, "Fields", parent);
				}
			}
			_g_object_unref0 (child);
		}
	}
	_tmp66_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp66_, "ul");
	_vala_iterable_unref0 (namespaces);
}

void
valadoc_html_basic_doclet_write_child_dependencies (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiPackage* package,
                                                    ValadocApiNode* parent)
{
	ValaCollection* deps = NULL;
	ValaCollection* _tmp0_;
	ValaCollection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocHtmlMarkupWriter* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	ValadocHtmlMarkupWriter* _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = valadoc_api_package_get_full_dependency_list (package);
	deps = _tmp0_;
	_tmp1_ = deps;
	_tmp2_ = vala_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_vala_iterable_unref0 (deps);
		return;
	}
	_tmp4_ = self->writer;
	_tmp5_ = g_strdup ("class");
	_tmp6_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp5_;
	_tmp7_[1] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	_tmp9_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp4_, "h2", _tmp8_, (gint) 2);
	_tmp10_ = valadoc_markup_writer_text (_tmp9_, "Dependencies:");
	valadoc_markup_writer_end_tag (_tmp10_, "h2");
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = self->writer;
	_tmp12_ = g_strdup ("class");
	_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "ul", _tmp15_, (gint) 2);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaIterator* _p_it = NULL;
		ValaCollection* _tmp16_;
		ValaIterator* _tmp17_;
		_tmp16_ = deps;
		_tmp17_ = vala_iterable_iterator ((ValaIterable*) _tmp16_);
		_p_it = _tmp17_;
		while (TRUE) {
			ValaIterator* _tmp18_;
			ValadocApiPackage* p = NULL;
			ValaIterator* _tmp19_;
			gpointer _tmp20_;
			gchar* link = NULL;
			ValadocApiPackage* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = _p_it;
			if (!vala_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _p_it;
			_tmp20_ = vala_iterator_get (_tmp19_);
			p = (ValadocApiPackage*) _tmp20_;
			_tmp21_ = p;
			_tmp22_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp21_, parent);
			link = _tmp22_;
			_tmp23_ = link;
			if (_tmp23_ == NULL) {
				ValadocHtmlMarkupWriter* _tmp24_;
				gchar* _tmp25_;
				ValadocHtmlCssClassResolver* _tmp26_;
				ValadocApiPackage* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				ValadocApiPackage* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar** _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				ValadocMarkupWriter* _tmp36_;
				ValadocApiPackage* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				ValadocMarkupWriter* _tmp40_;
				_tmp24_ = self->writer;
				_tmp25_ = g_strdup ("class");
				_tmp26_ = self->cssresolver;
				_tmp27_ = p;
				_tmp28_ = valadoc_html_css_class_resolver_resolve (_tmp26_, (ValadocApiNode*) _tmp27_);
				_tmp29_ = g_strdup ("id");
				_tmp30_ = p;
				_tmp31_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strdup (_tmp32_);
				_tmp34_ = g_new0 (gchar*, 4 + 1);
				_tmp34_[0] = _tmp25_;
				_tmp34_[1] = _tmp28_;
				_tmp34_[2] = _tmp29_;
				_tmp34_[3] = _tmp33_;
				_tmp35_ = _tmp34_;
				_tmp35__length1 = 4;
				_tmp36_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp24_, "li", _tmp35_, (gint) 4);
				_tmp37_ = p;
				_tmp38_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = valadoc_markup_writer_text (_tmp36_, _tmp39_);
				valadoc_markup_writer_end_tag (_tmp40_, "li");
				_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
			} else {
				ValadocHtmlMarkupWriter* _tmp41_;
				gchar* _tmp42_;
				ValadocHtmlCssClassResolver* _tmp43_;
				ValadocApiPackage* _tmp44_;
				gchar* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				ValadocHtmlMarkupWriter* _tmp48_;
				ValadocApiPackage* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				ValadocApiPackage* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				ValadocHtmlMarkupWriter* _tmp55_;
				_tmp41_ = self->writer;
				_tmp42_ = g_strdup ("class");
				_tmp43_ = self->cssresolver;
				_tmp44_ = p;
				_tmp45_ = valadoc_html_css_class_resolver_resolve (_tmp43_, (ValadocApiNode*) _tmp44_);
				_tmp46_ = g_new0 (gchar*, 2 + 1);
				_tmp46_[0] = _tmp42_;
				_tmp46_[1] = _tmp45_;
				_tmp47_ = _tmp46_;
				_tmp47__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp41_, "li", _tmp47_, (gint) 2);
				_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
				_tmp48_ = self->writer;
				_tmp49_ = p;
				_tmp50_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp49_, parent);
				_tmp51_ = _tmp50_;
				_tmp52_ = p;
				_tmp53_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp52_);
				_tmp54_ = _tmp53_;
				valadoc_html_markup_writer_link (_tmp48_, _tmp51_, _tmp54_, NULL);
				_g_free0 (_tmp51_);
				_tmp55_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp55_, "li");
			}
			_g_free0 (link);
			_g_object_unref0 (p);
		}
		_vala_iterator_unref0 (_p_it);
	}
	_tmp56_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp56_, "ul");
	_vala_iterable_unref0 (deps);
}

void
valadoc_html_basic_doclet_write_children (ValadocHtmlBasicDoclet* self,
                                          ValadocApiNode* node,
                                          ValadocApiNodeType type,
                                          const gchar* type_string,
                                          ValadocApiNode* container)
{
	ValaList* children = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (type_string != NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, type, TRUE);
	children = _tmp0_;
	_tmp1_ = children;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gboolean _tmp4_ = FALSE;
		ValadocHtmlMarkupWriter* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		ValadocMarkupWriter* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		ValadocHtmlMarkupWriter* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		ValadocHtmlMarkupWriter* _tmp90_;
		if (VALADOC_API_IS_STRUCT (node)) {
			_tmp4_ = type == VALADOC_API_NODE_TYPE_FIELD;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			ValaList* _tmp5_;
			_tmp5_ = children;
			vala_list_sort (_tmp5_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
		}
		_tmp6_ = self->writer;
		_tmp7_ = g_strdup ("class");
		_tmp8_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
		_tmp9_ = g_new0 (gchar*, 2 + 1);
		_tmp9_[0] = _tmp7_;
		_tmp9_[1] = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 2;
		_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "h3", _tmp10_, (gint) 2);
		_tmp12_ = valadoc_markup_writer_text (_tmp11_, type_string);
		_tmp13_ = valadoc_markup_writer_text (_tmp12_, ":");
		valadoc_markup_writer_end_tag (_tmp13_, "h3");
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp14_ = self->writer;
		_tmp15_ = g_strdup ("class");
		_tmp16_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
		_tmp17_ = g_new0 (gchar*, 2 + 1);
		_tmp17_[0] = _tmp15_;
		_tmp17_[1] = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp18__length1 = 2;
		valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "ul", _tmp18_, (gint) 2);
		_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
		{
			ValaList* _child_list = NULL;
			ValaList* _tmp19_;
			gint _child_size = 0;
			ValaList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _child_index = 0;
			_tmp19_ = children;
			_child_list = _tmp19_;
			_tmp20_ = _child_list;
			_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_child_size = _tmp22_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp23_;
				gint _tmp24_;
				ValadocApiNode* child = NULL;
				ValaList* _tmp25_;
				gpointer _tmp26_;
				ValadocHtmlMarkupWriter* _tmp27_;
				gchar* _tmp28_;
				ValadocHtmlCssClassResolver* _tmp29_;
				ValadocApiNode* _tmp30_;
				gchar* _tmp31_;
				gchar** _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				ValadocApiNode* _tmp34_;
				ValadocHtmlMarkupWriter* _tmp89_;
				_child_index = _child_index + 1;
				_tmp23_ = _child_index;
				_tmp24_ = _child_size;
				if (!(_tmp23_ < _tmp24_)) {
					break;
				}
				_tmp25_ = _child_list;
				_tmp26_ = vala_list_get (_tmp25_, _child_index);
				child = (ValadocApiNode*) _tmp26_;
				_tmp27_ = self->writer;
				_tmp28_ = g_strdup ("class");
				_tmp29_ = self->cssresolver;
				_tmp30_ = child;
				_tmp31_ = valadoc_html_css_class_resolver_resolve (_tmp29_, _tmp30_);
				_tmp32_ = g_new0 (gchar*, 2 + 1);
				_tmp32_[0] = _tmp28_;
				_tmp32_[1] = _tmp31_;
				_tmp33_ = _tmp32_;
				_tmp33__length1 = 2;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp27_, "li", _tmp33_, (gint) 2);
				_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
				_tmp34_ = child;
				if (valadoc_html_basic_doclet_is_internal_node (self, _tmp34_)) {
					gboolean _tmp35_ = FALSE;
					ValadocApiNode* _tmp36_;
					ValadocApiNode* _tmp60_;
					_tmp36_ = child;
					if (VALADOC_API_IS_SYMBOL (_tmp36_)) {
						ValadocApiNode* _tmp37_;
						gboolean _tmp38_;
						gboolean _tmp39_;
						_tmp37_ = child;
						_tmp38_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
						_tmp39_ = _tmp38_;
						_tmp35_ = _tmp39_;
					} else {
						_tmp35_ = FALSE;
					}
					if (_tmp35_) {
						ValadocHtmlMarkupWriter* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar** _tmp43_;
						gchar** _tmp44_;
						gint _tmp44__length1;
						ValadocHtmlMarkupWriter* _tmp45_;
						ValadocApiNode* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						ValadocApiNode* _tmp49_;
						const gchar* _tmp50_;
						const gchar* _tmp51_;
						ValadocHtmlMarkupWriter* _tmp52_;
						_tmp40_ = self->writer;
						_tmp41_ = g_strdup ("class");
						_tmp42_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
						_tmp43_ = g_new0 (gchar*, 2 + 1);
						_tmp43_[0] = _tmp41_;
						_tmp43_[1] = _tmp42_;
						_tmp44_ = _tmp43_;
						_tmp44__length1 = 2;
						valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp40_, "span", _tmp44_, (gint) 2);
						_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
						_tmp45_ = self->writer;
						_tmp46_ = child;
						_tmp47_ = valadoc_html_basic_doclet_get_link (self, _tmp46_, container);
						_tmp48_ = _tmp47_;
						_tmp49_ = child;
						_tmp50_ = valadoc_api_node_get_name (_tmp49_);
						_tmp51_ = _tmp50_;
						valadoc_html_markup_writer_link (_tmp45_, _tmp48_, _tmp51_, NULL);
						_g_free0 (_tmp48_);
						_tmp52_ = self->writer;
						valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp52_, "span");
					} else {
						ValadocHtmlMarkupWriter* _tmp53_;
						ValadocApiNode* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						ValadocApiNode* _tmp57_;
						const gchar* _tmp58_;
						const gchar* _tmp59_;
						_tmp53_ = self->writer;
						_tmp54_ = child;
						_tmp55_ = valadoc_html_basic_doclet_get_link (self, _tmp54_, container);
						_tmp56_ = _tmp55_;
						_tmp57_ = child;
						_tmp58_ = valadoc_api_node_get_name (_tmp57_);
						_tmp59_ = _tmp58_;
						valadoc_html_markup_writer_link (_tmp53_, _tmp56_, _tmp59_, NULL);
						_g_free0 (_tmp56_);
					}
					_tmp60_ = child;
					if (valadoc_html_basic_doclet_has_brief_description (self, _tmp60_)) {
						ValadocHtmlMarkupWriter* _tmp61_;
						ValadocApiNode* _tmp62_;
						_tmp61_ = self->writer;
						valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp61_, " - ");
						_tmp62_ = child;
						valadoc_html_basic_doclet_write_brief_description (self, _tmp62_, container);
					}
				} else {
					ValadocHtmlMarkupWriter* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					gchar** _tmp66_;
					gchar** _tmp67_;
					gint _tmp67__length1;
					gboolean _tmp68_ = FALSE;
					ValadocApiNode* _tmp69_;
					ValadocHtmlMarkupWriter* _tmp81_;
					ValadocHtmlMarkupWriter* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar** _tmp85_;
					gchar** _tmp86_;
					gint _tmp86__length1;
					ValadocApiNode* _tmp87_;
					ValadocHtmlMarkupWriter* _tmp88_;
					_tmp63_ = self->writer;
					_tmp64_ = g_strdup ("class");
					_tmp65_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_leaf_code_definition);
					_tmp66_ = g_new0 (gchar*, 2 + 1);
					_tmp66_[0] = _tmp64_;
					_tmp66_[1] = _tmp65_;
					_tmp67_ = _tmp66_;
					_tmp67__length1 = 2;
					valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp63_, "span", _tmp67_, (gint) 2);
					_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
					_tmp69_ = child;
					if (VALADOC_API_IS_SYMBOL (_tmp69_)) {
						ValadocApiNode* _tmp70_;
						gboolean _tmp71_;
						gboolean _tmp72_;
						_tmp70_ = child;
						_tmp71_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
						_tmp72_ = _tmp71_;
						_tmp68_ = _tmp72_;
					} else {
						_tmp68_ = FALSE;
					}
					if (_tmp68_) {
						ValadocHtmlMarkupWriter* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						gchar** _tmp76_;
						gchar** _tmp77_;
						gint _tmp77__length1;
						ValadocApiNode* _tmp78_;
						ValadocHtmlMarkupWriter* _tmp79_;
						_tmp73_ = self->writer;
						_tmp74_ = g_strdup ("class");
						_tmp75_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
						_tmp76_ = g_new0 (gchar*, 2 + 1);
						_tmp76_[0] = _tmp74_;
						_tmp76_[1] = _tmp75_;
						_tmp77_ = _tmp76_;
						_tmp77__length1 = 2;
						valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp73_, "span", _tmp77_, (gint) 2);
						_tmp77_ = (_vala_array_free (_tmp77_, _tmp77__length1, (GDestroyNotify) g_free), NULL);
						_tmp78_ = child;
						valadoc_html_basic_doclet_write_signature (self, _tmp78_, container);
						_tmp79_ = self->writer;
						valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp79_, "span");
					} else {
						ValadocApiNode* _tmp80_;
						_tmp80_ = child;
						valadoc_html_basic_doclet_write_signature (self, _tmp80_, container);
					}
					_tmp81_ = self->writer;
					valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp81_, "span");
					_tmp82_ = self->writer;
					_tmp83_ = g_strdup ("class");
					_tmp84_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_leaf_brief_description);
					_tmp85_ = g_new0 (gchar*, 2 + 1);
					_tmp85_[0] = _tmp83_;
					_tmp85_[1] = _tmp84_;
					_tmp86_ = _tmp85_;
					_tmp86__length1 = 2;
					valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp82_, "div", _tmp86_, (gint) 2);
					_tmp86_ = (_vala_array_free (_tmp86_, _tmp86__length1, (GDestroyNotify) g_free), NULL);
					_tmp87_ = child;
					valadoc_html_basic_doclet_write_brief_description (self, _tmp87_, container);
					_tmp88_ = self->writer;
					valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp88_, "div");
				}
				_tmp89_ = self->writer;
				valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp89_, "li");
				_g_object_unref0 (child);
			}
		}
		_tmp90_ = self->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp90_, "ul");
	}
	_vala_iterable_unref0 (children);
}

void
valadoc_html_basic_doclet_write_image_block (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* element)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	if (VALADOC_API_IS_CLASS (element)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALADOC_API_IS_INTERFACE (element);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALADOC_API_IS_STRUCT (element);
	}
	if (_tmp0_) {
		const gchar* _tmp2_ = NULL;
		ValadocSettings* _tmp3_;
		const gchar* format = NULL;
		ValadocChartsHierarchy* chart = NULL;
		ValadocChartsFactory* _tmp4_;
		ValadocChartsHierarchy* _tmp5_;
		ValadocChartsHierarchy* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		ValadocHtmlMarkupWriter* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		ValadocMarkupWriter* _tmp16_;
		ValadocMarkupWriter* _tmp17_;
		ValadocHtmlMarkupWriter* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		ValadocHtmlMarkupWriter* _tmp34_;
		ValadocChartsHierarchy* _tmp35_;
		_tmp3_ = self->priv->_settings;
		if (_tmp3_->use_svg_images) {
			_tmp2_ = "svg";
		} else {
			_tmp2_ = "png";
		}
		format = _tmp2_;
		_tmp4_ = self->image_factory;
		_tmp5_ = valadoc_charts_hierarchy_new (_tmp4_, element);
		chart = _tmp5_;
		_tmp6_ = chart;
		_tmp7_ = format;
		_tmp8_ = valadoc_html_basic_doclet_get_img_path (self, element, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = format;
		valadoc_charts_chart_save ((ValadocChartsChart*) _tmp6_, _tmp9_, _tmp10_);
		_g_free0 (_tmp9_);
		_tmp11_ = self->writer;
		_tmp12_ = g_strdup ("class");
		_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
		_tmp14_ = g_new0 (gchar*, 2 + 1);
		_tmp14_[0] = _tmp12_;
		_tmp14_[1] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 2;
		_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "h2", _tmp15_, (gint) 2);
		_tmp17_ = valadoc_markup_writer_text (_tmp16_, "Object Hierarchy:");
		valadoc_markup_writer_end_tag (_tmp17_, "h2");
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = self->writer;
		_tmp19_ = g_strdup ("class");
		_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_diagram);
		_tmp21_ = g_strdup ("usemap");
		_tmp22_ = valadoc_api_node_get_full_name (element);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat ("#", _tmp23_, NULL);
		_tmp25_ = g_strdup ("alt");
		_tmp26_ = valadoc_api_node_get_name (element);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("Object hierarchy for %s", _tmp27_);
		_tmp29_ = g_strdup ("src");
		_tmp30_ = format;
		_tmp31_ = valadoc_html_basic_doclet_get_img_path_html (self, element, _tmp30_);
		_tmp32_ = g_new0 (gchar*, 8 + 1);
		_tmp32_[0] = _tmp19_;
		_tmp32_[1] = _tmp20_;
		_tmp32_[2] = _tmp21_;
		_tmp32_[3] = _tmp24_;
		_tmp32_[4] = _tmp25_;
		_tmp32_[5] = _tmp28_;
		_tmp32_[6] = _tmp29_;
		_tmp32_[7] = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp33__length1 = 8;
		valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp18_, "img", _tmp33_, (gint) 8);
		_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp23_);
		_tmp34_ = self->writer;
		_tmp35_ = chart;
		valadoc_html_markup_writer_add_usemap (_tmp34_, (ValadocChartsChart*) _tmp35_);
		_g_object_unref0 (chart);
	}
}

void
valadoc_html_basic_doclet_write_namespace_content (ValadocHtmlBasicDoclet* self,
                                                   ValadocApiNamespace* node,
                                                   ValadocApiNode* parent)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValadocHtmlMarkupWriter* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocHtmlMarkupWriter* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	ValadocHtmlMarkupWriter* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	ValadocMarkupWriter* _tmp27_;
	ValadocMarkupWriter* _tmp28_;
	ValadocHtmlMarkupWriter* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	ValadocMarkupWriter* _tmp34_;
	ValadocMarkupWriter* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	ValadocHtmlMarkupWriter* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("Global Namespace");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = valadoc_api_node_get_full_name ((ValadocApiNode*) node);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = self->writer;
	_tmp11_ = g_strdup ("class");
	_tmp12_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	_tmp15_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp10_, "h1", _tmp14_, (gint) 2);
	_tmp16_ = valadoc_markup_writer_text (_tmp15_, _tmp5_);
	valadoc_markup_writer_end_tag (_tmp16_, "h1");
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = self->writer;
	_tmp18_ = g_strdup ("class");
	_tmp19_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_hr);
	_tmp20_ = g_new0 (gchar*, 2 + 1);
	_tmp20_[0] = _tmp18_;
	_tmp20_[1] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp17_, "hr", _tmp21_, (gint) 2);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = self->writer;
	_tmp23_ = g_strdup ("class");
	_tmp24_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp25_ = g_new0 (gchar*, 2 + 1);
	_tmp25_[0] = _tmp23_;
	_tmp25_[1] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 2;
	_tmp27_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp22_, "h2", _tmp26_, (gint) 2);
	_tmp28_ = valadoc_markup_writer_text (_tmp27_, "Description:");
	valadoc_markup_writer_end_tag (_tmp28_, "h2");
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_documentation (self, (ValadocApiNode*) node, parent);
	_tmp29_ = self->writer;
	_tmp30_ = g_strdup ("class");
	_tmp31_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp32_ = g_new0 (gchar*, 2 + 1);
	_tmp32_[0] = _tmp30_;
	_tmp32_[1] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 2;
	_tmp34_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp29_, "h2", _tmp33_, (gint) 2);
	_tmp35_ = valadoc_markup_writer_text (_tmp34_, "Content:");
	valadoc_markup_writer_end_tag (_tmp35_, "h2");
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == NULL) {
		ValadocApiItem* _tmp38_;
		ValadocApiItem* _tmp39_;
		_tmp38_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
		_tmp39_ = _tmp38_;
		valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), parent);
	} else {
		valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) node, parent);
	}
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_CLASS, "Classes", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_STRUCT, "Structs", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_ENUM, "Enums", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_METHOD, "Functions", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_FIELD, "Fields", parent);
	_tmp40_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp40_, "div");
	_g_free0 (_tmp5_);
}

void
valadoc_html_basic_doclet_write_package_content (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiPackage* node,
                                                 ValadocApiNode* parent)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocHtmlMarkupWriter* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValadocMarkupWriter* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValadocHtmlMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	ValadocWikiPage* _tmp30_ = NULL;
	ValadocApiTree* _tmp31_;
	ValadocWikiPageTree* _tmp32_;
	ValadocWikiPageTree* _tmp33_;
	ValadocWikiPage* wikipage = NULL;
	ValadocWikiPage* _tmp39_;
	ValadocWikiPage* _tmp40_;
	ValadocHtmlMarkupWriter* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar** _tmp49_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	ValadocMarkupWriter* _tmp51_;
	ValadocMarkupWriter* _tmp52_;
	ValadocHtmlMarkupWriter* _tmp73_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = self->writer;
	_tmp6_ = g_strdup ("class");
	_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp8_ = g_strdup ("id");
	_tmp9_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_new0 (gchar*, 4 + 1);
	_tmp12_[0] = _tmp6_;
	_tmp12_[1] = _tmp7_;
	_tmp12_[2] = _tmp8_;
	_tmp12_[3] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 4;
	_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "h1", _tmp13_, (gint) 4);
	_tmp15_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp16_ = _tmp15_;
	_tmp17_ = valadoc_markup_writer_text (_tmp14_, _tmp16_);
	valadoc_markup_writer_end_tag (_tmp17_, "h1");
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = self->writer;
	_tmp19_ = g_strdup ("class");
	_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp21_ = g_new0 (gchar*, 2 + 1);
	_tmp21_[0] = _tmp19_;
	_tmp21_[1] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp18_, "hr", _tmp22_, (gint) 2);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = self->writer;
	_tmp24_ = g_strdup ("class");
	_tmp25_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp26_ = g_new0 (gchar*, 2 + 1);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	_tmp28_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp23_, "h2", _tmp27_, (gint) 2);
	_tmp29_ = valadoc_markup_writer_text (_tmp28_, "Description:");
	valadoc_markup_writer_end_tag (_tmp29_, "h2");
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = self->tree;
	_tmp32_ = valadoc_api_tree_get_wikitree (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == NULL) {
		_g_object_unref0 (_tmp30_);
		_tmp30_ = NULL;
	} else {
		ValadocApiTree* _tmp34_;
		ValadocWikiPageTree* _tmp35_;
		ValadocWikiPageTree* _tmp36_;
		const gchar* _tmp37_;
		ValadocWikiPage* _tmp38_;
		_tmp34_ = self->tree;
		_tmp35_ = valadoc_api_tree_get_wikitree (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->_wiki_index_name;
		_tmp38_ = valadoc_wiki_page_tree_search (_tmp36_, _tmp37_);
		_g_object_unref0 (_tmp30_);
		_tmp30_ = _tmp38_;
	}
	_tmp39_ = _g_object_ref0 (_tmp30_);
	wikipage = _tmp39_;
	_tmp40_ = wikipage;
	if (_tmp40_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp41_;
		ValadocHtmlHtmlRenderer* _tmp42_;
		ValadocWikiPage* _tmp43_;
		ValadocContentPage* _tmp44_;
		ValadocContentPage* _tmp45_;
		_tmp41_ = self->_renderer;
		valadoc_html_html_renderer_set_container (_tmp41_, (ValadocDocumentation*) parent);
		_tmp42_ = self->_renderer;
		_tmp43_ = wikipage;
		_tmp44_ = valadoc_wiki_page_get_documentation (_tmp43_);
		_tmp45_ = _tmp44_;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp42_, (ValadocContentContentElement*) _tmp45_);
	}
	_tmp46_ = self->writer;
	_tmp47_ = g_strdup ("class");
	_tmp48_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp49_ = g_new0 (gchar*, 2 + 1);
	_tmp49_[0] = _tmp47_;
	_tmp49_[1] = _tmp48_;
	_tmp50_ = _tmp49_;
	_tmp50__length1 = 2;
	_tmp51_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp46_, "h2", _tmp50_, (gint) 2);
	_tmp52_ = valadoc_markup_writer_text (_tmp51_, "Content:");
	valadoc_markup_writer_end_tag (_tmp52_, "h2");
	_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) node, parent);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp53_;
		gint _child_size = 0;
		ValaList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _child_index = 0;
		_tmp53_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) node, VALADOC_API_NODE_TYPE_NAMESPACE, TRUE);
		_child_list = _tmp53_;
		_tmp54_ = _child_list;
		_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_child_size = _tmp56_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp57_;
			gint _tmp58_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp59_;
			gpointer _tmp60_;
			ValadocApiNode* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			_child_index = _child_index + 1;
			_tmp57_ = _child_index;
			_tmp58_ = _child_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _child_list;
			_tmp60_ = vala_list_get (_tmp59_, _child_index);
			child = (ValadocApiNode*) _tmp60_;
			_tmp61_ = child;
			_tmp62_ = valadoc_api_node_get_name (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == NULL) {
				ValadocApiNode* _tmp64_;
				ValadocApiNode* _tmp65_;
				ValadocApiNode* _tmp66_;
				ValadocApiNode* _tmp67_;
				ValadocApiNode* _tmp68_;
				ValadocApiNode* _tmp69_;
				ValadocApiNode* _tmp70_;
				ValadocApiNode* _tmp71_;
				ValadocApiNode* _tmp72_;
				_tmp64_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp64_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", parent);
				_tmp65_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp65_, VALADOC_API_NODE_TYPE_CLASS, "Classes", parent);
				_tmp66_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp66_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", parent);
				_tmp67_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp67_, VALADOC_API_NODE_TYPE_ENUM, "Enums", parent);
				_tmp68_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp68_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", parent);
				_tmp69_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp69_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", parent);
				_tmp70_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp70_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", parent);
				_tmp71_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp71_, VALADOC_API_NODE_TYPE_METHOD, "Functions", parent);
				_tmp72_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp72_, VALADOC_API_NODE_TYPE_FIELD, "Fields", parent);
			}
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	valadoc_html_basic_doclet_write_child_dependencies (self, node, parent);
	_tmp73_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp73_, "div");
	_g_object_unref0 (wikipage);
	_g_object_unref0 (_tmp30_);
}

void
valadoc_html_basic_doclet_write_file_header (ValadocHtmlBasicDoclet* self,
                                             const gchar* css,
                                             const gchar* js,
                                             const gchar* title)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlMarkupWriter* _tmp1_;
	ValadocHtmlMarkupWriter* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValadocHtmlMarkupWriter* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	const gchar* _tmp23_ = NULL;
	ValadocHtmlMarkupWriter* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	ValadocHtmlMarkupWriter* _tmp27_;
	ValadocHtmlMarkupWriter* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (css != NULL);
	g_return_if_fail (js != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "html", NULL, (gint) 0);
	_tmp1_ = self->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp1_, "head", NULL, (gint) 0);
	_tmp2_ = self->writer;
	_tmp3_ = g_strdup ("charset");
	_tmp4_ = g_strdup ("UTF-8");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp2_, "meta", _tmp6_, (gint) 2);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	if (title == NULL) {
		ValadocHtmlMarkupWriter* _tmp7_;
		ValadocMarkupWriter* _tmp8_;
		ValadocMarkupWriter* _tmp9_;
		_tmp7_ = self->writer;
		_tmp8_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "title", NULL, (gint) 0);
		_tmp9_ = valadoc_markup_writer_text (_tmp8_, "Vala Binding Reference");
		valadoc_markup_writer_end_tag (_tmp9_, "title");
	} else {
		ValadocHtmlMarkupWriter* _tmp10_;
		ValadocMarkupWriter* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		_tmp10_ = self->writer;
		_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp10_, "title", NULL, (gint) 0);
		_tmp12_ = valadoc_markup_writer_text (_tmp11_, title);
		_tmp13_ = valadoc_markup_writer_text (_tmp12_, " &ndash; Vala Binding Reference");
		valadoc_markup_writer_end_tag (_tmp13_, "title");
	}
	_tmp14_ = self->writer;
	valadoc_html_markup_writer_stylesheet_link (_tmp14_, css);
	_tmp15_ = self->writer;
	valadoc_html_markup_writer_javascript_link (_tmp15_, js);
	_tmp16_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp16_, "head");
	_tmp17_ = self->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp17_, "body", NULL, (gint) 0);
	_tmp18_ = self->writer;
	_tmp19_ = g_strdup ("class");
	_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_site_header);
	_tmp21_ = g_new0 (gchar*, 2 + 1);
	_tmp21_[0] = _tmp19_;
	_tmp21_[1] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "div", _tmp22_, (gint) 2);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	if (title == NULL) {
		_tmp23_ = "";
	} else {
		_tmp23_ = title;
	}
	_tmp24_ = self->writer;
	_tmp25_ = g_strdup_printf ("%s Reference Manual", _tmp23_);
	_tmp26_ = _tmp25_;
	valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp24_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp27_, "div");
	_tmp28_ = self->writer;
	_tmp29_ = g_strdup ("class");
	_tmp30_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_body);
	_tmp31_ = g_new0 (gchar*, 2 + 1);
	_tmp31_[0] = _tmp29_;
	_tmp31_[1] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp28_, "div", _tmp32_, (gint) 2);
	_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
}

void
valadoc_html_basic_doclet_write_file_footer (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlMarkupWriter* _tmp1_;
	ValadocHtmlMarkupWriter* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValadocHtmlMarkupWriter* _tmp7_;
	ValadocHtmlMarkupWriter* _tmp8_;
	ValadocHtmlMarkupWriter* _tmp9_;
	ValadocHtmlMarkupWriter* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp0_, "div");
	_tmp1_ = self->writer;
	valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp1_, "br", NULL, (gint) 0);
	_tmp2_ = self->writer;
	_tmp3_ = g_strdup ("class");
	_tmp4_ = g_strdup ("site_footer");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp2_, "div", _tmp6_, (gint) 2);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp7_, "Generated by ");
	_tmp8_ = self->writer;
	valadoc_html_markup_writer_link (_tmp8_, "https://docs.vala.dev", "<kbd>valadoc</kbd>", NULL);
	_tmp9_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp9_, "div");
	_tmp10_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp10_, "body");
	_tmp11_ = self->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "html");
}

ValadocHtmlBasicDoclet*
valadoc_html_basic_doclet_construct (GType object_type)
{
	ValadocHtmlBasicDoclet * self = NULL;
	self = (ValadocHtmlBasicDoclet*) valadoc_api_visitor_construct (object_type);
	return self;
}

static void
valadoc_html_basic_doclet_class_init (ValadocHtmlBasicDocletClass * klass,
                                      gpointer klass_data)
{
	ValadocApiNodeType* _tmp0_;
	valadoc_html_basic_doclet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocHtmlBasicDoclet_private_offset);
	((ValadocHtmlBasicDocletClass *) klass)->process = (void (*) (ValadocHtmlBasicDoclet*, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) valadoc_html_basic_doclet_real_process;
	((ValadocHtmlBasicDocletClass *) klass)->get_img_path_html = (gchar* (*) (ValadocHtmlBasicDoclet*, ValadocApiNode*, const gchar*)) valadoc_html_basic_doclet_real_get_img_path_html;
	((ValadocHtmlBasicDocletClass *) klass)->get_img_path = (gchar* (*) (ValadocHtmlBasicDoclet*, ValadocApiNode*, const gchar*)) valadoc_html_basic_doclet_real_get_img_path;
	((ValadocHtmlBasicDocletClass *) klass)->get_icon_directory = (gchar* (*) (ValadocHtmlBasicDoclet*)) valadoc_html_basic_doclet_real_get_icon_directory;
	((ValadocHtmlBasicDocletClass *) klass)->write_wiki_page = (void (*) (ValadocHtmlBasicDoclet*, ValadocWikiPage*, const gchar*, const gchar*, const gchar*, const gchar*)) valadoc_html_basic_doclet_real_write_wiki_page;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_html_basic_doclet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_html_basic_doclet_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_html_basic_doclet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY] = g_param_spec_object ("linker", "linker", "linker", VALADOC_HTML_TYPE_LINK_HELPER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", VALADOC_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY] = g_param_spec_string ("wiki-index-name", "wiki-index-name", "wiki-index-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (ValadocApiNodeType, 7);
	_tmp0_[0] = VALADOC_API_NODE_TYPE_CONSTANT;
	_tmp0_[1] = VALADOC_API_NODE_TYPE_PROPERTY;
	_tmp0_[2] = VALADOC_API_NODE_TYPE_DELEGATE;
	_tmp0_[3] = VALADOC_API_NODE_TYPE_STATIC_METHOD;
	_tmp0_[4] = VALADOC_API_NODE_TYPE_METHOD;
	_tmp0_[5] = VALADOC_API_NODE_TYPE_SIGNAL;
	_tmp0_[6] = VALADOC_API_NODE_TYPE_FIELD;
	valadoc_html_basic_doclet_inheritable_members = _tmp0_;
	valadoc_html_basic_doclet_inheritable_members_length1 = 7;
	_valadoc_html_basic_doclet_inheritable_members_size_ = valadoc_html_basic_doclet_inheritable_members_length1;
}

static void
valadoc_html_basic_doclet_valadoc_doclet_interface_init (ValadocDocletIface * iface,
                                                         gpointer iface_data)
{
	valadoc_html_basic_doclet_valadoc_doclet_parent_iface = g_type_interface_peek_parent (iface);
	iface->process = (void (*) (ValadocDoclet*, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) valadoc_html_basic_doclet_process;
}

static void
valadoc_html_basic_doclet_instance_init (ValadocHtmlBasicDoclet * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = valadoc_html_basic_doclet_get_instance_private (self);
	_tmp0_ = g_strdup ("index.valadoc");
	self->priv->_wiki_index_name = _tmp0_;
	_tmp1_ = g_strdup ("../index.html");
	self->package_list_link = _tmp1_;
	self->priv->html_id_counter = (guint) 0;
}

static void
valadoc_html_basic_doclet_finalize (GObject * obj)
{
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	_g_object_unref0 (self->priv->_linker);
	_g_object_unref0 (self->priv->_settings);
	_g_free0 (self->priv->_wiki_index_name);
	_valadoc_api_tree_unref0 (self->tree);
	_g_object_unref0 (self->_renderer);
	_valadoc_markup_writer_unref0 (self->writer);
	_g_object_unref0 (self->cssresolver);
	_g_object_unref0 (self->image_factory);
	_g_object_unref0 (self->reporter);
	_g_free0 (self->package_list_link);
	G_OBJECT_CLASS (valadoc_html_basic_doclet_parent_class)->finalize (obj);
}

static GType
valadoc_html_basic_doclet_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocHtmlBasicDocletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_html_basic_doclet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHtmlBasicDoclet), 0, (GInstanceInitFunc) valadoc_html_basic_doclet_instance_init, NULL };
	static const GInterfaceInfo valadoc_doclet_info = { (GInterfaceInitFunc) valadoc_html_basic_doclet_valadoc_doclet_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_html_basic_doclet_type_id;
	valadoc_html_basic_doclet_type_id = g_type_register_static (VALADOC_API_TYPE_VISITOR, "ValadocHtmlBasicDoclet", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (valadoc_html_basic_doclet_type_id, VALADOC_TYPE_DOCLET, &valadoc_doclet_info);
	ValadocHtmlBasicDoclet_private_offset = g_type_add_instance_private (valadoc_html_basic_doclet_type_id, sizeof (ValadocHtmlBasicDocletPrivate));
	return valadoc_html_basic_doclet_type_id;
}

GType
valadoc_html_basic_doclet_get_type (void)
{
	static volatile gsize valadoc_html_basic_doclet_type_id__once = 0;
	if (g_once_init_enter (&valadoc_html_basic_doclet_type_id__once)) {
		GType valadoc_html_basic_doclet_type_id;
		valadoc_html_basic_doclet_type_id = valadoc_html_basic_doclet_get_type_once ();
		g_once_init_leave (&valadoc_html_basic_doclet_type_id__once, valadoc_html_basic_doclet_type_id);
	}
	return valadoc_html_basic_doclet_type_id__once;
}

static void
_vala_valadoc_html_basic_doclet_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	switch (property_id) {
		case VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY:
		g_value_set_object (value, valadoc_html_basic_doclet_get_linker (self));
		break;
		case VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY:
		g_value_set_object (value, valadoc_html_basic_doclet_get_settings (self));
		break;
		case VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY:
		g_value_set_string (value, valadoc_html_basic_doclet_get_wiki_index_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_valadoc_html_basic_doclet_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	switch (property_id) {
		case VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY:
		valadoc_html_basic_doclet_set_linker (self, g_value_get_object (value));
		break;
		case VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY:
		valadoc_html_basic_doclet_set_settings (self, g_value_get_object (value));
		break;
		case VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY:
		valadoc_html_basic_doclet_set_wiki_index_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

