/* 
 * Copyright (C) 2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: drag_drop.c,v 1.2 2003/03/07 16:05:42 guenter Exp $
 *
 * drag and drop support for the main window
 */

#include <config.h>
#include <gtk/gtk.h>
#include <stdio.h>

#include "globals.h"
#include "drag_drop.h"
#include "playlist.h"

static void drag_cb (GtkWidget          *widget,
		     GdkDragContext     *context,
		     gint                x,
		     gint                y,
		     GtkSelectionData   *data,
		     guint               info,
		     guint               time) {

  gchar str[MAX_MRL_LEN];

  printf ("drag_drop: drag callback, length=%d, format=%d\n",
	  data->length, data->format);

  if (data->format == 8) {

    int len, pos;

    len = data->length;
    if (len>MAX_MRL_LEN)
      len = MAX_MRL_LEN;

    memcpy (str, data->data, len);

    str [len-2] = 0; /* eliminate \r\n */

    pos = playlist_add_mrl (str);

    playlist_play(pos);
  }

  gtk_drag_finish (context, TRUE, FALSE, time);
}

static const GtkTargetEntry target_table[] = {
        { "text/uri-list", 0, 0 },
};

void drag_drop_setup (GtkWidget *widget) {

  gtk_drag_dest_set (widget, GTK_DEST_DEFAULT_ALL,
		     target_table, 1, GDK_ACTION_COPY);

  g_signal_connect (GTK_OBJECT (widget), "drag_data_received",
		    G_CALLBACK (drag_cb), NULL);
}
