//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMTEXTUREBASE_H
#define PMTEXTUREBASE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qvaluelist.h>

#include "pmnamedobject.h"
#include "pmdeclare.h"

/**
 * Base class for all textures that can link to declares
 */
class PMTextureBase : public PMNamedObject
{
   typedef PMNamedObject Base;
public:
   /** Creates an PMTextureBase */
   PMTextureBase( );
   /** Deletes the object */
   virtual ~PMTextureBase( );
   
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   
   /** */
   virtual void restoreMemento( PMMemento* s );

   /** The object has to append all declare types the object can link to. */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const = 0;
   /** Returns true if the object can insert a link objects of type t */
   bool canLinkTo( PMDeclare::PMDeclareType t ) const;
   /** Returns true if the object can insert a link to the object obj */
   bool canLinkTo( const PMDeclare* decl ) const
   {
      return canLinkTo( decl->declareType( ) );
   }
   
   /** */
   virtual PMDeclare* linkedObject( ) const { return m_pLinkedObject; }
   /** Sets the linked object. Returns true if successful */
   bool setLinkedObject( PMDeclare* o );
private:
   /** IDs for @ref PMMementoData */
   enum PMTextureBaseMementoID { PMLinkedObjectID };
   PMDeclare* m_pLinkedObject;
};


#endif
