/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmtexturebase.h"
#include "pmdeclare.h"
#include "pmpart.h"
#include "pmsymboltable.h"
#include "pmtexturebaseedit.h"
#include "pmparser.h"

#include "pmmemento.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>


PMTextureBase::PMTextureBase( )
      : Base( )
{
   m_pLinkedObject = 0;
}

PMTextureBase::~PMTextureBase( )
{
}

bool PMTextureBase::isA( PMObjectType t ) const
{
   if( t == PMTTextureBase )
      return true;
   return Base::isA( t );
}

bool PMTextureBase::setLinkedObject( PMDeclare* obj )
{
   if( obj )
   {
      if( canLinkTo( obj ) )
      {
         if( m_pLinkedObject != obj )
         {
            if( m_pMemento )
            {
               m_pMemento->addData( PMTTextureBase, PMLinkedObjectID,
                                    m_pLinkedObject );
               m_pMemento->setViewStructureChanged( );
            }
            
            if( m_pLinkedObject )
            {
               m_pLinkedObject->removeLinkedObject( this );
               if( m_pMemento )
                  m_pMemento->addChangedObject( m_pLinkedObject, PMCData );
            }
            m_pLinkedObject = obj;
            m_pLinkedObject->addLinkedObject( this );
            if( m_pMemento )
               m_pMemento->addChangedObject( m_pLinkedObject, PMCData );
         }
         return true;
      }
   }
   else
   {
      if( m_pLinkedObject != 0 )
      {
         if( m_pMemento )
         {
            m_pMemento->addData( PMTTextureBase, PMLinkedObjectID,
                                 m_pLinkedObject );
            m_pMemento->addChangedObject( m_pLinkedObject, PMCData );
         }
         m_pLinkedObject->removeLinkedObject( this );
         m_pLinkedObject = 0;
      }
      return true;
   }
   return false;
}

bool PMTextureBase::canLinkTo( PMDeclare::PMDeclareType t ) const
{
   return ( linkPossibilities( ).findIndex( t ) >= 0 );
}

void PMTextureBase::serialize( PMOutputDevice& dev ) const
{
   serializeName( dev );
   
   if( m_pLinkedObject)
   {
      if( m_pLinkedObject->firstChild( ) )
         dev.writeLine( m_pLinkedObject->id( ) );
      else
      {
         QString text;
         text = name( );
         if( text.isEmpty( ) )
            text = description( );
         
         dev.writeComment( QString( "No prototype for %1" ).arg( text ) );
      }
   }
   
   Base::serialize( dev );
}

void PMTextureBase::serialize( QDomElement& e, QDomDocument& doc ) const
{
   if( m_pLinkedObject )
      e.setAttribute( "prototype", m_pLinkedObject->id( ) );
   Base::serialize( e, doc );
}

void PMTextureBase::readAttributes( const PMXMLHelper& h )
{
   QString id = h.stringAttribute( "prototype", "" );
   if( !id.isEmpty( ) )
   {
      PMDeclare* link = h.parser( )->checkLink( id );
      if( link )
      {
         if( canLinkTo( link ) )
         {
            m_pLinkedObject = link;
            m_pLinkedObject->addLinkedObject( this );
         }
         else
            h.parser( )->printError( i18n( "Declare \"%1\" has wrong type." )
                                     .arg( id ) );
      }
   }
}

void PMTextureBase::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTTextureBase )
      {
         switch( data->valueID( ) )
         {
            case PMLinkedObjectID:
               setLinkedObject( ( PMDeclare* ) data->objectData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMTextureBase::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
