namespace Binge.Parsers
{
	using System;
	using System.Collections;
	using System.Xml;
	using Binge.Bits;

	public class XmlAnnotationParser: Parser
	{
		public XmlAnnotationParser (): base () {}
		public XmlAnnotationParser (string file): base (file) {}
		public XmlAnnotationParser (string file, Hashtable ns): base (file, ns) {}

		public override void Parse ()
		{
		}

		Namespace ParseNamespace ()
		{
			return new Namespace ();
		}

		Binge.Bits.Attribute ParseAttribute ()
		{
			return new Binge.Bits.Attribute ();
		}

		Interface ParseInterface ()
		{
			return new Interface ();
		}

		Binge.Bits.Enum ParseEnum ()
		{
			return new Binge.Bits.Enum ();
		}

		EnumItem ParseEnumItem ()
		{
			return new EnumItem ();
		}

		Class ParseClass ()
		{
			return new Class ();
		}

		Property ParseProperty ()
		{
			return new Property ();
		}

		Constructor ParseConstructor ()
		{
			return new Constructor ();
		}

		Destructor ParseDestructor ()
		{
			return new Destructor ();
		}

		Method ParseMethod ()
		{
			return new Method ();
		}

		Parameter ParseParameter ()
		{
			return new Parameter ();
		}
	}
}
