/***************************************************************************
                            KJavaProcess.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KJAVAPROCESS_H
#define KJAVAPROCESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

@interface KJavaProcess : QObject 

/** 
 Creates a process object, the process is NOT invoked at this point.
 You should first set the process's parameters, and then call startJava.
     
*/
- init;
- (void) dealloc;

/** 
 Invoke the JVM with the parameters that have been set.  The Java process
 will start after this call.
     
*/
- (BOOL) startJava;

/** 
 Stop the JVM (if it's running).
     
*/
- stopJava;

/** 
 Returns the status of the java Process- true if it's ok, false if it has died.
 It calls -[KProcess isRunning]
     
*/
- (BOOL) isRunning;

/** 
 Used to specify the path to the Java executable to be run.
     
*/
- setJVMPath: (NSString *)path;

/** 
 This will set the classpath the Java process will use.  It's used as a the
 -cp command line option.  It adds every jar file stored in $KDEDIRS/share/apps/kjava/
 to the classpath, and then adds the $CLASSPATH environmental variable.  This allows
 users to simply drop the JSSE (Java Secure Sockets Extension classes into that directory
 without having to modify the jvm configuration files.
     
*/
- setClasspath: (NSString *)classpath;

/** 
 Set a property on the java command line as -Dname=value, or -Dname if value is -[QString null].
 For example, you could call setSystemProperty( "kjas.debug", "" ) to set the kjas.debug property.
     
*/
- setSystemProperty: (NSString *)name value: (NSString *)value;

/** 
 The class to be called when -startJava is called.
     
*/
- setMainClass: (NSString *)clazzName;

/** 
 Extra flags passed to the JVM.
     
*/
- setExtraArgs: (NSString *)args;

/** 
 Arguments passed to the main class.  They will be very last in the java
 command line, after the main class.
     
*/
- setClassArgs: (NSString *)classArgs;

/** 
 Sends a command to the KJAS Applet Server by building a QByteArray
 out of the data, and then writes it standard out.
     
*/
- send: (char)cmd_code args: (NSArray *)args;

/** 
 Sends a command to the KJAS Applet Server by building a QByteArray
 out of the data, and then writes it standard out.  It adds each QString
 in the arg list, and then adds the data array.
     
*/
- send: (char)cmd_code args: (NSArray *)args data: (QByteArray*)data;
- (BOOL) invokeJVM;
- killJVM;
- (QByteArray*) addArgs: (char)cmd_code args: (NSArray *)args;
- popBuffer;
- sendBuffer: (QByteArray*)buff;
- storeSize: (QByteArray*)buff;

/** 
 This slot is called whenever something is written to stdin of the process.
 It's called again to make sure we keep emptying out the buffer that contains
 the messages we need send.
     
*/
- slotWroteData;

/** 
 This slot is called when the Java Process writes to standard out.  We then
 process the data from the file descriptor that is passed to us and send the
 command to the AppletServer
     
*/
- slotReceivedData: (int)arg1 int: (int)arg2;
@end

/** Override these methods in subclasses of KJavaProcess to customise event handling behaviour */
@protocol KJavaProcessEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
