/***************************************************************************
                            kde_KPopupMenu.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPOPUPMENU
#define KDE_KPOPUPMENU

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 KPopupMenu is a class for menus with standard title items and keyboard
 accessibility for popups with many options and/or varying options. It acts
 identically to QPopupMenu, with the addition of insertTitle(),
 changeTitle(), setKeyboardShortcutsEnabled() and
 setKeyboardShortcutsExecute() methods.

 The titles support a text string, an icon, plus user defined gradients,
 colors, and background pixmaps.

 The keyboard search algorithm is incremental with additional underlining
 for user feedback.

 @author Hamish Rodda <meddie@yoyo.its.monash.edu.au>
 
 @short A menu with title items.

*/

/** *
 Constructs a KPopupMenu.
     
*/
kde_KPopupMenu * kde_new_KPopupMenu(qt_QWidget * parent, char* name);

/** *
 Destructs the object
     
*/
void kde_del_KPopupMenu( kde_KPopupMenu* p );

/** *
 Inserts a title item with no icon.
     
*/
int kde_KPopupMenu_insertTitle(kde_KPopupMenu* instPointer,qt_QString * text, int identifier, int index);

/** *
 Inserts a title item with the given icon and title.
     
*/
int kde_KPopupMenu_insertTitle1(kde_KPopupMenu* instPointer,qt_QPixmap * icon, qt_QString * text, int identifier, int index);

/** *
 Changes the title of the item at the specified id. If a icon was
 previously set it is cleared.
     
*/
void kde_KPopupMenu_changeTitle(kde_KPopupMenu* instPointer,int identifier, qt_QString * text);

/** *
 Changes the title and icon of the title item at the specified id.
     
*/
void kde_KPopupMenu_changeTitle1(kde_KPopupMenu* instPointer,int identifier, qt_QPixmap * icon, qt_QString * text);

/** *
 Returns the title of the title item at the specified id. The default
 id of -1 is for backwards compatibility only, you should always specify
 the id.
     
*/
qt_QString * kde_KPopupMenu_title(kde_KPopupMenu* instPointer,int identifier);

/** *
 Returns the icon of the title item at the specified id.
     
*/
qt_QPixmap * kde_KPopupMenu_titlePixmap(kde_KPopupMenu* instPointer,int identifier);

/** *
 Enables keyboard navigation by searching for the entered key sequence.
 Also underlines the currently selected item, providing feedback on the search.

 Defaults to off.

 WARNING: calls to text() of currently keyboard-selected items will
 contain additional ampersand characters.

 WARNING: though pre-existing keyboard shortcuts will not interfere with the
 operation of this feature, they may be confusing to the user as the existing
 shortcuts will not work.

*/
void kde_KPopupMenu_setKeyboardShortcutsEnabled(kde_KPopupMenu* instPointer,int enable);

/** *
 Enables execution of the menu item once it is uniquely specified.
 Defaults to off.

*/
void kde_KPopupMenu_setKeyboardShortcutsExecute(kde_KPopupMenu* instPointer,int enable);

/** *
 Obsolete method provided for backwards compatibility only. Use the
 normal constructor and insertTitle instead.
     
*/
kde_KPopupMenu * kde_new_KPopupMenu1(qt_QString * title, qt_QWidget * parent, char* name);

/** *
 Obsolete method provided for backwards compatibility only. Use
 insertTitle and changeTitle instead.
     
*/
void kde_KPopupMenu_setTitle(kde_KPopupMenu* instPointer,qt_QString * title);
void kde_KPopupMenu_virtual_hook(kde_KPopupMenu* instPointer,int identifier, void* data);
qt_QString * kde_KPopupMenu_underlineText(kde_KPopupMenu* instPointer,qt_QString * text, unsigned int length);
void kde_KPopupMenu_resetKeyboardVars(kde_KPopupMenu* instPointer,int noMatches);

#endif
