/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rcsid[]="@(#)$Id: ypset.c,v 1.3 1994/01/02 21:59:08 root Exp $";
/*
 *	$Author: root $
 *	$Log: ypset.c,v $
 * Revision 1.3  1994/01/02  21:59:08  root
 * Strict prototypes
 *
 * Revision 1.2  1994/01/02  20:10:08  root
 * Added GPL notice
 *
 * Revision 1.1  1993/06/15  22:52:42  root
 * Initial revision
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rpc/rpc.h>
#include <rpcsvc/yp.h>

static void
Usage( void)
{
	fprintf(stderr, "Usage: ypset [-d domain] host\n");
	exit(1);
}

extern int optind;
extern char *optarg;

void
main(int argc, char **argv)
{
	char dom[65];
	char *d, *h;
	struct in_addr addr;
	struct ypbind_setdom y;
	CLIENT *udpClient;
	struct sockaddr_in localHost;
	struct timeval tout;
	enum clnt_stat rpcstat;
	int s;

	getdomainname(dom, sizeof dom);

	d=dom;
	while(1) {
		int c=getopt(argc, argv, "d:");
		if (c==EOF) break;
		d=optarg;
	}
	argc-=optind;
	argv+=optind;

	h=argv[0];
	if (!h) Usage();

	if (isdigit(*h)) {
		addr.s_addr=inet_addr(h);
	} else {
		struct hostent *he=gethostbyname(h);
		if (!he) {
			fprintf(stderr, "%s: No such host\n", h);
			exit(1);
		}
		addr=*(struct in_addr *)(he->h_addr);
	}

	y.ypsetdom_domain=d;
	(*(struct in_addr *)(y.ypsetdom_binding.ypbind_binding_addr))=addr;
	(*(short *)(y.ypsetdom_binding.ypbind_binding_port))=0;
 
	memset(&localHost, '\0', sizeof localHost);
	localHost.sin_family=AF_INET;
	localHost.sin_addr.s_addr=htonl(INADDR_LOOPBACK);
	tout.tv_sec=25; tout.tv_usec=0;
	s=RPC_ANYSOCK;

	udpClient=clntudp_create(&localHost, YPBINDPROG, YPBINDVERS, tout, &s);
	if (udpClient==NULL) {
		clnt_pcreateerror("udpClient");
		exit(1);
	}

	tout.tv_sec=5; tout.tv_usec=0;
	rpcstat=clnt_call(udpClient, YPBINDPROC_SETDOM, xdr_ypbind_setdom, &y,
		xdr_void, NULL, tout);
	if (rpcstat!=RPC_SUCCESS) {
		clnt_perror(udpClient, "clnt_call");
		exit(1);
	}
	exit (0);
}
