/*******************************************************************
*                                                                  *
*             This software is part of the ast package             *
*                Copyright (c) 1999-2001 AT&T Corp.                *
*        and it may only be used by you under license from         *
*                       AT&T Corp. ("AT&T")                        *
*         A copy of the Source Code Agreement is available         *
*                at the AT&T Internet web site URL                 *
*                                                                  *
*       http://www.research.att.com/sw/license/ast-open.html       *
*                                                                  *
*        If you have copied this software without agreeing         *
*        to the terms of the license you are infringing on         *
*           the license and copyright and are violating            *
*               AT&T's intellectual property rights.               *
*                                                                  *
*                 This software was created by the                 *
*                 Network Services Research Center                 *
*                        AT&T Labs Research                        *
*                         Florham Park NJ                          *
*                                                                  *
*               Glenn Fowler <gsf@research.att.com>                *
*******************************************************************/
#include	"sftest.h"

MAIN()
{
	Sfio_t	*str, *fr, *fw, *sf[2];
	int	c;
	int	fd[2];

	if(!(str = sfopen(NIL(Sfio_t*),"abc","s")) )
		terror("Opening string stream\n");

	if(pipe(fd) < 0)
		terror("pipe failed\n");

	if(!(fr = sfnew(NIL(Sfio_t*),NIL(Void_t*),(size_t)SF_UNBOUND,
			 fd[0],SF_READ)) )
		terror("Opening read pipe stream\n");
	if(!(fw = sfnew(NIL(Sfio_t*),NIL(Void_t*),(size_t)SF_UNBOUND,
			 fd[1],SF_WRITE)) )
		terror("Opening write pipe stream\n");

	sf[0] = fr;
	sf[1] = str;
	if((c = sfpoll(sf,2,0)) != 1 || sf[0] != str)
		terror("Only str should be available c=%d\n",c);

	sf[0] = fr;
	if(sfpoll(sf,1,0) != 0 )
		terror("Pipe stream should not be ready\n");

	sfputc(fw,'a'); sfsync(fw);
	sf[0] = fr;
	if(sfpoll(sf,1,0) != 1 )
		terror("Pipe read should be ready\n");
	if((c = sfgetc(fr)) != 'a')
		terror("Didn't get back right data\n");

	sf[0] = fr;
	sf[1] = str;
	if(sfpoll(sf,2,0) != 1 || sf[0] != str)
		terror("Only str should be available2\n");

	sf[0] = fw;
	sf[1] = str;
	if(sfpoll(sf,2,0) != 2)
		terror("Both str&pipe write should be available\n");

	sfgetc(str); sfgetc(str); sfgetc(str);
	sfstack(fr,str);

	if(sfpoll(&fr,1,0) != 0)
		terror("Nothing should be available\n");

	if(pipe(fd) < 0)
		terror("Can't create pipe\n");

	if(!(fr = sfnew(fr,NIL(Void_t*),SF_UNBOUND,fd[0],SF_READ)) )
		terror("Can't create stream\n");

	if(write(fd[1],"0123456789",10) != 10)
		terror("Can't write to pipe\n");

	if(sfpoll(&fr,1,1000) != 1)
		terror("Data should be available\n");

	TSTEXIT(0);
}
