/*
 * $Id: os_vms.h,v 1.6 1996/03/15 07:41:11 hubert Exp $
 *
 * Program:	Operating system dependent routines - VMS 5.n
 *
 *
 * Yehavi Bourvine
 * Hebrew University of Jeruselem
 * +972-2-585684
 * YEHAVI@vms.huji.ac.il
 *
 * Please address all bugs and comments to "pine-bugs@cac.washington.edu"
 *
 *
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 */

#ifndef	OSDEP_H
#define	OSDEP_H

#include	<string.h>

#undef	CTRL
#include	<signal.h>

#include	<ctype.h>
#include	<types.h>

#include	<stat.h>

/*
 * type qsort() expects
 */
#define	QSType	  int
#define QcompType void

/*
 * File name separator, as a char and string
 */
#define	C_FILESEP	'/'
#define	S_FILESEP	""

/*
 * Place where mail gets delivered (for pico's new mail checking)
 */
#define	MAILDIR		"SYS$LOGIN:"


/*
 * What and where the tool that checks spelling is located.  If this is
 * undefined, then the spelling checker is not compiled into pico.
 */
#define SPELLER         "$ SPELL"

/* memcpy() is no good for overlapping blocks.  If that's a problem, use
 * the memmove() in ../c-client
 */
#define bcopy(a,b,s) memmove (b, a, s)

#ifdef	0
/* now defined in pico.h and edef.h */
typedef struct  KBSTREE {
	char	value;
        int     func;              /* Routine to handle it         */
	struct	KBSTREE *down; 
	struct	KBSTREE	*left;
} KBESC_T;

extern KBESC_T *pico_kbesc;
extern int kbseq();
#endif	/* no longer needed */


extern char *getcwd(char *, int);

#ifdef ANSI_DRIVER
#define	NROW	24
#define	NCOL	80
#endif

#define ttputc __ttputc

/*
 * Mode passed chmod() to make tmp files exclusively user read/write-able
 */
#define	MODE_READONLY	(0600)

#endif	/* OSDEP_H */
