/*
 * seejpeg.c
 *
 * Copyright (C) 1993-1996 Evan Harris
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

/* 	$Id: seejpeg.c,v 1.5 1996/11/01 19:14:33 evan Exp $	 */

#ifndef lint
static char vcid[] = "$Id: seejpeg.c,v 1.5 1996/11/01 19:14:33 evan Exp $";
#endif /* lint */

#include "seejpeg.h"
#include <string.h>
#include <getopt.h>
#include <vga.h>
#include <sys/times.h>

#define VERSION "seejpeg version 1.6.1"

int opt_greyscale = 0, opt_quantize = 0, opt_verbose = 0, opt_widthonly = 0;
int opt_onepass = 0, opt_forcemode = TEXT, opt_doublex = 0, opt_doubley = 0;
int opt_slideshow = -1, opt_cycle = 0, opt_centre = 0, opt_randomise = 0;
double opt_fuzz = 1.0, opt_gamma = 1.0;

int go_backwards = 0;


int
main(int argc, char **argv)
{
    int c, arg, arg2, num_args, err = 0;
    short *args, t;
    char *errstr = NULL, *forcemodestr = NULL;
    char *ch;
  
    while ((c = getopt(argc, argv, "1cd:f:gqrs:vwCF:G:")) != -1)
    {
	switch (c)
	{
	  case '1':
	    opt_onepass = 1;
	    break;
	  case 'c':
	    opt_centre = 1;
	    break;
	  case 'd':
	    for (ch = optarg; *ch != '\0'; ch++)
	    {
		switch (*ch)
		{
		  case 'x':
		    opt_doublex = 1;
		    break;
		  case 'y':
		    opt_doubley = 1;
		    errstr = "doubling in Y direction not yet fully implemented";
		    break;
		  default:
		    errstr = "can only double image in x or y direction";
		    break;
		}
	    }
	    break;
	  case 'f':
	    opt_fuzz = atof(optarg);
	    if (opt_fuzz < 0.5 || opt_fuzz > 1.0)
	    {
		errstr = "fuzz factor must be in range [0.5,1.0]";
	    }
	    break;
	  case 'g':
	    opt_greyscale = 1;
	    break;
	  case 'q':
	    opt_quantize = 1;
	    break;
	  case 'r':
	    opt_randomise = 1;
	    break;
	  case 'v':
	    opt_verbose = 1;
	    break;
	  case 'w':
	    opt_widthonly = 1;
	    break;
	  case 'C':
	    opt_cycle = 1;
	    break;
	  case 'F':
	    forcemodestr = optarg;
	    break;
	  case 'G':
	    opt_gamma = atof(optarg);
	    if (opt_gamma < 0.1 || opt_gamma > 5.0)
	    {
		errstr = "gamma correction must be in range [0.1, 5.0]";
	    }
	    break;
	  case 's':
	    opt_slideshow = atoi(optarg);
	    if (opt_slideshow < -1)
	    {
		errstr = "slideshow waiting time must not be negative";
	    }
	    break;
	  case '?':
	    err++;
	    break;
	}
    }
  
    if (!opt_verbose)
    {
	vga_disabledriverreport();
    }

    vga_init();

    if (errstr != NULL)
    {
	fprintf(stderr, "Error: %s\n", errstr);
	exit(1);
    }

    if (forcemodestr != NULL)
    {
	opt_forcemode = vga_getmodenumber(forcemodestr);
	switch (opt_forcemode)
	{
	  case G1280x1024x256:
	  case G1024x768x256:
	  case G800x600x256:
	  case G640x480x256:
	  case G320x200x256:
	    opt_quantize = 1;
	    break;
	  case G1280x1024x16M:
	  case G1024x768x16M:
	  case G800x600x16M:
	  case G640x480x16M:
	  case G320x200x16M:
	  case G1280x1024x32K:
	  case G1024x768x32K:
	  case G800x600x32K:
	  case G640x480x32K:
	  case G320x200x32K:
	    break;
	  default:
	    fprintf(stderr, "Error: unknown/unsupported mode name '%s'\n",
		    forcemodestr);
	    break;
	}
    }

    if (err || argc - optind == 0)
    {
	fprintf(stderr, VERSION"\n");
	fprintf(stderr,
		"Usage: %s [-1cgqrvwC] [-dx] [-f fuzz] [-s time] [-F mode] [-G gamma] {file} ...\n",
		argv[0]);
	fprintf(stderr, "\t-1   one pass quantization (-q implicit)\n");
	fprintf(stderr,
		"\t-c   centre the image if it is smaller than video mode\n");
	fprintf(stderr, "\t-dx  double the image in the x direction\n");
	fprintf(stderr, "\t-f   set fuzz factor to determine video mode\n");
	fprintf(stderr, "\t-g   force greyscale mode (-1 implicit)\n");
	fprintf(stderr, "\t-q   quantize picture (256 colour mode)\n");
	fprintf(stderr, "\t-r   randomise order of images\n");
	fprintf(stderr,
		"\t-s   slideshow, wait {time} seconds between images\n");
	fprintf(stderr, "\t-v   verbose\n");
	fprintf(stderr, "\t-w   only use width to determine video mode\n");
	fprintf(stderr, "\t-C   cycle through pictures\n");
	fprintf(stderr, "\t-F   force the use of {mode} video mode\n");
	fprintf(stderr, "\t-G   specify monitor gamma correction value\n");
	fprintf(stderr, "File types supported: JPEG, GIF, PPM, BMP, TARGA\n");
	exit(1);
    }

    num_args = argc - optind;
    args = malloc(num_args * sizeof(short));
    if (args != NULL)
    {
	for (arg = 0; arg < num_args; arg++)
	{
	    args[arg] = optind + arg;
	}
    }
    
    if (opt_randomise)
    {
	srand48(times(NULL));
    }

    chiptype_init();
    gamma_table_init(opt_gamma);
    do
    {
	if (opt_randomise)
	{
	    for (arg = 0; arg < num_args; arg++)
	    {
		args[arg] = optind + arg;
	    }
	    for (arg = 0; arg < num_args; arg++)
	    {
		arg2 = lrand48() % num_args;
		t = args[arg];
		args[arg] = args[arg2];
		args[arg2] = t;
	    }
	}

	for (arg = 0; arg < num_args; arg++)
	{
	    if (opt_verbose)
	    {
		printf("File   : %s\n", argv[args[arg]]);
	    }
	    err = read_image_file(argv[args[arg]]);
	    if (opt_verbose)
	    {
		if (err != 1)
		{
		    printf("Error reading image\n");
		} 
	    }
	    if (go_backwards)
	    {
		arg -= (arg > 0 ? 2 : 1);
		go_backwards = 0;
	    }
	}
    }
    while (opt_cycle);
    display_shutdown();

    free(args);

    return EXIT_SUCCESS;
}
